      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       IDENTIFICATION DIVISION. 
       CLASS-ID. CobLogging AS "CobLogging" INHERITS DYNAMICISAM.
       
       CONFIGURATION SECTION.
       REPOSITORY.
           CLASS JINT            AS "int"
           CLASS JLONG           AS "long"
           CLASS JSTRING         AS "java.lang.String" 
           CLASS JBOOL           AS "boolean"
           CLASS JBYTEARRAY      AS "byte[]"
           CLASS DYNAMICFILE     AS "com.iscobol.rts.DynamicFile"
           CLASS KEYDESCRIPTIONS AS "com.iscobol.rts.KeyDescription[]"
           >> IF ISAM_CTREE IS DEFINED
              CLASS DYNAMICISAM    AS "com.iscobol.io.DynamicCtreeJ"
           >> ELSE 
              CLASS DYNAMICISAM    AS "com.iscobol.io.DynamicJIsam"
           >> END-IF
           .

       IDENTIFICATION DIVISION.
       OBJECT.

       WORKING-STORAGE SECTION.
       77  ISAM-NAME   PIC X(128).
       77  ISAM-OP     PIC X(5).

       PROCEDURE DIVISION.
************************************************************************
       IDENTIFICATION DIVISION.
       METHOD-ID. MY-OPEN AS "open" OVERRIDE.
       WORKING-STORAGE SECTION.
       77  RESULT      OBJECT REFERENCE JINT. 
       LINKAGE SECTION.
       77  PATH        OBJECT REFERENCE JSTRING.
       77  OPENTYPE    OBJECT REFERENCE JINT.
       77  LOCKTYPE    OBJECT REFERENCE JINT.
       77  KEYS        OBJECT REFERENCE KEYDESCRIPTIONS.
       77  MAXREC      OBJECT REFERENCE JINT.
       77  MINREC      OBJECT REFERENCE JINT.
       77  NKEYS       OBJECT REFERENCE JINT.
       77  ACCESSMODE  OBJECT REFERENCE JINT.
       77  OPTIONL     OBJECT REFERENCE "boolean".
       77  ASSIGNEXT   OBJECT REFERENCE "boolean".
       PROCEDURE DIVISION USING PATH, 
                                OPENTYPE, 
                                LOCKTYPE, 
                                KEYS, 
                                MAXREC, 
                                MINREC, 
                                NKEYS, 
                                ACCESSMODE,
                                OPTIONL,
                                ASSIGNEXT
                      RETURNING RESULT.
       MAIN.      
      *Logging action - start  
           SET ISAM-NAME TO PATH.
           MOVE "Open" TO ISAM-OP.
           SELF:>write_log().  
      *Logging action - end      
           SET RESULT TO SUPER:>open(PATH, 
                                     OPENTYPE, 
                                     LOCKTYPE, 
                                     KEYS, 
                                     MAXREC, 
                                     MINREC, 
                                     NKEYS, 
                                     ACCESSMODE,
                                     OPTIONL,
                                     ASSIGNEXT). 
           GOBACK.
       END METHOD.
************************************************************************
       IDENTIFICATION DIVISION.
       METHOD-ID. MY-CLOSE AS "close" OVERRIDE.
       WORKING-STORAGE SECTION.
       77  RESULT OBJECT REFERENCE JINT.
       PROCEDURE DIVISION RETURNING RESULT.
       MAIN.
      *Logging action - start
           MOVE "Close" TO ISAM-OP.
           SELF:>write_log().
      *Logging action - end
           SET RESULT TO SUPER:>close().
           GOBACK.
       END METHOD. 
************************************************************************  
       IDENTIFICATION DIVISION.
       METHOD-ID. MY-WRITE AS "write" OVERRIDE.
       WORKING-STORAGE SECTION.
       77  RESULT OBJECT REFERENCE JLONG.
       LINKAGE SECTION.
       77  THERECORD  OBJECT REFERENCE JBYTEARRAY.
       77  OFFS       OBJECT REFERENCE JINT.  
       77  RECSIZE    OBJECT REFERENCE JINT.     
       77  FLAGLOCK   OBJECT REFERENCE JBOOL.
       PROCEDURE DIVISION USING THERECORD,
                                OFFS,
                                RECSIZE,
                                FLAGLOCK
                      RETURNING RESULT.
       MAIN.       
      *Logging action - start
           MOVE "Write" TO ISAM-OP.
           SELF:>write_log().
      *Logging action - end
           SET RESULT TO SUPER:>write(THERECORD,
                                      OFFS,
                                      RECSIZE,
                                      FLAGLOCK).
           GOBACK.
       END METHOD.  
************************************************************************
       IDENTIFICATION DIVISION.
       METHOD-ID. WRITE-LOG AS "write_log".
       PROCEDURE DIVISION.
       MAIN. 
           DISPLAY ISAM-OP " on " ISAM-NAME upon sysout.
           GOBACK.
       END METHOD.
************************************************************************
       END OBJECT.
************************************************************************
