
##### isCOBOL release 2025 R1 build#1145.9-20250707-40290 ######
##### Copyright (c) 2005 - 2025 Veryant. ######

----------
**This sample shows the audit feature, which builds on top of the I/O Trigger file**
**technology, and allows COBOL developers to add logging on all I/O operations without**
**source code modifications.**

**The source code of this sample is installed as part of the ISAPPLICATION sample**
**in the folder "$ISCOBOL/sample/isapplication/source/audit"**
** and "$ISCOBOL/sample/isapplication/copylib/audit"**

**This document assumes the $ISCOBOL environment variable exists and points**
**to the isCOBOL SDK installation folder.**

**When talking about a "command prompt window" it means an isCOBOL Shell**
**on the Windows OS and a standard shell on Linux/Unix**

----------
### List of sample files

 - iscobol.properties: a configuration file that associates the file IndexedFile to 
   the AuditTrigger file system

 - copylib\audit folder:
   - audit.wrk: Copy of Working-Storage Section statements, contains the audit variables
   - auditfilesettings.*: FD/SL of the file that contains the audit settings for file 
     operations
   - audit-linkage.wrk: Copy of Linkage Section for the AUDIT.cbl program
   - auditlog.*: FD/SL of the file that contains the audit information
   - auditlogsettings.*: FD/SL of the file that contains the audit settings for user 
     login/logout and the program execution information

 - resource folder: the folder used in the CLASSPATH
   - tools.png: the image used by the AUDITSETTINGS program 

 - source\audit: contains the audit programs

   - AUDIT.cbl: This program contains the audit function. Call it with with the appropriate
                op-code to execute audit function:
     - start and stop the auditlog thread program
     - pass the name of the logged user to the audit program
     - load the audit settings from the file
     - trace the user login and logout
     - trace the start and the end of a program

   - AUDITANALYSIS.cbl: A graphical program to review the audit log

   - AUDITLOG.cbl: This program writes the file's audit information into the auditlog file.
                   Call this program in a thread at the startup of your program.  
                   In a copybook called audit.cpy there is a paragraph that starts the 
                   audit thread and another paragraph that retrieves the information from 
                   the AuditTrigger program using the communication beetween threads.	

   - AUDITSETTINGS.cbl: A graphical program to configure the audit settings.
                        In the I-O Activity tab you can choose which file operation(s) to 
                        trace. Specify the name of the user as well as the name of 
                        the file. To trace all operation of a specific file click on "ALL"
                        checkbox. If you want trace the operation on all file type "ALL" 
                        into the column "table"

                        The operations you can trace are:	
                        +---------------------------+-------------------+
                        | operation                 | value stored into |
                        |                           | auditlog file     |
                        +---------------------------+-------------------+
                        | open                      | fo                |
                        | close                     | fc                |
                        | delete record             | fd                |
                        | delete file               | ff                |
                        | read (all types of reads) | fr                |
                        | write                     | fw                |
                        | rewrite                   | fx                |
                        +---------------------------+-------------------+

                        In the User Activity tab you can choose to trace login/logout and  
                        program execution information. You will specify the name of the user.
                        The operations you can trace are:
                        +---------------------------+-------------------+
                        | operation                 | value stored into |
                        |                           | auditlog file     |
                        +---------------------------+-------------------+
                        | login                     | pi                |
                        | logout                    | po                |
                        | programs start            | ps                |
                        | programs end              | pe                |
                        +---------------------------+-------------------+

   - AuditTrigger.cbl: The trigger program. This program checks the audit settings 
                       and sends the requested operation data thru a thread message to  
                       the AUDITLOG program. 

 **NOTE:**

        This COBOL program generates a lot of java classes. The classes of this kind of
        program must be placed into the CLASSPATH. The code_prefix will not work for the
        trigger programs.

----------
 - 1 Using a command prompt window go to the "$ISCOBOL/sample/isapplication" folder

 - 2 Follow the instructions in that folder's README to compile the application and audit programs, and set the CLASSPATH.

 - 3 Run the ISAPPLICATION program. Audit settings and Audit Analysis are accessible in the left-side menu.