/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.types;

import com.veryant.cobol.compiler.BuiltIn;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.memory.Chunk;
import com.veryant.cobol.compiler.memory.DataItem;
import com.veryant.cobol.compiler.memory.DynamicChunk;
import com.veryant.cobol.compiler.scope.DataItemDeclaration;
import com.veryant.cobol.compiler.types.AbstractOperand;
import com.veryant.cobol.compiler.types.IReferenceModable;
import com.veryant.cobol.compiler.types.IRoundable;
import com.veryant.cobol.compiler.types.ISubscriptable;
import com.veryant.cobol.compiler.types.NumericLiteral;
import com.veryant.cobol.converters.Binary;
import com.veryant.cobol.exceptions.COBOLCompilerException;

public class DataItemReference
extends AbstractOperand
implements ISubscriptable,
IReferenceModable,
IRoundable {
    private final DataItemDeclaration dataItemDeclaration;
    private AbstractOperand from;
    private AbstractOperand to;
    private final int subscriptsCount;
    private AbstractOperand[] subscripts;
    private DataItem[] occursHierarchy;
    private final boolean externalSubscripts;
    private boolean rounded;
    private BuiltIn modBuiltIn;

    @Override
    public int getSubscriptsCount() {
        return this.subscriptsCount;
    }

    @Override
    public void setSubscript(int n, AbstractOperand abstractOperand) {
        this.subscripts[n] = abstractOperand;
    }

    @Override
    public AbstractOperand getSubscript(int n) {
        return this.subscripts[n];
    }

    @Override
    public int getSubscriptMultiplier(int n) {
        return ((DynamicChunk)this.occursHierarchy[n].getChunk()).getSize();
    }

    @Override
    public boolean hasExternalSubscripts() {
        return this.externalSubscripts;
    }

    @Override
    public boolean hasReferenceModifier() {
        return this.modBuiltIn != null;
    }

    @Override
    public boolean hasStaticSize() {
        if (super.hasStaticSize()) {
            return !this.hasReferenceModifier() || this.hasReferenceModifier() && this.to instanceof NumericLiteral;
        }
        return false;
    }

    @Override
    public int getStaticSize() {
        if (this.hasStaticSize()) {
            if (this.hasReferenceModifier()) {
                return Binary.toInt(((NumericLiteral)this.to).getCobolBigDecimal(), 0, 0, true);
            }
            return this.getChunk().getSize();
        }
        return 0;
    }

    @Override
    public void setReferenceModifier(BuiltIn builtIn, AbstractOperand abstractOperand, AbstractOperand abstractOperand2) {
        this.modBuiltIn = builtIn;
        this.from = abstractOperand;
        this.to = abstractOperand2;
        this.getDataItem().denyPromotion();
    }

    @Override
    public AbstractOperand getFrom() {
        return this.from;
    }

    @Override
    public AbstractOperand getTo() {
        return this.to;
    }

    @Override
    public boolean isRounded() {
        return this.rounded;
    }

    @Override
    public void setRounded(boolean bl) {
        this.rounded = bl;
    }

    @Override
    public boolean matches(AbstractOperand abstractOperand) {
        if (this.getDataItem().isPromoted()) {
            return false;
        }
        if (abstractOperand instanceof DataItemReference && ((DataItemReference)abstractOperand).getDataItem().isPromoted()) {
            return false;
        }
        return super.matches(abstractOperand);
    }

    public DataItem getDataItem() {
        return this.dataItemDeclaration.getDataItem();
    }

    public DataItemDeclaration getDataItemDeclaration() {
        return this.dataItemDeclaration;
    }

    @Override
    public BuiltIn getBuiltIn() {
        if (this.hasReferenceModifier()) {
            return this.modBuiltIn;
        }
        return this.getDataItem().getBuiltIn();
    }

    @Override
    public Magnitude getMagnitude() {
        if (this.hasReferenceModifier()) {
            return null;
        }
        return this.getDataItem().getMagnitude();
    }

    @Override
    public Chunk getChunk() {
        if (this.getDataItem().isPromoted()) {
            throw new COBOLCompilerException("Internal error, memory access denied for promoted variables");
        }
        return (Chunk)this.getDataItem().getChunk();
    }

    public DataItemReference(ISourceReference iSourceReference, DataItemDeclaration dataItemDeclaration) {
        this(iSourceReference, dataItemDeclaration, false, false);
    }

    public DataItemReference(ISourceReference iSourceReference, DataItemDeclaration dataItemDeclaration, boolean bl) {
        this(iSourceReference, dataItemDeclaration, bl, false);
    }

    public DataItemReference(ISourceReference iSourceReference, DataItemDeclaration dataItemDeclaration, boolean bl, boolean bl2) {
        super(iSourceReference);
        this.dataItemDeclaration = dataItemDeclaration;
        if (!bl) {
            this.dataItemDeclaration.markAsUsed();
        }
        DataItem dataItem = dataItemDeclaration.getDataItem();
        if (this.getMagnitude() != null && this.getMagnitude().getDigits() > 18) {
            dataItem.denyPromotion();
        }
        this.subscriptsCount = dataItem.getOccursRank();
        if (this.subscriptsCount > 0) {
            dataItem.denyPromotion();
            this.subscripts = new AbstractOperand[this.subscriptsCount];
            this.occursHierarchy = new DataItem[this.subscriptsCount];
            DataItem dataItem2 = dataItem.isOccurs() ? dataItem : dataItem.getParentOccurs();
            for (int i = this.subscriptsCount - 1; i >= 0; --i) {
                this.occursHierarchy[i] = dataItem2;
                dataItem2 = dataItem2.getParentOccurs();
            }
        }
        this.externalSubscripts = bl2;
    }

    public String toString() {
        return this.getDataItem().toString();
    }
}

