/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast.statements;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstSymbol;
import com.veryant.cobol.compiler.ast.common.AstFileReference;
import com.veryant.cobol.compiler.ast.common.AstSharing;
import com.veryant.cobol.compiler.ast.statements.AstAbstractFileIOStatement;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.scope.FileDeclaration;
import com.veryant.cobol.compiler.stmts.Open;

public class AstOpenStatement
extends AstAbstractFileIOStatement {
    public AstOpenStatement(Collector collector, Token token) {
        super(collector, token);
    }

    @Override
    public void walk() {
        Open.OpenMode openMode = null;
        Open.SharingMode sharingMode = Open.SharingMode.None;
        Open open = null;
        for (AstNode astNode : this.getChildren()) {
            if (astNode instanceof AstSymbol) {
                switch (astNode.getToken().kind) {
                    case 398: {
                        openMode = Open.OpenMode.Input;
                        break;
                    }
                    case 524: {
                        openMode = Open.OpenMode.Output;
                        break;
                    }
                    case 374: {
                        openMode = Open.OpenMode.IO;
                        break;
                    }
                    case 319: {
                        openMode = Open.OpenMode.Extend;
                    }
                }
                continue;
            }
            if (astNode instanceof AstSharing) {
                switch (((AstNode)astNode.getChild((int)0)).getToken().kind) {
                    case 18: {
                        sharingMode = Open.SharingMode.WithAllOther;
                        break;
                    }
                    case 485: {
                        sharingMode = Open.SharingMode.WithNoOther;
                        break;
                    }
                    case 582: {
                        sharingMode = Open.SharingMode.WithReadOnly;
                    }
                }
                continue;
            }
            if (!(astNode instanceof AstFileReference)) continue;
            AstFileReference astFileReference = (AstFileReference)astNode;
            open = new Open(this.getToken());
            this.getCode().addStatement(open);
            FileDeclaration.AccessMode accessMode = astFileReference.getFile().getAccessMode();
            switch (openMode) {
                case Input: {
                    break;
                }
                case Output: {
                    break;
                }
                case IO: {
                    break;
                }
                case Extend: {
                    if (accessMode == FileDeclaration.AccessMode.Sequential) break;
                    this.consoleWrite(76, this.getToken(), new Object[0]);
                }
            }
            switch (astFileReference.getFile().getAccessMode()) {
                case Sequential: {
                    break;
                }
                case Random: {
                    break;
                }
            }
            open.getData().setOpenMode(openMode);
            open.getData().setSharingMode(sharingMode);
            open.getData().setFile(astFileReference.getFile());
            open.getData().getFile().setNeedsClose(true);
            block27: for (AstSymbol astSymbol : (AstSymbol[])astFileReference.findChildren(AstSymbol.class)) {
                switch (astSymbol.getToken().kind) {
                    case 627: {
                        open.getData().setReversed(true);
                        continue block27;
                    }
                    case 485: {
                        open.getData().setWithNoRewind(true);
                        continue block27;
                    }
                    case 450: {
                        open.getData().setWithLock(true);
                    }
                }
            }
        }
    }
}

