/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast.statements;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.Section;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstSection;
import com.veryant.cobol.compiler.ast.common.AstGiving;
import com.veryant.cobol.compiler.ast.statements.AstPerformStatement;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.stmts.AbstractStatement;
import com.veryant.cobol.compiler.stmts.Exit;
import com.veryant.cobol.compiler.stmts.Go;
import com.veryant.cobol.compiler.types.AbstractOperand;

public class AstExitStatement
extends AstNode {
    private Section section;
    private Exit.ExitTypes exitType = Exit.ExitTypes.Exit;
    private AbstractOperand exitCode;
    private Exit exit = null;

    public AstExitStatement(Collector collector, Token token) {
        super(collector, token);
    }

    @Override
    public void validate() {
        this.exitType = Exit.ExitTypes.Exit;
        block7: for (AstNode astNode : this.getChildren()) {
            switch (astNode.getToken().kind) {
                case 536: {
                    this.exitType = Exit.ExitTypes.ExitPerform;
                    AstPerformStatement astPerformStatement = this.findParent(AstPerformStatement.class);
                    if (astPerformStatement != null) continue block7;
                    this.consoleWrite(24, this.getToken(), new Object[0]);
                    continue block7;
                }
                case 190: {
                    this.exitType = Exit.ExitTypes.ExitPerformCycle;
                    continue block7;
                }
                case 532: {
                    this.exitType = Exit.ExitTypes.ExitParagraph;
                    continue block7;
                }
                case 649: {
                    this.exitType = Exit.ExitTypes.ExitSection;
                    AstSection astSection = this.findParent(AstSection.class);
                    if (!astSection.hasLabel()) {
                        this.consoleWrite(80, this.getToken(), new Object[0]);
                    }
                    this.section = astSection.getSection();
                    continue block7;
                }
                case 563: {
                    this.exitType = Exit.ExitTypes.ExitProgram;
                    AstGiving astGiving = astNode.getUniqueChild(AstGiving.class);
                    if (astGiving == null) continue block7;
                    this.exitCode = astGiving.getOperands()[0];
                }
            }
        }
    }

    @Override
    public void walk() {
        if (this.exitType == Exit.ExitTypes.ExitSection) {
            this.getCode().addStatement(new Go(this.getToken(), this.getCode().getCurrentProcedureIndex(), this.section.getEnd()));
        } else {
            this.exit = new Exit(this.getToken(), this.exitType, this.exitCode);
            this.getCode().addStatement(this.exit);
        }
    }

    public void updateInlinePerformStatement(AbstractStatement abstractStatement) {
        if (this.exit != null) {
            switch (this.exitType) {
                case ExitPerform: 
                case ExitPerformCycle: {
                    abstractStatement.setLabelNeeded(true);
                    this.exit.setInlinePerformStatement(abstractStatement);
                }
            }
        }
    }
}

