/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast.statements;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.IOperand;
import com.veryant.cobol.compiler.ast.AstAssignment;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstOperand;
import com.veryant.cobol.compiler.ast.AstOperandsList;
import com.veryant.cobol.compiler.ast.common.AstNotOnSizeError;
import com.veryant.cobol.compiler.ast.common.AstOnSizeError;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.stmts.ComputeArith;

public class AstComputeStatement
extends AstNode {
    public AstComputeStatement(Collector collector, Token token) {
        super(collector, token);
    }

    @Override
    public void validate() {
        AstOperandsList astOperandsList = this.getUniqueChild(AstOperandsList.class);
        for (AstOperand astOperand : astOperandsList.getAstOperands()) {
            if (!IOperand.isOtherThanNumeric(astOperand.getOperand())) continue;
            this.consoleWrite(44, astOperand.getToken(), new Object[0]);
        }
    }

    @Override
    public void walk() {
        AstOperandsList astOperandsList = this.getUniqueChild(AstOperandsList.class);
        AstAssignment astAssignment = this.getUniqueChild(AstAssignment.class);
        ComputeArith computeArith = new ComputeArith(this.getToken(), this.getContext().getARITHMETIC().getArithmeticType(), astOperandsList.getOperands(), astAssignment.getExpression());
        computeArith.setSizeError(this.walkAsBranch(AstOnSizeError.class));
        computeArith.setNotSizeError(this.walkAsBranch(AstNotOnSizeError.class));
        this.getCode().addStatement(computeArith);
    }
}

