/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import com.veryant.cobol.compiler.Utils;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.compiler.directives.DIALECT;
import com.veryant.cobol.compiler.directives.DUMMY;
import com.veryant.cobol.compiler.directives.DirectivesFactory;
import com.veryant.cobol.compiler.directives.HIDEMESSAGE;
import com.veryant.cobol.compiler.directives.IDirectiveListener;
import com.veryant.cobol.compiler.directives.IReservedWords;
import com.veryant.cobol.compiler.directives.LISTWIDTH;
import com.veryant.cobol.compiler.directives.REMOVE;
import com.veryant.cobol.compiler.directives.ReservedWordsList;
import com.veryant.cobol.compiler.directives.SETTINGS;
import com.veryant.cobol.compiler.frontend.CobolParserConstants;
import com.veryant.cobol.exceptions.COBOLCompilerException;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Directives {
    ArrayList<String> defaults = new ArrayList();
    private ArrayList<String> cmdLine = new ArrayList();
    private List<IDirectiveListener> directiveListeners = new ArrayList<IDirectiveListener>();
    private char quoteChar;
    private BaseDirective[] allDirectives = new BaseDirective[323];
    private boolean[] rwFlags = null;
    private ArrayList<String> rwRemoved = new ArrayList();
    private Boolean commitRwDirectives = false;
    private ArrayList<BaseDirective> rwDirectives = new ArrayList();
    private static final Pattern directiveNamePattern = Pattern.compile("[A-Z0-9\\-]+", 2);

    public Directives() throws InvalidDirectiveException {
        this.clearRwDirectives(true);
        DirectivesFactory.setDefaults(this);
        while (this.defaults.size() > 0) {
            String[] stringArray = this.defaults.toArray(new String[0]);
            this.defaults.clear();
            for (String string : stringArray) {
                this.set(BaseDirective.Phase.AtEnd, string);
            }
        }
    }

    public void addDirectiveListener(IDirectiveListener iDirectiveListener) {
        this.directiveListeners.add(iDirectiveListener);
        for (BaseDirective baseDirective : this.allDirectives) {
            IDirectiveListener.onDirectiveChanged(iDirectiveListener, baseDirective);
        }
    }

    public void removeDirectiveListener(IDirectiveListener iDirectiveListener) {
        this.directiveListeners.remove(iDirectiveListener);
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    public <T extends BaseDirective> T getDirective(int n) {
        return (T)this.allDirectives[n];
    }

    public BaseDirective setDirective(BaseDirective.Phase phase, BaseDirective baseDirective) {
        int n;
        if (baseDirective instanceof DIALECT) {
            this.clearRwDirectives(true);
        }
        if (this.allDirectives[n = baseDirective.getIndex()] == null || !this.allDirectives[n].mergeWith(phase, baseDirective)) {
            this.allDirectives[n] = baseDirective;
        }
        return this.allDirectives[n];
    }

    public ArrayList<String> getSettingsTexts() {
        SETTINGS sETTINGS = (SETTINGS)this.getDirective(278);
        if (!sETTINGS.isSet()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        block0 : switch (sETTINGS.getFormat()) {
            case Line: {
                LISTWIDTH lISTWIDTH = (LISTWIDTH)this.getDirective(179);
                StringBuilder stringBuilder = new StringBuilder();
                for (BaseDirective baseDirective : this.allDirectives) {
                    if (baseDirective == null) continue;
                    stringBuilder.append(baseDirective.toString()).append(' ');
                }
                Object object = stringBuilder.toString().trim();
                while (true) {
                    if (((String)object).length() <= lISTWIDTH.getWidth()) {
                        arrayList.add((String)object);
                        break block0;
                    }
                    int n = ((String)object).substring(0, lISTWIDTH.getWidth() + 1).lastIndexOf(32);
                    if (n <= 0) {
                        n = lISTWIDTH.getWidth();
                    }
                    arrayList.add(((String)object).substring(0, n));
                    object = ((String)object).substring(n).trim();
                }
            }
            case Col: {
                for (BaseDirective baseDirective : this.allDirectives) {
                    if (baseDirective == null) continue;
                    arrayList.add(baseDirective.toString());
                }
                break;
            }
            case Col3: {
                int n = 0;
                StringBuilder stringBuilder = new StringBuilder();
                for (BaseDirective baseDirective : this.allDirectives) {
                    if (baseDirective == null) continue;
                    if (n >= 3) {
                        arrayList.add(stringBuilder.toString().trim());
                        stringBuilder.setLength(0);
                        n = 0;
                    }
                    stringBuilder.append(baseDirective.toString()).append(' ');
                    ++n;
                }
                if (stringBuilder.length() <= 0) break;
                arrayList.add(stringBuilder.toString().trim());
                break;
            }
        }
        return arrayList;
    }

    private void clearRwDirectives(Boolean bl) {
        if (bl.booleanValue()) {
            this.rwFlags = new boolean[CobolParserConstants.tokenImage.length];
        }
        this.commitRwDirectives = false;
        this.rwDirectives.clear();
    }

    private void updateRw(BaseDirective.Phase phase, BaseDirective baseDirective) {
        if (baseDirective instanceof IReservedWords) {
            for (int i = 0; i < this.rwDirectives.size(); ++i) {
                if (this.rwDirectives.get(i).getIndex() != baseDirective.getIndex()) continue;
                this.rwDirectives.remove(i);
                this.commitRwDirectives = true;
                break;
            }
            if (baseDirective.isSet()) {
                this.rwDirectives.add(baseDirective);
                this.commitRwDirectives = true;
            }
        }
        if (this.commitRwDirectives.booleanValue() && phase != BaseDirective.Phase.ImmediateSet) {
            for (BaseDirective baseDirective2 : this.rwDirectives) {
                boolean[] blArray = ((IReservedWords)((Object)baseDirective2)).getRWFlags();
                for (int i = 0; i < blArray.length; ++i) {
                    int n = i;
                    this.rwFlags[n] = this.rwFlags[n] | blArray[i];
                }
            }
            this.clearRwDirectives(false);
        }
        if (baseDirective instanceof REMOVE) {
            this.rwRemoved = ((REMOVE)baseDirective).getRwList();
        }
    }

    public boolean isRwSuppressed(int n) {
        return !this.rwFlags[n];
    }

    public boolean isRwRemoved(String string) {
        if (this.rwRemoved.size() > 0) {
            return this.rwRemoved.contains(ReservedWordsList.normalize(string));
        }
        return false;
    }

    public void setDefault(String string) throws InvalidDirectiveException {
        this.set(BaseDirective.Phase.SetDefaults, string);
    }

    public static InvalidDirectiveException invalidDirectiveException(String string, Object ... objectArray) {
        return new InvalidDirectiveException(string, objectArray);
    }

    public void set(BaseDirective.Phase phase, String object) throws InvalidDirectiveException {
        if (phase == BaseDirective.Phase.CommandLine) {
            this.cmdLine.add((String)object);
        }
        block77: while (((String)object).length() > 0) {
            Matcher matcher = directiveNamePattern.matcher((CharSequence)(object = ((String)object).trim()));
            if (matcher.find()) {
                String string = ((String)object).substring(matcher.start(), matcher.end());
                Object object2 = string.replace("-", "").toUpperCase();
                String string2 = "";
                if (((String)object2).startsWith("NO")) {
                    string2 = "NO";
                    object2 = ((String)object2).substring(2);
                }
                switch (object2) {
                    case "MFLEVEL": {
                        object2 = "MF";
                        break;
                    }
                    case "COBSTATCONV": {
                        object2 = "COBFSTATCONV";
                        break;
                    }
                    case "DBCSOSSI": {
                        object2 = "DBCSSOSI";
                        break;
                    }
                    case "DIR": 
                    case "USE": {
                        object2 = "DIRECTIVES";
                        break;
                    }
                    case "IBMMS": 
                    case "PC1": {
                        object = matcher.replaceFirst((String)(string2.length() == 0 ? "MS\"1\"" : string2 + "MS"));
                        continue block77;
                    }
                    case "JAPANESE": {
                        object2 = "NCHAR";
                        break;
                    }
                    case "OUTPUT": {
                        object2 = "ILOUTPUT";
                        break;
                    }
                    case "P": {
                        object2 = "PREPROCESS";
                        break;
                    }
                    case "PRINT": {
                        object2 = "LIST";
                        break;
                    }
                    case "SETTING": {
                        object2 = "SETTINGS";
                        break;
                    }
                    case "WARNING": {
                        object2 = "WARNINGS";
                        break;
                    }
                    case "WRITETHRU": {
                        object2 = "WRITETHROUGH";
                        break;
                    }
                    case "COMS85": 
                    case "ILARRAYPROPERTY": 
                    case "ILASSEMBLY": 
                    case "ILCLR": 
                    case "ILCOMPANY": 
                    case "ILCOPYRIGHT": 
                    case "ILCULTURE": 
                    case "ILCUTPREFIX": 
                    case "ILDELAYSIGN": 
                    case "ILDESCRIPTION": 
                    case "ILDOC": 
                    case "ILDYNCALL": 
                    case "ILEXPONENTIATION": 
                    case "ILFILEVERSION": 
                    case "ILGEN": 
                    case "ILICON": 
                    case "ILKEYFILE": 
                    case "ILKEYNAME": 
                    case "ILMAIN": 
                    case "ILMANIFEST": 
                    case "ILNAMESPACE": 
                    case "ILNATIVE": 
                    case "ILNATIVERESOURCE": 
                    case "ILNORMALIZENAMES": 
                    case "ILOBJECTIFY": 
                    case "ILPARAMS": 
                    case "ILPINVOKE": 
                    case "ILPRODUCT": 
                    case "ILPRODUCTVERSION": 
                    case "ILREF": 
                    case "ILRESOURCE": 
                    case "ILSHOWPERFORMOVERLAP": 
                    case "ILSOURCE": 
                    case "ILSTACKSIZE": 
                    case "ILSTATIC": 
                    case "ILSTDLIB": 
                    case "ILTARGET": 
                    case "ILTITLE": 
                    case "ILTRADEMARK": 
                    case "ILUSING": 
                    case "ILVERIFY": 
                    case "ILVERSION": 
                    case "TRICKLE": 
                    case "XMLGEN": 
                    case "XMLPARSE": 
                    case "ZWB": {
                        object2 = "DUMMY";
                    }
                }
                object2 = string2 + (String)object2;
                Object object3 = DirectivesFactory.getDirective((String)object2);
                if (object3 == null) {
                    throw Directives.invalidDirectiveException("Directive %s does not exist.", string);
                }
                if (((BaseDirective)object3).isNo() && !((BaseDirective)object3).isNoAllowed()) {
                    throw Directives.invalidDirectiveException("Directive %s does not exist.", string);
                }
                object = ((String)object).substring(matcher.end());
                if (phase == BaseDirective.Phase.CommandLine && ((String)object).startsWith("=")) {
                    object = "\"" + ((String)object).substring(1).trim() + "\"";
                    this.cmdLine.remove(this.cmdLine.size() - 1);
                    this.cmdLine.add((String)object2 + (String)object);
                }
                object = ((BaseDirective)object3).parseTokens((String)object);
                ((BaseDirective)object3).checkSetLegal(phase);
                if (!(object3 instanceof DUMMY) && !(object3 instanceof HIDEMESSAGE) && ((BaseDirective)object3).isNo() && ((BaseDirective)object3).getTokenCount() > 0) {
                    throw Directives.invalidDirectiveException("Directive %s cannot have parameters.", string);
                }
                ((BaseDirective)object3).setValues();
                object3 = this.setDirective(phase, (BaseDirective)object3);
                for (IDirectiveListener iDirectiveListener : this.directiveListeners) {
                    IDirectiveListener.onDirectiveChanged(iDirectiveListener, (BaseDirective)object3);
                }
                this.cacheValue((BaseDirective)object3);
                if (phase != BaseDirective.Phase.Clone && ((BaseDirective)object3).applyOtherDirectives()) {
                    if (phase != BaseDirective.Phase.AtEnd && ((BaseDirective)object3).getImmediateSet() != null) {
                        this.set(BaseDirective.Phase.ImmediateSet, ((BaseDirective)object3).getImmediateSet());
                    }
                    if (((BaseDirective)object3).getAtEndSet() != null) {
                        if (phase.compareTo(BaseDirective.Phase.AtEnd) <= 0) {
                            this.defaults.add(((BaseDirective)object3).getAtEndSet());
                        } else {
                            this.set(phase, ((BaseDirective)object3).getAtEndSet());
                        }
                    }
                }
                if (phase.compareTo(BaseDirective.Phase.AfterInit) >= 0) {
                    this.checkCompatibility((BaseDirective)object3);
                }
                this.updateRw(phase, (BaseDirective)object3);
                continue;
            }
            throw Directives.invalidDirectiveException("Directive %s does not exist.", object);
        }
    }

    private void checkCompatibility(BaseDirective baseDirective) throws InvalidDirectiveException {
        BaseDirective baseDirective2 = baseDirective.checkCompatibility(this);
        if (baseDirective2 != null) {
            throw Directives.invalidDirectiveException("Directive %s is not compatible with %s.", baseDirective.toString(), baseDirective2.toString());
        }
    }

    private void cacheValue(BaseDirective baseDirective) {
        switch (baseDirective.getIndex()) {
            case 16: {
                this.quoteChar = (char)39;
                break;
            }
            case 249: {
                this.quoteChar = (char)34;
            }
        }
    }

    public void importAll(BaseDirective.Phase phase, Directives directives) throws InvalidDirectiveException {
        if (phase != BaseDirective.Phase.Clone) {
            throw Directives.invalidDirectiveException("Directive merging not allowed in phase %s.", new Object[]{phase});
        }
        for (String string : directives.cmdLine) {
            this.set(BaseDirective.Phase.CommandLine, string);
        }
        for (BaseDirective baseDirective : this.allDirectives) {
            if (baseDirective == null) continue;
            baseDirective.checkCompatibility(this);
        }
    }

    public void parseOptionsFile(String string) throws InvalidDirectiveException {
        File file = new File(string);
        if (Utils.isValidFile(file)) {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).length() <= 0 || string2.charAt(0) == '#') continue;
                    this.set(BaseDirective.Phase.OptionFile, string2.trim());
                }
            }
            catch (IOException iOException) {
                throw new COBOLCompilerException(String.format("Cannot access file: %s", string));
            }
        }
    }
}

