/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.Memory;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;

public class Pic9Comp_9
extends NumericVar {
    private static final long serialVersionUID = 123L;

    public Pic9Comp_9(Memory m, int i, int il, int dl, boolean s, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(m, i, il, dl, s, (il + dl) / 2 + 1, dimSize, dim, name, pComma);
        if (m != null) {
            this.updateCache(m, this.theValue);
        }
    }

    public Pic9Comp_9(CobolVar par, int i, int il, int dl, boolean s, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(par, i, il, dl, s, (il + dl) / 2 + 1, dimSize, dim, name, pComma);
    }

    private void putBDToMem(Memory mem, BigCobolDec _bcd) {
        int i = this.end - 1;
        byte b = 0;
        BigCobolDec val = new BigCobolDec(_bcd);
        boolean minus = val.isNegative();
        while (i >= this.curOffset) {
            byte nibble = val.getDecDigit(0);
            val.shift(-1);
            b = nibble;
            nibble = val.getDecDigit(0);
            val.shift(-1);
            b = (byte)(b | (byte)(nibble << 4));
            mem.put(i--, b);
        }
        mem.put(this.curOffset, (byte)(b | 0xF0));
        if (minus) {
            for (i = this.curOffset; i < this.end; ++i) {
                mem.put(i, ~mem.get(i));
            }
        }
    }

    private void putLongToMem(Memory mem, long val) {
        boolean minus;
        int i = this.end - 1;
        byte b = 0;
        if (val < 0L) {
            minus = true;
            val = -val;
        } else {
            minus = false;
        }
        while (i >= this.curOffset) {
            byte nibble = (byte)(val % 10L);
            b = nibble;
            nibble = (byte)((val /= 10L) % 10L);
            val /= 10L;
            b = (byte)(b | (byte)(nibble << 4));
            mem.put(i--, b);
        }
        mem.put(this.curOffset, (byte)(b | 0xF0));
        if (minus) {
            for (i = this.curOffset; i < this.end; ++i) {
                mem.put(i, ~mem.get(i));
            }
        }
    }

    @Override
    void updateMemory(Memory mem, CobolNum cn) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(mem, cn.getUnscaledLong());
        } else {
            this.putBDToMem(mem, cn.bigCobDecValue());
        }
    }

    @Override
    void updateMemory(Memory mem) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(mem, this.num().getUnscaledLong());
        } else {
            this.putBDToMem(mem, this.num().bigCobDecValue());
        }
    }

    @Override
    int getAlphaBuffSize() {
        return super.getAlphaBuffSize() + 1;
    }

    @Override
    public void defaultInitialize() {
        this.theValue.lnUnscValue = 0L;
        Memory mem = this.getMemory();
        mem.fill(this.curOffset, this.end, (byte)0);
    }

    @Override
    void updateCache(Memory mem, CobolNum cn) {
        if (this.intLen + this.decLen <= 18) {
            cn.set(this.getLongFromMem(mem), this.decLen);
        } else {
            cn.set(this.getBDFromMem(mem));
        }
    }

    private long getLongFromMem(Memory mem) {
        int i;
        long Return2 = 0L;
        long decFact = 1L;
        boolean negative = this.myIsNegative(mem);
        byte[] locmem = new byte[mem.length];
        if (negative) {
            for (i = this.curOffset; i < this.end; ++i) {
                locmem[i] = ~mem.get(i);
            }
        } else {
            for (i = this.curOffset; i < this.end; ++i) {
                locmem[i] = mem.get(i);
            }
        }
        for (i = this.end - 1; i > this.curOffset; --i) {
            Return2 += (long)(locmem[i] & 0xF) * decFact;
            Return2 += (long)(locmem[i] >> 4 & 0xF) * (decFact *= 10L);
            decFact *= 10L;
        }
        Return2 += (long)(locmem[i] & 0xF) * decFact;
        decFact *= 10L;
        if (negative) {
            return -Return2;
        }
        return Return2;
    }

    private BigCobolDec getBDFromMem(Memory mem) {
        int i;
        boolean negative = this.myIsNegative(mem);
        char[] cNum = new char[this.intLen + this.decLen + 2];
        int cnIdx = cNum.length;
        byte[] locmem = new byte[mem.length];
        if (negative) {
            for (i = this.curOffset; i < this.end; ++i) {
                locmem[i] = ~mem.get(i);
            }
        } else {
            for (i = this.curOffset; i < this.end; ++i) {
                locmem[i] = mem.get(i);
            }
        }
        for (i = this.end - 1; i > this.curOffset; --i) {
            cNum[--cnIdx] = (char)(locmem[i] & 0xF);
            cNum[--cnIdx] = (char)(locmem[i] >> 4 & 0xF);
        }
        cNum[--cnIdx] = (char)(locmem[i] & 0xF);
        return Pic9Comp_9.getBD(cNum, cnIdx, negative, this.decLen);
    }

    @Override
    public boolean isNumeric() {
        int k;
        Memory mem = this.getMemory();
        byte sign = (byte)(mem.get(k = this.curOffset) & 0xF0);
        if (sign != 0 && sign != 240 || (mem.get(k++) & 0xF) > 9) {
            return false;
        }
        while (k < this.end) {
            if ((mem.get(k) & 0xF) > 9 || (mem.get(k) >> 4 & 0xF) > 9) {
                return false;
            }
            ++k;
        }
        return true;
    }

    @Override
    public boolean isNegative() {
        return this.isNumeric() && this.myIsNegative(this.getMemory());
    }

    private boolean myIsNegative(Memory mem) {
        return (mem.get(this.curOffset) & 0xF0) == 0;
    }
}

