/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.Config;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.Memory;
import com.iscobol.rts_n.Factory;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.EncBytes;
import com.iscobol.types_n.Literal;
import com.iscobol.types_n.MemMan;
import com.iscobol.types_n.NumericLiteralAll;
import com.iscobol.types_n.ObjectVar;
import com.iscobol.types_n.Pic1;
import com.iscobol.types_n.PicN;
import com.iscobol.types_n.PicNumEdit;
import com.iscobol.types_n.PicX;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class NumericVar
extends CobolVar
implements INumericVar,
EncBytes {
    public static final boolean showZeroes;
    public static final int checkNC;
    public static final String zeroFill = "00000000000000000000000000000000";
    static final byte[][] dca_encoded_sign;
    static final byte[][] dci_encoded_sign;
    static final byte[][] dcm_encoded_sign;
    static final byte[][] dcb_encoded_sign;
    static final byte[][] dcr_encoded_sign;
    static final byte[] encoded_digits;
    public static final NumericVar ZERO;
    final short intLen;
    final short decLen;
    final boolean signed;
    public CobolNum theValue;
    protected boolean lenInBytes;
    protected int len;
    protected int end;
    private static final long serialVersionUID = 123L;
    static final CobolNum zero;
    public static final int[] XLEN;

    abstract void updateCache(Memory var1, CobolNum var2);

    abstract void updateMemory(Memory var1, CobolNum var2);

    @Override
    public void setZero() {
        this.defaultInitialize();
    }

    @Override
    public void setAllZero() {
        this.defaultInitialize();
    }

    protected static int bDigits(int phisLen, int il, int dl) {
        int Return2 = il + dl;
        if (Return2 == 0) {
            Return2 = XLEN[phisLen];
        }
        return Return2;
    }

    NumericVar(Memory m, int i, int il, int dl, boolean s, int realLen, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(m, i, realLen, dimSize, dim, name, pComma);
        this.intLen = (short)il;
        this.decLen = (short)dl;
        this.signed = s;
        this.theValue = CobolNum.get(this.intLen + this.decLen, (int)this.decLen);
        this.len = this.getLen();
        this.end = this.getEnd();
    }

    NumericVar(CobolVar par, int i, int il, int dl, boolean s, int realLen, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(par, i, realLen, dimSize, dim, name, pComma);
        this.intLen = (short)il;
        this.decLen = (short)dl;
        this.signed = s;
        this.theValue = CobolNum.get(this.intLen + this.decLen, (int)this.decLen);
        this.len = this.getLen();
        this.end = this.getEnd();
    }

    int getAlphaBuffSize() {
        int Return2 = this.intLen + 1;
        if (this.signed) {
            ++Return2;
        }
        if (this.decLen > 0) {
            Return2 += this.decLen + 1;
        }
        return Return2;
    }

    protected Object clone() {
        NumericVar Return2;
        try {
            Return2 = (NumericVar)super.clone();
            Return2.theValue = CobolNum.noo(this.theValue);
        }
        catch (CloneNotSupportedException _ex) {
            Return2 = null;
        }
        return Return2;
    }

    @Override
    protected void updateEnd() {
        this.end = this.getEnd();
    }

    @Override
    public boolean isSigned() {
        return this.signed;
    }

    public NumericVar set(CobolVar value) {
        value.moveTo(this);
        return this;
    }

    @Override
    public boolean set(Memory src, int srcStart, int srcLen, boolean filling) {
        boolean Return2 = super.set(src, srcStart, srcLen, this.getLen(), filling);
        this.updateCache(this.memory.getMemory(), this.theValue);
        return Return2;
    }

    @Override
    public boolean set(Memory src, int srcStart, int srcLen, int destLen, boolean filling) {
        boolean Return2 = super.set(src, srcStart, srcLen, destLen, filling);
        this.updateCache(this.memory.getMemory(), this.theValue);
        return Return2;
    }

    @Override
    void internalSet(CobolVar cv) {
        cv.moveTo(this);
    }

    long parseLong(Memory src, int srcStart, int srcEnd) throws NumberFormatException {
        long Return2 = 0L;
        boolean negative = false;
        if (src.get(srcStart) == C_MINUS) {
            negative = true;
            ++srcStart;
        }
        for (int i = srcStart; i <= srcEnd; ++i) {
            byte digit = src.get(i);
            if (digit < C_0 || digit > C_9) {
                throw new NumberFormatException("" + digit);
            }
            Return2 = Return2 * 10L + (long)digit - (long)C_0;
        }
        return negative ? -Return2 : Return2;
    }

    @Override
    void setBytes(Memory src, int srcStart, int srcLen) {
        block16: {
            if (src != null) {
                int srcEnd = srcStart + srcLen - 1;
                while (srcStart <= srcEnd && src.get(srcStart) == C_SPACE) {
                    ++srcStart;
                }
                while (srcEnd >= srcStart && src.get(srcEnd) == C_SPACE) {
                    --srcEnd;
                }
                srcLen = srcEnd + 1 - srcStart;
                if (srcLen > 0) {
                    int dot;
                    byte dot_char = C_POINT;
                    for (dot = srcStart; dot <= srcEnd && src.get(dot) != dot_char; ++dot) {
                    }
                    if (dot <= srcEnd) {
                        int nDec = srcEnd - dot;
                        if (nDec > this.decLen) {
                            nDec = this.decLen;
                        }
                        try {
                            if (nDec > 0) {
                                long ip = this.parseLong(src, srcStart, dot - 1) * CobolNum.fact[nDec];
                                if (ip < 0L) {
                                    this.set(ip - this.parseLong(src, dot + 1, dot + nDec), nDec, false, false);
                                } else {
                                    this.set(ip + this.parseLong(src, dot + 1, dot + nDec), nDec, false, false);
                                }
                                break block16;
                            }
                            this.set(this.parseLong(src, srcStart, dot - 1), nDec, false, false);
                        }
                        catch (NumberFormatException e) {
                            this.set(0L, 0, false, false);
                        }
                    } else {
                        try {
                            this.set(this.parseLong(src, srcStart, srcEnd), 0, false, false);
                        }
                        catch (NumberFormatException e) {
                            this.set(0L, 0, false, false);
                        }
                    }
                } else {
                    this.set(0L, 0, false, false);
                }
            }
        }
    }

    @Override
    public boolean set(String s) {
        return this.set(CobolNum.get(s, false));
    }

    @Override
    public boolean set(CobolNum cn) {
        return this.set(cn, false, false);
    }

    @Override
    public boolean set(Object o) {
        if (o != null) {
            if (o instanceof CobolNum) {
                return this.set((CobolNum)o, false, false);
            }
            if (o instanceof NumericVar) {
                return this.set(((NumericVar)o).num(), false, false);
            }
            if (o instanceof BigDecimal) {
                return this.set((BigDecimal)o);
            }
            if (o instanceof Double) {
                return this.set((Double)o);
            }
            if (o instanceof Float) {
                return this.set(((Float)o).doubleValue());
            }
            return this.set(o.toString());
        }
        throw new NullPointerException();
    }

    @Override
    public boolean set(boolean value) {
        return this.set(value ? 1L : 0L, 0, false, false);
    }

    @Override
    public boolean set(byte value) {
        return this.set(value, 0, false, false);
    }

    @Override
    public boolean set(char value) {
        return this.set(value, 0, false, false);
    }

    @Override
    public boolean set(short value) {
        return this.set(value, 0, false, false);
    }

    @Override
    public boolean set(int value) {
        return this.set(value, 0, false, false);
    }

    @Override
    public boolean set(long value) {
        return this.set(value, 0, false, false);
    }

    @Override
    public boolean set(float value) {
        return this.set(CobolNum.noo(value), false, false);
    }

    @Override
    public boolean set(double value) {
        return this.set(CobolNum.noo(value), false, false);
    }

    public boolean set(BigCobolDec bd) {
        if (bd.precision() > 18) {
            return this.set(CobolNum.noo(bd), false, false);
        }
        return this.set(CobolNum.noo(bd.unscaled18Digits(bd.scale()), bd.scale()), false, false);
    }

    public boolean set(BigDecimal bd) {
        BigInteger uv = bd.unscaledValue();
        if (uv.bitLength() > 63) {
            return this.set(CobolNum.noo(bd), false, false);
        }
        return this.set(CobolNum.noo(uv.longValue(), bd.scale()), false, false);
    }

    @Override
    public boolean set(byte[] src) {
        return this.set(src, 0, src.length, true);
    }

    @Override
    public boolean toboolean() {
        return this.num().signum() != 0;
    }

    @Override
    public byte tobyte() {
        return (byte)this.num().intValue();
    }

    @Override
    public char tochar() {
        return (char)this.num().intValue();
    }

    @Override
    public short toshort() {
        return (short)this.num().intValue();
    }

    @Override
    public int toint() {
        return this.num().intValue();
    }

    @Override
    public long tolong() {
        return this.num().longValue();
    }

    @Override
    public float tofloat() {
        return this.num().floatValue();
    }

    @Override
    public double todouble() {
        return this.num().doubleValue();
    }

    public boolean set(long unscaled, int scale, boolean rounded, boolean checkOverflow) {
        boolean overflow;
        if (this.isFinal) {
            return true;
        }
        int scaleDiff = scale - this.decLen;
        if (rounded && scaleDiff > 0) {
            unscaled = CobolNum.roundUpIfNeeded(unscaled, scaleDiff);
        }
        if (this.lenInBytes ? (overflow = CobolNum.isLongOverflowByte(unscaled, this.len, this.signed, scaleDiff)) && checkOverflow : (overflow = CobolNum.isLongOverflow(unscaled, scale, this.intLen)) && checkOverflow) {
            return true;
        }
        if (!this.signed && unscaled < 0L) {
            unscaled = -unscaled;
        }
        this.theValue.set(unscaled, scale);
        if (this.decLen != scale) {
            this.theValue.setScale(this.decLen, false, this.lenInBytes);
        }
        if (overflow) {
            if (this.lenInBytes) {
                if (this.signed) {
                    this.theValue.setSizeByteSigned(this.len);
                } else {
                    this.theValue.setSizeByteUnsigned(this.len);
                }
            } else {
                this.theValue.setSizeDigit(this.intLen, this.decLen);
            }
        }
        this.updateMemory(this.memory.getMemory(), this.theValue);
        return false;
    }

    public void addToMe(long i) {
        CobolNum cn = this.num();
        cn.addToMe(i);
        this.set(cn);
    }

    public void subFromMe(long i) {
        CobolNum cn = this.num();
        cn.subFromMe(i);
        this.set(cn);
    }

    public void multiplyByMe(long i) {
        CobolNum cn = this.num();
        cn.multiplyByMe(i);
        this.set(cn);
    }

    public void divideIntoMe(long i) {
        this.divideIntoMe(false, i);
    }

    public void divideIntoMe(boolean checkdivbyzero, long i) {
        if (checkdivbyzero && i == 0L) {
            this.theValue.divideIntoMeByZero(checkdivbyzero);
            this.updateMemory(this.memory.getMemory(), this.theValue);
        } else {
            CobolNum cn = this.num();
            cn.divideIntoMe(i);
            this.set(cn);
        }
    }

    public boolean set(CobolNum d, boolean rounded, boolean checkOverflow) {
        boolean overflow;
        if (this.isFinal) {
            return true;
        }
        if (rounded && this.decLen < d.scale()) {
            d = CobolNum.noo(d);
            d.setScale(this.decLen, rounded, this.lenInBytes);
        }
        if (this.lenInBytes ? (overflow = d.isOverflowByte(this.theValue, this.len, this.signed)) && checkOverflow : (overflow = d.isOverflow(this.theValue, this.intLen)) && checkOverflow) {
            return true;
        }
        this.theValue.set(d, rounded, this.lenInBytes);
        if (!this.signed && this.theValue.signum() < 0) {
            this.theValue.negateMe();
        }
        if (this.decLen != d.scale()) {
            this.theValue.setScale(this.decLen, rounded, this.lenInBytes);
        }
        if (overflow) {
            if (this.lenInBytes) {
                if (this.signed) {
                    this.theValue.setSizeByteSigned(this.len);
                } else {
                    this.theValue.setSizeByteUnsigned(this.len);
                }
            } else {
                this.theValue.setSizeDigit(this.intLen, this.decLen);
            }
        }
        this.updateMemory(this.memory.getMemory(), this.theValue);
        return false;
    }

    @Override
    public CobolNum num() {
        if (!this.isFinal) {
            this.updateCache(this.memory.getMemory(), this.theValue);
        }
        return this.theValue;
    }

    @Override
    public void updateCache() {
        this.updateCache(this.memory.getMemory(), this.theValue);
    }

    long getLong() {
        return this.num().getUnscaledLong();
    }

    @Override
    public int compareTo(NumericVar cfrt) {
        return this.num().compareTo(cfrt.num());
    }

    @Override
    public int compareTo(CobolNum cfrt) {
        return this.num().compareTo(cfrt);
    }

    @Override
    public int compareTo(CobolVar cfrt) {
        return -cfrt.compareTo(this);
    }

    @Override
    public int compareTo(NumericLiteralAll cfrt) {
        return -cfrt.compareTo(this);
    }

    @Override
    public int compareTo(NumericVar cfrt, int[] collSeq) {
        return this.num().compareTo(cfrt.num());
    }

    @Override
    public int compareTo(CobolVar cfrt, int[] collSeq) {
        return -cfrt.compareTo(this, collSeq);
    }

    @Override
    public int compareTo(NumericLiteralAll cfrt, int[] collSeq) {
        return -cfrt.compareTo(this, collSeq);
    }

    @Override
    public int integer() {
        return this.num().intValue();
    }

    @Override
    public int scale() {
        return this.decLen;
    }

    @Override
    public int intLength() {
        return this.intLen;
    }

    public static NumericVar literal(String val, boolean pComma) {
        CobolNum n = CobolNum.get(val, pComma);
        int scale = n.scale();
        int precision = n.precision();
        NumericVar Return2 = precision < 0 ? Literal.get.num(n.doubleValue(), pComma) : Literal.get.num(n, precision - scale, scale, pComma);
        return Return2;
    }

    public static NumericVar literal(double val, boolean pComma) {
        return Literal.get.num(val, pComma);
    }

    public static NumericVar literal(CobolNum val, boolean pComma) {
        if (val.getType() == 2) {
            return Literal.get.num(val.doubleValue(), pComma);
        }
        if (val.getType() == 3) {
            return Literal.get.num(val.floatValue(), pComma);
        }
        return Literal.get.num(val, val.precision(), val.scale(), pComma);
    }

    public static NumericVar literal(CobolNum val, int nInt, int nDec, boolean pComma) {
        return Literal.get.num(val, nInt, nDec, pComma);
    }

    public static NumericVar literal(long val, int nInt, int nDec, boolean pComma) {
        return Literal.get.num(val, nInt, nDec, pComma);
    }

    @Override
    public CobolVar moveTo(NumericVar dest) {
        dest.set(this.num(), false, false);
        return this;
    }

    @Override
    public CobolVar moveTo(PicNumEdit dest) {
        dest.set(this);
        return this;
    }

    @Override
    public CobolVar moveTo(PicN dest) {
        dest.set(this);
        return this;
    }

    @Override
    public CobolVar moveTo(PicX dest) {
        dest.set(this);
        return this;
    }

    @Override
    public boolean isInteger() {
        if (!this.isNumeric()) {
            return false;
        }
        if (this.decLen == 0) {
            return true;
        }
        return this.getLong() % (long)(10 * this.decLen) == 0L;
    }

    @Override
    public boolean isPositive() {
        return this.isNumeric() && this.getLong() > 0L;
    }

    @Override
    public boolean isNegative() {
        return this.isNumeric() && this.getLong() < 0L;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public Object getId() {
        return ObjectVar.getId((int)this.getLong());
    }

    public NumericVar setId(Object obj) {
        this.set(ObjectVar.ssetId(obj), 0, false, false);
        return this;
    }

    @Override
    public INumericVar setIId(Object id) {
        return this.setId(id);
    }

    public NumericVar at(int[] idxs) {
        return (NumericVar)this.intAt(idxs);
    }

    public NumericVar at(int ix) {
        return (NumericVar)this.intAt(ix);
    }

    public NumericVar atNC(int[] idxs) {
        return (NumericVar)this.intAtNC(idxs);
    }

    public NumericVar atNC(int ix) {
        return (NumericVar)this.intAtNC(ix);
    }

    public NumericVar offs(int offs) {
        return (NumericVar)this.intOffs(offs);
    }

    public NumericVar offsNC(int offs) {
        return (NumericVar)this.intOffsNC(offs);
    }

    public NumericVar setDepending(CobolVar depOn) {
        return (NumericVar)this.intSetDepending(depOn);
    }

    public NumericVar byVal() {
        this.byValue = true;
        return this;
    }

    public NumericVar byRef() {
        this.byValue = false;
        return this;
    }

    public NumericVar copy() {
        return (NumericVar)this.intCopy();
    }

    @Override
    protected int getCategory() {
        return 4;
    }

    @Override
    int internalCompare(ICobolVar value) {
        return -((CobolVar)value).compareTo(this);
    }

    @Override
    public String toString() {
        return this.toString(this.isDecPointComma, false);
    }

    @Override
    public String toString(boolean decPointComma) {
        return this.toString(decPointComma, false);
    }

    @Override
    public String toStringNoGui() {
        return this.toString(this.isDecPointComma, true);
    }

    private String toString(boolean decPointComma, boolean noGui) {
        String Return2;
        if (!noGui && showZeroes) {
            int iLen;
            String sign;
            CobolNum n = this.num();
            StringBuffer sb = new StringBuffer(n.toString());
            if (this.signed) {
                if (n.isNegative()) {
                    sign = "-";
                    sb.deleteCharAt(0);
                } else {
                    sign = "+";
                }
            } else {
                sign = "";
            }
            if (this.decLen > 0) {
                iLen = sb.indexOf(".");
                if (iLen <= 0) {
                    iLen = sb.length();
                }
            } else {
                iLen = sb.length();
            }
            if ((iLen = this.intLen - iLen) > 0) {
                sb.insert(0, zeroFill.substring(0, iLen));
            }
            sb.insert(0, sign);
            Return2 = sb.toString();
        } else {
            Return2 = this.num().toString();
        }
        if (decPointComma) {
            Return2 = Return2.replace('.', ',');
        }
        return Return2;
    }

    public int hashCode() {
        return this.num().bigCobDecValue().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof NumericVar) {
            return this.compareTo((NumericVar)o) == 0;
        }
        return false;
    }

    static BigCobolDec getBD(char[] cNum, int cnIdx, boolean negative, int decLen) {
        int k;
        if (decLen > 0) {
            int i;
            k = cNum.length - 1;
            for (i = decLen; i > 0; --i) {
                if (cNum[k] <= '\t') {
                    int n = k;
                    cNum[n] = (char)(cNum[n] + 48);
                } else {
                    cNum[k] = 48;
                }
                --k;
            }
            for (i = cnIdx; i <= k; ++i) {
                cNum[i - 1] = cNum[i] <= '\t' ? (int)(cNum[i] + 48) : 48;
            }
            cNum[k] = 46;
            --cnIdx;
        } else {
            for (k = cNum.length - 1; k >= cnIdx; --k) {
                if (cNum[k] <= '\t') {
                    int n = k;
                    cNum[n] = (char)(cNum[n] + 48);
                    continue;
                }
                cNum[k] = 48;
            }
        }
        int endcnum = cNum.length - 1;
        while (cnIdx < endcnum && cNum[cnIdx] == '0') {
            ++cnIdx;
        }
        if (negative) {
            cNum[--cnIdx] = 45;
        }
        return new BigCobolDec(new String(cNum, cnIdx, cNum.length - cnIdx));
    }

    protected final void checkNumericContent() {
        if (!this.isNumeric()) {
            if (checkNC == 1) {
                throw new IscobolRuntimeException(31, this.name == null ? "" : this.name);
            }
            if (checkNC == -1) {
                Factory.log("CHECK NUMERIC CONTENT: detected not numeric " + (this.name == null ? "" : this.name));
            }
        }
    }

    @Override
    protected void setAddressRecur(MemMan mem, int od) {
        super.setAddressRecur(mem, od);
        this.end -= od;
    }

    @Override
    CobolVar getDefaultValue() {
        return Factory.getFigurativeZero(this.isDecPointComma);
    }

    @Override
    public int compareTo(Pic1 pic1) {
        return -pic1.compareTo(this);
    }

    public CobolVar moveTo(Pic1 dest) {
        dest.set(this.tolong());
        return this;
    }

    static {
        dca_encoded_sign = new byte[][]{{C_0, C_BC}, {C_1, C_J}, {C_2, C_K}, {C_3, C_L}, {C_4, C_M}, {C_5, C_N}, {C_6, C_O}, {C_7, C_P}, {C_8, C_Q}, {C_9, C_R}};
        dci_encoded_sign = new byte[][]{{C_BO, C_BC}, {C_A, C_J}, {C_B, C_K}, {C_C, C_L}, {C_D, C_M}, {C_E, C_N}, {C_F, C_O}, {C_G, C_P}, {C_H, C_Q}, {C_I, C_R}};
        dcm_encoded_sign = new byte[][]{{C_0, C_p}, {C_1, C_q}, {C_2, C_r}, {C_3, C_s}, {C_4, C_t}, {C_5, C_u}, {C_6, C_v}, {C_7, C_w}, {C_8, C_x}, {C_9, C_y}};
        dcb_encoded_sign = new byte[][]{{C_0, C_BB}, {C_1, C_A}, {C_2, C_B}, {C_3, C_C}, {C_4, C_D}, {C_5, C_E}, {C_6, C_F}, {C_7, C_G}, {C_8, C_H}, {C_9, C_I}};
        dcr_encoded_sign = new byte[][]{{C_0, C_SPACE}, {C_1, C_EXCL_MK}, {C_2, C_QUOT_MK}, {C_3, C_NUM_SN}, {C_4, C_DOLLAR}, {C_5, C_PERCENT}, {C_6, C_AMP}, {C_7, C_APOST}, {C_8, C_L_PAR}, {C_9, C_R_PAR}};
        encoded_digits = new byte[]{C_0, C_1, C_2, C_3, C_4, C_5, C_6, C_7, C_8, C_9, C_MINUS, C_POINT};
        ZERO = Literal.get.num(0L, 1, 0, false);
        zero = CobolNum.noo(0L, 0);
        char tmp = Config.getProperty(".check.numeric_content", "N").charAt(0);
        checkNC = tmp == 'Y' || tmp == 'y' || tmp == 'S' || tmp == 's' || tmp == 'T' || tmp == 't' || tmp == '1' ? 1 : (tmp == 'N' || tmp == 'n' || tmp == 'F' || tmp == 'f' || tmp == '0' ? 0 : Config.getProperty(".check.numeric_content", 0));
        showZeroes = Config.getProperty(".gui.show_zeroes", false);
        XLEN = new int[]{0, 2, 4, 7, 9, 12, 14, 15, 18, 21, 24, 26, 28, 31, 31, 33, 35, 35, 38};
    }
}

