/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.PicDisplay;

public class PicDisplayWP
extends PicDisplay {
    private static final long serialVersionUID = 123L;
    private final short piLen;
    private final short myIntLen;
    private final short myDecLen;

    public PicDisplayWP(byte[] m, int i, int il, int dl, boolean signed, int[] dimSize, int[] dim, String name, int opt, boolean sSeparated, boolean sLeading, boolean pComma, int pl) {
        super(m, i, il, dl, signed, dimSize, dim, name, opt, sSeparated, sLeading, pComma);
        this.piLen = (short)pl;
        if (this.piLen > 0) {
            this.myIntLen = (short)(this.intLen + this.piLen);
            this.myDecLen = 0;
        } else if (this.piLen < 0) {
            this.myIntLen = 0;
            this.myDecLen = (short)(this.decLen - this.piLen);
        } else {
            this.myIntLen = this.intLen;
            this.myDecLen = this.decLen;
        }
        this.theValue = CobolNum.get(this.myIntLen, (int)this.myDecLen);
    }

    public PicDisplayWP(CobolVar p, int i, int il, int dl, boolean signed, int[] dimSize, int[] dim, String name, int opt, boolean sSeparated, boolean sLeading, boolean pComma, int pl) {
        super(p, i, il, dl, signed, dimSize, dim, name, opt, sSeparated, sLeading, pComma);
        this.piLen = (short)pl;
        if (this.piLen > 0) {
            this.myIntLen = (short)(this.intLen + this.piLen);
            this.myDecLen = 0;
        } else if (this.piLen < 0) {
            this.myIntLen = 0;
            this.myDecLen = (short)(this.decLen - this.piLen);
        } else {
            this.myIntLen = this.intLen;
            this.myDecLen = this.decLen;
        }
        this.theValue = CobolNum.get(this.myIntLen, (int)this.myDecLen);
    }

    @Override
    public boolean set(long unscaled, int scale, boolean rounded, boolean checkOverflow) {
        boolean overflow;
        if (this.isFinal) {
            return true;
        }
        if (this.piLen != 0) {
            if (this.piLen > 0) {
                unscaled /= CobolNum.fact[this.piLen];
                unscaled *= CobolNum.fact[this.piLen];
            } else {
                unscaled *= CobolNum.fact[-this.piLen];
                unscaled /= CobolNum.fact[-this.piLen];
            }
        }
        int scaleDiff = scale - this.myDecLen;
        if (rounded && scaleDiff > 0) {
            unscaled = CobolNum.roundUpIfNeeded(unscaled, scaleDiff);
        }
        if ((overflow = CobolNum.isLongOverflow(unscaled, scale, this.myIntLen)) && checkOverflow) {
            return true;
        }
        if (!this.signed && unscaled < 0L) {
            unscaled = -unscaled;
        }
        this.theValue.set(unscaled, scale);
        if (this.myDecLen != scale) {
            this.theValue.setScale(this.myDecLen, false, this.lenInBytes);
        }
        if (overflow) {
            if (this.lenInBytes) {
                if (this.signed) {
                    this.theValue.setSizeByteSigned(this.len);
                } else {
                    this.theValue.setSizeByteUnsigned(this.len);
                }
            } else {
                this.theValue.setSizeDigit(this.myIntLen, this.myDecLen);
            }
        }
        this.memory.setUnsync(this);
        return false;
    }

    @Override
    public boolean set(CobolNum d, boolean rounded, boolean checkOverflow) {
        boolean overflow;
        if (this.isFinal) {
            return true;
        }
        if (rounded) {
            d = CobolNum.noo(d);
            if (this.piLen > 0) {
                d.roundUpIfNeeded(this.piLen);
            }
            if (this.myDecLen < d.scale()) {
                d.setScale(this.myDecLen, rounded, this.lenInBytes);
            }
        }
        if ((overflow = d.isOverflow(this.theValue, this.myIntLen)) && checkOverflow) {
            return true;
        }
        this.theValue.set(d, rounded, this.lenInBytes);
        this.theValue.shift(-this.piLen);
        this.theValue.shift(this.piLen);
        if (!this.signed && this.theValue.signum() < 0) {
            this.theValue.negateMe();
        }
        if (this.myDecLen != d.scale()) {
            this.theValue.setScale(this.myDecLen, rounded, this.lenInBytes);
        }
        if (overflow) {
            if (this.lenInBytes) {
                if (this.signed) {
                    this.theValue.setSizeByteSigned(this.len);
                } else {
                    this.theValue.setSizeByteUnsigned(this.len);
                }
            } else {
                this.theValue.setSizeDigit(this.myIntLen, this.myDecLen);
            }
        }
        this.memory.setUnsync(this);
        return false;
    }

    @Override
    void updateMemory(byte[] mem, CobolNum cn) {
        cn = CobolNum.noo(cn);
        cn.shift(-this.piLen);
        cn.setScale(this.decLen);
        super.updateMemory(mem, cn);
    }

    @Override
    void updateMemory(byte[] mem) {
        this.updateMemory(mem, this.num());
    }

    @Override
    void updateCache(byte[] mem, CobolNum cn) {
        super.updateCache(mem, cn);
        cn.setScale(this.myDecLen);
        cn.shift(this.piLen);
    }

    @Override
    public String toString() {
        return new String(this.getMemory(), this.getOffset(), this.getLen());
    }

    @Override
    public int intLength() {
        return this.myIntLen;
    }

    @Override
    public int scale() {
        return this.myDecLen;
    }
}

