/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts_n;

import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.UserHandles;
import com.iscobol.rts_n.EsqlHostVar;
import com.iscobol.rts_n.EsqlRuntime;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;

public class EsqlOraPrepStat {
    private String name;
    private boolean statNoData;
    private int rowCount;
    private Connection con;
    private int type;
    private int holdability;
    private String query;
    private final Logger log = LoggerFactory.get(2048);
    private Vector params = new Vector();
    private Vector bindCols = new Vector();
    int handle;
    private SQLWarning warnings;
    private boolean nullResult = false;
    private int lastCol = 0;
    private static Method registerReturnParameter;
    private static Method getReturnResultSet;
    private static Method exec;
    static Class[] mReturnOutPar;
    static Class[] nullParamClass;
    static Object[] nullParam;
    private PreparedStatement hstmt;

    public EsqlOraPrepStat(String name, int type, int holdabilit) {
        this.name = name;
        this.type = type;
        this.holdability = holdabilit;
        this.handle = UserHandles.ssetId(this);
        this.warnings = null;
    }

    public void setQuery(Connection co, String quer) throws SQLException {
        this.query = quer;
        this.con = co;
        this.statNoData = EsqlRuntime.isStatNoData(this.query);
        if (this.hstmt != null) {
            try {
                if (this.log != null) {
                    this.log.info("Developers log: EsqlOraPrepStat: before close PS " + this.hstmt);
                }
                this.hstmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.hstmt = co.prepareStatement(this.query);
        if (this.log != null) {
            this.log.info("Developers log: EsqlOraPrepStat: after open PS " + this.hstmt);
        }
    }

    public ResultSet exec() throws SQLException {
        int bcSize = this.bindCols.size();
        Vector params = new Vector();
        if (params.size() == 0) {
            params.add(null);
        }
        for (int i = 0; i < this.bindCols.size(); ++i) {
            if (this.bindCols.get(i) == null) continue;
            params.add(this.bindCols.get(i));
        }
        params.add(null);
        this.rowCount = 0;
        if (this.hstmt != null) {
            try {
                exec.invoke((Object)this.hstmt, nullParam);
                ResultSet rs = (ResultSet)getReturnResultSet.invoke((Object)this.hstmt, nullParam);
                if (rs != null) {
                    rs.next();
                    EsqlRuntime.fillHostVars(rs, params);
                }
            }
            catch (InvocationTargetException e) {
                e.getCause().printStackTrace();
            }
            catch (Exception e) {
                e.getCause().printStackTrace();
            }
            this.nullResult = EsqlRuntime.searchNullWithoutInd(this.bindCols);
            this.rowCount = this.hstmt.getUpdateCount();
            this.warnings = this.hstmt.getWarnings();
            return null;
        }
        EsqlRuntime.esqlError(7, "/Syntax error");
        return null;
    }

    void setParams(EsqlOraPrepStat ec) throws SQLException {
        EsqlRuntime.setParams(this.hstmt, this.params);
    }

    public void close() throws SQLException {
        if (this.hstmt != null) {
            if (this.log != null) {
                this.log.info("Developers log: EsqlOraPrepStat: before close PS " + this.hstmt);
            }
            this.hstmt.close();
        }
    }

    public boolean isStatNoData() {
        return this.statNoData;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public String getQuery() {
        return this.query;
    }

    public String getName() {
        return this.name;
    }

    public int getHandle() {
        return this.handle;
    }

    public boolean hasNullResult() {
        return this.nullResult;
    }

    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public void bindCol(CobolVar hostVar, int type, int col, NumericVar ind, NumericVar len) throws SQLException {
        EsqlHostVar hv = new EsqlHostVar(hostVar, type, col, ind, len);
        for (int bcSize = this.bindCols.size(); bcSize <= col; ++bcSize) {
            this.bindCols.add(null);
        }
        this.bindCols.set(col, hv);
        try {
            registerReturnParameter.invoke((Object)this.hstmt, col + this.lastCol, hv.getFSqlType());
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
        }
        catch (Exception e) {
            e.getCause().printStackTrace();
        }
    }

    public void setParam(CobolVar hostVar, int type, int col, NumericVar ind, NumericVar len) throws SQLException {
        this.setParam(hostVar, type, col, ind, len, (short)-1);
    }

    public void setParam(CobolVar hostVar, int type, int col, NumericVar ind, NumericVar len, short sqlType) throws SQLException {
        int trimType = Config.getProperty(".jdbc.kept_spaces", 1);
        EsqlHostVar hv = new EsqlHostVar(hostVar, type, col, ind, len, "I", sqlType);
        for (int bcSize = this.params.size(); bcSize <= col; ++bcSize) {
            this.params.add(null);
        }
        this.params.set(col, hv);
        this.lastCol = this.params.size() - 1;
        hv.fromVar(col, this.hstmt, trimType);
    }

    public String getQueryLog() {
        String quer = this.query;
        if (this.params.size() > 0) {
            int trimType = Config.getProperty(".jdbc.kept_spaces", 1);
            quer = quer + " trimType[" + trimType + "] using[";
            for (int col = 1; col < this.params.size(); ++col) {
                if (col > 1) {
                    quer = quer + ", ";
                }
                if (this.params.get(col) != null) {
                    if (trimType == -1) {
                        quer = quer + "'" + ((EsqlHostVar)this.params.get(col)).getVar().toString() + "'";
                        continue;
                    }
                    quer = quer + "'" + EsqlHostVar.rtrim(((EsqlHostVar)this.params.get(col)).getVar(), trimType, trimType) + "'";
                    continue;
                }
                quer = quer + "null";
            }
        }
        return quer;
    }

    static {
        mReturnOutPar = new Class[]{Integer.TYPE, Integer.TYPE};
        nullParamClass = new Class[0];
        nullParam = new Object[0];
        try {
            Class<?> oraClass = Class.forName("oracle.jdbc.OraclePreparedStatement");
            exec = oraClass.getMethod("execute", nullParamClass);
            Class[] mReturnOutPar = new Class[]{Integer.TYPE, Integer.TYPE};
            registerReturnParameter = oraClass.getMethod("registerReturnParameter", mReturnOutPar);
            getReturnResultSet = oraClass.getMethod("getReturnResultSet", nullParamClass);
        }
        catch (Exception e) {
            throw new IscobolRuntimeException(e);
        }
    }
}

