/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.print.SpoolPrinter;
import java.awt.Point;
import java.awt.print.Printable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.event.PrintJobAttributeEvent;
import javax.print.event.PrintJobAttributeListener;

public class SpoolPrinterDirect
extends SpoolPrinter
implements Printable,
RuntimeErrorsNumbers {
    private DocFlavor format;
    private File file;
    private OutputStream out;
    private InputStream inp;

    public SpoolPrinterDirect(AbstractGuiFactoryImpl gf) {
        super(gf);
    }

    @Override
    protected void init() {
        this.format = DocFlavor.INPUT_STREAM.AUTOSENSE;
        this.services = PrintServiceLookup.lookupPrintServices(this.format, this.aset);
        this.setting.currentPrinter = null;
        try {
            this.file = File.createTempFile("prt", ".prt");
            this.file.deleteOnExit();
            this.out = new FileOutputStream(this.file);
        }
        catch (FileNotFoundException _ex) {
            throw new IscobolRuntimeException(8, _ex.toString());
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(8, _ex.toString());
        }
    }

    @Override
    public boolean setup() {
        boolean Return2;
        PrintService ps = ServiceUI.printDialog(null, 0, 0, this.services, this.getCurrPrintService(), this.format, this.aset);
        if (ps != null) {
            this.setting.currentPrinter = ps;
            Return2 = true;
        } else {
            Return2 = false;
        }
        return Return2;
    }

    public void setFont(Hashtable attrs) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    @Override
    public void setFont(int fontId) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    public Point getPageLayout(Hashtable attrs) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    @Override
    public void setMargins(double top, double bottom, double left, double right, int type) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    public void setColor(int red, int green, int blue) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    public void printBitmap(byte[] bitmapStream, double row, double col, double height, double width, int type) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    public void drawGraph(int shape, double startX, double startY, double stopX, double stopY, int type) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    public void setGraphPen(int style, double width, int red, int green, int blue) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    public void setGraphBrush(int style, int red, int green, int blue) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    @Override
    public void setDataColumns(int[] cols) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    @Override
    public void setPageColumn(boolean pComma, double start, double indent, double separation, int fontId, int unit, char align, boolean transparency) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    @Override
    public void clearPageColumn() {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    public void setCursor(double startX, double startY, double[] stopX, double[] stopY, int type, int shape) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    @Override
    public void setOrientation(int or) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    @Override
    public void setQuality(int qu) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    @Override
    public boolean setPrinter(String s) {
        for (int i = 0; i < this.services.length; ++i) {
            if (!this.services[i].getName().equals(s)) continue;
            this.setting.currentPrinter = this.services[i];
            return true;
        }
        return false;
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(8, _ex.toString());
        }
    }

    @Override
    public void write(char[] cbuf) {
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.write(new String(cbuf), off, len);
    }

    @Override
    public void write(int c) {
    }

    public void write(String str) {
        try {
            this.out.write(str.getBytes());
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(8, _ex.toString());
        }
    }

    public void write(String str, int off, int len) {
        try {
            this.out.write(str.getBytes(), off, len);
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(8, _ex.toString());
        }
    }

    @Override
    public void close() {
        try {
            this.out.close();
            PrintService currPrinter = this.getCurrPrintService();
            if (currPrinter != null) {
                DocPrintJob job = currPrinter.createPrintJob();
                job.addPrintJobAttributeListener(new PrintJobAttributeListener(){

                    @Override
                    public void attributeUpdate(PrintJobAttributeEvent pjae) {
                        System.out.println(pjae);
                    }
                }, null);
                this.inp = new FileInputStream(this.file);
                SimpleDoc doc = new SimpleDoc(this.inp, this.format, null);
                job.print(doc, this.aset);
                if (this.file != null) {
                    this.file.delete();
                }
            }
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(8, _ex.toString());
        }
        catch (PrintException _ex) {
            _ex.printStackTrace();
        }
    }
}

