/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SetLinesPerPage
extends PrintCommand {
    private int lines;

    public SetLinesPerPage(GuiFactory gf, int lines) {
        super(gf, 13);
        this.lines = lines;
    }

    public SetLinesPerPage(GuiFactory gf, RandomAccessFile inOut) throws IOException {
        super(gf, 13);
        this.lines = inOut.readInt();
    }

    @Override
    void toFile(RandomAccessFile inOut) throws IOException {
        inOut.writeInt(this.lines);
    }

    @Override
    public boolean testPrint(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        return this.print(pc, g2d, pf);
    }

    @Override
    public boolean print(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        TextLayout layout = new TextLayout("0", pc.font, pc.frc);
        float height = layout.getAscent() + layout.getDescent() + layout.getLeading();
        pc.advancing = (float)((pf.getImageableHeight() - (double)height) / (double)(this.lines - 1));
        return true;
    }
}

