/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.HandlesManager;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SetFont
extends PrintCommand {
    private Font font;
    private int fontId = -1;

    public SetFont(GuiFactory gf, HandlesManager hndls, Font f) {
        super(gf, 2);
        this.font = f;
        if (this.font != null) {
            this.fontId = hndls.getHandle(this.font);
        }
    }

    public SetFont(GuiFactory gf, HandlesManager hndls, RandomAccessFile inOut) throws IOException {
        super(gf, 2);
        this.fontId = inOut.readInt();
        this.font = (Font)hndls.getObject(this.fontId);
    }

    @Override
    void toFile(RandomAccessFile inOut) throws IOException {
        inOut.writeInt(this.fontId);
    }

    @Override
    public boolean testPrint(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        return this.print(pc, g2d, pf);
    }

    @Override
    public boolean print(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        g2d.setFont(this.font);
        pc.font = this.font;
        pc.frc = g2d.getFontRenderContext();
        return true;
    }
}

