/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.Events;
import com.iscobol.gui.FontAttribute;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.server.FontCmp;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.UserHandles;
import com.iscobol.rts.print.MyPrintService;
import com.iscobol.rts.print.PrintBitmapSrv;
import com.iscobol.rts.print.SpoolPrinter;
import com.iscobol.rts.print.SpoolPrinterInterface;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;

public class ServerSpoolPrinter
extends SpoolPrinter
implements SpoolPrinterInterface,
RuntimeErrorsNumbers {
    public ServerSpoolPrinter(GuiFactory gf, Events events) {
        super(gf);
        this.events = events;
        this.init();
    }

    @Override
    public void setGraphPen(int style, double width, int red, int green, int blue, int alpha) {
        super.setGraphPen(style, width, new Color(red, green, blue, alpha));
    }

    @Override
    public void setGraphPenPt(int style, double width, int red, int green, int blue, int alpha) {
        super.setGraphPenPt(style, width, new Color(red, green, blue, alpha));
    }

    @Override
    public void setGraphBrush(int style, int red, int green, int blue, int alpha) {
        super.setGraphBrush(style, new Color(red, green, blue, alpha));
    }

    @Override
    public void setBoxShade(int red, int green, int blue, int alpha) {
        super.setBoxShade(new Color(red, green, blue, alpha));
    }

    @Override
    public Point getPageLayout(Hashtable attrs) {
        return super.getPageLayout(attrs);
    }

    public void setFont(Hashtable attrs) {
        super.setFont(attrs);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
    }

    @Override
    protected Font getFont(Map tattrs) {
        return ScreenUtility.getServerFont(tattrs);
    }

    @Override
    protected Font getFont(int fontId) {
        return this.getFont(fontId, false);
    }

    public Font getFont(int fontId, boolean throwExc) {
        Object fcmp = UserHandles.getId(fontId);
        if (fcmp instanceof FontCmp) {
            Map attrs = FontAttribute.convertToTextAttributes(((FontCmp)fcmp).getAttrs());
            if (throwExc) {
                String family = (String)attrs.get(TextAttribute.FAMILY);
                Font Return2 = this.getFont(attrs);
                if (Return2 == null || !Return2.getFamily().equalsIgnoreCase(family)) {
                    throw new IllegalArgumentException(family);
                }
                return Return2;
            }
            return this.getFont(attrs);
        }
        if (throwExc) {
            throw new IllegalArgumentException("" + fontId);
        }
        return null;
    }

    @Override
    public void printBitmap(int imageId, double row, double col, int locType, double height, double width, int sizeType) {
        if (imageId != 0) {
            boolean locCells = false;
            boolean sizeCells = false;
            switch (locType) {
                case 2: {
                    row *= 72.0;
                    col *= 72.0;
                    break;
                }
                case 3: {
                    row *= 28.34645652770996;
                    col *= 28.34645652770996;
                    break;
                }
                case 1: {
                    locCells = true;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    System.err.println("printBitmap:Type " + locType + " not supported!");
                }
            }
            switch (sizeType) {
                case 2: {
                    width *= 72.0;
                    height *= 72.0;
                    break;
                }
                case 3: {
                    width *= 28.34645652770996;
                    height *= 28.34645652770996;
                    break;
                }
                case 1: {
                    sizeCells = true;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    if (width == 0.0 || height == 0.0) break;
                    System.err.println("printBitmap:Type " + sizeType + " not supported!");
                }
            }
            this.addCommand(new PrintBitmapSrv(this.gf, imageId, row, col, locCells, height, width, sizeCells));
        }
    }

    @Override
    public boolean isServerSide() throws IOException {
        return true;
    }

    @Override
    public boolean setup() {
        boolean Return2 = false;
        if (this.services != null) {
            PrintService mcp = null;
            PrintService[] mps = new MyPrintService[this.services.length];
            PrintService currPrinter = this.getCurrPrintService();
            if (this.services.length > 0) {
                for (int i = this.services.length - 1; i >= 0; --i) {
                    mps[i] = new MyPrintService(this.services[i]);
                    if (!this.services[i].equals(currPrinter)) continue;
                    mcp = mps[i];
                }
            }
            if ((mcp = (MyPrintService)ScreenUtility.getGuiFactory().serverPrintDialog(null, 0, 0, mps, mcp, null, this.aset)) != null) {
                PrintRequestAttributeSet asetRet;
                int cpIdx = -1;
                for (int i = mps.length - 1; i >= 0; --i) {
                    if (!((MyPrintService)mps[i]).equals(mcp)) continue;
                    cpIdx = i;
                }
                if (cpIdx >= 0) {
                    this.setting.currentPrinter = this.services[cpIdx];
                }
                if ((asetRet = mcp.getPrintAttributes()) != null) {
                    this.aset = asetRet;
                }
                Return2 = true;
            } else {
                Return2 = false;
            }
        } else {
            Return2 = false;
        }
        return Return2;
    }

    @Override
    public double[] setup(double top, double bottom, double left, double right) throws IOException {
        return new double[0];
    }
}

