/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.rts.print.RemotePrintCommand;
import com.iscobol.rts.print.RemotePrintResponse;
import com.iscobol.rts.print.SpoolPrinterInterface;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.print.attribute.Size2DSyntax;

public class RemotePrintCommandFactory
implements SpoolPrinterInterface {
    public static final int CMD_SETUP = 1;
    public static final int CMD_SETUP2 = 2;
    public static final int CMD_SET_FONT = 3;
    public static final int CMD_SET_FONT2 = 4;
    public static final int CMD_GET_PAGE_LAYOUT = 5;
    public static final int CMD_SET_MARGINS = 6;
    public static final int CMD_GET_MARGINS = 7;
    public static final int CMD_SET_COLOR = 8;
    public static final int CMD_SET_BACKGROUND = 9;
    public static final int CMD_SET_LINES_PER_PAGE = 10;
    public static final int CMD_PRINT_BITMAP = 11;
    public static final int CMD_DRAW_GRAPH = 12;
    public static final int CMD_SET_GRAPH_PEN = 13;
    public static final int CMD_SET_GRAPH_PEN_PT = 14;
    public static final int CMD_SET_GRAPH_BRUSH = 15;
    public static final int CMD_SET_DATA_COLUMNS = 16;
    public static final int CMD_SET_PAGE_COLUMNS = 17;
    public static final int CMD_CLEAR_PAGE_COLUMNS = 18;
    public static final int CMD_SET_CURSOR = 19;
    public static final int CMD_GET_NO_PRINTERS = 20;
    public static final int CMD_GET_CURR_PRINTER = 21;
    public static final int CMD_SET_PRINTER = 22;
    public static final int CMD_SET_PRINTER2 = 23;
    public static final int CMD_SET_ORIENTATION = 24;
    public static final int CMD_GET_ORIENTATION = 25;
    public static final int CMD_SET_QUALITY = 26;
    public static final int CMD_GET_QUALITY = 27;
    public static final int CMD_SET_JOB_NAME = 28;
    public static final int CMD_GET_PRINTER_NUMBER = 29;
    public static final int CMD_GET_PRINTER_NAME = 30;
    public static final int CMD_GET_PRINTER_URI = 31;
    public static final int CMD_IS_PRINTER_DEFAULT = 32;
    public static final int CMD_GET_COLOR_SUPPORT = 33;
    public static final int CMD_GET_CURR_ORIENTATION = 34;
    public static final int CMD_GET_CURR_COPIES = 35;
    public static final int CMD_SET_CURR_COPIES = 36;
    public static final int CMD_HAS_DUPLEX_PRINTING = 37;
    public static final int CMD_SET_DUPLEX_PRINTING = 38;
    public static final int CMD_GET_DUPLEX_PRINTING = 39;
    public static final int CMD_GET_JOB_NAME = 40;
    public static final int CMD_SET_MEDIA_SIZE = 41;
    public static final int CMD_SET_CUSTOM_MEDIA_SIZE = 42;
    public static final int CMD_GET_CURR_MEDIA_SIZE = 43;
    public static final int CMD_GET_CURR_MEDIA_SIZE_2D = 44;
    public static final int CMD_IS_SERVER_SIZE = 45;
    public static final int CMD_SET_ATTRIBUTE = 46;
    public static final int CMD_HAS_PRINTED = 47;
    public static final int CMD_CANCEL_JOB = 48;
    public static final int CMD_SET_MEDIA_TRAY = 49;
    public static final int CMD_GET_MEDIA_TRAY = 50;
    public static final int CMD_GET_MEDIA_4PRINTER = 51;
    public static final int CMD_UPDATE_PRINTERS = 52;
    public static final int CMD_SET_CHROMACITY = 53;
    public static final int CMD_GET_CHROMACITY = 54;
    public static final int CMD_SET_COLLATE = 55;
    public static final int CMD_GET_COLLATE = 56;
    public static final int CMD_RESET = 57;
    public static final int CMD_GET_CURR_PRINTER_CAPABILITIES = 58;
    public static final int CMD_GET_FONT_METRICS = 59;
    public static final int CMD_SET_DEFAULT_UNITS = 60;
    public static final int CMD_NEW_PAGE = 61;
    public static final int CMD_TEXT_OUT = 62;
    public static final int CMD_PRINT_AT = 63;
    public static final int CMD_SET_PREVIEW = 64;
    public static final int CMD_SET_PDF = 65;
    public static final int CMD_SET_HEADER_FOOTER = 66;
    public static final int CMD_SET_REPORT_NAME = 67;
    public static final int CMD_CLOSE = 68;
    public static final int CMD_PRINT_AND_CLOSE = 69;
    public static final int CMD_FLUSH = 70;
    public static final int CMD_WRITE = 71;
    public static final int CMD_WRITE2 = 72;
    public static final int CMD_WRITE3 = 73;
    public static final int CMD_WRITE4 = 74;
    public static final int CMD_WRITE5 = 75;
    public static final int CMD_WRITE6 = 76;
    public static final int CMD_WRITE_BYTES = 77;
    public static final int CMD_WRITE_BYTES2 = 78;
    public static final int CMD_SET_PITCH = 79;
    public static final int CMD_SET_BOX_SHADE = 80;
    private static final int MAX_BUFFER_SIZE = 10000;
    private final Vector<RemotePrintCommand> buffer = new Vector();
    final SpoolPrinterInterface target;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemotePrintCommandFactory(SpoolPrinterInterface sp, RemotePrintCommandFactory current) {
        this.target = sp;
        if (current != null) {
            Vector<RemotePrintCommand> vector = current.buffer;
            synchronized (vector) {
                this.buffer.addAll(current.buffer);
            }
        }
    }

    @Override
    public boolean setup() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 1;
        RemotePrintResponse r = this.flushCommands(c);
        return r.bool;
    }

    @Override
    public RemotePrintResponse executeCommands(RemotePrintCommand[] commands) throws IOException {
        return this.target.executeCommands(commands);
    }

    @Override
    public void sendCommands(RemotePrintCommand[] commands) throws IOException {
        this.target.sendCommands(commands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommands() throws IOException {
        Vector<RemotePrintCommand> vector = this.buffer;
        synchronized (vector) {
            this.target.sendCommands(this.buffer.toArray(new RemotePrintCommand[this.buffer.size()]));
            this.buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotePrintResponse flushCommands(RemotePrintCommand c) throws IOException {
        Vector<RemotePrintCommand> v = new Vector<RemotePrintCommand>();
        Vector<RemotePrintCommand> vector = this.buffer;
        synchronized (vector) {
            v.addAll(this.buffer);
            this.buffer.clear();
        }
        v.addElement(c);
        RemotePrintResponse r = this.target.executeCommands(v.toArray(new RemotePrintCommand[v.size()]));
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommand(RemotePrintCommand c) throws IOException {
        Vector<RemotePrintCommand> vector = this.buffer;
        synchronized (vector) {
            if (this.buffer.size() == 9999) {
                this.flushCommands(c);
            } else {
                this.buffer.addElement(c);
            }
        }
    }

    @Override
    public double[] setup(double top, double bottom, double left, double right) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 2;
        c.db1 = top;
        c.db2 = bottom;
        c.db3 = left;
        c.db4 = right;
        RemotePrintResponse r = this.flushCommands(c);
        return r.dbla;
    }

    @Override
    public void setFont(Map attrs) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 3;
        c.obj1 = attrs != null ? new HashMap(attrs) : attrs;
        this.addCommand(c);
    }

    @Override
    public void setFont(int fontId) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 4;
        c.int1 = fontId;
        this.addCommand(c);
        this.sendCommands();
    }

    @Override
    public Point getPageLayout(Hashtable attrs) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 5;
        c.obj1 = attrs != null ? new Hashtable(attrs) : null;
        RemotePrintResponse r = this.flushCommands(c);
        return new Point(r.int1, r.int2);
    }

    @Override
    public void setMargins(double top, double bottom, double left, double right, int type) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 6;
        c.db1 = top;
        c.db2 = bottom;
        c.db3 = left;
        c.db4 = right;
        c.int1 = type;
        this.addCommand(c);
    }

    @Override
    public double[] getMargins(int type) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 7;
        c.int1 = type;
        RemotePrintResponse r = this.flushCommands(c);
        return r.dbla;
    }

    @Override
    public void setColor(int red, int green, int blue, int alpha) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 8;
        c.int1 = red;
        c.int2 = green;
        c.int3 = blue;
        c.int4 = alpha;
        this.addCommand(c);
    }

    @Override
    public void setBackground(int red, int green, int blue, int alpha) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 9;
        c.int1 = red;
        c.int2 = green;
        c.int3 = blue;
        c.int4 = alpha;
        this.addCommand(c);
    }

    @Override
    public void setLinesPerPage(int lines) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 10;
        c.int1 = lines;
        this.addCommand(c);
    }

    @Override
    public void printBitmap(int imageId, double row, double col, int locType, double height, double width, int sizeType) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 11;
        c.db1 = row;
        c.db2 = col;
        c.db3 = height;
        c.db4 = width;
        c.int1 = imageId;
        c.int2 = locType;
        c.int3 = sizeType;
        this.addCommand(c);
        this.sendCommands();
    }

    @Override
    public void drawGraph(int shape, double startX, double startY, double stopX, double stopY, int type, String shade) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 12;
        c.db1 = startX;
        c.db2 = startY;
        c.db3 = stopX;
        c.db4 = stopY;
        c.int1 = shape;
        c.int2 = type;
        c.str1 = shade;
        this.addCommand(c);
    }

    @Override
    public void setBoxShade(int red, int green, int blue, int alpha) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 80;
        c.int1 = red;
        c.int2 = green;
        c.int3 = blue;
        c.int4 = alpha;
        this.addCommand(c);
    }

    @Override
    public void setGraphPen(int style, double width, int red, int green, int blue, int alpha) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 13;
        c.db1 = width;
        c.int1 = style;
        c.int2 = red;
        c.int3 = green;
        c.int4 = blue;
        c.int5 = alpha;
        this.addCommand(c);
    }

    @Override
    public void setGraphPenPt(int style, double width, int red, int green, int blue, int alpha) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 14;
        c.db1 = width;
        c.int1 = style;
        c.int2 = red;
        c.int3 = green;
        c.int4 = blue;
        c.int5 = alpha;
        this.addCommand(c);
    }

    @Override
    public void setGraphBrush(int style, int red, int green, int blue, int alpha) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 15;
        c.int1 = style;
        c.int2 = red;
        c.int3 = green;
        c.int4 = blue;
        c.int5 = alpha;
        this.addCommand(c);
    }

    @Override
    public void setDataColumns(int[] cols) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 16;
        c.inta1 = cols;
        this.addCommand(c);
    }

    @Override
    public void setPageColumn(boolean pComma, double start, double indent, double separation, int fontId, int unit, char align, boolean transparency) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 17;
        c.bool1 = pComma;
        c.db1 = start;
        c.db2 = indent;
        c.db3 = separation;
        c.int1 = fontId;
        c.int2 = unit;
        c.chr1 = align;
        c.bool2 = transparency;
        this.addCommand(c);
        this.sendCommands();
    }

    @Override
    public void clearPageColumn() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 18;
        this.addCommand(c);
    }

    @Override
    public void setCursor(double startX, double startY, double[] stopX, double[] stopY, int type, int shape, byte txtAlign) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 19;
        c.db1 = startX;
        c.db2 = startY;
        c.dba1 = stopX;
        c.dba2 = stopY;
        c.int1 = type;
        c.int2 = shape;
        c.by1 = txtAlign;
        this.addCommand(c);
    }

    @Override
    public int getNoPrinters() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 20;
        RemotePrintResponse r = this.flushCommands(c);
        return r.int1;
    }

    @Override
    public int getCurrPrinter() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 21;
        RemotePrintResponse r = this.flushCommands(c);
        return r.int1;
    }

    @Override
    public boolean setPrinter(String s) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 22;
        c.str1 = s;
        RemotePrintResponse r = this.flushCommands(c);
        return r.bool;
    }

    @Override
    public boolean setPrinter(int nr) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 23;
        c.int1 = nr;
        RemotePrintResponse r = this.flushCommands(c);
        return r.bool;
    }

    @Override
    public void setOrientation(int or) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 24;
        c.int1 = or;
        this.addCommand(c);
    }

    @Override
    public int getOrientation() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 25;
        RemotePrintResponse r = this.flushCommands(c);
        return r.int1;
    }

    @Override
    public void setQuality(int qu) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 26;
        c.int1 = qu;
        this.addCommand(c);
    }

    @Override
    public int getQuality() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 27;
        RemotePrintResponse r = this.flushCommands(c);
        return r.int1;
    }

    @Override
    public void setJobName(String jn, String out) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 28;
        c.str1 = jn;
        c.str2 = out;
        this.addCommand(c);
    }

    @Override
    public int getPrinterNumber(String s) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 29;
        c.str1 = s;
        RemotePrintResponse r = this.flushCommands(c);
        return r.int1;
    }

    @Override
    public String getPrinterName(int idx) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 30;
        c.int1 = idx;
        RemotePrintResponse r = this.flushCommands(c);
        return r.str;
    }

    @Override
    public String getPrinterURI(int idx) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 31;
        c.int1 = idx;
        RemotePrintResponse r = this.flushCommands(c);
        return r.str;
    }

    @Override
    public boolean isPrinterDefault(int idx) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 32;
        c.int1 = idx;
        RemotePrintResponse r = this.flushCommands(c);
        return r.bool;
    }

    @Override
    public int getColorSupport(int idx) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 33;
        c.int1 = idx;
        RemotePrintResponse r = this.flushCommands(c);
        return r.int1;
    }

    @Override
    public int getCurrOrientation() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 34;
        RemotePrintResponse r = this.flushCommands(c);
        return r.int1;
    }

    @Override
    public int getCurrCopies() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 35;
        RemotePrintResponse r = this.flushCommands(c);
        return r.int1;
    }

    @Override
    public void setCurrCopies(int copies) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 36;
        c.int1 = copies;
        this.addCommand(c);
    }

    @Override
    public boolean hasDuplexPrinting() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 37;
        RemotePrintResponse r = this.flushCommands(c);
        return r.bool;
    }

    @Override
    public void setDuplexPrinting(int dp) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 38;
        c.int1 = dp;
        this.addCommand(c);
    }

    @Override
    public int getDuplexPrinting() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 39;
        RemotePrintResponse r = this.flushCommands(c);
        return r.int1;
    }

    @Override
    public String getJobName() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 40;
        RemotePrintResponse r = this.flushCommands(c);
        return r.str;
    }

    @Override
    public boolean setMediaSize(int n) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 41;
        c.int1 = n;
        RemotePrintResponse r = this.flushCommands(c);
        return r.bool;
    }

    @Override
    public boolean setCustomMediaSize(float x, float y, int u) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 42;
        c.int1 = u;
        c.flt1 = x;
        c.flt2 = y;
        RemotePrintResponse r = this.flushCommands(c);
        return r.bool;
    }

    @Override
    public int getCurrMediaSize() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 43;
        RemotePrintResponse r = this.flushCommands(c);
        return r.int1;
    }

    @Override
    public Size2DSyntax getCurrMediaSize2D() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 44;
        RemotePrintResponse r = this.flushCommands(c);
        return (Size2DSyntax)r.obj;
    }

    @Override
    public boolean isServerSide() throws IOException {
        return this.target.isServerSide();
    }

    @Override
    public void setAttribute(String key, String value) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 46;
        c.str1 = key;
        c.str2 = value;
        this.addCommand(c);
    }

    @Override
    public boolean hasPrinted() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 47;
        RemotePrintResponse r = this.flushCommands(c);
        return r.bool;
    }

    @Override
    public void cancelJob() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 48;
        this.addCommand(c);
    }

    @Override
    public boolean setMediaTray(int n) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 49;
        c.int1 = n;
        RemotePrintResponse r = this.flushCommands(c);
        return r.bool;
    }

    @Override
    public int getMediaTray() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 50;
        RemotePrintResponse r = this.flushCommands(c);
        return r.int1;
    }

    @Override
    public int[][] getMedia4Printer(String prnName) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 51;
        c.str1 = prnName;
        RemotePrintResponse r = this.flushCommands(c);
        return r.intaa;
    }

    @Override
    public void updatePrinters() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 52;
        this.addCommand(c);
    }

    @Override
    public void setChromaticity(int co) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 53;
        c.int1 = co;
        this.addCommand(c);
    }

    @Override
    public int getChromaticity() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 54;
        RemotePrintResponse r = this.flushCommands(c);
        return r.int1;
    }

    @Override
    public void setCollate(int cl) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 55;
        c.int1 = cl;
        this.addCommand(c);
    }

    @Override
    public int getCollate() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 56;
        RemotePrintResponse r = this.flushCommands(c);
        return r.int1;
    }

    @Override
    public void reset() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 57;
        this.addCommand(c);
    }

    @Override
    public int[] getCurrPrinterCapabilities() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 58;
        RemotePrintResponse r = this.flushCommands(c);
        return r.inta;
    }

    @Override
    public Hashtable getFontMetrics(Hashtable attrs) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 59;
        c.obj1 = attrs != null ? new Hashtable(attrs) : null;
        RemotePrintResponse r = this.flushCommands(c);
        return (Hashtable)r.obj;
    }

    @Override
    public void setPitch(char type, float factor) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 79;
        c.chr1 = type;
        c.flt1 = factor;
        this.addCommand(c);
    }

    @Override
    public void setDefaultUnits(int type) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 60;
        c.int1 = type;
        this.addCommand(c);
    }

    @Override
    public void newPage() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 61;
        this.addCommand(c);
    }

    @Override
    public void textOut(byte[] b, int offset, int length) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 62;
        c.bya1 = RemotePrintCommandFactory.copyByteArray(b);
        c.int1 = offset;
        c.int2 = length;
        this.addCommand(c);
    }

    @Override
    public void printAt(String s, float x, float y, float w, boolean rpos, char algn, byte ys, boolean clp) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 63;
        c.str1 = s;
        c.flt1 = x;
        c.flt2 = y;
        c.flt3 = w;
        c.bool1 = rpos;
        c.bool2 = clp;
        c.chr1 = algn;
        c.by1 = ys;
        this.addCommand(c);
    }

    @Override
    public void setPreview(boolean prvw) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 64;
        c.bool1 = prvw;
        this.addCommand(c);
    }

    @Override
    public void setPDF(boolean pdf) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 65;
        c.bool1 = pdf;
        this.addCommand(c);
    }

    @Override
    public void setHeaderFooter(String h, String f, int ft) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 66;
        c.int1 = ft;
        c.str1 = h;
        c.str2 = f;
        this.addCommand(c);
        this.sendCommands();
    }

    @Override
    public void setReportName(String u) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 67;
        c.str1 = u;
        this.addCommand(c);
    }

    @Override
    public void close() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 68;
        this.flushCommands(c);
    }

    @Override
    public IOException printAndClose() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 69;
        RemotePrintResponse r = this.flushCommands(c);
        return (IOException)r.obj;
    }

    @Override
    public void flush() throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 70;
        this.addCommand(c);
    }

    @Override
    public void write(char[] b) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 71;
        c.chra1 = RemotePrintCommandFactory.copyCharArray(b);
        this.addCommand(c);
    }

    @Override
    public void write(char[] b, int off, int len) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 72;
        c.chra1 = RemotePrintCommandFactory.copyCharArray(b);
        c.int1 = off;
        c.int2 = len;
        this.addCommand(c);
    }

    @Override
    public void writeBytes(byte[] b) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 77;
        c.bya1 = RemotePrintCommandFactory.copyByteArray(b);
        this.addCommand(c);
    }

    @Override
    public void writeBytes(byte[] b, int off, int len) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 78;
        c.bya1 = RemotePrintCommandFactory.copyByteArray(b);
        c.int1 = off;
        c.int2 = len;
        this.addCommand(c);
    }

    @Override
    public void write(int ch) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 73;
        c.int1 = ch;
        this.addCommand(c);
    }

    @Override
    public void write(byte[] b) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 74;
        c.bya1 = RemotePrintCommandFactory.copyByteArray(b);
        this.addCommand(c);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 75;
        c.bya1 = RemotePrintCommandFactory.copyByteArray(b);
        c.int1 = off;
        c.int2 = len;
        this.addCommand(c);
    }

    @Override
    public void write(byte ch) throws IOException {
        RemotePrintCommand c = new RemotePrintCommand();
        c.type = 76;
        c.by1 = ch;
        this.addCommand(c);
    }

    static void writeIntArray(ObjectOutput out, int[] a) throws IOException {
        if (a != null) {
            out.writeInt(a.length);
            for (int i = 0; i < a.length; ++i) {
                out.writeInt(a[i]);
            }
        } else {
            out.writeInt(-1);
        }
    }

    static void writeByteArray(ObjectOutput out, byte[] a) throws IOException {
        if (a != null) {
            out.writeInt(a.length);
            for (int i = 0; i < a.length; ++i) {
                out.writeByte(a[i]);
            }
        } else {
            out.writeInt(-1);
        }
    }

    static void writeCharArray(ObjectOutput out, char[] a) throws IOException {
        if (a != null) {
            out.writeInt(a.length);
            for (int i = 0; i < a.length; ++i) {
                out.writeChar(a[i]);
            }
        } else {
            out.writeInt(-1);
        }
    }

    static void writeDoubleArray(ObjectOutput out, double[] a) throws IOException {
        if (a != null) {
            out.writeInt(a.length);
            for (int i = 0; i < a.length; ++i) {
                out.writeDouble(a[i]);
            }
        } else {
            out.writeInt(-1);
        }
    }

    static int[] readIntArray(ObjectInput in) throws IOException {
        int len = in.readInt();
        if (len >= 0) {
            int[] a = new int[len];
            for (int i = 0; i < len; ++i) {
                a[i] = in.readInt();
            }
            return a;
        }
        return null;
    }

    static byte[] readByteArray(ObjectInput in) throws IOException {
        int len = in.readInt();
        if (len >= 0) {
            byte[] a = new byte[len];
            for (int i = 0; i < len; ++i) {
                a[i] = in.readByte();
            }
            return a;
        }
        return null;
    }

    static char[] readCharArray(ObjectInput in) throws IOException {
        int len = in.readInt();
        if (len >= 0) {
            char[] a = new char[len];
            for (int i = 0; i < len; ++i) {
                a[i] = in.readChar();
            }
            return a;
        }
        return null;
    }

    static double[] readDoubleArray(ObjectInput in) throws IOException {
        int len = in.readInt();
        if (len >= 0) {
            double[] a = new double[len];
            for (int i = 0; i < len; ++i) {
                a[i] = in.readDouble();
            }
            return a;
        }
        return null;
    }

    static void writeIntIntArray(ObjectOutput out, int[][] a) throws IOException {
        if (a != null) {
            out.writeInt(a.length);
            for (int i = 0; i < a.length; ++i) {
                if (a[i] != null) {
                    out.writeInt(a[i].length);
                    for (int j = 0; j < a[i].length; ++j) {
                        out.writeInt(a[i][j]);
                    }
                    continue;
                }
                out.writeInt(-1);
            }
        } else {
            out.writeInt(-1);
        }
    }

    static int[][] readIntIntArray(ObjectInput in) throws IOException {
        int len = in.readInt();
        if (len >= 0) {
            int[][] a = new int[len][];
            for (int i = 0; i < len; ++i) {
                int len2 = in.readInt();
                if (len2 >= 0) {
                    a[i] = new int[len2];
                    for (int j = 0; j < a[i].length; ++j) {
                        a[i][j] = in.readInt();
                    }
                    continue;
                }
                a[i] = null;
            }
            return a;
        }
        return null;
    }

    static byte[] copyByteArray(byte[] src) {
        byte[] copy = new byte[src.length];
        System.arraycopy(src, 0, copy, 0, src.length);
        return copy;
    }

    static char[] copyCharArray(char[] src) {
        char[] copy = new char[src.length];
        System.arraycopy(src, 0, copy, 0, src.length);
        return copy;
    }
}

