/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Base64;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IPicNumEdit;
import com.iscobol.rts.IXMLAttributes;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RtsUtil;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.PicX;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XMLStream
extends DefaultHandler {
    static final int XML_SUCCESS = 1;
    static final int XML_BAD_ARGUMENT = -1;
    protected ICobolVar xmlVar;
    private XmlNode xmlRoot;
    protected PrintWriter out;
    private Map<String, String> writeNsPrefixes;
    protected boolean omitEmptyElements = true;
    protected boolean initializeOnRead;
    protected boolean rtrim;
    protected boolean resolveRefs;
    private int prog;
    private Map<String, String> globalNamespaces = new HashMap<String, String>();
    private List<DeferredElement> deferredElements = new ArrayList<DeferredElement>();
    protected Stack<Node> varStack;
    private Node last;
    private TransformerHandler hd;
    private Properties outputProperties;
    private boolean mtomEnabled;
    private Map<String, ICobolVar> mtomItems = new HashMap<String, ICobolVar>();
    private String schemaLocation;
    private boolean writeSchemaLocation;
    private boolean addLineFeed;
    private final boolean isInXmlFile;
    private XmlNode startNode;
    private int startNodeIndex = 1;
    private boolean startNodeAttr;

    public XMLStream(ICobolVar v) {
        this(v, false, false);
    }

    public XMLStream(CobolVar v) {
        this((ICobolVar)v, false, false);
    }

    public XMLStream(CobolVar v, boolean xmlFile, boolean addLineFeed) {
        this((ICobolVar)v, xmlFile, addLineFeed);
    }

    public XMLStream(ICobolVar v, boolean xmlFile, boolean addLineFeed) {
        if (!(xmlFile || v != null && v.getIXMLAttributes() != null)) {
            throw new IllegalArgumentException(v.getName());
        }
        this.xmlVar = v;
        this.isInXmlFile = xmlFile;
        this.addLineFeed = addLineFeed;
    }

    public final int readFromFile(String fn) {
        return this.read(fn, null);
    }

    public final int readFromFile(String fn, String encoding) {
        return this.read(fn, encoding);
    }

    public final int read(String fn) {
        return this.read(fn, null);
    }

    public final int read(String fn, String encoding) {
        InputStream in;
        if (fn != null) {
            try {
                in = new FileInputStream(fn.trim());
            }
            catch (FileNotFoundException _ex) {
                throw new IscobolRuntimeException(130, _ex.getMessage());
            }
        } else {
            in = System.in;
        }
        return this.readFromStream(in, encoding);
    }

    public final int readFromString(String s) {
        return this.read(new StringReader(s));
    }

    public final int readFromString(String s, String encoding) {
        return this.read(new StringReader(s));
    }

    public final int readFromStream(InputStream in) {
        return this.readFromStream(in, null);
    }

    public final int readFromStream(InputStream in, String encoding) {
        if (encoding != null) {
            return this.read(new InputStreamReader(in, Charset.forName(encoding)));
        }
        return this.read(in);
    }

    public boolean isOk() {
        return this.varStack != null && this.varStack.isEmpty();
    }

    protected int read(InputStream in) {
        this.readConfiguration();
        InputStream in2 = null;
        if (this.resolveRefs) {
            XMLReferenceResolver resolver = new XMLReferenceResolver(new InputStreamReader(in));
            in = in2 = resolver.resolveReferencesIS();
        }
        if (this.initializeOnRead) {
            this.xmlVar.initialize(null, null, true);
        }
        this.last = null;
        this.varStack = new Stack();
        this.pushNode(this.xmlVar, null, null);
        SAXParserFactory factory = RtsUtil.newSAXParserFactory();
        factory.setNamespaceAware(true);
        try {
            SAXParser saxParser = factory.newSAXParser();
            InputSource is = new InputSource(in);
            saxParser.parse(is, (DefaultHandler)this);
            if (in2 != null) {
                in2.close();
            }
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        catch (ParserConfigurationException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        catch (SAXException _ex) {
            if (_ex.getException() != null) {
                throw new IscobolRuntimeException(_ex.getException());
            }
            throw new IscobolRuntimeException(_ex);
        }
        return 1;
    }

    protected int read(Reader in) {
        this.readConfiguration();
        Reader in2 = null;
        if (this.resolveRefs) {
            XMLReferenceResolver resolver = new XMLReferenceResolver(in);
            in = in2 = resolver.resolveReferences();
        }
        if (this.initializeOnRead) {
            this.xmlVar.initialize(null, null, true);
        }
        this.last = null;
        this.varStack = new Stack();
        this.pushNode(this.xmlVar, null, null);
        SAXParserFactory factory = RtsUtil.newSAXParserFactory();
        factory.setNamespaceAware(true);
        try {
            SAXParser saxParser = factory.newSAXParser();
            InputSource is = new InputSource(in);
            saxParser.parse(is, (DefaultHandler)this);
            if (in2 != null) {
                in2.close();
            }
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        catch (ParserConfigurationException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        catch (SAXException _ex) {
            if (_ex.getException() != null) {
                throw new IscobolRuntimeException(_ex.getException());
            }
            throw new IscobolRuntimeException(_ex);
        }
        return 1;
    }

    private boolean tagcmp(IXMLAttributes c1, Attributes c2, int idx) {
        String utmp;
        String u1 = c1.getNamespace();
        String n1 = c1.getIdentifier();
        String u2 = c2.getURI(idx);
        String n2 = c2.getLocalName(idx);
        int i = n1.indexOf(58);
        if (i >= 0 && (utmp = this.globalNamespaces.get(n1.substring(0, i))) != null) {
            u1 = utmp;
            n1 = n1.substring(i + 1);
        }
        return n1.equalsIgnoreCase(n2) && u1.equals(u2);
    }

    private boolean tagcmp(String uri, String localName, Node n) {
        String utmp;
        String n1 = n.name;
        String u1 = n.uri;
        int idx = n1.indexOf(58);
        if (idx >= 0 && (utmp = this.globalNamespaces.get(n1.substring(0, idx))) != null) {
            u1 = utmp;
            n1 = n1.substring(idx + 1);
        }
        return localName.equalsIgnoreCase(n1) && uri.equals(u1);
    }

    private boolean tagcmp(String uri, String localName, IXMLAttributes c) {
        String utmp;
        String n1 = c.getIdentifier();
        String u1 = c.getNamespace();
        int idx = n1.indexOf(58);
        if (idx >= 0 && (utmp = this.globalNamespaces.get(n1.substring(0, idx))) != null) {
            u1 = utmp;
            n1 = n1.substring(idx + 1);
        }
        return localName.equalsIgnoreCase(n1) && uri.equals(u1);
    }

    protected void pushNode(ICobolVar var, int[] dim, Attributes attrs) {
        IXMLAttributes xml0 = var.getIXMLAttributes();
        Enumeration chldrn = var.getChildren();
        int[] nDim = var.getDimensions();
        if (nDim != null) {
            if (dim == null) {
                dim = new int[]{1};
            } else if (dim.length != nDim.length) {
                for (int i = 0; i < dim.length; ++i) {
                    nDim[i] = dim[i];
                }
                nDim[dim.length] = 1;
                dim = nDim;
            }
        }
        if (!(xml0 == null || xml0.isCDATA() || xml0.isProcessingInstruction() || xml0.isAttribute())) {
            Node n = this.newNode(var, dim, xml0.getNamespace(), xml0.getIdentifier());
            if (attrs != null) {
                n.attrs = new Attrs(attrs);
            }
            if (chldrn.hasMoreElements()) {
                chldrn = var.getChildren();
                while (chldrn.hasMoreElements()) {
                    ICobolVar child = (ICobolVar)chldrn.nextElement();
                    IXMLAttributes xmlA = child.getIXMLAttributes();
                    if (xmlA != null && !xml0.isCDATA() && !xml0.isProcessingInstruction()) {
                        if (xmlA.isAttribute()) {
                            if (xmlA.isFinal()) {
                                if (xmlA.getIdentifier().startsWith("xmlns:")) {
                                    String pfx = xmlA.getIdentifier().substring(6);
                                    String uri = child.toStringNoGui();
                                    this.globalNamespaces.put(pfx, uri);
                                    n.namespaces.put(pfx, uri);
                                }
                                n.finalAttr.addElement(child);
                                n.attrCount.addElement(new int[1]);
                                continue;
                            }
                            xmlA.clear();
                            n.varAttr.addElement(child);
                            continue;
                        }
                        n.next.addElement(child);
                        continue;
                    }
                    if (n.data != null || !xml0.isFinal() && child == xml0.getIdentifierVar()) continue;
                    n.data = child;
                }
            } else if (n.data == null) {
                n.data = var;
            }
            if (this.isInXmlFile) {
                XmlNode xn = (XmlNode)n;
                if (this.xmlRoot == null) {
                    this.xmlRoot = xn;
                } else if (!this.varStack.isEmpty()) {
                    XmlNode par = (XmlNode)this.varStack.peek();
                    par.children.addElement(xn);
                    xn.parent = par;
                }
            }
            this.varStack.push(n);
        }
    }

    private void set(ICobolVar var, int[] dim, String val) {
        this.set(var, dim, val, null);
    }

    private void set(ICobolVar var, int[] dim, String val, boolean[] flags) {
        ICobolVar cv = this.getVar(var, dim);
        if (cv == null) {
            return;
        }
        boolean setDefault = false;
        if (flags != null) {
            if (flags[1]) {
                byte[] b = Base64.decode(val.getBytes());
                if (b != null) {
                    cv.set(b);
                }
            } else if (flags[2]) {
                cv.set(RtsUtil.hexToBytes(val));
            } else if (flags[3]) {
                boolean b = Boolean.parseBoolean(val);
                if (cv instanceof INumericVar) {
                    cv.set(b ? 1 : 0);
                } else {
                    cv.set("" + b);
                }
            } else {
                setDefault = true;
            }
        } else {
            setDefault = true;
        }
        if (setDefault) {
            if (cv instanceof IPicNumEdit) {
                boolean[] e = new boolean[1];
                cv.set(CobolNum.valueOf(val, cv.isDecimalPointComma(), e));
                if (e[0]) {
                    cv.set(val);
                }
            } else {
                cv.set(val);
            }
        }
    }

    private ICobolVar getVar(ICobolVar var, int[] dim) {
        ICobolVar cv = null;
        if (dim == null) {
            cv = var;
        } else {
            try {
                cv = var.intIAt(dim);
            }
            catch (IscobolRuntimeException _ex) {
                if (_ex.getErrNum() != 1) {
                    throw _ex;
                }
                System.out.print("XMLOutOfBound " + var.getName() + "[");
                for (int i = 0; i < dim.length; ++i) {
                    System.out.print("" + dim[i] + " ");
                }
                System.out.println("]");
            }
        }
        return cv;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int i;
        if (this.isInXmlFile && this.schemaLocation == null) {
            for (i = 0; i < attributes.getLength(); ++i) {
                if (!"schemaLocation".equals(attributes.getLocalName(i)) && !"noNamespaceSchemaLocation".equals(attributes.getLocalName(i)) || !"http://www.w3.org/2001/XMLSchema-instance".equals(attributes.getURI(i))) continue;
                this.schemaLocation = attributes.getValue(i);
                break;
            }
        }
        if (this.varStack.isEmpty()) {
            throw new SAXException("Empty stack on start element " + qName);
        }
        Node n = this.varStack.peek();
        if (this.isInXmlFile) {
            Attrs attrs = new Attrs(attributes);
            BaseNode xn = new BaseNode(uri, localName);
            if (n.attrs != null) {
                xn.attrs = attrs;
            } else {
                n.attrs = attrs;
            }
            ((XmlNode)n).xmlChildren.addElement(xn);
        }
        if (this.last != null && this.tagcmp(uri, localName, this.last)) {
            this.varStack.push(this.last);
            ICobolVar lvp = this.last.var.getIParent();
            if (lvp != null && this.last.var.getDimensions() != lvp.getDimensions()) {
                this.last.clearData();
                int n2 = this.last.dim.length - 1;
                this.last.dim[n2] = this.last.dim[n2] + 1;
                this.last.sted = false;
                this.last = null;
                this.startElement(uri, localName, qName, attributes);
            }
        } else if (!n.sted && this.tagcmp(uri, localName, n) || !n.xml.isFinal()) {
            block1: for (i = 0; i < attributes.getLength(); ++i) {
                IXMLAttributes xmlA;
                ICobolVar child;
                int j;
                for (j = 0; j < n.finalAttr.size(); ++j) {
                    child = n.finalAttr.elementAt(j);
                    xmlA = child.getIXMLAttributes();
                    if (!this.tagcmp(xmlA, attributes, i)) continue;
                    this.set(child, n.dim, attributes.getValue(i));
                    int[] ac = n.attrCount.elementAt(j);
                    ac[0] = this.incrCount(xmlA, n.dim, ac[0]);
                    break;
                }
                if (j < n.finalAttr.size()) continue;
                for (j = 0; j < n.varAttr.size(); ++j) {
                    child = n.varAttr.elementAt(j);
                    xmlA = child.getIXMLAttributes();
                    if (xmlA.getIdentifier().length() != 0) continue;
                    xmlA.setIdentifier(attributes.getLocalName(i));
                    boolean found = false;
                    Enumeration en = child.getChildren();
                    while (en.hasMoreElements()) {
                        ICobolVar child0 = (ICobolVar)en.nextElement();
                        if (child0 == xmlA.getIdentifierVar()) continue;
                        this.set(child0, n.dim, attributes.getValue(i));
                        found = true;
                        break;
                    }
                    if (found) continue block1;
                    this.set(child, n.dim, attributes.getValue(i));
                    continue block1;
                }
            }
            if (!n.xml.isFinal()) {
                n.xml.setIdentifier(localName);
                n.xml.setNamespace(uri);
                if (n.next.size() > 0) {
                    this.pushNode(n.next.elementAt(0), n.dim, null);
                }
            }
            n.count = this.incrCount(n.xml, n.dim, n.count);
            n.sted = true;
        } else if (this.resolveRefs) {
            HashMap<String, int[]> counters = new HashMap<String, int[]>();
            String dimStr = "";
            if (n.dim != null) {
                for (int j = 0; j < n.dim.length; ++j) {
                    dimStr = dimStr + n.dim[j] + " ";
                }
            }
            for (i = 0; i < n.next.size(); ++i) {
                int[] c2;
                int[] c1;
                ICobolVar child = n.next.elementAt(i);
                IXMLAttributes xmlA = child.getIXMLAttributes();
                if (!this.tagcmp(uri, localName, xmlA) && xmlA.isFinal()) continue;
                if (this.isOccurs(child)) {
                    this.pushChildNode(localName, qName, n, uri, attributes, xmlA, child);
                    break;
                }
                if (!dimStr.equals(n.dimStr)) {
                    n.counters.clear();
                    n.dimStr = dimStr;
                }
                if ((c1 = (int[])counters.get(localName)) == null) {
                    c1 = new int[1];
                    counters.put(localName, c1);
                }
                if ((c2 = n.counters.get(localName)) == null) {
                    c2 = new int[1];
                    n.counters.put(localName, c2);
                }
                if (c1[0] == c2[0]) {
                    this.pushChildNode(localName, qName, n, uri, attributes, xmlA, child);
                    c2[0] = c2[0] + 1;
                    break;
                }
                c1[0] = c1[0] + 1;
            }
            if (i >= n.next.size()) {
                PicX x = new PicX("");
                x.setIdentifier(new PicX(localName), false);
                x.setNamespace(new PicX(uri), false);
                this.pushNode(x, null, attributes);
                this.startElement(uri, localName, qName, attributes);
            }
        } else {
            for (i = n.next.size() - 1; i >= 0; --i) {
                ICobolVar child = n.next.elementAt(i);
                IXMLAttributes xmlA = child.getIXMLAttributes();
                if (!this.tagcmp(uri, localName, xmlA) && xmlA.isFinal()) continue;
                this.pushChildNode(localName, qName, n, uri, attributes, xmlA, child);
                break;
            }
            if (i < 0) {
                PicX x = new PicX("");
                x.setIdentifier(new PicX(localName), false);
                x.setNamespace(new PicX(uri), false);
                this.pushNode(x, null, attributes);
                this.startElement(uri, localName, qName, attributes);
            }
        }
        this.last = null;
    }

    private void pushChildNode(String localName, String qName, Node n, String uri, Attributes attributes, IXMLAttributes xmlA, ICobolVar child) throws SAXException {
        if (!xmlA.isFinal()) {
            xmlA.setIdentifier(localName);
            xmlA.setNamespace(uri);
        }
        this.pushNode(child, n.dim, attributes);
        this.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.varStack.isEmpty()) {
            throw new SAXException("Empty stack on characters, last=" + this.last);
        }
        Node n = this.varStack.peek();
        n.cdata.append(ch, start, length);
    }

    private boolean isOccurs(ICobolVar var) {
        int[] dim = var.getDimensions();
        if (dim != null) {
            ICobolVar par = var.getIParent();
            int[] pdim = par != null ? par.getDimensions() : null;
            if (pdim != null) {
                return pdim.length < dim.length;
            }
            return true;
        }
        return false;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        boolean[] flags;
        ICobolVar cv;
        String href;
        if (this.varStack.isEmpty()) {
            throw new SAXException("Empty stack on end element " + qName);
        }
        Node n = this.varStack.pop();
        Iterator it = n.namespaces.keySet().iterator();
        while (it.hasNext()) {
            this.globalNamespaces.remove(it.next());
        }
        if (this.mtomEnabled && this.mtomItems != null && "Include".equals(localName) && "http://www.w3.org/2004/08/xop/include".equals(uri) && n.attrs != null && (href = n.attrs.getValue("href")) != null && href.startsWith("cid:") && (cv = this.mtomItems.get(href.substring(4))) != null && !this.varStack.isEmpty()) {
            ICobolVar data;
            Node pn = this.varStack.peek();
            flags = null;
            if (pn.xml != null) {
                flags = XMLStream.getFlags(pn.xml);
            }
            if (flags != null && (flags[1] || flags[2]) && pn.data != null && (data = this.getVar(pn.data, pn.dim)) != null) {
                data.set(cv.getBytes());
                pn.data = null;
                return;
            }
        }
        if (!this.resolveRefs || this.isOccurs(n.var)) {
            this.last = n;
        }
        if (n.data != null) {
            flags = null;
            if (n.xml != null) {
                flags = XMLStream.getFlags(n.xml);
            }
            this.set(n.data, n.dim, n.cdata.toString(), flags);
        }
    }

    public void setOutputProperty(String key, String value) {
        if (this.outputProperties == null) {
            this.outputProperties = new Properties();
        }
        this.outputProperties.setProperty(key.trim(), value.trim());
    }

    public void setPrintWriter(PrintWriter pw) {
        this.out = pw;
        this.createTransformerHandler();
    }

    public final void setOutputStream(OutputStream os) {
        this.setOutputStream(os, null);
    }

    public void setOutputStream(OutputStream os, String encoding) {
        PrintWriter pw = encoding != null ? new PrintWriter(new OutputStreamWriter(os, Charset.forName(encoding))) : new PrintWriter(os);
        this.setPrintWriter(pw);
    }

    public final void setFileName(String fn) {
        this.setFileName(fn, null);
    }

    public void setFileName(String fn, String encoding) {
        if (fn != null) {
            try {
                if (encoding != null) {
                    this.out = new PrintWriter(fn.trim(), encoding);
                }
                this.out = new PrintWriter(fn.trim());
            }
            catch (FileNotFoundException _ex) {
                throw new IscobolRuntimeException(130, _ex.getMessage());
            }
            catch (IOException _ex) {
                throw new IscobolRuntimeException(133, _ex.getMessage());
            }
        } else {
            this.out = new PrintWriter(System.out);
        }
        this.createTransformerHandler();
    }

    private void createTransformerHandler() {
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            int indentNumber = Config.getProperty(".xmlstream.indent_number", -1);
            if (indentNumber >= 0) {
                try {
                    tf.setAttribute("indent-number", String.valueOf(indentNumber));
                }
                catch (IllegalArgumentException ex) {
                    System.err.println(ex);
                }
            } else if (this.addLineFeed) {
                indentNumber = 0;
            }
            this.hd = tf.newTransformerHandler();
            Transformer serializer = this.hd.getTransformer();
            if (indentNumber >= 0) {
                serializer.setOutputProperty("indent", "yes");
            }
            if (this.outputProperties != null) {
                serializer.setOutputProperties(this.outputProperties);
            }
            if (this.isInXmlFile) {
                serializer.setOutputProperty("omit-xml-declaration", "yes");
            }
            StreamResult streamResult = new StreamResult(this.out);
            this.hd.setResult(streamResult);
        }
        catch (TransformerConfigurationException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
    }

    public TransformerHandler getTransformerHandler() {
        return this.hd;
    }

    public PrintWriter getPrintWriter() {
        if (this.out == null) {
            this.setOutputStream(System.out);
        }
        return this.out;
    }

    public final int write(String fn) {
        return this.write(fn, false, null);
    }

    public final int write(String fn, String encoding) {
        return this.write(fn, false, encoding);
    }

    public int write(String fn, boolean writeQualifiedTagNames, String encoding) {
        this.setFileName(fn, encoding);
        return this.internalWrite(writeQualifiedTagNames);
    }

    public final int writeToFile(String fn) {
        return this.write(fn, false, null);
    }

    public final int writeToFile(String fn, String encoding) {
        return this.write(fn, false, encoding);
    }

    public final int writeToFile(String fn, boolean writeQualifiedTagNames) {
        return this.write(fn, writeQualifiedTagNames, null);
    }

    public final int writeToFile(String fn, boolean writeQualifiedTagNames, String encoding) {
        return this.write(fn, writeQualifiedTagNames, encoding);
    }

    public final int writeToStream(OutputStream os) {
        return this.writeToStream(os, false, null);
    }

    public final int writeToStream(OutputStream os, boolean writeQualifiedTagNames) {
        return this.writeToStream(os, writeQualifiedTagNames, null);
    }

    public int writeToStream(OutputStream os, boolean writeQualifiedTagNames, String encoding) {
        this.setOutputStream(os, encoding);
        return this.internalWrite(writeQualifiedTagNames);
    }

    public final int writeToPrintWriter(PrintWriter pw) {
        return this.writeToPrintWriter(pw, false);
    }

    public final int writeToPrintWriter(PrintWriter pw, boolean writeQualifiedTagNames) {
        this.setPrintWriter(pw);
        return this.internalWrite(writeQualifiedTagNames);
    }

    public final int writeToStringBuffer(StringBuffer s) {
        return this.writeToStringBuffer(s, false);
    }

    public int writeToStringBuffer(StringBuffer s, boolean writeQualifiedTagNames) {
        StringWriter sw = new StringWriter();
        int rc = this.writeToPrintWriter(new PrintWriter(sw), writeQualifiedTagNames);
        s.append(sw.toString());
        return rc;
    }

    protected void readConfiguration() {
        this.omitEmptyElements = !this.isInXmlFile && Config.getProperty(".xmlstream.omit_empty_elements", true);
        this.rtrim = this.isInXmlFile || Config.getProperty(".xmlstream.rtrim", false);
        this.resolveRefs = Config.getProperty(".xmlstream.resolve_references", false);
        this.mtomEnabled = Config.getProperty("iscobol.http.mtom_enabled", false);
        this.initializeOnRead = Config.getProperty(".xmlstream.initialize_on_read", false);
    }

    public final int write() {
        return this.internalWrite(false);
    }

    public final int writeQualified() {
        return this.internalWrite(true);
    }

    protected int internalWrite(boolean writeQualifiedTagNames) {
        try {
            if (this.isInXmlFile && this.schemaLocation != null) {
                this.writeSchemaLocation = true;
            }
            if (writeQualifiedTagNames) {
                this.writeNsPrefixes = new LinkedHashMap<String, String>();
                this.fillNsPrefixTable(this.xmlVar);
            }
            this.readConfiguration();
            if (this.out == null) {
                this.setOutputStream(System.out);
            }
            try {
                this.hd.startDocument();
                this.scanElement(this.xmlRoot, this.xmlVar, null, null, 1, 0);
                this.hd.endDocument();
            }
            catch (SAXException _ex) {
                throw new IscobolRuntimeException(_ex);
            }
        }
        finally {
            this.writeNsPrefixes = null;
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
        }
        return 1;
    }

    private void fillNsPrefixTable(ICobolVar cv) {
        String namespace;
        IXMLAttributes attrs = cv.getIXMLAttributes();
        if (attrs != null && !attrs.isAttribute() && (namespace = attrs.getNamespace()) != null && namespace.length() > 0 && this.writeNsPrefixes.get(namespace) == null) {
            this.writeNsPrefixes.put(namespace, "ns" + (this.writeNsPrefixes.size() + 1));
        }
        Enumeration children = cv.getChildren();
        while (children.hasMoreElements()) {
            this.fillNsPrefixTable((ICobolVar)children.nextElement());
        }
    }

    private void scanElement(XmlNode node, ICobolVar var, int[] dim, boolean[] flags, int level, int nestedOccurs) throws SAXException {
        if (node != null) {
            var = node.var;
        }
        int[] myDim = var.getDimensions();
        if (dim == null) {
            if (myDim == null) {
                this.writeElement(node, var, dim, flags, level, nestedOccurs);
            } else {
                dim = new int[1];
                int lastDim = var.getLastDimension();
                int i = 1;
                while (i <= lastDim) {
                    dim[0] = i++;
                    this.scanElement(node, var, dim, flags, level, nestedOccurs + 1);
                }
            }
        } else if (dim.length == myDim.length) {
            this.writeElement(node, var, dim, flags, level, nestedOccurs);
        } else {
            int[] newDim = new int[myDim.length];
            for (int i = 0; i < dim.length; ++i) {
                newDim[i] = dim[i];
            }
            dim = newDim;
            int n = this.getDimension(var, dim, myDim[myDim.length - 1]);
            int i = 1;
            while (i <= n) {
                dim[myDim.length - 1] = i++;
                this.scanElement(node, var, dim, flags, level, nestedOccurs + 1);
            }
        }
    }

    protected int getDimension(ICobolVar var, int[] dim, int n) {
        if (this.omitEmptyElements && dim.length > 1 && var.isInDynamicTable()) {
            int[] tmp = new int[dim.length - 1];
            System.arraycopy(dim, 0, tmp, 0, tmp.length);
            n = var.getDynamicCapacity(tmp, true);
        }
        return n;
    }

    private boolean isEmpty0(String s) {
        if (this.rtrim) {
            s = s.trim();
        }
        return s.length() == 0;
    }

    protected boolean isEmpty(ICobolVar var, int[] dim) {
        Enumeration chldrn = var.getChildren();
        if (!chldrn.hasMoreElements()) {
            int[] varDim = var.getDimensions();
            if (varDim == null) {
                return this.isEmpty0(var.toStringNoGui());
            }
            if (dim == null) {
                return varDim[0] == 0;
            }
            if (dim.length == varDim.length) {
                return this.isEmpty0(var.intIAt(dim).toStringNoGui());
            }
            if (dim.length < varDim.length) {
                int[] dim0 = new int[dim.length + 1];
                System.arraycopy(dim, 0, dim0, 0, dim.length);
                int n = var.isInDynamicTable() ? var.getDynamicCapacity(dim, true) : varDim[dim.length];
                int j = 1;
                while (j <= n) {
                    dim0[dim.length] = j++;
                    if (this.isEmpty(var, dim0)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        while (chldrn.hasMoreElements()) {
            ICobolVar child = (ICobolVar)chldrn.nextElement();
            if (this.isEmpty(child, dim)) continue;
            return false;
        }
        return true;
    }

    private void writeElement(XmlNode node, ICobolVar var, int[] dim, boolean[] flags, int level, int nestedOccurs) throws SAXException {
        this.writeElement(node, var, dim, flags, level, nestedOccurs, new AttributesImpl());
    }

    private void writeElement(XmlNode node, ICobolVar var, int[] dim, boolean[] flags, int level, int nestedOccurs, AttributesImpl atts) throws SAXException {
        if (node != null) {
            this.writeElement(node, dim, flags, level, nestedOccurs, atts);
        } else {
            this.writeElement(var, dim, flags, level, nestedOccurs, atts);
            if (this.resolveRefs && level == 3) {
                while (!this.deferredElements.isEmpty()) {
                    this.deferredElements.remove(0).write();
                }
            }
        }
    }

    private static boolean[] getFlags(IXMLAttributes xmlAttrs) {
        return new boolean[]{xmlAttrs.isRaw(), xmlAttrs.isBase64Binary(), xmlAttrs.isHexBinary(), xmlAttrs.isBoolean()};
    }

    private static boolean[] getFlags(boolean[] or, IXMLAttributes xmlAttrs) {
        return new boolean[]{or[0] || xmlAttrs.isRaw(), or[1] || xmlAttrs.isBase64Binary(), or[2] || xmlAttrs.isHexBinary(), or[3] || xmlAttrs.isBoolean()};
    }

    private void writeElement(ICobolVar var, int[] dim, boolean[] flags, int level, int nestedOccurs, AttributesImpl atts) throws SAXException {
        block22: {
            boolean started;
            String namespace;
            IXMLAttributes xml0;
            block24: {
                String attr;
                IXMLAttributes xmlA;
                ICobolVar child;
                Enumeration chldrn;
                block23: {
                    int idx;
                    Object id0;
                    chldrn = var.getChildren();
                    xml0 = var.getIXMLAttributes();
                    if (xml0 == null || xml0.isCDATA() || xml0.isProcessingInstruction()) break block22;
                    if (xml0.isAttribute()) {
                        return;
                    }
                    if (this.writeSchemaLocation) {
                        atts.addAttribute(null, "xsi", "xmlns:xsi", "CDATA", "http://www.w3.org/2001/XMLSchema-instance");
                        atts.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation", "xsi:noNamespaceSchemaLocation", "CDATA", this.schemaLocation);
                        this.writeSchemaLocation = false;
                    }
                    namespace = xml0.getNamespace();
                    flags = flags == null ? XMLStream.getFlags(xml0) : XMLStream.getFlags(flags, xml0);
                    started = false;
                    chldrn = var.getChildren();
                    while (chldrn.hasMoreElements()) {
                        child = (ICobolVar)chldrn.nextElement();
                        xmlA = child.getIXMLAttributes();
                        attr = "";
                        if (xmlA == null || !xmlA.isAttribute()) continue;
                        Enumeration nephews = child.getChildren();
                        while (nephews.hasMoreElements()) {
                            child = (ICobolVar)nephews.nextElement();
                        }
                        if (dim != null && dim.length == child.getDimensions().length) {
                            child = child.intIAt(dim);
                        }
                        if ((attr = child.toStringNoGui()).length() <= 0) continue;
                        String id = xmlA.getIdentifier();
                        String ns = xmlA.getNamespace();
                        if (this.resolveRefs && level == 1 && id.startsWith("xmlns:")) {
                            this.globalNamespaces.put(id.substring(6), attr);
                        }
                        if (ns.length() > 0 && !ns.equals(namespace)) {
                            if ("http://www.w3.org/XML/1998/namespace".equals(ns)) {
                                atts.addAttribute(ns, id, "xml:" + id, "CDATA", attr);
                                continue;
                            }
                            if ("http://www.w3.org/2000/xmlns/".equals(ns)) {
                                atts.addAttribute(ns, id, "xmlns:" + id, "CDATA", attr);
                                continue;
                            }
                            String prfx = "ns" + ++this.prog;
                            atts.addAttribute("", "", "xmlns:" + prfx, "CDATA", ns);
                            atts.addAttribute(ns, id, prfx + ":" + id, "CDATA", attr);
                            continue;
                        }
                        atts.addAttribute(ns, id, id, "CDATA", attr);
                    }
                    if (!(!this.resolveRefs || level != 1 || ((String)(id0 = xml0.getIdentifier())).endsWith("Envelope") && (idx = ((String)id0).indexOf(58)) >= 0 && "http://schemas.xmlsoap.org/soap/envelope/".equals(this.globalNamespaces.get(((String)id0).substring(0, idx))))) {
                        this.resolveRefs = false;
                    }
                    if (this.writeNsPrefixes != null && level == 1 && !this.resolveRefs) {
                        for (String ns : this.writeNsPrefixes.keySet()) {
                            String pfx = this.writeNsPrefixes.get(ns);
                            atts.addAttribute("", "", "xmlns:" + pfx, "CDATA", ns);
                        }
                    }
                    if (atts.getLength() > 0) {
                        this.hd_startElement(xml0, namespace, atts);
                        started = true;
                    }
                    if ((chldrn = var.getChildren()).hasMoreElements()) break block23;
                    xmlA = var.getIXMLAttributes();
                    if (dim != null && var.getDimensions() == null) break block24;
                    ICobolVar cv = dim == null ? var : var.intIAt(dim);
                    attr = cv.toStringNoGui();
                    if (this.omitEmptyElements && this.isEmpty0(attr)) break block24;
                    if (!started) {
                        this.hd_startElement(xml0, namespace, atts);
                        started = true;
                    }
                    this.characters(cv, xml0, namespace, attr, xmlA, flags);
                    break block24;
                }
                while (chldrn.hasMoreElements()) {
                    int idx;
                    child = (ICobolVar)chldrn.nextElement();
                    xmlA = child.getIXMLAttributes();
                    if (xmlA == null || xmlA.isCDATA() || xmlA.isProcessingInstruction()) {
                        if (dim != null && child.getDimensions() == null) continue;
                        ICobolVar cv = dim == null ? child : child.intIAt(dim);
                        attr = cv.toStringNoGui();
                        if (this.omitEmptyElements && this.isEmpty0(attr)) continue;
                        if (!started) {
                            this.hd_startElement(xml0, namespace, atts);
                            started = true;
                        }
                        this.characters(cv, xml0, namespace, attr, xmlA, flags);
                        continue;
                    }
                    if (xmlA.isAttribute()) continue;
                    String idA = xmlA.getIdentifier();
                    boolean nestedSoapArray = this.resolveRefs && nestedOccurs > 0 && idA.endsWith("Array") && (idx = idA.indexOf(58)) >= 0 && "http://schemas.xmlsoap.org/soap/encoding/".equals(this.globalNamespaces.get(idA.substring(0, idx)));
                    String href = null;
                    boolean[] localFlags = flags == null ? XMLStream.getFlags(xmlA) : XMLStream.getFlags(flags, xmlA);
                    if (!started) {
                        if (this.omitEmptyElements && this.isEmpty(var, dim)) {
                            return;
                        }
                        if (nestedSoapArray) {
                            href = "itemId" + ++this.prog;
                            atts.addAttribute("", "", "href", "CDATA", "#" + href);
                        }
                        this.hd_startElement(xml0, namespace, atts);
                        started = true;
                    }
                    if (nestedSoapArray) {
                        this.deferredElements.add(new DeferredElement(child, dim, localFlags, href));
                        continue;
                    }
                    this.scanElement(null, child, dim, localFlags, level + 1, nestedOccurs);
                }
            }
            if (started) {
                this.hd_endElement(xml0, namespace);
            }
        }
    }

    private void writeElement(XmlNode node, int[] dim, boolean[] flags, int level, int nestedOccurs, AttributesImpl atts) throws SAXException {
        IXMLAttributes xml0;
        Vector<ICobolVar> attrs;
        ICobolVar var = node.var;
        Vector<XmlNode> chldrn = node.newChildren;
        if (chldrn == null) {
            chldrn = new Vector();
        }
        if ((attrs = node.newAttr) == null) {
            attrs = new Vector();
            if (node == this.xmlRoot) {
                attrs.addAll(node.varAttr);
                attrs.addAll(node.finalAttr);
            }
        }
        if ((xml0 = node.xml) != null && !xml0.isCDATA() && !xml0.isProcessingInstruction()) {
            String attr;
            IXMLAttributes xmlA;
            ICobolVar child;
            int i;
            if (xml0.isAttribute()) {
                return;
            }
            String namespace = xml0.getNamespace();
            if (this.writeSchemaLocation) {
                atts.addAttribute(null, "xsi", "xmlns:xsi", "CDATA", "http://www.w3.org/2001/XMLSchema-instance");
                if (namespace != null && namespace.length() > 0) {
                    atts.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "xsi:schemaLocation", "CDATA", namespace + " " + this.schemaLocation);
                } else {
                    atts.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation", "xsi:noNamespaceSchemaLocation", "CDATA", this.schemaLocation);
                }
                this.writeSchemaLocation = false;
            }
            flags = flags == null ? XMLStream.getFlags(xml0) : XMLStream.getFlags(flags, xml0);
            boolean started = false;
            int childCount = attrs.size();
            for (i = 0; i < childCount; ++i) {
                child = attrs.elementAt(i);
                xmlA = child.getIXMLAttributes();
                attr = "";
                if (xmlA == null || !xmlA.isAttribute() || (attr = child.toStringNoGui()).length() <= 0) continue;
                String id = xmlA.getIdentifier();
                String ns = xmlA.getNamespace();
                atts.addAttribute(ns, id, id, "CDATA", Factory.rightTrim(attr));
            }
            if (atts.getLength() > 0) {
                this.hd_startElement(xml0, namespace, atts);
                started = true;
            }
            if ((childCount = chldrn.size()) == 0) {
                xmlA = var.getIXMLAttributes();
                attr = var.toStringNoGui();
                if (!this.omitEmptyElements || !this.isEmpty0(attr)) {
                    if (!started) {
                        this.hd_startElement(xml0, namespace, atts);
                        started = true;
                    }
                    this.characters(var, xml0, namespace, attr, xmlA, flags);
                }
            } else {
                for (i = 0; i < childCount; ++i) {
                    XmlNode childNode = chldrn.elementAt(i);
                    child = childNode.var;
                    xmlA = childNode.xml;
                    if (xmlA == null || xmlA.isCDATA() || xmlA.isProcessingInstruction()) {
                        attr = var.toStringNoGui();
                        if (this.omitEmptyElements && this.isEmpty0(attr)) continue;
                        if (!started) {
                            this.hd_startElement(xml0, namespace, atts);
                            started = true;
                        }
                        this.characters(var, xml0, namespace, attr, xmlA, flags);
                        continue;
                    }
                    boolean[] localFlags = flags == null ? XMLStream.getFlags(xmlA) : XMLStream.getFlags(flags, xmlA);
                    if (!started) {
                        if (this.omitEmptyElements && this.isEmpty(var, dim)) {
                            return;
                        }
                        this.hd_startElement(xml0, namespace, atts);
                        started = true;
                    }
                    this.scanElement(childNode, null, dim, localFlags, level + 1, nestedOccurs);
                }
            }
            if (started) {
                this.hd_endElement(xml0, namespace);
            }
        }
    }

    private void characters(ICobolVar cv, IXMLAttributes xml0, String namespace, String attr, IXMLAttributes xmlA, boolean[] flags) throws SAXException {
        if (this.mtomEnabled && flags != null && (flags[1] || flags[2])) {
            AttributesImpl a = new AttributesImpl();
            String key = "attachment-" + (this.mtomItems.size() + 1);
            this.mtomItems.put(key, cv);
            a.addAttribute("", "", "href", "CDATA", "cid:" + key);
            this.hd.startElement("http://www.w3.org/2004/08/xop/include", "Include", "Include", a);
            this.hd_endElement(xml0, namespace);
        } else {
            this.characters(attr, cv.getBytes(), xmlA, flags, cv instanceof INumericVar);
        }
    }

    private void hd_startElement(IXMLAttributes xml0, String namespace, AttributesImpl atts) throws SAXException {
        String qId;
        String id = xml0.getIdentifier();
        if (this.writeNsPrefixes != null) {
            if (namespace != null && namespace.length() > 0) {
                qId = this.writeNsPrefixes.get(namespace) + ":" + id;
                namespace = "";
            } else {
                qId = id;
            }
        } else {
            qId = id;
            if (xml0.hasExplicitNs() && "".equals(namespace)) {
                atts.addAttribute(namespace, id, "xmlns", "CDATA", "");
            }
        }
        this.hd.startElement(namespace, id, qId, atts);
    }

    private void hd_endElement(IXMLAttributes xml0, String namespace) throws SAXException {
        String qId;
        String id = xml0.getIdentifier();
        if (this.writeNsPrefixes != null) {
            if (namespace != null && namespace.length() > 0) {
                qId = this.writeNsPrefixes.get(namespace) + ":" + id;
                namespace = "";
            } else {
                qId = id;
            }
        } else {
            qId = id;
        }
        this.hd.endElement(namespace, id, qId);
    }

    private void characters(String attr, byte[] b, IXMLAttributes xmlA, boolean[] flags, boolean isNumeric) throws SAXException {
        int i;
        int len = 0;
        boolean raw = false;
        boolean base64Binary = false;
        boolean hexBinary = false;
        boolean isBoolean = false;
        if (flags != null) {
            raw = flags[0];
            base64Binary = flags[1];
            hexBinary = flags[2];
            isBoolean = flags[3];
        }
        if (this.rtrim) {
            if (base64Binary || hexBinary) {
                len = b.length;
                for (i = b.length - 1; i >= 0 && b[i] == 32; --i) {
                    --len;
                }
            } else {
                attr = Factory.rightTrim(attr);
            }
        } else if (base64Binary || hexBinary) {
            len = b.length;
        }
        if (raw) {
            this.hd.processingInstruction("javax.xml.transform.disable-output-escaping", null);
            this.hd.characters(attr.toCharArray(), 0, attr.length());
            this.hd.processingInstruction("javax.xml.transform.enable-output-escaping", null);
        } else if (base64Binary) {
            attr = new String(Base64.encode(b, 0, len));
            this.hd.characters(attr.toCharArray(), 0, attr.length());
        } else if (hexBinary) {
            attr = RtsUtil.bytesToHex(b, 0, len);
            this.hd.characters(attr.toCharArray(), 0, attr.length());
        } else if (isBoolean) {
            if (isNumeric) {
                try {
                    i = Integer.parseInt(attr);
                    attr = i != 0 ? "true" : "false";
                }
                catch (NumberFormatException ex) {
                    attr = "false";
                }
            } else {
                attr = "" + Boolean.parseBoolean(attr.trim());
            }
            this.hd.characters(attr.toCharArray(), 0, attr.length());
        } else if (xmlA != null && xmlA.isCDATA()) {
            this.hd.startCDATA();
            this.hd.characters(attr.toCharArray(), 0, attr.length());
            this.hd.endCDATA();
        } else if (xmlA != null && xmlA.isProcessingInstruction()) {
            attr = "<?" + attr + "?>";
            this.hd.processingInstruction("javax.xml.transform.disable-output-escaping", null);
            this.hd.characters(attr.toCharArray(), 0, attr.length());
            this.hd.processingInstruction("javax.xml.transform.enable-output-escaping", null);
        } else {
            this.hd.characters(attr.toCharArray(), 0, attr.length());
        }
    }

    public Map<String, ICobolVar> getMtomItems() {
        return this.mtomItems;
    }

    public void setMtomItems(Map<String, ICobolVar> map) {
        this.mtomItems = map;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public boolean startKey(ICobolVar key, int index) {
        IXMLAttributes xmlA;
        if (!this.isInXmlFile || this.xmlRoot == null || (xmlA = key.getIXMLAttributes()) == null || index < 1) {
            return false;
        }
        XmlNode n = this.findNode(this.xmlRoot, key, xmlA.isAttribute());
        if (n != null) {
            this.startNode = n;
            this.startNodeIndex = index;
            this.startNodeAttr = xmlA.isAttribute();
            return true;
        }
        return false;
    }

    public boolean rewriteKey(ICobolVar key) {
        IXMLAttributes xmlA;
        if (!this.isInXmlFile || this.xmlRoot == null || (xmlA = key.getIXMLAttributes()) == null) {
            return false;
        }
        XmlNode n = this.findNode(this.xmlRoot, key, xmlA.isAttribute());
        if (n != null) {
            Vector<XmlNode> path = new Vector<XmlNode>();
            XmlNode n0 = n;
            while (n0 != this.xmlRoot) {
                path.add(0, n0);
                n0 = n0.parent;
            }
            XmlNode newNode = (XmlNode)this.modifyNode(this.xmlRoot, path, 0, key, xmlA.isAttribute(), false);
            if (!xmlA.isAttribute()) {
                this.addNewChildren(newNode, key);
            }
            return true;
        }
        return false;
    }

    public boolean deleteKey(ICobolVar key) {
        IXMLAttributes xmlA;
        if (!this.isInXmlFile || this.xmlRoot == null || (xmlA = key.getIXMLAttributes()) == null) {
            return false;
        }
        XmlNode n = this.findNode(this.xmlRoot, key, xmlA.isAttribute());
        if (n != null) {
            Vector<XmlNode> path = new Vector<XmlNode>();
            XmlNode n0 = n;
            while (n0 != this.xmlRoot) {
                path.add(0, n0);
                n0 = n0.parent;
            }
            this.modifyNode(this.xmlRoot, path, 0, key, xmlA.isAttribute(), true);
            return true;
        }
        return false;
    }

    public boolean writeKey(ICobolVar key, boolean all) {
        IXMLAttributes xmlA;
        if (!this.isInXmlFile || this.xmlRoot == null || (xmlA = key.getIXMLAttributes()) == null) {
            return false;
        }
        boolean isAttr = xmlA.isAttribute();
        XmlNode n = this.findNode(this.xmlRoot, key, isAttr);
        if (n != null) {
            Vector<XmlNode> path = new Vector<XmlNode>();
            XmlNode n0 = n;
            while (n0 != this.xmlRoot) {
                path.add(0, n0);
                n0 = n0.parent;
            }
            XmlNode newNode = (XmlNode)this.addNode(this.xmlRoot, path, 0, key, isAttr);
            if (all && !isAttr) {
                this.addNewChildren(newNode, key);
            }
            return true;
        }
        return false;
    }

    private Node modifyNode(XmlNode parent, Vector<XmlNode> path, int idx, ICobolVar key, boolean attr, boolean delete) {
        XmlNode n = path.elementAt(idx);
        int end = path.size() - 1;
        if (attr) {
            ++end;
        }
        if (idx < end) {
            int i;
            String id = n.xml.getIdentifier();
            if (parent.newChildren == null) {
                parent.newChildren = new Vector();
            }
            for (i = parent.newChildren.size() - 1; i >= 0; --i) {
                XmlNode c = parent.newChildren.elementAt(i);
                if (c.xml.getIdentifier().equals(id)) break;
            }
            if (i >= 0) {
                n = parent.newChildren.elementAt(i);
                if (attr && idx == end - 1) {
                    if (n.newAttr != null) {
                        String attrName = key.getIXMLAttributes().getIdentifier();
                        for (i = n.newAttr.size() - 1; i >= 0; --i) {
                            if (!n.newAttr.elementAt(i).getIXMLAttributes().getIdentifier().equals(attrName)) continue;
                            if (delete) {
                                n.newAttr.removeElementAt(i);
                                break;
                            }
                            n.newAttr.setElementAt(key.xmlClone(), i);
                            break;
                        }
                    }
                    return null;
                }
                return this.modifyNode(n, path, idx + 1, key, attr, delete);
            }
            return null;
        }
        if (parent.newChildren != null) {
            String tagName = key.getIXMLAttributes().getIdentifier();
            for (int i = parent.newChildren.size() - 1; i >= 0; --i) {
                if (!parent.newChildren.elementAt((int)i).xml.getIdentifier().equals(tagName)) continue;
                if (delete) {
                    parent.newChildren.removeElementAt(i);
                    return null;
                }
                n = this.newXmlNode(key.xmlClone());
                parent.newChildren.setElementAt(n, i);
                return n;
            }
        }
        return null;
    }

    private Node addNode(XmlNode parent, Vector<XmlNode> path, int idx, ICobolVar key, boolean attr) {
        XmlNode n = path.elementAt(idx);
        int end = path.size() - 1;
        if (attr) {
            ++end;
        }
        if (idx < end) {
            int i;
            String id = n.xml.getIdentifier();
            if (parent.newChildren == null) {
                parent.newChildren = new Vector();
            }
            for (i = parent.newChildren.size() - 1; i >= 0; --i) {
                XmlNode c = parent.newChildren.elementAt(i);
                if (c.xml.getIdentifier().equals(id)) break;
            }
            if (i >= 0) {
                n = parent.newChildren.elementAt(i);
            } else {
                n = this.newXmlNode(n.var.xmlClone());
                parent.newChildren.addElement(n);
            }
            if (attr && idx == end - 1) {
                if (n.newAttr == null) {
                    n.newAttr = new Vector();
                }
                n.newAttr.addElement(key.xmlClone());
                return null;
            }
            return this.addNode(n, path, idx + 1, key, attr);
        }
        if (parent.newChildren == null) {
            parent.newChildren = new Vector();
        }
        n = this.newXmlNode(key.xmlClone());
        parent.newChildren.addElement(n);
        return n;
    }

    private void addNewChildren(XmlNode n, ICobolVar cv) {
        if (n.newAttr == null) {
            n.newAttr = new Vector();
        }
        for (ICobolVar a : n.varAttr) {
            n.newAttr.addElement(a.xmlClone());
        }
        for (ICobolVar a : n.finalAttr) {
            n.newAttr.addElement(a.xmlClone());
        }
        Enumeration en = cv.getChildren();
        while (en.hasMoreElements()) {
            ICobolVar child = (ICobolVar)en.nextElement();
            XmlNode newNode = this.newXmlNode(child.xmlClone());
            n.newChildren.addElement(newNode);
            this.addNewChildren(newNode, child);
        }
    }

    public int readKey(ICobolVar key) {
        if (this.readKey(key, this.startNode, this.startNodeIndex, this.startNodeAttr)) {
            return this.startNodeIndex++;
        }
        return 0;
    }

    private boolean readKey(ICobolVar key, XmlNode startNode, int startNodeIndex, boolean startNodeAttr) {
        IXMLAttributes xmlA;
        if (!this.isInXmlFile || this.xmlRoot == null || (xmlA = key.getIXMLAttributes()) == null) {
            return false;
        }
        XmlNode n = this.findNode(this.xmlRoot, key, xmlA.isAttribute());
        if (n != null) {
            if (n != startNode) {
                startNode = n;
                startNodeIndex = 1;
                startNodeAttr = xmlA.isAttribute();
            }
            if (startNodeAttr) {
                if (startNodeIndex <= startNode.attrs.getLength()) {
                    xmlA.setIdentifier(startNode.attrs.getLocalName(startNodeIndex - 1));
                    boolean found = false;
                    Enumeration en = key.getChildren();
                    while (en.hasMoreElements()) {
                        ICobolVar child0 = (ICobolVar)en.nextElement();
                        if (child0 == xmlA.getIdentifierVar()) continue;
                        this.set(child0, n.dim, startNode.attrs.getValue(startNodeIndex - 1));
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.set(key, n.dim, startNode.attrs.getValue(startNodeIndex - 1));
                    }
                    return true;
                }
            } else if (startNodeIndex <= startNode.xmlChildren.size()) {
                IXMLAttributes xml0;
                ICobolVar child0;
                BaseNode xn = startNode.xmlChildren.elementAt(startNodeIndex - 1);
                xmlA.setIdentifier(xn.name);
                boolean found = false;
                Enumeration en = key.getChildren();
                while (en.hasMoreElements()) {
                    child0 = (ICobolVar)en.nextElement();
                    xml0 = child0.getIXMLAttributes();
                    if (child0 == xmlA.getIdentifierVar() || xml0 != null && xml0.isAttribute()) continue;
                    this.set(child0, n.dim, startNode.cdata.toString());
                    found = true;
                    break;
                }
                if (!found) {
                    this.set(key, n.dim, startNode.cdata.toString());
                }
                en = key.getChildren();
                block2: while (en.hasMoreElements()) {
                    child0 = (ICobolVar)en.nextElement();
                    xml0 = child0.getIXMLAttributes();
                    if (xml0 == null) continue;
                    if (xml0.isAttribute()) {
                        int len = startNode.attrs.getLength();
                        for (int i = 0; i < len; ++i) {
                            if (!startNode.attrs.getLocalName(i).equals(xml0.getIdentifier())) continue;
                            this.set(child0, n.dim, startNode.attrs.getValue(i));
                            continue block2;
                        }
                        continue;
                    }
                    this.readKey(child0, null, 1, false);
                }
                return true;
            }
        }
        return false;
    }

    private XmlNode findNode(XmlNode n, ICobolVar key, boolean isAttribute) {
        if (isAttribute) {
            for (ICobolVar vAttr : n.finalAttr) {
                if (vAttr != key) continue;
                return n;
            }
            for (ICobolVar vAttr : n.varAttr) {
                if (vAttr != key) continue;
                return n;
            }
        } else if (n.var == key) {
            return n;
        }
        for (XmlNode c : n.children) {
            XmlNode ret = this.findNode(c, key, isAttribute);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private int incrCount(IXMLAttributes xml, int[] dim, int count) {
        ++count;
        ICobolVar countVar = xml.getCount();
        if (countVar != null) {
            if (dim != null && dim.length > 1) {
                int[] countDim = new int[dim.length - 1];
                System.arraycopy(dim, 0, countDim, 0, countDim.length);
                countVar = countVar.intIAt(countDim);
            }
            countVar.set(count);
        }
        return count;
    }

    private Node newNode(ICobolVar cv, int[] d, String ns, String ln) {
        if (this.isInXmlFile) {
            return new XmlNode(cv, d, ns, ln);
        }
        return new Node(cv, d, ns, ln);
    }

    private XmlNode newXmlNode(ICobolVar cv) {
        return new XmlNode(cv, null, null, null);
    }

    private static class XmlNode
    extends Node {
        Vector<BaseNode> xmlChildren = new Vector();
        XmlNode parent;
        final Vector<XmlNode> children = new Vector();
        Vector<XmlNode> newChildren;
        Vector<ICobolVar> newAttr;

        XmlNode(String ns, String ln) {
            super(null, null, ns, ln);
        }

        XmlNode(ICobolVar cv, int[] d, String ns, String ln) {
            super(cv, d, ns, ln);
        }
    }

    private static class Node
    extends BaseNode {
        StringBuffer cdata = new StringBuffer();
        final ICobolVar var;
        final int[] dim;
        final Vector<ICobolVar> finalAttr = new Vector();
        final Vector<ICobolVar> varAttr = new Vector();
        final Vector<ICobolVar> next = new Vector();
        ICobolVar data;
        final IXMLAttributes xml;
        boolean sted;
        Map namespaces = new HashMap();
        Map<String, int[]> counters = new HashMap<String, int[]>();
        String dimStr = "";
        int count;
        final Vector<int[]> attrCount = new Vector();

        Node(ICobolVar cv, int[] d, String ns, String ln) {
            super(ns, ln);
            this.var = cv;
            this.dim = d;
            this.xml = cv.getIXMLAttributes();
        }

        void clearData() {
            this.cdata = new StringBuffer();
        }
    }

    private static class BaseNode {
        final String uri;
        final String name;
        Attrs attrs;

        BaseNode(String ns, String ln) {
            this.uri = ns;
            this.name = ln;
        }
    }

    private static class Attrs {
        final String[] names;
        final String[] values;

        Attrs(Attributes a) {
            if (a != null) {
                int len = a.getLength();
                this.names = new String[len];
                this.values = new String[len];
                for (int i = 0; i < len; ++i) {
                    this.names[i] = a.getLocalName(i);
                    this.values[i] = a.getValue(i);
                }
            } else {
                this.names = new String[0];
                this.values = new String[0];
            }
        }

        int getLength() {
            return this.names.length;
        }

        String getLocalName(int i) {
            return this.names[i];
        }

        String getValue(int i) {
            return this.values[i];
        }

        String getValue(String n) {
            for (int i = 0; i < this.names.length; ++i) {
                if (!this.names[i].equals(n)) continue;
                return this.values[i];
            }
            return null;
        }
    }

    private class DeferredElement {
        ICobolVar var;
        int[] dim;
        boolean[] flags;
        String href;

        DeferredElement(ICobolVar var, int[] dim, boolean[] flags, String href) {
            this.var = var;
            if (dim != null) {
                this.dim = new int[dim.length];
                System.arraycopy(dim, 0, this.dim, 0, dim.length);
            }
            this.flags = flags;
            this.href = href;
        }

        void write() throws SAXException {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "", "id", "CDATA", this.href);
            XMLStream.this.writeElement(null, this.var, this.dim, this.flags, 5, 0, atts);
        }
    }

    private static class XMLReferenceResolver {
        private Document document;

        XMLReferenceResolver(Reader in) {
            DocumentBuilderFactory factory = RtsUtil.newDocumentBuilderFactory();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                InputSource is = new InputSource(in);
                this.document = builder.parse(is);
            }
            catch (ParserConfigurationException e) {
                throw new IscobolRuntimeException(e);
            }
            catch (SAXException e) {
                throw new IscobolRuntimeException(e);
            }
            catch (IOException e) {
                throw new IscobolRuntimeException(e);
            }
        }

        InputStream resolveReferencesIS() {
            Element rootElement = this.document.getDocumentElement();
            this.resolveReferences(rootElement, new int[]{0});
            TransformerFactory transformerFactory = SAXTransformerFactory.newInstance();
            try {
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(this.document);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                StreamResult result = new StreamResult(new OutputStreamWriter(out));
                transformer.transform(source, result);
                out.close();
                return new ByteArrayInputStream(out.toByteArray());
            }
            catch (IOException e) {
                throw new IscobolRuntimeException(e);
            }
            catch (TransformerException e) {
                throw new IscobolRuntimeException(e);
            }
        }

        Reader resolveReferences() {
            Element rootElement = this.document.getDocumentElement();
            this.resolveReferences(rootElement, new int[]{0});
            TransformerFactory transformerFactory = SAXTransformerFactory.newInstance();
            try {
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(this.document);
                StringWriter sw = new StringWriter();
                StreamResult result = new StreamResult(sw);
                transformer.transform(source, result);
                return new StringReader(sw.toString());
            }
            catch (TransformerException e) {
                throw new IscobolRuntimeException(e);
            }
        }

        void resolveReferences(Element element, int[] idxs) {
            String href = element.getAttribute("href");
            if (href != null && href.startsWith("#")) {
                href = href.substring(1);
                int[] newIdxs = new int[idxs.length];
                System.arraycopy(idxs, 0, newIdxs, 0, idxs.length);
                Element elemById = this.getElementById((Element)element.getParentNode(), href, newIdxs);
                if (elemById != null) {
                    elemById.removeAttribute("id");
                    String tagName = elemById.getTagName();
                    int idx = tagName.indexOf(58);
                    if (idx >= 0) {
                        tagName = tagName.substring(idx + 1);
                        this.document.renameNode(elemById, null, tagName);
                    }
                    element.getParentNode().replaceChild(elemById, element);
                    this.resolveReferences(elemById, idxs);
                }
            }
            NodeList childNodes = element.getChildNodes();
            int[] newIdxs = new int[idxs.length + 1];
            System.arraycopy(idxs, 0, newIdxs, 0, idxs.length);
            for (int i = 0; i < childNodes.getLength(); ++i) {
                newIdxs[idxs.length] = i;
                org.w3c.dom.Node node = childNodes.item(i);
                if (node.getNodeType() != 1) continue;
                this.resolveReferences((Element)node, newIdxs);
            }
        }

        Element getElementById(Element element, String id, int[] idxs) {
            NodeList nodes = element.getChildNodes();
            int len = nodes.getLength();
            for (int i = idxs[idxs.length - 1] + 1; i < len; ++i) {
                Element elem2;
                org.w3c.dom.Node node = nodes.item(i);
                if (node.getNodeType() != 1 || (elem2 = this.getElementById((Element)node, id)) == null) continue;
                return elem2;
            }
            int[] newIdxs = new int[idxs.length - 1];
            System.arraycopy(idxs, 0, newIdxs, 0, newIdxs.length);
            return this.getElementById((Element)element.getParentNode(), id, newIdxs);
        }

        Element getElementById(Element element, String id) {
            if (id.equals(element.getAttribute("id"))) {
                return element;
            }
            NodeList nodes = element.getChildNodes();
            int len = nodes.getLength();
            for (int i = 0; i < len; ++i) {
                Element elem2;
                org.w3c.dom.Node node = nodes.item(i);
                if (node.getNodeType() != 1 || (elem2 = this.getElementById((Element)node, id)) == null) continue;
                return elem2;
            }
            return null;
        }
    }
}

