/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.as.AppServerImpl;
import com.iscobol.as.ClientInfo;
import com.iscobol.as.ClientInfoRC;
import com.iscobol.gui.AppFactory;
import com.iscobol.interfaces.debugger.IDebuggerExtension2;
import com.iscobol.io.IndexFile;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.ContextEnv;
import com.iscobol.rts.HTTPSessionInfo;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.StickyConfig;
import com.iscobol.rts.StopRunException;
import com.iscobol.rts.Version;
import com.license4j.ActivationStatus;
import com.license4j.HardwareID;
import com.license4j.License;
import com.license4j.LicenseValidator;
import com.license4j.ValidationStatus;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public final class Config
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String propFile;
    private StickyConfig sticky;
    public static final String ISCOBOL = "iscobol.";
    private static String PREFIX;
    private static String PREFIX_ND;
    public static final String NOLOG_SUFFIX = " $$";
    public static final String filesep;
    public static final String systemDir;
    private static boolean clientTask;
    private static boolean shouldStartDebugListener;
    private static byte[] staticProps;
    private Properties personalProps = new Properties();
    private Logger log;
    private PropertyChangeSupport changeListeners;
    private static byte[] e;
    private static byte[] f;
    private static final byte[] a;
    private static final byte[] E;
    private static final byte[] F;
    private static final byte[] ni;
    private static byte[] n;
    private static final byte[] d;
    private static final byte[] qi;
    private static byte[] q;
    private static final byte[] m;
    private static byte[] d1;
    private static String sd1;
    private static byte[] d2;
    private static byte[] d3;
    private static byte[] pi;
    private static byte[] pic;
    private static byte[] pie;
    private static byte[] piea;
    private static byte[] pe;
    private static byte[] pv;
    private static byte[] lc;
    private static byte[] dli;
    private static byte[] uh;
    private static byte[] cL;
    private static byte[] cC;
    private static byte[] cDt;
    private static final byte[] errgeneric;
    private static String[] err;
    private static char[] val;
    private static char[] use;
    private static String spiR;
    private static String speR;
    private static String spvR;
    private static int[] mas;
    private static String eol;
    private static final byte[] mas1;
    private static final byte[] mas2;
    private static int mas3;
    private static final byte[] wc1;
    private static final byte[] wc2;
    private static final byte[] suff;
    private static final byte[] suffC;
    private static final byte[] suffEa;
    private static final byte[] suffE;
    private static final byte[] mla;
    private static final byte[] mla1;
    private static final byte[] mla2;
    private static final byte[] mla3;
    private static final byte[] mla4;
    private static Hashtable allProp;
    private static String pk;
    private static String pkc;
    private static String pke;
    private static String pkea;
    private static String hIDseed;
    private static String[] hID;
    private static final byte[] htu;
    private static String lD;
    private static String fLl;
    private static String fL1;
    private static String fLa;
    private static final Object lck;
    public static final boolean LITTLE_ENDIAN;

    public static void setStaticProps(byte[] b) {
        staticProps = b;
    }

    public static void setPrefix(String p, byte[] licDesc, byte[] key) {
        if (p == null) {
            n = ni;
            q = qi;
            PREFIX = ISCOBOL;
            PREFIX_ND = ISCOBOL.substring(0, ISCOBOL.length() - 1);
        } else {
            n = licDesc;
            q = key;
            PREFIX = p + '.';
            PREFIX_ND = p;
        }
        e = null;
        IscobolSystem.remove(Config.class);
    }

    public static String getPrefix() {
        return PREFIX;
    }

    private StickyConfig getSticky() {
        if (this.sticky == null) {
            this.sticky = new StickyConfig();
        }
        return this.sticky;
    }

    public Config() {
        this(null, null);
    }

    Config(InputStream propOnly, String propOnlyFile) {
        String propDir;
        Collection<String> copy6;
        int i;
        if (PREFIX == null) {
            PREFIX = ISCOBOL;
            PREFIX_ND = ISCOBOL.substring(0, ISCOBOL.length() - 1);
            n = ni;
            q = qi;
        }
        if (e == null) {
            int j;
            byte[] prfx = RtsUtil.getUTFBytes(PREFIX);
            e = new byte[prfx.length + E.length];
            f = new byte[prfx.length + F.length];
            for (i = 0; i < prfx.length; ++i) {
                Config.e[i] = Config.f[i] = prfx[i];
            }
            for (j = 0; j < E.length; ++j) {
                Config.e[i + j] = E[j];
            }
            for (j = 0; j < F.length; ++j) {
                Config.f[i + j] = F[j];
            }
        }
        this.propFile = PREFIX + "properties";
        Properties props = System.getProperties();
        if (propOnly != null) {
            try {
                Collection<String> copy2 = RtsUtil.loadPropertiesWithImport(this.personalProps, propOnly);
                this.addSource("From conf only: " + propOnlyFile);
                for (String s : copy2) {
                    this.addSource("From conf.copy: " + s);
                }
                this.loadSystemPropertiesAndStart(props);
            }
            catch (Exception _ex) {
                throw new ExceptionInInitializerError(_ex);
            }
            this.manageVersion();
            return;
        }
        propOnlyFile = props.getProperty(PREFIX + "conf.only");
        if (propOnlyFile != null) {
            try {
                Collection<String> copy3 = RtsUtil.loadPropertiesWithImport(this.personalProps, propOnlyFile);
                this.addSource("From conf only: " + propOnlyFile);
                for (String s : copy3) {
                    this.addSource("From conf.copy: " + s);
                }
                this.loadSystemPropertiesAndStart(props);
            }
            catch (Exception _ex) {
                throw new ExceptionInInitializerError(_ex);
            }
            this.manageVersion();
            return;
        }
        try {
            copy6 = RtsUtil.loadPropertiesWithImport(this.personalProps, systemDir + filesep + this.propFile);
            this.addSource(systemDir + filesep + this.propFile);
            for (String s : copy6) {
                this.addSource("From conf.copy: " + s);
            }
        }
        catch (Exception copy4) {
            // empty catch block
        }
        try {
            propDir = System.getProperty("user.home");
            if (propDir != null) {
                copy6 = RtsUtil.loadPropertiesWithImport(this.personalProps, propDir + filesep + this.propFile);
                this.addSource("From user home: " + propDir + filesep + this.propFile);
                for (String s : copy6) {
                    this.addSource("From conf.copy: " + s);
                }
            }
        }
        catch (Exception copy5) {
            // empty catch block
        }
        try {
            copy6 = RtsUtil.loadPropertiesWithImport(this.personalProps);
            for (String s : copy6) {
                this.addSource("From conf.copy: " + s);
            }
            ClassLoader loader = this.getClass().getClassLoader();
            if (loader != null) {
                URL location = loader.getResource(this.propFile);
                this.addSource("From class path: " + location.getPath().substring(1));
            }
        }
        catch (Exception copy6) {
            // empty catch block
        }
        propDir = System.getProperty(PREFIX + "conf");
        if (propDir != null) {
            try {
                this.intLoadProperties(propDir, true);
            }
            catch (IOException _ex) {
                throw new ExceptionInInitializerError(_ex);
            }
        }
        try {
            propDir = System.getenv(PREFIX_ND.toUpperCase());
            if (propDir != null) {
                copy6 = RtsUtil.loadPropertiesWithImport(this.personalProps, propDir + filesep + this.propFile);
                this.addSource("From $" + PREFIX_ND.toUpperCase() + ": " + propDir + filesep + this.propFile);
                for (String s : copy6) {
                    this.addSource("From conf.copy: " + s);
                }
            }
        }
        catch (Throwable copy7) {
            // empty catch block
        }
        this.manageVersion();
        String acuOrder = Config.getProperty(this, ".properties.acu_compat", "", "0");
        if (Config.isTrue(acuOrder)) {
            try {
                Method listEnv = System.class.getMethod("getenv", null);
                Map env = (Map)listEnv.invoke(null, null);
                Set envNames = env.keySet();
                this.addSource("Environment variables");
                for (String envVarName : envNames) {
                    String envVarValue = (String)env.get(envVarName);
                    this.personalProps.put(PREFIX + envVarName.toLowerCase(), envVarValue);
                }
            }
            catch (NoSuchMethodException listEnv) {
            }
            catch (IllegalAccessException listEnv) {
            }
            catch (InvocationTargetException listEnv) {
                // empty catch block
            }
        }
        this.loadSystemPropertiesAndStart(props);
        if (mas == null) {
            int discardedChars;
            String info = Config.getProperty(this, "iscobol.licinfo", null);
            int infoLen = info.length();
            mas = new int[3];
            if (infoLen > 9) {
                int dc = -1;
                for (Object c : (String)new char[]{' ', '_', '@'}) {
                    int idx = info.lastIndexOf((int)c);
                    if (idx <= 0 || idx > infoLen - 9 || !Character.isDigit(info.charAt(idx - 1)) || dc >= 0 && dc <= infoLen - idx) continue;
                    dc = infoLen - idx;
                }
                discardedChars = dc > 0 ? dc : 9;
            } else {
                discardedChars = 8;
            }
            for (i = infoLen - discardedChars - 1; i > 0 && Character.isDigit(info.charAt(i)); --i) {
            }
            try {
                Config.mas[0] = Integer.parseInt(info.substring(i + 1, infoLen - discardedChars));
            }
            catch (Exception dc) {
                // empty catch block
            }
            int n = i--;
            while (i > 0 && Character.isDigit(info.charAt(i))) {
                --i;
            }
            if (i >= 0 && info.charAt(i) == '/') {
                try {
                    int l = Integer.parseInt(info.substring(i + 1, n));
                    Config.mas[1] = mas[0];
                    Config.mas[0] = l;
                }
                catch (Exception l) {
                    // empty catch block
                }
            }
            n = i--;
            while (i > 0 && Character.isDigit(info.charAt(i))) {
                --i;
            }
            if (i >= 0 && info.charAt(i) == '/') {
                try {
                    int l = Integer.parseInt(info.substring(i + 1, n));
                    Config.mas[2] = mas[1];
                    Config.mas[1] = mas[0];
                    Config.mas[0] = l;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void manageVersion() {
        if (PREFIX == ISCOBOL) {
            try {
                if (this.personalProps.get(PREFIX + "runtime.version") == null) {
                    this.personalProps.put(PREFIX + "runtime.version", Version.getVersion());
                }
                if (this.personalProps.get(PREFIX + "runtime.cs.version") == null) {
                    this.personalProps.put(PREFIX + "runtime.cs.version", "96");
                }
                if (this.personalProps.get(PREFIX + "runtime.fs.version") == null) {
                    this.personalProps.put(PREFIX + "runtime.fs.version", "19");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getMod(int i1, int i2, int[] i3) {
        if (mas == null) {
            return -1;
        }
        if (i3 != null) {
            if (mas[0] > 0 && i1 > mas[0]) {
                i3[0] = i3[0] - 1;
                if (i2 >= 0) {
                    i3[1] = i3[1] - 1;
                }
                return Config.getMod(mas[0], mas3);
            }
            if (i2 > mas[2]) {
                i3[0] = i3[0] - 1;
                i3[1] = i3[1] - 1;
                return Config.getMod(mas3, mas[2]);
            }
        } else {
            if (mas[0] > 0 && i1 >= mas[0]) {
                return Config.getMod(mas[0], mas3);
            }
            if (i2 >= mas[2]) {
                return Config.getMod(mas3, mas[2]);
            }
        }
        return mas[1];
    }

    private void loadStaticProps() {
        if (staticProps != null) {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(staticProps);
                RtsUtil.loadProperties(this.personalProps, in);
            }
            catch (Exception _ex) {
                throw new ExceptionInInitializerError(_ex);
            }
        }
    }

    private void loadSystemPropertiesAndStart(Properties props) {
        int dot;
        try {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                String propValue = (String)props.get(propName);
                if (!propName.startsWith(PREFIX)) continue;
                this.addSource("-D" + propName + "=" + propValue);
            }
            this.personalProps.putAll((Map<?, ?>)System.getProperties());
            this.loadStaticProps();
            Config.putProperty(this.personalProps, n, q);
        }
        catch (ExceptionInInitializerError e) {
            throw e;
        }
        catch (Exception e) {
            // empty catch block
        }
        String vd = (String)this.personalProps.get("iscobol.conf.var_delimiters");
        if (vd != null && (dot = vd.indexOf(46)) > 0) {
            this.personalProps = new MyProperties(this.personalProps, vd.substring(0, dot), vd.substring(dot + 1));
        }
        this.startUtilities(false);
    }

    public void reloadSystemProperties() {
        Properties p = System.getProperties();
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String v;
            String n = (String)e.nextElement();
            if (this.personalProps.getProperty(n) != null || (v = p.getProperty(n)) == null) continue;
            this.personalProps.setProperty(n, v);
        }
    }

    public static String markNoIscobolRuntimeThread() {
        return Config.markNoIscobolRuntimeThread("");
    }

    public static String markNoIscobolRuntimeThread(String sfx) {
        String origName = Thread.currentThread().getName();
        if (!origName.endsWith(NOLOG_SUFFIX)) {
            Thread.currentThread().setName(origName + sfx + NOLOG_SUFFIX);
        }
        return origName;
    }

    private static final boolean isLittleEndian() {
        try {
            Class<?> ByteOrder2 = Class.forName("java.nio.ByteOrder");
            Object nativeOrder = ByteOrder2.getMethod("nativeOrder", new Class[0]).invoke(null, new Object[0]);
            return nativeOrder == ByteOrder2.getField("LITTLE_ENDIAN").get(null);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void startDebugListener(int rundebug, int port, boolean redirectStreams) {
        Config.startDebugListener(rundebug, port, redirectStreams, true, 0);
    }

    public static void startDebugListener(int rundebug, int port, boolean redirectStreams, boolean remote) {
        Config.startDebugListener(rundebug, port, redirectStreams, remote, 0);
    }

    public static void startDebugListener(int rundebug, int port, boolean redirectStreams, boolean remote, int blockingMode) {
        if (shouldStartDebugListener) {
            Config.intStartDebugListener(rundebug, port, redirectStreams, remote, blockingMode);
        }
    }

    private static void intStartDebugListener(int rundebug, int port, boolean redirectStreams, boolean remote, int blockingMode) {
        try {
            IDebuggerExtension2 dbg = (IDebuggerExtension2)Class.forName("com.iscobol.debugger.DebuggerImpl").newInstance();
            dbg.startListener(rundebug, port, redirectStreams, remote, blockingMode);
            shouldStartDebugListener = false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void stopDebugListener(boolean closeCurrentConnection) {
        if (!shouldStartDebugListener) {
            try {
                IDebuggerExtension2 dbg = (IDebuggerExtension2)Class.forName("com.iscobol.debugger.DebuggerImpl").newInstance();
                dbg.stopListener(closeCurrentConnection);
                shouldStartDebugListener = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void startDebugListener(Properties personalProps, String rundebugProp) {
        if (clientTask) {
            return;
        }
        int rundebug = 0;
        try {
            rundebug = Integer.parseInt(personalProps.getProperty(PREFIX + rundebugProp, "0"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (rundebug == 1 || rundebug == 2) {
            int port = 9999;
            try {
                port = Integer.parseInt(personalProps.getProperty(PREFIX + "debug.port", Integer.toString(9999)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            boolean redStreams = Config.isTrue(personalProps.getProperty(PREFIX + "rundebug.redirect_streams", personalProps.getProperty(PREFIX + "redirect_streams", "true")));
            int blockingMode = 0;
            try {
                blockingMode = Config.isTrue(personalProps.getProperty(PREFIX + "rundebug.auto_pause", "true")) ? 0 : 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Config.intStartDebugListener(rundebug, port, redStreams, true, blockingMode);
        }
    }

    public static void loadProperties(String propDir, boolean urlAllowed) throws IOException {
        Config conf = Config.get();
        conf.intLoadProperties(propDir, urlAllowed);
        conf.startUtilities(true);
    }

    public static void loadProperties(String propDir) throws IOException {
        Config.loadProperties(propDir, true);
    }

    private void startUtilities(boolean createLogger) {
        String thName = Thread.currentThread().getName();
        if (!thName.endsWith(NOLOG_SUFFIX)) {
            Thread.currentThread().setName(thName + NOLOG_SUFFIX);
            try {
                this.log = LoggerFactory.get(this, 1, createLogger);
            }
            finally {
                Thread.currentThread().setName(thName);
            }
            if (this.log != null) {
                Enumeration<?> e = this.personalProps.propertyNames();
                while (e.hasMoreElements()) {
                    String k = e.nextElement().toString();
                    if (k.matches("iscobol.*license.\\d\\d\\d\\d") || k.equals("iscobol.licinfo")) continue;
                    if (Config.isEncrypt(k)) {
                        this.log.info("[CONFIG] [isCobol] " + k + "=***Encrypted Value***");
                        continue;
                    }
                    if (allProp.get(k) != null || k.startsWith("iscobol.filename.mapping.") || k.startsWith("iscobol.print.attribute.") || k.startsWith("iscobol.esql.sqlcode.") || k.startsWith("iscobol.sqlserver.iss.mapping.")) {
                        this.log.info("[CONFIG] [isCobol] " + k + "=" + this.personalProps.getProperty(k));
                        continue;
                    }
                    if (!k.startsWith(PREFIX)) continue;
                    this.log.info("[CONFIG] [user] " + k + "=" + this.personalProps.getProperty(k));
                }
            }
            if (shouldStartDebugListener) {
                Config.startDebugListener(this.personalProps, "rundebug");
            }
        } else if (thName.endsWith("PCC $$") && shouldStartDebugListener) {
            Config.startDebugListener(this.personalProps, "compiler.rundebug");
        }
    }

    private void intLoadProperties(String propDir, boolean urlAllowed) throws IOException {
        InputStream propIn;
        block7: {
            propIn = null;
            try {
                propIn = Class.forName(propDir).getResourceAsStream(this.propFile);
                this.addSource("Using " + PREFIX + "conf, From directory or jar file containing " + propDir + ": " + this.propFile);
            }
            catch (ClassNotFoundException _ex1) {
                if (urlAllowed) {
                    try {
                        propIn = new URL(propDir).openStream();
                        this.addSource("Using " + PREFIX + "conf, URL: " + propDir);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (propIn != null) break block7;
                propIn = new FileInputStream(propDir);
                this.addSource("Using " + PREFIX + "conf=" + propDir);
            }
        }
        if (propIn != null) {
            Collection<String> copy = RtsUtil.loadPropertiesWithImport(this.personalProps, propIn);
            for (String s : copy) {
                this.addSource("From conf.copy: " + s);
            }
        }
    }

    private void addSource(String propLoc) {
        String srcProp = this.personalProps.getProperty(PREFIX + "properties.sources");
        String linesep = System.getProperty("line.separator");
        srcProp = srcProp != null ? srcProp + linesep + "\t" + propLoc : linesep + "\t" + propLoc;
        this.personalProps.setProperty(PREFIX + "properties.sources", srcProp);
    }

    private static Config get() {
        Config Return2 = (Config)IscobolSystem.get(Config.class);
        if (Return2 == null) {
            Return2 = new Config();
            IscobolSystem.set(Config.class, Return2);
        }
        return Return2;
    }

    public static Properties getIscobolProperties() {
        Properties Return2 = new Properties();
        Properties pp = Config.getAllProperties();
        int prefixLen = PREFIX.length();
        Enumeration<Object> en = pp.keys();
        while (en.hasMoreElements()) {
            String key = en.nextElement().toString();
            if (!key.startsWith(PREFIX) || key.length() <= prefixLen) continue;
            Object value = pp.get(key);
            Return2.put(key.substring(prefixLen), value);
        }
        return Return2;
    }

    public static Properties getAllProperties() {
        return Config.get().personalProps;
    }

    public static String getProperty(Config c, String key, String alias, String aDefault) {
        String Return2 = Config.intGetProperty(c, key, alias, aDefault);
        if (Return2 != null) {
            Return2 = Return2.replaceAll("\\s+$", "");
        }
        return Return2;
    }

    public static String intGetProperty(Config c, String key, String alias, String aDefault) {
        String Return2;
        if (key.charAt(0) == '.') {
            key = PREFIX_ND + key;
            if (alias.length() > 0) {
                alias = PREFIX_ND + alias;
            }
        }
        if ((Return2 = StickyConfig.getProperty(key, alias, aDefault, c.getSticky(), c.personalProps)) != null) {
            return Return2;
        }
        if (key.equals(PREFIX + "file.index.version")) {
            Return2 = IndexFile.getDefaultDynamicFile(c).getVersion();
            c.personalProps.put(PREFIX + "file.index.version", Return2);
            return Return2;
        }
        ContextEnv ce = ContextEnv.get();
        try {
            Return2 = ce.getProperty(key.substring(PREFIX.length()).toUpperCase().replace(".", "_"));
            if (Return2 != null) {
                Config.setProperty(key, Return2);
                return Return2;
            }
            if (!alias.equals("") && (Return2 = ce.getProperty(alias.substring(PREFIX.length()).toUpperCase().replace(".", "_"))) != null) {
                Config.setProperty(alias, Return2);
                return Return2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return aDefault;
    }

    public static String getProperty(Thread thr, String key, String aDefault) {
        Config c = (Config)IscobolSystem.get(thr, Config.class);
        if (c == null) {
            return aDefault;
        }
        return Config.getProperty(c, key, aDefault);
    }

    public static String getProperty(Config c, String key, String aDefault) {
        return Config.getProperty(c, key, "", aDefault);
    }

    public static String getProperty(String key, String alias, String aDefault) {
        return Config.getProperty(Config.get(), key, alias, aDefault);
    }

    public static String getProperty(String key, String aDefault) {
        return Config.getProperty(Config.get(), key, "", aDefault);
    }

    public static int getProperty(Config c, String key, int aDefault) {
        String str = Config.getProperty(c, key, null);
        if (str != null) {
            try {
                aDefault = Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return aDefault;
    }

    public static int getProperty(String key, int aDefault) {
        String str = Config.getProperty(key, null);
        if (str != null) {
            try {
                aDefault = Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return aDefault;
    }

    public static int getProperty(String key, String alias, int aDefault) {
        String str = Config.getProperty(key, null);
        if (str != null) {
            try {
                aDefault = Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            str = Config.getProperty(alias, null);
            if (str != null) {
                try {
                    aDefault = Integer.parseInt(str);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return aDefault;
    }

    public static boolean isTrue(String rs) {
        if (rs.length() > 0) {
            switch (rs.charAt(0)) {
                case 'T': 
                case 't': {
                    return true;
                }
                case 'Y': 
                case 'y': {
                    return true;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean getProperty(String key, String alias, boolean aDefault) {
        String rs = Config.getProperty(key, null);
        if (rs == null && (rs = Config.getProperty(alias, null)) == null) {
            return aDefault;
        }
        return Config.isTrue(rs);
    }

    public static boolean getProperty(Config c, String key, boolean aDefault) {
        String rs = Config.getProperty(c, key, null);
        if (rs == null) {
            return aDefault;
        }
        return Config.isTrue(rs);
    }

    public static boolean getProperty(String key, boolean aDefault) {
        String rs = Config.getProperty(key, null);
        if (rs == null) {
            return aDefault;
        }
        return Config.isTrue(rs);
    }

    public static synchronized String getProperty(Hashtable tl) {
        char c;
        String res = Config.getProperty(RtsUtil.newUTFString(e), "");
        int cl = 0;
        int i = res.length() - 9;
        int j = 1;
        while (Character.isDigit(c = res.charAt(i))) {
            cl += j * (c - 48);
            --i;
            j *= 10;
        }
        if (tl.size() >= cl) {
            return RtsUtil.newUTFString(a);
        }
        return null;
    }

    private static byte[] toByte(String ins) {
        char[] in = ins.toCharArray();
        byte[] Return2 = new byte[in.length >> 1];
        int j = 0;
        for (int i = 0; i < Return2.length; ++i) {
            Return2[i] = (byte)(in[j] - 65 << 4);
            if (++j >= in.length) continue;
            int n = i;
            Return2[n] = (byte)(Return2[n] | (byte)(in[j] - 65));
            ++j;
        }
        return Return2;
    }

    public static boolean putProperty(String key, int i) {
        SimpleDateFormat df = new SimpleDateFormat(RtsUtil.newUTFString(d));
        try {
            Date b = df.parse(key.substring(key.length() - d.length));
            long t = System.currentTimeMillis();
            if (b.compareTo(new Date(t - 86400000L)) > i) {
                return false;
            }
            if (b.compareTo(new Date(t - 691200000L)) <= i) {
                Config.putProperty();
            }
            return true;
        }
        catch (Exception _ex) {
            return false;
        }
    }

    public static void putProperty(byte[] g, byte[] u) {
        Config.putProperty(Config.get().personalProps, g, u);
    }

    public static void putProperty(Properties argv, byte[] g, byte[] u) {
        String res = argv.getProperty(RtsUtil.newUTFString(g));
        if (res == null || res.length() < d.length + 10) {
            Config.putProperty();
            return;
        }
        if ((res = Config.putProperty(res, u)).substring(0, 10).equals(Config.wombat(res.substring(10)))) {
            if (Config.putProperty(res, 0)) {
                argv.setProperty(RtsUtil.newUTFString(f), "1");
            } else {
                argv.setProperty(RtsUtil.newUTFString(f), "0");
            }
        } else {
            Config.putProperty();
        }
        argv.setProperty(RtsUtil.newUTFString(e), res.substring(10));
        if (!Config.wp4(res.substring(10), g)) {
            Config.putProperty();
        }
    }

    public static String putProperty(String key, byte[] u) {
        Context ctx = new Context(u);
        byte[] sb = Config.toByte(key);
        ctx.d(sb);
        return RtsUtil.newUTFString(sb);
    }

    public static void putProperty() {
        int i = n.length;
        for (i = 0; i < n.length; ++i) {
            if (n[i] >= 0 || sd1.length() > 0) {
                final String msg = RtsUtil.newUTFString(m) + sd1;
                Error e = new Error(msg){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public String toString() {
                        return msg;
                    }
                };
                e.setStackTrace(new StackTraceElement[0]);
                throw e;
            }
            Config.putProperty(new Properties(), n, q);
        }
    }

    private static String wombat(String s) {
        byte[] data = RtsUtil.getUTFBytes(s);
        int result = -1;
        for (int i = 0; i < data.length; ++i) {
            byte octet = data[i];
            for (int j = 0; j < 8; ++j) {
                result = (octet >>> 7 ^ result >>> 31) != 0 ? result << 1 ^ 0x4C11DB7 : (result <<= 1);
                octet = (byte)(octet << 1);
            }
        }
        String Return2 = "000000000" + (0xFFFFFFFFL & (long)(~result));
        return Return2.substring(Return2.length() - 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPropertyChangeListener(PropertyChangeListener l) {
        Config conf;
        if (l == null) {
            return;
        }
        Config config = conf = Config.get();
        synchronized (config) {
            if (conf.changeListeners == null) {
                conf.changeListeners = new PropertyChangeSupport(conf);
            }
            conf.changeListeners.addPropertyChangeListener(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            return;
        }
        Config conf = Config.get();
        if (conf.changeListeners != null) {
            Config config = conf;
            synchronized (config) {
                conf.changeListeners.removePropertyChangeListener(l);
            }
        }
    }

    public static void setProperty(String key, String value) {
        Config.setProperty(Config.get(), key, value, false);
    }

    public static boolean setProperty(String key, String value, boolean writeLog) {
        return Config.setProperty(Config.get(), key, value, writeLog);
    }

    static boolean setProperty(Config conf, String key, String value, boolean writeLog) {
        String failed;
        Object[] old;
        if (key.charAt(0) == '.') {
            key = PREFIX_ND + key;
        }
        if ((old = StickyConfig.setProperty(key, value, conf.getSticky(), conf.personalProps)) != null) {
            boolean logAllowed;
            boolean bl = logAllowed = !Thread.currentThread().getName().endsWith(NOLOG_SUFFIX);
            if (key.equals(PREFIX + "tracelevel")) {
                if (logAllowed) {
                    try {
                        LoggerFactory.setTraceLevel(Integer.parseInt(value));
                        conf.log = LoggerFactory.get(1);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (key.equals(PREFIX + "logfile")) {
                if (logAllowed) {
                    LoggerFactory.setLogFile(value);
                }
            } else if (key.equals(PREFIX + "logfile.thread")) {
                if (logAllowed) {
                    LoggerFactory.setShowThreadInfo(Config.isTrue(value));
                }
            } else if (conf.changeListeners != null && old[0] != value) {
                conf.changeListeners.firePropertyChange(key, old[0], value);
            }
            failed = "";
        } else {
            failed = " <failed>";
        }
        if (writeLog && conf.log != null) {
            if (allProp.get(key) != null) {
                if (!key.matches("iscobol.*license.\\d\\d\\d\\d") && !key.equals("iscobol.licinfo")) {
                    if (Config.isEncrypt(key)) {
                        conf.log.info("[SET ENVIRONMENT ] [isCobol] " + key + "=***Encrypted Value***" + failed);
                    } else {
                        conf.log.info("SET ENVIRONMENT [isCobol] '" + key + "=" + value + "'" + failed);
                    }
                }
            } else if (!key.matches("iscobol.*license.\\d\\d\\d\\d") && !key.equals("iscobol.licinfo")) {
                if (Config.isEncrypt(key)) {
                    conf.log.info("[SET ENVIRONMENT ] [isCobol] " + key + "=***Encrypted Value***" + failed);
                } else {
                    conf.log.info("SET ENVIRONMENT [users] '" + key + "=" + value + "'" + failed);
                }
            }
        }
        return failed.length() == 0;
    }

    public static boolean unsetProperty(String key) {
        return Config.unsetProperty(key, true);
    }

    public static boolean unsetProperty(String key, boolean notifyChange) {
        Object[] old;
        Config config = Config.get();
        if (key.charAt(0) == '.') {
            key = PREFIX_ND + key;
        }
        if ((old = StickyConfig.unsetProperty(key, config.getSticky(), config.personalProps)) != null) {
            if (notifyChange && config.changeListeners != null) {
                config.changeListeners.firePropertyChange(key, old[0], "");
            }
            if (config.log != null) {
                config.log.info("UNSET ENVIRONMENT '" + key + "'");
            }
            return true;
        }
        if (config.log != null) {
            config.log.info("UNSET ENVIRONMENT '" + key + "' <failed>");
        }
        return false;
    }

    public static Hashtable getSqlDecode() {
        Hashtable<String, String> Return2 = new Hashtable<String, String>();
        Config conf = Config.get();
        Enumeration<?> e = conf.personalProps.propertyNames();
        while (e.hasMoreElements()) {
            String k = e.nextElement().toString();
            if (!k.startsWith("iscobol.esql.sqlcode.")) continue;
            Return2.put(k.substring(21), conf.personalProps.getProperty(k));
        }
        return Return2;
    }

    public static boolean isUserProperty(String propName) {
        if (propName == null || propName.length() == 0) {
            return false;
        }
        if (propName.matches("iscobol.*license.\\d\\d\\d\\d") || propName.equals("iscobol.file.encryption.key")) {
            return false;
        }
        if (propName.charAt(0) == '.') {
            propName = ISCOBOL + propName;
        }
        return !allProp.containsKey(propName);
    }

    public static String getPropertyAlias(String propName) {
        String desc = (String)allProp.get(propName);
        if (desc != null && desc.startsWith("alias ")) {
            return desc.substring(6);
        }
        return "";
    }

    public static String getPropertySeparateThread(String propName, String def) {
        return Config.getPropertiesSeparateThread(new String[]{propName}, new String[]{def})[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getPropertiesSeparateThread(final String[] propNames, final String[] defs) {
        final Object[] value = new Object[2];
        final String[] propValues = new String[propNames.length];
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Config.markNoIscobolRuntimeThread();
                Object[] objectArray = value;
                synchronized (value) {
                    try {
                        for (int i = 0; i < propNames.length; ++i) {
                            if (propNames[i] == null) continue;
                            propValues[i] = Config.getProperty(propNames[i], defs[i]);
                        }
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        value[0] = propValues;
                        value[1] = Boolean.TRUE;
                        value.notify();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
        t.start();
        Object[] objectArray = value;
        synchronized (value) {
            if (value[1] == null) {
                try {
                    value.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            IscobolSystem.destroyEnv(t);
            return (String[])value[0];
        }
    }

    public static boolean isClientTask() {
        return clientTask;
    }

    public static void setClientTask(boolean clientTask) {
        Config.clientTask = clientTask;
    }

    static boolean isEncrypt(String key) {
        return key.equals("iscobol.file.encryption.key") || key.equals("iscobol.net.ssl.key_store_password") || key.equals("iscobol.net.ssl.trust_store_password") || key.equals("iscobol.sqlserver.password") || key.equals("iscobol.user.passwd") || key.equals("iscobol.user.password") || key.equals("iscobol.jdbc.password") || key.equals("iscobol.file.index.password") || key.startsWith("iscobol.file.index.") && key.endsWith(".password") || key.equals("iscobol.print.attribute.owner_password") || key.equals("iscobol.print.attribute.user_password");
    }

    static boolean wp4(String str, byte[] g) {
        int i;
        String iStr = str.substring(str.indexOf("##") + 2);
        int idx = iStr.indexOf(47);
        String licId = idx >= 0 ? iStr.substring(0, idx) : iStr;
        String st = RtsUtil.newUTFString(g);
        String tStr = null;
        int flag = st.startsWith(RtsUtil.newUTFString(suffC)) ? 1 : (st.startsWith(RtsUtil.newUTFString(suffE)) ? 2 : (st.startsWith(RtsUtil.newUTFString(suffEa)) ? 3 : 0));
        int valc = Config.getVal(flag);
        if (valc != 32 && valc != 67) {
            return true;
        }
        for (i = 0; i < iStr.length() && (iStr.charAt(i) >= '0' && iStr.charAt(i) <= '9' || iStr.charAt(i) == '/'); ++i) {
        }
        iStr = i <= iStr.length() ? iStr.substring(i, iStr.length() - 8) : "";
        tStr = st.replace(RtsUtil.newUTFString(lc), "");
        if (valc != 67) {
            if (iStr.length() > 0 && (iStr.charAt(0) == RtsUtil.newUTFString(cC).charAt(0) || iStr.charAt(0) == RtsUtil.newUTFString(cL).charAt(0))) {
                if (iStr.charAt(0) != RtsUtil.newUTFString(cL).charAt(0)) {
                    if (tStr.startsWith(RtsUtil.newUTFString(suff) + spvR) && use[0] == 'X') {
                        Config.gn(0);
                    } else if (tStr.startsWith(RtsUtil.newUTFString(suff) + spvR)) {
                        Config.use[0] = 88;
                    }
                }
            } else {
                Config.setVal(flag, 'O');
                return true;
            }
            if (tStr.startsWith(RtsUtil.newUTFString(suffE) + spvR) && use[2] == 'X') {
                Config.gn(2);
            } else if (tStr.startsWith(RtsUtil.newUTFString(suffE) + spvR)) {
                Config.use[2] = 88;
            } else if (tStr.startsWith(RtsUtil.newUTFString(suffEa) + spvR) && use[3] == 'X') {
                Config.gn(3);
            } else if (tStr.startsWith(RtsUtil.newUTFString(suffE) + spvR)) {
                Config.use[3] = 88;
            }
        } else {
            valc = 32;
        }
        String spi = spiR;
        String k = "";
        String is = "";
        String pi = "";
        try {
            block45: {
                BufferedReader rea;
                if (!(lD != null || (lD = System.getenv(RtsUtil.newUTFString(dli))) != null && new File(lD).isDirectory() || (lD = System.getProperty(RtsUtil.newUTFString(uh))) != null)) {
                    lD = RtsUtil.newUTFString(cDt);
                }
                if (fLl == null) {
                    fLl = lD + filesep + RtsUtil.newUTFString(cDt) + PREFIX + RtsUtil.newUTFString(d2);
                }
                if (fL1 == null) {
                    fL1 = lD + filesep + PREFIX + RtsUtil.newUTFString(d2);
                }
                if (fLa == null) {
                    fLa = lD + filesep + PREFIX + RtsUtil.newUTFString(d3);
                }
                switch (flag) {
                    case 1: {
                        if (valc != 32) {
                            return true;
                        }
                        spi = RtsUtil.newUTFString(pic);
                        is = RtsUtil.newUTFString(suffC);
                        pi = pkc;
                        break;
                    }
                    case 2: {
                        if (valc != 32) {
                            return true;
                        }
                        spi = RtsUtil.newUTFString(pie);
                        is = RtsUtil.newUTFString(suffE);
                        pi = pke;
                        break;
                    }
                    case 3: {
                        if (valc != 32) {
                            return true;
                        }
                        spi = RtsUtil.newUTFString(piea);
                        is = RtsUtil.newUTFString(suffEa);
                        pi = pkea;
                        break;
                    }
                    default: {
                        if (valc != 32) {
                            return true;
                        }
                        is = RtsUtil.newUTFString(suff);
                        pi = pk;
                    }
                }
                if (hIDseed == null) {
                    hIDseed = HardwareID.getHardwareIDFromVolumeSerialNumber();
                }
                if (hID[flag] == null) {
                    Config.hID[flag] = licId + hIDseed;
                }
                String fL = "";
                boolean isSll = false;
                try {
                    rea = new BufferedReader(new FileReader(fLl));
                    while (fL != null) {
                        fL = rea.readLine();
                        if (fL == null || !fL.startsWith(tStr)) continue;
                        k = fL;
                    }
                    rea.close();
                }
                catch (Exception e) {
                    isSll = true;
                }
                try {
                    rea = new BufferedReader(new FileReader(fL1));
                    fL = "";
                    while (fL != null) {
                        fL = rea.readLine();
                        if (fL == null || !fL.startsWith(tStr)) continue;
                        k = fL;
                    }
                    rea.close();
                }
                catch (Exception e) {
                    if (!isSll) break block45;
                    Config.sll(iStr, pi, is + spvR, flag);
                    return true;
                }
            }
            if (k == null || !k.contains("=")) {
                Config.sll(iStr, pi, is + spvR, flag);
                return true;
            }
            k = k.substring(k.indexOf(61) + 1);
        }
        catch (Exception e) {
            Config.sll(iStr, pi, is + spvR, flag);
            return true;
        }
        try {
            License lic = LicenseValidator.validateWithCustomHardwareID((String)k, (String)pi, (String)spi, (String)speR, (String)spvR, (String)hID[flag], null, null);
            ValidationStatus ret = lic.getValidationStatus();
            if (((Enum)ret).ordinal() != 0) {
                Config.sll(iStr, pi, is + spvR, flag);
            } else {
                Config.setVal(flag, 'O');
            }
            return true;
        }
        catch (Exception e) {
            sd1 = RtsUtil.newUTFString(d1);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char getVal(int flag) {
        char[] cArray = val;
        synchronized (val) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return val[flag];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setVal(int flag, char valc) {
        char[] cArray = val;
        synchronized (val) {
            Config.val[flag] = valc;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static void wpm() {
        if (sd1.length() == 0) {
            String hardwareID = "";
            try {
                hardwareID = HardwareID.getHardwareIDFromVolumeSerialNumber();
            }
            catch (Exception exception) {
                // empty catch block
            }
            sd1 = RtsUtil.newUTFString(d1) + hardwareID;
        }
    }

    public static void setWC(String wc) {
        if (wc == null) {
            final String msg = RtsUtil.newUTFString(wc2);
            String s = RtsUtil.newUTFString(wc1);
            Error e = new Error(msg){
                private static final long serialVersionUID = 1L;

                @Override
                public String toString() {
                    return msg;
                }
            };
            for (StackTraceElement ste : e.getStackTrace()) {
                if (!ste.getClassName().equals(s)) continue;
                e.setStackTrace(new StackTraceElement[0]);
                throw e;
            }
        }
    }

    private static int getMod(int i1, int i2) {
        final String msg = i1 >= 0 ? RtsUtil.newUTFString(mas1) + i1 : (i2 >= 0 ? RtsUtil.newUTFString(mas1) + i2 + RtsUtil.newUTFString(mas2) : null);
        if (msg != null) {
            Error e = new Error(msg){
                private static final long serialVersionUID = 1L;

                @Override
                public String toString() {
                    return msg;
                }
            };
            e.setStackTrace(new StackTraceElement[0]);
            throw e;
        }
        return -i1;
    }

    public static String srl(byte[] s, String hID, int flag) {
        try {
            String p;
            MessageDigest dig = MessageDigest.getInstance("SHA-1");
            switch (flag) {
                case 1: {
                    dig.update(suffC);
                    p = pkc;
                    break;
                }
                case 2: {
                    dig.update(suffE);
                    p = pke;
                    break;
                }
                case 3: {
                    dig.update(suffEa);
                    p = pkea;
                    break;
                }
                default: {
                    dig.update(suff);
                    p = pk;
                }
            }
            Cipher cip = Cipher.getInstance("Blowfish");
            byte[] k = dig.digest();
            cip.init(2, new SecretKeySpec(k, 0, k.length, "Blowfish"));
            byte[] d = cip.doFinal(s, 0, s.length);
            Arrays.fill(k, (byte)0);
            String licStr = RtsUtil.newUTFString(d);
            License la = LicenseValidator.validate((String)licStr, (String)p, null, null, null, (int)0);
            License l = LicenseValidator.autoActivateWithCustomHardwareID((License)la, (String)RtsUtil.newUTFString(htu), (String)hID);
            if (l.getActivationStatus() != ActivationStatus.ACTIVATION_SERVER_CONNECTION_ERROR) {
                return l.getLicenseString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void sll(String s, String p, String i, int flag) {
        HTTPSessionInfo sInfo;
        ClientInfo cInfo;
        AppFactory delegate;
        if (Thread.currentThread().getName().indexOf(",R-") >= 0) {
            return;
        }
        boolean as = IscobolSystem.isAS();
        if (as) {
            delegate = (AppFactory)IscobolSystem.get(AppFactory.class);
            cInfo = (ClientInfo)IscobolSystem.get(ClientInfo.class);
            sInfo = null;
        } else {
            delegate = null;
            cInfo = null;
            sInfo = (HTTPSessionInfo)IscobolSystem.get(HTTPSessionInfo.class);
        }
        Thread th = new Thread(() -> Config.lambda$sll$0(s, p, flag, as, delegate, cInfo, i, sInfo));
        th.start();
    }

    private static boolean iside() {
        try {
            return Class.forName("org.eclipse.core.runtime.Platform").getMethod("getBundle", String.class).invoke(null, "com.iscobol.plugins.editor.IscobolEditor") != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gn(int v) {
        int t = v;
        if (v > 3) {
            t -= 4;
        }
        char[] cArray = val;
        synchronized (val) {
            while (val[t] == ' ') {
                try {
                    val.wait();
                }
                catch (InterruptedException e) {
                    final String msg = RtsUtil.newUTFString(errgeneric);
                    if (Config.iside()) {
                        ExceptionInInitializerError eie = new ExceptionInInitializerError(msg){

                            @Override
                            public String toString() {
                                return msg;
                            }
                        };
                        eie.setStackTrace(new StackTraceElement[0]);
                        throw eie;
                    }
                    System.err.println(msg);
                    throw new StopRunException(99);
                }
            }
            if (val[t] == 'K') {
                if (v > 3 || Config.iside()) {
                    final String msg = v <= 3 ? err[v] : RtsUtil.newUTFString(errgeneric);
                    ExceptionInInitializerError eie = new ExceptionInInitializerError(msg){

                        @Override
                        public String toString() {
                            return msg;
                        }
                    };
                    eie.setStackTrace(new StackTraceElement[0]);
                    throw eie;
                }
                throw new StopRunException(99);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void loadEnvironment(File propFile, boolean append) throws IOException {
        Properties props = new Properties();
        Config c = Config.get();
        if (propFile != null) {
            RtsUtil.loadPropertiesWithImport(props, propFile);
        }
        if (!append) {
            if (c.log != null) {
                c.log.info("RESET PROPERTIES");
            }
            Properties oldProps = Config.getIscobolProperties();
            Enumeration<?> en = oldProps.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (key.matches(".*license.\\d\\d\\d\\d") || key.equals("licinfo") || key.equals("properties.sources") || key.equals("runtime.cs.version") || key.equals("expired") || key.equals("runtime.version") || key.equals("runtime.fs.version")) continue;
                Config.unsetProperty(ISCOBOL + key);
            }
        }
        if (propFile != null && c.log != null) {
            c.log.info("LOAD CONFIGURATION FILE '" + propFile + "'");
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            Config.setProperty(c, k, props.getProperty(k), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static /* synthetic */ void lambda$sll$0(String s, String p, int flag, boolean as, AppFactory delegate, ClientInfo cInfo, String i, HTTPSessionInfo sInfo) {
        block72: {
            block70: {
                Config.markNoIscobolRuntimeThread();
                res = 79;
                cancel = false;
                kill = false;
                stopSession = false;
                la /* !! */  = LicenseValidator.validate((String)s.substring(1), (String)p, null, null, null, (int)0);
                l = LicenseValidator.autoActivateWithCustomHardwareID((License)la /* !! */ , (String)RtsUtil.newUTFString(Config.htu), (String)Config.hID[flag]);
                if (!as || l.getActivationStatus() != ActivationStatus.ACTIVATION_SERVER_CONNECTION_ERROR) break block70;
                if (delegate == null && !(cInfo instanceof ClientInfoRC)) ** GOTO lbl56
                dig = MessageDigest.getInstance("SHA-1");
                switch (flag) {
                    case 1: {
                        dig.update(Config.suffC);
                        break;
                    }
                    case 2: {
                        dig.update(Config.suffE);
                        break;
                    }
                    case 3: {
                        dig.update(Config.suffEa);
                        break;
                    }
                    default: {
                        dig.update(Config.suff);
                    }
                }
                cip = Cipher.getInstance("Blowfish");
                k /* !! */  = dig.digest();
                d = s.substring(1).getBytes("utf-8");
                cip.init(1, new SecretKeySpec(k /* !! */ , 0, k /* !! */ .length, "Blowfish"));
                d = cip.doFinal(d, 0, d.length);
                Arrays.fill(k /* !! */ , (byte)0);
                try {
                    licStr = delegate != null ? delegate.activateLic(d, Config.hID[flag], flag) : ((ClientInfoRC)cInfo).activateLic(d, Config.hID[flag], flag);
                    if (licStr == null) {
                        res = 67;
                    }
                }
                catch (IOException ex) {
                    res = 67;
                    var20_26 = Config.val;
                    synchronized (Config.val) {
                        if (!cancel) {
                            Config.val[flag] = res;
                        }
                        Config.val.notify();
                        // ** MonitorExit[var20_26] (shouldn't be in output)
                        if (stopSession) {
                            sInfo.stopSession();
                        }
                        IscobolSystem.destroyEnv(Thread.currentThread());
                        return;
                    }
                }
                ** GOTO lbl76
lbl56:
                // 1 sources

                res = 67;
                var15_17 = Config.val;
                synchronized (Config.val) {
                    if (!cancel) {
                        Config.val[flag] = res;
                    }
                    Config.val.notify();
                    // ** MonitorExit[var15_17] (shouldn't be in output)
                    if (stopSession) {
                        sInfo.stopSession();
                    }
                    IscobolSystem.destroyEnv(Thread.currentThread());
                    return;
                }
            }
            licStr = l.getLicenseString();
lbl76:
            // 2 sources

            var15_16 = Config.lck;
            synchronized (var15_16) {
                valc = Config.getVal(flag);
                if (valc == ' ' || valc == 'C') ** break block71
                cancel = true;
            }
            k /* !! */  = (byte[])Config.val;
            synchronized (Config.val) {
                if (!cancel) {
                    Config.val[flag] = res;
                }
                Config.val.notify();
                // ** MonitorExit[k /* !! */ ] (shouldn't be in output)
                if (stopSession) {
                    sInfo.stopSession();
                }
                IscobolSystem.destroyEnv(Thread.currentThread());
                return;
            }
            {
                ret = la /* !! */ .getValidationStatus();
                if (licStr == null || licStr.equals(s.substring(1))) {
                    Config.sd1 = RtsUtil.newUTFString(Config.d1) + Config.hID;
                    Config.sd1 = Config.sd1 + " " + ((Enum)ret).ordinal();
                    if (s.charAt(0) == RtsUtil.newUTFString(Config.cC).charAt(0)) {
                        if (la /* !! */ .getActivationStatus() == ActivationStatus.ACTIVATION_SERVER_CONNECTION_ERROR) {
                            k = null;
                            a = i.replace(Config.spvR, RtsUtil.newUTFString(Config.d3) + "." + Config.spvR);
                            try {
                                rea = new BufferedReader(new FileReader(Config.fLa));
                                k = rea.readLine();
                                while (k != null && !k.startsWith(a)) {
                                    k = rea.readLine();
                                }
                                rea.close();
                            }
                            catch (Throwable rea) {
                                // empty catch block
                            }
                            if (k == null) {
                                bw = new BufferedWriter(new FileWriter(Config.fLa, true));
                                str = l.getManualActivationRequestStringWithCustomHardwareID(Config.hID[flag]);
                                str = str.substring(str.indexOf(")") + 1);
                                str = str.replace("\n", "");
                                bw.write(a + "=" + str + Config.eol);
                                bw.flush();
                                bw.close();
                            }
                        }
                        if ((la /* !! */ .getActivationStatus() == ActivationStatus.MULTIPLE_ACTIVATION_LIMIT_REACHED || la /* !! */ .getActivationStatus() == ActivationStatus.ALREADY_ACTIVATED_ON_ANOTHER_COMPUTER) && l.getLicenseActivationDaysRemaining(new Date()) > 0) {
                            Config.err[flag] = i + RtsUtil.newUTFString(Config.mla3) + ", " + l.getLicenseActivationDaysRemaining(new Date()) + RtsUtil.newUTFString(Config.mla1) + RtsUtil.newUTFString(Config.mla4);
                            System.err.println(Config.err[flag]);
                        } else if (la /* !! */ .getActivationStatus() == ActivationStatus.MULTIPLE_ACTIVATION_LIMIT_REACHED || la /* !! */ .getActivationStatus() == ActivationStatus.ALREADY_ACTIVATED_ON_ANOTHER_COMPUTER) {
                            Config.err[flag] = i + RtsUtil.newUTFString(Config.mla3) + "!" + RtsUtil.newUTFString(Config.mla4);
                            System.err.println(Config.err[flag]);
                            if (cInfo != null) {
                                kill = true;
                            } else if (sInfo != null) {
                                stopSession = sInfo.isSessionStoppable();
                                res = 67;
                            } else {
                                res = 75;
                            }
                        } else if (l.getLicenseActivationDaysRemaining(new Date()) > 0) {
                            Config.err[flag] = i + RtsUtil.newUTFString(Config.mla) + " " + l.getLicenseActivationDaysRemaining(new Date()) + RtsUtil.newUTFString(Config.mla1) + " " + Config.fLa + RtsUtil.newUTFString(Config.mla2);
                            System.err.println(Config.err[flag]);
                        } else {
                            Config.err[flag] = i + RtsUtil.newUTFString(Config.mla) + "! " + Config.fLa + RtsUtil.newUTFString(Config.mla2);
                            System.err.println(Config.err[flag]);
                            if (cInfo != null) {
                                kill = true;
                            } else if (sInfo != null) {
                                stopSession = sInfo.isSessionStoppable();
                                res = 67;
                            } else {
                                res = 75;
                            }
                        }
                    }
                } else {
                    bw = new BufferedWriter(new FileWriter(Config.fLl, true));
                    str = licStr;
                    str = str.substring(str.indexOf(")") + 1);
                    str = str.replace("\n", "");
                    bw.write(i + "=" + str + Config.eol);
                    bw.flush();
                    bw.close();
                    Files.setAttribute(Paths.get(Config.fLl, new String[0]), "dos:hidden", true, new LinkOption[]{LinkOption.NOFOLLOW_LINKS});
                }
                // MONITOREXIT @DISABLED, blocks:[17, 8, 9] lbl167 : MonitorExitStatement: MONITOREXIT : var15_16
                {
                    catch (Throwable var24_33) {
                        throw var24_33;
                    }
                }
                if (!kill) break block72;
                AppServerImpl.kill(cInfo.getThreadId(), 99);
            }
        }
        la /* !! */  = (License)Config.val;
        synchronized (Config.val) {
            if (!cancel) {
                Config.val[flag] = res;
            }
            Config.val.notify();
            // ** MonitorExit[la /* !! */ ] (shouldn't be in output)
            if (stopSession) {
                sInfo.stopSession();
            }
            IscobolSystem.destroyEnv(Thread.currentThread());
            ** GOTO lbl-1000
        }
        {
            catch (Throwable t) {
                try {
                    res = 75;
                }
                catch (Throwable var27_36) {
                    throw var27_36;
                }
                finally {
                    var12_14 = Config.val;
                    synchronized (Config.val) {
                        if (!cancel) {
                            Config.val[flag] = res;
                        }
                        Config.val.notify();
                        // ** MonitorExit[var12_14] (shouldn't be in output)
                        if (stopSession) {
                            sInfo.stopSession();
                        }
                        IscobolSystem.destroyEnv(Thread.currentThread());
                    }
                }
            }
lbl-1000:
            // 2 sources

            {
                return;
            }
        }
    }

    static {
        filesep = File.separator;
        systemDir = filesep + "etc";
        shouldStartDebugListener = true;
        a = new byte[]{67, 108, 105, 101, 110, 116, 115, 32, 110, 117, 109, 98, 101, 114, 32, 101, 120, 99, 101, 101, 100, 115, 33, 10};
        E = new byte[]{108, 105, 99, 105, 110, 102, 111};
        F = new byte[]{101, 120, 112, 105, 114, 101, 100};
        ni = new byte[]{105, 115, 99, 111, 98, 111, 108, 46, 108, 105, 99, 101, 110, 115, 101, 46, 50, 48, 50, 52};
        d = new byte[]{121, 121, 121, 121, 77, 77, 100, 100};
        qi = new byte[]{20, 87, -101, -121, 24, 71, 52, -22};
        m = new byte[]{77, 105, 115, 115, 105, 110, 103, 32, 76, 105, 99, 101, 110, 115, 101, 58, 32, 84, 104, 101, 32, 108, 105, 99, 101, 110, 115, 101, 32, 107, 101, 121, 32, 105, 115, 32, 109, 105, 115, 115, 105, 110, 103, 44, 32, 105, 110, 118, 97, 108, 105, 100, 32, 111, 114, 32, 104, 97, 115, 32, 101, 120, 112, 105, 114, 101, 100, 33, 10, 67, 104, 101, 99, 107, 32, 121, 111, 117, 114, 32, 112, 114, 111, 112, 101, 114, 116, 105, 101, 115, 32, 102, 105, 108, 101, 115, 32, 111, 114, 32, 99, 111, 110, 116, 97, 99, 116, 32, 86, 101, 114, 121, 97, 110, 116, 32, 111, 114, 32, 121, 111, 117, 114, 32, 100, 105, 115, 116, 114, 105, 98, 117, 116, 111, 114, 32, 102, 111, 114, 32, 116, 101, 99, 104, 110, 105, 99, 97, 108, 32, 115, 117, 112, 112, 111, 114, 116, 46};
        d1 = new byte[]{32, 87, 105, 116, 104, 32, 121, 111, 117, 114, 32, 104, 97, 114, 100, 119, 97, 114, 101, 32, 107, 101, 121, 61};
        sd1 = "";
        d2 = new byte[]{108, 105, 99};
        d3 = new byte[]{97, 99, 116, 105, 118, 97, 116, 101};
        pi = new byte[]{114, 117, 110, 116, 105, 109, 101};
        pic = new byte[]{99, 111, 109, 112, 105, 108, 101, 114};
        pie = new byte[]{101, 105, 115};
        piea = new byte[]{101, 97, 115, 121, 100, 98};
        pe = null;
        pv = new byte[]{50, 48, 50, 52};
        lc = new byte[]{46, 108, 105, 99, 101, 110, 115, 101};
        dli = new byte[]{73, 83, 67, 79, 66, 79, 76, 95, 76, 73, 67};
        uh = new byte[]{117, 115, 101, 114, 46, 104, 111, 109, 101};
        cL = new byte[]{64};
        cC = new byte[]{95};
        cDt = new byte[]{46};
        errgeneric = new byte[]{80, 114, 111, 98, 108, 101, 109, 32, 111, 110, 32, 105, 115, 99, 111, 98, 111, 108, 32, 108, 105, 99, 101, 110, 115, 101};
        err = new String[4];
        val = new char[]{' ', ' ', ' ', ' '};
        use = new char[]{' ', ' ', ' ', ' '};
        spiR = RtsUtil.newUTFString(pi);
        speR = null;
        spvR = RtsUtil.newUTFString(pv);
        eol = System.getProperty("line.separator", "\n");
        mas1 = new byte[]{76, 105, 99, 101, 110, 115, 101, 32, 117, 115, 101, 114, 32, 99, 111, 117, 110, 116, 32, 101, 120, 99, 101, 101, 100, 101, 100, 46, 32, 67, 117, 114, 114, 101, 110, 116, 32, 109, 97, 120, 105, 109, 117, 109, 32, 110, 117, 109, 98, 101, 114, 32, 111, 102, 32, 97, 108, 108, 111, 119, 101, 100, 32, 117, 115, 101, 114, 115, 58, 32};
        mas2 = new byte[]{32, 87, 101, 98, 32, 67, 108, 105, 101, 110, 116, 115};
        mas3 = -777;
        wc1 = new byte[]{111, 114, 103, 46, 119, 101, 98, 115, 119, 105, 110, 103, 46, 83, 119, 105, 110, 103, 77, 97, 105, 110};
        wc2 = new byte[]{110, 111, 32, 87, 101, 98, 67, 108, 105, 101, 110, 116, 32, 101, 110, 118, 105, 114, 111, 110, 109, 101, 110, 116};
        suff = new byte[]{105, 115, 99, 111, 98, 111, 108, 46};
        suffC = new byte[]{105, 115, 99, 111, 98, 111, 108, 46, 99, 111, 109, 112, 105, 108, 101, 114, 46};
        suffEa = new byte[]{105, 115, 99, 111, 98, 111, 108, 46, 101, 97, 115, 121, 100, 98, 46};
        suffE = new byte[]{105, 115, 99, 111, 98, 111, 108, 46, 101, 105, 115, 46};
        mla = new byte[]{32, 65, 99, 116, 105, 118, 97, 116, 105, 111, 110, 32, 114, 101, 113, 117, 105, 114, 101, 100};
        mla1 = new byte[]{32, 100, 97, 121, 115, 32, 108, 101, 102, 116, 33};
        mla2 = new byte[]{32, 99, 111, 117, 108, 100, 32, 98, 101, 32, 99, 114, 101, 97, 116, 101, 100, 32, 102, 111, 114, 32, 109, 97, 110, 117, 97, 108, 32, 97, 99, 116, 105, 118, 97, 116, 105, 111, 110, 44, 32, 99, 104, 101, 99, 107, 32, 100, 101, 116, 97, 105, 108, 115, 32, 111, 110, 32, 104, 116, 116, 112, 115, 58, 47, 47, 108, 105, 99, 101, 110, 115, 101, 46, 118, 101, 114, 121, 97, 110, 116, 46, 99, 111, 109, 47, 97, 99, 116, 105, 118, 97, 116, 101};
        mla3 = new byte[]{32, 77, 97, 120, 32, 110, 117, 109, 98, 101, 114, 32, 111, 102, 32, 97, 99, 116, 105, 118, 97, 116, 105, 111, 110, 115, 32, 114, 101, 97, 99, 104, 101, 100};
        mla4 = new byte[]{32, 67, 111, 110, 116, 97, 99, 116, 32, 86, 101, 114, 121, 97, 110, 116, 32, 111, 114, 32, 121, 111, 117, 114, 32, 100, 105, 115, 116, 114, 105, 98, 117, 116, 111, 114, 32, 102, 111, 114, 32, 116, 101, 99, 104, 110, 105, 99, 97, 108, 32, 115, 117, 112, 112, 111, 114, 116, 46};
        allProp = new Hashtable();
        pk = "30819f300d06092a864886f70d010101050003818d003081893032301006072a8648ce3d02002EC311215SHA512withECDSA106052b81040006031e0004c06c5d6b4dbb943eee9fe58068320162ad4be4c950d9eba35e43bea4G02818100cfa43124a331b137a6bb89e6fe7025694a00f27873ed9fe61a2aac232c5600770238bb79e3cf6c5bcd6296f809ff283735953d594c2c3518860589e4fe06fd65bbc2ef61b66dde9fd1083b2518baf67a3040ccb97dd763dfe8a6278080af0bd103RSA4102413SHA512withRSA1017469c566172c3a70cf50f46db7d53da6fba0108d4b46f46f00b11248f9ee70203010001";
        pkc = "30819f300d06092a864886f70d010101050003818d003081893032301006072a8648ce3d02002EC311215SHA512withECDSA106052b81040006031e00046f20487a2fbe182d2052421d6981928a56dd50dde2ab15815f31188bG0281810094393640938df8728462cdeb57e26b480f6f4c0990c442eb3f8bd9ff674121034446caee8ca6c8c0edcd5fe66670c2bcc73559f32491f82694aefc64771c07a87710cb0816352292ef3ce7b6feae06a9bd5dd879f3f651675daa8d3ceb79956f03RSA4102413SHA512withRSA9438035da979fbfc662c16736f5b651f218e10f90e5ef21d1bd58ce8051901eb0203010001";
        pke = "30819f300d06092a864886f70d010101050003818d003081893032301006072a8648ce3d02002EC311215SHA512withECDSA106052b81040006031e0004c995e7bb2076e7d7e833a562d57551185e45807869e4d83a82f793d1G0281810089b5b9fc7497e0cb53afb0d08f8a3defe545cb0af3b0168eec15168e8df48ee61c94c47e1fe7386c50bbdccf8ddb95aab8c4276612703526e21491ac89b375d0d22e45279e933349c91f257d192618f8a16b1bf142842c390b786ac8fbbfd71b03RSA4102413SHA512withRSA1272f844de93291c7bc07b1c1c67f9128ec203b9fb2a5350281f7d45aa007ea50203010001";
        pkea = "30819f300d06092a864886f70d010101050003818d003081893032301006072a8648ce3d02002EC311215SHA512withECDSA106052b81040006031e0004acd02f2eefbdb2a16e1f61b0b2318c216ef27c2d5308cd27a3e1f693G02818100b006844969bebe7703808a04e8ceea03d175f7cc179a6fddfda516ddfbfc8de1fb0721abbaaa7f99f5bdd8ec6fc688e30251a6de84af750e67f6e83fdcdd645e88126ad6f60ff84dad65216a37824d86d7a702eb5411936e332d28c84789a05c03RSA4102413SHA512withRSAabda77dddc9b9295759ac6baed8016b9496ede8774c2ef5c1324fceeae7dfae10203010001";
        hID = new String[4];
        htu = new byte[]{104, 116, 116, 112, 115, 58, 47, 47, 108, 105, 99, 101, 110, 115, 101, 46, 118, 101, 114, 121, 97, 110, 116, 46, 99, 111, 109, 47, 97, 108, 103, 97, 115, 47};
        lck = new Object();
        LITTLE_ENDIAN = Config.isLittleEndian();
        try {
            java.util.logging.Logger log = java.util.logging.Logger.getLogger(LicenseValidator.class.getName());
            if (log != null) {
                log.setLevel(Level.OFF);
            }
        }
        catch (Throwable log) {
            // empty catch block
        }
        try {
            Class.forName("com.iscobol.rts.StickyConfig");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        allProp.put("iscobol.accept_timeout", "description");
        allProp.put("iscobol.apply_file_path", "alias iscobol.file.apply_file_path");
        allProp.put("iscobol.array_cache", "description");
        allProp.put("iscobol.array_check", "description");
        allProp.put("iscobol.as.authentication", "description");
        allProp.put("iscobol.as.check_alive_interval", "description");
        allProp.put("iscobol.as.clientupdate.propfile", "description");
        allProp.put("iscobol.as.clientupdate.site", "description");
        allProp.put("iscobol.as.clientupdate.version", "description");
        allProp.put("iscobol.as.debugport_range", "description");
        allProp.put("iscobol.as.digest", "description");
        allProp.put("iscobol.as.keepalive", "description");
        allProp.put("iscobol.as.logfile", "description");
        allProp.put("iscobol.as.logging", "description");
        allProp.put("iscobol.as.max_connections", "description");
        allProp.put("iscobol.as.stop_thread", "description");
        allProp.put("iscobol.as.turborun.chdir", "description");
        allProp.put("iscobol.auto_input_mode", "description");
        allProp.put("iscobol.background_intensity", "description");
        allProp.put("iscobol.binary_file_prefix", "alias iscobol.file.binary_file_prefix");
        allProp.put("iscobol.bitmap_scale.best_quality", "description");
        allProp.put("iscobol.call_program.set_switches", "description");
        allProp.put("iscobol.check.numeric_content", "description");
        allProp.put("iscobol.checkdiv", "description");
        allProp.put("iscobol.close_on_exit", "alias iscobol.file.close_on_exit");
        allProp.put("iscobol.code_prefix", "description");
        allProp.put("iscobol.code_prefix.reload", "description");
        allProp.put("iscobol.apply_code_path", "description");
        allProp.put("iscobol.colormap.high", "description");
        allProp.put("iscobol.colormap.low", "description");
        allProp.put("iscobol.colormap.reverse", "description");
        allProp.put("iscobol.column_separation", "alias iscobol.gui.column_separation");
        allProp.put("iscobol.conf", "description");
        allProp.put("iscobol.conf.only", "description");
        allProp.put("iscobol.conf.var_delimiters", "description");
        allProp.put("iscobol.current_date", "description");
        allProp.put("iscobol.debug.code_prefix", "description");
        allProp.put("iscobol.debug.embedded_source", "description");
        allProp.put("iscobol.debug.port", "description");
        allProp.put("iscobol.debug.remote_source", "description");
        allProp.put("iscobol.debug.remote_source_enabled", "description");
        allProp.put("iscobol.debug_code_prefix", "alias iscobol.debug.code_prefix");
        allProp.put("iscobol.default_options", "description");
        allProp.put("iscobol.default_program", "description");
        allProp.put("iscobol.display_message", "description");
        allProp.put("iscobol.display_message_timeout", "description");
        allProp.put("iscobol.dll_convention", "description");
        allProp.put("iscobol.easydb.date_cutoff", "description");
        allProp.put("iscobol.easydb.dirlevel", "description");
        allProp.put("iscobol.easydb.filename_mapping", "description");
        allProp.put("iscobol.easydb.inv_date", "description");
        allProp.put("iscobol.easydb.mapping", "");
        allProp.put("iscobol.easydb.max_date", "description");
        allProp.put("iscobol.easydb.min_date", "description");
        allProp.put("iscobol.easydb.postgres_row_limit", "description");
        allProp.put("iscobol.easydb_date_cutoff", "alias iscobol.easydb.date_cutoff");
        allProp.put("iscobol.easydb_dirlevel", "alias iscobol.easydb.dirlevel");
        allProp.put("iscobol.easydb_inv_date", "alias iscobol.easydb.inv_date");
        allProp.put("iscobol.easydb_max_date", "alias iscobol.easydb.max_date");
        allProp.put("iscobol.easydb_min_date", "alias iscobol.easydb.min_date");
        allProp.put("iscobol.encoding", "description");
        allProp.put("iscobol.env.trunc_on_null", "description");
        allProp.put("iscobol.errors_ok", "alias iscobol.file.errors_ok");
        allProp.put("iscobol.esql.error.negative", "description");
        allProp.put("iscobol.esql.execute.hook", "description");
        allProp.put("iscobol.esql.picx_handling", "description");
        allProp.put("iscobol.esql.db2.row_data_as_bytes_threshold", "description");
        allProp.put("iscobol.esql.value_sqlcode_on_null", "description");
        allProp.put("iscobol.esql.value_too_many_rows", "description");
        allProp.put("iscobol.esql.warnings", "description");
        allProp.put("iscobol.exception.dump", "description");
        allProp.put("iscobol.exception.dumpfile", "description");
        allProp.put("iscobol.exception.java", "description");
        allProp.put("iscobol.exception.message", "description");
        allProp.put("iscobol.exception.prefix", "description");
        allProp.put("iscobol.exception_message", "alias iscobol.display_message");
        allProp.put("iscobol.expired", "description");
        allProp.put("iscobol.extend_creates", "alias iscobol.file.extend_creates");
        allProp.put("iscobol.extfh.intrinsic_file_manager", "description");
        allProp.put("iscobol.extfh.libname", "description");
        allProp.put("iscobol.f10_is_menu", "description");
        allProp.put("iscobol.fields_unboxed", "alias iscobol.gui.fields_unboxed");
        allProp.put("iscobol.file.apply_file_path", "description");
        allProp.put("iscobol.file.asa.strip_trailing_spaces", "description");
        allProp.put("iscobol.file.binary_file_prefix", "description");
        allProp.put("iscobol.file.case", "description");
        allProp.put("iscobol.file.close_on_exit", "description");
        allProp.put("iscobol.file.connector.program", "description");
        allProp.put("iscobol.file.connector.program.dcic", "description");
        allProp.put("iscobol.file.connector.program.mfc", "description");
        allProp.put("iscobol.file.connector.program.rmc", "description");
        allProp.put("iscobol.file.connector.program.vfc", "description");
        allProp.put("iscobol.file.env_naming", "description");
        allProp.put("iscobol.file.env_naming.prefix", "alias iscobol.file.env_naming_prefix");
        allProp.put("iscobol.file.env_naming_prefix", "description");
        allProp.put("iscobol.file.errors_ok", "description");
        allProp.put("iscobol.file.extend_creates", "description");
        allProp.put("iscobol.file.extra_keys_ok", "description");
        allProp.put("iscobol.file.index", "description");
        allProp.put("iscobol.file.index.", "description");
        allProp.put("iscobol.file.index.<n>.batchaddition", "description");
        allProp.put("iscobol.file.index.<n>.batchaddition.records", "description");
        allProp.put("iscobol.file.index.<n>.bulkaddition", "description");
        allProp.put("iscobol.file.index.<n>.connect", "description");
        allProp.put("iscobol.file.index.<n>.data_extension", "description");
        allProp.put("iscobol.file.index.<n>.datacompress", "description");
        allProp.put("iscobol.file.index.<n>.datacompress.level", "description");
        allProp.put("iscobol.file.index.<n>.datacompress.strategy", "description");
        allProp.put("iscobol.file.index.<n>.datacompress.type", "description");
        allProp.put("iscobol.file.index.<n>.encrypt", "description");
        allProp.put("iscobol.file.index.<n>.file_mapping", "description");
        allProp.put("iscobol.file.index.<n>.file_mapping_p<n>", "description");
        allProp.put("iscobol.file.index.<n>.fixed_length", "description");
        allProp.put("iscobol.file.index.<n>.index_extension", "description");
        allProp.put("iscobol.file.index.<n>.keycompress", "description");
        allProp.put("iscobol.file.index.<n>.keycompress.leading", "description");
        allProp.put("iscobol.file.index.<n>.keycompress.padding", "description");
        allProp.put("iscobol.file.index.<n>.keycompress.rle", "description");
        allProp.put("iscobol.file.index.<n>.keycompress.vlennod", "description");
        allProp.put("iscobol.file.index.<n>.log.error", "description");
        allProp.put("iscobol.file.index.<n>.log.file", "description");
        allProp.put("iscobol.file.index.<n>.log.info", "description");
        allProp.put("iscobol.file.index.<n>.log.profile", "description");
        allProp.put("iscobol.file.index.<n>.memoryfile", "description");
        allProp.put("iscobol.file.index.<n>.optimisticadd", "description");
        allProp.put("iscobol.file.index.<n>.path_mapping", "description");
        allProp.put("iscobol.file.index.<n>.prefetch", "description");
        allProp.put("iscobol.file.index.<n>.prefetch.records", "description");
        allProp.put("iscobol.file.index.<n>.prefetch.ttl", "description");
        allProp.put("iscobol.file.index.<n>.rowid", "description");
        allProp.put("iscobol.file.index.<n>.rowid.size", "description");
        allProp.put("iscobol.file.index.<n>.rpc", "description");
        allProp.put("iscobol.file.index.<n>.rpc.crc", "description");
        allProp.put("iscobol.file.index.<n>.server", "description");
        allProp.put("iscobol.file.index.<n>.transaction", "description");
        allProp.put("iscobol.file.index.<n>.transaction.logging", "description");
        allProp.put("iscobol.file.index.<n>.user", "description");
        allProp.put("iscobol.file.index.<n>.versioncheck", "description");
        allProp.put("iscobol.file.index.batchaddition", "description");
        allProp.put("iscobol.file.index.batchaddition.records", "description");
        allProp.put("iscobol.file.index.bulkaddition", "description");
        allProp.put("iscobol.file.index.check_all_keys", "description");
        allProp.put("iscobol.file.index.connect", "description");
        allProp.put("iscobol.file.index.data_extension", "description");
        allProp.put("iscobol.file.index.data_suffix", "description");
        allProp.put("iscobol.file.index.datacompress", "description");
        allProp.put("iscobol.file.index.datacompress.level", "description");
        allProp.put("iscobol.file.index.datacompress.strategy", "description");
        allProp.put("iscobol.file.index.datacompress.type", "description");
        allProp.put("iscobol.file.index.encrypt", "description");
        allProp.put("iscobol.file.index.file_mapping", "description");
        allProp.put("iscobol.file.index.file_mapping_p<n>", "description");
        allProp.put("iscobol.file.index.fixed_length", "description");
        allProp.put("iscobol.file.index.index_extension", "description");
        allProp.put("iscobol.file.index.index_suffix", "description");
        allProp.put("iscobol.file.index.keycompress", "description");
        allProp.put("iscobol.file.index.keycompress.leading", "description");
        allProp.put("iscobol.file.index.keycompress.padding", "description");
        allProp.put("iscobol.file.index.keycompress.rle", "description");
        allProp.put("iscobol.file.index.keycompress.vlennod", "description");
        allProp.put("iscobol.file.index.lock_read_anyhow", "description");
        allProp.put("iscobol.file.index.lock_wait", "description");
        allProp.put("iscobol.file.index.log.error", "description");
        allProp.put("iscobol.file.index.log.file", "description");
        allProp.put("iscobol.file.index.log.info", "description");
        allProp.put("iscobol.file.index.log.profile", "description");
        allProp.put("iscobol.file.index.maxinstance", "description");
        allProp.put("iscobol.file.index.memoryfile", "description");
        allProp.put("iscobol.file.index.memoryfile.persist", "description");
        allProp.put("iscobol.file.index.optimisticadd", "description");
        allProp.put("iscobol.file.index.path_mapping", "description");
        allProp.put("iscobol.file.index.prefetch", "description");
        allProp.put("iscobol.file.index.prefetch.records", "description");
        allProp.put("iscobol.file.index.prefetch.ttl", "description");
        allProp.put("iscobol.file.index.read_lock_test", "description");
        allProp.put("iscobol.file.index.rowid", "description");
        allProp.put("iscobol.file.index.rowid.size", "description");
        allProp.put("iscobol.file.index.rpc", "description");
        allProp.put("iscobol.file.index.rpc.crc", "description");
        allProp.put("iscobol.file.index.server", "description");
        allProp.put("iscobol.file.index.skiplock", "description");
        allProp.put("iscobol.file.index.ssl", "description");
        allProp.put("iscobol.file.index.sslcert", "description");
        allProp.put("iscobol.file.index.strip_extension", "description");
        allProp.put("iscobol.file.index.transaction", "description");
        allProp.put("iscobol.file.index.transaction.logging", "description");
        allProp.put("iscobol.file.index.user", "description");
        allProp.put("iscobol.file.index.version", "description");
        allProp.put("iscobol.file.index.versioncheck", "description");
        allProp.put("iscobol.file.indexed_file_prefix", "description");
        allProp.put("iscobol.file.input", "description");
        allProp.put("iscobol.file.input_nolock", "description");
        allProp.put("iscobol.file.io_creates", "description");
        allProp.put("iscobol.file.lock_manager", "description");
        allProp.put("iscobol.file.min_rec_size", "description");
        allProp.put("iscobol.file.open_check", "description");
        allProp.put("iscobol.file.output", "description");
        allProp.put("iscobol.file.page_eject_on_close", "description");
        allProp.put("iscobol.file.prefix", "description");
        allProp.put("iscobol.file.prefix_separator", "description");
        allProp.put("iscobol.file.relative", "description");
        allProp.put("iscobol.file.relative_file_prefix", "description");
        allProp.put("iscobol.file.remove_name_spaces", "description");
        allProp.put("iscobol.file.sequential", "description");
        allProp.put("iscobol.file.sequential_file_prefix", "description");
        allProp.put("iscobol.file.status", "description");
        allProp.put("iscobol.file.strip_trailing_spaces", "description");
        allProp.put("iscobol.file.suffix", "description");
        allProp.put("iscobol.file.xextfh", "description");
        allProp.put("iscobol.file_prefix", "alias iscobol.file.prefix");
        allProp.put("iscobol.file_prefix.separator", "alias iscobol.file.prefix_separator");
        allProp.put("iscobol.file_suffix", "alias iscobol.file.suffix");
        allProp.put("iscobol.filename.mapping", "alias iscobol.easydb.filename_mapping");
        allProp.put("iscobol.floating_point_format", "description");
        allProp.put("iscobol.font.default", "description");
        allProp.put("iscobol.font.fixed", "description");
        allProp.put("iscobol.font.handling", "description");
        allProp.put("iscobol.font.large", "description");
        allProp.put("iscobol.font.medium", "description");
        allProp.put("iscobol.font.small", "description");
        allProp.put("iscobol.font.traditional", "description");
        allProp.put("iscobol.gui.accept.before_time.repeat", "description");
        allProp.put("iscobol.gui.bitmap.event", "description");
        allProp.put("iscobol.gui.checkbox.event", "description");
        allProp.put("iscobol.gui.column_separation", "description");
        allProp.put("iscobol.gui.combobox.event", "description");
        allProp.put("iscobol.gui.csmaxbuffersize", "description");
        allProp.put("iscobol.gui.cstimeout", "description");
        allProp.put("iscobol.gui.curr_bcolor", "description");
        allProp.put("iscobol.gui.curr_ef_bcolor", "description");
        allProp.put("iscobol.gui.curr_ef_fcolor", "description");
        allProp.put("iscobol.gui.curr_fcolor", "description");
        allProp.put("iscobol.gui.date_entry.century_date", "description");
        allProp.put("iscobol.gui.date_entry.cutoff", "description");
        allProp.put("iscobol.gui.date_entry.display_format", "description");
        allProp.put("iscobol.gui.date_entry.errormessage", "description");
        allProp.put("iscobol.gui.date_entry.long_date", "description");
        allProp.put("iscobol.gui.date_entry.time", "description");
        allProp.put("iscobol.gui.date_entry.validate", "description");
        allProp.put("iscobol.gui.dateentry.event", "description");
        allProp.put("iscobol.gui.disabled_field_color", "description");
        allProp.put("iscobol.gui.dpifontscaling", "description");
        allProp.put("iscobol.gui.ef.ext_message", "description");
        allProp.put("iscobol.gui.entryfield.event", "description");
        allProp.put("iscobol.gui.entryfield.notify_change_delay", "description");
        allProp.put("iscobol.gui.entryfield.read_only_color", "description");
        allProp.put("iscobol.gui.entryfield.read_only_cursor_arrow", "description");
        allProp.put("iscobol.gui.events_list", "description");
        allProp.put("iscobol.gui.exclude_events", "description");
        allProp.put("iscobol.gui.f4_drops_combobox", "description");
        allProp.put("iscobol.gui.factory.class", "description");
        allProp.put("iscobol.gui.fields_unboxed", "description");
        allProp.put("iscobol.gui.from_fields_refreshed_in_accept", "alias iscobol.gui.input_predisplay");
        allProp.put("iscobol.gui.grid.event", "description");
        allProp.put("iscobol.gui.grid.extended_finish_reason", "description");
        allProp.put("iscobol.gui.grid.find_delay", "description");
        allProp.put("iscobol.gui.grid.lm_on_columns", "description");
        allProp.put("iscobol.gui.hints_off", "description");
        allProp.put("iscobol.gui.hints_on", "description");
        allProp.put("iscobol.gui.icon", "description");
        allProp.put("iscobol.gui.icon_file", "description");
        allProp.put("iscobol.gui.icons_scaling", "description");
        allProp.put("iscobol.gui.ignore_invalid_handle", "description");
        allProp.put("iscobol.gui.implied_decimal", "alias iscobol.gui.entryfield.implied_decimal");
        allProp.put("iscobol.gui.independent.icon", "description");
        allProp.put("iscobol.gui.javabean.event", "description");
        allProp.put("iscobol.gui.justify_num_fields", "description");
        allProp.put("iscobol.gui.kbd_case", "description");
        allProp.put("iscobol.gui.keyboard_buffering", "description");
        allProp.put("iscobol.gui.keyboard_enab_when_destroy", "description");
        allProp.put("iscobol.gui.label.rtrim", "description");
        allProp.put("iscobol.gui.layout_manager", "description");
        allProp.put("iscobol.gui.layout_manager.max_font_zoom", "description");
        allProp.put("iscobol.gui.layout_manager.min_font_zoom", "description");
        allProp.put("iscobol.gui.light_gray_is_transparent", "description");
        allProp.put("iscobol.gui.lightweightpopup", "description");
        allProp.put("iscobol.gui.list.lm_on_columns", "description");
        allProp.put("iscobol.gui.listbox.event", "description");
        allProp.put("iscobol.gui.max_text_in_bytes", "description");
        allProp.put("iscobol.gui.messagebox.bcolor", "description");
        allProp.put("iscobol.gui.messagebox.fcolor", "description");
        allProp.put("iscobol.gui.messagebox.font", "description");
        allProp.put("iscobol.gui.messagebox.centered", "description");
        allProp.put("iscobol.gui.messagebox.custom_prog", "description");
        allProp.put("iscobol.gui.mouse_disabled", "description");
        allProp.put("iscobol.gui.native_name", "description");
        allProp.put("iscobol.gui.nested_embedded_proc_check", "description");
        allProp.put("iscobol.gui.ntf_resized_delay", "description");
        allProp.put("iscobol.gui.placeholder_color", "description");
        allProp.put("iscobol.gui.push_activated_by_enter", "description");
        allProp.put("iscobol.gui.push_override_focus_change", "description");
        allProp.put("iscobol.gui.pushbutton.event", "description");
        allProp.put("iscobol.gui.quit_mode", "description");
        allProp.put("iscobol.gui.radiobutton.event", "description");
        allProp.put("iscobol.gui.rollover_border_color", "description");
        allProp.put("iscobol.gui.rollover_border_width", "description");
        allProp.put("iscobol.gui.screen_col_plus_base", "description");
        allProp.put("iscobol.gui.screen_col_zero", "description");
        allProp.put("iscobol.gui.scrn_size_cols", "description");
        allProp.put("iscobol.gui.scrn_size_rows", "description");
        allProp.put("iscobol.gui.scrollbar.event", "description");
        allProp.put("iscobol.gui.show_zeroes", "description");
        allProp.put("iscobol.gui.tab.event", "description");
        allProp.put("iscobol.gui.tool_bar.native", "description");
        allProp.put("iscobol.gui.treeview.event", "description");
        allProp.put("iscobol.gui.treeview.selection_delay", "description");
        allProp.put("iscobol.gui.web_browser.home", "description");
        allProp.put("iscobol.gui.web_browser.search", "description");
        allProp.put("iscobol.gui.webbrowser.class", "description");
        allProp.put("iscobol.gui.webbrowser.event", "description");
        allProp.put("iscobol.gui.window.auto_resize.fixed_dim", "description");
        allProp.put("iscobol.gui.window_title", "description");
        allProp.put("iscobol.gui.windows_darkening", "description");
        allProp.put("iscobol.gui.windows_modality", "description");
        allProp.put("iscobol.gui.windows_uncropped", "description");
        allProp.put("iscobol.guifactory.class", "alias iscobol.gui.factory_class");
        allProp.put("iscobol.help_program", "description");
        allProp.put("iscobol.help_program_mouse_stop_delay", "description");
        allProp.put("iscobol.hints_off", "alias iscobol.gui.hints_off");
        allProp.put("iscobol.hints_on", "alias iscobol.gui.hints_on");
        allProp.put("iscobol.hostname", "description");
        allProp.put("iscobol.hot_key", "description");
        allProp.put("iscobol.http.cookies_as_fields", "description");
        allProp.put("iscobol.http.form.encoding", "description");
        allProp.put("iscobol.http.ignore_certificates", "description");
        allProp.put("iscobol.http.upload.directory", "description");
        allProp.put("iscobol.http.upload.max_size", "description");
        allProp.put("iscobol.http.upload.prefix", "description");
        allProp.put("iscobol.http.value_prefix_colon", "description");
        allProp.put("iscobol.icon", "alias iscobol.gui.icon");
        allProp.put("iscobol.ignore_invalid_handle", "alias iscobol.gui.ignore_invalid_handle");
        allProp.put("iscobol.indexed_file_prefix", "alias iscobol.file.indexed_file_prefix");
        allProp.put("iscobol.io_creates", "alias iscobol.file.io_creates");
        allProp.put("iscobol.jdbc.allocate.type", "alias iscobol.jdbc.allocate_type");
        allProp.put("iscobol.jdbc.allocate_type", "description");
        allProp.put("iscobol.jdbc.autocommit", "description");
        allProp.put("iscobol.jdbc.connection.login.timeout", "description");
        allProp.put("iscobol.jdbc.cursor.concurrency", "description");
        allProp.put("iscobol.jdbc.cursor.type", "description");
        allProp.put("iscobol.jdbc.datasource", "description");
        allProp.put("iscobol.jdbc.dateformat", "description");
        allProp.put("iscobol.jdbc.driver", "description");
        allProp.put("iscobol.jdbc.fetch_size", "description");
        allProp.put("iscobol.jdbc.kept_spaces", "description");
        allProp.put("iscobol.jdbc.on_stop_run", "description");
        allProp.put("iscobol.jdbc.options", "description");
        allProp.put("iscobol.jdbc.password", "description");
        allProp.put("iscobol.jdbc.timeformat", "description");
        allProp.put("iscobol.jdbc.timestampformat", "description");
        allProp.put("iscobol.jdbc.url", "description");
        allProp.put("iscobol.jdbc.user", "description");
        allProp.put("iscobol.jisam.autolock_allowed", "iscobol.file.index.autolock_allowed");
        allProp.put("iscobol.jisam.version", "description");
        allProp.put("iscobol.jsonstream.allow_backslash_escaping_any_character", "description");
        allProp.put("iscobol.jsonstream.indent_number", "description");
        allProp.put("iscobol.jsonstream.initialize_on_read", "description");
        allProp.put("iscobol.jsonstream.omit_empty_elements", "description");
        allProp.put("iscobol.jsonstream.rtrim", "description");
        allProp.put("iscobol.justify_num_fields", "alias iscobol.gui.justify_num_fields");
        allProp.put("iscobol.jvm_options", "description");
        allProp.put("iscobol.kbd_auto_return", "alias iscobol.keyboard.kbd_auto_return");
        allProp.put("iscobol.key.*add", "description");
        allProp.put("iscobol.key.*backspace", "description");
        allProp.put("iscobol.key.*clear", "description");
        allProp.put("iscobol.key.*decimal", "description");
        allProp.put("iscobol.key.*delete", "description");
        allProp.put("iscobol.key.*divide", "description");
        allProp.put("iscobol.key.*down", "description");
        allProp.put("iscobol.key.*end", "description");
        allProp.put("iscobol.key.*enter", "description");
        allProp.put("iscobol.key.*f1", "description");
        allProp.put("iscobol.key.*f10", "description");
        allProp.put("iscobol.key.*f11", "description");
        allProp.put("iscobol.key.*f12", "description");
        allProp.put("iscobol.key.*f13", "description");
        allProp.put("iscobol.key.*f14", "description");
        allProp.put("iscobol.key.*f15", "description");
        allProp.put("iscobol.key.*f16", "description");
        allProp.put("iscobol.key.*f17", "description");
        allProp.put("iscobol.key.*f18", "description");
        allProp.put("iscobol.key.*f19", "description");
        allProp.put("iscobol.key.*f2", "description");
        allProp.put("iscobol.key.*f20", "description");
        allProp.put("iscobol.key.*f3", "description");
        allProp.put("iscobol.key.*f4", "description");
        allProp.put("iscobol.key.*f5", "description");
        allProp.put("iscobol.key.*f6", "description");
        allProp.put("iscobol.key.*f7", "description");
        allProp.put("iscobol.key.*f8", "description");
        allProp.put("iscobol.key.*f9", "description");
        allProp.put("iscobol.key.*help", "description");
        allProp.put("iscobol.key.*home", "description");
        allProp.put("iscobol.key.*insert", "description");
        allProp.put("iscobol.key.*left", "description");
        allProp.put("iscobol.key.*multiply", "description");
        allProp.put("iscobol.key.*numpad0", "description");
        allProp.put("iscobol.key.*numpad1", "description");
        allProp.put("iscobol.key.*numpad2", "description");
        allProp.put("iscobol.key.*numpad3", "description");
        allProp.put("iscobol.key.*numpad4", "description");
        allProp.put("iscobol.key.*numpad5", "description");
        allProp.put("iscobol.key.*numpad6", "description");
        allProp.put("iscobol.key.*numpad7", "description");
        allProp.put("iscobol.key.*numpad8", "description");
        allProp.put("iscobol.key.*numpad9", "description");
        allProp.put("iscobol.key.*pagedown", "description");
        allProp.put("iscobol.key.*pageup", "description");
        allProp.put("iscobol.key.*right", "description");
        allProp.put("iscobol.key.*subtract", "description");
        allProp.put("iscobol.key.*tab", "description");
        allProp.put("iscobol.key.*up", "description");
        allProp.put("iscobol.key.^*add", "description");
        allProp.put("iscobol.key.^*backspace", "description");
        allProp.put("iscobol.key.^*clear", "description");
        allProp.put("iscobol.key.^*decimal", "description");
        allProp.put("iscobol.key.^*delete", "description");
        allProp.put("iscobol.key.^*divide", "description");
        allProp.put("iscobol.key.^*down", "description");
        allProp.put("iscobol.key.^*end", "description");
        allProp.put("iscobol.key.^*enter", "description");
        allProp.put("iscobol.key.^*f1", "description");
        allProp.put("iscobol.key.^*f10", "description");
        allProp.put("iscobol.key.^*f11", "description");
        allProp.put("iscobol.key.^*f12", "description");
        allProp.put("iscobol.key.^*f13", "description");
        allProp.put("iscobol.key.^*f14", "description");
        allProp.put("iscobol.key.^*f15", "description");
        allProp.put("iscobol.key.^*f16", "description");
        allProp.put("iscobol.key.^*f17", "description");
        allProp.put("iscobol.key.^*f18", "description");
        allProp.put("iscobol.key.^*f19", "description");
        allProp.put("iscobol.key.^*f2", "description");
        allProp.put("iscobol.key.^*f20", "description");
        allProp.put("iscobol.key.^*f3", "description");
        allProp.put("iscobol.key.^*f4", "description");
        allProp.put("iscobol.key.^*f5", "description");
        allProp.put("iscobol.key.^*f6", "description");
        allProp.put("iscobol.key.^*f7", "description");
        allProp.put("iscobol.key.^*f8", "description");
        allProp.put("iscobol.key.^*f9", "description");
        allProp.put("iscobol.key.^*help", "description");
        allProp.put("iscobol.key.^*home", "description");
        allProp.put("iscobol.key.^*insert", "description");
        allProp.put("iscobol.key.^*left", "description");
        allProp.put("iscobol.key.^*multiply", "description");
        allProp.put("iscobol.key.^*numpad0", "description");
        allProp.put("iscobol.key.^*numpad1", "description");
        allProp.put("iscobol.key.^*numpad2", "description");
        allProp.put("iscobol.key.^*numpad3", "description");
        allProp.put("iscobol.key.^*numpad4", "description");
        allProp.put("iscobol.key.^*numpad5", "description");
        allProp.put("iscobol.key.^*numpad6", "description");
        allProp.put("iscobol.key.^*numpad7", "description");
        allProp.put("iscobol.key.^*numpad8", "description");
        allProp.put("iscobol.key.^*numpad9", "description");
        allProp.put("iscobol.key.^*pagedown", "description");
        allProp.put("iscobol.key.^*pageup", "description");
        allProp.put("iscobol.key.^*right", "description");
        allProp.put("iscobol.key.^*subtract", "description");
        allProp.put("iscobol.key.^*tab", "description");
        allProp.put("iscobol.key.^*up", "description");
        allProp.put("iscobol.key.^add", "description");
        allProp.put("iscobol.key.^backspace", "description");
        allProp.put("iscobol.key.^clear", "description");
        allProp.put("iscobol.key.^decimal", "description");
        allProp.put("iscobol.key.^delete", "description");
        allProp.put("iscobol.key.^divide", "description");
        allProp.put("iscobol.key.^down", "description");
        allProp.put("iscobol.key.^end", "description");
        allProp.put("iscobol.key.^enter", "description");
        allProp.put("iscobol.key.^f1", "description");
        allProp.put("iscobol.key.^f10", "description");
        allProp.put("iscobol.key.^f11", "description");
        allProp.put("iscobol.key.^f12", "description");
        allProp.put("iscobol.key.^f13", "description");
        allProp.put("iscobol.key.^f14", "description");
        allProp.put("iscobol.key.^f15", "description");
        allProp.put("iscobol.key.^f16", "description");
        allProp.put("iscobol.key.^f17", "description");
        allProp.put("iscobol.key.^f18", "description");
        allProp.put("iscobol.key.^f19", "description");
        allProp.put("iscobol.key.^f2", "description");
        allProp.put("iscobol.key.^f20", "description");
        allProp.put("iscobol.key.^f3", "description");
        allProp.put("iscobol.key.^f4", "description");
        allProp.put("iscobol.key.^f5", "description");
        allProp.put("iscobol.key.^f6", "description");
        allProp.put("iscobol.key.^f7", "description");
        allProp.put("iscobol.key.^f8", "description");
        allProp.put("iscobol.key.^f9", "description");
        allProp.put("iscobol.key.^help", "description");
        allProp.put("iscobol.key.^home", "description");
        allProp.put("iscobol.key.^insert", "description");
        allProp.put("iscobol.key.^left", "description");
        allProp.put("iscobol.key.^multiply", "description");
        allProp.put("iscobol.key.^numpad0", "description");
        allProp.put("iscobol.key.^numpad1", "description");
        allProp.put("iscobol.key.^numpad2", "description");
        allProp.put("iscobol.key.^numpad3", "description");
        allProp.put("iscobol.key.^numpad4", "description");
        allProp.put("iscobol.key.^numpad5", "description");
        allProp.put("iscobol.key.^numpad6", "description");
        allProp.put("iscobol.key.^numpad7", "description");
        allProp.put("iscobol.key.^numpad8", "description");
        allProp.put("iscobol.key.^numpad9", "description");
        allProp.put("iscobol.key.^pagedown", "description");
        allProp.put("iscobol.key.^pageup", "description");
        allProp.put("iscobol.key.^right", "description");
        allProp.put("iscobol.key.^subtract", "description");
        allProp.put("iscobol.key.^tab", "description");
        allProp.put("iscobol.key.^up", "description");
        allProp.put("iscobol.key.accepted_control_characters", "description");
        allProp.put("iscobol.key.add", "description");
        allProp.put("iscobol.key.backspace", "description");
        allProp.put("iscobol.key.clear", "description");
        allProp.put("iscobol.key.decimal", "description");
        allProp.put("iscobol.key.default_shortcuts_enabled", "description");
        allProp.put("iscobol.key.delete", "description");
        allProp.put("iscobol.key.divide", "description");
        allProp.put("iscobol.key.down", "description");
        allProp.put("iscobol.key.end", "description");
        allProp.put("iscobol.key.enter", "description");
        allProp.put("iscobol.key.f1", "description");
        allProp.put("iscobol.key.f10", "description");
        allProp.put("iscobol.key.f11", "description");
        allProp.put("iscobol.key.f12", "description");
        allProp.put("iscobol.key.f13", "description");
        allProp.put("iscobol.key.f14", "description");
        allProp.put("iscobol.key.f15", "description");
        allProp.put("iscobol.key.f16", "description");
        allProp.put("iscobol.key.f17", "description");
        allProp.put("iscobol.key.f18", "description");
        allProp.put("iscobol.key.f19", "description");
        allProp.put("iscobol.key.f2", "description");
        allProp.put("iscobol.key.f20", "description");
        allProp.put("iscobol.key.f3", "description");
        allProp.put("iscobol.key.f4", "description");
        allProp.put("iscobol.key.f5", "description");
        allProp.put("iscobol.key.f6", "description");
        allProp.put("iscobol.key.f7", "description");
        allProp.put("iscobol.key.f8", "description");
        allProp.put("iscobol.key.f9", "description");
        allProp.put("iscobol.key.help", "description");
        allProp.put("iscobol.key.home", "description");
        allProp.put("iscobol.key.insert", "description");
        allProp.put("iscobol.key.left", "description");
        allProp.put("iscobol.key.multiply", "description");
        allProp.put("iscobol.key.numpad0", "description");
        allProp.put("iscobol.key.numpad1", "description");
        allProp.put("iscobol.key.numpad2", "description");
        allProp.put("iscobol.key.numpad3", "description");
        allProp.put("iscobol.key.numpad4", "description");
        allProp.put("iscobol.key.numpad5", "description");
        allProp.put("iscobol.key.numpad6", "description");
        allProp.put("iscobol.key.numpad7", "description");
        allProp.put("iscobol.key.numpad8", "description");
        allProp.put("iscobol.key.numpad9", "description");
        allProp.put("iscobol.key.pagedown", "description");
        allProp.put("iscobol.key.pageup", "description");
        allProp.put("iscobol.key.right", "description");
        allProp.put("iscobol.key.subtract", "description");
        allProp.put("iscobol.key.system", "description");
        allProp.put("iscobol.key.tab", "description");
        allProp.put("iscobol.key.up", "description");
        allProp.put("iscobol.keyboard.kbd_auto_return", "description");
        allProp.put("iscobol.keyboard.kbd_case", "description");
        allProp.put("iscobol.keyboard.kbd_check_numbers", "description");
        allProp.put("iscobol.keyboard.kbd_cursor_past_end", "description");
        allProp.put("iscobol.keyboard.kbd_data_range", "description");
        allProp.put("iscobol.keyboard.kbd_exception_range", "description");
        allProp.put("iscobol.keyboard.kbd_implied_decimal", "description");
        allProp.put("iscobol.keyboard.kbd_rm_2_default_handling", "description");
        allProp.put("iscobol.keyboard.kbd_screen_default", "description");
        allProp.put("iscobol.keysen.method", "description");
        allProp.put("iscobol.license", "description");
        allProp.put("iscobol.licinfo", "description");
        allProp.put("iscobol.lightweightpopup", "alias iscobol.gui.lightweightpopup");
        allProp.put("iscobol.little_endian", "description");
        allProp.put("iscobol.logfile", "description");
        allProp.put("iscobol.logfile.append", "description");
        allProp.put("iscobol.logfile.maxlen", "description");
        allProp.put("iscobol.logfile.number", "description");
        allProp.put("iscobol.logfile.thread", "description");
        allProp.put("iscobol.math.fpp36", "description");
        allProp.put("iscobol.memory.alpha_edited", "description");
        allProp.put("iscobol.message.cancel", "description");
        allProp.put("iscobol.message.no", "description");
        allProp.put("iscobol.message.ok", "description");
        allProp.put("iscobol.message.yes", "description");
        allProp.put("iscobol.min_rec_size", "alias iscobol.file.min_rec_size");
        allProp.put("iscobol.national.acu_compatibility", "description");
        allProp.put("iscobol.net.ssl.key_store", "description");
        allProp.put("iscobol.net.ssl.key_store_password", "description");
        allProp.put("iscobol.net.ssl.trust_store", "description");
        allProp.put("iscobol.net.ssl.trust_store_password", "descriptin");
        allProp.put("iscobol.os.name", "description");
        allProp.put("iscobol.port", "description");
        allProp.put("iscobol.print.default_font", "description");
        allProp.put("iscobol.print.memory", "description");
        allProp.put("iscobol.print.pdf_async", "description");
        allProp.put("iscobol.print.preview.icon", "description");
        allProp.put("iscobol.print.preview.title", "description");
        allProp.put("iscobol.print.spooler_async", "description");
        allProp.put("iscobol.printer.channels", "description");
        allProp.put("iscobol.printer.dialog.always", "description");
        allProp.put("iscobol.profiler.elapse_time", "description");
        allProp.put("iscobol.profiler.enable", "description");
        allProp.put("iscobol.properties", "description");
        allProp.put("iscobol.properties.acu_compat", "description");
        allProp.put("iscobol.properties.sources", "description");
        allProp.put("iscobol.quit_mode", "alias iscobol.gui.quit_mode");
        allProp.put("iscobol.recursion_data_global", "description");
        allProp.put("iscobol.redirect_streams", "alias iscobol.rundebug.redirect_streams");
        allProp.put("iscobol.relative_file_prefix", "alias iscobol.file.relative_file_prefix");
        allProp.put("iscobol.remote.conf", "description");
        allProp.put("iscobol.remote_conf", "alias iscobol.remote.conf");
        allProp.put("iscobol.resource.", "description");
        allProp.put("iscobol.resource.country", "description");
        allProp.put("iscobol.resource.file", "description");
        allProp.put("iscobol.resource.language", "description");
        allProp.put("iscobol.resource.variant", "description");
        allProp.put("iscobol.rundebug", "description");
        allProp.put("iscobol.rundebug.auto_pause", "description");
        allProp.put("iscobol.runtime.compile_flags.mandatory", "description");
        allProp.put("iscobol.runtime.compile_flags.prohibited", "description");
        allProp.put("iscobol.runtime.cs.version", "description");
        allProp.put("iscobol.runtime.currency", "description");
        allProp.put("iscobol.runtime.decimal_point_is_comma", "description");
        allProp.put("iscobol.runtime.fs.version", "description");
        allProp.put("iscobol.runtime.native.ignore_errors", "description");
        allProp.put("iscobol.runtime.version", "description");
        allProp.put("iscobol.sequential_file_prefix", "alias iscobol.file.sequential_file_prefix");
        allProp.put("iscobol.serialization.debug", "description");
        allProp.put("iscobol.shared_dlopen_null", "description");
        allProp.put("iscobol.shared_library_list", "description");
        allProp.put("iscobol.sort.dir", "description");
        allProp.put("iscobol.sort.maxfiles", "description");
        allProp.put("iscobol.sort.memsize", "description");
        allProp.put("iscobol.sqlserver.database", "description");
        allProp.put("iscobol.sqlserver.dirlevel", "description");
        allProp.put("iscobol.sqlserver.iss", "description");
        allProp.put("iscobol.sqlserver.iss.mapping", "description");
        allProp.put("iscobol.sqlserver.isspath", "description");
        allProp.put("iscobol.sqlserver.password", "description");
        allProp.put("iscobol.sqlserver.sysname", "description");
        allProp.put("iscobol.sshterminal", "description");
        allProp.put("iscobol.station", "description");
        allProp.put("iscobol.strip_trailing_spaces", "alias iscobol.file.strip_trailing_spaces");
        allProp.put("iscobol.substring.check", "description");
        allProp.put("iscobol.substring.unbound", "description");
        allProp.put("iscobol.substring.zero_len_all", "description");
        allProp.put("iscobol.substring_check", "alias iscobol.substring.check");
        allProp.put("iscobol.switches", "description");
        allProp.put("iscobol.system.exec", "description");
        allProp.put("iscobol.terminal.alpha_autoclear", "description");
        allProp.put("iscobol.terminal.autowrap", "description");
        allProp.put("iscobol.terminal.cursor_blink", "description");
        allProp.put("iscobol.terminal.cursor_color", "description");
        allProp.put("iscobol.terminal.cursor_type", "description");
        allProp.put("iscobol.terminal.data_range", "description");
        allProp.put("iscobol.terminal.double_byte_compat", "description");
        allProp.put("iscobol.terminal.drag_enabled", "description");
        allProp.put("iscobol.terminal.edited_formatted", "description");
        allProp.put("iscobol.terminal.info.132column", "description");
        allProp.put("iscobol.terminal.info.attributes", "description");
        allProp.put("iscobol.terminal.info.blink", "description");
        allProp.put("iscobol.terminal.info.client.name", "description");
        allProp.put("iscobol.terminal.info.color", "description");
        allProp.put("iscobol.terminal.info.drawing", "description");
        allProp.put("iscobol.terminal.info.dual_intensity", "description");
        allProp.put("iscobol.terminal.info.graphic", "description");
        allProp.put("iscobol.terminal.info.name", "description");
        allProp.put("iscobol.terminal.info.printer", "description");
        allProp.put("iscobol.terminal.info.refresh_monitor", "description");
        allProp.put("iscobol.terminal.info.remote", "description");
        allProp.put("iscobol.terminal.info.reverse", "description");
        allProp.put("iscobol.terminal.info.screem.physical.height", "description");
        allProp.put("iscobol.terminal.info.screen.columns", "description");
        allProp.put("iscobol.terminal.info.screen.lines", "description");
        allProp.put("iscobol.terminal.info.screen.physical.width", "description");
        allProp.put("iscobol.terminal.info.screen.usable.height", "description");
        allProp.put("iscobol.terminal.info.screen.usable.width", "description");
        allProp.put("iscobol.terminal.info.underline", "description");
        allProp.put("iscobol.terminal.kbd_case", "alias iscobol.keyboard.kbd_case");
        allProp.put("iscobol.terminal.no_autoclear", "description");
        allProp.put("iscobol.terminal.paste_key", "description");
        allProp.put("iscobol.terminal.screen_prompt", "description");
        allProp.put("iscobol.terminal.screen_prompt_all", "description");
        allProp.put("iscobol.terminal.update_from_screen", "description");
        allProp.put("iscobol.tracelevel", "description");
        allProp.put("iscobol.upper_lower_method", "description");
        allProp.put("iscobol.use_for_debugging", "description");
        allProp.put("iscobol.user.name", "description");
        allProp.put("iscobol.vision.f_locks_per_file", "description");
        allProp.put("iscobol.vision.f_log_buffer_size", "description");
        allProp.put("iscobol.vision.f_log_device", "description");
        allProp.put("iscobol.vision.f_log_encrypt", "description");
        allProp.put("iscobol.vision.f_log_file", "description");
        allProp.put("iscobol.vision.f_logdir", "description");
        allProp.put("iscobol.vision.f_logging", "description");
        allProp.put("iscobol.vision.f_maxfiles", "description");
        allProp.put("iscobol.vision.f_maxlocks", "description");
        allProp.put("iscobol.vision.f_trace", "description");
        allProp.put("iscobol.vision.f_version", "description");
        allProp.put("iscobol.vision.i_buffers", "description");
        allProp.put("iscobol.Vision.i_buffers", "description");
        allProp.put("iscobol.wbitmap.load_method", "description");
        allProp.put("iscobol.web_browser.home", "alias iscobol.gui.web_browser.home");
        allProp.put("iscobol.web_browser.search", "alias iscobol.gui.web_browser.search");
        allProp.put("iscobol.xmlstream.indent_number", "description");
        allProp.put("iscobol.xmlstream.initialize_on_read", "description");
        allProp.put("iscobol.xmlstream.omit_empty_elements", "description");
        allProp.put("iscobol.xmlstream.resolve_references", "description");
        allProp.put("iscobol.xmlstream.rtrim", "description");
        allProp.put("iscobol.hot_event.", "description");
    }

    private static class Context {
        int[][] ps = new int[][]{{196, 121, 228, 227}, {65, 99, 190, 210}, {127, 236, 81, 24}, {90, 102, 139, 237}, {245, 186, 63, 4}, {51, 226, 90, 232}, {182, 149, 8, 20}, {45, 44, 237, 221}, {187, 232, 197, 146}, {142, 54, 8, 21}, {193, 181, 33, 9}, {148, 241, 80, 122}, {91, 56, 201, 166}, {76, 56, 24, 127}, {61, 135, 99, 150}, {25, 88, 69, 69}};
        int[][] ks = new int[][]{{187, 80, 148, 52}, {60, 4, 93, 90}, {196, 121, 228, 227}, {245, 186, 63, 4}, {193, 181, 33, 9}, {182, 149, 8, 20}, {15, 223, 41, 148}, {118, 78, 27, 134}, {154, 111, 69, 110}, {117, 253, 9, 20}, {90, 250, 173, 255}, {193, 146, 14, 179}, {211, 175, 3, 170}, {180, 91, 146, 19}, {246, 100, 183, 114}, {36, 69, 52, 220}, {128, 203, 70, 66}, {212, 218, 57, 168}, {9, 21, 162, 103}, {45, 250, 78, 167}, {69, 188, 237, 156}, {216, 223, 126, 131}, {56, 150, 122, 91}, {143, 220, 192, 100}, {173, 84, 67, 89}, {147, 225, 118, 108}, {191, 5, 114, 6}, {53, 250, 237, 59}, {82, 146, 219, 15}, {80, 207, 225, 107}, {146, 218, 213, 76}, {114, 131, 170, 33}, {181, 98, 29, 194}, {109, 143, 150, 134}, {98, 76, 195, 98}, {226, 226, 67, 39}, {76, 56, 24, 127}, {91, 56, 201, 166}, {51, 226, 90, 232}, {45, 44, 237, 221}, {99, 160, 52, 103}, {250, 180, 158, 104}, {50, 232, 61, 68}, {47, 162, 121, 26}, {133, 201, 119, 193}, {133, 35, 71, 132}, {73, 111, 208, 158}, {129, 66, 123, 116}, {252, 162, 162, 149}, {152, 66, 126, 221}, {203, 36, 248, 19}, {142, 54, 8, 21}, {25, 88, 69, 69}, {127, 236, 81, 24}, {187, 232, 197, 146}, {126, 189, 221, 131}, {187, 235, 227, 131}, {238, 97, 93, 174}, {48, 150, 246, 32}, {252, 104, 44, 47}, {191, 183, 191, 107}, {33, 193, 213, 87}, {22, 60, 237, 228}, {163, 53, 138, 177}, {112, 171, 155, 5}, {19, 234, 173, 136}, {22, 169, 207, 197}, {206, 227, 73, 96}, {219, 117, 252, 22}, {126, 124, 151, 121}, {158, 108, 126, 105}, {152, 240, 123, 81}, {201, 134, 34, 39}, {221, 214, 6, 33}, {214, 213, 158, 56}, {220, 158, 244, 94}, {199, 11, 19, 126}, {108, 22, 46, 56}, {171, 242, 144, 89}, {53, 233, 72, 28}, {30, 244, 144, 34}, {38, 28, 1, 51}, {199, 147, 121, 178}, {254, 145, 200, 226}, {218, 240, 29, 219}, {197, 134, 51, 74}, {149, 70, 59, 235}, {82, 21, 136, 200}, {197, 109, 253, 47}, {197, 180, 54, 116}, {65, 90, 121, 107}, {12, 181, 91, 164}, {108, 156, 50, 101}, {96, 197, 62, 104}, {181, 223, 150, 89}, {199, 111, 212, 14}, {24, 107, 128, 132}, {146, 151, 61, 157}, {156, 163, 181, 156}, {223, 1, 70, 92}, {213, 136, 105, 83}, {22, 202, 230, 74}, {98, 53, 186, 218}, {109, 236, 195, 166}, {110, 99, 50, 90}, {102, 189, 173, 102}, {48, 229, 71, 123}, {77, 110, 32, 194}, {109, 43, 219, 223}, {189, 142, 197, 169}, {243, 193, 190, 165}, {27, 134, 239, 72}, {31, 207, 42, 233}, {23, 29, 31, 136}, {86, 153, 69, 65}, {48, 243, 130, 142}, {141, 254, 160, 63}, {47, 8, 112, 59}, {195, 251, 188, 244}, {169, 53, 238, 171}, {131, 39, 129, 105}, {127, 175, 43, 185}, {101, 54, 199, 38}, {95, 137, 4, 119}, {140, 120, 208, 173}, {67, 48, 130, 185}, {39, 89, 202, 253}, {239, 239, 89, 137}, {242, 225, 79, 18}, {117, 108, 104, 178}, {181, 52, 230, 98}, {179, 39, 62, 55}, {194, 18, 130, 95}, {209, 255, 145, 219}, {120, 85, 0, 250}, {197, 175, 199, 153}, {197, 120, 172, 28}, {209, 75, 111, 43}, {158, 12, 186, 44}, {2, 197, 199, 133}, {135, 67, 207, 143}, {177, 109, 54, 88}, {15, 103, 120, 33}, {4, 106, 209, 146}, {82, 97, 175, 191}, {107, 68, 216, 219}, {120, 53, 91, 190}, {38, 92, 56, 24}, {51, 131, 207, 115}, {187, 113, 9, 234}, {67, 6, 72, 171}, {130, 27, 15, 46}, {243, 23, 113, 50}, {28, 80, 59, 124}, {155, 40, 224, 79}, {245, 228, 41, 170}, {31, 75, 153, 68}, {200, 3, 161, 72}, {108, 171, 136, 208}, {25, 183, 24, 35}, {255, 15, 9, 175}, {187, 103, 47, 197}, {96, 92, 98, 23}, {73, 84, 49, 241}, {161, 18, 70, 58}, {175, 28, 151, 42}, {226, 205, 82, 201}, {160, 56, 133, 43}, {207, 195, 145, 109}, {32, 128, 77, 110}, {30, 74, 249, 77}, {250, 164, 233, 167}, {19, 81, 237, 141}, {72, 179, 131, 71}, {254, 228, 188, 204}, {240, 150, 238, 252}, {185, 171, 31, 163}, {35, 147, 44, 46}, {45, 105, 189, 43}, {222, 205, 233, 130}, {204, 127, 168, 117}, {107, 192, 252, 89}, {22, 105, 223, 18}, {223, 200, 235, 80}, {23, 62, 203, 139}, {156, 153, 101, 191}, {229, 50, 197, 231}, {207, 198, 200, 59}, {37, 21, 141, 42}, {240, 60, 155, 23}, {132, 211, 210, 211}, {71, 198, 19, 221}, {64, 244, 175, 91}, {99, 137, 144, 215}, {159, 28, 41, 187}, {163, 135, 31, 139}, {116, 138, 180, 228}, {176, 31, 248, 56}, {159, 155, 174, 71}, {255, 137, 255, 92}, {140, 70, 225, 77}, {81, 92, 69, 48}, {177, 159, 3, 221}, {52, 9, 134, 40}, {19, 86, 55, 219}, {130, 96, 170, 117}, {191, 56, 139, 165}, {223, 8, 71, 133}, {83, 171, 122, 151}, {61, 9, 27, 128}, {117, 52, 105, 134}, {89, 68, 148, 203}, {88, 242, 44, 71}, {62, 247, 74, 135}, {61, 34, 128, 39}, {191, 60, 130, 16}, {238, 156, 145, 114}, {255, 136, 171, 128}, {66, 82, 116, 239}, {235, 47, 226, 44}, {158, 214, 172, 96}, {188, 221, 112, 36}, {111, 210, 167, 4}, {119, 28, 73, 181}, {252, 255, 156, 187}, {102, 223, 88, 113}, {88, 11, 216, 220}, {178, 246, 158, 8}, {133, 83, 171, 120}, {95, 115, 173, 226}, {84, 99, 229, 174}, {209, 193, 218, 45}, {32, 98, 191, 153}, {186, 166, 165, 209}, {80, 150, 97, 209}, {152, 194, 59, 243}, {216, 221, 91, 231}, {51, 21, 244, 115}, {182, 51, 45, 236}, {34, 119, 212, 112}, {119, 49, 194, 232}, {179, 144, 63, 22}, {111, 210, 141, 233}, {112, 114, 60, 78}, {192, 194, 8, 3}, {58, 121, 206, 93}, {212, 9, 180, 5}, {175, 192, 22, 115}, {224, 160, 51, 44}, {69, 31, 12, 193}, {178, 138, 238, 101}, {74, 31, 120, 124}, {138, 142, 246, 228}, {42, 228, 32, 112}, {46, 169, 6, 100}, {171, 185, 186, 173}};

        private byte F(int x) {
            int idx = x & 0xFF;
            return (byte)(this.ks[idx][0] ^ this.ks[idx][1] ^ this.ks[idx][2] ^ this.ks[idx][3]);
        }

        private void eround(byte[] a, int oa, byte[] b, int ob, int n) {
            int n2 = oa;
            a[n2] = (byte)(a[n2] ^ (this.F(b[ob]) ^ this.ps[n][0]));
            int n3 = oa + 1;
            a[n3] = (byte)(a[n3] ^ (this.F(b[ob + 1]) ^ this.ps[n][1]));
            int n4 = oa + 2;
            a[n4] = (byte)(a[n4] ^ (this.F(b[ob + 2]) ^ this.ps[n][2]));
            int n5 = oa + 3;
            a[n5] = (byte)(a[n5] ^ (this.F(b[ob + 3]) ^ this.ps[n][3]));
        }

        private void dround(byte[] a, int oa, byte[] b, int ob, int n) {
            int n2 = oa + 3;
            a[n2] = (byte)(a[n2] ^ (this.F(b[ob + 3]) ^ this.ps[n][3]));
            int n3 = oa + 2;
            a[n3] = (byte)(a[n3] ^ (this.F(b[ob + 2]) ^ this.ps[n][2]));
            int n4 = oa + 1;
            a[n4] = (byte)(a[n4] ^ (this.F(b[ob + 1]) ^ this.ps[n][1]));
            int n5 = oa;
            a[n5] = (byte)(a[n5] ^ (this.F(b[ob]) ^ this.ps[n][0]));
        }

        private void e(byte[] c) {
            int ol = 0;
            int cnt = c.length;
            while (cnt >= 8) {
                int or = ol + 4;
                this.eround(c, or, c, ol, 0);
                this.eround(c, ol, c, or, 1);
                this.eround(c, or, c, ol, 2);
                this.eround(c, ol, c, or, 3);
                this.eround(c, or, c, ol, 4);
                this.eround(c, ol, c, or, 5);
                this.eround(c, or, c, ol, 6);
                this.eround(c, ol, c, or, 7);
                this.eround(c, or, c, ol, 8);
                this.eround(c, ol, c, or, 9);
                this.eround(c, or, c, ol, 10);
                this.eround(c, ol, c, or, 11);
                this.eround(c, or, c, ol, 12);
                this.eround(c, ol, c, or, 13);
                this.eround(c, or, c, ol, 14);
                this.eround(c, ol, c, or, 15);
                cnt -= 8;
                ol += 8;
            }
            while (ol < c.length) {
                int n = ol;
                c[n] = (byte)(c[n] ^ (this.F(ol % 256) ^ this.ps[ol % 16][ol % 4]));
                ++ol;
            }
        }

        private void d(byte[] c) {
            int ol = 0;
            int cnt = c.length;
            while (cnt >= 8) {
                int or = ol + 4;
                this.dround(c, ol, c, or, 15);
                this.dround(c, or, c, ol, 14);
                this.dround(c, ol, c, or, 13);
                this.dround(c, or, c, ol, 12);
                this.dround(c, ol, c, or, 11);
                this.dround(c, or, c, ol, 10);
                this.dround(c, ol, c, or, 9);
                this.dround(c, or, c, ol, 8);
                this.dround(c, ol, c, or, 7);
                this.dround(c, or, c, ol, 6);
                this.dround(c, ol, c, or, 5);
                this.dround(c, or, c, ol, 4);
                this.dround(c, ol, c, or, 3);
                this.dround(c, or, c, ol, 2);
                this.dround(c, ol, c, or, 1);
                this.dround(c, or, c, ol, 0);
                cnt -= 8;
                ol += 8;
            }
            while (ol < c.length) {
                int n = ol;
                c[n] = (byte)(c[n] ^ (this.F(ol % 256) ^ this.ps[ol % 16][ol % 4]));
                ++ol;
            }
        }

        Context(byte[] k) {
            int i;
            byte[] dataLR = new byte[8];
            int klen = k.length;
            int j = 0;
            for (i = 0; i < this.ps.length / 4; ++i) {
                int[] nArray = this.ps[i];
                nArray[0] = nArray[0] ^ k[j];
                int[] nArray2 = this.ps[i];
                nArray2[1] = nArray2[1] ^ k[(j + 1) % klen];
                int[] nArray3 = this.ps[i];
                nArray3[2] = nArray3[2] ^ k[(j + 2) % klen];
                int[] nArray4 = this.ps[i];
                nArray4[3] = nArray4[3] ^ k[(j + 3) % klen];
                j = (j + 4) % klen;
            }
            for (i = 0; i < this.ps.length / 4; i += 2) {
                this.e(dataLR);
                this.ps[i][0] = dataLR[0];
                this.ps[i][1] = dataLR[1];
                this.ps[i][2] = dataLR[2];
                this.ps[i][3] = dataLR[3];
                this.ps[i + 1][0] = dataLR[4];
                this.ps[i + 1][1] = dataLR[5];
                this.ps[i + 1][2] = dataLR[6];
                this.ps[i + 1][3] = dataLR[7];
            }
            for (i = 0; i < 4; ++i) {
                for (j = 0; j < 256; j += 2) {
                    this.e(dataLR);
                    this.ks[j][i] = dataLR[0] ^ dataLR[1] ^ dataLR[2] ^ dataLR[3];
                    this.ks[j + 1][i] = dataLR[4] ^ dataLR[5] ^ dataLR[6] ^ dataLR[7];
                }
            }
        }
    }

    private class MyProperties
    extends Properties {
        private final String delStart;
        private final String delEnd;
        private final int delStartLen;
        private final int delEndLen;

        MyProperties(Properties p, String vds, String vde) {
            super(p);
            this.delStart = vds;
            this.delEnd = vde;
            this.delStartLen = vds.length();
            this.delEndLen = vde.length();
        }

        @Override
        public String getProperty(String key) {
            int ixs;
            String prop = super.getProperty(key);
            if (prop != null && (ixs = prop.indexOf(this.delStart)) >= 0) {
                int ixe;
                StringBuffer res = new StringBuffer(prop.substring(0, ixs));
                int cur = ixs;
                do {
                    if (ixs > cur) {
                        res.append(prop.substring(cur, ixs));
                    }
                    if ((ixe = prop.indexOf(this.delEnd, ixs += this.delStartLen)) <= 0) break;
                    String sub = this.getProperty(prop.substring(ixs, ixe));
                    if (sub == null) continue;
                    res.append(sub);
                } while ((ixs = prop.indexOf(this.delStart, cur = ixe + this.delEndLen)) > 0);
                res.append(prop.substring(cur));
                return res.toString();
            }
            return prop;
        }
    }
}

