/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.messageserver.common;

import com.iscobol.logger.Logger;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rpc.messageserver.common.IMessageSerializer;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rpc.messageserver.common.SessionException;
import com.iscobol.rpc.messageserver.common.ThreadsafeQueue;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolSystem;
import java.io.ObjectInputStream;
import java.util.NoSuchElementException;

public class InboundMessageHandler
extends Thread {
    private Session session = null;
    private ThreadsafeQueue queue = new ThreadsafeQueue();
    private ObjectInputStream instream = null;
    private boolean signalToStop = false;
    private IMessageSerializer messageSerializer = null;

    public InboundMessageHandler(Session session) {
        this.setSession(session);
        this.setInstream(session.getInstream());
        this.setMessageSerializer(this.getSession().getSessionControl().getMessageSerializer());
    }

    public int getSessionId() {
        if (this.session != null) {
            return this.session.getSessionId();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSignalToStop(boolean signalToStop) {
        this.signalToStop = signalToStop;
        ThreadsafeQueue threadsafeQueue = this.queue;
        synchronized (threadsafeQueue) {
            this.queue.notifyAll();
        }
    }

    public Message getMessage(boolean blockUntilMessage) throws SessionException {
        Message msg = null;
        if (!this.isSignalToStop()) {
            if (blockUntilMessage) {
                try {
                    msg = (Message)this.queue.get();
                }
                catch (NoSuchElementException ex) {
                    throw new SessionException("Connection is closed");
                }
            } else {
                msg = (Message)this.queue.noBlockingGet();
            }
        } else {
            throw new SessionException("Connection is closed");
        }
        return msg;
    }

    @Override
    public void run() {
        Thread.currentThread().setName(this.getClass().getName() + ":hashcode=" + this.hashCode() + ":sessionId=" + this.getSession().getSessionId());
        Config.markNoIscobolRuntimeThread();
        while (!this.isSignalToStop()) {
            try {
                Logger log = this.getSession().isClientSession() ? RemoteRegistry.getClientProblemLogger() : RemoteRegistry.getProblemLogger(this.getSessionId());
                Message msg = this.getMessageSerializer().deserialize(this.instream, log);
                this.queue.put(msg);
            }
            catch (NullPointerException nex) {
                this.getSession().closeSession();
            }
            catch (Exception ex) {
                this.getSession().closeSession();
            }
            IscobolSystem.destroyEnv(this);
            Thread.yield();
        }
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    protected void setInstream(ObjectInputStream instream) {
        this.instream = instream;
    }

    protected ObjectInputStream getInstream() {
        return this.instream;
    }

    protected synchronized boolean isSignalToStop() {
        return this.signalToStop;
    }

    public void setMessageSerializer(IMessageSerializer messageSerializer) {
        this.messageSerializer = messageSerializer;
    }

    public IMessageSerializer getMessageSerializer() {
        return this.messageSerializer;
    }
}

