/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.dualrpc.client;

import com.iscobol.rpc.dualrpc.client.DualRpcClient;
import com.iscobol.rpc.dualrpc.common.IDualRpcMessageConstants;
import com.iscobol.rpc.dualrpc.common.IRpcHandler;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rpc.messageserver.common.SessionException;
import com.iscobol.rts.ArrayTable;

public class DualRpcClientDispatcher
extends Thread
implements IRpcMessageDispatcher,
IDualRpcMessageConstants {
    private DualRpcClient dualRpcClient = null;

    public DualRpcClientDispatcher(DualRpcClient dualRpcClient) {
        this.dualRpcClient = dualRpcClient;
    }

    @Override
    public void run() {
        long sessionId = this.getSession().getSessionId();
        try {
            Thread.currentThread().setName(this.getClass().getName() + ":hashcode=" + this.hashCode() + ":sessionId=" + sessionId);
            while (true) {
                try {
                    Message message = this.getSession().getMessage(true);
                    Thread worker = this.dualRpcClient.getRpcWorkerFactory().getRpcWorkerThread(this, message);
                    worker.setDaemon(true);
                    worker.start();
                }
                catch (SessionException sessex) {
                    if (this.dualRpcClient.getCallbackHandler() != null) {
                        this.dualRpcClient.getCallbackHandler().brokenConnection();
                    }
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Thread.yield();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public ArrayTable getCallWaitingRegistry() {
        return this.dualRpcClient.getCallWaitingRegistry();
    }

    @Override
    public IRpcHandler getHandler(String handlerClassname) {
        return (IRpcHandler)this.dualRpcClient.getClientHandlers().get(handlerClassname);
    }

    @Override
    public Session getSession() {
        return this.dualRpcClient.getMessageclient().getSession();
    }
}

