/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export.ss;

import com.iscobol.gui.export.ExportDataProvider;
import com.iscobol.gui.export.ExportMonitor;
import com.iscobol.gui.export.Exporter;
import com.iscobol.gui.export.GridDataProvider;
import com.iscobol.misc.export.UnitConverter;
import com.iscobol.misc.export.ss.SSExportHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public abstract class SSGridExporter
implements Exporter {
    private static final int FLUSH_ROW_RATE = 1000;
    private static final float screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
    private final Map<String, CellStyle> CELL_STYLES = new TreeMap<String, CellStyle>();
    private String outputFile;
    private String reportName;
    protected GridDataProvider provider;
    private ExportMonitor monitor;
    private int tickRate;
    protected SSExportHelper helper;
    private CellStyle defaultCellStyle;

    public abstract void setCellStyleAttrs(CellStyle var1, int var2, int var3, String var4);

    @Override
    public void setOutputFile(String filename) {
        this.outputFile = filename;
    }

    @Override
    public String getOutputFile() {
        return this.outputFile;
    }

    @Override
    public void setDataProvider(ExportDataProvider provider) {
        if (!(provider instanceof GridDataProvider)) {
            throw new IllegalArgumentException("Invalid Data Provider!");
        }
        this.provider = (GridDataProvider)provider;
    }

    @Override
    public ExportDataProvider getDataProvider() {
        return this.provider;
    }

    @Override
    public void export() throws Exception {
        if (this.provider == null) {
            throw new Exception("data provider is null");
        }
        if (this.outputFile == null) {
            throw new Exception("output file is null");
        }
        this.helper = this.createExportHelper();
        this.defaultCellStyle = this.helper.getWorkbook().createCellStyle();
        this.reportName = new File(this.outputFile).getName();
        int rowCount = this.provider.getRowCount();
        int colCount = this.provider.getColumnCount();
        int hdRowCount = this.provider.getHeadingRowCount();
        int hdColCount = this.provider.getHeadingColumnCount();
        int rowCountRate = rowCount / (this.tickRate - 1);
        ArrayList<int[]> rowColSpans = new ArrayList<int[]>();
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            if (rowIdx > 0 && rowIdx % 1000 == 0) {
                this.helper.flushRows(this.getSheet(rowIdx));
            }
            if (this.monitor != null && rowCountRate > 0 && rowIdx > 0 && rowIdx % rowCountRate == 0) {
                this.monitor.worked(rowIdx / rowCountRate);
            }
            Row row = this.getSheet(rowIdx).createRow(rowIdx);
            row.setHeightInPoints((float)UnitConverter.pixel2ExcelHeightPoints(this.provider.getRowHeight(rowIdx)));
            for (int colIdx = 0; colIdx < colCount; ++colIdx) {
                int dt;
                Cell cell = row.createCell(colIdx);
                String cellValue = this.provider.getCellData(rowIdx, colIdx);
                if (rowIdx < hdColCount) {
                    int rs = this.provider.getCellRowSpan(rowIdx, colIdx);
                    int cs = this.provider.getCellColumnSpan(rowIdx, colIdx);
                    if (rs > 1 || cs > 1) {
                        rowColSpans.add(new int[]{rowIdx, colIdx, rs, cs});
                    }
                }
                Double numericValue = null;
                int[] decimals = new int[2];
                String dateFormat = null;
                if (rowIdx >= hdColCount && colIdx >= hdRowCount) {
                    dt = this.provider.getColumnDataType(colIdx);
                    switch (dt) {
                        case 2: {
                            numericValue = this.helper.getNumericValue(cellValue);
                            if (numericValue == null) break;
                            decimals = this.helper.getDecimals(cellValue);
                            break;
                        }
                        case 3: {
                            dateFormat = this.provider.getColumnDateFormat(colIdx);
                        }
                    }
                } else {
                    dt = 0;
                }
                CellStyle cellStyle = this.getCellStyle(rowIdx, colIdx, dt, decimals, dateFormat);
                cell.setCellStyle(cellStyle);
                if (numericValue != null) {
                    cell.setCellValue(numericValue.doubleValue());
                    continue;
                }
                if (cellValue == null || cellValue.length() <= 0) continue;
                cell.setCellValue(cellValue);
            }
        }
        for (int[] rcs : rowColSpans) {
            if (rcs[2] == 1) {
                String text = "";
                int rowIdx = rcs[0];
                int colIdx = -1;
                int endColIdx = rcs[1] + rcs[3] - 1;
                for (int i = rcs[1]; i <= endColIdx; ++i) {
                    String cellValue = this.provider.getCellData(rowIdx, i);
                    if (cellValue == null) continue;
                    text = text + cellValue;
                    if (cellValue.length() <= 0 || colIdx >= 0) continue;
                    colIdx = i;
                }
                if (colIdx < 0) {
                    colIdx = rcs[1];
                }
                Row row = this.getSheet(rowIdx).getRow(rowIdx);
                Cell cell = row.getCell(rcs[1]);
                CellStyle cellStyle = this.getCellStyle(rowIdx, colIdx, 0, new int[2], null);
                cell.setCellStyle(cellStyle);
                cell.setCellValue(text);
            }
            this.helper.addMergedRegion(this.getSheet(rcs[0]), rcs[0], rcs[0] + rcs[2] - 1, rcs[1], rcs[1] + rcs[3] - 1);
        }
        if (hdColCount > 0 || hdRowCount > 0) {
            int rowSplit = Math.min(this.provider.getHeadingColumnCount(), this.provider.getColumnCount());
            int colSplit = Math.min(this.provider.getHeadingRowCount(), this.provider.getRowCount());
            this.getSheet(0).createFreezePane(colSplit, rowSplit);
        }
        this.helper.write(this.outputFile);
        this.helper.getWorkbook().close();
        this.CELL_STYLES.clear();
        this.helper.dispose();
        this.helper = null;
        this.defaultCellStyle = null;
        if (this.monitor != null) {
            this.monitor.worked(this.tickRate);
            this.monitor.done();
        }
    }

    private String getStyleKey(int rowIdx, int colIdx, int dataType, int[] numericType, String dateFormat) {
        StringBuilder sb = new StringBuilder();
        Font f = this.provider.getCellFont(rowIdx, colIdx);
        sb.append("font=[");
        sb.append(f.getFamily());
        sb.append(",");
        sb.append(f.getSize2D());
        sb.append(",");
        sb.append(f.isBold() ? "1" : "0");
        sb.append(",");
        sb.append(f.isItalic() ? "1]" : "0]");
        sb.append(",color=[");
        Color[] c = this.provider.getCellColor(rowIdx, colIdx);
        sb.append(c[0].getRGB());
        sb.append(",");
        sb.append(c[1].getRGB());
        sb.append("],align=");
        sb.append(this.provider.getColumnAlignment(colIdx));
        sb.append(",div=");
        sb.append(this.provider.getColumnDivider(colIdx));
        if (dataType != 0 && dataType != 1) {
            if (dateFormat != null) {
                sb.append(",df=");
                sb.append(dateFormat);
            } else {
                sb.append(",nt=");
                sb.append(numericType[0] + "," + numericType[1]);
            }
        }
        return sb.toString();
    }

    private CellStyle getCellStyle(int rowIdx, int colIdx, int dataType, int[] decimals, String dateFormat) {
        String key = this.getStyleKey(rowIdx, colIdx, dataType, decimals, dateFormat);
        CellStyle cellStyle = this.CELL_STYLES.get(key);
        if (cellStyle == null) {
            String format;
            try {
                cellStyle = this.helper.getWorkbook().createCellStyle();
            }
            catch (Exception ex) {
                return this.defaultCellStyle;
            }
            if (dataType == 0 || dataType == 1) {
                format = null;
            } else if (dateFormat != null) {
                format = dateFormat;
            } else if (decimals[0] > 0) {
                format = decimals[1] > 0 ? "#,##0." : "0.";
                for (int i = 0; i < decimals[0]; ++i) {
                    format = format + "0";
                }
            } else {
                format = decimals[1] > 0 ? "#,###" : "###";
            }
            this.setCellStyleAttrs(cellStyle, rowIdx, colIdx, format);
            this.CELL_STYLES.put(key, cellStyle);
        }
        return cellStyle;
    }

    protected Sheet getSheet(int rowNum) {
        int sheetIdx = rowNum / this.helper.getMaxRowsPerSheet();
        if (sheetIdx >= this.helper.getSheetCount()) {
            this.createSheet(this.reportName + " " + String.valueOf(this.helper.getSheetCount() + 1));
        }
        return this.helper.getSheetAt(sheetIdx);
    }

    protected Sheet createSheet(String reportName) {
        Sheet sheet = this.helper.createSheet(reportName);
        int columnCount = this.provider.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            sheet.setColumnWidth(i, UnitConverter.pixel2ExcelWidthUnits(this.provider.getColumnWidth(i)));
        }
        return sheet;
    }

    protected abstract SSExportHelper createExportHelper();

    public org.apache.poi.ss.usermodel.Font getFont(Font f, Color fg) {
        return this.helper.getFont(f.getFamily(), f.getSize2D() * 72.0f / screenResolution, f.isBold(), f.isItalic(), false, fg);
    }

    @Override
    public void setMonitor(ExportMonitor monitor, int tickRate) {
        this.monitor = monitor;
        this.tickRate = Math.max(2, tickRate);
    }
}

