/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export.ss;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public abstract class SSExportHelper {
    private static final DecimalFormatSymbols dfs = new DecimalFormatSymbols();
    public static final int NOT_NUMERIC = 0;
    public static final int NUMERIC_INT = 1;
    public static final int NUMERIC_FLT = 2;
    public static final String DEFAULT_INT_FORMAT = "#,###";
    public static final String DEFAULT_FLT_FORMAT = "#,###.##########";
    private final Map<String, Font> FONTS = new HashMap<String, Font>();
    private Workbook workbook;
    private List<Sheet> sheets = new ArrayList<Sheet>();
    protected DataFormat dataFormat;

    public abstract int getSheetColorCount();

    public abstract int computeAnchorX(int var1, int var2);

    public abstract int computeAnchorY(int var1, int var2);

    public abstract void setBorderedCellStyleAttrs(CellStyle var1, boolean var2, boolean var3, boolean var4, boolean var5, int var6, Color var7);

    public abstract void setFontColor(Font var1, Color var2);

    protected abstract Workbook createWorkbook();

    public abstract void setBackgroundAttrs(CellStyle var1, Color var2);

    public abstract Color getBackgroundColor(CellStyle var1);

    public abstract int getMaxRowsPerSheet();

    public void addMergedRegion(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
    }

    public final Workbook getWorkbook() {
        if (this.workbook == null) {
            this.workbook = this.createWorkbook();
        }
        return this.workbook;
    }

    public final int getSheetCount() {
        return this.sheets.size();
    }

    public final int getFontCount() {
        return this.FONTS.size();
    }

    public void flushRows(Sheet sheet) {
    }

    public final Sheet getSheetAt(int sheetIdx) {
        if (sheetIdx < this.sheets.size()) {
            return this.sheets.get(sheetIdx);
        }
        return null;
    }

    public Sheet createSheet(String reportName) {
        Sheet sheet = this.workbook.createSheet(reportName);
        this.sheets.add(sheet);
        return sheet;
    }

    public void write(String outputFile) throws IOException {
        FileOutputStream fileOut = new FileOutputStream(outputFile);
        this.workbook.write((OutputStream)fileOut);
        fileOut.close();
        this.workbook.close();
    }

    public void dispose() {
        this.workbook = null;
        this.dataFormat = null;
        this.sheets.clear();
        this.FONTS.clear();
    }

    public Double getNumericValue(String stringValue) {
        try {
            stringValue = SSExportHelper.removeChar(stringValue, dfs.getGroupingSeparator());
            stringValue = stringValue.replace(',', '.');
            return Double.valueOf(stringValue);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public int getNumericType(String stringValue) {
        if (stringValue.indexOf(dfs.getGroupingSeparator()) >= 0) {
            if (stringValue.indexOf(dfs.getDecimalSeparator()) >= 0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public int[] getDecimals(String stringValue) {
        int[] Return2 = new int[2];
        int idx = stringValue.indexOf(dfs.getDecimalSeparator());
        if (idx >= 0) {
            Return2[0] = stringValue.length() - idx - 1;
        }
        if (stringValue.indexOf(dfs.getGroupingSeparator()) >= 0) {
            Return2[1] = 1;
        }
        return Return2;
    }

    private static String removeChar(String s, char c) {
        StringBuilder sb = new StringBuilder();
        char[] ca = s.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i] == c) continue;
            sb.append(ca[i]);
        }
        return sb.toString();
    }

    public Font getFont(String family, float size, boolean bold, boolean italic, boolean underline, Color foreground) {
        StringBuilder sb = new StringBuilder();
        sb.append(family);
        sb.append('-');
        sb.append(size);
        if (bold) {
            sb.append("-b");
        }
        if (italic) {
            sb.append("-i");
        }
        if (underline) {
            sb.append("-u");
        }
        sb.append(foreground.getRGB());
        String key = sb.toString();
        Font font = this.FONTS.get(key);
        if (font == null) {
            font = this.getWorkbook().createFont();
            font.setFontName(family);
            font.setFontHeightInPoints((short)size);
            font.setBold(bold);
            font.setItalic(italic);
            if (underline) {
                font.setUnderline((byte)1);
            }
            this.setFontColor(font, foreground);
            this.FONTS.put(key, font);
        }
        return font;
    }

    public short getFormat(String numericFormat) {
        if (this.dataFormat == null) {
            this.dataFormat = this.getWorkbook().createDataFormat();
        }
        return this.dataFormat.getFormat(numericFormat);
    }
}

