/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.lib;

import com.iscobol.rts.Config;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IPicAnyLength;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.UserHandles;
import com.iscobol.types.PicInt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class C$SOCKET
implements IscobolCall,
RuntimeErrorsNumbers {
    private static final int AGS_CREATE_SERVER = 1;
    private static final int AGS_ACCEPT = 2;
    private static final int AGS_CREATE_CLIENT = 3;
    private static final int AGS_CLOSE = 4;
    private static final int AGS_WRITE = 5;
    private static final int AGS_READ = 6;
    private static final int AGS_FLUSH = 7;
    private static final int AGS_EMPTY = 8;
    private static final int AGS_GETHOSTNAME = 9;
    private static final int AGS_LAST_ERROR = 10;
    private static final int AGS_NEXT_READ = 11;
    private static final int AGS_REMOTE_NAME = 12;
    private static final int AGS_REMOTE_ADDR = 13;
    private static final int AGS_READ_LINE = 14;
    private static final int AGS_GETHOSTADDR = 15;
    private static final int AGS_GETSOCKETPORT = 16;
    private static final int GETREMOTEADDRESS = 31;
    private static final int EBADF = 10009;
    private static final int EINVAL = 10022;
    private static final int EADDRINUSE = 10048;
    private static final int ENETUNREACH = 10051;
    private static final int ECONNREFUSED = 10061;
    private static final int EUNKNOWN = 10102;
    private static final int SUCCESS = 0;
    private static final int ERROR = -1;
    private static final int NULL = 0;
    private PicInt returnCode = new PicInt(new byte[4], 0, 0, null, null, "", false);
    private Result lastResult;
    private int operationErrorCode;
    private MySocket socket;

    private static String getErrMsg(int e) {
        switch (e) {
            case 0: {
                return "Success";
            }
            case 10022: {
                return "Invalid argument";
            }
            case 10009: {
                return "Bad file descriptor";
            }
        }
        return "No description available";
    }

    @Override
    public Object call(Object[] argv) {
        Result result;
        this.operationErrorCode = -1;
        this.socket = null;
        if (argv != null && argv.length > 0) {
            ICobolVar[] iargv = new ICobolVar[argv.length];
            System.arraycopy(argv, 0, iargv, 0, argv.length);
            try {
                result = this.call(iargv);
            }
            catch (ClassCastException _ex) {
                result = new Result(10009);
            }
            catch (BindException _ex) {
                result = new Result(_ex);
            }
            catch (ConnectException _ex) {
                result = new Result(_ex);
            }
            catch (NoRouteToHostException _ex) {
                result = new Result(_ex);
            }
            catch (PortUnreachableException _ex) {
                result = new Result(_ex);
            }
            catch (SocketException _ex) {
                result = new Result(_ex);
            }
            catch (IOException _ex) {
                result = new Result(_ex);
            }
        } else {
            result = new Result(this.operationErrorCode, 10102);
        }
        this.lastResult = result;
        if (this.socket != null) {
            this.socket.setLastResult(this.lastResult);
        }
        this.returnCode.set(this.lastResult.returnCode);
        return this.returnCode;
    }

    public Result call(ICobolVar[] argv) throws IOException {
        Result Return2;
        switch (argv[0].toint()) {
            case 1: {
                this.operationErrorCode = 0;
                if (argv.length > 1) {
                    int port = argv[1].toint();
                    MyServerSocket server = new MyServerSocket(port);
                    int hndl = UserHandles.ssetId(server);
                    Return2 = new Result(hndl);
                    break;
                }
                Return2 = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 2: {
                this.operationErrorCode = 0;
                if (argv.length > 1) {
                    MyServerSocket server = (MyServerSocket)UserHandles.getId(argv[1].toint());
                    if (server != null) {
                        int hndl = server.accept();
                        Return2 = new Result(hndl);
                        break;
                    }
                    Return2 = new Result(this.operationErrorCode, 10009);
                    break;
                }
                Return2 = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 3: {
                this.operationErrorCode = 0;
                if (argv.length > 2) {
                    int port = argv[1].toint();
                    String host = argv[2].toString().trim();
                    this.socket = new MySocket(host, port);
                    int hndl = UserHandles.ssetId(this.socket);
                    Return2 = new Result(hndl);
                    break;
                }
                Return2 = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 4: {
                this.operationErrorCode = -1;
                if (argv.length > 1) {
                    int hndl = argv[1].toint();
                    Object obj = UserHandles.getId(hndl);
                    if (obj instanceof MyServerSocket) {
                        ((MyServerSocket)obj).close();
                        Return2 = new Result(0);
                        UserHandles.free(hndl);
                        break;
                    }
                    if (obj instanceof MySocket) {
                        ((MySocket)obj).close();
                        Return2 = new Result(0);
                        UserHandles.free(hndl);
                        break;
                    }
                    Return2 = new Result(this.operationErrorCode, 10009);
                    break;
                }
                Return2 = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 5: {
                this.operationErrorCode = -1;
                if (argv.length > 3) {
                    this.socket = (MySocket)UserHandles.getId(argv[1].toint());
                    if (this.socket != null) {
                        byte[] buff = argv[2].getBytes();
                        int len = argv[3].toint();
                        if (len > 0 && len <= buff.length) {
                            this.socket.write(buff, 0, len);
                            Return2 = new Result(len);
                            break;
                        }
                        Return2 = new Result(this.operationErrorCode, 10022);
                        break;
                    }
                    Return2 = new Result(this.operationErrorCode, 10009);
                    break;
                }
                Return2 = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 6: 
            case 14: {
                this.operationErrorCode = -1;
                if (argv.length > 3) {
                    this.socket = (MySocket)UserHandles.getId(argv[1].toint());
                    if (this.socket != null) {
                        boolean ln;
                        byte[] buff = null;
                        if (!(argv[2] instanceof IPicAnyLength)) {
                            buff = new byte[argv[2].length()];
                        }
                        int len = argv[3].toint();
                        int timeval = argv.length > 4 ? argv[4].toint() : -1;
                        boolean bl = ln = argv[0].toint() == 14;
                        if (len > 0) {
                            if (buff != null) {
                                if (len <= buff.length) {
                                    Return2 = ln ? new Result(this.socket.readLn(buff, len, timeval)) : new Result(this.socket.read(buff, len, timeval));
                                    if (Return2.returnCode < 0) break;
                                    argv[2].set(buff, 0, Return2.returnCode, true);
                                    break;
                                }
                                Return2 = new Result(this.operationErrorCode, 10022);
                                break;
                            }
                            buff = ln ? this.socket.readLn(len, timeval) : this.socket.read(len, timeval);
                            Return2 = new Result(buff.length);
                            if (Return2.returnCode < 0) break;
                            argv[2].set(buff, 0, Return2.returnCode, true);
                            break;
                        }
                        if (len == 0) {
                            Return2 = new Result(this.socket.available());
                            break;
                        }
                        len = -len;
                        if (buff != null) {
                            if (len <= buff.length) {
                                Return2 = ln ? new Result(this.socket.readLn(buff, len, timeval)) : new Result(this.socket.read(buff, len, timeval));
                                if (Return2.returnCode < 0) break;
                                this.socket.fillBuffer(buff, 0, Return2.returnCode, false);
                                argv[2].set(buff, 0, Return2.returnCode, true);
                                break;
                            }
                            Return2 = new Result(this.operationErrorCode, 10022);
                            break;
                        }
                        buff = ln ? this.socket.readLn(len, timeval) : this.socket.read(len, timeval);
                        Return2 = new Result(buff.length);
                        if (Return2.returnCode < 0) break;
                        this.socket.fillBuffer(buff, 0, Return2.returnCode, false);
                        argv[2].set(buff, 0, Return2.returnCode, true);
                        break;
                    }
                    Return2 = new Result(this.operationErrorCode, 10009);
                    break;
                }
                Return2 = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 7: {
                this.operationErrorCode = -1;
                if (argv.length > 1) {
                    int hndl = argv[1].toint();
                    this.socket = (MySocket)UserHandles.getId(hndl);
                    if (this.socket != null) {
                        this.socket.flush();
                        Return2 = new Result(0);
                        break;
                    }
                    Return2 = new Result(this.operationErrorCode, 10009);
                    break;
                }
                Return2 = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 8: {
                this.operationErrorCode = -1;
                if (argv.length > 2) {
                    int len = argv[2].toint();
                    int hndl = argv[1].toint();
                    this.socket = (MySocket)UserHandles.getId(hndl);
                    if (this.socket != null) {
                        this.socket.empty(len);
                        Return2 = new Result(0);
                        break;
                    }
                    Return2 = new Result(this.operationErrorCode, 10009);
                    break;
                }
                Return2 = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 9: {
                this.operationErrorCode = -1;
                if (argv.length > 1) {
                    argv[1].set(InetAddress.getLocalHost().getHostName());
                    Return2 = new Result(0);
                    break;
                }
                Return2 = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 10: {
                this.operationErrorCode = -1;
                if (argv.length > 1) {
                    Result res = null;
                    int hndl = argv[1].toint();
                    if (hndl == 0) {
                        res = this.lastResult;
                    } else {
                        hndl = argv[1].toint();
                        this.socket = (MySocket)UserHandles.getId(hndl);
                        if (this.socket != null) {
                            res = this.socket.getLastResult();
                        }
                    }
                    if (res != null) {
                        Return2 = new Result(res.errorCode);
                        if (argv.length <= 2) break;
                        argv[2].set(res.errorMsg);
                        break;
                    }
                    Return2 = new Result(0);
                    break;
                }
                Return2 = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 11: {
                this.operationErrorCode = -1;
                if (argv.length > 2) {
                    int hndl = argv[1].toint();
                    MyServerSocket server = (MyServerSocket)UserHandles.getId(hndl);
                    if (server != null) {
                        int timeout = argv[2].toint();
                        int rc = server.select(timeout, hndl);
                        if (rc == hndl) {
                            server.accept();
                            rc = server.select(timeout, hndl);
                        }
                        Return2 = new Result(rc);
                        break;
                    }
                    Return2 = new Result(this.operationErrorCode, 10022);
                    break;
                }
                Return2 = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 12: {
                this.operationErrorCode = -1;
                if (argv.length > 2) {
                    int hndl = argv[1].toint();
                    this.socket = (MySocket)UserHandles.getId(hndl);
                    if (this.socket != null) {
                        InetSocketAddress sa = (InetSocketAddress)this.socket.socket.getRemoteSocketAddress();
                        argv[2].set(sa.getHostName());
                        Return2 = new Result(0);
                        break;
                    }
                    Return2 = new Result(this.operationErrorCode, 10009);
                    break;
                }
                Return2 = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 13: {
                this.operationErrorCode = -1;
                if (argv.length > 2) {
                    int hndl = argv[1].toint();
                    this.socket = (MySocket)UserHandles.getId(hndl);
                    if (this.socket != null) {
                        InetSocketAddress sa = (InetSocketAddress)this.socket.socket.getRemoteSocketAddress();
                        argv[2].set(this.getIpAddress(sa.getAddress()));
                        Return2 = new Result(0);
                        break;
                    }
                    Return2 = new Result(this.operationErrorCode, 10009);
                    break;
                }
                Return2 = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 15: {
                this.operationErrorCode = -1;
                if (argv.length > 1) {
                    argv[1].set(this.getIpAddress(InetAddress.getLocalHost()));
                    Return2 = new Result(0);
                    break;
                }
                Return2 = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 16: {
                this.operationErrorCode = -1;
                if (argv.length > 2) {
                    int hndl = argv[1].toint();
                    this.socket = (MySocket)UserHandles.getId(hndl);
                    if (this.socket != null) {
                        InetSocketAddress sa = (InetSocketAddress)this.socket.socket.getRemoteSocketAddress();
                        argv[2].set(sa.getPort());
                        Return2 = new Result(0);
                        break;
                    }
                    Return2 = new Result(this.operationErrorCode, 10009);
                    break;
                }
                Return2 = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 31: {
                this.operationErrorCode = -1;
                if (argv.length > 2) {
                    int hndl = argv[1].toint();
                    this.socket = (MySocket)UserHandles.getId(hndl);
                    if (this.socket != null) {
                        Enumeration chldrn = argv[2].getChildren();
                        if (chldrn.hasMoreElements()) {
                            ICobolVar[] res = new ICobolVar[3];
                            for (int i = 0; i < res.length && chldrn.hasMoreElements(); ++i) {
                                res[i] = (ICobolVar)chldrn.nextElement();
                            }
                            InetSocketAddress sa = (InetSocketAddress)this.socket.socket.getRemoteSocketAddress();
                            if (res[0] != null) {
                                res[0].set(sa.getHostName());
                            }
                            if (res[1] != null) {
                                res[1].set(this.getIpAddress(sa.getAddress()));
                            }
                            if (res[2] != null) {
                                res[2].set(sa.getPort());
                            }
                            Return2 = new Result(0);
                            break;
                        }
                        Return2 = new Result(this.operationErrorCode, 10022);
                        break;
                    }
                    Return2 = new Result(this.operationErrorCode, 10009);
                    break;
                }
                Return2 = new Result(this.operationErrorCode, 10022);
                break;
            }
            default: {
                this.operationErrorCode = -1;
                Return2 = new Result(this.operationErrorCode, 10022);
            }
        }
        return Return2;
    }

    private String getIpAddress(InetAddress ia) {
        StringBuffer Return2 = new StringBuffer();
        byte[] addr = ia.getAddress();
        Return2.append(addr[0] & 0xFF);
        Return2.append('.');
        Return2.append(addr[1] & 0xFF);
        Return2.append('.');
        Return2.append(addr[2] & 0xFF);
        Return2.append('.');
        Return2.append(addr[3] & 0xFF);
        return Return2.toString();
    }

    @Override
    public void finalize() {
    }

    @Override
    public void perform(int begin, int end) {
    }

    private class Result {
        final int returnCode;
        final int errorCode;
        final String errorMsg;

        Result(int rc, int ec, String msg) {
            this.returnCode = rc;
            this.errorCode = ec;
            this.errorMsg = msg;
        }

        Result(NoRouteToHostException _ex) {
            this(c$SOCKET.operationErrorCode, 10051, _ex.toString());
        }

        Result(ConnectException _ex) {
            this(c$SOCKET.operationErrorCode, 10061, _ex.toString());
        }

        Result(BindException _ex) {
            this(c$SOCKET.operationErrorCode, 10048, _ex.toString());
        }

        Result(SocketException _ex) {
            this(c$SOCKET.operationErrorCode, 10102, _ex.toString());
        }

        Result(IOException _ex) {
            this(c$SOCKET.operationErrorCode, 10102, _ex.toString());
        }

        Result(int rc, int ec) {
            this(rc, ec, C$SOCKET.getErrMsg(ec));
        }

        Result(int rc) {
            this(rc, 0);
        }
    }

    static class MySocket {
        private final MyServerSocket server;
        private final Socket socket;
        private final InputStream is;
        private final OutputStream os;
        private byte[] lastRead;
        private Result lastResult;
        private final int maxBufferSize;

        MySocket(Socket s, MyServerSocket srv) throws IOException {
            this.server = srv;
            this.socket = s;
            this.socket.setTcpNoDelay(Config.getProperty(".csocket.tcp_nodelay", true));
            if (Config.getProperty(".csocket.setkeepalive", false)) {
                this.socket.setKeepAlive(true);
            }
            this.is = this.socket.getInputStream();
            this.os = this.socket.getOutputStream();
            this.maxBufferSize = Config.getProperty(".csocket.maxbuffersize", 4098);
        }

        MySocket(String host, int port) throws IOException {
            this(new Socket(host, port), null);
        }

        SocketChannel getChannel() {
            return this.socket.getChannel();
        }

        void write(byte[] b, int offs, int len) throws IOException {
            this.os.write(b, offs, len);
        }

        int available() throws IOException {
            int Return2;
            int rc;
            int offset;
            byte[] buffer = new byte[this.maxBufferSize];
            if (this.lastRead != null) {
                if (this.lastRead.length >= this.maxBufferSize) {
                    return this.lastRead.length;
                }
                offset = this.lastRead.length;
                System.arraycopy(this.lastRead, 0, buffer, 0, offset);
            } else {
                offset = 0;
            }
            this.socket.setSoTimeout(1);
            try {
                rc = this.is.read(buffer, offset, this.maxBufferSize - offset);
            }
            catch (SocketTimeoutException _ex) {
                rc = 0;
            }
            if (rc >= 0) {
                Return2 = rc + offset;
                this.lastRead = new byte[Return2];
                System.arraycopy(buffer, 0, this.lastRead, 0, Return2);
            } else {
                Return2 = 0;
            }
            this.socket.setSoTimeout(0);
            return Return2;
        }

        byte[] read(int len, int tOut) throws IOException {
            byte[] b = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int r = this.read(b, Math.min(len, b.length), tOut);
            while (r > 0) {
                baos.write(b, 0, r);
                if (r == len || r < b.length) break;
                r = this.read(b, Math.min(len -= r, b.length), tOut);
            }
            baos.close();
            return baos.toByteArray();
        }

        byte[] readLn(int len, int tOut) throws IOException {
            byte[] b = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int r = this.readLn(b, Math.min(len, b.length), tOut);
            while (r > 0) {
                baos.write(b, 0, r);
                if (r == len || r < b.length) break;
                r = this.readLn(b, Math.min(len -= r, b.length), tOut);
            }
            baos.close();
            return baos.toByteArray();
        }

        int read(byte[] b, int len, int tOut) throws IOException {
            if (this.lastRead != null) {
                int lastLen = this.lastRead.length;
                if (lastLen == len) {
                    System.arraycopy(this.lastRead, 0, b, 0, len);
                    this.lastRead = null;
                    return len;
                }
                if (lastLen < len) {
                    System.arraycopy(this.lastRead, 0, b, 0, lastLen);
                    this.lastRead = null;
                    return this._read(b, lastLen, len - lastLen, tOut) + lastLen;
                }
                System.arraycopy(this.lastRead, 0, b, 0, len);
                byte[] newLast = new byte[lastLen - len];
                System.arraycopy(this.lastRead, len, newLast, 0, newLast.length);
                this.lastRead = newLast;
                return len;
            }
            return this._read(b, 0, len, tOut);
        }

        private int findNl(byte[] b, int offs, int len) {
            int end = offs + len;
            int i = offs;
            if (offs > 0) {
                --offs;
            }
            while (i < end) {
                if (b[i] == 10) {
                    int Return2 = i++;
                    this.fillBuffer(b, i, end - i, true);
                    return Return2;
                }
                ++i;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int _readLn(byte[] bOut, int offs, int len, int tOut) throws IOException {
            int rc = 0;
            byte[] b = new byte[len];
            int i = 0;
            if (tOut >= 0) {
                this.socket.setSoTimeout(tOut > 0 ? tOut : 1);
            }
            try {
                for (i = 0; i < len && rc >= 0; i += rc) {
                    rc = this.is.read(b, i, len - i);
                    if (rc >= 0) {
                        int llen = this.findNl(b, i, rc);
                        if (llen < 0) continue;
                        int n = llen = this.cpStripCr(b, 0, bOut, offs, llen);
                        return n;
                    }
                    int n = -1;
                    return n;
                }
                System.arraycopy(b, 0, bOut, offs, len);
                int n = len;
                return n;
            }
            catch (SocketTimeoutException _ex) {
                if (i > 0) {
                    System.arraycopy(b, 0, bOut, offs, i);
                    int n = i;
                    return n;
                }
                int n = 0;
                return n;
            }
            finally {
                if (tOut >= 0) {
                    this.socket.setSoTimeout(0);
                }
            }
        }

        private int cpStripCr(byte[] src, int ss, byte[] dst, int ds, int len) {
            if (len > 0) {
                if (src[ss + len - 1] == 13) {
                    --len;
                }
                System.arraycopy(src, ss, dst, ds, len);
            }
            return len;
        }

        int readLn(byte[] b, int len, int tOut) throws IOException {
            int Return2;
            if (this.lastRead != null) {
                byte[] bb = this.lastRead;
                this.lastRead = null;
                int llen = this.findNl(bb, 0, bb.length);
                if (llen >= 0) {
                    Return2 = this.cpStripCr(bb, 0, b, 0, llen);
                } else {
                    int lastLen = bb.length;
                    if (lastLen == len) {
                        Return2 = this.cpStripCr(bb, 0, b, 0, len);
                    } else if (lastLen < len) {
                        lastLen = this.cpStripCr(bb, 0, b, 0, lastLen);
                        Return2 = this._readLn(b, lastLen, len - lastLen, tOut) + lastLen;
                    } else {
                        this.cpStripCr(bb, 0, b, 0, len);
                        this.lastRead = new byte[lastLen - len];
                        System.arraycopy(bb, len, this.lastRead, 0, this.lastRead.length);
                        Return2 = len;
                    }
                }
            } else {
                Return2 = this._readLn(b, 0, len, tOut);
            }
            return Return2;
        }

        void fillBuffer(byte[] b, int offs, int len, boolean append) {
            if (this.lastRead == null) {
                this.lastRead = new byte[len];
                System.arraycopy(b, offs, this.lastRead, 0, len);
            } else {
                byte[] newLast = new byte[this.lastRead.length + len];
                if (append) {
                    System.arraycopy(this.lastRead, 0, newLast, 0, this.lastRead.length);
                    System.arraycopy(b, offs, newLast, this.lastRead.length, len);
                } else {
                    System.arraycopy(b, offs, newLast, 0, len);
                    System.arraycopy(this.lastRead, 0, newLast, len, this.lastRead.length);
                }
                this.lastRead = newLast;
            }
        }

        private int _read(byte[] b, int offs, int len) throws IOException {
            return this._read(b, offs, len, -1);
        }

        private int _read(byte[] b, int offs, int len, int tOut) throws IOException {
            int i;
            int rc = 0;
            if (tOut >= 0) {
                this.socket.setSoTimeout(tOut > 0 ? tOut : 1);
            }
            try {
                for (i = 0; i < len && (rc = this.is.read(b, offs + i, len - i)) > 0; i += rc) {
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                // empty catch block
            }
            if (tOut >= 0) {
                this.socket.setSoTimeout(0);
            }
            if (i == 0) {
                return rc;
            }
            return i;
        }

        void flush() throws IOException {
            this.os.flush();
            int avail = this.is.available();
            if (avail > 0) {
                byte[] b = new byte[avail];
                this._read(b, 0, avail);
                this.fillBuffer(b, 0, avail, true);
            }
        }

        void empty(int len) throws IOException {
            this.flush();
            if (this.lastRead != null) {
                int lastLen = this.lastRead.length;
                if (lastLen == len) {
                    this.lastRead = null;
                } else if (lastLen >= len) {
                    byte[] newLast = new byte[lastLen - len];
                    System.arraycopy(this.lastRead, len, newLast, 0, lastLen - len);
                    this.lastRead = newLast;
                } else {
                    this.lastRead = null;
                    byte[] toThrow = new byte[len - lastLen];
                    this._read(toThrow, 0, toThrow.length);
                }
            } else {
                byte[] toThrow = new byte[len];
                this._read(toThrow, 0, toThrow.length);
            }
        }

        void close() throws IOException {
            this.socket.shutdownOutput();
            this.socket.close();
            if (this.server != null) {
                this.server.remove(this.socket);
            }
        }

        void setLastResult(Result r) {
            this.lastResult = r;
        }

        Result getLastResult() {
            return this.lastResult;
        }
    }

    static class MyServerSocket {
        private final ServerSocket server;
        private final HashMap sockets = new HashMap();
        private final int port;
        private ServerSocketChannel channel;

        MyServerSocket(int p) throws IOException {
            int mbs;
            this.port = p;
            this.channel = ServerSocketChannel.open();
            this.server = this.channel.socket();
            if (Config.getProperty(".csocket.reuseaddr", false)) {
                this.server.setReuseAddress(true);
            }
            if ((mbs = Config.getProperty(".csocket.maxbuffersize", 0)) > 0) {
                this.server.setReceiveBufferSize(mbs);
            }
            this.server.bind(new InetSocketAddress(this.port));
        }

        int accept() throws IOException {
            SocketChannel sc = this.channel.accept();
            Socket s = sc.socket();
            MySocket mySock = new MySocket(s, this);
            int Return2 = UserHandles.ssetId(mySock);
            this.sockets.put(s, new MySocketRef(Return2, mySock));
            return Return2;
        }

        void close() throws IOException {
            this.server.close();
        }

        int select(int timeout, int accept) throws IOException {
            SocketChannel sc;
            Iterator it;
            Selector selector;
            int Return2;
            block9: {
                block8: {
                    block10: {
                        byte[] buf1;
                        int rc;
                        MySocketRef ref;
                        SelectionKey selKey = null;
                        Return2 = 0;
                        selector = Selector.open();
                        boolean now = timeout == 0;
                        ByteBuffer bb = ByteBuffer.allocate(1);
                        if (timeout < 0) {
                            timeout = 0;
                        }
                        this.channel.configureBlocking(false);
                        this.channel.register(selector, 16);
                        it = this.sockets.keySet().iterator();
                        while (it.hasNext()) {
                            sc = ((Socket)it.next()).getChannel();
                            if (sc == null) continue;
                            sc.configureBlocking(false);
                            sc.register(selector, 1);
                        }
                        while (true) {
                            Iterator<SelectionKey> keyIterator;
                            if (now) {
                                selector.selectNow();
                            } else {
                                selector.select(timeout);
                            }
                            Set<SelectionKey> sk = selector.selectedKeys();
                            selKey = sk != null ? ((keyIterator = sk.iterator()) != null && keyIterator.hasNext() ? keyIterator.next() : null) : null;
                            if (selKey == null) break block8;
                            if (selKey.isAcceptable()) {
                                Return2 = accept;
                                break block9;
                            }
                            SocketChannel sChannel = (SocketChannel)selKey.channel();
                            ref = (MySocketRef)this.sockets.get(sChannel.socket());
                            if (ref == null) break block10;
                            Return2 = ref.hndl;
                            rc = sChannel.read(bb);
                            buf1 = bb.array();
                            if (rc != -1) break;
                            ref.socket.close();
                            UserHandles.free(ref.hndl);
                            this.sockets.remove(ref.socket.socket);
                        }
                        if (rc > 0) {
                            ref.socket.fillBuffer(buf1, 0, buf1.length, true);
                        }
                        break block9;
                    }
                    Return2 = 0;
                    break block9;
                }
                Return2 = 0;
            }
            selector.close();
            it = this.sockets.keySet().iterator();
            while (it.hasNext()) {
                sc = ((Socket)it.next()).getChannel();
                if (sc == null) continue;
                sc.configureBlocking(true);
            }
            this.channel.configureBlocking(true);
            return Return2;
        }

        void remove(Socket s) {
            this.sockets.remove(s);
        }
    }

    static final class MySocketRef {
        final int hndl;
        final MySocket socket;

        MySocketRef(int h, MySocket s) {
            this.hndl = h;
            this.socket = s;
        }
    }
}

