/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.java;

import com.iscobol.java.CobolVarHelper;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RtsUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EFDHelper
extends DefaultHandler {
    private Field root;
    private Stack<Field> stack = new Stack();
    private Key key;
    private ArrayList<Key> keys = new ArrayList();

    public EFDHelper(String fileName) throws IOException {
        this(new FileInputStream(fileName));
    }

    public EFDHelper(InputStream in) throws IOException {
        SAXParserFactory factory = RtsUtil.newSAXParserFactory();
        factory.setNamespaceAware(false);
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(in, (DefaultHandler)this);
        }
        catch (ParserConfigurationException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        catch (SAXException _ex) {
            if (_ex.getException() != null) {
                throw new IscobolRuntimeException(_ex.getException());
            }
            throw new IscobolRuntimeException(_ex);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("field".equals(qName) || "occurs".equals(qName)) {
            Field fld = new Field(attributes);
            if (this.root == null) {
                this.root = fld;
            } else {
                this.stack.peek().addChild(fld);
            }
            this.stack.push(fld);
        } else if ("key".equals(qName)) {
            String dups = attributes.getValue("duplicate");
            if ("true".equals(dups)) {
                this.key = new Key(true);
                this.keys.add(this.key);
            } else {
                this.key = new Key(false);
                this.keys.add(this.key);
            }
        } else if ("part".equals(qName)) {
            this.key.fields.add(attributes.getValue("name"));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("field".equals(qName) || "occurs".equals(qName)) {
            this.stack.pop();
        }
    }

    public CobolVarHelper getVarHelper(int opts) {
        if (this.root != null) {
            CobolVarHelper Return2 = new CobolVarHelper("FILLER", opts);
            this.getVarRecur(this.root, Return2);
            return Return2;
        }
        return null;
    }

    public CobolVarHelper getVarHelper() {
        return this.getVarHelper(0);
    }

    private void getVarRecur(Field f, CobolVarHelper cvh) {
        if (f.hasChildren()) {
            cvh.group(f.name);
            if (f.number > 0) {
                cvh.occurs(f.number);
            }
            Iterator<Field> it = f.children();
            while (it.hasNext()) {
                this.getVarRecur(it.next(), cvh);
            }
            cvh.endGroup();
        } else {
            switch (f.type) {
                case NumUnsigned: {
                    cvh.pic9(f.name, f.digits - f.scale, f.scale);
                    break;
                }
                case NumSignSep: {
                    cvh.picS9(f.name, f.digits - f.scale, f.scale).signSeparate(true);
                    break;
                }
                case NumSigned: {
                    cvh.picS9(f.name, f.digits - f.scale, f.scale);
                    break;
                }
                case NumSepLead: {
                    cvh.picS9(f.name, f.digits - f.scale, f.scale).signSeparate(true).signLeading(true);
                    break;
                }
                case NumLeading: {
                    cvh.picS9(f.name, f.digits - f.scale, f.scale).signLeading(true);
                    break;
                }
                case CompSigned: {
                    cvh.picS9Comp2(f.name, f.digits - f.scale, f.scale);
                    break;
                }
                case CompUnsigned: {
                    cvh.pic9Comp2(f.name, f.digits - f.scale, f.scale);
                    break;
                }
                case PackedPositive: {
                    cvh.pic9Comp3(f.name, f.digits - f.scale, f.scale);
                    break;
                }
                case PackedSigned: {
                    cvh.picS9Comp3(f.name, f.digits - f.scale, f.scale);
                    break;
                }
                case PackedUnsigned: {
                    cvh.pic9Comp6(f.name, f.digits - f.scale, f.scale);
                    break;
                }
                case BinarySigned: {
                    if (f.size == 2 && f.digits == 5) {
                        cvh.pic9Comp1(f.name);
                        break;
                    }
                    cvh.picS9Comp4(f.name, f.digits - f.scale, f.scale);
                    break;
                }
                case BinaryUnsigned: {
                    cvh.pic9Comp4(f.name, f.digits - f.scale, f.scale);
                    break;
                }
                case NativeSigned: {
                    cvh.picS9Comp5(f.name, f.digits - f.scale, f.scale);
                    break;
                }
                case NativeUnsigned: {
                    cvh.pic9Comp5(f.name, f.digits - f.scale, f.scale);
                    break;
                }
                case Float: {
                    if (f.size == 4) {
                        cvh.picFloat(f.name);
                        break;
                    }
                    cvh.picDouble(f.name);
                    break;
                }
                case National: {
                    cvh.picN(f.name, f.size / 2);
                    break;
                }
                default: {
                    cvh.picX(f.name, f.size);
                }
            }
        }
    }

    public int getKeyCount() {
        return this.keys.size();
    }

    public Key[] getKeys() {
        return this.keys.toArray(new Key[this.keys.size()]);
    }

    public static class Key {
        final boolean dups;
        private final ArrayList<String> fields = new ArrayList();

        private Key(boolean dups) {
            this.dups = dups;
        }

        public String[] getFields() {
            return this.fields.toArray(new String[this.fields.size()]);
        }

        public boolean duplicates() {
            return this.dups;
        }
    }

    public static class Field {
        final String name;
        final int offset;
        final int size;
        final Type type;
        final int digits;
        final int scale;
        final int number;
        final boolean hidden = false;
        private ArrayList<Field> children;

        Field(Attributes attrs) {
            int n;
            try {
                n = Integer.parseInt(attrs.getValue("size"));
            }
            catch (NumberFormatException _ex) {
                n = -1;
            }
            this.size = n;
            try {
                n = Integer.parseInt(attrs.getValue("number"));
            }
            catch (NumberFormatException _ex) {
                n = -1;
            }
            this.number = n;
            if (this.number > 0) {
                this.name = "FILLER";
                this.offset = -1;
                this.type = Type.Alphanum;
                this.digits = -1;
                this.scale = -1;
            } else {
                this.name = attrs.getValue("name");
                try {
                    n = Integer.parseInt(attrs.getValue("offset"));
                }
                catch (NumberFormatException _ex) {
                    n = -1;
                }
                this.offset = n;
                String sType = attrs.getValue("type");
                Type tt = Type.Alphanum;
                if (sType != null) {
                    for (Type t : Type.values()) {
                        if (!sType.equals(t.toString())) continue;
                        tt = t;
                        break;
                    }
                }
                this.type = tt;
                try {
                    n = Integer.parseInt(attrs.getValue("digits"));
                }
                catch (NumberFormatException _ex) {
                    n = -1;
                }
                this.digits = n;
                try {
                    n = Integer.parseInt(attrs.getValue("scale"));
                }
                catch (NumberFormatException _ex) {
                    n = -1;
                }
                this.scale = n;
            }
        }

        void addChild(Field child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
        }

        boolean hasChildren() {
            return this.children != null;
        }

        Iterator<Field> children() {
            return this.children.iterator();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.number > 0) {
                sb.append("occurs ");
                sb.append(this.number);
                sb.append(";");
                sb.append(this.size);
            } else {
                sb.append(this.name);
                sb.append(" ");
                sb.append(this.offset);
                sb.append(";");
                sb.append(this.size);
                if (this.children != null) {
                    sb.append(" group");
                } else {
                    sb.append(";");
                    sb.append((Object)this.type);
                    sb.append(";");
                    sb.append(this.digits);
                    sb.append(";");
                    sb.append(this.scale);
                }
            }
            return sb.toString();
        }
    }

    static enum Type {
        NumUnsigned,
        NumSignSep,
        NumSigned,
        NumSepLead,
        NumLeading,
        CompSigned,
        CompUnsigned,
        PackedPositive,
        PackedSigned,
        PackedUnsigned,
        BinarySigned,
        BinaryUnsigned,
        NativeSigned,
        NativeUnsigned,
        Float,
        Alphanum,
        JavaObject,
        National;

    }
}

