/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

class VisionFile {
    private final String idxExt = ".vix";
    private File vFile;
    private RandomAccessFile vRAFile;
    final char vVersion;
    private final int blockingFactor;
    private final int blockSize;
    private final int blockSize_4;
    final long numOfRecords;
    private final long deletedRecords;
    private final long totOpens;
    private final long userCount;
    private final long segmentSize;
    final int maxRec;
    final int minRec;
    final int nKeys;
    final Key[] keys;
    private final boolean compressed;
    private boolean hasDuplicates;
    private byte[] buffer;
    private final byte[] node;
    private final byte[] dummyInt = new byte[4];
    private int nodePnt;
    private long validRecordsNum;
    private long deletedRecordsNum;
    private final String fName;
    private final int nDataSegments;
    private int currDataSegment;
    private final long firstDataBlock;
    final byte[] collatingSequence;
    private final String blanks = "                                            ";

    private static final long readInt48(RandomAccessFile raf) throws IOException {
        long a = raf.readChar();
        long Return2 = (long)raf.readInt() & 0xFFFFFFFFL;
        return Return2 |= a << 32;
    }

    public VisionFile(String fileName) throws IOException {
        int lastDot = fileName.lastIndexOf(46);
        this.fName = lastDot > 0 && !new File(fileName + ".vix").exists() ? fileName.substring(0, lastDot) : fileName;
        this.vFile = new File(fileName);
        this.vRAFile = new RandomAccessFile(this.vFile, "r");
        try {
            int v = this.vRAFile.readInt();
            if (v != 269620246 && v != 269620249) {
                throw new IOException("Unrecognized Vision file!");
            }
            this.vVersion = this.vRAFile.readChar();
            this.blockingFactor = this.vRAFile.readChar();
            this.blockSize = this.blockingFactor * 512;
            this.blockSize_4 = this.blockSize - 4;
            switch (this.vVersion) {
                case '\u0003': {
                    this.node = new byte[this.blockSize];
                    this.nDataSegments = 0;
                    this.vRAFile.seek(24L);
                    this.firstDataBlock = (long)this.vRAFile.readInt() & 0xFFFFFFFEL;
                    this.vRAFile.seek(40L);
                    this.numOfRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.deletedRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.totOpens = 0L;
                    this.vRAFile.seek(56L);
                    long csAddr = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    if (csAddr != 0L) {
                        this.collatingSequence = new byte[256];
                        this.vRAFile.seek(csAddr + 16L);
                        this.vRAFile.read(this.collatingSequence);
                    } else {
                        this.collatingSequence = null;
                    }
                    this.vRAFile.seek(64L);
                    this.userCount = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.segmentSize = 0L;
                    this.vRAFile.seek(96L);
                    this.maxRec = this.vRAFile.readChar();
                    this.minRec = this.vRAFile.readChar();
                    this.buffer = new byte[this.maxRec];
                    this.nKeys = this.vRAFile.readByte() & 0xFF;
                    this.keys = new Key[this.nKeys];
                    int dataBlock = 1;
                    boolean bl = this.compressed = (this.vRAFile.readByte() & 0xFF) != 0;
                    if ((this.vRAFile.readByte() & 0xFF) != 0) {
                        throw new IOException("Unsupported feature: encryption");
                    }
                    int offset = 160;
                    int keySize = 32;
                    for (int i = 0; i < this.nKeys; ++i) {
                        int nextOffs = offset + keySize * i;
                        int nextEnd = (nextOffs + keySize) % 512;
                        if (nextEnd != 0 && nextEnd <= keySize) {
                            offset = dataBlock * 512;
                            ++dataBlock;
                            offset -= keySize * i;
                        }
                        this.vRAFile.seek(offset + keySize * i);
                        int boh1 = this.vRAFile.readByte() & 0xFF;
                        int boh2 = this.vRAFile.readInt();
                        int nparts = this.vRAFile.readByte() & 0xFF;
                        boolean dups = this.vRAFile.readByte() != 0;
                        this.hasDuplicates |= dups;
                        int len = this.vRAFile.readByte() & 0xFF;
                        this.keys[i] = new Key(nparts, dups, len, 0);
                        for (int j = 0; j < nparts; ++j) {
                            short boh = (short)(this.vRAFile.readByte() & 0xFF);
                            short plen = (short)(this.vRAFile.readByte() & 0xFF);
                            char offs = this.vRAFile.readChar();
                            this.keys[i].parts[j] = new KeyPart(offs, plen);
                        }
                    }
                    if (this.firstDataBlock > 0L) {
                        this.vRAFile.seek(this.firstDataBlock);
                        break;
                    }
                    this.vRAFile.seek(this.vRAFile.length());
                    break;
                }
                case '\u0004': {
                    this.node = null;
                    this.vRAFile.seek(16L);
                    this.nDataSegments = this.vRAFile.readShort();
                    this.vRAFile.seek(30L);
                    this.firstDataBlock = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(52L);
                    this.numOfRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.deletedRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(64L);
                    this.totOpens = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(68L);
                    long csAddr = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    if (csAddr != 0L) {
                        this.collatingSequence = new byte[256];
                        this.vRAFile.seek(csAddr + 16L);
                        this.vRAFile.read(this.collatingSequence);
                    } else {
                        this.collatingSequence = null;
                    }
                    this.vRAFile.seek(76L);
                    this.userCount = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(102L);
                    this.segmentSize = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(116L);
                    this.maxRec = this.vRAFile.readChar();
                    this.minRec = this.vRAFile.readChar();
                    this.buffer = new byte[this.maxRec];
                    this.nKeys = this.vRAFile.readByte() & 0xFF;
                    this.keys = new Key[this.nKeys];
                    int dataBlock = 1;
                    boolean bl = this.compressed = (this.vRAFile.readByte() & 0xFF) != 0;
                    if ((this.vRAFile.readByte() & 0xFF) != 0) {
                        throw new IOException("Unsupported feature: encryption");
                    }
                    int offset = 160;
                    int keySize = 59;
                    for (int i = 0; i < this.nKeys; ++i) {
                        int nextOffs = offset + keySize * i;
                        int nextEnd = (nextOffs + keySize) % 512;
                        if (nextEnd != 0 && nextEnd <= keySize) {
                            offset = dataBlock * 512;
                            ++dataBlock;
                            offset -= keySize * i;
                        }
                        this.vRAFile.seek(offset + keySize * i);
                        int boh1 = this.vRAFile.readByte() & 0xFF;
                        char boh2 = this.vRAFile.readChar();
                        int boh3 = this.vRAFile.readInt();
                        int nparts = this.vRAFile.readByte() & 0xFF;
                        boolean dups = this.vRAFile.readByte() != 0;
                        this.hasDuplicates |= dups;
                        int len = this.vRAFile.readByte() & 0xFF;
                        short boh = (short)(this.vRAFile.readByte() & 0xFF);
                        this.keys[i] = new Key(nparts, dups, len, boh);
                        for (int j = 0; j < nparts; ++j) {
                            short plen = (short)(this.vRAFile.readByte() & 0xFF);
                            char offs = this.vRAFile.readChar();
                            this.keys[i].parts[j] = new KeyPart(offs, plen);
                        }
                    }
                    if (this.firstDataBlock > 0L) {
                        this.vRAFile.seek(this.firstDataBlock);
                        break;
                    }
                    this.vRAFile.seek(this.vRAFile.length());
                    break;
                }
                case '\u0005': {
                    this.vRAFile.seek(20L);
                    this.nDataSegments = this.vRAFile.readShort();
                    this.node = null;
                    this.vRAFile.seek(34L);
                    this.firstDataBlock = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(62L);
                    this.numOfRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.deletedRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(82L);
                    long csAddr = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    if (csAddr != 0L) {
                        this.collatingSequence = new byte[256];
                        this.vRAFile.seek(csAddr + 16L);
                        this.vRAFile.read(this.collatingSequence);
                    } else {
                        this.collatingSequence = null;
                    }
                    this.vRAFile.seek(92L);
                    this.userCount = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.totOpens = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(122L);
                    this.segmentSize = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(149L);
                    this.maxRec = this.vRAFile.readInt();
                    this.minRec = this.vRAFile.readInt();
                    this.buffer = new byte[this.maxRec];
                    this.nKeys = this.vRAFile.readByte() & 0xFF;
                    this.keys = new Key[this.nKeys];
                    int dataBlock = 1;
                    boolean bl = this.compressed = (this.vRAFile.readByte() & 0xFF) != 0;
                    if ((this.vRAFile.readByte() & 0xFF) != 0) {
                        throw new IOException("Unsupported feature: encryption");
                    }
                    int offset = 194;
                    int keySize = 106;
                    for (int i = 0; i < this.nKeys; ++i) {
                        int nextOffs = offset + keySize * i;
                        int nextEnd = (nextOffs + keySize) % this.blockSize;
                        if (nextEnd != 0 && nextEnd <= keySize) {
                            offset = dataBlock * this.blockSize;
                            ++dataBlock;
                            offset -= keySize * i;
                        }
                        if (this.vRAFile.getFilePointer() < (long)(offset + keySize * i)) {
                            this.vRAFile.seek(offset + keySize * i);
                        }
                        int boh1 = this.vRAFile.readByte() & 0xFF;
                        char boh2 = this.vRAFile.readChar();
                        int boh3 = this.vRAFile.readInt();
                        int nparts = this.vRAFile.readByte() & 0xFF;
                        while (nparts == 0) {
                            nparts = this.vRAFile.readByte() & 0xFF;
                        }
                        byte ddups = this.vRAFile.readByte();
                        while (ddups != 0 && ddups != 1) {
                            ddups = this.vRAFile.readByte();
                        }
                        boolean dups = ddups != 0;
                        this.hasDuplicates |= dups;
                        int len = this.vRAFile.readByte() & 0xFF;
                        this.keys[i] = new Key(nparts, dups, len, 0);
                        for (int j = 0; j < nparts; ++j) {
                            short boh = (short)(this.vRAFile.readByte() & 0xFF);
                            short plen = (short)(this.vRAFile.readByte() & 0xFF);
                            int offs = this.vRAFile.readInt();
                            this.keys[i].parts[j] = new KeyPart(offs, plen);
                        }
                    }
                    if (this.firstDataBlock > 0L) {
                        this.vRAFile.seek(this.firstDataBlock);
                        break;
                    }
                    this.vRAFile.seek(this.vRAFile.length());
                    break;
                }
                case '\u0006': {
                    this.vRAFile.seek(20L);
                    this.nDataSegments = this.vRAFile.readShort();
                    this.node = null;
                    this.vRAFile.seek(34L);
                    this.firstDataBlock = VisionFile.readInt48(this.vRAFile);
                    this.vRAFile.seek(62L);
                    this.numOfRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.deletedRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.seek(82L);
                    long csAddr = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    if (csAddr != 0L) {
                        this.collatingSequence = new byte[256];
                        this.vRAFile.seek(csAddr + 16L);
                        this.vRAFile.read(this.collatingSequence);
                    } else {
                        this.collatingSequence = null;
                    }
                    this.vRAFile.seek(92L);
                    this.userCount = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.totOpens = VisionFile.readInt48(this.vRAFile);
                    this.vRAFile.seek(122L);
                    this.segmentSize = 0L;
                    this.vRAFile.seek(134L);
                    this.maxRec = this.vRAFile.readInt();
                    this.minRec = this.vRAFile.readInt();
                    this.buffer = new byte[this.maxRec];
                    this.nKeys = this.vRAFile.readByte() & 0xFF;
                    this.keys = new Key[this.nKeys];
                    int dataBlock = 1;
                    boolean bl = this.compressed = (this.vRAFile.readByte() & 0xFF) != 0;
                    if ((this.vRAFile.readByte() & 0xFF) != 0) {
                        throw new IOException("Unsupported feature: encryption");
                    }
                    int offset = 178;
                    int keySize = 106;
                    for (int i = 0; i < this.nKeys; ++i) {
                        int nextOffs = offset + keySize * i;
                        int nextEnd = (nextOffs + keySize) % this.blockSize;
                        if (nextEnd != 0 && nextEnd <= keySize) {
                            offset = dataBlock * this.blockSize;
                            ++dataBlock;
                            offset -= keySize * i;
                        }
                        if (this.vRAFile.getFilePointer() < (long)(offset + keySize * i)) {
                            this.vRAFile.seek(offset + keySize * i);
                        }
                        int boh1 = this.vRAFile.readByte() & 0xFF;
                        int boh2 = this.vRAFile.readInt();
                        char boh3 = this.vRAFile.readChar();
                        int nparts = this.vRAFile.readByte() & 0xFF;
                        while (nparts == 0) {
                            nparts = this.vRAFile.readByte() & 0xFF;
                        }
                        byte ddups = this.vRAFile.readByte();
                        while (ddups != 0 && ddups != 1) {
                            ddups = this.vRAFile.readByte();
                        }
                        boolean dups = ddups != 0;
                        this.hasDuplicates |= dups;
                        int len = this.vRAFile.readByte() & 0xFF;
                        this.keys[i] = new Key(nparts, dups, len, 0);
                        for (int j = 0; j < nparts; ++j) {
                            short boh = (short)(this.vRAFile.readByte() & 0xFF);
                            short plen = (short)(this.vRAFile.readByte() & 0xFF);
                            int offs = this.vRAFile.readInt();
                            this.keys[i].parts[j] = new KeyPart(offs, plen);
                        }
                    }
                    if (this.firstDataBlock > 0L) {
                        this.vRAFile.seek(this.firstDataBlock);
                        break;
                    }
                    this.vRAFile.seek(this.vRAFile.length());
                    break;
                }
                default: {
                    throw new IOException("Vision version " + this.vVersion + " is not supported yet");
                }
            }
        }
        catch (IOException _ex) {
            this.close();
            throw _ex;
        }
    }

    String fmt(String Return2, int len, boolean left) {
        int sLen = Return2.length();
        if (sLen < len) {
            Return2 = left ? Return2 + "                                            ".substring(0, len - sLen) : "                                            ".substring(0, len - sLen) + Return2;
        }
        return Return2;
    }

    String fmt(String s, int len) {
        return this.fmt(s, len, false);
    }

    String fmt(long n, int len, boolean left) {
        String s = "" + n;
        return this.fmt(s, len, left);
    }

    String fmt(long n, int len) {
        return this.fmt(n, len, false);
    }

    public void printInfo() {
        String c;
        System.out.println(this.vFile.getPath() + "  [vision version " + this.vVersion + "]");
        System.out.println("");
        File xFile = new File(this.vFile.getPath() + ".vix");
        System.out.println("# of records:" + this.fmt(this.numOfRecords, 18));
        System.err.println("# of deleted records:" + this.fmt(this.deletedRecords, 10));
        if (this.vVersion > '\u0003') {
            System.out.println("file size: " + this.fmt(this.vFile.length(), 20) + " (" + this.vFile.getPath() + ")");
            System.out.println("file size: " + this.fmt(xFile.length(), 20) + " (" + xFile.getPath() + ")");
            System.out.println("total file size:" + this.fmt(this.vFile.length() + xFile.length(), 15));
            System.out.println("segment size:" + this.fmt(this.segmentSize, 18));
        } else {
            System.out.println("file size: " + this.fmt(this.vFile.length(), 20));
        }
        String string = c = this.compressed ? " compressed" : "";
        if (this.minRec == this.maxRec) {
            System.out.println("record size:" + this.fmt(this.maxRec, 19) + c);
        } else {
            System.out.println("record size (min/max):" + this.fmt(this.minRec, 9) + "/" + this.maxRec + c);
        }
        System.out.println("# of keys: " + this.fmt(this.nKeys, 20));
        System.out.println("user count:" + this.fmt(this.userCount, 20));
        System.out.println("");
        System.out.println("Key  Dups    Seg-1     Seg-2     Seg-3     Seg-4     Seg-5     Seg-6");
        System.out.println("            (sz/of)   (sz/of)   (sz/of)   (sz/of)   (sz/of)   (sz/of)");
        System.out.println("");
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < this.nKeys; ++i) {
            out.delete(0, out.length());
            out.append(this.fmt(i, 3));
            out.append(this.fmt(this.keys[i].duplicates ? "Y" : "N", 5));
            out.append("  ");
            for (int j = 0; j < this.keys[i].nparts; ++j) {
                out.append(this.fmt(this.keys[i].parts[j].length, 3));
                out.append("/");
                out.append(this.fmt(this.keys[i].parts[j].offset, 6, true));
            }
            System.out.println(out);
        }
    }

    public long getValidRecordsNum() {
        return this.numOfRecords;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readNode3() throws IOException {
        if (this.nodePnt != 0) {
            if (this.nodePnt != this.blockSize_4) return this.blockSize_4 - this.nodePnt;
        }
        this.nodePnt = 0;
        this.vRAFile.read(this.node, 0, this.blockSize_4);
        if (this.node[this.nodePnt++] != 2) throw new IOException("Corrupted file!!");
        long nextNode = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
        if (nextNode == 0L) return this.blockSize_4 - 1;
        this.vRAFile.seek(nextNode);
        return this.blockSize_4 - 1;
    }

    private int myReadChar3() throws IOException {
        int Return2;
        int rc = this.readNode3();
        if (rc < 1) {
            Return2 = -1;
        } else if (rc == 1) {
            Return2 = (this.node[this.nodePnt] & 0xFF) << 8;
            this.nodePnt = 0;
            Return2 = this.readNode3() >= 1 ? (Return2 |= this.node[this.nodePnt++] & 0xFF) : -1;
        } else {
            Return2 = (this.node[this.nodePnt++] & 0xFF) << 8;
            Return2 |= this.node[this.nodePnt++] & 0xFF;
        }
        return Return2;
    }

    private int myRead3(byte[] b, int offs, int len) throws IOException {
        int Return2 = len;
        int rc = this.readNode3();
        while (rc > 0 && rc < len) {
            System.arraycopy(this.node, this.nodePnt, b, offs, rc);
            offs += rc;
            len -= rc;
            this.nodePnt = 0;
            rc = this.readNode3();
        }
        if (rc > 0) {
            System.arraycopy(this.node, this.nodePnt, b, offs, len);
            this.nodePnt += len;
        } else {
            Return2 = -1;
        }
        return Return2;
    }

    private int fillRecord(int iLen, boolean comp, byte[] out, int oOf, int oLen) {
        int Return2;
        if (iLen == 0) {
            Return2 = 0;
        } else if (comp) {
            int state = 0;
            int count = 0;
            byte chr = 0;
            Return2 = 0;
            block10: for (int i = 0; i < iLen; ++i) {
                switch (state) {
                    case -5: {
                        for (count = this.buffer[i] & 0xFF; count > 0; --count) {
                            out[Return2++] = 0;
                        }
                        state = 0;
                        continue block10;
                    }
                    case -4: {
                        for (count = this.buffer[i] & 0xFF; count > 0; --count) {
                            out[Return2++] = 48;
                        }
                        state = 0;
                        continue block10;
                    }
                    case -3: {
                        for (count = this.buffer[i] & 0xFF; count > 0; --count) {
                            out[Return2++] = 32;
                        }
                        state = 0;
                        continue block10;
                    }
                    case -2: {
                        if (chr == 0) {
                            chr = this.buffer[i];
                            continue block10;
                        }
                        for (count = this.buffer[i] & 0xFF; count > 0; --count) {
                            out[Return2++] = chr;
                        }
                        state = 0;
                        chr = 0;
                        continue block10;
                    }
                    case -6: {
                        out[Return2++] = this.buffer[i];
                        state = 0;
                        continue block10;
                    }
                    default: {
                        switch (this.buffer[i]) {
                            case -6: 
                            case -5: 
                            case -4: 
                            case -3: 
                            case -2: {
                                state = this.buffer[i];
                                continue block10;
                            }
                        }
                        out[Return2++] = this.buffer[i];
                    }
                }
            }
        } else {
            Return2 = Math.min(iLen, oLen);
            System.arraycopy(this.buffer, 0, out, oOf, Return2);
        }
        return Return2;
    }

    private int readNext3(byte[] b, int offs, int len) {
        int Return2 = 0;
        while (Return2 == 0) {
            try {
                boolean comp;
                int recLen = this.myReadChar3();
                Return2 = this.myReadChar3();
                if (this.hasDuplicates) {
                    this.myRead3(this.dummyInt, 0, 4);
                }
                if (recLen <= 0) continue;
                if (recLen > this.buffer.length) {
                    this.buffer = new byte[recLen];
                }
                this.myRead3(this.buffer, 0, recLen);
                if (this.compressed) {
                    if ((Return2 & 0x8000) != 0) {
                        Return2 &= 0xFFFF7FFF;
                        comp = false;
                    } else {
                        comp = true;
                    }
                } else {
                    comp = false;
                }
                if (Return2 == 0) {
                    ++this.deletedRecordsNum;
                    continue;
                }
                if ((Return2 = this.fillRecord(Return2, comp, b, offs, len)) >= this.minRec && Return2 <= this.maxRec) {
                    ++this.validRecordsNum;
                    continue;
                }
                Return2 = -1;
            }
            catch (IOException _ex) {
                Return2 = -1;
            }
        }
        return Return2;
    }

    private boolean newDataSegment() {
        if (this.currDataSegment < this.nDataSegments) {
            ++this.currDataSegment;
            String ext = this.currDataSegment < 16 ? ".d0" + Integer.toHexString(this.currDataSegment) : ".d" + Integer.toHexString(this.currDataSegment);
            try {
                this.vFile = new File(this.fName + ext);
                this.vRAFile.close();
                this.vRAFile = new RandomAccessFile(this.vFile, "r");
                this.vRAFile.seek(512L);
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private int readNext4(byte[] b, int offs, int len) {
        int Return2 = 0;
        while (Return2 == 0) {
            try {
                char recLen = this.vRAFile.readChar();
                Return2 = this.vRAFile.readChar();
                if (this.hasDuplicates) {
                    this.vRAFile.readInt();
                }
                if (recLen > '\u0000') {
                    boolean comp;
                    if (recLen > this.buffer.length) {
                        this.buffer = new byte[recLen];
                    }
                    this.vRAFile.read(this.buffer, 0, recLen);
                    if (this.compressed) {
                        if ((Return2 & 0x8000) != 0) {
                            Return2 &= 0xFFFF7FFF;
                            comp = false;
                        } else {
                            comp = true;
                        }
                    } else {
                        comp = false;
                    }
                    if (Return2 == 0) {
                        ++this.deletedRecordsNum;
                        continue;
                    }
                    if ((Return2 = this.fillRecord(Return2, comp, b, offs, len)) >= this.minRec && Return2 <= this.maxRec) {
                        ++this.validRecordsNum;
                        continue;
                    }
                    Return2 = -1;
                    continue;
                }
                if (this.newDataSegment()) {
                    Return2 = this.readNext4(b, offs, len);
                    continue;
                }
                Return2 = -1;
            }
            catch (EOFException _ex) {
                if (this.newDataSegment()) {
                    Return2 = this.readNext4(b, offs, len);
                    continue;
                }
                Return2 = -1;
            }
            catch (IOException _ex) {
                Return2 = -1;
            }
        }
        return Return2;
    }

    private int readNext5(byte[] b, int offs, int len) {
        int Return2 = 0;
        while (Return2 == 0) {
            try {
                int recLen = this.vRAFile.readInt();
                Return2 = this.vRAFile.readInt();
                byte deleted = this.vRAFile.readByte();
                int progr1 = this.vRAFile.readInt();
                char progr2 = this.vRAFile.readChar();
                if (recLen > 0) {
                    if (recLen > this.buffer.length) {
                        this.buffer = new byte[recLen];
                    }
                    this.vRAFile.read(this.buffer, 0, recLen);
                    boolean comp = this.compressed && deleted != 4;
                    if (deleted == 1) {
                        ++this.deletedRecordsNum;
                        Return2 = 0;
                        continue;
                    }
                    if ((Return2 = this.fillRecord(Return2, comp, b, offs, len)) >= this.minRec && Return2 <= this.maxRec) {
                        ++this.validRecordsNum;
                        continue;
                    }
                    Return2 = -1;
                    continue;
                }
                if (this.newDataSegment()) {
                    Return2 = this.readNext5(b, offs, len);
                    continue;
                }
                Return2 = -1;
            }
            catch (EOFException _ex) {
                if (this.newDataSegment()) {
                    Return2 = this.readNext5(b, offs, len);
                    continue;
                }
                Return2 = -1;
            }
            catch (IOException _ex) {
                Return2 = -1;
            }
        }
        return Return2;
    }

    public int readNext(byte[] b, int offs, int len) {
        if (this.vVersion == '\u0003') {
            return this.readNext3(b, offs, len);
        }
        if (this.vVersion == '\u0004') {
            return this.readNext4(b, offs, len);
        }
        if (this.vVersion == '\u0005' || this.vVersion == '\u0006') {
            return this.readNext5(b, offs, len);
        }
        return -1;
    }

    public int readNext(byte[] b) {
        return this.readNext(b, 0, b.length);
    }

    public void close() {
        if (this.vRAFile != null) {
            try {
                this.vRAFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class Key {
        final int nparts;
        final boolean duplicates;
        final int length;
        final short boh;
        final KeyPart[] parts;

        Key(int n, boolean dups, int len, short b) {
            this.nparts = n;
            this.parts = new KeyPart[this.nparts];
            this.duplicates = dups;
            this.length = len;
            this.boh = b;
        }
    }

    static class KeyPart {
        final int offset;
        final short length;

        KeyPart(int o, short l) {
            this.offset = o;
            this.length = l;
        }
    }
}

