/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.BaseFile;
import com.iscobol.io.RMKFile;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ScanRMKF
implements DynamicFile,
RuntimeErrorsNumbers,
Cloneable {
    private RMKFile theFile;
    private KeyDescription[] keys;
    private String path = "";
    private int errno;
    private Exception errio = null;

    @Override
    public String getSysErrno() {
        if (this.errio != null) {
            return this.errio.getMessage();
        }
        return "";
    }

    @Override
    public String getErrMsg() {
        if (this.errio != null) {
            return this.errio.getMessage();
        }
        return "";
    }

    @Override
    public int getCobErrno() {
        return this.errno;
    }

    private int mapError(int e) {
        this.errno = e;
        return 0;
    }

    private int success() {
        this.errno = 0;
        return 1;
    }

    @Override
    public synchronized long getNumRecords() {
        if (this.theFile != null) {
            return this.theFile.getValidRecordsNum();
        }
        return -1L;
    }

    @Override
    public synchronized int getNumKeys() {
        int Return2;
        if (this.keys != null) {
            Return2 = this.keys.length;
        } else if (this.theFile != null) {
            Return2 = this.theFile.nKeys;
            this.keys = new KeyDescription[Return2];
        } else {
            Return2 = -1;
        }
        return Return2;
    }

    @Override
    public int getMaxRecordSize() {
        if (this.theFile != null) {
            return this.theFile.maxRec;
        }
        return -1;
    }

    @Override
    public int getMinRecordSize() {
        if (this.theFile != null) {
            return this.theFile.minRec;
        }
        return -1;
    }

    @Override
    public synchronized KeyDescription getKey(int num) {
        KeyDescription Return2;
        if (this.theFile != null && num >= 0 && num < this.getNumKeys()) {
            if (this.keys[num] == null) {
                this.keys[num] = new KeyDescription(this.theFile.keys[num].nparts, this.theFile.keys[num].duplicates);
                for (int i = 0; i < this.theFile.keys[num].nparts; ++i) {
                    this.keys[num].setSegment(i, this.theFile.keys[num].parts[i].length, this.theFile.keys[num].parts[i].offset);
                }
            }
            Return2 = this.keys[num];
        } else {
            Return2 = null;
            this.mapError(102);
        }
        return Return2;
    }

    @Override
    public byte[] getSequence() {
        return null;
    }

    @Override
    public int build(String ath, String comment, int blockingFactor, int preAllocate, int extensionFactor, int compressionFactor, int ecryptionFlag, int maxRecordSize, int minRecordSize, KeyDescription[] keys, byte[] collating, boolean assignExt) {
        return this.mapError(126);
    }

    @Override
    public synchronized int open(String pth, int openType, int lockType, KeyDescription[] k, int maxRec, int minRec, int nKeys, int accessMode, boolean optional, boolean assignExt) {
        this.path = pth;
        if (assignExt) {
            this.path = BaseFile.expandFileName(this.path);
        }
        try {
            this.theFile = new RMKFile(this.path);
        }
        catch (FileNotFoundException ex) {
            if (new File(this.path).exists()) {
                return this.mapError(131);
            }
            return this.mapError(130);
        }
        catch (IOException ex) {
            this.errio = ex;
            return this.mapError(133);
        }
        return this.success();
    }

    @Override
    public synchronized void setCurrentRecord(long nRec) {
    }

    @Override
    public synchronized long getCurrentRecord() {
        return this.mapError(126);
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    @Override
    public synchronized int close() {
        if (this.theFile != null) {
            this.theFile.close();
            this.theFile = null;
            this.keys = null;
            this.path = "";
        }
        return this.success();
    }

    @Override
    public boolean isOpen() {
        return this.theFile != null;
    }

    @Override
    public synchronized long write(byte[] record, int offs, int size, boolean lock) {
        return this.mapError(126);
    }

    @Override
    public synchronized long rewrite(byte[] record, int offs, int size, boolean lock) {
        return this.mapError(126);
    }

    @Override
    public synchronized long delete(byte[] record, int offs) {
        return this.mapError(126);
    }

    @Override
    public synchronized long next(byte[] record, int offs, int lock) {
        int Return2;
        if (this.theFile != null) {
            try {
                Return2 = this.theFile.readNext(record, offs, record.length - offs);
            }
            catch (IOException _ex) {
                Return2 = this.mapError(105);
            }
            if (Return2 <= 0) {
                Return2 = this.mapError(this.theFile.getErrno());
            } else {
                this.success();
            }
        } else {
            Return2 = this.mapError(101);
        }
        return Return2;
    }

    private int findKey(KeyDescription key) {
        int Return2;
        int nKeys = this.getNumKeys();
        try {
            for (Return2 = 0; Return2 < nKeys && !key.equals(this.getKey(Return2)); ++Return2) {
            }
        }
        catch (NullPointerException e) {
            Return2 = -1;
        }
        return Return2;
    }

    @Override
    public synchronized long previous(byte[] record, int offs, int lock) {
        return this.mapError(126);
    }

    @Override
    public long read(byte[] record, int offs, KeyDescription k, int lock) {
        return this.read(record, offs, this.findKey(k), lock);
    }

    @Override
    public long read(byte[] record, int offs, int keyNum, int lock) {
        long Return2 = this.start(record, offs, keyNum, 0, 5);
        if (Return2 == 1L) {
            Return2 = this.next(record, offs, lock);
        }
        return Return2;
    }

    @Override
    public long start(byte[] record, int offs, int kNum, int kSize, int mode) {
        try {
            int rc = this.theFile.start(record, offs, kNum, kSize, mode);
            if (rc != 1) {
                return this.mapError(this.theFile.getErrno());
            }
            return this.success();
        }
        catch (IOException _ex) {
            return this.mapError(133);
        }
    }

    @Override
    public long start(byte[] record, int offs, KeyDescription k, int kSize, int mode) {
        return this.start(record, offs, this.findKey(k), kSize, mode);
    }

    @Override
    public synchronized int unlock() {
        return this.mapError(126);
    }

    @Override
    public synchronized int recover() {
        return this.mapError(126);
    }

    @Override
    public void sync(int allFiles) {
    }

    @Override
    public int remove(String name) {
        return this.mapError(126);
    }

    @Override
    public int rename(String src, String dst) {
        return this.mapError(126);
    }

    @Override
    public int begin() {
        return this.success();
    }

    @Override
    public int commit(int ctx) {
        return this.success();
    }

    @Override
    public int rollback() {
        return this.success();
    }

    @Override
    public String getVersion() {
        return "VisionScan v" + this.theFile.vVersion;
    }

    @Override
    public boolean isKeySelectedByNum() {
        return true;
    }

    public void finalize() {
        this.close();
    }

    public static void main(String[] argv) throws Exception {
        for (int i = 0; i < argv.length; ++i) {
            ScanRMKF f = new ScanRMKF();
            f.open(argv[i], 0, 0, null, 0, 0, 0, 0, false, false);
            if (f.theFile != null) {
                f.theFile.printInfo();
            }
            if (f.getCobErrno() != 0) {
                System.out.println(argv[i] + " error=" + f.getCobErrno() + ", sys=" + f.getSysErrno() + ", msg=" + f.getErrMsg());
                continue;
            }
            byte[] record = new byte[f.getMaxRecordSize()];
            for (int k = 0; k < f.theFile.nKeys; ++k) {
                long rc;
                f.start(record, 0, k, 0, 0);
                int cnt = 0;
                while ((rc = f.next(record, 0, record.length)) > 0L) {
                    ++cnt;
                }
                System.out.println(">>>found " + cnt + " out of " + f.getNumRecords());
                System.out.println(">>>exit=" + f.getCobErrno());
            }
            f.close();
        }
    }

    public static String recToString(byte[] rec) {
        char[] sb = new char[rec.length];
        for (int i = 0; i < rec.length; ++i) {
            sb[i] = rec[i] >= 32 && rec[i] <= 127 ? (int)rec[i] : 46;
        }
        return new String(sb);
    }
}

