/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.isam.FLock;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.OSFile;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolSystem;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class FileLock {
    private static final boolean OPEN_CHECK = Config.getProperty(".file.open_check", false);
    private static final long OPEN_LOCK_POS = System.getProperty("java.version").compareTo("1.5") >= 0 ? 0x7FFFFFFFFFFFFFFEL : 0x7FFFFFFEL;
    private static final boolean isAS = IscobolSystem.isAS();
    private static final HashMap openFiles = isAS ? new HashMap() : null;
    private static final int[] LOCK_EXCL = new int[]{-1};
    private String filePath;
    private final boolean exclusiveLock;
    private final OSFile file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLock(String path, OSFile f, boolean exLock, boolean read) throws IsamException {
        this.file = f;
        this.exclusiveLock = exLock;
        if (this.exclusiveLock) {
            FLock lck = new FLock();
            lck.l_whence = 0;
            lck.l_start = 0L;
            lck.l_len = 0;
            lck.l_type = read ? (short)0 : 1;
            if (isAS) {
                try {
                    path = new File(path).getCanonicalPath();
                }
                catch (IOException _ex) {
                    throw new IsamException(_ex);
                }
                HashMap _ex = openFiles;
                synchronized (_ex) {
                    if (openFiles.get(path) != null) {
                        throw new IsamException(113);
                    }
                    openFiles.put(path, LOCK_EXCL);
                    try {
                        this.file.fcntl(6, lck);
                    }
                    catch (IsamException ex) {
                        openFiles.remove(path);
                        throw ex;
                    }
                }
            }
            this.file.fcntl(6, lck);
        } else {
            if (isAS) {
                try {
                    path = new File(path).getCanonicalPath();
                }
                catch (IOException _ex) {
                    throw new IsamException(_ex);
                }
                HashMap _ex = openFiles;
                synchronized (_ex) {
                    int[] nLocks = (int[])openFiles.get(path);
                    if (nLocks == null) {
                        openFiles.put(path, new int[]{1});
                    } else {
                        if (nLocks == LOCK_EXCL) {
                            throw new IsamException(113);
                        }
                        nLocks[0] = nLocks[0] + 1;
                    }
                }
            }
            if (OPEN_CHECK) {
                FLock lck = new FLock();
                lck.l_whence = 0;
                lck.l_start = OPEN_LOCK_POS;
                lck.l_len = 1;
                lck.l_type = 0;
                this.file.fcntl(6, lck);
            }
        }
        this.filePath = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        if (this.filePath != null) {
            if (this.exclusiveLock) {
                FLock lck = new FLock();
                lck.l_whence = 0;
                lck.l_type = (short)2;
                if (isAS) {
                    HashMap hashMap = openFiles;
                    synchronized (hashMap) {
                        openFiles.remove(this.filePath);
                    }
                }
                lck.l_start = 0L;
                lck.l_len = 0;
                try {
                    this.file.fcntl(6, lck);
                }
                catch (IsamException isamException) {}
            } else {
                if (isAS) {
                    HashMap lck = openFiles;
                    synchronized (lck) {
                        int[] nLocks = (int[])openFiles.get(this.filePath);
                        if (nLocks != null && (nLocks[0] = nLocks[0] - 1) == 0) {
                            openFiles.remove(this.filePath);
                        }
                    }
                }
                if (OPEN_CHECK) {
                    FLock lck = new FLock();
                    lck.l_whence = 0;
                    lck.l_type = (short)2;
                    lck.l_start = OPEN_LOCK_POS;
                    lck.l_len = 1;
                    try {
                        this.file.fcntl(6, lck);
                    }
                    catch (IsamException isamException) {
                        // empty catch block
                    }
                }
            }
            this.filePath = null;
        }
    }
}

