/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.AtEndException;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.ItemToSort;
import com.iscobol.io.JavaToIscobolError;
import com.iscobol.io.SortFile;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicSort;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.SortKey;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class DynamicJavaSort
implements DynamicSort,
RuntimeErrorsNumbers {
    public static final int BUFFERSIZE = Config.getProperty(".sort.memsize", 0x100000);
    public static final int NMERGE = Config.getProperty(".sort.maxfiles", 16);
    private Vector array = new Vector();
    private Vector files = new Vector();
    private int maxRecSize;
    private int intSize;
    private int totElem;
    private int maxElem;
    private int readElem;
    private int cobErrno;
    private SortKey key;
    private String path;
    private CobolFile[] giving;
    private ICobolVar[] gNames;
    private ICobolVar record;
    private SortFile finalFile;
    private boolean mergeOnly;

    @Override
    public int initSort(String fName, ICobolVar rec, SortKey k, CobolFile[] using, ICobolVar[] uNames, CobolFile[] giv, ICobolVar[] gNam) {
        this.path = fName;
        this.record = rec;
        this.key = k;
        this.giving = giv;
        this.gNames = gNam;
        this.cobErrno = 0;
        this.maxRecSize = this.record.getMaxLength();
        this.intSize = this.maxRecSize + 4;
        int Return2 = 1;
        this.maxElem = BUFFERSIZE / this.intSize;
        if (using != null && using.length > 0) {
            for (int i = 0; i < using.length; ++i) {
                try {
                    using[i].open(uNames[i], 1, 1);
                    while (Return2 == 1) {
                        Return2 = this.releaseRecord(using[i].readNext(false, this.record));
                    }
                }
                catch (AtEndException atEndException) {
                    // empty catch block
                }
                using[i].close();
            }
            if (Return2 == 1) {
                Return2 = this.endInput();
            }
        }
        return Return2;
    }

    @Override
    public int initMerge(String path, ICobolVar record, SortKey key, CobolFile[] using, ICobolVar[] uNames, CobolFile[] giving, ICobolVar[] gNames) {
        this.mergeOnly = true;
        return this.initSort(path, record, key, using, uNames, giving, gNames);
    }

    private static int getRecLen(byte[] rec) {
        int offs = rec.length - 4;
        int Return2 = (rec[offs++] & 0xFF) << 24;
        Return2 |= (rec[offs++] & 0xFF) << 16;
        Return2 |= (rec[offs++] & 0xFF) << 8;
        return Return2 |= rec[offs] & 0xFF;
    }

    private static void putRecLen(byte[] rec, int rl) {
        int offs = rec.length - 4;
        rec[offs++] = (byte)(rl >>> 24);
        rec[offs++] = (byte)(rl >>> 16);
        rec[offs++] = (byte)(rl >>> 8);
        rec[offs] = (byte)rl;
    }

    @Override
    public int releaseRecord(int rl) {
        if (this.array.size() == this.maxElem) {
            if (!this.mergeOnly) {
                Collections.sort(this.array);
            }
            try {
                this.writeBuffer();
            }
            catch (IOException _ex) {
                this.cobErrno = JavaToIscobolError.map(_ex);
                return 0;
            }
        }
        byte[] nrec = new byte[this.intSize];
        System.arraycopy(this.record.getBytes(), 0, nrec, 0, rl);
        DynamicJavaSort.putRecLen(nrec, rl);
        this.array.addElement(new ItemToSort(this.key.keyArray, nrec));
        ++this.totElem;
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int endInput() {
        if (this.array.size() > 1) {
            Collections.sort(this.array);
        }
        if (this.files.size() > 0) {
            try {
                this.merge();
                this.finalFile = (SortFile)this.files.elementAt(0);
                this.finalFile.openRead();
            }
            catch (IOException _ex) {
                this.cobErrno = JavaToIscobolError.map(_ex);
                return 0;
            }
        }
        if (this.giving != null && this.giving.length > 0) {
            try {
                this.giving[0].open(this.gNames[0], 2, 1);
                while (true) {
                    int rl;
                    if ((rl = this.returnRecord()) < 0) {
                        if (this.cobErrno == 110) {
                            break;
                        }
                        int n = 0;
                        return n;
                    }
                    this.giving[0].updateBuffer(this.record.getBytes());
                    this.giving[0].write(false, rl);
                }
            }
            catch (CobolIOException _ex) {
                this.cobErrno = _ex.getErrNum();
                int n = 0;
                return n;
            }
            finally {
                this.giving[0].close();
                this.finalize();
            }
        }
        return 1;
    }

    @Override
    public int returnRecord() {
        byte[] mem = null;
        int Return2 = -1;
        if (this.finalFile == null) {
            if (this.readElem == this.array.size()) {
                this.cobErrno = 110;
                return Return2;
            }
            mem = ((ItemToSort)this.array.elementAt((int)this.readElem++)).memory;
            Return2 = DynamicJavaSort.getRecLen(mem);
        } else {
            try {
                this.finalFile.read();
            }
            catch (IOException _ex) {
                this.cobErrno = JavaToIscobolError.map(_ex);
                return Return2;
            }
            if (this.finalFile.isAtEnd()) {
                this.cobErrno = 110;
                return Return2;
            }
            mem = this.finalFile.buffer.memory;
            Return2 = DynamicJavaSort.getRecLen(mem);
        }
        this.record.set(mem, 0, Return2, true);
        return Return2;
    }

    @Override
    public int endOutput() {
        this.finalize();
        return 1;
    }

    private void writeBuffer() throws IOException {
        if (this.files.size() == NMERGE) {
            this.merge();
        } else {
            SortFile sf = new SortFile(this.intSize, this.key.keyArray);
            sf.create();
            this.files.addElement(sf);
            Iterator it = this.array.iterator();
            while (it.hasNext()) {
                sf.write((ItemToSort)it.next());
            }
            sf.close();
            this.array.removeAllElements();
        }
    }

    private void merge() throws IOException {
        ItemToSort minLine;
        SortFile sf2;
        SortFile minSf = null;
        int nElem = 0;
        if (this.array.size() == 0 && this.files.size() < 2 || this.files.size() < 1) {
            return;
        }
        SortFile newFile = new SortFile(this.intSize, this.key.keyArray);
        newFile.create();
        for (SortFile sf2 : this.files) {
            sf2.openRead();
            sf2.read();
        }
        do {
            minLine = null;
            Iterator it = this.files.iterator();
            while (it.hasNext()) {
                sf2 = (SortFile)it.next();
                if (sf2.isAtEnd()) {
                    sf2.finalize();
                    it.remove();
                    continue;
                }
                if (minLine != null) {
                    if (minLine.compareTo(sf2.buffer) <= 0) continue;
                    minLine = sf2.buffer;
                    minSf = sf2;
                    continue;
                }
                minLine = sf2.buffer;
                minSf = sf2;
            }
            if (nElem < this.array.size()) {
                ItemToSort memLine = (ItemToSort)this.array.elementAt(nElem);
                if (minLine == null || minLine.compareTo(memLine) > 0) {
                    minLine = memLine;
                    minSf = null;
                }
            }
            if (minLine == null) continue;
            newFile.write(minLine);
            if (minSf != null) {
                minSf.read();
                continue;
            }
            ++nElem;
        } while (minLine != null);
        if (this.files.size() == 1) {
            sf2 = (SortFile)this.files.elementAt(0);
            sf2.finalize();
            this.files.remove(0);
        }
        this.files.addElement(newFile);
        newFile.close();
        this.array.removeAllElements();
    }

    public void finalize() {
        Iterator it = this.files.iterator();
        while (it.hasNext()) {
            ((SortFile)it.next()).finalize();
        }
        this.array.clear();
        this.readElem = 0;
    }

    @Override
    public int getCobErrno() {
        return this.cobErrno;
    }
}

