/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.dci.Dci;
import com.iscobol.io.BaseFile;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IOUtil;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.MonitorFinalize;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.util.ArrayList;

public class DynamicDci
implements DynamicFile,
RuntimeErrorsNumbers,
Cloneable {
    private int theFile = -1;
    private MyConn theConn;
    private int openMode = 0;
    private KeyDescription[] keys;
    private int maxRecordSize;
    private int minRecordSize;
    private String path = "";
    private int errno;
    private String sysError;
    private String errMsg;
    private static final Object exit = new Object(){

        protected void finalize() {
            Dci.exit();
        }
    };

    public static int setenv(byte[] key, byte[] value) {
        MyConn conn = (MyConn)IscobolSystem.get(MyConn.class);
        if (conn == null) {
            Env env = (Env)IscobolSystem.get(Env.class);
            if (env == null) {
                env = new Env();
                IscobolSystem.set(Env.class, env);
            }
            env.set(key, value);
        } else {
            Dci.dci__setenv(conn.conn, key, value);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicDci() {
        Object object = exit;
        synchronized (object) {
            this.theConn = (MyConn)IscobolSystem.get(MyConn.class);
            if (this.theConn == null) {
                MyConn conn;
                Env env = (Env)IscobolSystem.get(Env.class);
                if (env == null) {
                    conn = new MyConn(Dci.c_connect(null, null, null));
                } else {
                    conn = new MyConn(Dci.c_connect(env.database, env.login, env.password));
                    env.update(conn);
                }
                this.theConn = conn;
                if (conn.conn >= 0) {
                    IscobolSystem.set(MyConn.class, conn);
                    Factory.getCurrentMonitor().addObjToFinalize(new MonitorFinalize(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void monitorFinalize() {
                            Object object = exit;
                            synchronized (object) {
                                Dci.c_disconn(conn.conn);
                                conn.conn = -1;
                            }
                        }
                    });
                }
            }
        }
    }

    private int getConn() {
        return this.theConn.conn;
    }

    @Override
    public String getSysErrno() {
        return this.sysError;
    }

    @Override
    public String getErrMsg() {
        return this.errMsg;
    }

    public int getFErrno() {
        return this.errno;
    }

    @Override
    public int getCobErrno() {
        switch (this.errno) {
            case 0: {
                return 0;
            }
            case 1: {
                return 133;
            }
            case 2: {
                return 102;
            }
            case 3: {
                return 104;
            }
            case 4: {
                return 125;
            }
            case 5: {
                return 107;
            }
            case 6: {
                return 105;
            }
            case 7: {
                return 100;
            }
            case 8: {
                return 111;
            }
            case 9: {
                return 112;
            }
            case 10: {
                return 127;
            }
            case 11: {
                return 113;
            }
            case 12: {
                return 128;
            }
            case 13: {
                return 128;
            }
            case 14: {
                return 116;
            }
            case 15: {
                return 130;
            }
            case 16: {
                return 131;
            }
            case 17: {
                return 126;
            }
            case 18: {
                return 129;
            }
            case 19: {
                return 140;
            }
            case 20: {
                return 133;
            }
            case 22: {
                return 122;
            }
            case 100: {
                return 204;
            }
            case 101: {
                return 200;
            }
        }
        return 134;
    }

    private void setLock(boolean lock) {
        if (lock) {
            Dci.set_f_no_lock(0);
        } else {
            Dci.set_f_no_lock(1);
        }
    }

    @Override
    public long getNumRecords() {
        byte[] result = new byte[11];
        int rc = Dci.i_info(this.theFile, -4, result);
        return Long.parseLong(new String(result, 0, 10));
    }

    @Override
    public int getNumKeys() {
        if (this.keys == null) {
            byte[] result = new byte[256];
            int rc = Dci.i_info(this.theFile, -1, result);
            if (rc == 0) {
                return this.mapError();
            }
            int[] values = IOUtil.csv2Int(result);
            this.maxRecordSize = values[0];
            this.minRecordSize = values[1];
            this.keys = new KeyDescription[values[2]];
        }
        return this.keys.length;
    }

    @Override
    public int getMaxRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.maxRecordSize;
    }

    @Override
    public int getMinRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.minRecordSize;
    }

    @Override
    public KeyDescription getKey(int num) {
        KeyDescription Return2;
        if (num >= 0 && num < this.getNumKeys()) {
            if (this.keys[num] == null) {
                byte[] result = new byte[256];
                int rc = Dci.i_info(this.theFile, num, result);
                if (rc == 0) {
                    this.mapError();
                    return null;
                }
                this.keys[num] = new KeyDescription(result);
            }
            Return2 = this.keys[num];
        } else {
            Return2 = null;
            this.mapError(2);
        }
        return Return2;
    }

    @Override
    public byte[] getSequence() {
        return null;
    }

    private int findKey(KeyDescription key) {
        int Return2;
        int nKeys = this.getNumKeys();
        try {
            for (Return2 = 0; Return2 < nKeys && !key.equals(this.getKey(Return2)); ++Return2) {
            }
        }
        catch (NullPointerException e) {
            Return2 = -1;
        }
        return Return2;
    }

    private int mapError(int err, int sys) {
        this.errno = err;
        this.sysError = "" + sys;
        this.errMsg = "";
        return 0;
    }

    private int mapError(int err) {
        this.errno = err;
        this.sysError = "";
        this.errMsg = "";
        return 0;
    }

    private int mapError() {
        this.errno = Dci.f_errno();
        this.sysError = "" + Dci.f_int_errno();
        this.errMsg = Dci.f_errmsg();
        if (this.errMsg == null) {
            this.errMsg = "";
        }
        return 0;
    }

    int mapOpen(int mode, int lockType) {
        int Return2;
        switch (mode) {
            default: {
                Return2 = 0;
                break;
            }
            case 2: {
                Return2 = 1;
                break;
            }
            case 3: {
                Return2 = 2;
                break;
            }
            case 6: {
                Return2 = 3;
            }
        }
        switch (lockType & 0xF) {
            default: {
                break;
            }
            case 1: 
            case 6: {
                Return2 |= 0x300;
                break;
            }
            case 4: {
                Return2 |= 0x200;
                break;
            }
            case 3: 
            case 5: {
                Return2 |= 0x100;
            }
        }
        if ((lockType & 0x100) != 0) {
            Return2 |= 0x10;
        }
        if ((lockType & 0x200) != 0) {
            Return2 |= 0x600;
        }
        if ((lockType & 0x800) != 0) {
            Return2 |= 0x4000;
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int build(String path, String comment, int blockingFactor, int preAllocate, int extensionFactor, int compressionFactor, int ecryptionFlag, int maxRecordSize, int minRecordSize, KeyDescription[] keys, byte[] collating, boolean assignExt) {
        Object object = exit;
        synchronized (object) {
            if (assignExt) {
                path = BaseFile.expandFileName(path);
            }
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            String p_params = new String(IOUtil.int2Csv(new int[]{blockingFactor, preAllocate, extensionFactor, compressionFactor, ecryptionFlag}, new int[]{1, 1, 1, 3, 1}));
            String l_params = "" + maxRecordSize + "," + minRecordSize + "," + keys.length;
            StringBuffer ks = new StringBuffer();
            int i = 0;
            while (true) {
                ks.append(keys[i].toString());
                if (++i >= keys.length) break;
                ks.append(',');
            }
            if (Dci.c_make(this.getConn(), path, comment, p_params, l_params, ks.toString(), null) == 0) {
                return this.mapError();
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int open(String path, int openType, int lockType, KeyDescription[] k, int maxRec, int minRec, int nKeys, int accesMode, boolean optional, boolean assignExt) {
        Object object = exit;
        synchronized (object) {
            if (assignExt) {
                path = BaseFile.expandFileName(path);
            }
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            String l_params = "" + maxRec + "," + minRec + "," + nKeys;
            switch (openType) {
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    this.theFile = Dci.c_open(this.getConn(), path, this.mapOpen(openType, lockType), l_params);
                    if (this.theFile >= 0) break;
                    return this.mapError();
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
                }
            }
            this.openMode = openType;
            this.path = path;
            return 1;
        }
    }

    @Override
    public void setCurrentRecord(long nRec) {
    }

    @Override
    public long getCurrentRecord() {
        return 0L;
    }

    @Override
    public boolean isOpen() {
        return this.openMode != 0;
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int close() {
        Object object = exit;
        synchronized (object) {
            if (this.isOpen()) {
                this.openMode = 0;
                if (this.getConn() >= 0 && Dci.c_close(this.getConn(), this.theFile) == 0) {
                    return this.mapError();
                }
                this.theFile = -1;
                this.keys = null;
                this.path = "";
                return 1;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(byte[] record, int offs, int size, boolean lock) {
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            this.setLock(lock);
            int rc = Dci.i_write(this.theFile, record, offs, size);
            this.errno = Dci.f_errno();
            if (rc == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rewrite(byte[] record, int offs, int size, boolean lock) {
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            this.setLock(lock);
            int rc = Dci.i_rewrite(this.theFile, record, offs, size);
            this.errno = Dci.f_errno();
            if (rc == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long delete(byte[] record, int offs) {
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            if (Dci.i_delete(this.theFile, record, offs) == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next(byte[] record, int offs, int lock) {
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            this.setLock(lock > 0);
            int Return2 = Dci.i_next(this.theFile, record, offs);
            this.errno = Dci.f_errno();
            if (Return2 == 0) {
                return this.mapError();
            }
            return Return2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long previous(byte[] record, int offs, int lock) {
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            this.setLock(lock > 0);
            int Return2 = Dci.i_previous(this.theFile, record, offs);
            this.errno = Dci.f_errno();
            if (Return2 == 0) {
                return this.mapError();
            }
            return Return2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(byte[] record, int offs, int keyNum, int lock) {
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            this.setLock(lock > 0);
            int Return2 = Dci.i_read(this.theFile, record, offs, keyNum);
            this.errno = Dci.f_errno();
            if (Return2 == 0) {
                return this.mapError();
            }
            return Return2;
        }
    }

    @Override
    public long read(byte[] record, int offs, KeyDescription key, int lock) {
        return this.read(record, offs, this.findKey(key), lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long start(byte[] record, int offs, int kNum, int kSize, int mode) {
        Object object = exit;
        synchronized (object) {
            int rc;
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            switch (mode) {
                case 0: {
                    byte[] tmpBuf = new byte[record.length];
                    rc = Dci.i_start(this.theFile, tmpBuf, 0, kNum, kSize, 1);
                    break;
                }
                case 1: {
                    byte[] tmpBuf = new byte[record.length];
                    for (int i = record.length - 1; i >= 0; --i) {
                        tmpBuf[i] = -1;
                    }
                    rc = Dci.i_start(this.theFile, tmpBuf, 0, kNum, kSize, 4);
                    break;
                }
                case 5: {
                    rc = Dci.i_start(this.theFile, record, offs, kNum, kSize, 0);
                    break;
                }
                case 6: {
                    rc = Dci.i_start(this.theFile, record, offs, kNum, kSize, 2);
                    break;
                }
                case 7: {
                    rc = Dci.i_start(this.theFile, record, offs, kNum, kSize, 1);
                    break;
                }
                case 8: {
                    rc = Dci.i_start(this.theFile, record, offs, kNum, kSize, 3);
                    break;
                }
                case 9: {
                    rc = Dci.i_start(this.theFile, record, offs, kNum, kSize, 4);
                    break;
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("START").toString());
                }
            }
            if (rc == 0) {
                return this.mapError();
            }
            return 1L;
        }
    }

    @Override
    public long start(byte[] record, int offs, KeyDescription k, int kSize, int mode) {
        return this.start(record, offs, this.findKey(k), kSize, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unlock() {
        int Return2;
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            Return2 = Dci.i_unlock(this.theFile);
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(int allFiles) {
        Object object = exit;
        synchronized (object) {
            if (this.getConn() >= 0) {
                Dci.i_sync(allFiles);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(String name) {
        int Return2 = 0;
        Object object = exit;
        synchronized (object) {
            if (this.getConn() >= 0) {
                Return2 = Dci.c_remove(this.getConn(), name);
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rename(String src, String dst) {
        int Return2;
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            Return2 = Dci.i_rename(src, dst);
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int begin() {
        int Return2 = 0;
        Object object = exit;
        synchronized (object) {
            if (this.getConn() >= 0) {
                Return2 = Dci.c_begin(this.getConn());
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int commit(int ctx) {
        int Return2 = 0;
        Object object = exit;
        synchronized (object) {
            if (this.getConn() >= 0) {
                Return2 = Dci.c_commit(this.getConn(), ctx);
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rollback() {
        int Return2 = 0;
        Object object = exit;
        synchronized (object) {
            if (this.getConn() >= 0) {
                Return2 = Dci.c_rollback(this.getConn());
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int recover() {
        int Return2;
        Object object = exit;
        synchronized (object) {
            if (this.getConn() < 0) {
                return this.mapError(1, 5510);
            }
            Return2 = Dci.i_recover();
        }
        return Return2;
    }

    @Override
    public String getVersion() {
        int intVersionLen;
        int fileVersionLen;
        int nameLen;
        byte[] name = new byte[255];
        byte[] fileVersion = new byte[255];
        byte[] intVersion = new byte[255];
        int rc = Dci.i_version(name, fileVersion, intVersion, 0, null);
        for (nameLen = 0; nameLen < name.length && name[nameLen] != 0; ++nameLen) {
        }
        for (fileVersionLen = 0; fileVersionLen < fileVersion.length && fileVersion[fileVersionLen] != 0; ++fileVersionLen) {
        }
        for (intVersionLen = 0; intVersionLen < intVersion.length && intVersion[intVersionLen] != 0; ++intVersionLen) {
        }
        return new String(name, 0, nameLen) + ";" + new String(fileVersion, 0, fileVersionLen) + ";" + new String(intVersion, 0, intVersionLen);
    }

    @Override
    public boolean isKeySelectedByNum() {
        return false;
    }

    public void finalize() {
        this.close();
    }

    static {
        Dci.i_init();
    }

    public static class Env {
        String database;
        String login;
        String password;
        private ArrayList<byte[][]> env = new ArrayList();

        void set(byte[] key, byte[] value) {
            String keyStr;
            this.env.add(new byte[][]{key, value});
            switch (keyStr = new String(key).trim().toUpperCase()) {
                case "DCI_DATABASE": {
                    this.database = new String(value).trim();
                    break;
                }
                case "DCI_LOGIN": {
                    this.login = new String(value).trim();
                    break;
                }
                case "DCI_PASSWORD": {
                    this.password = new String(value).trim();
                    break;
                }
            }
        }

        void update(MyConn conn) {
            if (conn != null && conn.conn >= 0) {
                int end = this.env.size();
                for (int i = 0; i < end; ++i) {
                    byte[][] keyValue = this.env.get(i);
                    Dci.dci__setenv(conn.conn, keyValue[0], keyValue[1]);
                }
                this.env.clear();
            }
        }
    }

    public static class MyConn {
        private int conn;

        MyConn(int c) {
            this.conn = c;
        }

        public int getConn() {
            return this.conn;
        }
    }
}

