/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.server;

import com.iscobol.as.ClientInfo;
import com.iscobol.gui.Constants;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.LocLinkedList;
import com.iscobol.gui.ParamElementArrayInt;
import com.iscobol.gui.ParamElementBoolean;
import com.iscobol.gui.ParamElementInt;
import com.iscobol.gui.ParamElementIntArrayInt;
import com.iscobol.gui.ParamElementIntBoolean;
import com.iscobol.gui.ParamElementIntInt;
import com.iscobol.gui.ParamElementVector;
import com.iscobol.gui.ParamVElement;
import com.iscobol.gui.ParamVector;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.server.BaseGUIControl;
import com.iscobol.gui.server.BaseGUIWindow;
import com.iscobol.gui.server.BeanContainer;
import com.iscobol.gui.server.ChangeFocusEvent;
import com.iscobol.gui.server.CobolAcceptStack;
import com.iscobol.gui.server.CobolGUIChipsBox;
import com.iscobol.gui.server.CobolGUIComboBox;
import com.iscobol.gui.server.CobolGUIJavaBean;
import com.iscobol.gui.server.CobolGUIScrollPane;
import com.iscobol.gui.server.CobolGUITab;
import com.iscobol.gui.server.CobolGUITerminalAccept;
import com.iscobol.gui.server.CobolGUITerminalAcceptScreen;
import com.iscobol.gui.server.CobolGUITerminalDisplay;
import com.iscobol.gui.server.CobolRecordAccept;
import com.iscobol.gui.server.DisplayMessageBox;
import com.iscobol.gui.server.DisplayToolBar;
import com.iscobol.gui.server.DisplayWindow;
import com.iscobol.gui.server.FontCmp;
import com.iscobol.gui.server.NullControl;
import com.iscobol.gui.server.NullSubWindow;
import com.iscobol.gui.server.NullWindow;
import com.iscobol.gui.server.ProcedureObject;
import com.iscobol.gui.server.ScrFactory;
import com.iscobol.gui.server.SubWindow;
import com.iscobol.gui.server.TerminalEmulation;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.AcceptException;
import com.iscobol.rts.ArrayTable;
import com.iscobol.rts.CallOverflowException;
import com.iscobol.rts.Config;
import com.iscobol.rts.DisplayException;
import com.iscobol.rts.Factory;
import com.iscobol.rts.FactoryData;
import com.iscobol.rts.FileImage;
import com.iscobol.rts.Functions;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IObjectVar;
import com.iscobol.rts.IPicAlphaEdit;
import com.iscobol.rts.IPicNumEdit;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.ModifyException;
import com.iscobol.rts.Monitor;
import com.iscobol.rts.MonitorFinalize;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.StopRunException;
import com.iscobol.rts.UserHandles;
import com.iscobol.rts.WindowCreateHandler;
import com.iscobol.rts.WrapperException;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import com.iscobol.types.ObjectVar;
import com.iscobol.types.PicX;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class CobolGUIEnvironment
implements Constants,
RuntimeErrorsNumbers {
    public static final boolean NO_FOCUS_MANAGER = true;
    public static final int KEY_UNPROCESSED = 0;
    public static final int KEY_IGNORED = 1;
    public static final int KEY_TERMINATED = 2;
    public static final int INQUIRE_STATUS_OK = 0;
    public static final int INQUIRE_STATUS_INVALID = 1;
    public static final int INQUIRE_STATUS_NOTDISPLAYED = 2;
    public static final int INQUIRE_STATUS_DESTROYED = 3;
    static final int BUFFERED_NONE = 0;
    static final int BUFFERED_ALL = 1;
    static final int BUFFERED_STANDARD_INITIAL = 2;
    static final int BUFFERED_FLOATING = 4;
    static final int BUFFERED_INDEPENDENT = 8;
    static final int BUFFERED_SUBWINDOW = 16;
    static final int BUFFERED_TOOL_BAR = 32;
    static final int BUFFERED_DOCKING = 64;
    static final int BUFFERED_DOCKABLE = 128;
    static final int BUFFERED_MDI_PARENT = 256;
    static final int BUFFERED_MDI_CHILD = 512;
    static final int BUFFERED_NOTIFICATION = 1024;
    private static int activeAcceptCount;
    public int traceLevel;
    private boolean activeAccept;
    private CobolAcceptStack acceptStack = new CobolAcceptStack();
    private LinkedList windowList = new LinkedList();
    private DisplayWindow _globCurrentWindow;
    private DisplayWindow _globActiveWindow;
    private String progName;
    private Monitor[] threadList;
    public static final boolean modality;
    public final boolean labelRtrim = Config.getProperty("iscobol.gui.label.rtrim", true);
    public final boolean isTEMPORARY_CONTROLS = Config.getProperty("iscobol.gui.temporary_controls", false);
    public final int sendtimeout = Config.getProperty("iscobol.gui.cstimeout", 500);
    public final boolean applyWindowColor = Config.getProperty("iscobol.gui.apply_window_color", true);
    public final int sendmaxbuffersize = Config.getProperty("iscobol.gui.csmaxbuffersize", 0x100000);
    public final boolean inputPredisplay = Config.getProperty("iscobol.gui.input_predisplay", "iscobol.gui.from_fields_refreshed_in_accept", false);
    public static final boolean updown_like_prevnext;
    public static final boolean firstlast_on_screen;
    public static final long bufferedwincmd;
    public static final boolean guiimplieddecimal;
    public final ArrayTable serverObjectIds = new ArrayTable();
    private int autoterminatedvalue;
    private int screencolplusbase = -1;
    private boolean pbskipclicked = true;
    private boolean skipclicked = true;
    private SendParamTimer spTimer;
    private Vector windowWait = new Vector();
    private int gui_exclude_events = -1;
    private String gui_event_list;
    private boolean eventlistcontainsMSG_VALIDATE;
    private boolean enableUI = true;
    private boolean nativename;
    private boolean debugnativename;
    private boolean colzerorm;
    private int trayMenuCount;
    private boolean iconfromfilechecked;
    private boolean iconfromfilechipsboxmouseenteredchecked;
    private boolean iconfromfilechipsboxmouseenteredcheckedalreadyloaded;
    private boolean iconfromfilechipsboxmouseexitedchecked;
    private boolean iconfromfilechipsboxmouseexitedcheckedalreadyloaded;
    private boolean nestedembeddedproccheck;
    private boolean executingProc;
    private FactoryData fd;
    private Hashtable<String, String> hotEventProcHT;
    private Hashtable<String, String> hotKeyProcHT;

    public static byte[] saveMem(ICobolVar v) {
        byte[] mem = v.getBytes();
        byte[] Return2 = new byte[mem.length];
        System.arraycopy(mem, 0, Return2, 0, mem.length);
        return Return2;
    }

    public CobolGUIEnvironment() {
        this.initEnviroment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setServerId(Object obj) {
        ArrayTable arrayTable = this.serverObjectIds;
        synchronized (arrayTable) {
            return this.serverObjectIds.put(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getServerId(int oi) {
        ArrayTable arrayTable = this.serverObjectIds;
        synchronized (arrayTable) {
            return this.serverObjectIds.get(oi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delServerId(int oi) {
        ArrayTable arrayTable = this.serverObjectIds;
        synchronized (arrayTable) {
            this.serverObjectIds.remove(oi);
        }
    }

    public void debugId() {
        System.out.println("<Server> debug id start -----");
        for (int i = this.serverObjectIds.length(); i > 0; --i) {
            Object obj = this.serverObjectIds.getObject(i);
            if (obj == null) continue;
            System.out.println("[" + i + "]=" + obj);
        }
        System.out.println("<Server> debug end   -----");
    }

    public void startWaitSendTimer(long hSeconds) {
        if (this.spTimer == null && hSeconds >= 0L) {
            this.spTimer = new SendParamTimer(hSeconds);
            this.spTimer.start();
        }
    }

    public void stopWaitSendTimer() {
        if (this.spTimer != null && !this.spTimer.isInterrupted()) {
            this.spTimer.interrupt();
        }
        this.spTimer = null;
    }

    public void dequeueWindow(BaseGUIWindow bgw) {
        this.dequeueWindow(bgw, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeueWindow(BaseGUIWindow bgw, boolean skipfirstanchor) {
        if (bgw == null) {
            return;
        }
        ScrFactory.flushProperties();
        Vector vector = this.windowWait;
        synchronized (vector) {
            bgw.dequeueParamsSend(true, skipfirstanchor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendParamsToWindow() {
        Vector vector = this.windowWait;
        synchronized (vector) {
            Object[] ctlLI = this.windowWait.toArray();
            BaseGUIWindow bgw = null;
            DisplayWindow dw = null;
            for (int i = 0; i < ctlLI.length; ++i) {
                bgw = (BaseGUIWindow)ctlLI[i];
                if (!(bgw instanceof DisplayWindow) || !((DisplayWindow)bgw).isDestroyed()) {
                    if (bgw instanceof DisplayWindow && ((dw = (DisplayWindow)bgw).isInCriticalRegion() || dw.isOptNew())) continue;
                    bgw.dequeueParamsSend(false);
                    this.windowWait.remove(bgw);
                }
                if (!(bgw instanceof DisplayWindow) || !((DisplayWindow)bgw).isDestroyed()) continue;
                this.windowWait.remove(bgw);
            }
            this.spTimer = null;
            if (this.windowWait.size() > 0) {
                this.startWaitSendTimer(this.sendtimeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueParams(BaseGUIWindow bgw, ParamVector pv) {
        Vector vector = this.windowWait;
        synchronized (vector) {
            bgw.enqueueParams(pv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueParams(BaseGUIWindow bgw) {
        if (this.sendtimeout != 0 || bgw.isOptNew()) {
            Vector vector = this.windowWait;
            synchronized (vector) {
                bgw.enqueueParams(bgw.getParamCSWindow());
                if (bgw instanceof DisplayToolBar) {
                    bgw = ((DisplayToolBar)bgw).getParentWindow();
                }
                if (bgw.getComponent() != null && this.sendmaxbuffersize > 0 && bgw.getQueueSize() > this.sendmaxbuffersize) {
                    bgw.dequeueParamsSend(false);
                } else if (!this.windowWait.contains(bgw)) {
                    this.windowWait.add(bgw);
                    this.startWaitSendTimer(this.sendtimeout);
                }
            }
        } else {
            bgw.sendParams(bgw.getParamCSWindow());
        }
    }

    public void sendParams(BaseGUIWindow bgw, ParamVector pv, boolean stoptimer) {
        this.sendParams(bgw, pv, stoptimer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendParams(BaseGUIWindow bgw, ParamVector pv, boolean stoptimer, boolean skipfirstanchor) {
        if (bgw.getComponent() == null) {
            return;
        }
        Vector vector = this.windowWait;
        synchronized (vector) {
            if (stoptimer) {
                if (this.windowWait.contains(bgw)) {
                    this.windowWait.remove(bgw);
                }
                if (this.windowWait.size() == 0) {
                    this.stopWaitSendTimer();
                }
            }
            if (!(bgw instanceof DisplayWindow) || !((DisplayWindow)bgw).isDestroyed()) {
                if (!bgw.isBufferedWindowType()) {
                    bgw.sendParamsWindow(pv);
                } else {
                    BaseGUIWindow savecurrent = bgw;
                    if (savecurrent != null && savecurrent instanceof SubWindow) {
                        savecurrent.sendParamsWindow(pv);
                        savecurrent = null;
                    }
                    DisplayWindow anchor = null;
                    while (!((anchor = bgw.getParentWnd()) == null || anchor instanceof DisplayWindow && anchor.isDestroyed() || anchor == bgw)) {
                        if (!skipfirstanchor) {
                            this.dequeueWindow(anchor);
                        }
                        skipfirstanchor = false;
                        bgw = anchor;
                    }
                    if (savecurrent != null) {
                        savecurrent.sendParamsWindow(pv);
                    }
                }
            }
        }
    }

    public int isLetterKey(int keyCode) {
        if (keyCode >= 65 && keyCode <= 90) {
            return keyCode + 1 - 65;
        }
        return -1;
    }

    public CobolGUIEnvironment startTimer(CobolVar h_seconds) {
        return this.startTimer((ICobolVar)h_seconds);
    }

    public CobolGUIEnvironment startTimer(ICobolVar h_seconds) {
        DisplayWindow cw = this.getInputWindow();
        cw.setTimeout(h_seconds.tolong());
        return this;
    }

    public CobolGUIEnvironment setAcceptTimeout(ICobolVar h_seconds) {
        long val;
        if (h_seconds != null) {
            val = h_seconds.tolong();
        } else {
            val = Config.getProperty("iscobol.accept_timeout", -1);
            if (val >= 0L) {
                val *= 100L;
            }
        }
        if (val >= 0L) {
            DisplayWindow cw = this.getInputWindow();
            cw.setTimeout(val);
        }
        return this;
    }

    public CobolGUIEnvironment setMouseFlags(CobolVar mouseFlags) {
        return this.setMouseFlags((ICobolVar)mouseFlags);
    }

    public CobolGUIEnvironment setMouseFlags(ICobolVar mouseFlags) {
        DisplayWindow cw = this.getInputWindow();
        cw.setMouseFlags(mouseFlags.toint());
        return this;
    }

    private void setAutoterminatedValue(String name, String values) {
        if (name.equals("kbd_auto_return")) {
            this.autoterminatedvalue = 0;
            try {
                this.autoterminatedvalue = Integer.parseInt(values);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initConfig() {
        Properties p = Config.getAllProperties();
        Enumeration<?> e = p.propertyNames();
        String prefix = Config.getPrefix();
        boolean noprintpreview = true;
        while (e.hasMoreElements()) {
            String v;
            String k = (String)e.nextElement();
            if (k == null || k.length() <= prefix.length() || !k.startsWith(prefix)) continue;
            String skey = k.substring(prefix.length(), k.length());
            if (skey.startsWith("key.") && k.length() > 12) {
                v = (String)p.get(k);
                ScrFactory.s_propertyChange(k, v);
                k = k.substring(12);
                this.setAutoterminatedValue(k, v);
            } else if (skey.startsWith("keyboard.") && k.length() > 17) {
                v = (String)p.get(k);
                ScrFactory.s_propertyChange(k, v);
                k = k.substring(17);
                this.setAutoterminatedValue(k, v);
            } else if (skey.startsWith("message.") && k.length() > 16) {
                v = (String)p.get(k);
                ScrFactory.s_propertyChange(k, v);
            } else if (skey.startsWith("gui.hints_on") || skey.startsWith("hints_on")) {
                v = (String)p.get(k);
                ScrFactory.s_propertyChange(k, v);
            } else if (skey.startsWith("gui.hints_off") || skey.startsWith("hints_off")) {
                v = (String)p.get(k);
                ScrFactory.s_propertyChange(k, v);
            } else if (skey.startsWith("gui.fields_unboxed") || skey.startsWith("fields_unboxed")) {
                v = (String)p.get(k);
                ScrFactory.s_propertyChange(k, v);
            } else if (skey.startsWith("gui.column_separation") || skey.startsWith("column_separation")) {
                v = (String)p.get(k);
                ScrFactory.s_propertyChange(k, v);
            } else if (skey.startsWith("gui.lightweightpopup") || skey.startsWith("lightweightpopup")) {
                v = (String)p.get(k);
                ScrFactory.s_propertyChange(k, v);
            } else if (skey.startsWith("gui.quit_mode") || skey.startsWith("quit_mode")) {
                v = (String)p.get(k);
                ScrFactory.s_propertyChange(k, v);
            } else if (skey.startsWith("gui.icon") || skey.startsWith("icon")) {
                v = (String)p.get(k);
                ScrFactory.s_propertyChange(k, v);
            } else if (skey.startsWith("print.preview.icon")) {
                noprintpreview = false;
                v = (String)p.get(k);
                ScrFactory.s_propertyChange(k, v);
            } else if (skey.startsWith("gui.grid.no_cell_drag")) {
                v = (String)p.get(k);
                ScrFactory.s_propertyChange(k, v);
            } else if (skey.startsWith("gui.native_name")) {
                v = (String)p.get(k);
                if (Config.isTrue(v)) {
                    this.nativename = true;
                }
                if (v != null && v.equals("debug")) {
                    this.debugnativename = true;
                }
            } else if (skey.startsWith("gui.screen_col_zero")) {
                v = (String)p.get(k);
                if (Config.isTrue(v)) {
                    this.colzerorm = true;
                }
                ScrFactory.s_propertyChange(k, v);
            } else if (skey.startsWith("gui.nested_embedded_proc_check") && Config.isTrue(v = (String)p.get(k))) {
                this.nestedembeddedproccheck = true;
            }
            if (skey.startsWith("terminal.paste_key") && k.length() > 19) {
                v = (String)p.get(k);
                ScrFactory.s_propertyChange(k, v);
                continue;
            }
            if (!k.startsWith(prefix)) continue;
            v = (String)p.get(k);
            ScrFactory.s_propertyChange(k, v);
        }
        ScrFactory.setJustifyNumFields(Config.getProperty("iscobol.gui.justify_num_fields", "iscobol.justify_num_fields", false));
        if (noprintpreview) {
            try {
                ScrFactory.setPrintPreviewImage(Config.getProperty("iscobol.print.preview.icon", null));
            }
            catch (IOException _ex) {
                ScreenUtility.handleIOException(_ex);
            }
        }
    }

    private void initScreenColPlusBase() {
        this.screencolplusbase = Config.getProperty("iscobol.gui.screen_col_plus_base", "iscobol.screen_col_plus_base", -1);
    }

    public int getScreenColPlusBase() {
        return this.screencolplusbase;
    }

    private void initPBSkipClicked() {
        this.pbskipclicked = Config.getProperty("iscobol.gui.push_override_focus_change", "iscobol.push_override_focus_change", true);
    }

    private void initSkipClicked() {
        this.skipclicked = Config.getProperty("iscobol.gui.click_override_focus_change", true);
    }

    private void initGuiExcludeEvents() {
        this.gui_exclude_events = Config.getProperty("iscobol.gui.exclude_events", "iscobol.exclude_events", -1);
        this.gui_event_list = Config.getProperty("iscobol.gui.events_list", "iscobol.events_list", null);
        if (this.gui_event_list != null) {
            this.gui_event_list = this.gui_event_list.toUpperCase();
            if (this.gui_event_list.indexOf("MSG-VALIDATE") >= 0 || this.gui_event_list.indexOf(new Integer(16391).toString()) >= 0) {
                this.eventlistcontainsMSG_VALIDATE = true;
            }
        }
    }

    public boolean getPBSkipClicked() {
        return this.pbskipclicked;
    }

    public boolean getSkipClicked() {
        return this.skipclicked;
    }

    private final void initEnviroment() {
        this.initConfig();
        this.initScreenColPlusBase();
        this.initPBSkipClicked();
        this.initSkipClicked();
        this.initGuiExcludeEvents();
        this.initGuiHotKeyOrEventProc();
        Factory.getCurrentMonitor().addObjToFinalize(new MonitorFinalize(){

            @Override
            public void monitorFinalize() {
                CobolGUIEnvironment.this.refreshAll();
            }
        });
        String windowHandleHookName = Config.getProperty("iscobol.gui.window.hook", null);
        if (windowHandleHookName != null && (this.fd = (FactoryData)IscobolSystem.get(FactoryData.class)) != null && this.fd.windowCreateHandler == null) {
            this.fd.createWindowCreateHandler(windowHandleHookName, Config.getProperty(".code_prefix", ""), true);
        }
    }

    private DisplayWindow setThreadActiveWindow(ThreadDependentData tdd, Monitor parentm) {
        DisplayWindow Return2 = null;
        ThreadDependentData tddparent = null;
        if (parentm != null && (tddparent = (ThreadDependentData)parentm.CGEObject) != null) {
            Thread THlastTH = null;
            DisplayWindow lastTH = this.getLastThreadWindow();
            if (lastTH != null) {
                THlastTH = lastTH.getWindowControlThread();
            }
            if (tdd._activeWindow != null && lastTH != null && THlastTH != null && tdd._activeWindow.isIndependent() && tdd._activeWindow != lastTH && !lastTH.isDestroyed() && THlastTH.equals(tdd._activeWindow.getWindowControlThread())) {
                Return2 = lastTH;
                tdd._activeWindow = Return2;
            } else {
                tdd._activeWindow = tddparent._activeWindow;
            }
        }
        if (parentm == null || tddparent == null) {
            tdd._activeWindow = this._globActiveWindow;
            Return2 = null;
        }
        return Return2;
    }

    private final ThreadDependentData getTdd() {
        Monitor m = Factory.getCurrentMonitor();
        ThreadDependentData Return2 = (ThreadDependentData)m.CGEObject;
        if (Return2 == null) {
            Return2 = new ThreadDependentData();
            m.CGEObject = Return2;
            Return2._currentWindow = this._globCurrentWindow;
            this.setThreadActiveWindow(Return2, m.getLastMonitor());
        }
        return Return2;
    }

    public void setActiveAccept(boolean aa) {
        this.activeAccept = aa;
        CobolGUIEnvironment.setAcceptActive(aa);
    }

    public LinkedList getWindowList() {
        return this.windowList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindow(BaseGUIWindow window) {
        LinkedList linkedList = this.windowList;
        synchronized (linkedList) {
            this.windowList.addLast(window);
        }
    }

    private DisplayWindow loadActiveWindow(BaseGUIWindow window, DisplayWindow parentWindow) {
        DisplayWindow Return2 = null;
        if (window == this.getThreadActiveWindow()) {
            Monitor m = Factory.getCurrentMonitor();
            Return2 = this.setThreadActiveWindow(this.getTdd(), m.getLastMonitor());
        }
        return Return2;
    }

    public void removeWindow(BaseGUIWindow window, DisplayWindow parentWindow) {
        this.removeWindow(window, parentWindow, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindow(BaseGUIWindow window, DisplayWindow parentWindow, boolean useparams) {
        LinkedList linkedList = this.windowList;
        synchronized (linkedList) {
            this.windowList.remove(window);
        }
        if (window == this.getCurrentWindow()) {
            this.setCurrentWindow(parentWindow);
        }
        DisplayWindow ret = null;
        if (window == this.getGlobActiveWindow()) {
            if (parentWindow == null || ((DisplayWindow)window).getWindowControlThread() != parentWindow.getWindowControlThread()) {
                if (window.getGuiFactory() != null) {
                    try {
                        window.getGuiFactory().enableKeyboard(((DisplayWindow)window).getTheObjectId());
                    }
                    catch (IOException _ex) {
                        ScreenUtility.handleIOException(_ex);
                    }
                } else {
                    this.acceptStack.enableKeyboard((DisplayWindow)window);
                }
            }
            if ((ret = this.loadActiveWindow(window, parentWindow)) == null) {
                ret = parentWindow;
            }
            this.setActiveWindow(ret, false, null, false, useparams);
            this.setCurrentWindow(ret);
        } else {
            ret = this.loadActiveWindow(window, parentWindow);
            if (ret != null) {
                this.setActiveWindow(ret, false, null, false, useparams);
                this.setCurrentWindow(ret);
            } else if (parentWindow != null && ((DisplayWindow)window).getWindowControlThread() != parentWindow.getWindowControlThread() && window.getGuiFactory() != null) {
                try {
                    window.getGuiFactory().enableKeyboard(((DisplayWindow)window).getTheObjectId());
                }
                catch (IOException _ex) {
                    ScreenUtility.handleIOException(_ex);
                }
            }
        }
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    void setCurrentWindow(DisplayWindow newcurrent) {
        if (newcurrent == null || this.searchWindow(newcurrent) != null) {
            this._globCurrentWindow = this.getTdd()._currentWindow = newcurrent;
        }
    }

    private void setCurrentWindow(DisplayWindow newCurrent, SubWindow newSW) {
        this.setCurrentWindow(newCurrent);
        newCurrent.setCurrentSW(newSW);
    }

    public void setActiveWindow(DisplayWindow newactive) {
        if (this.setActiveWindow(newactive, true, null)) {
            this.refreshAll();
        }
    }

    boolean setActiveWindow(DisplayWindow newactive, boolean check) {
        return this.setActiveWindow(newactive, check, null);
    }

    boolean setActiveWindow(DisplayWindow newactive, boolean check, ParamVector pv) {
        return this.setActiveWindow(newactive, check, pv, false, false);
    }

    boolean setActiveWindow(DisplayWindow newactive, boolean check, ParamVector pv, boolean iscmdactive, boolean useparams) {
        return this.setActiveWindow(newactive, check, pv, iscmdactive, useparams, true);
    }

    boolean setActiveWindow(DisplayWindow newactive, boolean check, ParamVector pv, boolean iscmdactive, boolean useparams, boolean callactive) {
        boolean Return2 = false;
        if (newactive == null) {
            if (this._globActiveWindow != null) {
                this._globActiveWindow.setActiveWindow(false);
                Return2 = true;
            }
            this._globActiveWindow = null;
            this.getTdd()._activeWindow = this._globActiveWindow;
            return Return2;
        }
        DisplayWindow foundw = null;
        foundw = Thread.holdsLock(this.windowWait) ? this.searchWindow(newactive, false) : this.searchWindow(newactive);
        if (foundw != null) {
            DisplayWindow active = this._globActiveWindow;
            if (active != null && active == newactive) {
                if (pv != null) {
                    pv.addElement(new ParamVElement(2008));
                } else {
                    newactive.toFront();
                }
                return false;
            }
            if (active != null && active != newactive) {
                if (!modality && check && active.isModal && active.isVisible() && active != newactive.getParentWnd()) {
                    throw new IscobolRuntimeException(19, ": cannot change the active window.");
                }
                this._globActiveWindow.setActiveWindow(false, false, useparams);
                Return2 = true;
            }
            this._globActiveWindow = newactive;
            if (Thread.currentThread() == this._globActiveWindow.getWindowControlThread()) {
                this.getTdd()._activeWindow = this._globActiveWindow;
            }
            if (useparams) {
                newactive.getParamCSWindow();
            }
            if (callactive) {
                newactive.setActiveWindow(true, iscmdactive);
            }
        }
        return Return2;
    }

    public final DisplayWindow getGlobActiveWindow() {
        DisplayWindow Return2 = this._globActiveWindow;
        return Return2;
    }

    public final DisplayWindow getThreadActiveWindow() {
        return this.getTdd()._activeWindow;
    }

    public final DisplayWindow getCurrentWindow() {
        DisplayWindow Return2 = this.getTdd()._currentWindow;
        if (Return2 != null && Return2.isDestroyed()) {
            Return2 = this.getLastThreadWindow();
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayWindow getLastThreadWindow() {
        DisplayWindow Return2 = null;
        LinkedList linkedList = this.windowList;
        synchronized (linkedList) {
            ListIterator ctlLI = this.windowList.listIterator(this.windowList.size());
            while (Return2 == null && ctlLI.hasPrevious()) {
                DisplayWindow ctl = (DisplayWindow)ctlLI.previous();
                if (ctl == null || ctl.getWindowControlThread() != Thread.currentThread()) continue;
                Return2 = ctl;
            }
        }
        return Return2;
    }

    public DisplayWindow searchWindow(DisplayWindow dw) {
        return this.searchWindow(dw, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayWindow searchWindow(DisplayWindow dw, boolean sync) {
        DisplayWindow Return2 = null;
        boolean found = false;
        if (sync) {
            LinkedList linkedList = this.windowList;
            synchronized (linkedList) {
                ListIterator ctlLI = this.windowList.listIterator(0);
                while (ctlLI.hasNext() && !found) {
                    DisplayWindow ctl = (DisplayWindow)ctlLI.next();
                    if (ctl != dw) continue;
                    found = true;
                }
            }
        } else {
            ListIterator ctlLI = this.windowList.listIterator(0);
            while (ctlLI.hasNext() && !found) {
                DisplayWindow ctl = (DisplayWindow)ctlLI.next();
                if (ctl != dw) continue;
                found = true;
            }
        }
        if (found) {
            Return2 = dw;
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayWindow searchWindow(int bgwid) {
        DisplayWindow Return2 = null;
        boolean found = false;
        LinkedList linkedList = this.windowList;
        synchronized (linkedList) {
            ListIterator ctlLI = this.windowList.listIterator(0);
            while (ctlLI.hasNext() && !found) {
                DisplayWindow ctl = (DisplayWindow)ctlLI.next();
                if (ctl.getTheObjectId() != bgwid) continue;
                Return2 = ctl;
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayWindow searchMainWindow() {
        LinkedList linkedList = this.windowList;
        synchronized (linkedList) {
            ListIterator ctlLI = this.windowList.listIterator(0);
            while (ctlLI.hasNext()) {
                DisplayWindow ctl = (DisplayWindow)ctlLI.next();
                if (!ctl.isMain()) continue;
                return ctl;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyWindowBTT(Thread th) {
        LinkedList linkedList = this.windowList;
        synchronized (linkedList) {
            ListIterator ctlLI = this.windowList.listIterator(0);
            while (ctlLI.hasNext()) {
                DisplayWindow ctl = (DisplayWindow)ctlLI.next();
                if (ctl.getWindowControlThread() != th || !ctl.isBindToThread()) continue;
                this.destroy(ctl);
            }
        }
    }

    public void setCurrentWindow(NumericVar ov) {
        this.setCurrentWindow((INumericVar)ov);
    }

    public void setCurrentWindow(INumericVar ov) {
        if (ov != null && ov.getOId() != null && ov.getOId() instanceof DisplayWindow) {
            this.setCurrentWindow((DisplayWindow)ov.getOId());
        }
    }

    public void setCurrentWindow(CobolVar ov) {
        this.setCurrentWindow((ICobolVar)ov);
    }

    public void setCurrentWindow(ICobolVar ov) {
        int index;
        DisplayWindow bgw;
        if (ov != null && (bgw = (DisplayWindow)UserHandles.getId(index = ov.toint())) != null) {
            this.setCurrentWindow(bgw);
        }
    }

    public void setActiveWindow(NumericVar ov) {
        this.setActiveWindow((INumericVar)ov);
    }

    public void setActiveWindow(INumericVar ov) {
        if (ov != null && ov.getOId() != null && ov.getOId() instanceof DisplayWindow) {
            this.setActiveWindow((DisplayWindow)ov.getOId());
        }
    }

    public void setActiveWindow(CobolVar ov) {
        this.setActiveWindow((ICobolVar)ov);
    }

    public void setActiveWindow(ICobolVar ov) {
        int index;
        DisplayWindow bgw;
        if (ov != null && (bgw = (DisplayWindow)UserHandles.getId(index = ov.toint())) != null) {
            this.setActiveWindow(bgw);
        }
    }

    public final FontCmp getDefaultFont() {
        return FontCmp.getDefaultFont();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCobolRecordAcceptNoWait(CobolRecordAccept status) {
        CobolRecordAccept cobolRecordAccept = status;
        synchronized (cobolRecordAccept) {
            this.acceptStack.push(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int fireCobolRecordAccept(CobolRecordAccept status) {
        DisplayWindow dw = status.getWindow();
        CobolRecordAccept cobolRecordAccept = status;
        synchronized (cobolRecordAccept) {
            this.acceptStack.push(status);
            if (status.getResponse()) {
                try {
                    status.wait();
                }
                catch (InterruptedException _ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (dw != null && dw instanceof DisplayWindow) {
            if (status.getClickOverrideResponseValue() != 0) {
                return status.getClickOverrideResponseValue();
            }
            return dw.getEventActionOfEventStatus();
        }
        return 0;
    }

    public void fireCobolRecordAccept(int type, int ks, int eventId, BaseGUIControl c, boolean termination, boolean exception) {
        this.fireCobolRecordAccept(new CobolRecordAccept(type, ks, eventId, c, termination, exception));
    }

    public int fireCobolRecordAccept(int type, int ks, int eventId, BaseGUIControl c, boolean termination, boolean exception, boolean resp) {
        return this.fireCobolRecordAccept(new CobolRecordAccept(type, ks, eventId, c, termination, exception, resp));
    }

    public void fireCobolRecordAccept(int type, int ks, int eventId, BaseGUIControl c, short data1, int data2, boolean termination, boolean exception) {
        this.fireCobolRecordAccept(new CobolRecordAccept(type, ks, eventId, c, data1, data2, termination, exception));
    }

    public int fireCobolRecordAccept(int type, int ks, int eventId, BaseGUIControl c, short data1, int data2, boolean termination, boolean exception, boolean resp) {
        return this.fireCobolRecordAccept(new CobolRecordAccept(type, ks, eventId, c, data1, data2, termination, exception, resp));
    }

    public void fireCobolRecordAccept(int type, int ks, int eventId, DisplayWindow c, boolean termination, boolean exception) {
        this.fireCobolRecordAccept(new CobolRecordAccept(type, ks, eventId, c, termination, exception));
    }

    public int fireCobolRecordAccept(int type, int ks, int eventId, DisplayWindow c, boolean termination, boolean exception, boolean resp) {
        return this.fireCobolRecordAccept(new CobolRecordAccept(type, ks, eventId, c, termination, exception, resp));
    }

    public void fireCobolRecordAccept(int type, int ks, int eventId, DisplayWindow c, short data1, int data2, boolean termination, boolean exception) {
        this.fireCobolRecordAccept(new CobolRecordAccept(type, ks, eventId, c, data1, data2, termination, exception));
    }

    public synchronized DisplayWindow getOutputWindow() {
        DisplayWindow Return2 = this.searchOutputWindow();
        if (Return2 == null) {
            Return2 = (DisplayWindow)ScrFactory.getGUIDisplayWindow(null, "INITIAL").setTitleBar(true).setWithSystemMenu(true).setAutoResize(true).setAutoMinimize(true).setLines(Config.getProperty("iscobol.gui.scrn_size_rows", 25)).setColumns(Config.getProperty("iscobol.gui.scrn_size_cols", 80));
            Return2.endDisplay();
        }
        return Return2;
    }

    public DisplayWindow searchOutputWindow() {
        DisplayWindow Return2 = this.getCurrentWindow();
        if (Return2 == null || Return2.isDestroyed()) {
            Return2 = this.searchMainWindow();
        }
        return Return2;
    }

    private DisplayWindow getInputWindow() {
        DisplayWindow Return2 = this.getThreadActiveWindow();
        if (Return2 == null || Return2.isDestroyed()) {
            Return2 = this.getGlobActiveWindow();
        }
        if (Return2 == null || Return2.isDestroyed()) {
            Return2 = this.getOutputWindow();
        }
        return Return2;
    }

    public BaseGUIControl display(NumericVar ov, BaseGUIControl cv) {
        return this.display((INumericVar)ov, cv);
    }

    public BaseGUIControl display(INumericVar ov, BaseGUIControl cv) {
        BaseGUIControl Return2 = null;
        if (ov != null) {
            if (ov.getOId() instanceof BaseGUIWindow) {
                BaseGUIWindow go = (BaseGUIWindow)ov.getOId();
                if (go != null) {
                    Return2 = this.display(go, cv);
                } else {
                    Factory.throwInvalidHandle(ov.getName());
                    Return2 = this.display(cv);
                }
            } else if (ov.getOId() != null && ov.getOId() instanceof BaseGUIControl) {
                Return2 = this.display((BaseGUIControl)ov.getOId(), cv);
            } else if (ov.getOId() == null) {
                Factory.throwInvalidHandle(ov.getName());
                Return2 = this.display(cv);
            }
        }
        return Return2;
    }

    public BaseGUIControl display(CobolVar ov, BaseGUIControl cv) {
        return this.display((ICobolVar)ov, cv);
    }

    public BaseGUIControl display(ICobolVar ov, BaseGUIControl cv) {
        BaseGUIControl Return2 = null;
        BaseGUIWindow go = null;
        if (ov != null) {
            int index = ov.toint();
            go = (BaseGUIWindow)UserHandles.getId(index);
        }
        if (go != null) {
            Return2 = this.display(go, cv);
        } else {
            Factory.throwInvalidHandle(ov.getName());
            Return2 = this.display(cv);
        }
        return Return2;
    }

    public BaseGUIControl display(BaseGUIWindow bgw, BaseGUIControl cv) {
        return this.display(bgw, cv, (BaseGUIControl)null);
    }

    public BaseGUIControl display(BaseGUIWindow bgw, BaseGUIControl cv, BaseGUIControl uponCtrl) {
        return this.display(bgw, cv, uponCtrl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIControl display(BaseGUIWindow bgw, BaseGUIControl cv, BaseGUIControl uponCtrl, boolean sendcurrentlc) {
        if (bgw == null && uponCtrl != null) {
            bgw = uponCtrl.getParentBGW();
            if (bgw == null && uponCtrl instanceof CobolGUIScrollPane && uponCtrl.getLastClone() != null) {
                bgw = uponCtrl.getLastClone().getParentWindow();
                uponCtrl = uponCtrl.getLastClone();
            }
            if (cv != null) {
                cv.setTabindex(uponCtrl.getAtY());
            }
            uponCtrl.loadElementAt();
        }
        BaseGUIControl Return2 = cv;
        BaseGUIWindow go = null;
        if (cv != null && cv.getContainsChildCTRL() && (go = cv.getCloneParentBGW()) != null && go != bgw) {
            return cv;
        }
        Vector vector = this.windowWait;
        synchronized (vector) {
            if (cv == null) {
                DisplayWindow dw = (DisplayWindow)bgw;
                ParamVector paramCS = dw.getParamCSWindow();
                DisplayWindow displayWindow = dw;
                synchronized (displayWindow) {
                    Return2 = this.displayOmitted(dw);
                    Return2.setParentWindow(dw);
                    paramCS.add(new ParamElementBoolean(3000, false));
                    Return2.setLoadParams(false);
                    dw.sendParams(paramCS);
                }
            }
            if (bgw instanceof DisplayToolBar) {
                DisplayToolBar dtb;
                DisplayToolBar paramCS = dtb = (DisplayToolBar)bgw;
                synchronized (paramCS) {
                    if (uponCtrl != null) {
                        if (cv != null) {
                            cv.setTabindex(uponCtrl.getAtY());
                        }
                        uponCtrl.loadElementAt();
                        ParamVector paramCS2 = dtb.getParentWindow().getParamCSWindow();
                        paramCS2.addElement(new ParamElementVector(1026, uponCtrl.getControlPeerServerId(), uponCtrl.getParamCS()));
                    }
                    Return2 = dtb.display(dtb.getParentWindow(), cv, uponCtrl, sendcurrentlc);
                    if (this.sendtimeout == 0) {
                        dtb.getParentWindow().sendParams(dtb.getParentWindow().getParamCSWindow());
                    }
                }
            }
            if (bgw instanceof DisplayWindow) {
                DisplayWindow dw = (DisplayWindow)bgw;
                BaseGUIControl bgc = null;
                boolean senddisplay = true;
                int idxcloni = 0;
                DisplayWindow displayWindow = dw;
                synchronized (displayWindow) {
                    ParamVector paramCS = dw.getParamCSWindow();
                    ParamVector paramCScloni = new ParamVector(IscobolSystem.isAS());
                    dw.setCreateOnlyTD(!cv.getContainsChildCTRL());
                    if (!cv.isClone() || cv instanceof CobolGUITerminalAccept) {
                        Return2 = dw.loadClone(cv, null, paramCScloni, !cv.getContainsChildCTRL());
                        idxcloni = paramCS.size();
                    }
                    Return2.setOperationTime(2);
                    if (sendcurrentlc) {
                        dw.setCurrentLC(Return2, paramCS);
                    }
                    if (uponCtrl != null) {
                        if (cv != null && uponCtrl.getAtY() >= 0) {
                            cv.setTabindex(uponCtrl.getAtY());
                        }
                        uponCtrl.loadElementAt();
                        paramCS.addElement(new ParamElementVector(1026, uponCtrl.getControlPeerServerId(), uponCtrl.getParamCS()));
                    }
                    boolean sendresettabprop = false;
                    boolean sendresetscrollprop = false;
                    if (uponCtrl != null && !Return2.hasTabProperty()) {
                        sendresettabprop = true;
                    }
                    if (uponCtrl != null && !Return2.hasScrollProperty()) {
                        sendresetscrollprop = true;
                    }
                    dw.display(Return2, null, paramCS, true, true, uponCtrl);
                    if (sendresettabprop) {
                        Return2.sendTabProperty(paramCS, uponCtrl.getControlPeerServerId(), 0);
                    }
                    if (sendresetscrollprop) {
                        Return2.sendScrollPaneProperty(paramCS, uponCtrl.getControlPeerServerId());
                    }
                    dw.setCreateOnlyTD(false);
                    if (!cv.getContainsChildCTRL()) {
                        cv.setRelocAtLine(0.0f);
                        cv.setRelocAtColumn(0.0f);
                    }
                    if (Return2.getContainsChildCTRL() && (bgc = Return2.getFirstDifferPrecDispl()) != Return2) {
                        if (bgc == null) {
                            senddisplay = false;
                        } else {
                            bgc = Return2;
                        }
                    }
                    if (senddisplay) {
                        paramCS.add(new ParamElementBoolean(3000, true));
                        if (Return2.getContainsChildJB()) {
                            dw.sendParams(paramCS);
                        } else if (Return2.getErase() > 0 || Return2.getComponentType() == 0) {
                            this.enqueueParams(dw);
                        } else {
                            this.enqueueParams(dw);
                        }
                    } else {
                        Enumeration params = paramCS.elements();
                        ParamVElement pe = null;
                        if (idxcloni > 0) {
                            while (idxcloni > 0 && params.hasMoreElements()) {
                                pe = (ParamVElement)params.nextElement();
                                paramCScloni.addFirst(pe);
                                --idxcloni;
                            }
                            while (params.hasMoreElements()) {
                                pe = (ParamVElement)params.nextElement();
                                paramCScloni.add(pe);
                            }
                        } else if (paramCS.size() > 0) {
                            this.enqueueParams(dw, paramCS);
                        }
                        this.enqueueParams(dw, paramCScloni);
                        dw.getParamCSWindow().removeAllElements();
                    }
                    if (dw != null) {
                        dw.removeServerObjectO(Return2);
                        this.enqueueParams(dw);
                    }
                }
            }
        }
        return Return2;
    }

    public BaseGUIControl display(BaseGUIControl container, BaseGUIControl child) {
        DisplayWindow bgw = null;
        if (container != null) {
            bgw = container.getParentWindow();
        }
        if (bgw == null && container instanceof CobolGUIScrollPane && container.getLastClone() != null) {
            bgw = container.getLastClone().getParentWindow();
            container = container.getLastClone();
        }
        if (container != null && container.getParentWindow() != null) {
            container.addComponentToContainer(child);
        }
        return container;
    }

    public BaseGUIControl displayOmitted(DisplayWindow dw) {
        BaseGUIControl displayOmittedField = ScrFactory.getGUITerminalDisplay("OMITTED", (CobolVar)null);
        try {
            displayOmittedField.setLoadParams(true);
            displayOmittedField.buildRemoteObject(displayOmittedField, dw);
            displayOmittedField.controlPeerinitialize();
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        displayOmittedField.setSize(1.6f, 1.0f);
        displayOmittedField.setLocation(20.0f, 40.0f);
        return displayOmittedField;
    }

    public synchronized BaseGUIControl display(BaseGUIControl cv) {
        return this.display(cv, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized BaseGUIControl display(BaseGUIControl cv, boolean sendcurrentlc) {
        if (!this.enableUI) {
            return NullControl.getInstance();
        }
        BaseGUIControl Return2 = null;
        BaseGUIWindow go = null;
        if (cv == null || !cv.getContainsChildCTRL() || (go = cv.getCloneParentBGW()) == null) {
            go = this.getOutputWindow();
        }
        DisplayWindow displayWindow = go;
        synchronized (displayWindow) {
            if (!(go == null || go instanceof DisplayWindow && ((DisplayWindow)go).isDestroyed())) {
                Return2 = this.display(go, cv, null, sendcurrentlc);
            }
        }
        if (Return2 == null) {
            return NullControl.getInstance();
        }
        return Return2;
    }

    public BaseGUIControl display(BaseGUIControl bgc, CobolVar hndl) {
        return this.display((BaseGUIWindow)null, bgc, (ICobolVar)hndl);
    }

    public BaseGUIControl display(BaseGUIWindow bgw, BaseGUIControl bgc, CobolVar hndl) {
        return this.display(bgw, bgc, (ICobolVar)hndl);
    }

    public BaseGUIControl display(BaseGUIControl bgc, ICobolVar hndl) {
        return this.display((BaseGUIWindow)null, bgc, hndl);
    }

    public BaseGUIControl display(BaseGUIWindow bgw, BaseGUIControl bgc, ICobolVar hndl) {
        BaseGUIWindow go = this.getWindowByHandle(hndl);
        BaseGUIWindow gocloneparent = null;
        BaseGUIControl Return2 = null;
        if (go != null) {
            SubWindow goSW;
            DisplayWindow goWnd;
            if (bgc != null && bgc.getContainsChildCTRL() && (gocloneparent = bgc.getCloneParentBGW()) != null && go != gocloneparent) {
                return bgc;
            }
            if (go instanceof DisplayToolBar) {
                DisplayToolBar dtb = (DisplayToolBar)go;
                Return2 = dtb.display(dtb.getParentWindow(), bgc);
            } else if (go instanceof DisplayWindow) {
                DisplayWindow goWnd2 = (DisplayWindow)go;
                if (this.searchWindow(goWnd2) != null) {
                    DisplayWindow save = this.getCurrentWindow();
                    SubWindow saveSW = save.getCurrentSW();
                    this.setCurrentWindow(goWnd2, null);
                    Return2 = this.display(goWnd2, bgc);
                    this.setCurrentWindow(save, saveSW);
                }
            } else if (go instanceof SubWindow && this.searchWindow(goWnd = (goSW = (SubWindow)go).getParentWnd()) != null) {
                DisplayWindow save = this.getCurrentWindow();
                SubWindow saveSW = save.getCurrentSW();
                this.setCurrentWindow(goWnd, goSW);
                Return2 = this.display(goWnd, bgc);
                this.setCurrentWindow(save, saveSW);
            }
        } else {
            Factory.throwInvalidHandle(hndl != null ? hndl.getName() : "");
            Return2 = this.display(bgc);
        }
        return Return2;
    }

    public BaseGUIControl modifyControl(NumericVar cv) {
        return this.modifyControl((INumericVar)cv);
    }

    public BaseGUIControl modifyControl(INumericVar cv) {
        if (!this.enableUI) {
            return NullControl.getInstance();
        }
        BaseGUIControl bgc = null;
        if (cv != null && cv instanceof IObjectVar && cv.getOId() != null && cv.getOId() instanceof BaseGUIControl) {
            bgc = (BaseGUIControl)cv.getOId();
        }
        if (bgc == null || bgc.getLastClone() != null && bgc.getLastClone().isDestroyed()) {
            Factory.throwInvalidHandle(cv.getName());
            return NullControl.getInstance();
        }
        return this.modifyControl(bgc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIControl modifyControl(BaseGUIControl bgc) {
        if (!this.enableUI) {
            return NullControl.getInstance();
        }
        if (bgc == null) {
            Factory.throwInvalidHandle("");
            return NullControl.getInstance();
        }
        BaseGUIControl Return2 = null;
        Return2 = CobolGUIEnvironment.getLastClone(bgc);
        DisplayWindow dw = (DisplayWindow)Return2.getParentBGW();
        if (dw != null && !dw.isDestroyed()) {
            try {
                Return2.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ScrFactory.flushProperties();
            Vector vector = this.windowWait;
            synchronized (vector) {
                dw.setInCriticalRegion(true);
                Return2.initializeAtRun(false);
                Return2.setOperationTime(8);
                Return2.setLoadParams(true);
                Return2.loadElementAt();
            }
        }
        return Return2;
    }

    public BaseGUIWindow modifyWindow(NumericVar cv) {
        return this.modifyWindow((INumericVar)cv);
    }

    public BaseGUIWindow modifyWindow(INumericVar cv) {
        return this.modifyWindow(cv, false);
    }

    public BaseGUIWindow modifyWindow(NumericVar cv, boolean onExc) {
        return this.modifyWindow((INumericVar)cv, onExc);
    }

    public BaseGUIWindow modifyWindow(INumericVar cv, boolean onExc) {
        if (!this.enableUI) {
            return NullWindow.getInstance();
        }
        BaseGUIWindow Return2 = null;
        if (cv != null && cv instanceof IObjectVar && cv.getOId() != null && cv.getOId() instanceof BaseGUIWindow) {
            Return2 = (BaseGUIWindow)cv.getOId();
        }
        if (Return2 == null || Return2 instanceof DisplayWindow && ((DisplayWindow)Return2).isDestroyed()) {
            Factory.throwInvalidHandle(cv.getName());
            if (onExc) {
                throw new ModifyException();
            }
            return NullWindow.getInstance();
        }
        ScrFactory.flushProperties();
        return Return2;
    }

    public BaseGUIWindow modifyWindow(CobolVar cv) {
        return this.modifyWindow((ICobolVar)cv);
    }

    public BaseGUIWindow modifyWindow(ICobolVar cv) {
        return this.modifyWindow(cv, false);
    }

    public BaseGUIWindow modifyWindow(CobolVar cv, boolean onExc) {
        return this.modifyWindow((ICobolVar)cv, onExc);
    }

    public BaseGUIWindow modifyWindow(ICobolVar cv, boolean onExc) {
        if (!this.enableUI) {
            return NullWindow.getInstance();
        }
        BaseGUIWindow Return2 = null;
        if (cv != null) {
            int index = cv.toint();
            Return2 = (BaseGUIWindow)UserHandles.getId(index);
        }
        if (Return2 == null) {
            Factory.throwInvalidHandle(cv.getName());
            if (onExc) {
                throw new ModifyException();
            }
            return NullWindow.getInstance();
        }
        ScrFactory.flushProperties();
        return Return2;
    }

    public BaseGUIWindow modifyWindow() {
        if (!this.enableUI) {
            return NullWindow.getInstance();
        }
        DisplayWindow Return2 = this.getCurrentWindow();
        if (Return2 == null) {
            Factory.throwInvalidHandle("");
            return NullWindow.getInstance();
        }
        ScrFactory.flushProperties();
        return Return2;
    }

    private static Object getObjByHandle(ICobolVar handle, Class clazz, ICobolVar status) {
        Object Return2;
        if (handle == null) {
            if (status != null) {
                status.set(1);
            } else {
                Factory.throwInvalidHandle("(null)");
            }
            Return2 = null;
        } else {
            Object obj = UserHandles.getId(handle.toint());
            if (obj == null || !clazz.isInstance(obj)) {
                if (status != null) {
                    status.set(1);
                } else {
                    Factory.throwInvalidHandle(handle.getName());
                }
                Return2 = null;
            } else {
                if (status != null) {
                    status.set(0);
                }
                Return2 = obj;
            }
        }
        return Return2;
    }

    private static boolean canInquire(BaseGUIControl bgc, ICobolVar status) {
        BaseGUIControl lClone;
        BaseGUIControl baseGUIControl = bgc.getIsControlEditor() ? bgc : (lClone = bgc.isClone() ? bgc : bgc.getLastClone());
        int myStatus = lClone == null ? 2 : (lClone.isDestroyed() ? 3 : 0);
        if (status != null) {
            status.set(myStatus);
        }
        if (myStatus != 0) {
            if (status == null) {
                Factory.throwInvalidHandle(bgc.getName());
            }
            return false;
        }
        return true;
    }

    public BaseGUIControl inquireControl(NumericVar cv) {
        return this.inquireControl((INumericVar)cv);
    }

    public BaseGUIControl inquireControl(INumericVar cv, ICobolVar status) {
        if (!this.enableUI) {
            return NullControl.getInstance();
        }
        BaseGUIControl bgc = (BaseGUIControl)CobolGUIEnvironment.getObjByHandle(cv, BaseGUIControl.class, status);
        if (bgc == null) {
            return NullControl.getInstance();
        }
        if (!CobolGUIEnvironment.canInquire(bgc, status)) {
            return NullControl.getInstance();
        }
        BaseGUIControl Return2 = CobolGUIEnvironment.getLastClone(bgc);
        try {
            Return2.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Return2.setOperationTime(4);
        if (Return2.isDestroyed()) {
            Return2.release();
            if (status != null) {
                status.set(3);
            } else {
                Factory.throwInvalidHandle(cv.getName());
            }
            return NullControl.getInstance();
        }
        return Return2;
    }

    public BaseGUIControl inquireControl(INumericVar cv) {
        return this.inquireControl(cv, null);
    }

    public BaseGUIControl inquireControl(BaseGUIControl bgc, ICobolVar status) {
        if (!this.enableUI) {
            return NullControl.getInstance();
        }
        if (bgc == null) {
            Factory.throwInvalidHandle("");
            return NullControl.getInstance();
        }
        if (!CobolGUIEnvironment.canInquire(bgc, status)) {
            return NullControl.getInstance();
        }
        BaseGUIControl Return2 = CobolGUIEnvironment.getLastClone(bgc);
        try {
            Return2.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Return2.setOperationTime(4);
        if (Return2.isDestroyed()) {
            Return2.release();
            if (status != null) {
                status.set(3);
            }
            return NullControl.getInstance();
        }
        return Return2;
    }

    public BaseGUIControl inquireControl(BaseGUIControl bgc) {
        return this.inquireControl(bgc, null);
    }

    public BaseGUIWindow inquireWindow(NumericVar cv) {
        return this.inquireWindow((INumericVar)cv);
    }

    public BaseGUIWindow inquireWindow(ICobolVar cv, ICobolVar status) {
        if (!this.enableUI) {
            return NullWindow.getInstance();
        }
        BaseGUIWindow Return2 = (BaseGUIWindow)CobolGUIEnvironment.getObjByHandle(cv, BaseGUIWindow.class, status);
        if (Return2 == null) {
            return NullWindow.getInstance();
        }
        if (Return2 instanceof DisplayWindow && ((DisplayWindow)Return2).isDestroyed()) {
            if (status != null) {
                status.set(3);
            } else {
                Factory.throwInvalidHandle(cv.getName());
            }
            return NullWindow.getInstance();
        }
        if (status != null) {
            status.set(0);
        }
        if (!Return2.isBufferedWindowType()) {
            ScrFactory.flushProperties();
        } else {
            this.dequeueWindow(Return2);
        }
        return Return2;
    }

    public BaseGUIWindow inquireWindow(INumericVar cv) {
        return this.inquireWindow(cv, null);
    }

    public BaseGUIWindow inquireWindow(CobolVar cv) {
        return this.inquireWindow((ICobolVar)cv);
    }

    public BaseGUIWindow inquireWindow(ICobolVar cv) {
        return this.inquireWindow(cv, null);
    }

    public BaseGUIWindow inquireWindowStatus(ICobolVar status) {
        if (!this.enableUI) {
            return NullWindow.getInstance();
        }
        DisplayWindow Return2 = this.getCurrentWindow();
        if (Return2 == null) {
            if (status != null) {
                status.set(2);
            } else {
                Factory.throwInvalidHandle("");
            }
            return NullWindow.getInstance();
        }
        if (status != null) {
            status.set(0);
        }
        if (!Return2.isBufferedWindowType()) {
            ScrFactory.flushProperties();
        } else {
            this.dequeueWindow(Return2);
        }
        return Return2;
    }

    public BaseGUIWindow inquireWindow() {
        return this.inquireWindowStatus(null);
    }

    private void predisplay(DisplayWindow dw, BaseGUIControl bgc) {
        if (bgc.isInputField() && bgc.hasUsing()) {
            this.display((BaseGUIWindow)dw, bgc, (BaseGUIControl)null);
        } else {
            LocLinkedList children = bgc.getChildGraphics();
            if (children != null) {
                int size = children.size();
                for (int i = 0; i < size; ++i) {
                    this.predisplay(dw, (BaseGUIControl)children.elementAt(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CobolRecordAccept internalAccept(ICobolVar ks, ICobolVar sC, ICobolVar eS, ICobolVar crsSN, ICobolVar crsAccept, BeanContainer beanCtn, DisplayWindow dw, BaseGUIControl cv, boolean onException, boolean omitted, boolean disableEmbProc, ParamVector param, CobolRecordAccept cra, CobolRecordAccept craHotkeyReturn) {
        boolean[] allProtected = new boolean[2];
        boolean sendp = false;
        ICobolVar crs = crsAccept != null ? crsAccept : crsSN;
        allProtected[0] = false;
        allProtected[1] = false;
        CobolRecordAccept Return2 = null;
        BaseGUIControl bgc = null;
        String savehotkeyretvalue = null;
        if (craHotkeyReturn != null && craHotkeyReturn.getControl() != null) {
            savehotkeyretvalue = craHotkeyReturn.getControl().strValue;
        }
        if (dw != null && !dw.isVisible()) {
            if (dw.getTimeout() > 0L) {
                try {
                    Thread.sleep(dw.getTimeout() * 10L);
                    return new CobolRecordAccept(19, -1, 90000, dw, null, 0, 0, false, false, false);
                }
                catch (InterruptedException ex) {
                    throw new IscobolRuntimeException(37, dw.getTitle());
                }
            }
            if (this.trayMenuCount == 0) {
                throw new IscobolRuntimeException(37, dw.getTitle());
            }
        }
        if (this.nestedembeddedproccheck && this.getTdd()._execAcceptStatement && this.getTdd()._execEmbeddedProc) {
            throw new IscobolRuntimeException(39, "");
        }
        this.getTdd()._execAcceptStatement = true;
        if (omitted) {
            Return2 = this.pop(dw, onException, omitted);
        } else {
            bgc = cv;
            DisplayWindow ex = dw;
            synchronized (ex) {
                if (param == null) {
                    param = new ParamVector(IscobolSystem.isAS());
                }
                if (cra == null) {
                    if (!bgc.getContainsChildCTRL()) {
                        sendp = true;
                        bgc.setOperationTime(2);
                        dw.setCurrentLC(bgc, param);
                        dw.display(bgc, null, param, false, true, null);
                        param.add(new ParamElementBoolean(3000, true));
                    } else {
                        if (bgc.getContainsChildTES() || bgc.getContainsChildTE()) {
                            bgc.setOperationTime(2);
                            dw.setCurrentLC(bgc, param);
                            dw.display(bgc, null, param, false, true, null);
                            param.add(new ParamElementBoolean(3000, true));
                        } else if (this.inputPredisplay) {
                            this.predisplay(dw, bgc);
                        }
                        dw.setParentWindowAndAdd(bgc, param);
                    }
                    if (crs != null && craHotkeyReturn == null) {
                        dw.setFirstControlCursor(null);
                        sendp = true;
                        try {
                            int val = Integer.parseInt(crs.toString());
                            if (crsAccept != null) {
                                int ln = (int)bgc.getAtLine();
                                int cn = (int)bgc.getAtColumn();
                                ln = (int)((float)ln + (bgc.getParentSW() != null && bgc.getParentSW().getAtLine() > 0.0f ? bgc.getParentSW().getAtLine() - 1.0f : 0.0f));
                                cn = (int)((float)cn + (bgc.getParentSW() != null && bgc.getParentSW().getAtColumn() > 0.0f ? bgc.getParentSW().getAtColumn() - 1.0f : 0.0f));
                                val += ln << 16;
                                val += cn - 1;
                            } else {
                                val = crs.length() < 6 ? val / 100 << 16 | val % 100 : val / 1000 << 16 | val % 1000;
                            }
                            this.loadProtectedWithColorFields(dw, bgc, crs, param, onException);
                            param.add(new ParamElementInt(2044, val));
                            int[] arrayid = new int[]{bgc.getControlPeerType() == 0 ? bgc.getControlPeerServerIdHG() : bgc.getControlPeerServerId()};
                            param.add(new ParamElementIntArrayInt(2066, val, arrayid));
                        }
                        catch (NumberFormatException val) {}
                    }
                } else if (crs != null && craHotkeyReturn == null) {
                    dw.setFirstControlCursor(null);
                }
                if (sendp && crs != null) {
                    dw.sendParams(param);
                }
                bgc.setOperationTime(1);
                if (cra != null || crs == null || craHotkeyReturn != null) {
                    this.loadProtectedWithColorFields(dw, bgc, crs, param, onException);
                }
                if (craHotkeyReturn == null) {
                    dw.setScreenCntrlVal(bgc, 0);
                    if (crsAccept != null || bgc.getComponentType() != 0) {
                        dw.setFirstControlCursor(null);
                    }
                    dw.setFirstControl(sC, bgc, allProtected);
                }
            }
            BaseGUIControl bgcfirst = null;
            if (dw.type != 11 && (bgcfirst = dw.getFirstControl()) != null && (!allProtected[0] || bgcfirst.isOkForInput())) {
                DisplayWindow val = dw;
                synchronized (val) {
                    dw.accept(bgc, param, ks, sC, eS, beanCtn);
                    param.add(new ParamVElement(3001));
                }
                if (!(disableEmbProc || !bgcfirst.hasBeforeProc() || dw.isBufferedWindowType() && param == dw.getParamCSWindow())) {
                    dw.sendParams(param);
                    param = new ParamVector();
                }
                if (craHotkeyReturn == null) {
                    Return2 = dw.manageBeforeEvent(ks, sC, eS, beanCtn, onException, disableEmbProc, bgc, param, cra);
                } else if (dw.isBufferedWindowType() && !disableEmbProc && bgcfirst.hasBeforeProc()) {
                    dw.sendParams(param);
                    param = new ParamVector();
                }
                if (Return2 == null) {
                    if (craHotkeyReturn == null) {
                        if (crs != null && !disableEmbProc && bgcfirst.hasBeforeProc()) {
                            ParamVector paramCS = dw.getParamCSWindow();
                            paramCS.addElement(new ParamVElement(2057));
                            if (!dw.isDestroyed()) {
                                dw.sendParamsWindow(paramCS);
                            }
                        }
                    } else {
                        dw.sendParams(param);
                        BaseGUIControl bgchk = null;
                        bgchk = bgc != null && bgc instanceof CobolGUITerminalAccept && ((CobolGUITerminalAccept)bgc).getOriginalCV() != null ? bgc : craHotkeyReturn.getControl();
                        bgchk.setValue(savehotkeyretvalue);
                        dw.requestFocus(bgchk);
                    }
                    Return2 = this.pop(dw, onException, false, param);
                    if (crs != null) {
                        int cfecurs = -1;
                        ChangeFocusEvent cfe = null;
                        if (Return2 instanceof ChangeFocusEvent) {
                            cfe = (ChangeFocusEvent)Return2;
                            cfecurs = cfe.getCursor();
                        } else if (Return2.getWindow() != null) {
                            cfecurs = Return2.getWindow().getCursorValue();
                        }
                        if (crsAccept != null) {
                            cfecurs = this.getAcceptCursorValue(bgc, cfecurs, cfe);
                        }
                        this.setCursorVar(crsSN, crsAccept, cfecurs);
                    }
                } else if (param != null && !dw.isDestroyed()) {
                    dw.sendParams(param);
                }
            } else {
                Return2 = new CobolRecordAccept(4, 97, 0, dw, true, true);
            }
            Return2.setAcceptBGC(bgc);
        }
        return Return2;
    }

    public CobolGUIEnvironment setThread(NumericVar handle, boolean last) {
        return this.setThread((INumericVar)handle, last);
    }

    public CobolGUIEnvironment setThread(INumericVar handle, boolean last) {
        if (handle != null) {
            Monitor m = Factory.getMonitorById(handle.toint());
            if (m != null) {
                try {
                    this.threadList = new Monitor[]{Factory.getMonitorById(handle.toint())};
                }
                catch (ClassCastException e) {
                    throw new IscobolRuntimeException(9, handle.getName());
                }
            }
        } else if (last) {
            Monitor lm = Factory.getLastThread();
            if (lm != null) {
                this.threadList = new Monitor[]{lm};
            }
        } else {
            Object[] list = Factory.getMonitors();
            this.threadList = new Monitor[list.length];
            for (int i = 0; i < list.length; ++i) {
                this.threadList[i] = (Monitor)list[i];
            }
        }
        return this;
    }

    public CobolRecordAccept accept(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, BaseGUIControl cv, boolean onException, INumericVar controlKey, CobolRecordAccept cra, boolean disableEmbProc) {
        return this.accept(ks, sC, eS, beanCtn, (ICobolVar)null, cv, onException, controlKey, cra, disableEmbProc);
    }

    public CobolRecordAccept accept(CobolVar ks, CobolVar sC, CobolVar eS, BeanContainer beanCtn, BaseGUIControl cv, boolean onException, NumericVar controlKey, CobolRecordAccept cra, boolean disableEmbProc) {
        return this.accept((ICobolVar)ks, (ICobolVar)sC, (ICobolVar)eS, beanCtn, (ICobolVar)null, cv, onException, (INumericVar)controlKey, cra, disableEmbProc);
    }

    public CobolRecordAccept accept(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, BaseGUIControl cv, boolean onException, ICobolVar controlKey, CobolRecordAccept cra, boolean disableEmbProc) {
        return this.accept(ks, sC, eS, beanCtn, (ICobolVar)null, cv, onException, controlKey, cra, disableEmbProc);
    }

    public CobolRecordAccept accept(CobolVar ks, CobolVar sC, CobolVar eS, BeanContainer beanCtn, BaseGUIControl cv, boolean onException, CobolVar controlKey, CobolRecordAccept cra, boolean disableEmbProc) {
        return this.accept((ICobolVar)ks, (ICobolVar)sC, (ICobolVar)eS, beanCtn, (ICobolVar)null, cv, onException, (ICobolVar)controlKey, cra, disableEmbProc);
    }

    public CobolRecordAccept accept(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, ICobolVar crsSN, BaseGUIControl cv, boolean onException, INumericVar controlKey, CobolRecordAccept cra, boolean disableEmbProc) {
        return this.accept(ks, sC, eS, beanCtn, crsSN, cv, onException, (ICobolVar)controlKey, cra, disableEmbProc);
    }

    public CobolRecordAccept accept(CobolVar ks, CobolVar sC, CobolVar eS, BeanContainer beanCtn, CobolVar crsSN, BaseGUIControl cv, boolean onException, NumericVar controlKey, CobolRecordAccept cra, boolean disableEmbProc) {
        return this.accept((ICobolVar)ks, (ICobolVar)sC, (ICobolVar)eS, beanCtn, (ICobolVar)crsSN, cv, onException, (ICobolVar)controlKey, cra, disableEmbProc);
    }

    public CobolRecordAccept accept(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, ICobolVar crsSN, BaseGUIControl cv, boolean onException, INumericVar controlKey, CobolRecordAccept cra, boolean disableEmbProc, ICobolVar crsAccept) {
        return this.accept(ks, sC, eS, beanCtn, crsSN, cv, onException, (ICobolVar)controlKey, cra, disableEmbProc, crsAccept);
    }

    public CobolRecordAccept accept(CobolVar ks, CobolVar sC, CobolVar eS, BeanContainer beanCtn, CobolVar crsSN, BaseGUIControl cv, boolean onException, NumericVar controlKey, CobolRecordAccept cra, boolean disableEmbProc, CobolVar crsAccept) {
        return this.accept((ICobolVar)ks, (ICobolVar)sC, (ICobolVar)eS, beanCtn, (ICobolVar)crsSN, cv, onException, (ICobolVar)controlKey, cra, disableEmbProc, (ICobolVar)crsAccept);
    }

    public CobolRecordAccept accept(CobolVar ks, CobolVar sC, CobolVar eS, BeanContainer beanCtn, CobolVar crsSN, BaseGUIControl cv, boolean onException, CobolVar controlKey, CobolRecordAccept cra, boolean disableEmbProc) {
        return this.accept((ICobolVar)ks, (ICobolVar)sC, (ICobolVar)eS, beanCtn, (ICobolVar)crsSN, cv, onException, (ICobolVar)controlKey, cra, disableEmbProc);
    }

    public CobolRecordAccept accept(CobolVar ks, CobolVar sC, CobolVar eS, BeanContainer beanCtn, CobolVar crsSN, BaseGUIControl cv, boolean onException, CobolVar controlKey, CobolRecordAccept cra, boolean disableEmbProc, CobolVar crsAccept) {
        return this.accept((ICobolVar)ks, (ICobolVar)sC, (ICobolVar)eS, beanCtn, (ICobolVar)crsSN, cv, onException, (ICobolVar)controlKey, cra, disableEmbProc, (ICobolVar)crsAccept);
    }

    public CobolRecordAccept accept(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, ICobolVar crsSN, BaseGUIControl cv, boolean onException, ICobolVar controlKey, CobolRecordAccept cra, boolean disableEmbProc) {
        return this.accept(ks, sC, eS, beanCtn, crsSN, cv, onException, controlKey, cra, disableEmbProc, (ICobolVar)null);
    }

    public CobolRecordAccept accept(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, ICobolVar crsSN, BaseGUIControl cv, boolean onException, ICobolVar controlKey, CobolRecordAccept cra, boolean disableEmbProc, ICobolVar crsAccept) {
        BaseGUIControl c;
        DisplayWindow go;
        this.setActiveAccept(true);
        CobolRecordAccept Return2 = null;
        CobolRecordAccept craHotkeyReturn = null;
        if (cra != null && cra.getRecordType() == 26) {
            craHotkeyReturn = cra;
            cra = null;
        }
        Monitor m = Factory.getCurrentMonitor();
        if (this.threadList != null) {
            for (int i = 0; i < this.threadList.length; ++i) {
                if (this.threadList[i] == null) continue;
                this.threadList[i].setCas(this.acceptStack, m);
            }
        }
        ParamVector paramCS = null;
        ScrFactory.flushProperties();
        if (cv != null && !(cv instanceof NullControl)) {
            go = (DisplayWindow)cv.getCloneParentBGW();
            if (go != null) {
                paramCS = go.getParamCSWindow();
                if (this.getGlobActiveWindow() != null && Thread.currentThread() == this.getGlobActiveWindow().getWindowControlThread()) {
                    boolean skip = false;
                    if (cra != null && (cra.getEventType() == 17023 || cra.getEventType() == 17024)) {
                        skip = true;
                    }
                    if (!skip) {
                        if (go != this.getGlobActiveWindow()) {
                            this.setActiveWindow(go, true, paramCS);
                        } else if (cra != null) {
                            paramCS.addElement(new ParamVElement(2008));
                        }
                    }
                }
            } else {
                go = this.getInputWindow();
            }
        } else {
            go = this.getInputWindow();
        }
        if (go != null && go.isDestroyed()) {
            CobolRecordAccept crad = new CobolRecordAccept(25, 91, 0, (DisplayWindow)null, 0, -1, true, true);
            this.setActiveAccept(false);
            return crad;
        }
        if (go != null && go.getMassUpdate()) {
            Return2 = new CobolRecordAccept(4, 97, 0, go, true, true);
            return Return2;
        }
        this.setCurrentWindow(go);
        go.setWindowControlThread(Thread.currentThread());
        go.setCasdestroy(this.acceptStack);
        go.setAllData(null);
        go.setActiveAccept(true);
        if (paramCS == null) {
            paramCS = go.getParamCSWindow();
        }
        if (cra == null) {
            go.resetScreenEnv(paramCS);
            int mf = go.getMouseFlags();
            if (mf < 0) {
                mf = 0;
            }
            paramCS.addElement(new ParamElementIntBoolean(2049, mf, true));
            go.setMouseFlags(-1);
            ScrFactory.setLastMouseStatus(null);
        } else if (cv == null || !cv.isClone() && (c = cra.getAcceptBGC()) != null && (c.isTerminalEmulation() || !c.isDestroyed())) {
            cv = cra.getAcceptBGC();
        }
        go.setControlKey(controlKey);
        if (cra == null && craHotkeyReturn == null) {
            go.setCursorValue(0);
        }
        if (cv != null && cv instanceof NullControl && cv.getAuto()) {
            ICobolVar crs;
            if (go.resetActiveAccept()) {
                paramCS.addElement(new ParamVElement(3002));
            }
            paramCS.addElement(new ParamVElement(2058));
            go.setTimeout(-1L);
            ICobolVar iCobolVar = crs = crsAccept != null ? crsAccept : crsSN;
            if (crs != null) {
                paramCS.addElement(new ParamVElement(2069));
                go.sendParams(paramCS);
                this.setCursorVar(crsSN, crsAccept, go.getCursorValue());
            } else {
                go.sendParams(paramCS);
            }
            Return2 = new CobolRecordAccept(14, Config.getProperty("iscobol.keyboard.kbd_auto_return", 0), 0, go, true, false);
        } else if (cv != null && !(cv instanceof NullControl)) {
            BaseGUIControl bgcclone = cv;
            if (!cv.getContainsChildCTRL() || cv.getContainsChildTES() || cv.getContainsChildTE()) {
                BaseGUIControl saveclonesource = cv.getCloneSource();
                this.sendParamsToWindow();
                bgcclone = saveclonesource != null && cv.isDestroyed() ? go.loadClone(saveclonesource, null, paramCS, !saveclonesource.getContainsChildCTRL()) : go.loadClone(cv, null, -1, paramCS, false, true);
            }
            if (!cv.isClone()) {
                bgcclone = go.loadClone(cv, null, paramCS);
            }
            Return2 = this.internalAccept(ks, sC, eS, crsSN, crsAccept, beanCtn, go, bgcclone, onException, false, disableEmbProc, paramCS, cra, craHotkeyReturn);
        } else {
            ICobolVar crs;
            if (go.resetActiveAccept()) {
                paramCS.addElement(new ParamVElement(3002));
            }
            if ((cra == null || cra.getRecordType() != 13) && this.getGlobActiveWindow() == this.getThreadActiveWindow()) {
                ParamVElement pve = cv instanceof NullControl ? new ParamElementIntInt(2051, (int)cv.getAtLine(), (int)cv.getAtColumn()) : new ParamVElement(2051);
                paramCS.addElement(pve);
            }
            go.sendParams(paramCS);
            Return2 = this.internalAccept(ks, sC, eS, crsSN, crsAccept, null, go, null, onException, true, false, null, cra, craHotkeyReturn);
            ICobolVar iCobolVar = crs = crsAccept != null ? crsAccept : crsSN;
            if (crs != null) {
                paramCS.addElement(new ParamVElement(2069));
                go.sendParams(paramCS);
                this.setCursorVar(crsSN, crsAccept, go.getCursorValue());
            }
        }
        this.threadList = null;
        this.setActiveAccept(false);
        return Return2;
    }

    private BaseGUIWindow getWindowByHandle(ICobolVar hndl) {
        Object obj;
        BaseGUIWindow Return2 = hndl != null && (obj = UserHandles.getId(hndl.toint())) != null && obj instanceof BaseGUIWindow ? (BaseGUIWindow)obj : null;
        return Return2;
    }

    public BaseGUIControl getControl(BaseGUIControl cv, CobolVar upon) {
        if (!this.enableUI) {
            return NullControl.getInstance();
        }
        return this.getControl(cv, (ICobolVar)upon);
    }

    public BaseGUIControl getControl(BaseGUIControl cv, ICobolVar upon) {
        if (!this.enableUI) {
            return NullControl.getInstance();
        }
        return this.getControl(cv, this.getWindowByHandle(upon));
    }

    public BaseGUIControl getControl(BaseGUIControl cv, BaseGUIControl upon) {
        if (upon != null) {
            if (upon instanceof CobolGUITab && upon.getCloneSource() != null && upon.getCloneSource().getParentControl() != null) {
                cv.createTabValues(upon);
                upon.getCloneSource().getParentControl().addChildGraphics(cv);
            }
            return this.getControl(cv, upon.getCloneParentBGW());
        }
        return this.getControl(cv, cv.getCloneParentBGW());
    }

    public BaseGUIControl getControl(BaseGUIControl cv, BaseGUIWindow go) {
        BaseGUIControl Return2 = null;
        BaseGUIWindow gocloneparent = null;
        if (go == null) {
            if (cv == null || (go = cv.getCloneParentBGW()) == null) {
                go = this.getOutputWindow();
            }
        } else if (cv != null && (gocloneparent = cv.getCloneParentBGW()) != null && go != gocloneparent) {
            return cv;
        }
        if (!cv.isClone()) {
            if (!cv.getContainsChildCTRL()) {
                Return2 = cv;
            } else if (go instanceof DisplayToolBar) {
                Return2 = ((DisplayToolBar)go).getParentWindow().loadClone(cv, null, go.getParamCSWindow());
            } else if (go instanceof DisplayWindow) {
                Return2 = ((DisplayWindow)go).loadClone(cv, null, go.getParamCSWindow());
            } else if (go instanceof SubWindow && ((SubWindow)go).getParentWindow() != null && !((SubWindow)go).getParentWindow().isDestroyed()) {
                Return2 = ((SubWindow)go).getParentWindow().loadClone(cv, null, ((SubWindow)go).getParentWindow().getParamCSWindow());
            }
        } else if (cv.isTerminalEmulation()) {
            Return2 = cv;
        }
        Return2.setOperationTime(2);
        Return2.setRelocAtLine(0.0f);
        Return2.setRelocAtColumn(0.0f);
        return Return2;
    }

    public BaseGUIControl getControl(BaseGUIControl cv) {
        return this.getControl(cv, (BaseGUIWindow)null);
    }

    public BaseGUIControl getControl(float rowcol) {
        int row = (int)(rowcol / 100.0f);
        int col = (int)(rowcol % 100.0f);
        return this.getControl(row, col);
    }

    public BaseGUIControl getControl(float row, float col) {
        BaseGUIControl Return2 = null;
        DisplayWindow go = this.getOutputWindow();
        Return2 = go.getControl(row, col);
        return Return2;
    }

    public BaseGUIControl getControl(String rowcol, boolean inpixel, boolean incell) {
        BaseGUIControl Return2 = null;
        int div = 0;
        float frowcol = 0.0f;
        boolean error = false;
        try {
            frowcol = (int)Float.parseFloat(rowcol);
        }
        catch (NumberFormatException e) {
            error = true;
        }
        if (!error) {
            if (inpixel) {
                div = 10000;
            } else if (rowcol.length() <= 4) {
                div = 100;
            } else if (rowcol.length() <= 6) {
                div = 1000;
            }
            if (div > 0) {
                int row = (int)(frowcol / (float)div);
                int col = (int)(frowcol % (float)div);
                Return2 = this.getControl(row, col, inpixel, inpixel, incell, incell);
            }
        }
        return Return2;
    }

    public BaseGUIControl getControl(float row, float col, boolean lineinpixel, boolean colinpixel, boolean lineincell, boolean colincell) {
        BaseGUIControl Return2 = null;
        DisplayWindow go = this.getOutputWindow();
        Return2 = go.getControl(row, col, lineinpixel, colinpixel, lineincell, colincell);
        return Return2;
    }

    public BaseGUIControl getControl(NumericVar cv) {
        return this.getControl((INumericVar)cv);
    }

    public BaseGUIControl getControl(INumericVar cv) {
        BaseGUIControl Return2 = null;
        if (cv != null && cv instanceof IObjectVar && ((IObjectVar)cv).getOId() != null && ((IObjectVar)cv).getOId() instanceof BaseGUIControl) {
            Return2 = (BaseGUIControl)cv.getOId();
        }
        return Return2;
    }

    public BaseGUIControl getControl(CobolVar cv) {
        return this.getControl((ICobolVar)cv);
    }

    public BaseGUIControl getControl(ICobolVar cv) {
        BaseGUIControl Return2 = null;
        if (cv != null) {
            int index = cv.toint();
            Return2 = (BaseGUIControl)UserHandles.getId(index);
        }
        return Return2;
    }

    private CobolRecordAccept pop(DisplayWindow dw, boolean onException, boolean omitted) {
        return this.pop(dw, onException, omitted, null);
    }

    private CobolRecordAccept pop(DisplayWindow dw, boolean onException, boolean omitted, ParamVector param) {
        CobolRecordAccept cra;
        block33: {
            String progname = null;
            String prognameexc = null;
            String prognametimeout = null;
            BaseGUIControl ctl = null;
            boolean ishotkeyevent = false;
            long dwtimeout = 0L;
            if (dw != null) {
                dwtimeout = dw.getTimeout();
            }
            while (true) {
                cra = this.acceptStack.pop(dw, param);
                param = null;
                if (cra == null || cra.getRecordType() == 25 || !cra.isValid() || cra.getRecordType() == 13) continue;
                dw.setAllData(cra.getAllData());
                cra.setAllData(null);
                dw.setNewControlFocused(cra.getNewControlFocused());
                dw.loadGetValueControls(cra.getOldFocusValues(), null);
                cra.setOldFocusValues(null);
                if (cra.getKeyStatus() == 65535) {
                    Factory.setStepIntoDebugStatus();
                    cra.responseClient();
                    continue;
                }
                ishotkeyevent = cra.isHotKeyEvent();
                if (ishotkeyevent || cra.getWindow() != null && cra.getWindow().isCloseWithException(cra) && (prognameexc = CobolGUIEnvironment.getHotKeyProgram(this, cra.getWindow().getQuitMode())) != null || (ctl = cra.getControl()) != null && (progname = ctl.eventToException(cra)) != null || cra.getEventType() == 90000 && (prognametimeout = CobolGUIEnvironment.getHotKeyProgram(this, 99)) != null || (cra.isException() || cra.getEventType() == 16397) && (prognameexc = CobolGUIEnvironment.getHotKeyProgram(this, cra.getKeyStatus())) != null) {
                    NumericVar excValue = null;
                    if (ishotkeyevent) {
                        progname = cra.getHotKeyString();
                        ctl = cra.getControl();
                    } else {
                        excValue = Factory.getVarShortBinary(new byte[2], 0, 2, false, null, null, null, "exc-value", false, 4, 0, true, false, false);
                        if (progname != null) {
                            excValue.set(ctl.getExceptionValue());
                        } else if (prognameexc != null) {
                            excValue.set(cra.getKeyStatus());
                            progname = prognameexc;
                        } else if (prognametimeout != null) {
                            excValue.set(99);
                            progname = prognametimeout;
                        }
                    }
                    PicX to = Factory.getVarAlphanum(new byte[200], 0, 200, false, null, null, null, "current-field", false, false);
                    NumericVar fieldSize = Factory.getVarShortBinary(new byte[2], 0, 2, false, null, null, null, "field-size", false, 4, 0, true, false, false);
                    if (ctl != null) {
                        String val = ctl.getValue();
                        ctl.setVarGetValue(val, to, -1, null);
                        ICobolVar cv = ctl.getCobolComponent(0);
                        if (cv != null) {
                            fieldSize.set(cv.getLength());
                        } else {
                            fieldSize.set((int)ctl.getSizes());
                        }
                    } else {
                        to.set("");
                        fieldSize.set(0);
                    }
                    int rc = 0;
                    ICobolVar saveControlKey = null;
                    if (cra.getWindow() != null) {
                        saveControlKey = cra.getWindow().getControlKey();
                    }
                    try {
                        Object ret = null;
                        ret = ishotkeyevent ? Factory.call(progname, null, new Object[]{to, fieldSize}) : Factory.call(progname, null, new Object[]{to, fieldSize, excValue});
                        if (ret instanceof ICobolVar) {
                            rc = ((ICobolVar)ret).toint();
                        }
                        if (ctl != null) {
                            ctl.setValue(((Object)to).toString());
                        }
                    }
                    catch (CallOverflowException ex) {
                        throw new WrapperException(ex);
                    }
                    DisplayWindow w = this.getCurrentWindow();
                    if (w != null) {
                        if (w.getActiveControl() != null) {
                            w.restoreFocusOwner();
                        } else if (omitted) {
                            w.requestFocus();
                        }
                        w.setControlKey(saveControlKey);
                    }
                    cra.responseClient();
                    if (rc == -1) {
                        cra = new ChangeFocusEvent(8, this.autoterminatedvalue, false, cra.getControl(), cra.getWindow(), 0);
                        break block33;
                    }
                    if (rc > 0) {
                        cra = new CobolRecordAccept(4, rc, 0, cra.getWindow(), cra.getControl(), 0, 0, true, true, false);
                        break block33;
                    }
                    if (ctl != null) {
                        if (ctl.isDestroyed()) {
                            return new CobolRecordAccept(26, 0, 0, ctl, false, false, true);
                        }
                        if (w.getActiveControl() == null) {
                            try {
                                ctl.controlPeerrequestFocus(ctl.getControlPeerServerId());
                                w.setActiveControl(ctl);
                            }
                            catch (IOException _re) {
                                ScreenUtility.handleIOException(_re);
                            }
                        }
                    }
                    if (w != null && dwtimeout > 0L) {
                        w.setTimeout(dwtimeout);
                    }
                    progname = null;
                    prognameexc = null;
                    continue;
                }
                if (cra.getRecordType() != 8 || cra.getWindow() == null || cra.getControl() == null || cra.getWindow().getActiveControl() == null || cra.getControl().getName().equals(cra.getWindow().getActiveControl().getName())) break;
            }
            ScrFactory.setLastMouseStatus(cra.getMouseStatus());
        }
        if (cra != null && cra.getWindow() != null) {
            cra.getWindow().setThreadWaiting(cra);
        }
        return cra;
    }

    public void getAllData(CobolRecordAccept cra) {
        this.getAllData(cra, null);
    }

    public boolean getAllData(CobolRecordAccept cra, DisplayWindow dwinput) {
        boolean Return2 = false;
        BaseGUIControl bgc = cra.getAcceptBGC();
        DisplayWindow dw = null;
        if (bgc == null) {
            bgc = cra.getControl();
        }
        if (bgc != null) {
            dw = (DisplayWindow)bgc.getParentBGW();
        }
        if (dw != null) {
            Return2 = dw.getAllData(dwinput, cra.getControl());
        } else if (bgc != null && bgc.isInputField() && bgc.getActiveAccept()) {
            bgc.getAllData();
            Return2 = bgc == cra.getControl();
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(DisplayToolBar dtb) {
        if (dtb != null) {
            DisplayWindow dw = dtb.getParentWindow();
            if (!dw.isBufferedWindowType()) {
                if (dw != null) {
                    dw.sendParams(dw.getParamCSWindow());
                }
                dtb.destroy();
            } else {
                LinkedList linkedList = this.windowList;
                synchronized (linkedList) {
                    dtb.destroydtb(dw.getParamCSWindow());
                    dw.sendParams(dw.getParamCSWindow());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy(BaseGUIWindow ctl) {
        if (ctl != null) {
            LinkedList linkedList = this.windowList;
            synchronized (linkedList) {
                if (ctl instanceof DisplayWindow && ((DisplayWindow)ctl).isMainApplicationWindow()) {
                    return false;
                }
                DisplayWindow pw = ctl.getParentWnd();
                if (pw != null) {
                    if (!pw.isDestroyed()) {
                        pw.deleteChildWindow((DisplayWindow)ctl);
                    } else {
                        pw = ((DisplayWindow)ctl).getNextCurrentWindow();
                    }
                }
                this.removeWindow(ctl, pw, true);
                if (pw != null) {
                    this.enqueueParams(pw, pw.getParamCSWindow());
                    ((DisplayWindow)ctl).destroy(pw);
                } else {
                    ((DisplayWindow)ctl).destroy();
                }
                if (pw != null) {
                    pw.sendParams(pw.getParamCSWindow());
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(BaseGUIControl ctl) {
        DisplayWindow dw = null;
        Vector windows = new Vector();
        BaseGUIControl baseGUIControl = ctl;
        synchronized (baseGUIControl) {
            this.destroy(ctl, windows);
            if (windows.size() > 0) {
                Enumeration elem = windows.elements();
                while (elem.hasMoreElements()) {
                    dw = (DisplayWindow)elem.nextElement();
                    this.enqueueParams(dw);
                }
            }
        }
    }

    public void destroy(BaseGUIControl ctl, Vector windows) {
        BaseGUIControl bgc = null;
        if (ctl.getIsControlEditor() && (bgc = ctl.getContainerEditor()) != null) {
            bgc.destroyControlEditor(ctl);
        } else {
            BaseGUIWindow bgw = null;
            bgc = ctl;
            bgc.destroyContainerChilds(windows);
            if (bgc.childGraphics != null && bgc.childGraphics.size() > 0) {
                BaseGUIControl[] childs = new BaseGUIControl[bgc.childGraphics.size()];
                bgc.childGraphics.toArray(childs);
                for (int i = 0; i < childs.length; ++i) {
                    this.destroy(childs[i], windows);
                }
                bgw = bgc.getCloneParentBGW();
                if (bgw != null && bgc.getLastClone() != null && !bgc.getLastClone().isDestroyed()) {
                    bgw.destroy(bgc.getLastClone(), bgw.getParamCSWindow());
                }
            } else {
                bgw = bgc.getCloneParentBGW();
                if (bgw != null) {
                    bgw.destroy(bgc.isClone() ? bgc : bgc.getLastClone(), bgw.getParamCSWindow());
                    if (!windows.contains(bgw)) {
                        windows.add(bgw);
                    }
                }
                if (!(ctl instanceof TerminalEmulation)) {
                    BaseGUIControl bgctrue = null;
                    if (!bgc.isClone()) {
                        bgctrue = bgc.getLastClone();
                        if (bgctrue != null) {
                            // empty if block
                        }
                    } else {
                        bgctrue = bgc;
                    }
                    if (bgctrue != null) {
                        bgctrue.destroy();
                    }
                }
            }
        }
    }

    public NumericVar destroy(NumericVar ov) {
        this.destroy((INumericVar)ov);
        return null;
    }

    public void destroy(INumericVar ov) {
        Object obj;
        boolean freeobjvar = true;
        if (ov != null && ov instanceof IObjectVar && (obj = ((IObjectVar)ov).getOId()) != null) {
            if (obj instanceof DisplayToolBar) {
                this.destroy((DisplayToolBar)obj);
            } else if (obj instanceof DisplayWindow) {
                DisplayWindow go = (DisplayWindow)obj;
                if (go != null && this.searchWindow(go) != null) {
                    freeobjvar = this.destroy(go);
                }
            } else if (obj instanceof BaseGUIControl) {
                BaseGUIControl bgc = (BaseGUIControl)obj;
                this.destroy(bgc);
            } else if (obj instanceof FontCmp) {
                this.refreshAll();
                ((FontCmp)obj).destroy();
                freeobjvar = !((FontCmp)obj).isStandardFont();
            } else if (obj instanceof Monitor) {
                Factory.stopThread(ov);
            } else if (obj instanceof SubWindow) {
                this.close((SubWindow)obj, false);
            } else if (obj instanceof FileImage) {
                freeobjvar = false;
            }
            if (freeobjvar) {
                ((IObjectVar)ov).free();
            }
        } else if (ov != null && ov instanceof IObjectVar) {
            ((IObjectVar)ov).free();
        }
    }

    public void destroy(CobolVar cv) {
        this.destroy((ICobolVar)cv);
    }

    public void destroy(ICobolVar cv) {
        if (cv != null) {
            int index = cv.toint();
            BaseGUIWindow bgw = (BaseGUIWindow)UserHandles.getId(index);
            if (bgw instanceof SubWindow) {
                this.close((SubWindow)bgw, false);
                UserHandles uh = (UserHandles)IscobolSystem.getIfExists(UserHandles.class, Thread.currentThread());
                if (uh != null) {
                    UserHandles.free(bgw);
                }
            } else if (bgw != null) {
                this.destroy(bgw);
                UserHandles uh = (UserHandles)IscobolSystem.getIfExists(UserHandles.class, Thread.currentThread());
                if (uh != null) {
                    UserHandles.free(bgw);
                }
            }
            cv.set(0);
        }
    }

    public void destroy(boolean all) {
        DisplayWindow go = this.getCurrentWindow();
        if (go != null) {
            go.destroy();
        }
    }

    public void destroyAllControls() {
        DisplayWindow go = this.getCurrentWindow();
        if (go != null) {
            go.destroyAllControls();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAll() {
        Object[] ctl = this.windowList.toArray();
        for (int i = 0; i < ctl.length; ++i) {
            Vector vector = this.windowWait;
            synchronized (vector) {
                Object object = ctl[i];
                synchronized (object) {
                    ((DisplayWindow)ctl[i]).destroy();
                }
            }
        }
    }

    public BaseGUIControl addToScreen(BaseGUIControl container, BaseGUIControl child) {
        if (child.childGraphics != null && child.childGraphics.size() > 0) {
            BaseGUIControl[] childs = new BaseGUIControl[child.childGraphics.size()];
            child.childGraphics.toArray(childs);
            for (int i = 0; i < childs.length; ++i) {
                this.addToScreenElement(container, childs[i]);
            }
        } else {
            container = this.addToScreenElement(container, child);
        }
        return container;
    }

    private BaseGUIControl addToScreenElement(BaseGUIControl container, BaseGUIControl child) {
        if (container != null && child != null) {
            child.setDynamicControl(true);
            if (container.hasTabProperty()) {
                child.setTabValues(container);
            }
            if (container.hasScrollProperty()) {
                child.setScrollValues(container);
            }
            child.displaysetHandle();
            BaseGUIWindow go = container.getCloneParentBGW();
            BaseGUIControl first = null;
            if (container.childGraphics != null && container.childGraphics.size() > 0) {
                BaseGUIControl[] childs = new BaseGUIControl[container.childGraphics.size()];
                container.childGraphics.toArray(childs);
                for (int i = 0; first == null && i < childs.length; ++i) {
                    if (first != null) continue;
                    first = childs[i].getLastClone();
                }
                if (first != null && first.getActiveDisplay()) {
                    child.setParentControl(container);
                    if (container != null && container.getLastClone() != null && container.getLastClone().getTabIndex() >= 0) {
                        container.getLastClone().getParentUponCtrl().setAtY(container.getLastClone().getTabIndex());
                        this.display(null, child, container.getLastClone().getParentUponCtrl());
                    } else {
                        if (child.getAddToScreenLine() > 0.0f) {
                            child.addLine(child.getAddToScreenLine(), true);
                        }
                        if (child.getAddToScreenColumn() > 0.0f) {
                            child.addColumn(child.getAddToScreenColumn(), true);
                        }
                        if (go != null) {
                            this.display(go, child, null, false);
                        } else {
                            this.display(child, false);
                        }
                    }
                    if (child.getLastClone() != null) {
                        child.getLastClone().setHandle(null);
                    }
                }
            } else {
                if (container instanceof CobolGUITerminalDisplay) {
                    container = ScrFactory.getControl(container.name, null, null).setStyle("TEMPORARY").setPrompt(true).endDeclaration();
                }
                child.setParentControl(container);
                if (container != null && container.getLastClone() != null && (container instanceof CobolGUITab || container instanceof CobolGUIScrollPane)) {
                    if (container instanceof CobolGUITab && container.getLastClone().getTabIndex() >= 0) {
                        container.getLastClone().getParentUponCtrl().setAtY(container.getLastClone().getTabIndex());
                    }
                    this.display(null, child, container.getLastClone().getParentUponCtrl());
                } else {
                    if (child.getAddToScreenLine() > 0.0f) {
                        child.addLine(child.getAddToScreenLine(), true);
                    }
                    if (child.getAddToScreenColumn() > 0.0f) {
                        child.addColumn(child.getAddToScreenColumn(), true);
                    }
                    if (go != null) {
                        this.display(go, child, null, false);
                    } else {
                        this.display(child, false);
                    }
                }
                if (child.getLastClone() != null) {
                    child.getLastClone().setHandle(null);
                }
                first = child.getLastClone();
            }
            if (first == null) {
                BaseGUIControl bgc = child.getClone(null);
                bgc.setIsClone(false);
                bgc.setHandle(null);
                child.setLastClone(bgc);
                bgc.setParentControl(container);
            }
        }
        return container;
    }

    public NumericVar removeFromScreen(BaseGUIControl container, NumericVar ov) {
        this.removeFromScreen(container, (INumericVar)ov);
        return null;
    }

    public void removeFromScreen(BaseGUIControl container, INumericVar ov) {
        Object obj = null;
        if (ov != null && ov instanceof IObjectVar && (obj = ((IObjectVar)ov).getOId()) != null && obj instanceof BaseGUIControl) {
            this.removeFromScreen(container, (BaseGUIControl)obj);
        }
    }

    public BaseGUIControl removeFromScreen(BaseGUIControl container, BaseGUIControl child) {
        if (container instanceof CobolGUITab) {
            if (container.isClone()) {
                container = container.getCloneSource();
            }
            if (container.getParentControl() != null) {
                container.getParentControl().deleteChildGraphics(child);
            }
            this.destroy(child);
            child.removeTabValues();
        } else if (child.childGraphics != null && child.childGraphics.size() > 0) {
            BaseGUIControl[] childs = new BaseGUIControl[child.childGraphics.size()];
            child.childGraphics.toArray(childs);
            int i = 0;
            for (i = 0; i < childs.length; ++i) {
                this.destroy(childs[i]);
                container.deleteChildGraphics(childs[i]);
                childs[i].setParentControl(null);
            }
        } else {
            BaseGUIControl first = null;
            if (container.childGraphics != null && container.childGraphics.size() > 0) {
                BaseGUIControl[] childs = new BaseGUIControl[container.childGraphics.size()];
                container.childGraphics.toArray(childs);
                for (int i = 0; first == null && i < childs.length; ++i) {
                    if (first != null) continue;
                    first = childs[i].getLastClone();
                }
                if (first != null && first.getActiveDisplay()) {
                    child.setParentControl(null);
                    this.destroy(child);
                }
            }
        }
        if (child.getLastClone() != null) {
            container.deleteChildGraphics(child.getLastClone());
        }
        container.deleteChildGraphics(child);
        child.setParentControl(null);
        UserHandles uh = (UserHandles)IscobolSystem.getIfExists(UserHandles.class, Thread.currentThread());
        if (uh != null) {
            UserHandles.free(child);
        }
        return container;
    }

    public void close(CobolVar ov) {
        this.close(ov, false);
    }

    public void close(ICobolVar ov) {
        this.close(ov, false);
    }

    public void close(CobolVar cv, boolean nd) {
        this.close((ICobolVar)cv, nd);
    }

    public void closePopup(ICobolVar wcb) {
        byte[] wcbba = wcb.getBytes();
        int handle = SubWindow.getU2B(wcbba, 0);
        if (handle != 0) {
            this.close(handle, false);
        } else {
            this.close(this.getSubWindow(null), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(SubWindow sw, boolean nd) {
        if (sw == null) {
            return;
        }
        DisplayWindow go = sw.getParentWnd();
        if (go != null) {
            Vector vector = this.windowWait;
            synchronized (vector) {
                go.dequeueParamsSend(true);
            }
        }
        sw.close(nd);
    }

    public void close(ICobolVar cv, boolean nd) {
        int index;
        boolean destroyok;
        if (cv != null && (destroyok = this.close(index = cv.toint(), nd))) {
            cv.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(int index, boolean nd) {
        boolean destroyok = true;
        if (UserHandles.getId(index) instanceof DisplayWindow) {
            Object object;
            DisplayWindow go = (DisplayWindow)UserHandles.getId(index);
            if (go != null) {
                object = this.windowWait;
                synchronized (object) {
                    go.dequeueParamsSend(true);
                }
            }
            if (go != null) {
                if (this.searchWindow(go) != null) {
                    destroyok = this.destroy(go);
                } else if (go instanceof DisplayToolBar) {
                    this.destroy((DisplayToolBar)go);
                }
            }
            if (destroyok) {
                UserHandles uh;
                if (go.type == 11) {
                    object = go.getNotificationLock();
                    synchronized (object) {
                        go.getNotificationLock().notify();
                    }
                }
                if ((uh = (UserHandles)IscobolSystem.getIfExists(UserHandles.class, Thread.currentThread())) != null) {
                    UserHandles.free(index);
                }
            }
        } else if (UserHandles.getId(index) instanceof SubWindow) {
            SubWindow bgw = (SubWindow)UserHandles.getId(index);
            this.close(bgw, nd);
            UserHandles uh = (UserHandles)IscobolSystem.getIfExists(UserHandles.class, Thread.currentThread());
            if (uh != null) {
                UserHandles.free(index);
            }
        }
        return destroyok;
    }

    public ObjectVar destroy(ObjectVar ov) {
        this.close(ov);
        return null;
    }

    public void close(IObjectVar ov) {
        this.close(ov, false);
    }

    public ObjectVar close(ObjectVar ov, boolean nd) {
        this.close((IObjectVar)ov, nd);
        return null;
    }

    public void close(IObjectVar ov, boolean nd) {
        if (ov != null && ov.getOId() != null) {
            if (ov.getOId() instanceof DisplayWindow) {
                DisplayWindow go = (DisplayWindow)ov.getOId();
                if (go != null) {
                    if (this.searchWindow(go) != null) {
                        this.destroy(go);
                    } else if (go instanceof DisplayToolBar) {
                        this.destroy((DisplayToolBar)go);
                    }
                    UserHandles uh = (UserHandles)IscobolSystem.getIfExists(UserHandles.class, Thread.currentThread());
                    if (uh != null) {
                        UserHandles.free(go);
                    }
                }
            } else if (ov.getOId() instanceof SubWindow) {
                SubWindow go = (SubWindow)ov.getOId();
                this.close(go, nd);
                UserHandles uh = (UserHandles)IscobolSystem.getIfExists(UserHandles.class, Thread.currentThread());
                if (uh != null) {
                    UserHandles.free(go);
                }
            }
            ov.set(0);
        }
    }

    public void setCrtStatus(CobolVar keyStatusOfCrtStatus, int val1, CobolRecordAccept cra) {
        this.setCrtStatus((ICobolVar)keyStatusOfCrtStatus, val1, cra);
    }

    public void setCrtStatus(ICobolVar keyStatusOfCrtStatus, int val1, CobolRecordAccept cra) {
        if (keyStatusOfCrtStatus != null) {
            if (keyStatusOfCrtStatus instanceof INumericVar) {
                keyStatusOfCrtStatus.set(val1);
            } else {
                int key3 = 0;
                if (cra != null && cra.getWindow() != null) {
                    key3 = cra.getWindow().getControlKeyValue();
                }
                byte[] mem = CobolGUIEnvironment.saveMem(keyStatusOfCrtStatus);
                int ofs = 0;
                Integer i = new Integer(val1);
                mem[ofs++] = 48;
                if (mem.length > 1) {
                    mem[ofs++] = i.byteValue();
                }
                if (mem.length > 2) {
                    i = new Integer(key3);
                    mem[ofs++] = i.byteValue();
                }
                keyStatusOfCrtStatus.set(mem);
            }
        }
    }

    public void setCobolCrtStatusInterface(CobolVar keyStatusOfCrtStatus, CobolRecordAccept cra) {
        this.setCobolCrtStatusInterface((ICobolVar)keyStatusOfCrtStatus, cra);
    }

    public void setCobolCrtStatusInterface(ICobolVar keyStatusOfCrtStatus, CobolRecordAccept cra) {
        this.setCobolCrtStatusInterface(keyStatusOfCrtStatus, cra, true);
    }

    public void setCobolCrtStatusInterface(ICobolVar keyStatusOfCrtStatus, CobolRecordAccept cra, boolean setescape) {
        if (setescape) {
            this.getTdd()._escapeKey = cra.getKeyStatus();
        }
        if (keyStatusOfCrtStatus != null) {
            if (keyStatusOfCrtStatus instanceof INumericVar) {
                this.setCrtStatus(keyStatusOfCrtStatus, cra.getKeyStatus(), cra);
            } else {
                byte[] mem = CobolGUIEnvironment.saveMem(keyStatusOfCrtStatus);
                int ofs = 0;
                Integer i = null;
                if (cra.isEvent() && cra.getKeyStatus() == 99) {
                    mem[ofs++] = 51;
                    if (mem.length > 2) {
                        mem[ofs + 1] = 99;
                    }
                } else if (cra.isException() && cra.getKeyStatus() == 97) {
                    mem[ofs++] = 57;
                    if (mem.length > 2) {
                        mem[ofs + 1] = 97;
                    }
                } else if (cra.isException() || cra.getExceptionGenerated()) {
                    if ((cra.isEvent() || cra.isTabChangedEvent()) && cra.getExceptionValue() == 0) {
                        mem[ofs++] = 52;
                        mem[ofs++] = 0;
                        if (mem.length > 2) {
                            mem[ofs++] = 96;
                        }
                    } else {
                        mem[ofs++] = 49;
                        i = new Integer(cra.getKeyStatus());
                        if (i != null && mem.length > 1) {
                            mem[ofs++] = i.byteValue();
                        }
                        if (mem.length > 2) {
                            mem[ofs++] = i.byteValue();
                        }
                    }
                } else if (cra.getEventType() == 3) {
                    mem[ofs++] = 52;
                    mem[ofs++] = 0;
                    if (mem.length > 2) {
                        mem[ofs++] = 96;
                    }
                } else {
                    mem[ofs++] = 48;
                    mem[ofs++] = cra.getAutoTermination() ? 49 : 48;
                    i = new Integer(cra.getKeyStatus());
                    if (mem.length > 2) {
                        mem[ofs++] = i.byteValue();
                    }
                }
                keyStatusOfCrtStatus.set(mem);
            }
        }
        if (cra.getWindow() != null) {
            cra.getWindow().setControlKeyValue(cra.getKeyStatus());
        } else if (cra.isEventFromThread() && this.getCurrentWindow() != null) {
            this.getCurrentWindow().setControlKeyValue(cra.getKeyStatus());
        }
    }

    public CobolRecordAccept responseAcceptControl(CobolVar ks, CobolVar sC, CobolRecordAccept cra, BaseGUIControl acceptbgc) {
        return this.responseAcceptControl((ICobolVar)ks, (ICobolVar)sC, cra, acceptbgc, (BaseGUIControl)null, (BaseGUIControl)null);
    }

    public CobolRecordAccept responseAcceptControl(CobolVar ks, CobolVar sC, CobolRecordAccept cra, BaseGUIControl acceptbgc, BaseGUIControl bgc, BaseGUIControl currFocus) {
        return this.responseAcceptControl(ks, sC, cra, acceptbgc, bgc, currFocus, true);
    }

    public CobolRecordAccept responseAcceptControl(ICobolVar ks, ICobolVar sC, CobolRecordAccept cra, BaseGUIControl acceptbgc) {
        return this.responseAcceptControl(ks, sC, cra, acceptbgc, (BaseGUIControl)null, (BaseGUIControl)null);
    }

    public CobolRecordAccept responseAcceptControl(ICobolVar ks, ICobolVar sC, CobolRecordAccept cra, BaseGUIControl acceptbgc, BaseGUIControl bgc, BaseGUIControl currFocus) {
        return this.responseAcceptControl(ks, sC, cra, acceptbgc, bgc, currFocus, true);
    }

    public CobolRecordAccept responseAcceptControl(ICobolVar ks, ICobolVar sC, CobolRecordAccept cra, BaseGUIControl acceptbgc, BaseGUIControl bgc, BaseGUIControl currFocus, boolean nextifdestroyed) {
        return this.responseAcceptControl(ks, sC, cra, acceptbgc, bgc, currFocus, nextifdestroyed, false);
    }

    public CobolRecordAccept responseAcceptControl(ICobolVar ks, ICobolVar sC, CobolRecordAccept cra, BaseGUIControl acceptbgc, BaseGUIControl bgc, BaseGUIControl currFocus, boolean nextifdestroyed, boolean embeddedproc) {
        DisplayWindow go = cra.getWindow();
        BaseGUIControl newfocus = null;
        switch (this.getAcceptControlOfScreenControl(sC, acceptbgc)) {
            default: {
                if (!(bgc == null || bgc.isTerminalEmulation() || !bgc.isDestroyed() && bgc.isEnabled() || acceptbgc == null || acceptbgc.isDestroyed())) {
                    DisplayWindow currWindow = (DisplayWindow)acceptbgc.getParentBGW();
                    newfocus = nextifdestroyed ? acceptbgc.setCursorValue(bgc.getScreenCntrlVal() + 1, true, false) : acceptbgc.setCursorValue(bgc.getScreenCntrlVal() - 1, true, false);
                    if (newfocus != null) {
                        cra.setNewControlWithFocus(newfocus);
                        return cra;
                    }
                    currWindow.resetScreenEnv(null);
                    return new CobolRecordAccept(13, 0, 0, (BaseGUIControl)null, false, false, true).setAcceptBGC(acceptbgc);
                }
                return null;
            }
            case 1: {
                if (go != null) {
                    int cv = -1;
                    cv = this.getControlValueOfScreenControl(sC, acceptbgc);
                    if (cv >= 0) {
                        newfocus = cv == 0 ? cra.getWindow().getActiveControl() : acceptbgc.setCursorValue(cv, false, false);
                        cra.setExceptionGenerated(false);
                        if (newfocus != null) {
                            cra.setTerminationGenerated(false);
                        } else {
                            cra.setTerminationGenerated(true);
                            cra.setKeyStatus(0);
                            this.setCobolCrtStatusInterface(ks, cra);
                            if (cra.getControl() != null) {
                                this.setControlValueOfScreenControl(sC, cra.getControl().getScreenCntrlVal(), acceptbgc);
                            }
                            this.setAcceptControlOfScreenControl(sC, 0, acceptbgc);
                            cra.setRecordType(14);
                        }
                    }
                }
                cra.setNewControlWithFocus(newfocus);
                return cra;
            }
            case 2: {
                this.setCrtStatus(ks, this.getControlValueOfScreenControl(sC, acceptbgc), cra);
                cra.setRecordType(14);
                cra.setKeyStatus(this.getControlValueOfScreenControl(sC, acceptbgc));
                return cra;
            }
            case 3: {
                this.setCrtStatus(ks, this.getControlValueOfScreenControl(sC, acceptbgc), cra);
                cra.setRecordType(15);
                cra.setKeyStatus(this.getControlValueOfScreenControl(sC, acceptbgc));
                return cra;
            }
            case 4: 
        }
        if (go != null) {
            int cv = -1;
            cv = this.getControlIdOfScreenControl(sC, acceptbgc);
            if (cv >= 0) {
                newfocus = cv == 0 ? cra.getWindow().getActiveControl() : acceptbgc.setCursorId(cv, true, false, false, embeddedproc);
                cra.setExceptionGenerated(false);
                if (newfocus != null) {
                    cra.setTerminationGenerated(false);
                } else {
                    cra.setTerminationGenerated(true);
                    cra.setKeyStatus(0);
                    this.setCobolCrtStatusInterface(ks, cra);
                    if (cra.getControl() != null) {
                        this.setControlIdOfScreenControl(sC, cra.getControl().getId(), acceptbgc);
                    }
                    this.setAcceptControlOfScreenControl(sC, 0, acceptbgc);
                    cra.setRecordType(14);
                }
            }
        }
        cra.setNewControlWithFocus(newfocus);
        return cra;
    }

    public void responseAccept(CobolVar ks, CobolVar sC, CobolVar eS, BeanContainer beanCtn, CobolRecordAccept cra) {
        this.responseAccept((ICobolVar)ks, (ICobolVar)sC, (ICobolVar)eS, beanCtn, cra);
    }

    public void responseAccept(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, CobolRecordAccept cra) {
        if (cra.getRecordType() == 13 || cra.getRecordType() == 12 || cra.getRecordType() == 27 || cra.getRecordType() == 14 || cra.getRecordType() == 26 || this.getAcceptControlExcpValue(sC, cra.getAcceptBGC()) || this.getAcceptControlTermValue(sC, cra.getAcceptBGC())) {
            return;
        }
        boolean gonext = false;
        if (cra.getExceptionGenerated()) {
            if (this.getAcceptControlOfScreenControl(sC, cra.getAcceptBGC()) == 0) {
                gonext = true;
            }
        } else {
            gonext = true;
        }
        if (eS != null && eS.getLength() == 25 && gonext) {
            int ea = this.getEventActionOfEventStatus(eS);
            switch (ea) {
                case 0: {
                    break;
                }
                case 1: {
                    cra.setExceptionGenerated(true);
                    cra.setTerminationGenerated(true);
                    if (cra.getKeyStatus() != 0 || cra.getTerminationValue() != 0) break;
                    cra.setKeyStatus(96);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 7: {
                    cra.setExceptionGenerated(true);
                    cra.setTerminationGenerated(true);
                    if (cra.getKeyStatus() != 0 || cra.getTerminationValue() != 0) break;
                    cra.setKeyStatus(96);
                }
            }
        }
    }

    public int getAcceptControlOfScreenControl(CobolVar sC, BaseGUIControl acceptbgc) {
        return this.getAcceptControlOfScreenControl((ICobolVar)sC, acceptbgc);
    }

    public int getAcceptControlOfScreenControl(ICobolVar sC, BaseGUIControl acceptbgc) {
        int Return2 = 0;
        if (sC != null && acceptbgc != null && acceptbgc.isScreenSectionVar()) {
            NumericVar cv = this.getTdd()._acceptControlOfScreenControl;
            if ((this.getTdd()._screenControlLength = sC.getLength()) >= 1) {
                this.getTdd()._screenControl.set(sC.getBytes());
                Return2 = cv.toint();
            }
        }
        return Return2;
    }

    public void setAcceptControlOfScreenControl(CobolVar sC, int v, BaseGUIControl acceptbgc) {
        this.setAcceptControlOfScreenControl((ICobolVar)sC, v, acceptbgc);
    }

    public void setAcceptControlOfScreenControl(ICobolVar sC, int v, BaseGUIControl acceptbgc) {
        if (sC != null && acceptbgc != null && acceptbgc.isScreenSectionVar()) {
            NumericVar cv = this.getTdd()._acceptControlOfScreenControl;
            if ((this.getTdd()._screenControlLength = sC.getLength()) >= 1) {
                this.getTdd()._screenControl.set(sC.getBytes());
                cv.set(v);
                sC.set(this.getTdd()._screenControl.getBytes());
            }
        }
    }

    public int getControlValueOfScreenControl(CobolVar sC, BaseGUIControl acceptbgc) {
        return this.getControlValueOfScreenControl((ICobolVar)sC, acceptbgc);
    }

    public int getControlValueOfScreenControl(ICobolVar sC, BaseGUIControl acceptbgc) {
        int Return2 = 0;
        if (sC != null && acceptbgc != null && acceptbgc.isScreenSectionVar()) {
            NumericVar cv = this.getTdd()._controlValueOfScreenControl;
            if ((this.getTdd()._screenControlLength = sC.getLength()) >= 4) {
                this.getTdd()._screenControl.set(sC.getBytes());
                Return2 = cv.toint();
            }
        }
        return Return2;
    }

    private void setControlValueOfScreenControl(ICobolVar sC, int v, BaseGUIControl acceptbgc) {
        if (sC != null && acceptbgc != null && acceptbgc.isScreenSectionVar()) {
            NumericVar cv = this.getTdd()._controlValueOfScreenControl;
            if ((this.getTdd()._screenControlLength = sC.getLength()) >= 4) {
                this.getTdd()._screenControl.set(sC.getBytes());
                cv.set(v);
                sC.set(this.getTdd()._screenControl.getBytes());
            }
        }
    }

    public int getControlIdOfScreenControl(CobolVar sC, BaseGUIControl acceptbgc) {
        return this.getControlIdOfScreenControl((ICobolVar)sC, acceptbgc);
    }

    public int getControlIdOfScreenControl(ICobolVar sC, BaseGUIControl acceptbgc) {
        int Return2 = 0;
        if (sC != null && acceptbgc != null && acceptbgc.isScreenSectionVar()) {
            NumericVar cv = this.getTdd()._controlIdOfScreenControl;
            if ((this.getTdd()._screenControlLength = sC.getLength()) == 10) {
                this.getTdd()._screenControl.set(sC.getBytes());
                Return2 = cv.toint();
            }
        }
        return Return2;
    }

    public void setControlIdOfScreenControl(CobolVar sC, int v, BaseGUIControl acceptbgc) {
        this.setControlIdOfScreenControl((ICobolVar)sC, v, acceptbgc);
    }

    public void setControlIdOfScreenControl(ICobolVar sC, int v, BaseGUIControl acceptbgc) {
        if (sC != null && acceptbgc != null && acceptbgc.isScreenSectionVar()) {
            NumericVar cv = this.getTdd()._controlIdOfScreenControl;
            if ((this.getTdd()._screenControlLength = sC.getLength()) == 10) {
                this.getTdd()._screenControl.set(sC.getBytes());
                if (v == 0) {
                    DisplayWindow gaw = null;
                    BaseGUIControl Return2 = null;
                    gaw = this.getThreadActiveWindow();
                    if (gaw != null && (Return2 = gaw.getActiveControl()) != null) {
                        v = Return2.intGetId();
                    }
                }
                cv.set(v);
                sC.set(this.getTdd()._screenControl.getBytes());
            }
        }
    }

    private void setControlHandleOfScreenControl(ICobolVar sC, Object o, BaseGUIControl acceptbgc) {
        BaseGUIControl bgc = (BaseGUIControl)o;
        if (bgc != null && bgc.haveHandle()) {
            return;
        }
        if (sC != null && acceptbgc != null && acceptbgc.isScreenSectionVar()) {
            ObjectVar cv = this.getTdd()._controlHandleOfScreenControl;
            if ((this.getTdd()._screenControlLength = sC.getLength()) >= 8) {
                this.getTdd()._screenControl.set(sC.getBytes());
                this.setObjectVar(o, cv);
                sC.set(this.getTdd()._screenControl.getBytes());
            }
        }
    }

    public int getEventActionOfEventStatus(CobolVar eS, CobolRecordAccept cra) {
        return this.getEventActionOfEventStatus((ICobolVar)eS, cra);
    }

    public int getEventActionOfEventStatus(ICobolVar eS, CobolRecordAccept cra) {
        if (!cra.isEvent()) {
            return 0;
        }
        return this.getEventActionOfEventStatus(eS);
    }

    public int getEventActionOfEventStatus(CobolVar eS) {
        return this.getEventActionOfEventStatus((ICobolVar)eS);
    }

    public int getEventActionOfEventStatus(ICobolVar eS) {
        int Return2 = 0;
        if (eS != null) {
            NumericVar cv = this.getTdd()._eventActionOfEventStatus;
            if (eS.getLength() == 25) {
                this.getTdd()._eventStatus.set(eS.getBytes());
                Return2 = cv.toint();
            }
        }
        return Return2;
    }

    void setEventActionOfEventStatus(ICobolVar eS, int v, CobolRecordAccept cra) {
        if (eS != null) {
            NumericVar cv = this.getTdd()._eventActionOfEventStatus;
            if (eS.getLength() == 25) {
                this.getTdd()._eventStatus.set(eS.getBytes());
                cv.set(v);
                eS.set(this.getTdd()._eventStatus.getBytes());
            }
        }
        if (cra.getWindow() != null && cra.getWindow() instanceof DisplayWindow) {
            cra.getWindow().setEventActionOfEventStatus(v);
        }
    }

    private int getEventTypeOfEventStatus(ICobolVar eS) {
        int Return2 = 0;
        if (eS != null) {
            NumericVar cv = this.getTdd()._eventType;
            if (eS.getLength() >= 4) {
                this.getTdd()._eventStatus.set(eS.getBytes());
                Return2 = cv.toint();
            }
        }
        return Return2;
    }

    private void setEventTypeOfEventStatus(ICobolVar eS, int v) {
        if (eS != null) {
            NumericVar cv = this.getTdd()._eventType;
            if (eS.getLength() >= 4) {
                this.getTdd()._eventStatus.set(eS.getBytes());
                cv.set(v);
                eS.set(this.getTdd()._eventStatus.getBytes());
            }
        }
    }

    private void setEventControlIdOfEventStatus(ICobolVar eS, int v) {
        if (eS != null) {
            NumericVar cv = this.getTdd()._eventControlId;
            if (eS.getLength() >= 14) {
                this.getTdd()._eventStatus.set(eS.getBytes());
                cv.set(v);
                eS.set(this.getTdd()._eventStatus.getBytes());
            }
        }
    }

    private void setEventData1OfEventStatus(ICobolVar eS, int v) {
        if (eS != null) {
            NumericVar cv = this.getTdd()._eventData1;
            if (eS.getLength() >= 16) {
                this.getTdd()._eventStatus.set(eS.getBytes());
                cv.set(v);
                eS.set(this.getTdd()._eventStatus.getBytes());
            }
        }
    }

    private void setEventData2OfEventStatus(ICobolVar eS, int v) {
        if (eS != null) {
            NumericVar cv = this.getTdd()._eventData2;
            if (eS.getLength() >= 24) {
                this.getTdd()._eventStatus.set(eS.getBytes());
                cv.set(v);
                eS.set(this.getTdd()._eventStatus.getBytes());
            }
        }
    }

    private void setEventWindowHandleOfEventStatus(ICobolVar eS, Object o) {
        if (eS != null) {
            ObjectVar cv = this.getTdd()._eventWindowHandle;
            if (eS.getLength() >= 8) {
                this.getTdd()._eventStatus.set(eS.getBytes());
                this.setObjectVar(o, cv);
                eS.set(this.getTdd()._eventStatus.getBytes());
            }
        }
    }

    private void setEventControlHandleOfEventStatus(ICobolVar eS, Object o) {
        if (eS != null) {
            ObjectVar cv = this.getTdd()._eventControlHandle;
            if (eS.getLength() >= 12) {
                this.getTdd()._eventStatus.set(eS.getBytes());
                this.setObjectVar(o, cv);
                eS.set(this.getTdd()._eventStatus.getBytes());
            }
        }
    }

    private void saveEventStatus(ICobolVar eS) {
        if (eS != null) {
            ThreadDependentData.access$2002(this.getTdd(), CobolGUIEnvironment.saveMem(eS));
        } else {
            ThreadDependentData.access$2002(this.getTdd(), null);
        }
    }

    private void restoreEventStatus(ICobolVar eS) {
        if (eS != null && this.getTdd()._eventStatusSave != null) {
            eS.set(this.getTdd()._eventStatusSave);
            ThreadDependentData.access$2002(this.getTdd(), null);
        }
    }

    private boolean getAcceptControlExcpValue(ICobolVar sC, BaseGUIControl acceptbgc) {
        boolean Return2 = false;
        if (sC != null && acceptbgc != null && acceptbgc.isScreenSectionVar()) {
            NumericVar cv = this.getTdd()._acceptControlOfScreenControl;
            if ((this.getTdd()._screenControlLength = sC.getLength()) >= 1) {
                this.getTdd()._screenControl.set(sC.getBytes());
                if (cv.toint() == 3) {
                    Return2 = true;
                }
            }
        }
        return Return2;
    }

    private boolean getAcceptControlTermValue(ICobolVar sC, BaseGUIControl acceptbgc) {
        boolean Return2 = false;
        if (sC != null && acceptbgc != null && acceptbgc.isScreenSectionVar()) {
            NumericVar cv = this.getTdd()._acceptControlOfScreenControl;
            if ((this.getTdd()._screenControlLength = sC.getLength()) >= 1) {
                this.getTdd()._screenControl.set(sC.getBytes());
                if (cv.toint() == 2) {
                    Return2 = true;
                }
            }
        }
        return Return2;
    }

    public synchronized boolean isAcceptTerminated(CobolVar ks, CobolVar sC, CobolVar eS, BeanContainer beanCtn, CobolRecordAccept cra, boolean isAcceptOnException) {
        return this.isAcceptTerminated((ICobolVar)ks, (ICobolVar)sC, (ICobolVar)eS, beanCtn, cra, isAcceptOnException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isAcceptTerminated(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, CobolRecordAccept cra, boolean isAcceptOnException) {
        boolean Return2 = false;
        if (cra.getRecordType() == 25 || cra.getRecordType() == 26) {
            return Return2;
        }
        if (cra.getRecordType() != 13) {
            boolean bl = Return2 = (cra.getRecordType() == 14 || cra.getTerminationGenerated() || this.getAcceptControlTermValue(sC, cra.getAcceptBGC())) && this.getEventActionOfEventStatus(eS, cra) != 2;
            if (cra.getControl() != null && cra.getControl().getIsControlEditor()) {
                Return2 = false;
            }
            if (Return2 && cra.isException() && !cra.isTabChangedEvent() && !cra.isEventFromThread() && cra.getKeyStatus() != 97 && !isAcceptOnException) {
                Return2 = false;
            }
            if (!(Return2 || cra.getRecordType() != 12 && cra.getRecordType() != 27)) {
                Return2 = true;
            }
            if (Return2 && !cra.isEvent() && !cra.isException() || !cra.isException() && !cra.getExceptionGenerated()) {
                cra.setCobolScreenControlInterface(this, sC);
            }
            cra.setCobolCrtStatusInterface(this, ks);
            if (Return2) {
                DisplayWindow dw = this.getInputWindow();
                Vector vector = this.windowWait;
                synchronized (vector) {
                    ParamVector paramCSWindow = dw.getParamCSWindow();
                    this.getAllData(cra, dw);
                    paramCSWindow.addElement(new ParamElementIntBoolean(2049, 0, false));
                    Vector disableInputVect = new Vector();
                    if (cra.getAcceptBGC() != null && dw != null) {
                        dw.disableInput(cra.getAcceptBGC(), disableInputVect);
                    }
                    if (cra.getWindow() != null) {
                        cra.getWindow().setActiveControl(null);
                        if (cra.getWindow() != dw) {
                            try {
                                cra.getWindow().getComponent().clearFocusOwner();
                            }
                            catch (IOException _re) {
                                ScreenUtility.handleIOException(_re);
                            }
                        } else {
                            paramCSWindow.addElement(new ParamVElement(2050));
                        }
                    }
                    dw.sendParams(paramCSWindow);
                    if (disableInputVect.size() > 0) {
                        dw.removeServerObjectIO(disableInputVect);
                    }
                    dw.setCasdestroy(null);
                    dw.setAllData(null);
                    dw.setTimeout(-1L);
                    dw.setActiveAccept(false);
                    if (this.getAcceptControlTermValue(sC, cra.getAcceptBGC())) {
                        this.setAcceptControlOfScreenControl(sC, 0, cra.getAcceptBGC());
                    }
                }
                this.getTdd()._execAcceptStatement = false;
            }
        }
        if (cra.getResponse()) {
            cra.responseClient();
        }
        if (Return2) {
            this.restoreEventStatus(eS);
        }
        return Return2;
    }

    public synchronized void manageAcceptException(CobolVar ks, CobolVar sC, CobolVar eS, BeanContainer beanCtn, CobolRecordAccept cra, boolean isonexcp) throws AcceptException {
        this.manageAcceptException((ICobolVar)ks, (ICobolVar)sC, (ICobolVar)eS, beanCtn, cra, isonexcp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void manageAcceptException(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, CobolRecordAccept cra, boolean isonexcp) throws AcceptException {
        if (cra.getRecordType() == 13 || cra.getRecordType() == 27 || cra.getRecordType() == 14 || cra.getRecordType() == 26) {
            return;
        }
        if (cra.getControl() != null && cra.getControl().getIsControlEditor() && !cra.getControl().isSelfAct()) {
            return;
        }
        if (isonexcp && cra.getRecordType() == 25) {
            cra.setCobolCrtStatusInterface(this, ks);
            throw new AcceptException(cra.getKeyStatus());
        }
        if (isonexcp && (this.getAcceptControlExcpValue(sC, cra.getAcceptBGC()) || cra.isException() || cra.getExceptionGenerated() || cra.getRecordType() == 12)) {
            DisplayWindow dw;
            cra.setCobolCrtStatusInterface(this, ks, !cra.isException());
            if (!cra.isException()) {
                cra.setCobolScreenControlInterface(this, sC);
            }
            if ((dw = this.getInputWindow()) != null && !dw.isDestroyed()) {
                Vector vector = this.windowWait;
                synchronized (vector) {
                    ParamVector paramCSWindow = dw.getParamCSWindow();
                    if (cra != null && cra.getAcceptBGC() != null && cra.getAcceptBGC().getComponentType() == 0) {
                        dw.setAllData(null);
                    }
                    boolean setalsocracontrol = this.getAllData(cra, dw);
                    paramCSWindow.addElement(new ParamElementIntBoolean(2049, 0, false));
                    BaseGUIControl bgc = cra.getControl();
                    if (bgc != null && bgc.isValid()) {
                        String val = null;
                        BaseGUIControl.MyString[] tmp = new BaseGUIControl.MyString[1];
                        val = !setalsocracontrol ? bgc.getAllData(tmp) : bgc.analyzeData(tmp);
                        if (bgc.hasRefreshDisplayedValue() && val != null && tmp[0] != null && cra.getEventType() != 4100) {
                            bgc.refreshDisplayedValue(val, tmp[0], dw.getParamCSWindow());
                        }
                    }
                    Vector disableInputVect = new Vector();
                    if (cra.getAcceptBGC() != null && dw != null) {
                        dw.disableInput(cra.getAcceptBGC(), disableInputVect);
                    }
                    if (cra.getResponse()) {
                        cra.responseClient();
                    }
                    if (cra.getWindow() != null) {
                        cra.getWindow().setActiveControl(null);
                        if (cra.getWindow() != dw) {
                            if (cra.getWindow().getComponent() != null) {
                                try {
                                    cra.getWindow().getComponent().clearFocusOwner();
                                }
                                catch (IOException _re) {
                                    ScreenUtility.handleIOException(_re);
                                }
                            }
                        } else {
                            paramCSWindow.addElement(new ParamVElement(2050));
                        }
                    }
                    dw.sendParams(paramCSWindow);
                    if (disableInputVect.size() > 0) {
                        dw.removeServerObjectIO(disableInputVect);
                    }
                    this.restoreEventStatus(eS);
                    dw.setCasdestroy(null);
                    dw.setAllData(null);
                    dw.setTimeout(-1L);
                    dw.setActiveAccept(false);
                }
            }
            this.getTdd()._execAcceptStatement = false;
            throw new AcceptException(cra.getKeyStatus());
        }
    }

    public void debugStack() {
        this.acceptStack.debug();
    }

    public void setCobolEnv(CobolVar ks, CobolVar sC, CobolRecordAccept cra) {
        this.setCobolEnv((ICobolVar)ks, (ICobolVar)sC, cra);
    }

    public void setCobolEnv(ICobolVar ks, ICobolVar sC, CobolRecordAccept cra) {
        cra.setCobolCrtStatusInterface(this, ks);
        cra.setCobolScreenControlInterface(this, sC);
    }

    public CobolGUIEnvironment eraseScreen() {
        return this;
    }

    public CobolGUIEnvironment getEscapeKey(CobolVar k) {
        return this.getEscapeKey((ICobolVar)k);
    }

    public CobolGUIEnvironment getEscapeKey(ICobolVar k) {
        k.set(this.getTdd()._escapeKey);
        return this;
    }

    public SubWindow getSubWindow(String ov) {
        DisplayWindow go = this.getCurrentWindow();
        return go.currentSW;
    }

    public BaseGUIWindow displayTitle(String s, CobolVar id) {
        return this.displayTitle(s, (ICobolVar)id);
    }

    public BaseGUIWindow displayTitle(String s, ICobolVar id) {
        DisplayWindow go = this.getCurrentWindow();
        return this.displayTitle(s, id, go);
    }

    public BaseGUIWindow displayTitle(String s, CobolVar id, NumericVar ov) {
        return this.displayTitle(s, (ICobolVar)id, (INumericVar)ov);
    }

    public BaseGUIWindow displayTitle(String s, ICobolVar id, INumericVar ov) {
        DisplayWindow go = (DisplayWindow)ov.getOId();
        if (go != null) {
            return this.displayTitle(s, id, go);
        }
        Factory.throwInvalidHandle(ov.getName());
        return NullWindow.getInstance();
    }

    public BaseGUIWindow displayTitle(String s, CobolVar id, CobolVar cv) {
        return this.displayTitle(s, (ICobolVar)id, (ICobolVar)cv);
    }

    public BaseGUIWindow displayTitle(String s, ICobolVar id, ICobolVar cv) {
        int index;
        Object o;
        DisplayWindow go = null;
        if (cv != null && (o = UserHandles.getId(index = cv.toint())) != null) {
            if (o instanceof DisplayWindow) {
                go = (DisplayWindow)o;
            } else if (o instanceof SubWindow) {
                go = ((SubWindow)o).getParentWnd();
            }
        }
        if (go != null) {
            return this.displayTitle(s, id, go);
        }
        Factory.throwInvalidHandle(cv.getName());
        return NullWindow.getInstance();
    }

    public BaseGUIWindow displayTitle(String s, CobolVar id, DisplayWindow dw) {
        return this.displayTitle(s, (ICobolVar)id, dw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow displayTitle(String s, ICobolVar id, DisplayWindow dw) {
        if (s != null && s.equalsIgnoreCase("GLOBAL") && dw != null && !dw.isMainApplicationWindow()) {
            Object[] ctl = this.windowList.toArray();
            for (int i = 0; i < ctl.length; ++i) {
                if (ctl[i] == null) continue;
                Object object = ctl[i];
                synchronized (object) {
                    if (ctl[i] instanceof DisplayWindow && ((DisplayWindow)ctl[i]).isMainApplicationWindow()) {
                        dw = (DisplayWindow)ctl[i];
                        break;
                    }
                    continue;
                }
            }
        }
        dw.modifyTitle(id).endModify();
        return dw;
    }

    public BaseGUIWindow setScreenSize(int size) {
        return this.setScreenSize(size, false);
    }

    public BaseGUIWindow setScreenSize(int size, boolean isonexcp) throws DisplayException {
        if (isonexcp) {
            String is132 = Config.getProperty("iscobol.terminal.info.132column", "N");
            if (size == 80 && is132 != null && Config.isTrue(is132) || size == 132 && is132 != null && !Config.isTrue(is132)) {
                throw new DisplayException(1);
            }
        }
        DisplayWindow go = this.getOutputWindow();
        go.setScreenSize(size);
        return go;
    }

    public void acceptFromTerminalInfo(CobolVar dest) {
        this.acceptFromTerminalInfo((ICobolVar)dest);
    }

    public void acceptFromTerminalInfo(ICobolVar dest) {
        PicX TERMINAL_ABILITIES = Factory.getVarAlphanum(Factory.getMem(120), 0, 120, false, null, null, null, "TERMINAL-ABILITIES", true, false);
        PicX TERMINAL_NAME = Factory.getVarAlphanum(TERMINAL_ABILITIES, 0, 10, false, null, null, null, "TERMINAL-NAME", true, false);
        PicX FILLER = Factory.getVarAlphanum(TERMINAL_ABILITIES, 10, 1, false, null, null, null, "FILLER", true, false);
        PicX FILLER$1 = Factory.getVarAlphanum(TERMINAL_ABILITIES, 11, 1, false, null, null, null, "FILLER", true, false);
        PicX FILLER$2 = Factory.getVarAlphanum(TERMINAL_ABILITIES, 12, 1, false, null, null, null, "FILLER", true, false);
        PicX FILLER$3 = Factory.getVarAlphanum(TERMINAL_ABILITIES, 13, 1, false, null, null, null, "FILLER", true, false);
        PicX FILLER$4 = Factory.getVarAlphanum(TERMINAL_ABILITIES, 14, 1, false, null, null, null, "FILLER", true, false);
        PicX FILLER$5 = Factory.getVarAlphanum(TERMINAL_ABILITIES, 15, 1, false, null, null, null, "FILLER", true, false);
        PicX FILLER$6 = Factory.getVarAlphanum(TERMINAL_ABILITIES, 16, 1, false, null, null, null, "FILLER", true, false);
        NumericVar NUMBER_OF_SCREEN_LINES = Factory.getVarDisplayAcu(TERMINAL_ABILITIES, 17, 3, false, null, null, null, "NUMBER-OF-SCREEN-LINES", true, 3, 0, false, false, false);
        NumericVar NUMBER_OF_SCREEN_COLUMNS = Factory.getVarDisplayAcu(TERMINAL_ABILITIES, 20, 3, false, null, null, null, "NUMBER-OF-SCREEN-COLUMNS", true, 3, 0, false, false, false);
        PicX FILLER$7 = Factory.getVarAlphanum(TERMINAL_ABILITIES, 23, 1, false, null, null, null, "FILLER", true, false);
        PicX FILLER$8 = Factory.getVarAlphanum(TERMINAL_ABILITIES, 24, 1, false, null, null, null, "FILLER", true, false);
        PicX FILLER$9 = Factory.getVarAlphanum(TERMINAL_ABILITIES, 25, 1, false, null, null, null, "FILLER", true, false);
        NumericVar USABLE_SCREEN_HEIGHT = Factory.getVarCompX(TERMINAL_ABILITIES, 26, 2, false, null, null, null, "USABLE-SCREEN-HEIGHT", true, 2, 0, false, false, false);
        NumericVar USABLE_SCREEN_WIDTH = Factory.getVarCompX(TERMINAL_ABILITIES, 28, 2, false, null, null, null, "USABLE-SCREEN-WIDTH", true, 2, 0, false, false, false);
        NumericVar PHYSICAL_SCREEN_HEIGHT = Factory.getVarCompX(TERMINAL_ABILITIES, 30, 2, false, null, null, null, "PHYSICAL-SCREEN-HEIGHT", true, 2, 0, false, false, false);
        NumericVar PHYSICAL_SCREEN_WIDTH = Factory.getVarCompX(TERMINAL_ABILITIES, 32, 2, false, null, null, null, "PHYSICAL-SCREEN-WIDTH", true, 2, 0, false, false, false);
        PicX FILLER$10 = Factory.getVarAlphanum(TERMINAL_ABILITIES, 34, 1, false, null, null, null, "FILLER", true, false);
        PicX CLIENT_MACHINE_NAME = Factory.getVarAlphanum(TERMINAL_ABILITIES, 35, 64, false, null, null, null, "CLIENT-MACHINE-NAME", true, false);
        PicX FILLER$11 = Factory.getVarAlphanum(TERMINAL_ABILITIES, 99, 1, false, null, null, null, "FILLER", true, false);
        PicX CLIENT_USER_ID = Factory.getVarAlphanum(TERMINAL_ABILITIES, 100, 20, false, null, null, null, "CLIENT-USER-ID", true, false);
        TERMINAL_NAME.set(Config.getProperty("iscobol.terminal.info.name", "xterm"));
        FILLER.set(Config.getProperty("iscobol.terminal.info.reverse", "Y"));
        FILLER$1.set(Config.getProperty("iscobol.terminal.info.blink", "N"));
        FILLER$2.set(Config.getProperty("iscobol.terminal.info.underline", "Y"));
        FILLER$3.set(Config.getProperty("iscobol.terminal.info.dual_intensity", "Y"));
        FILLER$4.set(Config.getProperty("iscobol.terminal.info.132column", "N"));
        FILLER$5.set(Config.getProperty("iscobol.terminal.info.color", "Y"));
        FILLER$6.set(Config.getProperty("iscobol.terminal.info.drawing", "Y"));
        DisplayWindow currWindow = this.getCurrentWindow();
        int lines = 0;
        lines = currWindow != null ? (int)currWindow.getLines() : Config.getProperty("iscobol.terminal.info.screen.lines", 25);
        NUMBER_OF_SCREEN_LINES.set(lines, 0, false, false);
        int sizes = 0;
        sizes = currWindow != null ? (int)currWindow.getSizes() : Config.getProperty("iscobol.terminal.info.screen.columns", 80);
        NUMBER_OF_SCREEN_COLUMNS.set(sizes, 0, false, false);
        FILLER$7.set(Config.getProperty("iscobol.terminal.info.printer", "Y"));
        FILLER$8.set(Config.getProperty("iscobol.terminal.info.attributes", "Y"));
        boolean hasGraphInt = false;
        String hasGraphStr = Config.getProperty("iscobol.terminal.info.graphic", null);
        if (hasGraphStr != null) {
            hasGraphInt = Config.isTrue(hasGraphStr);
        } else {
            boolean bl = hasGraphInt = !GraphicsEnvironment.isHeadless();
        }
        if (hasGraphInt) {
            FILLER$9.set("Y");
        } else {
            FILLER$9.set("N");
        }
        int defScreenHeight = 56;
        int defScreenWidth = 80;
        int defUsableScreenHeight = 56;
        int defUsableScreenWidth = 80;
        int usableScreenH = Config.getProperty("iscobol.terminal.info.screen.usable.height", -1);
        int usableScreenW = Config.getProperty("iscobol.terminal.info.screen.usable.width", -1);
        boolean monitor_refresh = Config.getProperty("iscobol.terminal.info.refresh_monitor", false);
        if (hasGraphInt) {
            if (monitor_refresh || usableScreenH == -1 || usableScreenW == -1) {
                try {
                    GuiFactory gf = ScreenUtility.getGuiFactory();
                    Rectangle screenArea = null;
                    screenArea = gf.getScreenArea();
                    if (screenArea != null) {
                        if (monitor_refresh || usableScreenH == -1) {
                            defScreenHeight = screenArea.y;
                            usableScreenH = screenArea.height;
                            Config.setProperty("iscobol.terminal.info.screen.usable.height", String.valueOf(usableScreenH));
                            Config.setProperty("iscobol.terminal.info.screen.physical.height", String.valueOf(defScreenHeight));
                        }
                        if (monitor_refresh || usableScreenW == -1) {
                            defScreenWidth = screenArea.x;
                            usableScreenW = screenArea.width;
                            Config.setProperty("iscobol.terminal.info.screen.usable.width", String.valueOf(usableScreenW));
                            Config.setProperty("iscobol.terminal.info.screen.physical.width", String.valueOf(defScreenWidth));
                        }
                    }
                }
                catch (IOException _re) {
                    ScreenUtility.handleIOException(_re);
                }
            }
        } else {
            if (usableScreenH == -1) {
                usableScreenH = defUsableScreenHeight;
            }
            if (usableScreenW == -1) {
                usableScreenW = defUsableScreenWidth;
            }
        }
        USABLE_SCREEN_HEIGHT.set(usableScreenH, 0, false, false);
        USABLE_SCREEN_WIDTH.set(usableScreenW, 0, false, false);
        int phisicalScreenH = Config.getProperty("iscobol.terminal.info.screen.physical.height", defScreenHeight);
        PHYSICAL_SCREEN_HEIGHT.set(phisicalScreenH, 0, false, false);
        int phisicalScreenW = Config.getProperty("iscobol.terminal.info.screen.physical.width", defScreenWidth);
        PHYSICAL_SCREEN_WIDTH.set(phisicalScreenW, 0, false, false);
        ClientInfo ci = (ClientInfo)IscobolSystem.get(ClientInfo.class);
        FILLER$10.set(ci != null ? "Y" : "N");
        CLIENT_MACHINE_NAME.set(ci != null ? ci.getHostName() : "");
        CLIENT_USER_ID.set(ci != null ? ci.getUserName() : "");
        dest.set(TERMINAL_ABILITIES.getBytes());
    }

    void restoreVarInterface(ICobolVar ks, ICobolVar sC, ICobolVar eS, CobolRecordAccept cra, BaseGUIControl acceptbgc) {
        if (cra.getWindow() != null && cra.getWindow() instanceof DisplayWindow) {
            cra.getWindow().setEventActionOfEventStatus(this.getEventActionOfEventStatus(eS));
        }
    }

    public static CobolRecordAccept manageControlAccept(ICobolVar ks, ICobolVar sC, ICobolVar eS, CobolGUIEnvironment screenManager, CobolRecordAccept cra, boolean isonexcp, boolean disableEmbProc, BaseGUIControl acceptbgc) {
        return CobolGUIEnvironment.manageControlAccept(ks, sC, eS, screenManager, cra, isonexcp, disableEmbProc, acceptbgc, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CobolRecordAccept manageControlAccept(ICobolVar ks, ICobolVar sC, ICobolVar eS, CobolGUIEnvironment screenManager, CobolRecordAccept cra, boolean isonexcp, boolean disableEmbProc, BaseGUIControl acceptbgc, boolean dequeue) {
        ProcedureObject proc;
        if (cra != null && cra.getEventType() == 3) {
            screenManager.setCobolEnv(null, sC, cra);
        } else {
            screenManager.setCobolEnv(ks, sC, cra);
        }
        String hoteventprogname = null;
        if (cra != null) {
            hoteventprogname = CobolGUIEnvironment.getHotKeyOrEventProgram(screenManager, cra.getEventType());
        }
        if (!((proc = cra.getControl().getProc(cra)) == null && hoteventprogname == null || !cra.isEvent() && hoteventprogname == null)) {
            boolean haseventprocstandard = false;
            if (proc != null && cra.isEvent()) {
                haseventprocstandard = true;
            }
            screenManager.setEventActionOfEventStatus(eS, 0, cra);
            ICobolVar cv = proc.getEventStatus();
            if (cv != null && cv != eS) {
                cra.setCobolEventStatusInterface(screenManager, cv);
            }
            ICobolVar saveControlKey = null;
            if (cra.getWindow() != null) {
                saveControlKey = cra.getWindow().getControlKey();
                cra.getWindow().setAllData(null);
            }
            if (cra.isBeanEvent() && proc.getProgram() instanceof BeanContainer) {
                CobolGUIEnvironment.setJavaBeanSpecialNames(cra, (BeanContainer)proc.getProgram());
            }
            boolean b = screenManager.executingProc;
            screenManager.executingProc = true;
            int eventactionsetfromhotevent = -1;
            int eventtypesetfromhotevent = -1;
            boolean exitfromhoteventproc = false;
            if (hoteventprogname != null) {
                eventactionsetfromhotevent = screenManager.getEventActionOfEventStatus(eS);
                eventtypesetfromhotevent = screenManager.getEventTypeOfEventStatus(eS);
                screenManager.saveEventStatus(eS);
                exitfromhoteventproc = CobolGUIEnvironment.runHotEventProgram(screenManager, hoteventprogname, cra, eS, cra.getEventType());
                eventactionsetfromhotevent = screenManager.getEventActionOfEventStatus(eS);
                screenManager.restoreEventStatus(eS);
            }
            if (haseventprocstandard && !exitfromhoteventproc) {
                try {
                    proc.perform();
                }
                finally {
                    screenManager.executingProc = b;
                }
            }
            if (cra.getWindow() != null) {
                cra.getWindow().setControlKey(saveControlKey);
            }
            if (dequeue || screenManager.getEventActionOfEventStatus(eS) != 0) {
                screenManager.dequeueWindow(cra.getWindow());
            }
            cra.getControl().checkDestroyed(cra);
            screenManager.restoreVarInterface(ks, sC, eS, cra, acceptbgc);
            if (eventactionsetfromhotevent != -1 && screenManager.getEventActionOfEventStatus(eS) == 0) {
                screenManager.setEventActionOfEventStatus(eS, eventactionsetfromhotevent, cra);
                cra.setEventAction(eventactionsetfromhotevent);
            }
            if (screenManager.getEventActionOfEventStatus(eS) == 2) {
                return cra;
            }
        }
        if (screenManager.getEventActionOfEventStatus(eS) == 7 || screenManager.getEventActionOfEventStatus(eS) == 1) {
            screenManager.responseAccept(ks, sC, eS, null, cra);
            ThreadDependentData.access$2002(screenManager.getTdd(), null);
        }
        if (!cra.getControl().isTerminalEmulation() && cra.getControl().isDestroyed()) {
            CobolRecordAccept ret = screenManager.responseAcceptControl(ks, sC, cra, acceptbgc, cra.getControl(), null, true);
            BaseGUIControl isEventNewFocus = null;
            if (ret != null) {
                isEventNewFocus = ret.getNewControlWithFocus();
            }
            if (isEventNewFocus != null) {
                ret = CobolGUIEnvironment.manageBeforeEvent(ks, sC, eS, null, screenManager, isEventNewFocus, null, isonexcp, false, acceptbgc);
                if (cra != null && cra != ret) {
                    cra.responseClient();
                }
                return new CobolRecordAccept(13, 0, 0, cra.getControl(), false, false, true).setAcceptBGC(acceptbgc);
            }
        }
        if (!disableEmbProc && !cra.isTabChangedEvent() && (cra.isException() || cra.getExceptionGenerated())) {
            screenManager.setCobolEnv(ks, sC, cra);
            proc = cra.getControl().getExceptionProc(cra);
            screenManager.setAcceptControlOfScreenControl(sC, 0, acceptbgc);
            if (proc != null) {
                if (cra.isNTFEvent()) {
                    screenManager.setAcceptControlOfScreenControl(sC, 1, acceptbgc);
                }
                screenManager.getAllData(cra);
                DisplayWindow wnd = cra.getControl().getParentWindow();
                if (wnd != null) {
                    wnd.setExecutingExceptionProc(true);
                }
                ICobolVar saveControlKey = null;
                if (wnd != null) {
                    saveControlKey = wnd.getControlKey();
                    wnd.setAllData(null);
                }
                BaseGUIControl bgcparent = null;
                if (acceptbgc != null) {
                    bgcparent = acceptbgc.getCloneSource();
                }
                screenManager.getTdd()._execEmbeddedProc = true;
                proc.perform();
                screenManager.getTdd()._execEmbeddedProc = false;
                if (wnd != null) {
                    wnd.setControlKey(saveControlKey);
                }
                if (wnd != null) {
                    wnd.setExecutingExceptionProc(false);
                }
                if (CobolGUIEnvironment.checkIfDestroyed(wnd, acceptbgc)) {
                    if (acceptbgc.isDestroyed() && bgcparent != null && bgcparent.getLastClone() != null) {
                        acceptbgc = bgcparent.getLastClone();
                    }
                    CobolGUIEnvironment.reloadAcceptIfDestroyed(ks, sC, eS, wnd, acceptbgc);
                    screenManager.dequeueWindow(wnd);
                }
                screenManager.dequeueWindow(cra.getWindow());
                cra.getControl().checkDestroyed(cra);
                if (ks != null) {
                    cra.setKeyStatus(CobolGUIEnvironment.getKsInt(ks));
                }
                screenManager.restoreVarInterface(ks, sC, eS, cra, acceptbgc);
                CobolRecordAccept ret = screenManager.responseAcceptControl(ks, sC, cra, acceptbgc, null, null, true, true);
                BaseGUIControl isExcpNewFocus = null;
                if (ret != null) {
                    isExcpNewFocus = ret.getNewControlWithFocus();
                }
                if (isExcpNewFocus != null) {
                    ret = CobolGUIEnvironment.manageBeforeEvent(ks, sC, eS, null, screenManager, isExcpNewFocus, null, isonexcp, false, acceptbgc);
                    if (ret != null) {
                        if (cra != null && cra != ret) {
                            cra.responseClient();
                        }
                        return ret;
                    }
                    cra.setRecordType(13);
                } else if (ret != null) {
                    if (cra != null && cra != ret) {
                        cra.responseClient();
                    }
                    return ret;
                }
            }
        }
        return cra;
    }

    public static CobolRecordAccept manageWindowAccept(ICobolVar ks, ICobolVar sC, ICobolVar eS, CobolGUIEnvironment screenManager, CobolRecordAccept cra, boolean isonexcp, BaseGUIControl acceptbgc) {
        ProcedureObject proc = cra.getWindow().getProc(cra);
        if (proc != null) {
            ICobolVar cv = proc.getEventStatus();
            if (cv != null && cv != eS) {
                cra.setCobolEventStatusInterface(screenManager, cv);
            }
            ICobolVar saveControlKey = null;
            if (cra.getWindow() != null) {
                saveControlKey = cra.getWindow().getControlKey();
                cra.getWindow().setAllData(null);
            }
            proc.perform();
            if (cra.getWindow() != null) {
                cra.getWindow().setControlKey(saveControlKey);
            }
            screenManager.restoreVarInterface(ks, sC, eS, cra, acceptbgc);
            if (ks != null) {
                cra.setKeyStatus(CobolGUIEnvironment.getKsInt(ks));
            }
        }
        return cra;
    }

    private static int getKsInt(ICobolVar ks) {
        byte[] mem = null;
        int Return2 = 0;
        if (ks == null) {
            return Return2;
        }
        if (ks instanceof INumericVar) {
            Return2 = ks.toint();
        } else {
            mem = CobolGUIEnvironment.saveMem(ks);
            if (mem != null && mem.length > 2) {
                Return2 = new Integer(mem[2]);
            }
        }
        return Return2;
    }

    static CobolRecordAccept manageGotoFocusEvent(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, CobolGUIEnvironment screenManager, ChangeFocusEvent cfe, boolean isonexcp, boolean disableEmbProc, BaseGUIControl acceptbgc) {
        int acceptControl;
        DisplayWindow currWindow = cfe.getWindow();
        BaseGUIControl currentFocus = currWindow.getActiveControl();
        BaseGUIControl isAfterNewFocus = null;
        BaseGUIControl bgc = cfe.getControl();
        CobolRecordAccept cra = null;
        int terminationVal = cfe.getTerminationValue();
        int terminationValOrig = cfe.getTerminationValue();
        BaseGUIControl eventSrc = cfe.getEventSource();
        int ksint = CobolGUIEnvironment.getKsInt(ks);
        if (!disableEmbProc && currentFocus != null && currentFocus.hasAfterProc()) {
            int evtype = eS != null ? screenManager.getEventTypeOfEventStatus(eS) : 0;
            cra = new CobolRecordAccept(0, terminationVal != -1 ? terminationVal : 96, evtype, currentFocus, false, false, true).setAcceptBGC(acceptbgc);
            screenManager.setAcceptControlOfScreenControl(sC, 0, acceptbgc);
            cra.afterInitializeCSI(ks, sC, null, screenManager, acceptbgc);
            if (ks == null) {
                screenManager.getTdd()._escapeKey = 96;
            }
            ICobolVar saveControlKey = null;
            if (cra.getWindow() != null) {
                saveControlKey = cra.getWindow().getControlKey();
                cra.getWindow().getAllData(null, null);
            }
            screenManager.getTdd()._execEmbeddedProc = true;
            currentFocus.getAfterProc().perform();
            screenManager.getTdd()._execEmbeddedProc = false;
            if (cra.getWindow() != null) {
                cra.getWindow().setControlKey(saveControlKey);
            }
            ksint = CobolGUIEnvironment.getKsInt(ks);
            cra.setKeyStatus(terminationVal != -1 ? terminationVal : ksint);
            terminationVal = CobolGUIEnvironment.getKsInt(ks);
            CobolRecordAccept ret = screenManager.responseAcceptControl(ks, sC, cra, acceptbgc, null, null, true, true);
            isAfterNewFocus = null;
            if (ret != null) {
                CobolGUIEnvironment.restoreTabValue(cfe);
                isAfterNewFocus = ret.getNewControlWithFocus();
            }
            if (isAfterNewFocus != null) {
                if (cfe != null && cfe.getRecordType() == 9 && currWindow != null && eventSrc != null) {
                    eventSrc.skipNextClicked();
                }
                if ((ret = CobolGUIEnvironment.manageBeforeEvent(ks, sC, eS, beanCtn, screenManager, isAfterNewFocus, null, isonexcp, false, acceptbgc)) != null) {
                    return ret;
                }
                return new CobolRecordAccept(13, 0, 0, (BaseGUIControl)null, false, false, true).setAcceptBGC(acceptbgc);
            }
            if (ret != null) {
                return ret;
            }
        }
        if ((acceptControl = screenManager.getAcceptControlOfScreenControl(sC, acceptbgc)) == 2 || acceptControl == 3) {
            cra = new CobolRecordAccept(acceptControl == 2 ? 14 : 15, 0, 0, currentFocus, false, false, true).setAcceptBGC(acceptbgc);
            return cra;
        }
        if (cfe.getRecordType() == 10) {
            return new CobolRecordAccept(3, 99, 13, currWindow, true, true).setAcceptBGC(acceptbgc);
        }
        if (cfe.getRecordType() == 11) {
            if (screenManager.getAcceptControlOfScreenControl(sC, acceptbgc) == 0) {
                if (eventSrc != null) {
                    try {
                        cfe.getWindow().controlsetProp(eventSrc.getControlPeerServerId(), "RESTORE-VALUE", "1", 0);
                    }
                    catch (IOException _re) {
                        ScreenUtility.handleIOException(_re);
                    }
                }
                if (ks == null) {
                    ksint = 96;
                }
                return new CobolRecordAccept(4, ksint, 7, eventSrc != null ? eventSrc : bgc, cfe.getEventData1(), cfe.getEventData2(), true, true).setAcceptBGC(acceptbgc);
            }
        } else {
            CobolRecordAccept ret;
            if (cfe.getRecordType() == 12 || cfe.getRecordType() == 27) {
                BaseGUIControl bgctmp = null;
                if (cfe.getRecordType() == 27 && cfe.getCMD() != null && cfe.getCMD().getControl() != null && (bgctmp = (BaseGUIControl)ScreenUtility.stgetTransferFocusForward(cfe.getCMD().getControl(), true, false, true, false)) != null) {
                    ret = CobolGUIEnvironment.manageBeforeEvent(ks, sC, eS, beanCtn, screenManager, bgctmp, null, isonexcp, false, acceptbgc);
                    if (ret != null) {
                        return ret;
                    }
                    return new CobolRecordAccept(13, 0, 0, (BaseGUIControl)null, false, false, true).setAcceptBGC(acceptbgc);
                }
                bgctmp = cfe.getEventSource();
                if (bgctmp == null) {
                    bgctmp = bgc;
                }
                cra = new CobolRecordAccept(cfe.getRecordType(), 96, 3, bgctmp, false, false, false).setAcceptBGC(acceptbgc);
                cra.setCobolEventStatusInterface(screenManager, eS);
                cra = new CobolRecordAccept(cfe.getRecordType(), 96, 3, bgc, false, false, false).setAcceptBGC(acceptbgc);
                return cra;
            }
            if (bgc != null && bgc.getActiveAccept()) {
                if (!bgc.isTerminalEmulation() && bgc.isDestroyed()) {
                    return new CobolRecordAccept(13, 0, 0, (BaseGUIControl)null, false, false, true).setAcceptBGC(acceptbgc);
                }
                if (terminationValOrig < 0) {
                    BaseGUIControl bgccurrfocus = bgc;
                    if (bgc.isProtectedField()) {
                        bgc = currentFocus;
                        bgccurrfocus = null;
                    }
                    ret = null;
                    if (bgc != null && !bgc.getIsControlEditor()) {
                        ret = CobolGUIEnvironment.manageBeforeEvent(ks, sC, eS, beanCtn, screenManager, bgc, bgccurrfocus, isonexcp, disableEmbProc, acceptbgc, null, true, cfe.getRecordType() == 9);
                    }
                    if (ret != null) {
                        return ret;
                    }
                    CobolGUIEnvironment.manageDateEntryEvent(sC, screenManager, cfe, eventSrc, acceptbgc);
                    return new CobolRecordAccept(13, 0, 0, (BaseGUIControl)null, false, false, true).setAcceptBGC(acceptbgc);
                }
            }
        }
        CobolGUIEnvironment.manageDateEntryEvent(sC, screenManager, cfe, eventSrc, acceptbgc);
        if (terminationValOrig >= 0) {
            return new CobolRecordAccept(14, terminationVal, 0, currentFocus, true, false).setAcceptBGC(acceptbgc);
        }
        return new CobolRecordAccept(13, 0, 0, (BaseGUIControl)null, false, false, true).setAcceptBGC(acceptbgc);
    }

    static void manageDateEntryEvent(ICobolVar sC, CobolGUIEnvironment screenManager, ChangeFocusEvent cfe, BaseGUIControl eventSrc, BaseGUIControl acceptbgc) {
        if (cfe.getRecordType() == 23) {
            if (screenManager.getAcceptControlOfScreenControl(sC, acceptbgc) == 0 && eventSrc != null) {
                try {
                    cfe.getWindow().controlsetProp(eventSrc.getControlPeerServerId(), "OPEN-POPUP", "", 0);
                }
                catch (IOException _re) {
                    ScreenUtility.handleIOException(_re);
                }
            }
        } else if (cfe.getRecordType() == 24 && screenManager.getAcceptControlOfScreenControl(sC, acceptbgc) == 0 && eventSrc != null) {
            try {
                cfe.getWindow().controlsetProp(cfe.getEventSource().getControlPeerServerId(), "UPDATE-VALUE", "", 0);
            }
            catch (IOException _re) {
                ScreenUtility.handleIOException(_re);
            }
        }
    }

    static void restoreTabValue(ChangeFocusEvent cfe) {
        if (cfe.getWindow() != null && cfe.getRecordType() == 11 && cfe.getEventSource() != null && cfe.getEventSource() instanceof CobolGUITab) {
            try {
                cfe.getWindow().controlsetProp(cfe.getEventSource().getControlPeerServerId(), "RESTORE-VALUE", "0", 0);
                ((CobolGUITab)cfe.getEventSource()).setTabVAlueToSaveValue();
            }
            catch (IOException _re) {
                ScreenUtility.handleIOException(_re);
            }
        }
    }

    public static CobolRecordAccept manageBeforeEvent(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, CobolGUIEnvironment screenManager, BaseGUIControl bgc, BaseGUIControl currFocus, boolean isonexcp, boolean disableEmbProc, BaseGUIControl acceptbgc, boolean nextifdestroyed) {
        return CobolGUIEnvironment.manageBeforeEvent(ks, sC, eS, beanCtn, screenManager, bgc, currFocus, isonexcp, disableEmbProc, acceptbgc, null, nextifdestroyed, false);
    }

    public static CobolRecordAccept manageBeforeEvent(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, CobolGUIEnvironment screenManager, BaseGUIControl bgc, BaseGUIControl currFocus, boolean isonexcp, boolean disableEmbProc, BaseGUIControl acceptbgc) {
        return CobolGUIEnvironment.manageBeforeEvent(ks, sC, eS, beanCtn, screenManager, bgc, currFocus, isonexcp, disableEmbProc, acceptbgc, null, true, false);
    }

    public static CobolRecordAccept manageBeforeEvent(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, CobolGUIEnvironment screenManager, BaseGUIControl bgc, BaseGUIControl currFocus, boolean isonexcp, boolean disableEmbProc, BaseGUIControl acceptbgc, ParamVector param, boolean nextifdestroyed, boolean isgotoevent) {
        block30: {
            BaseGUIControl isBeforeNewFocus = null;
            DisplayWindow currWindow = (DisplayWindow)acceptbgc.getParentBGW();
            if (currWindow == null) {
                return new CobolRecordAccept(13, 0, 0, (BaseGUIControl)null, false, false, true).setAcceptBGC(acceptbgc);
            }
            currWindow.setBeginAccept(false);
            DisplayWindow containerW = currWindow;
            if (currWindow != null && currWindow instanceof DisplayToolBar) {
                containerW = ((DisplayToolBar)currWindow).getParentWindow();
            }
            DisplayWindow actWndTH = screenManager.getThreadActiveWindow();
            while (!disableEmbProc && bgc.hasBeforeProc()) {
                CobolRecordAccept cra = new CobolRecordAccept(0, ks != null ? CobolGUIEnvironment.getKsInt(ks) : 96, 0, bgc, false, false, true).setAcceptBGC(acceptbgc);
                screenManager.setAcceptControlOfScreenControl(sC, 0, acceptbgc);
                cra.beforeInitializeCSI(ks, sC, eS, screenManager, acceptbgc);
                currWindow.getAllData(null, null);
                ICobolVar saveControlKey = null;
                if (cra.getWindow() != null) {
                    saveControlKey = cra.getWindow().getControlKey();
                    cra.getWindow().setAllData(null);
                }
                screenManager.getTdd()._execEmbeddedProc = true;
                bgc.getBeforeProc().perform();
                screenManager.getTdd()._execEmbeddedProc = false;
                if (cra.getWindow() != null) {
                    cra.getWindow().setControlKey(saveControlKey);
                }
                if (ks != null) {
                    cra.setKeyStatus(CobolGUIEnvironment.getKsInt(ks));
                }
                if (CobolGUIEnvironment.checkIfDestroyed(cra.getWindow(), acceptbgc)) {
                    boolean firstcontrolisdestroyed = cra.getWindow().getFirstControl() != null && bgc == cra.getWindow().getFirstControl() && cra.getWindow().getFirstControl().isDestroyed();
                    CobolGUIEnvironment.reloadAcceptIfDestroyed(ks, sC, eS, cra.getWindow(), acceptbgc);
                    if (firstcontrolisdestroyed) {
                        bgc = cra.getWindow().getFirstControl();
                    }
                    screenManager.dequeueWindow(cra.getWindow());
                }
                if (acceptbgc != null && !acceptbgc.isTerminalEmulation() && acceptbgc.isDestroyed()) {
                    return new CobolRecordAccept(13, 0, 0, (BaseGUIControl)null, false, false, true).setAcceptBGC(acceptbgc);
                }
                CobolRecordAccept ret = screenManager.responseAcceptControl(ks, sC, cra, acceptbgc, bgc, currFocus, nextifdestroyed, true);
                isBeforeNewFocus = null;
                if (ret != null) {
                    isBeforeNewFocus = ret.getNewControlWithFocus();
                }
                if (isBeforeNewFocus != null) {
                    currWindow.setActiveControl(bgc);
                    bgc = isBeforeNewFocus;
                    continue;
                }
                if (ret != null) {
                    return ret;
                }
                if (containerW != null && !containerW.haveSameControlThread(screenManager._globActiveWindow) && !containerW.haveSameControlThread(actWndTH)) {
                    return null;
                }
                if (!bgc.getParentBGW().isBufferedWindowType() || param == null) {
                    screenManager.dequeueWindow(bgc.getParentBGW());
                }
                if (bgc == currFocus) {
                    if (bgc != currWindow.getActiveControl()) {
                        if (!currWindow.isBufferedWindowType()) {
                            currWindow.requestFocus(bgc);
                        } else {
                            currWindow.requestFocus(bgc, param);
                        }
                    }
                    currWindow.setActiveControl(bgc);
                } else {
                    currWindow.setActiveControl(null);
                    if (!currWindow.isBufferedWindowType()) {
                        currWindow.requestFocus(bgc);
                    } else {
                        currWindow.requestFocus(bgc, param);
                    }
                }
                break block30;
            }
            if (containerW != null && !containerW.haveSameControlThread(screenManager._globActiveWindow) && !containerW.haveSameControlThread(actWndTH)) {
                return null;
            }
            if (param == null && bgc != null) {
                if (bgc.getParentBGW() != null) {
                    screenManager.enqueueParams(bgc.getParentBGW());
                }
                if (bgc == null || currFocus == null || bgc != currFocus) {
                    screenManager.dequeueWindow(bgc.getParentBGW());
                }
            }
            if (bgc == currFocus) {
                if (!(bgc == currWindow.getActiveControl() || isgotoevent && bgc instanceof CobolGUIComboBox)) {
                    if (!currWindow.isBufferedWindowType()) {
                        currWindow.requestFocus(bgc);
                    } else {
                        currWindow.requestFocus(bgc, param);
                    }
                }
                currWindow.setActiveControl(bgc);
            } else {
                currWindow.setActiveControl(null);
                currWindow.requestFocus(bgc, param);
            }
        }
        return null;
    }

    public static CobolRecordAccept prepareCra(CobolRecordAccept cra, BaseGUIControl acceptbgc) {
        CobolRecordAccept Return2 = cra;
        switch (cra.getRecordType()) {
            case 16: {
                Return2 = cra.getControl().controlEvent(cra);
                break;
            }
            case 19: 
            case 21: {
                Return2 = cra.getWindow().windowEvent(cra);
            }
        }
        if (Return2 == null) {
            Return2 = new CobolRecordAccept(13, 0, 0, (BaseGUIControl)null, false, false, true);
        }
        Return2.setAcceptBGC(acceptbgc);
        return Return2;
    }

    static CobolRecordAccept manageTuboEvent(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, CobolGUIEnvironment screenManager, ChangeFocusEvent cfe, boolean isonexcp, boolean disableEmbProc, BaseGUIControl acceptbgc) {
        boolean callValidate = false;
        DisplayWindow currWindow = cfe.getWindow();
        BaseGUIControl currentFocus = currWindow.getActiveControl();
        BaseGUIControl.MyString[] tmp = new BaseGUIControl.MyString[1];
        String val = null;
        try {
            CobolRecordAccept cra;
            switch (cfe.getRecordType()) {
                case 8: {
                    if (!VirtualKeyboard.isScreenEditing(cfe.getCobFun()) && !VirtualKeyboard.isTermination(cfe.getCobFun())) break;
                    callValidate = true;
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 23: 
                case 24: {
                    callValidate = true;
                    break;
                }
                case 12: 
                case 27: {
                    callValidate = true;
                }
            }
            if (cfe.getRecordType() != 8 && (cra = cfe.getCMD()) != null) {
                cra = CobolGUIEnvironment.manageAcceptBody(ks, sC, eS, beanCtn, screenManager, cra, isonexcp, disableEmbProc, acceptbgc);
                cra.setAcceptBGC(acceptbgc);
                cra.setCobolCrtStatusInterface(screenManager, ks);
                if (cra.getControl() != null && !cra.getControl().isTerminalEmulation() && cra.getControl().isDestroyed()) {
                    return cra;
                }
                if (screenManager.getEventActionOfEventStatus(eS) == 2) {
                    if (cfe.getRecordType() == 11) {
                        if (cfe.getEventSource() != null) {
                            try {
                                cfe.getWindow().controlsetProp(cfe.getEventSource().getControlPeerServerId(), "RESTORE-VALUE", "1", 0);
                            }
                            catch (IOException _re) {
                                ScreenUtility.handleIOException(_re);
                            }
                        }
                    } else {
                        if (cfe.getRecordType() == 9) {
                            return CobolGUIEnvironment.manageGotoFocusEvent(ks, sC, eS, beanCtn, screenManager, cfe, isonexcp, disableEmbProc, acceptbgc);
                        }
                        CobolGUIEnvironment.manageDateEntryEvent(sC, screenManager, cfe, cfe.getEventSource(), acceptbgc);
                    }
                    return new CobolRecordAccept(13, 0, 0, (BaseGUIControl)null, false, false, true).setAcceptBGC(acceptbgc);
                }
            }
            if (callValidate && currentFocus != null && currentFocus.isValidRemoteControl() && currentFocus.controlPeerisEnabled() && !currentFocus.isExcludeEventMSG_VALIDATE()) {
                val = currentFocus.getAllData(tmp);
                if (currentFocus.hasEventProc()) {
                    CobolRecordAccept craval = new CobolRecordAccept(7, 96, 16391, currentFocus, false, false, true).setAcceptBGC(acceptbgc);
                    craval.setAcceptBGC(acceptbgc);
                    if (ks != null) {
                        craval.setKeyStatus(CobolGUIEnvironment.getKsInt(ks));
                    }
                    screenManager.saveEventStatus(eS);
                    craval = CobolGUIEnvironment.manageAcceptBody(ks, sC, eS, beanCtn, screenManager, craval, isonexcp, disableEmbProc, acceptbgc);
                    if (screenManager.getEventActionOfEventStatus(eS) == 2) {
                        CobolGUIEnvironment.restoreTabValue(cfe);
                        if (currentFocus != null) {
                            currentFocus.controlPeerrequestFocus(currentFocus.getControlPeerServerId());
                        }
                        screenManager.restoreEventStatus(eS);
                        return new CobolRecordAccept(13, 0, 0, (BaseGUIControl)null, false, false, true).setAcceptBGC(acceptbgc);
                    }
                    screenManager.restoreEventStatus(eS);
                }
            }
            if (callValidate && (currentFocus != null && currentFocus.isValidRemoteControl() && currentFocus.controlPeerisEnabled() || cfe.getAfterTermination()) && val != null && tmp[0] != null) {
                currentFocus.refreshDisplayedValue(val, tmp[0], currWindow.getParamCSWindow());
            }
            cfe.setValidateOk(true);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return cfe;
    }

    static CobolRecordAccept manageChangeFocusEvent(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, CobolGUIEnvironment screenManager, ChangeFocusEvent cfe, boolean isonexcp, boolean disableEmbProc, BaseGUIControl acceptbgc) {
        switch (cfe.getRecordType()) {
            case 8: {
                return CobolGUIEnvironment.manageKeyPressedEvent(ks, sC, eS, beanCtn, screenManager, cfe, isonexcp, disableEmbProc, acceptbgc);
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 23: 
            case 24: 
            case 27: {
                return CobolGUIEnvironment.manageGotoFocusEvent(ks, sC, eS, beanCtn, screenManager, cfe, isonexcp, disableEmbProc, acceptbgc);
            }
        }
        return null;
    }

    static CobolRecordAccept manageKeyPressedEvent(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, CobolGUIEnvironment screenManager, ChangeFocusEvent cfe, boolean isonexcp, boolean disableEmbProc, BaseGUIControl acceptbgc) {
        int acceptControl;
        boolean handleTermination = true;
        DisplayWindow currWindow = cfe.getWindow();
        BaseGUIControl currentFocus = cfe.getControl();
        int cobFun = cfe.getCobFun();
        boolean isValidateOk = cfe.isValidateOk();
        boolean isediting = VirtualKeyboard.isScreenEditing(cobFun);
        boolean istermination = VirtualKeyboard.isTermination(cobFun);
        boolean isexception = VirtualKeyboard.isException(cobFun);
        int termination = VirtualKeyboard.termination(cobFun);
        int exception = VirtualKeyboard.exception(cobFun);
        int editing = VirtualKeyboard.editing(cobFun);
        boolean wrap = !istermination && !isexception;
        BaseGUIControl isAfterNewFocus = null;
        CobolRecordAccept cra = null;
        if ((isediting || istermination) && currentFocus != null && !disableEmbProc && currentFocus.hasAfterProc()) {
            int ksValue = 0;
            if (istermination) {
                ksValue = termination;
            } else if (isexception) {
                ksValue = exception;
            }
            cra = new CobolRecordAccept(14, cfe.isAuto() ? Config.getProperty("iscobol.keyboard.kbd_auto_return", 0) : ksValue, 0, currentFocus, false, false, true).setAcceptBGC(acceptbgc);
            cra.initializeCobolScreenInterface(ks, sC, eS, screenManager);
            ICobolVar saveControlKey = null;
            if (cra.getWindow() != null) {
                saveControlKey = cra.getWindow().getControlKey();
                cra.getWindow().getAllData(null, null);
            }
            screenManager.getTdd()._execEmbeddedProc = true;
            currentFocus.getAfterProc().perform();
            screenManager.getTdd()._execEmbeddedProc = false;
            if (cra.getWindow() != null) {
                cra.getWindow().setControlKey(saveControlKey);
            }
            if (ks != null) {
                cra.setKeyStatus(CobolGUIEnvironment.getKsInt(ks));
            }
            CobolRecordAccept ret = screenManager.responseAcceptControl(ks, sC, cra, acceptbgc, currentFocus, null, true, true);
            isAfterNewFocus = null;
            if (ret != null) {
                isAfterNewFocus = ret.getNewControlWithFocus();
            }
            if (currentFocus.isScreenEditTerminalEmulation() || !currentFocus.isDestroyed()) {
                if (isAfterNewFocus != null) {
                    ret = CobolGUIEnvironment.manageBeforeEvent(ks, sC, eS, beanCtn, screenManager, isAfterNewFocus, null, isonexcp, false, acceptbgc);
                    if (ret != null) {
                        return ret;
                    }
                    cra.setRecordType(13);
                    return cra;
                }
                if (ret != null) {
                    return ret;
                }
            } else {
                boolean next = false;
                if (isediting && isAfterNewFocus != null) {
                    switch (editing) {
                        case 196608: 
                        case 393216: {
                            next = true;
                        }
                        case 262144: 
                        case 327680: {
                            CobolRecordAccept rett;
                            if (next && currentFocus.getScreenCntrlVal() < isAfterNewFocus.getScreenCntrlVal() || !next && currentFocus.getScreenCntrlVal() > isAfterNewFocus.getScreenCntrlVal()) {
                                handleTermination = false;
                            }
                            if ((rett = CobolGUIEnvironment.manageBeforeEvent(ks, sC, eS, beanCtn, screenManager, isAfterNewFocus, null, isonexcp, disableEmbProc, acceptbgc, next)) == null) break;
                            return rett;
                        }
                        case 65536: {
                            break;
                        }
                    }
                }
            }
        }
        if ((acceptControl = screenManager.getAcceptControlOfScreenControl(sC, acceptbgc)) != 2 && acceptControl != 3) {
            BaseGUIControl bgctemp = null;
            boolean next = false;
            boolean vtab = true;
            boolean firstlast = false;
            if (isediting) {
                switch (editing) {
                    case 65536: 
                    case 131072: {
                        if (firstlast_on_screen) {
                            firstlast = true;
                        }
                    }
                    case 196608: 
                    case 393216: 
                    case 655360: {
                        if (!firstlast) {
                            next = true;
                        }
                    }
                    case 262144: 
                    case 327680: 
                    case 589824: {
                        if (isValidateOk) {
                            if (isAfterNewFocus == null && acceptbgc != null && acceptbgc.childGraphics != null && acceptbgc.childGraphics.size() > 0) {
                                CobolRecordAccept ret;
                                Dimension charDim;
                                if (firstlast) {
                                    if (editing == 65536) {
                                        bgctemp = (BaseGUIControl)ScreenUtility.stgetFirstInputField(currentFocus);
                                    } else if (editing == 131072) {
                                        bgctemp = (BaseGUIControl)ScreenUtility.stgetLastInputField(currentFocus);
                                    }
                                } else if (next) {
                                    if (!updown_like_prevnext && editing == 393216) {
                                        charDim = null;
                                        int rbgcX = 0;
                                        if (currentFocus.isScreenEditTerminalEmulation()) {
                                            rbgcX = cfe.getCursor() & 0xFFFF;
                                            charDim = cfe.getWindow().getCharDim();
                                            if (charDim != null) {
                                                rbgcX *= charDim.width;
                                            }
                                        } else {
                                            rbgcX += currentFocus.getX();
                                        }
                                        if ((bgctemp = (BaseGUIControl)ScreenUtility.getDown(currentFocus.getParentBGW().getCurrChildsActiveAccept(), currentFocus, rbgcX, currentFocus.getY())) != null && bgctemp.isScreenEditTerminalEmulation() && charDim != null && charDim.width > 0 && bgctemp.getX() < rbgcX) {
                                            int colcursor = rbgcX - bgctemp.getX();
                                            int val = 0x100000;
                                            currentFocus.getParentBGW().getParamCSWindow().add(new ParamElementInt(2044, val += (colcursor /= charDim.width) + bgctemp.getX() / charDim.width));
                                            currentFocus.getParentBGW().enqueueParams(currentFocus.getParentBGW().getParamCSWindow());
                                        }
                                    } else {
                                        if (updown_like_prevnext) {
                                            vtab = editing == 196608;
                                        }
                                        bgctemp = (BaseGUIControl)ScreenUtility.stgetTransferFocusForward(currentFocus, true, wrap, vtab, false);
                                    }
                                } else if (!updown_like_prevnext && editing == 327680) {
                                    charDim = null;
                                    int rbgcX = 0;
                                    if (currentFocus.isScreenEditTerminalEmulation()) {
                                        rbgcX = cfe.getCursor() & 0xFFFF;
                                        charDim = cfe.getWindow().getCharDim();
                                        if (charDim != null) {
                                            rbgcX *= charDim.width;
                                        }
                                    } else {
                                        rbgcX += currentFocus.getX();
                                    }
                                    if ((bgctemp = (BaseGUIControl)ScreenUtility.getUp(currentFocus.getParentBGW().getCurrChildsActiveAccept(), currentFocus, rbgcX, currentFocus.getY())) != null && bgctemp.isScreenEditTerminalEmulation() && charDim != null && charDim.width > 0 && bgctemp.getX() < rbgcX) {
                                        int colcursor = rbgcX - bgctemp.getX();
                                        int val = (bgctemp.getY() + charDim.height) / charDim.height << 16;
                                        currentFocus.getParentBGW().getParamCSWindow().add(new ParamElementInt(2044, val += (colcursor /= charDim.width) + bgctemp.getX() / charDim.width));
                                        currentFocus.getParentBGW().enqueueParams(currentFocus.getParentBGW().getParamCSWindow());
                                    }
                                } else {
                                    if (updown_like_prevnext) {
                                        vtab = editing == 262144;
                                    }
                                    bgctemp = (BaseGUIControl)ScreenUtility.stgetTransferFocusBackward(currentFocus, true, wrap, vtab, false);
                                }
                                if (bgctemp != null) {
                                    handleTermination = false;
                                    ret = CobolGUIEnvironment.manageBeforeEvent(ks, sC, eS, beanCtn, screenManager, bgctemp, null, isonexcp, disableEmbProc, acceptbgc, next);
                                    if (ret == null) break;
                                    return ret;
                                }
                                if (!isexception) break;
                                if (!updown_like_prevnext) {
                                    if (editing == 196608 || editing == 262144) {
                                        bgctemp = next ? (BaseGUIControl)ScreenUtility.stgetTransferFocusForward(currentFocus, true, true, true, false) : (BaseGUIControl)ScreenUtility.stgetTransferFocusBackward(currentFocus, true, true, true, false);
                                    } else if (editing == 327680) {
                                        bgctemp = currentFocus;
                                    } else if (editing == 393216) {
                                        bgctemp = currentFocus;
                                    }
                                } else {
                                    bgctemp = next ? (BaseGUIControl)ScreenUtility.stgetTransferFocusForward(currentFocus, true, true, editing == 196608, false) : (BaseGUIControl)ScreenUtility.stgetTransferFocusBackward(currentFocus, true, true, editing == 262144, false);
                                }
                                if (!(isonexcp || exception != 52 && exception != 53)) {
                                    if (bgctemp != null && (ret = CobolGUIEnvironment.manageBeforeEvent(ks, sC, eS, beanCtn, screenManager, bgctemp, null, isonexcp, disableEmbProc, acceptbgc, next)) != null) {
                                        return ret;
                                    }
                                    handleTermination = false;
                                    break;
                                }
                                if (!(isonexcp || editing != 655360 && editing != 589824)) {
                                    istermination = false;
                                    isexception = false;
                                    break;
                                }
                                return new CobolRecordAccept(15, exception, 0, currWindow, true, true).setAcceptBGC(acceptbgc);
                            }
                            if (isAfterNewFocus != null || acceptbgc == null || acceptbgc.childGraphics != null && acceptbgc.childGraphics.size() != 0 || isonexcp || editing != 655360 && editing != 589824) break;
                            istermination = false;
                            isexception = false;
                            break;
                        }
                        currWindow.requestFocus(currentFocus);
                    }
                }
            }
        }
        if ((acceptControl = screenManager.getAcceptControlOfScreenControl(sC, acceptbgc)) == 2 || acceptControl == 3) {
            return new CobolRecordAccept(acceptControl == 2 ? 14 : 15, 0, 0, currentFocus, false, false, true).setAcceptBGC(acceptbgc);
        }
        if (handleTermination) {
            if (isexception) {
                return new CobolRecordAccept(15, exception, 0, currWindow, true, true).setAcceptBGC(acceptbgc);
            }
            if (istermination) {
                if (cra != null) {
                    termination = cra.getKeyStatus();
                }
                if (screenManager.getAcceptControlOfScreenControl(sC, acceptbgc) != 3) {
                    return new CobolRecordAccept(14, termination, 0, currentFocus, true, false).setAcceptBGC(acceptbgc).setAutoTermination(cfe != null ? cfe.isAuto() : false);
                }
            } else if (currentFocus instanceof CobolGUITerminalAccept || currentFocus instanceof CobolGUITerminalAcceptScreen) {
                currentFocus.getParentBGW().getParamCSWindow().add(new ParamElementIntInt(1063, currentFocus.getControlPeerServerId(), currentFocus.getControlPeerServerId()));
            }
        }
        return new CobolRecordAccept(13, 0, 0, (BaseGUIControl)null, false, false, true).setAcceptBGC(acceptbgc);
    }

    public static CobolRecordAccept manageCloseWindow(CobolVar ks, CobolVar sC, CobolVar eS, BeanContainer beanCtn, CobolGUIEnvironment screenManager, CobolRecordAccept cra, boolean isonexcp, boolean disableEmbProc, BaseGUIControl acceptbgc) {
        return CobolGUIEnvironment.manageCloseWindow((ICobolVar)ks, (ICobolVar)sC, (ICobolVar)eS, beanCtn, screenManager, cra, isonexcp, disableEmbProc, acceptbgc);
    }

    public static CobolRecordAccept manageCloseWindow(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, CobolGUIEnvironment screenManager, CobolRecordAccept cra, boolean isonexcp, boolean disableEmbProc, BaseGUIControl acceptbgc) {
        CobolRecordAccept Return2 = cra.getWindow().finishCloseCmd(cra, screenManager.getEventActionOfEventStatus(eS));
        Return2 = Return2 != null ? CobolGUIEnvironment.manageAcceptBody(ks, sC, eS, beanCtn, screenManager, Return2, isonexcp, disableEmbProc, acceptbgc) : new CobolRecordAccept(13, 0, 0, (BaseGUIControl)null, false, false, true).setAcceptBGC(acceptbgc);
        return Return2;
    }

    public static CobolRecordAccept manageAccept(CobolVar ks, CobolVar sC, CobolVar eS, BeanContainer beanCtn, CobolGUIEnvironment screenManager, CobolRecordAccept cra, boolean isonexcp, boolean disableEmbProc) {
        return CobolGUIEnvironment.manageAccept((ICobolVar)ks, (ICobolVar)sC, (ICobolVar)eS, beanCtn, screenManager, cra, isonexcp, disableEmbProc);
    }

    public static CobolRecordAccept manageAccept(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, CobolGUIEnvironment screenManager, CobolRecordAccept cra, boolean isonexcp, boolean disableEmbProc) {
        return CobolGUIEnvironment.manageAccept(ks, sC, eS, beanCtn, screenManager, cra, isonexcp, disableEmbProc, true);
    }

    public static CobolRecordAccept manageAccept(CobolVar ks, CobolVar sC, CobolVar eS, BeanContainer beanCtn, CobolGUIEnvironment screenManager, CobolRecordAccept cra, boolean isonexcp, boolean disableEmbProc, boolean dequeue) {
        return CobolGUIEnvironment.manageAccept((ICobolVar)ks, (ICobolVar)sC, (ICobolVar)eS, beanCtn, screenManager, cra, isonexcp, disableEmbProc, dequeue);
    }

    public static CobolRecordAccept manageAccept(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, CobolGUIEnvironment screenManager, CobolRecordAccept cra, boolean isonexcp, boolean disableEmbProc, boolean dequeue) {
        block16: {
            boolean isclosecontrol;
            block15: {
                if (cra.getRecordType() == 26) {
                    return cra;
                }
                if (cra.getRecordType() == 25 || cra.getRecordType() == 15 && screenManager.getAcceptControlExcpValue(sC, cra.getAcceptBGC())) {
                    return cra;
                }
                boolean isclosewindow = false;
                isclosecontrol = false;
                screenManager.setAcceptControlOfScreenControl(sC, 0, cra.getAcceptBGC());
                BaseGUIControl acceptbgc = cra.getAcceptBGC();
                cra = CobolGUIEnvironment.prepareCra(cra, acceptbgc);
                if (cra.getRecordType() == 13) {
                    return cra;
                }
                if (cra.isNTFEvent() && cra.getControl() == null && cra.getWindow() != null) {
                    cra.getWindow().setSizeNTFChanged(cra.getEventData1() / 100, cra.getEventData2() / 100);
                }
                if (cra.getRecordType() != 7 || cra.getControl() == null) {
                    isclosewindow = cra.getEventType() == 16415;
                } else if (cra.getControl() instanceof CobolGUIChipsBox && cra.getEventType() == 16415) {
                    isclosecontrol = true;
                }
                if (cra instanceof ChangeFocusEvent) {
                    cra = CobolGUIEnvironment.manageTuboEvent(ks, sC, eS, beanCtn, screenManager, (ChangeFocusEvent)cra, isonexcp, disableEmbProc, acceptbgc);
                    cra.setAcceptBGC(acceptbgc);
                    if (cra.getRecordType() == 13) {
                        return cra;
                    }
                }
                cra = CobolGUIEnvironment.manageAcceptBody(ks, sC, eS, beanCtn, screenManager, cra, isonexcp, disableEmbProc, acceptbgc, dequeue);
                if (!isclosewindow) break block15;
                switch (screenManager.getEventActionOfEventStatus(eS)) {
                    case 1: 
                    case 7: {
                        CobolRecordAccept secondcra = cra.getWindow().finishCloseCmd(cra, screenManager.getEventActionOfEventStatus(eS));
                        if (secondcra != null) {
                            secondcra.setAcceptBGC(acceptbgc);
                            cra.getWindow().setEvent(secondcra);
                            break;
                        }
                        break block16;
                    }
                    case 4: {
                        cra = new CobolRecordAccept(13, 0, 0, (BaseGUIControl)null, false, false, true).setAcceptBGC(acceptbgc);
                        cra.setAcceptBGC(acceptbgc);
                        break;
                    }
                    default: {
                        cra = CobolGUIEnvironment.manageCloseWindow(ks, sC, eS, beanCtn, screenManager, cra, isonexcp, disableEmbProc, acceptbgc);
                        cra.setAcceptBGC(acceptbgc);
                        break;
                    }
                }
                break block16;
            }
            if (isclosecontrol) {
                ((CobolGUIChipsBox)cra.getControl()).manageMsgClose(cra, screenManager.getEventActionOfEventStatus(eS) == 4);
            }
        }
        return cra;
    }

    public static CobolRecordAccept manageAcceptBody(CobolVar ks, CobolVar sC, CobolVar eS, BeanContainer beanCtn, CobolGUIEnvironment screenManager, CobolRecordAccept cra, boolean isonexcp, boolean disableEmbProc, BaseGUIControl acceptbgc) {
        return CobolGUIEnvironment.manageAcceptBody((ICobolVar)ks, (ICobolVar)sC, (ICobolVar)eS, beanCtn, screenManager, cra, isonexcp, disableEmbProc, acceptbgc);
    }

    public static CobolRecordAccept manageAcceptBody(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, CobolGUIEnvironment screenManager, CobolRecordAccept cra, boolean isonexcp, boolean disableEmbProc, BaseGUIControl acceptbgc) {
        return CobolGUIEnvironment.manageAcceptBody(ks, sC, eS, beanCtn, screenManager, cra, isonexcp, disableEmbProc, acceptbgc, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CobolRecordAccept manageAcceptBody(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, CobolGUIEnvironment screenManager, CobolRecordAccept cra, boolean isonexcp, boolean disableEmbProc, BaseGUIControl acceptbgc, boolean dequeue) {
        BaseGUIControl helpIdCtl;
        String actionName;
        screenManager.setAcceptControlOfScreenControl(sC, 0, acceptbgc);
        if (cra instanceof ChangeFocusEvent) {
            cra = CobolGUIEnvironment.manageChangeFocusEvent(ks, sC, eS, beanCtn, screenManager, (ChangeFocusEvent)cra, isonexcp, disableEmbProc, acceptbgc);
            cra.setAcceptBGC(acceptbgc);
            if (cra.getRecordType() == 13) {
                return cra;
            }
        }
        cra.setAcceptBGC(acceptbgc);
        if (cra.getRecordType() == 14 || cra.getRecordType() == 12 || cra.getRecordType() == 27 || screenManager.getAcceptControlTermValue(sC, acceptbgc) || screenManager.getAcceptControlExcpValue(sC, acceptbgc)) {
            return cra;
        }
        cra.initializeCobolScreenInterface(ks, sC, eS, screenManager);
        if (!cra.isMSGEvent()) {
            screenManager.saveEventStatus(eS);
        }
        if (cra.isBeanEvent() && beanCtn != null) {
            CobolGUIEnvironment.setJavaBeanSpecialNames(cra, beanCtn);
        }
        ProcedureObject proc = null;
        DisplayWindow go = null;
        int excValue = 0;
        if (cra.isException()) {
            excValue = cra.getKeyStatus();
        } else if (cra.getExceptionGenerated()) {
            excValue = cra.getControl() != null ? cra.getExceptionValue() : cra.getKeyStatus();
        }
        boolean helpMouseStop = false;
        if (cra.getRecordType() == 28) {
            actionName = "ITEM-HELP";
            helpIdCtl = cra.getControl();
            helpMouseStop = true;
        } else {
            actionName = Factory.getAction(excValue);
            helpIdCtl = null;
        }
        if (actionName != null) {
            block67: {
                BaseGUIControl bgcac;
                go = cra.getWindow();
                if (go != null && (bgcac = go.getActiveControl()) != null) {
                    try {
                        if (actionName.equalsIgnoreCase("CUT-SELECTION")) {
                            go.controlsetProp(bgcac.getControlPeerServerId(), "ACTION", "1", 0);
                            break block67;
                        }
                        if (actionName.equalsIgnoreCase("COPY-SELECTION")) {
                            go.controlsetProp(bgcac.getControlPeerServerId(), "ACTION", "2", 0);
                            break block67;
                        }
                        if (actionName.equalsIgnoreCase("PASTE-SELECTION")) {
                            go.controlsetProp(bgcac.getControlPeerServerId(), "ACTION", "3", 0);
                            break block67;
                        }
                        if (actionName.equalsIgnoreCase("DELETE-SELECTION")) {
                            go.controlsetProp(bgcac.getControlPeerServerId(), "ACTION", "4", 0);
                            break block67;
                        }
                        if (actionName.equalsIgnoreCase("SELECT-ALL-SELECTION")) {
                            go.controlsetProp(bgcac.getControlPeerServerId(), "ACTION", "7", 0);
                            break block67;
                        }
                        if (actionName.equalsIgnoreCase("UNDO")) {
                            go.controlsetProp(bgcac.getControlPeerServerId(), "ACTION", "5", 0);
                            break block67;
                        }
                        if (actionName.equalsIgnoreCase("REDO")) {
                            go.controlsetProp(bgcac.getControlPeerServerId(), "ACTION", "6", 0);
                            break block67;
                        }
                        if (actionName.equalsIgnoreCase("SEARCH")) {
                            go.controlsetProp(bgcac.getControlPeerServerId(), "ACTION", "8", 0);
                            break block67;
                        }
                        if (actionName.equalsIgnoreCase("ITEM-HELP")) {
                            DisplayWindow w;
                            String progname = Config.getProperty("iscobol.help_program", null);
                            if (progname != null) {
                                cra.setRecordType(3);
                                int v = helpMouseStop ? 19 : 8;
                                screenManager.setEventTypeOfEventStatus(eS, v);
                                if (helpIdCtl == null) {
                                    BaseGUIControl baseGUIControl = helpIdCtl = cra.getWindow() != null ? cra.getWindow().getActiveControl() : null;
                                }
                                if (helpIdCtl != null) {
                                    int helpId = helpIdCtl.getHelpId();
                                    screenManager.setEventData2OfEventStatus(eS, helpId);
                                    if (helpIdCtl.hasProc(cra)) {
                                        cra.setExceptionGenerated(false);
                                        cra = CobolGUIEnvironment.manageControlAccept(ks, sC, eS, screenManager, cra, isonexcp, disableEmbProc, acceptbgc, true);
                                    }
                                    if (screenManager.getEventActionOfEventStatus(eS) == 2) {
                                        return cra;
                                    }
                                    try {
                                        if (eS == null) {
                                            PicX eStmp = Factory.getVarAlphanum(Factory.getMem(25), 0, 25, false, null, null, null, "EVENT-STATUS", false, false);
                                            screenManager.setEventTypeOfEventStatus(eStmp, v);
                                            screenManager.setEventData2OfEventStatus(eStmp, helpId);
                                            Factory.call(progname, null, new Object[]{eStmp});
                                        } else {
                                            Factory.call(progname, null, new Object[]{eS});
                                        }
                                    }
                                    catch (CallOverflowException ex) {
                                        throw new WrapperException(ex);
                                    }
                                }
                            }
                            if ((w = screenManager.getCurrentWindow()) != null) {
                                w.restoreFocusOwner();
                            }
                            cra.responseClient();
                            break block67;
                        }
                        if (!actionName.equalsIgnoreCase("HELP-CURSOR")) {
                            // empty if block
                        }
                    }
                    catch (IOException _re) {
                        ScreenUtility.handleIOException(_re);
                    }
                }
            }
            screenManager.setEventActionOfEventStatus(eS, 2, cra);
            cra.setRecordType(13);
            return cra;
        }
        if (cra.isCMD_EXITEvent()) {
            throw new StopRunException();
        }
        if (cra.getControl() != null && cra.getControl().hasProc(cra)) {
            cra = CobolGUIEnvironment.manageControlAccept(ks, sC, eS, screenManager, cra, isonexcp, disableEmbProc, acceptbgc, dequeue);
        }
        if (cra.getWindow() != null) {
            if (cra.getEventType() == 6) {
                DisplayWindow dw = screenManager.getGlobActiveWindow();
                if (dw != null && dw.isModal() && cra.getWindow() != dw && dw.haveAnchor(cra.getWindow())) {
                    cra.setRecordType(13);
                } else if (Thread.holdsLock(screenManager.getWindowWait())) {
                    screenManager.setActiveWindow(cra.getWindow(), false, null, true, false);
                } else {
                    LinkedList w = screenManager.getWindowList();
                    synchronized (w) {
                        Vector helpId = screenManager.getWindowWait();
                        synchronized (helpId) {
                            screenManager.setActiveWindow(cra.getWindow(), false, null, true, false);
                        }
                    }
                }
            }
            if (cra.getWindow().hasProc(cra)) {
                cra = CobolGUIEnvironment.manageWindowAccept(ks, sC, eS, screenManager, cra, isonexcp, acceptbgc);
            }
        }
        if ((go = cra.getWindow()) != null && cra.getControl() == null || cra.getKeyStatus() == 95 && (go = screenManager.getCurrentWindow()) != null) {
            BaseGUIControl bgc = null;
            if (cra.getKeyStatus() == 97) {
                screenManager.setAcceptControlOfScreenControl(sC, 0, acceptbgc);
                screenManager.setControlValueOfScreenControl(sC, 0, acceptbgc);
            } else {
                bgc = go.getActiveControl();
                if (bgc != null) {
                    cra.control = bgc;
                    cra.setControlId(bgc.intGetId());
                    cra.setScreenCntrlVal(bgc.getScreenCntrlVal());
                    if (bgc != null && bgc.isClone()) {
                        screenManager.setControlHandleOfScreenControl(sC, bgc.getCloneSource(), acceptbgc);
                    } else {
                        screenManager.setControlHandleOfScreenControl(sC, bgc, acceptbgc);
                    }
                    screenManager.setAcceptControlOfScreenControl(sC, 0, acceptbgc);
                    if (!(disableEmbProc || (proc = bgc.getExceptionProc()) == null || cra.getEventType() != 4114 && cra.getEventType() != 16397 && cra.getEventType() != 1 && cra.getKeyStatus() != 95)) {
                        if (cra.isNTFEvent()) {
                            screenManager.setAcceptControlOfScreenControl(sC, 1, acceptbgc);
                        }
                        screenManager.getAllData(cra);
                        DisplayWindow wnd = bgc.getParentWindow();
                        if (wnd != null) {
                            wnd.setExecutingExceptionProc(true);
                        }
                        ICobolVar saveControlKey = null;
                        if (wnd != null) {
                            saveControlKey = wnd.getControlKey();
                            wnd.setAllData(null);
                        }
                        screenManager.getTdd()._execEmbeddedProc = true;
                        proc.perform();
                        screenManager.getTdd()._execEmbeddedProc = false;
                        if (wnd != null) {
                            wnd.setControlKey(saveControlKey);
                        }
                        if (wnd != null) {
                            wnd.setExecutingExceptionProc(false);
                        }
                        if (ks != null) {
                            cra.setKeyStatus(CobolGUIEnvironment.getKsInt(ks));
                        }
                        screenManager.restoreVarInterface(ks, sC, eS, cra, acceptbgc);
                        CobolRecordAccept ret = screenManager.responseAcceptControl(ks, sC, cra, acceptbgc, bgc, null, true, true);
                        BaseGUIControl isExcpNewFocus = null;
                        if (ret != null) {
                            isExcpNewFocus = ret.getNewControlWithFocus();
                        }
                        if (isExcpNewFocus != null) {
                            ret = CobolGUIEnvironment.manageBeforeEvent(ks, sC, eS, null, screenManager, isExcpNewFocus, null, isonexcp, false, acceptbgc);
                            if (ret != null) {
                                if (cra != null && cra != ret) {
                                    cra.responseClient();
                                }
                                return ret;
                            }
                            cra.setRecordType(13);
                        } else if (ret != null) {
                            return ret;
                        }
                    }
                }
            }
        }
        if (cra.getExceptionGenerated()) {
            screenManager.responseAcceptControl(ks, sC, cra, acceptbgc);
        }
        return cra;
    }

    private static void setJavaBeanSpecialNames(CobolRecordAccept cra, BeanContainer beanCnt) {
        beanCnt.setEventObject(cra.getEventObject());
        BaseGUIControl ctl = cra.getControl();
        if (ctl != null && ctl.isClone()) {
            ctl = ctl.getCloneSource();
        }
        beanCnt.setEventSource((CobolGUIJavaBean)ctl);
    }

    public CobolGUIEnvironment setProgName(String pn) {
        if (this.progName == null) {
            this.progName = pn;
        }
        return this;
    }

    public String getProgName() {
        return this.progName;
    }

    private void setObjectVar(Object from, IObjectVar to) {
        if (from == null) {
            to.set(0);
        } else {
            int k = 1;
            int count = UserHandles.getIdCount();
            for (k = UserHandles.getFirstId(); k < count; ++k) {
                if (UserHandles.getId(k) != from) continue;
                to.set(k);
                break;
            }
            if (k == count) {
                to.setOId(from);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWindowPalette() {
        LinkedList linkedList = this.windowList;
        synchronized (linkedList) {
            ListIterator ctlLI = this.windowList.listIterator(0);
            while (ctlLI.hasNext()) {
                DisplayWindow ctl = (DisplayWindow)ctlLI.next();
                ctl.updatePalette();
            }
        }
    }

    public static void updatePalette() {
        ScrFactory.getGUIEnviroment().updateWindowPalette();
    }

    public void acceptFromWindowHandle(CobolVar cv) {
        this.acceptFromWindowHandle((ICobolVar)cv);
    }

    public void acceptFromWindowHandle(ICobolVar cv) {
        if (cv != null) {
            cv.setOId(this.getCurrentWindow());
        }
    }

    public void acceptFromWindowHandle(NumericVar nv) {
        this.acceptFromWindowHandle((ICobolVar)nv);
    }

    public void acceptFromControlHandle(NumericVar nv) {
        this.acceptFromControlHandle((INumericVar)nv);
    }

    public void acceptFromControlHandle(INumericVar nv) {
        if (nv != null) {
            nv.setOId(this.getCurrentWindow().getLastFocusOwner());
        }
    }

    public void acceptFromInputStatus(CobolVar cv) {
        this.acceptFromInputStatus(cv, false);
    }

    public void acceptFromInputStatus(ICobolVar cv) {
        this.acceptFromInputStatus(cv, false);
    }

    public void acceptFromInputStatus(ICobolVar cv, boolean onlyChar) {
        if (cv != null) {
            try {
                int activeWindowId = this._globActiveWindow != null && this._globActiveWindow.getComponent() != null ? this._globActiveWindow.getComponent().getTheObjectId() : -1;
                if (ScreenUtility.getGuiFactory().getInputStatus(activeWindowId, onlyChar)) {
                    cv.set(1);
                } else {
                    cv.set(0);
                }
            }
            catch (IOException _re) {
                ScreenUtility.handleIOException(_re);
            }
        }
    }

    public void getChar(ICobolVar cv) {
        this.getChar(cv, false);
    }

    public void getChar(ICobolVar cv, boolean onlyChar) {
        if (cv != null) {
            try {
                int activeWindowId;
                if (this._globActiveWindow != null && this._globActiveWindow.getComponent() != null) {
                    this.refreshWin(this._globActiveWindow);
                    activeWindowId = this._globActiveWindow.getComponent().getTheObjectId();
                } else {
                    activeWindowId = -1;
                }
                String c = ScreenUtility.getGuiFactory().getChar(activeWindowId, onlyChar);
                cv.set(c);
            }
            catch (IOException _re) {
                ScreenUtility.handleIOException(_re);
            }
        }
    }

    public final SubWindow getCurrentSubWindow() {
        SubWindow Return2 = this.getCurrentWindow().currentSW;
        if (Return2 == null) {
            Return2 = NullSubWindow.getInstance();
        }
        return Return2;
    }

    static BaseGUIControl getLastClone(BaseGUIControl bgc) {
        BaseGUIControl Return2 = null;
        if (bgc.isClone()) {
            Return2 = bgc;
        } else {
            Return2 = bgc.getLastClone();
            if (Return2 == null) {
                Return2 = bgc.getIsControlEditor() ? bgc : NullControl.getInstance();
            }
        }
        return Return2;
    }

    public void resetCobolEventStatusInterface(CobolVar eS) {
        this.resetCobolEventStatusInterface((ICobolVar)eS);
    }

    public void resetCobolEventStatusInterface(ICobolVar eS) {
        this.setEventTypeOfEventStatus(eS, 0);
        this.setEventWindowHandleOfEventStatus(eS, null);
        this.setEventControlHandleOfEventStatus(eS, null);
    }

    public void setCobolEventStatusInterface(CobolRecordAccept cra, CobolVar eS) {
        this.setCobolEventStatusInterface(cra, (ICobolVar)eS);
    }

    public void setCobolEventStatusInterface(CobolRecordAccept cra, ICobolVar eS) {
        this.setEventTypeOfEventStatus(eS, cra.getEventType());
        this.setEventWindowHandleOfEventStatus(eS, cra.getWindow());
        if (cra.control != null && cra.control.isClone()) {
            this.setEventControlHandleOfEventStatus(eS, cra.control.getCloneSource());
        } else {
            this.setEventControlHandleOfEventStatus(eS, cra.control);
        }
        this.setEventControlIdOfEventStatus(eS, cra.getControlId());
        this.setEventData1OfEventStatus(eS, cra.getEventData1());
        this.setEventData2OfEventStatus(eS, cra.getEventData2());
        this.setEventActionOfEventStatus(eS, cra.getEventAction(), cra);
    }

    public void setCobolScreenControlInterface(CobolVar sC, int screenCntrlVal, BaseGUIControl control, int controlId, BaseGUIControl acceptbgc) {
        this.setCobolScreenControlInterface((ICobolVar)sC, screenCntrlVal, control, controlId, acceptbgc);
    }

    public void setCobolScreenControlInterface(ICobolVar sC, int screenCntrlVal, BaseGUIControl control, int controlId, BaseGUIControl acceptbgc) {
        if (control != null && control.haveHandle()) {
            return;
        }
        this.setControlValueOfScreenControl(sC, screenCntrlVal, acceptbgc);
        this.setControlHandleOfScreenControl(sC, control, acceptbgc);
        this.setControlIdOfScreenControl(sC, controlId, acceptbgc);
    }

    public void manageMsgBox(DisplayMessageBox dmb) {
        CobolRecordAccept cra = null;
        if (dmb != null) {
            do {
                if ((cra = this.acceptStack.popAnswerMsgBox(dmb)) != null) {
                    cra.getMsgBox().msgboxEvent(cra);
                }
                if (cra == null || !cra.getResponse()) continue;
                cra.responseClient();
            } while (cra == null);
        }
    }

    public void manageActiveProp(CobolVar ks, CobolVar sC, CobolVar eS, BaseGUIControl bgc, boolean dequeue) {
        this.manageActiveProp((ICobolVar)ks, (ICobolVar)sC, (ICobolVar)eS, bgc, dequeue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manageActiveProp(ICobolVar ks, ICobolVar sC, ICobolVar eS, BaseGUIControl bgc, boolean dequeue) {
        CobolRecordAccept cra = null;
        DisplayWindow go = null;
        if (this.getTdd()._screenControlLength > 0) {
            ThreadDependentData.access$2102(this.getTdd(), CobolGUIEnvironment.saveMem(this.getTdd()._screenControl));
        }
        this.getTdd()._screenControlSaveLength = this.getTdd()._screenControlLength;
        if (bgc.getParentBGW() != null) {
            Vector vector = this.windowWait;
            synchronized (vector) {
                bgc.getParentBGW().dequeueParamsSend(true);
            }
        }
        if (bgc != null && (go = bgc.getCloneParentWindow()) != null) {
            if (go.isThreadWaiting()) {
                throw new IscobolRuntimeException(22, "");
            }
            go.setWaitAction(bgc);
            do {
                if ((cra = this.acceptStack.popAnswerAction(go, bgc)) != null && cra.getEventType() != 31) {
                    this.setAcceptControlOfScreenControl(sC, 0, bgc);
                    cra.setAcceptBGC(bgc);
                    cra.initializeCobolScreenInterface(ks, sC, eS, this);
                    CobolGUIEnvironment.manageAccept(ks, sC, eS, null, this, cra, false, false, dequeue);
                }
                if (cra == null || !cra.getResponse()) continue;
                cra.responseClient();
            } while (cra == null || cra.getEventType() != 31);
            if (!dequeue) {
                this.dequeueWindow(cra.getWindow());
            }
            go.setWaitAction(null);
        }
        if (this.getTdd()._screenControlSaveLength > 0) {
            this.getTdd()._screenControl.set(this.getTdd()._screenControlSave);
        }
        this.getTdd()._screenControlLength = this.getTdd()._screenControlSaveLength;
    }

    public void display(String str) {
        this.display(null, 0, true, str, true);
    }

    public void display(String str, boolean eol) {
        this.display(null, 0, true, str, eol);
    }

    public void display(String filename, int recLen, boolean lineSeq, String str) {
        this.display(filename, recLen, lineSeq, str, true);
    }

    public void display(String filename, int recLen, boolean lineSeq, String str, boolean eol) {
        DisplayWindow dw = this.getCurrentWindow();
        if (dw == null) {
            Factory.displayUponSysOut(filename, recLen, lineSeq, false, str, eol);
        } else {
            this.display(ScrFactory.getGUITerminalDisplay(str).setNoadvancing(!eol));
        }
    }

    public void display(String filename, int recLen, boolean lineSeq, boolean eol, ICobolVar[] vars, ICobolVar[] pictures) {
        DisplayWindow dw = this.getCurrentWindow();
        if (dw == null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < vars.length; ++i) {
                sb.append(vars[i]);
            }
            Factory.displayUponSysOut(filename, recLen, lineSeq, false, sb.toString(), eol);
        } else {
            for (int i = 0; i < vars.length; ++i) {
                BaseGUIControl bgc = pictures[i] != null ? ScrFactory.getGUITerminalDisplay("FILLER", (BaseGUIControl)null, pictures[i]).setFrom(vars[i]) : ScrFactory.getGUITerminalDisplay(vars[i]);
                bgc.setAutoAdvancingLine();
                bgc.setNoadvancing(i < vars.length - 1 || !eol);
                this.display(bgc);
            }
        }
    }

    public void accept(CobolVar ks, CobolVar sC, CobolVar eS, BeanContainer beanCtn, CobolVar crs, CobolVar cv) {
        this.accept((ICobolVar)ks, (ICobolVar)sC, (ICobolVar)eS, beanCtn, (ICobolVar)crs, (ICobolVar)cv);
    }

    public void accept(ICobolVar ks, ICobolVar sC, ICobolVar eS, BeanContainer beanCtn, ICobolVar crs, ICobolVar cv) {
        DisplayWindow dw = this.getCurrentWindow();
        if (dw == null) {
            if (cv instanceof INumericVar) {
                cv.ieval().set(CobolNum.get(Functions.numVal(Factory.acceptFromConsole().toString(), cv.isDecimalPointComma()).toString(), cv.isDecimalPointComma()));
            } else if (cv instanceof IPicNumEdit) {
                cv.ieval().set(CobolNum.get(Functions.numValC(Factory.acceptFromConsole().toString(), cv.isDecimalPointComma(), ((IPicNumEdit)cv).getCurrencyChar()).toString(), cv.isDecimalPointComma()));
            } else if (cv instanceof IPicAlphaEdit) {
                if (cv.getClass().getName().indexOf("types_n") >= 0) {
                    cv.ieval().setValue(com.iscobol.rts_n.Factory.acceptFromConsole());
                } else {
                    cv.ieval().setValue(Factory.acceptFromConsole());
                }
            } else {
                cv.ieval().set(Factory.acceptFromConsole().getBytes());
            }
        } else {
            CobolRecordAccept int__cra_1 = null;
            do {
                if (this.getEventActionOfEventStatus(eS, int__cra_1 = CobolGUIEnvironment.manageAccept(ks, sC, eS, null, this, this.accept(ks, sC, eS, null, crs, ScrFactory.getGUITerminalAccept(cv), false, null, int__cra_1, false), false, false)) == 2) continue;
                this.responseAccept(ks, sC, eS, null, int__cra_1);
                this.manageAcceptException(ks, sC, eS, null, int__cra_1, false);
            } while (!this.isAcceptTerminated(ks, sC, eS, null, int__cra_1, false));
        }
    }

    public CobolGUIEnvironment setHandleToId(CobolVar cv, CobolVar id) {
        return this.setHandleToId((ICobolVar)cv, (ICobolVar)id);
    }

    public CobolGUIEnvironment setHandleToId(ICobolVar cv, ICobolVar id) {
        if (cv != null && id != null) {
            DisplayWindow dw = this.getThreadActiveWindow();
            BaseGUIControl found = null;
            if (dw != null) {
                found = dw.searchControlId(id.toint());
            }
            byte[] mem = Factory.getMem(4);
            ObjectVar areaOV = Factory.getVarObject(mem, 0, 4, false, null, null, null, "HANDLE", false, 0, 0, false, false, false);
            areaOV.setId(found != null && found.isClone() ? found.getCloneSource() : found);
            cv.set(areaOV.integer());
        }
        return this;
    }

    private static boolean containsExceptionValue(String v, int exc) {
        boolean Return2 = false;
        int min = -1;
        int max = -1;
        try {
            int numTok;
            StringTokenizer st = new StringTokenizer(v, "-");
            if (st != null && (numTok = st.countTokens()) > 0 && numTok == 2) {
                String strmin = st.nextToken().trim();
                String strmax = st.nextToken().trim();
                if (strmin != null && strmax != null) {
                    min = Integer.parseInt(strmin);
                    max = Integer.parseInt(strmax);
                    if (exc >= min && exc <= max) {
                        Return2 = true;
                    }
                }
            } else if (v != null && exc == (min = Integer.parseInt(v))) {
                Return2 = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Return2;
    }

    public static String getHotKeyProgram(CobolGUIEnvironment screenManager, int exc) {
        screenManager.initGuiHotKeyOrEventProc();
        return CobolGUIEnvironment.getHotKeyOrEventProgram(screenManager.getHotKeyProcHT(), exc, "iscobol.hot_key.");
    }

    private static String getHotKeyOrEventProgram(CobolGUIEnvironment screenManager, int exc) {
        screenManager.initGuiHotKeyOrEventProc();
        return CobolGUIEnvironment.getHotKeyOrEventProgram(screenManager.getHotEventProcHT(), exc, "iscobol.hot_event.");
    }

    private static String getHotKeyOrEventProgram(Hashtable<String, String> p, int exc, String configname) {
        if (p == null) {
            return null;
        }
        String Return2 = null;
        boolean found = false;
        Enumeration<String> e = p.keys();
        if (e == null) {
            return null;
        }
        while (!found && e.hasMoreElements()) {
            String k = e.nextElement();
            Return2 = k.substring(configname.length());
            String v = p.get(k);
            if (v != null) {
                StringTokenizer st = new StringTokenizer(v, ",");
                int numTok = st.countTokens();
                if (numTok > 0) {
                    for (int i = 0; !found && i < numTok; ++i) {
                        String temp = st.nextToken().trim().toUpperCase();
                        found = CobolGUIEnvironment.containsExceptionValue(temp, exc);
                    }
                } else {
                    found = CobolGUIEnvironment.containsExceptionValue(v, exc);
                }
                if (!found) {
                    Return2 = null;
                }
            }
            if (!found || Return2 != null) continue;
            found = false;
        }
        return Return2;
    }

    private void setCursorVar(ICobolVar crsSN, ICobolVar crsAccept, int value) {
        String l = "00" + (value >> 16);
        String c = "00" + (value & 0xFFFF);
        if (crsSN != null) {
            if (crsSN.length() < 6) {
                crsSN.set(l.substring(l.length() - 2, l.length()) + c.substring(c.length() - 2, c.length()));
            } else {
                crsSN.set(l.substring(l.length() - 3, l.length()) + c.substring(c.length() - 3, c.length()));
            }
        }
        if (crsAccept != null) {
            crsAccept.set(c);
        }
    }

    private void loadProtectedWithColorFields(DisplayWindow dw, BaseGUIControl bgc, ICobolVar crs, ParamVector param, boolean onException) {
        Vector of = new Vector();
        dw.getIsProtectedFieldWithColorValue(bgc, of);
        int winfo = 0;
        if (dw.hasEventProc()) {
            winfo = 1;
        }
        if (crs != null) {
            winfo |= 0x100;
        }
        if (onException) {
            winfo |= 0x1000;
        }
        if (winfo > 0) {
            param.add(new ParamElementInt(2062, winfo));
        }
        int[] protwithcolor = null;
        if (of.size() > 0) {
            protwithcolor = new int[of.size()];
            Enumeration e = of.elements();
            int i = 0;
            BaseGUIControl bgcof = null;
            while (e.hasMoreElements()) {
                bgcof = (BaseGUIControl)e.nextElement();
                protwithcolor[i] = bgcof.getControlPeerServerId();
                ++i;
            }
        } else {
            protwithcolor = new int[]{-1};
        }
        param.add(new ParamElementArrayInt(2061, protwithcolor));
    }

    public void debugsrv(String s) {
        System.out.println("<Server> debug start -----[" + s + "]");
        for (int i = this.serverObjectIds.length(); i > 0; --i) {
            Object obj = this.serverObjectIds.getObject(i);
            if (obj == null) continue;
            System.out.println("s[" + i + "]=" + obj);
        }
        System.out.println("<Server> debug end   -----[" + s + "]");
    }

    public static void debug(String s) {
    }

    public Vector getWindowWait() {
        return this.windowWait;
    }

    public void refreshAll() {
        this.sendParamsToWindow();
    }

    public void refreshCurrent() {
        DisplayWindow cw = this.getCurrentWindow();
        if (cw != null) {
            this.refreshWin(cw);
        }
    }

    public void refreshWin(DisplayWindow dw) {
        if (dw instanceof DisplayToolBar) {
            dw = ((DisplayToolBar)dw).getParentWindow();
        }
        if (dw != null) {
            this.dequeueWindow(dw);
        }
    }

    public void setInquireBuffered(DisplayWindow dw, boolean inqb) {
        if (!inqb) {
            this.refreshWin(dw);
        }
        dw.setInquireBuffered(inqb);
    }

    public boolean isBufferedWindowType(BaseGUIWindow bgw, int type) {
        return bufferedwincmd == 1L || (type == 6 || type == 3) && (bufferedwincmd & 2L) == 2L || type == 5 && (bufferedwincmd & 4L) == 4L || type == 2 && (bufferedwincmd & 8L) == 8L || type == 7 && (bufferedwincmd & 0x40L) == 64L || type == 8 && (bufferedwincmd & 0x80L) == 128L || type == 9 && (bufferedwincmd & 0x100L) == 256L || type == 10 && (bufferedwincmd & 0x200L) == 512L || type == 11 && (bufferedwincmd & 0x400L) == 1024L || bgw instanceof SubWindow && (bufferedwincmd & 0x10L) == 16L;
    }

    private int getAcceptCursorValue(BaseGUIControl bgc, int cfecurs, ChangeFocusEvent cfe) {
        int cn = (int)bgc.getAtColumn();
        if ((cn = (int)((float)cn + (bgc.getParentSW() != null && bgc.getParentSW().getAtColumn() > 0.0f ? bgc.getParentSW().getAtColumn() - 1.0f : 0.0f))) > 0) {
            cfecurs -= cn - 1;
        } else if (cfe != null && bgc.isTerminalEmulation()) {
            int colcursor = 0;
            int rbgcX = cfe.getCursor() & 0xFFFF;
            Dimension charDim = cfe.getWindow().getCharDim();
            if (charDim != null) {
                rbgcX *= charDim.width;
            }
            colcursor = rbgcX - bgc.getX();
            if ((colcursor /= charDim.width) > 0) {
                cfecurs = colcursor;
            }
        }
        return cfecurs;
    }

    public boolean isExcludeEventMSG_VALIDATE() {
        boolean Return2 = false;
        if (this.gui_exclude_events == -1) {
            return Return2;
        }
        if (this.gui_exclude_events == 1) {
            Return2 = this.eventlistcontainsMSG_VALIDATE;
        } else if (this.gui_exclude_events == 0 && this.gui_event_list != null) {
            Return2 = !this.eventlistcontainsMSG_VALIDATE;
        }
        return Return2;
    }

    public CobolAcceptStack getAS() {
        return this.acceptStack;
    }

    private static boolean checkIfDestroyed(DisplayWindow wnd, BaseGUIControl acceptbgc) {
        boolean Return2 = false;
        ArrayList al = wnd.getCurrChildsActiveAccept();
        if (al != null) {
            BaseGUIControl bgc = null;
            for (int i = 0; !Return2 && i < al.size(); ++i) {
                bgc = (BaseGUIControl)al.get(i);
                if (bgc == null) continue;
                Return2 = bgc.isDestroyed();
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reloadAcceptIfDestroyed(ICobolVar ks, ICobolVar sC, ICobolVar eS, DisplayWindow wnd, BaseGUIControl acceptbgc) {
        DisplayWindow displayWindow = wnd;
        synchronized (displayWindow) {
            ParamVector paramCSWindow = wnd.getParamCSWindow();
            int size = paramCSWindow.size();
            boolean saveactivea = acceptbgc.getActiveAccept();
            acceptbgc.intsetActiveAccept(false);
            wnd.accept(acceptbgc, paramCSWindow, ks, sC, eS, null);
            if (size < paramCSWindow.size()) {
                paramCSWindow.add(new ParamVElement(3001));
                if (wnd.getFirstControl() != null && wnd.getFirstControl().isDestroyed()) {
                    boolean[] allProtected = new boolean[]{false, false};
                    wnd.setFirstControl(sC, acceptbgc, allProtected);
                }
                wnd.enqueueParams(paramCSWindow);
            }
            acceptbgc.intsetActiveAccept(saveactivea);
        }
    }

    public int getActiveWindowHandleOfThread(NumericVar cv) {
        return this.getActiveWindowHandleOfThread((INumericVar)cv);
    }

    public int getActiveWindowHandleOfThread(INumericVar cv) {
        int Return2 = 0;
        Monitor m = null;
        if (cv != null && cv instanceof IObjectVar && cv.getOId() != null && cv.getOId() instanceof Monitor && (m = (Monitor)cv.getOId()) != null) {
            ThreadDependentData mytdd = null;
            mytdd = (ThreadDependentData)m.CGEObject;
            if (mytdd != null && mytdd._activeWindow != null && mytdd._activeWindow instanceof DisplayWindow && !mytdd._activeWindow.isDestroyed()) {
                Return2 = UserHandles.ssetId(mytdd._activeWindow);
            }
        }
        return Return2;
    }

    public static synchronized void setAcceptActive(boolean bActive) {
        if (bActive) {
            ++activeAcceptCount;
        } else if (activeAcceptCount > 0) {
            --activeAcceptCount;
        } else {
            StringWriter result = new StringWriter();
            PrintWriter printWriter = new PrintWriter(result);
            new Exception().printStackTrace(printWriter);
            Logger guiLog = null;
            if (guiLog == null) {
                guiLog = LoggerFactory.get(512);
            }
            guiLog.info("Accept finished, but no accepts active: acceptsActive value [" + activeAcceptCount + "] stackTrace [" + ((Object)result).toString() + "]");
        }
    }

    public static synchronized boolean isAcceptActive() {
        return activeAcceptCount > 0;
    }

    public static synchronized void resetAcceptsActive() {
        activeAcceptCount = 0;
    }

    public void disableUI() {
        this.enableUI = false;
    }

    public void enableUI() {
        this.enableUI = true;
    }

    public boolean isEnabledUI() {
        return this.enableUI;
    }

    public boolean getNativeName() {
        return this.nativename || this.debugnativename;
    }

    public boolean getDebugNativeName() {
        return this.debugnativename;
    }

    public boolean getColZeroRm() {
        return this.colzerorm;
    }

    public void addTrayMenu() {
        ++this.trayMenuCount;
    }

    public void removeTrayMenu() {
        --this.trayMenuCount;
    }

    public void setIconFile() {
        if (!this.iconfromfilechecked) {
            try {
                ScrFactory.setIconFileImage(Config.getProperty("iscobol.gui.icon_file", null));
                this.iconfromfilechecked = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getIconFileId() {
        try {
            return ScrFactory.getIconFileId();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public void setIconFileChipsBoxMouseEntered() {
        if (!this.iconfromfilechipsboxmouseenteredchecked) {
            try {
                ScrFactory.setIconFileChipsBoxMouseEnteredImage(Config.getProperty("iscobol.gui.icon_file.chipsbox.mouseentered", null));
                this.iconfromfilechipsboxmouseenteredchecked = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getIconFileChipsBoxMouseEnteredId() {
        if (!this.iconfromfilechipsboxmouseenteredcheckedalreadyloaded) {
            try {
                this.iconfromfilechipsboxmouseenteredcheckedalreadyloaded = true;
                return ScrFactory.getIconFileChipsBoxMouseEnteredId();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    public void setIconFileChipsBoxMouseExited() {
        if (!this.iconfromfilechipsboxmouseexitedchecked) {
            try {
                ScrFactory.setIconFileChipsBoxMouseExitedImage(Config.getProperty("iscobol.gui.icon_file.chipsbox.mouseexited", null));
                this.iconfromfilechipsboxmouseexitedchecked = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getIconFileChipsBoxMouseExitedId() {
        if (!this.iconfromfilechipsboxmouseexitedcheckedalreadyloaded) {
            try {
                this.iconfromfilechipsboxmouseexitedcheckedalreadyloaded = true;
                return ScrFactory.getIconFileChipsBoxMouseExitedId();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    public Object getObjSynch() {
        return this.windowWait;
    }

    boolean isExecutingProc() {
        return this.executingProc;
    }

    public boolean isInEmbeddedProc() {
        return this.getTdd() != null && this.getTdd()._execEmbeddedProc;
    }

    public WindowCreateHandler getWindowCreateHandler() {
        if (this.fd != null) {
            return this.fd.windowCreateHandler;
        }
        return null;
    }

    private static boolean runHotEventProgram(CobolGUIEnvironment screenManager, String progname, CobolRecordAccept cra, ICobolVar eS, int hoteventnumber) {
        int rc = 0;
        int ea = 0;
        DisplayWindow w = screenManager.getCurrentWindow();
        if (progname != null && w != null && !w.getExecutingHotEventProc()) {
            ea = screenManager.getEventActionOfEventStatus(eS);
            if (w != null) {
                w.setExecutingHotEventProc(true);
            }
            Object ret = null;
            try {
                ret = Factory.call(progname, null, new Object[]{eS}, true);
                if (ret != null && ret instanceof ICobolVar) {
                    rc = ((ICobolVar)ret).toint();
                }
            }
            catch (CallOverflowException ex) {
                throw new WrapperException(ex);
            }
            ea = screenManager.getEventActionOfEventStatus(eS);
            if (w != null) {
                w.setExecutingHotEventProc(false);
            }
        }
        return rc == 1;
    }

    private void initGuiHotKeyOrEventProc() {
        this.hotEventProcHT = new Hashtable();
        this.hotKeyProcHT = new Hashtable();
        Properties p = Config.getAllProperties();
        Enumeration<?> e = p.propertyNames();
        Object Return2 = null;
        boolean found = false;
        String confignamehotkey = "iscobol.hot_key.";
        String confignamehotevent = "iscobol.hot_event.";
        while (e.hasMoreElements()) {
            String v;
            String k = (String)e.nextElement();
            if (k.startsWith(confignamehotkey) && k.length() > confignamehotkey.length()) {
                v = (String)p.get(k);
                this.hotKeyProcHT.put(k, v);
                continue;
            }
            if (!k.startsWith(confignamehotevent) || k.length() <= confignamehotevent.length()) continue;
            v = (String)p.get(k);
            this.hotEventProcHT.put(k, v);
        }
    }

    public Hashtable getHotKeyProcHT() {
        return this.hotKeyProcHT;
    }

    public Hashtable getHotEventProcHT() {
        return this.hotEventProcHT;
    }

    static {
        modality = Config.getProperty("iscobol.gui.windows_modality", true);
        updown_like_prevnext = Config.getProperty("iscobol.keystroke.updown_like_prevnext", false);
        firstlast_on_screen = Config.getProperty("iscobol.keystroke.firstlast_on_screen", false);
        bufferedwincmd = Config.getProperty("iscobol.gui.buffered_win_cmd", 1);
        guiimplieddecimal = Config.getProperty("iscobol.gui.entryfield.implied_decimal", "iscobol.gui.implied_decimal", false);
    }

    private class SendParamTimer
    extends Thread {
        private long delay;

        public SendParamTimer(long h_frame) {
            this.delay = h_frame;
        }

        @Override
        public void run() {
            Config.markNoIscobolRuntimeThread();
            try {
                SendParamTimer.sleep(this.delay);
                CobolGUIEnvironment.this.sendParamsToWindow();
                IscobolSystem.destroyEnv(this);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class ThreadDependentData {
        private DisplayWindow _currentWindow;
        private DisplayWindow _activeWindow;
        private int _escapeKey;
        private byte[] _eventStatusSave;
        private CobolVar _eventStatus = Factory.getVarAlphanum(Factory.getMem(25), 0, 25, false, null, null, null, "EVENT-STATUS", false, false);
        private NumericVar _eventType = Factory.getVarCompX(this._eventStatus, 0, 4, false, null, null, null, "EVENT-TYPE", false, 4, 0, false, false, false);
        private ObjectVar _eventWindowHandle = Factory.getVarObject(this._eventStatus, 4, 4, false, null, null, null, "EVENT-WINDOW-HANDLE", false, 0, 0, false, false, false);
        private ObjectVar _eventControlHandle = Factory.getVarObject(this._eventStatus, 8, 4, false, null, null, null, "EVENT-CONTROL-HANDLE", false, 0, 0, false, false, false);
        private NumericVar _eventControlId = Factory.getVarCompX(this._eventStatus, 12, 2, false, null, null, null, "EVENT-CONTROL-ID", false, 2, 0, false, false, false);
        private NumericVar _eventData1 = Factory.getVarCompN(this._eventStatus, 14, 2, false, null, null, null, "EVENT-DATA-1", false, 0, 0, true, false, false);
        private NumericVar _eventData2 = Factory.getVarCompN(this._eventStatus, 16, 8, false, null, null, null, "EVENT-DATA-2", false, 0, 0, true, false, false);
        private NumericVar _eventActionOfEventStatus = Factory.getVarCompX(this._eventStatus, 24, 1, false, null, null, null, "EVENT-ACTION", false, 1, 0, false, false, false);
        private byte[] _screenControlSave;
        private int _screenControlSaveLength;
        private int _screenControlLength;
        private CobolVar _screenControl = Factory.getVarAlphanum(Factory.getMem(10), 0, 10, false, null, null, null, "SCREEN-CONTROL", false, false);
        private NumericVar _acceptControlOfScreenControl = Factory.getVarDisplayAcu(this._screenControl, 0, 1, false, null, null, null, "ACCEPT-CONTROL", false, 1, 0, false, false, false);
        private NumericVar _controlValueOfScreenControl = Factory.getVarDisplayAcu(this._screenControl, 1, 3, false, null, null, null, "CONTROL-VALUE", false, 3, 0, false, false, false);
        private ObjectVar _controlHandleOfScreenControl = Factory.getVarObject(this._screenControl, 4, 4, false, null, null, null, "CONTROL-HANDLE", false, 0, 0, false, false, false);
        private NumericVar _controlIdOfScreenControl = Factory.getVarCompX(this._screenControl, 8, 2, false, null, null, null, "CONTROL-ID", false, 2, 0, false, false, false);
        private boolean _execEmbeddedProc;
        private boolean _execAcceptStatement;

        private ThreadDependentData() {
        }

        static /* synthetic */ byte[] access$2002(ThreadDependentData x0, byte[] x1) {
            x0._eventStatusSave = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$2102(ThreadDependentData x0, byte[] x1) {
            x0._screenControlSave = x1;
            return x1;
        }
    }
}

