/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

public class TextIcon
implements Icon,
PropertyChangeListener {
    static final double NINETY_DEGREES = Math.toRadians(90.0);
    static final int bufSpace = 5;
    String label;
    String[] charStrings;
    int[] charWidths;
    int[] position;
    int width;
    int height;
    int charHeight;
    int descent;
    int rotation;
    Component component;
    Color fg;
    static final int POSITION_NORMAL = 0;
    static final int POSITION_TOP_RIGHT = 1;
    static final int POSITION_FAR_TOP_RIGHT = 2;
    public static final int ROTATE_DEFAULT = 0;
    public static final int ROTATE_NONE = 1;
    public static final int ROTATE_LEFT = 2;
    public static final int ROTATE_RIGHT = 4;
    static final String sDrawsInTopRight = "\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u308e\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7\u30ee\u30f5\u30f6";
    static final String sDrawsInFarTopRight = "\u3001\u3002";
    static final int DEFAULT_CJK = 1;
    static final int LEGAL_ROMAN = 7;
    static final int DEFAULT_ROMAN = 4;
    static final int LEGAL_MUST_ROTATE = 6;
    static final int DEFAULT_MUST_ROTATE = 2;

    public TextIcon(Component c, String lb, int rotateHint) {
        this.component = c;
        this.label = lb;
        this.rotation = TextIcon.verifyRotation(this.label, rotateHint);
        this.calcDimensions();
        this.component.addPropertyChangeListener(this);
    }

    public void setLabel(String lb) {
        this.label = lb;
        this.rotation = TextIcon.verifyRotation(this.label, this.rotation);
        this.recalcDimensions();
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if ("font".equals(prop)) {
            this.recalcDimensions();
        }
    }

    void recalcDimensions() {
        int wOld = this.getIconWidth();
        int hOld = this.getIconHeight();
        this.calcDimensions();
        if (wOld != this.getIconWidth() || hOld != this.getIconHeight()) {
            this.component.invalidate();
        }
    }

    void calcDimensions() {
        FontMetrics fm = this.component.getFontMetrics(this.component.getFont());
        this.charHeight = fm.getAscent() + fm.getDescent();
        this.descent = fm.getDescent();
        if (this.rotation == 1) {
            int len = this.label.length();
            char[] data = new char[len];
            this.label.getChars(0, len, data, 0);
            this.width = 0;
            this.charStrings = new String[len];
            this.charWidths = new int[len];
            this.position = new int[len];
            for (int i = 0; i < len; ++i) {
                char ch = data[i];
                this.charWidths[i] = fm.charWidth(ch);
                if (this.charWidths[i] > this.width) {
                    this.width = this.charWidths[i];
                }
                this.charStrings[i] = new String(data, i, 1);
                this.position[i] = sDrawsInTopRight.indexOf(ch) >= 0 ? 1 : (sDrawsInFarTopRight.indexOf(ch) >= 0 ? 2 : 0);
            }
            this.height = this.charHeight * len + this.descent;
        } else {
            this.width = this.charHeight;
            this.height = fm.stringWidth(this.label) + 10;
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (c.isEnabled()) {
            g.setColor(this.fg != null ? this.fg : c.getForeground());
        } else {
            g.setColor(Color.lightGray);
        }
        g.setFont(c.getFont());
        if (this.rotation == 1) {
            this.addRenderingHints(g);
            int yPos = y + this.charHeight;
            for (int i = 0; i < this.charStrings.length; ++i) {
                switch (this.position[i]) {
                    case 0: {
                        g.drawString(this.charStrings[i], x + (this.width - this.charWidths[i]) / 2, yPos);
                        break;
                    }
                    case 1: {
                        int tweak = this.charHeight / 3;
                        g.drawString(this.charStrings[i], x + tweak / 2, yPos - tweak);
                        break;
                    }
                    case 2: {
                        int tweak = this.charHeight - this.charHeight / 3;
                        g.drawString(this.charStrings[i], x + tweak / 2, yPos - tweak);
                    }
                }
                yPos += this.charHeight;
            }
        } else if (this.rotation == 2) {
            g.translate(x + this.width, y + this.height);
            ((Graphics2D)g).rotate(-NINETY_DEGREES);
            g.drawString(this.label, 5, -this.descent);
            ((Graphics2D)g).rotate(NINETY_DEGREES);
            g.translate(-(x + this.width), -(y + this.height));
        } else if (this.rotation == 4) {
            g.translate(x, y);
            ((Graphics2D)g).rotate(NINETY_DEGREES);
            g.drawString(this.label, 5, -this.descent);
            ((Graphics2D)g).rotate(-NINETY_DEGREES);
            g.translate(-x, -y);
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public static int verifyRotation(String lb, int rotateHint) {
        int legal;
        boolean hasCJK = false;
        boolean hasMustRotate = false;
        int len = lb.length();
        char[] data = new char[len];
        lb.getChars(0, len, data, 0);
        for (int i = 0; i < len; ++i) {
            char ch = data[i];
            if (ch >= '\u4e00' && ch <= '\u9fff' || ch >= '\u3400' && ch <= '\u4dff' || ch >= '\uf900' && ch <= '\ufaff' || ch >= '\u3040' && ch <= '\u309f' || ch >= '\u30a0' && ch <= '\u30ff') {
                hasCJK = true;
            }
            if (!(ch >= '\u0590' && ch <= '\u05ff' || ch >= '\u0600' && ch <= '\u06ff') && (ch < '\u0700' || ch > '\u074f')) continue;
            hasMustRotate = true;
        }
        if (hasCJK) {
            return 1;
        }
        int n = legal = hasMustRotate ? 6 : 7;
        if ((rotateHint & legal) > 0) {
            return rotateHint;
        }
        return hasMustRotate ? 2 : 4;
    }

    protected void addRenderingHints(Graphics g) {
    }

    public void setForeground(Color c) {
        this.fg = c;
    }
}

