/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.IsTextIcon;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import java.awt.Color;
import java.awt.font.TextAttribute;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class Label
extends JLabel {
    public static final int DEFAULT_H_ALIGNMENT = 2;
    public static final int DEFAULT_V_ALIGNMENT = 1;
    private int hAlignment = 2;
    private int vAlignment = 1;
    private boolean multiline;
    private boolean vertical;
    private boolean noKeyLetter;
    private boolean transparent;
    private String title = "";
    private int mnemonicIndex = -1;
    private Color savefg;

    void updateAlignment() {
        this.setAlignment(this.hAlignment, this.vAlignment);
    }

    private void reloadTitle(String t) {
        if (this.hAlignment == 0) {
            this.setText(RemoteBaseGUIControl.buildTitle(t, !this.noKeyLetter ? this.mnemonicIndex : -1, true, false, this.isUnderlined()));
        } else if (this.hAlignment == 4) {
            this.setText(RemoteBaseGUIControl.buildTitle(t, !this.noKeyLetter ? this.mnemonicIndex : -1, false, true, this.isUnderlined()));
        } else {
            this.setText(RemoteBaseGUIControl.buildTitle(t, !this.noKeyLetter ? this.mnemonicIndex : -1, false, false, this.isUnderlined()));
        }
    }

    boolean isUnderlined() {
        return this.getFont().getAttributes().get(TextAttribute.UNDERLINE) == TextAttribute.UNDERLINE_ON;
    }

    public void setTitle(String t) {
        this.title = t;
        if (this.title == null || this.title.length() == 0) {
            this.setText("");
            return;
        }
        t = this.checkTitle(t);
        if (this.vertical) {
            this.setAlignment(this.hAlignment, this.vAlignment);
        } else {
            if (this.multiline) {
                this.reloadTitle(t);
            } else {
                this.setText(t);
            }
            if (this.vAlignment != this.getVerticalAlignment()) {
                this.setVerticalAlignment(this.vAlignment);
            }
        }
    }

    private String checkTitle(String t) {
        if (!this.noKeyLetter) {
            StringBuffer sb = new StringBuffer(t);
            this.mnemonicIndex = ScreenUtility.getMnemonicIdx(sb);
            t = sb.toString();
        }
        return t;
    }

    public void setAlignment(int hAlign, int vAlign) {
        this.hAlignment = hAlign;
        this.vAlignment = vAlign;
        if (this.vertical) {
            this.setText(null);
            int rotateHint = this.hAlignment == 4 ? 4 : 2;
            this.setIcon(new IsTextIcon(this, this.checkTitle(this.title), rotateHint));
            if (this.vAlignment != this.getVerticalAlignment()) {
                this.setVerticalAlignment(this.vAlignment);
            }
            this.setHorizontalAlignment(0);
        } else {
            this.setIcon(null);
            this.setTitle(this.title);
            if (this.hAlignment != this.getHorizontalAlignment()) {
                this.setHorizontalAlignment(this.hAlignment);
            }
        }
        this.repaint();
    }

    public void setNoKeyLetter(boolean n) {
        this.noKeyLetter = n;
        this.setTitle(this.title);
    }

    public void setTransparent(boolean t) {
        this.transparent = t;
        this.setOpaque(!this.transparent);
        this.repaint();
    }

    public void setCentered(boolean set) {
        if (set) {
            if (this.vertical) {
                this.setAlignment(this.hAlignment, 0);
            } else {
                this.setAlignment(0, this.vAlignment);
            }
        } else if (this.vertical) {
            this.setAlignment(this.hAlignment, 1);
        } else {
            this.setAlignment(2, this.vAlignment);
        }
    }

    public void setLeft(boolean set) {
        if (set) {
            this.setAlignment(2, this.vAlignment);
        } else {
            this.setAlignment(2, this.vAlignment);
        }
    }

    public void setRight(boolean set) {
        if (set) {
            this.setAlignment(4, this.vAlignment);
        } else {
            this.setAlignment(2, this.vAlignment);
        }
    }

    public void setTop(boolean set) {
        this.setVertical(set);
        if (set) {
            this.setAlignment(this.hAlignment, 1);
        } else {
            this.setAlignment(this.hAlignment, 1);
        }
    }

    public void setBottom(boolean set) {
        this.setVertical(set);
        if (set) {
            this.setAlignment(this.hAlignment, 3);
        } else {
            this.setAlignment(this.hAlignment, 1);
        }
    }

    public void setVertical(boolean v) {
        this.vertical = v;
    }

    public void setMultiline(boolean m) {
        this.multiline = m;
    }

    private void buildForeground(boolean e) {
        if (this.getText() != null) {
            if (!e) {
                Color disableC;
                if (this.savefg == null) {
                    this.savefg = this.getForeground();
                }
                if ((disableC = UIManager.getColor("Label.disabledForeground")) == null) {
                    disableC = new ColorUIResource(153, 153, 153);
                }
                super.setForeground(disableC);
            } else if (this.savefg != null) {
                this.setForeground(this.savefg);
                this.savefg = null;
            }
        }
    }

    @Override
    public void setEnabled(boolean e) {
        super.setEnabled(e);
        this.buildForeground(e);
    }

    @Override
    public void setForeground(Color f) {
        if (!this.isEnabled()) {
            this.savefg = f;
        } else {
            super.setForeground(f);
        }
    }
}

