/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.Constants;
import com.iscobol.gui.client.swing.GridViewS;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;

public class GridTableAdjustableRows
extends MouseInputAdapter
implements Constants {
    public Cursor resizeCursor;
    private Cursor otherCursor;
    private Cursor initialCursor;
    private GridViewS parent;
    private JTable table;
    private int mousepressedY;
    private int adjustRow = -1;
    private int adjustRowCandidate = -1;
    private int newHeight = -1;
    private int minvalue;
    private int maxvalue;

    public GridTableAdjustableRows(GridViewS p, JTable t) {
        this.parent = p;
        this.otherCursor = this.resizeCursor = Cursor.getPredefinedCursor(8);
        this.table = t;
        this.initialCursor = this.table.getCursor();
        this.table.addMouseListener(this);
        this.table.addMouseMotionListener(this);
    }

    public void removeListenerAdjustableRows() {
        this.table.removeMouseListener(this);
        this.table.removeMouseMotionListener(this);
        this.table.setCursor(this.initialCursor);
    }

    private int getAdjustableRow(Point p) {
        return this.getAdjustableRow(p, this.table.rowAtPoint(p));
    }

    private int getAdjustableRow(Point p, int row) {
        if (row == -1) {
            return -1;
        }
        int col = this.table.columnAtPoint(p);
        if (col == -1) {
            return -1;
        }
        Rectangle r = this.table.getCellRect(row, col, true);
        r.grow(0, -3);
        if (r.contains(p)) {
            return -1;
        }
        int midPoint = r.y + r.height / 2;
        int rowIndex = p.y < midPoint ? row - 1 : row;
        return rowIndex;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point p = e.getPoint();
        this.adjustRowCandidate = this.adjustRow = this.getAdjustableRow(p);
        this.mousepressedY = p.y - this.table.getRowHeight(this.adjustRow);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.newHeight >= 0 && this.adjustRow >= 0) {
            this.parent.sendRet(16438, this.adjustRow + this.parent.getNumColHeadings(), this.newHeight / this.parent.font.getHeight(), false);
            this.adjustRow = -1;
            this.adjustRowCandidate = -1;
            this.newHeight = -1;
            this.parent.setBeginDrag(0);
            this.parent.setLastRowColDragged(-99, -99);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.adjustRowCandidate = this.getAdjustableRow(e.getPoint());
        if (this.adjustRowCandidate >= 0 != (this.table.getCursor() == this.resizeCursor)) {
            Cursor tmp = this.table.getCursor();
            this.table.setCursor(this.otherCursor);
            if (this.otherCursor != this.resizeCursor) {
                this.adjustRowCandidate = -1;
            }
            this.otherCursor = tmp;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.adjustRow >= 0) {
            this.parent.setBeginDrag(50);
            this.newHeight = e.getY() - this.mousepressedY;
            if (this.newHeight >= this.minvalue && this.newHeight <= this.maxvalue) {
                this.parent.intsetRowHeight(this.adjustRow + this.parent.getNumColHeadings(), this.newHeight);
                this.parent.getJTable().setRowHeight(this.adjustRow, this.newHeight);
            }
        }
    }

    public void setMinMaxHeight(int min, int hrd, float max) {
        this.minvalue = min;
        this.maxvalue = (int)(max * (float)hrd);
    }

    public int getAdjustRowCandidate() {
        return this.adjustRowCandidate;
    }
}

