/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.easydb;

import com.iscobol.easydb.Condition;
import com.iscobol.easydb.EdbiIs;
import com.iscobol.easydb.EdbiIsCommon;
import com.iscobol.easydb.Field;
import com.iscobol.easydb.Index;
import com.iscobol.easydb.IndexList;
import com.iscobol.easydb.Macro;
import com.iscobol.easydb.Segment;
import com.iscobol.easydb.SimpleCondition;
import com.iscobol.easydb.SimpleConditionList;
import com.iscobol.easydb.StringList;
import com.iscobol.easydb.Table;
import com.iscobol.rts.RtsUtil;
import java.io.File;
import java.io.StringReader;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XmlDocument
implements EdbiIsCommon {
    public EdbiIs edbi;
    boolean isEfdParser = false;
    boolean efdParserFlagIncludeComments = false;
    boolean efdParserFlagInclude999 = false;
    boolean efdParserFlagExcludeArrays = false;
    boolean efdParserFlagDeepFirst = false;
    public static final Hashtable<String, Integer> hdescfrmt = new Hashtable();
    DocumentBuilderFactory factory = RtsUtil.newDocumentBuilderFactory();
    DocumentBuilder builder = null;
    Document doc = null;

    public XmlDocument(EdbiIs ed, String fileName, String xmlContent, boolean isEfdP, int efdFlags) {
        this.isEfdParser = isEfdP;
        if (efdFlags >= 8) {
            this.efdParserFlagDeepFirst = true;
            efdFlags -= 8;
        }
        if (efdFlags >= 4) {
            this.efdParserFlagExcludeArrays = true;
            efdFlags -= 4;
        }
        if (efdFlags >= 2) {
            this.efdParserFlagInclude999 = true;
            efdFlags -= 2;
        }
        if (efdFlags > 0) {
            this.efdParserFlagIncludeComments = true;
        }
        this.edbi = ed;
        try {
            this.builder = this.factory.newDocumentBuilder();
            if (fileName != null) {
                this.doc = this.builder.parse(new File(fileName));
            } else {
                StringReader sr = new StringReader(xmlContent);
                InputSource is = new InputSource(sr);
                this.doc = this.builder.parse(is);
            }
            if (this.edbi.hasDebug()) {
                this.parseStream();
            }
        }
        catch (Exception e) {
            this.edbi.printErr(2, e.toString(), 0);
        }
    }

    public void parseStream() throws Exception {
        Element root = this.doc.getDocumentElement();
        this.parseNode(root);
    }

    public void parseNode(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                System.out.println("Element: " + node.getNodeName());
                NamedNodeMap attributes = node.getAttributes();
                if (attributes.getLength() > 0) {
                    System.out.println("\tAttributes: ");
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Attr attribute = (Attr)attributes.item(i);
                        System.out.print(attribute.getNodeName() + "=" + attribute.getNodeValue() + " ");
                    }
                    System.out.println();
                }
                this.parseChilds(node.getChildNodes());
                System.out.println("End element: " + node.getNodeName());
                break;
            }
            case 3: 
            case 4: {
                Text text = (Text)node;
                if (text.getNodeValue().trim().equals("")) break;
                System.out.println("\tText; " + text.getNodeValue());
                break;
            }
            default: {
                System.out.println(" DEFAULT nodeName: " + node.getNodeName());
                System.out.println(" DEFAULT nodeType: " + node.getNodeType());
            }
        }
    }

    public void parseChilds(NodeList childs) {
        if (childs.getLength() > 0) {
            for (int i = 0; i < childs.getLength(); ++i) {
                this.parseNode(childs.item(i));
            }
        }
    }

    public void carTable(Table tab) {
        Element root = this.doc.getDocumentElement();
        NamedNodeMap attributes = root.getAttributes();
        if (!root.getNodeName().equalsIgnoreCase("table")) {
            this.edbi.printErr(23, "Invalid sytntax tag name [" + root.getNodeName() + "] unknown!", 1);
            return;
        }
        if (attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attr = (Attr)attributes.item(i);
                String attrName = attr.getNodeName();
                if (attrName.equalsIgnoreCase("name")) {
                    tab.tabname = attr.getNodeValue().replace('-', '_');
                    tab.cobtabname = attr.getNodeValue().replace('_', '-');
                    continue;
                }
                if (attrName.equalsIgnoreCase("type")) {
                    if (!(attr.getNodeValue().equalsIgnoreCase("idx") || attr.getNodeValue().equalsIgnoreCase("rel") || attr.getNodeValue().equalsIgnoreCase("seq"))) {
                        this.edbi.printErr(23, "Only IDX REL and SEQ type is required!", 1);
                        return;
                    }
                    if (attr.getNodeValue().equalsIgnoreCase("rel")) {
                        tab.setFileOrg(1);
                        continue;
                    }
                    if (!attr.getNodeValue().equalsIgnoreCase("seq")) continue;
                    tab.setFileOrg(2);
                    continue;
                }
                if (attrName.equalsIgnoreCase("maxRecLen")) {
                    tab.maxRecLen = Integer.parseInt(attr.getNodeValue());
                    if (tab.maxRecLen <= 999999) continue;
                    this.edbi.printErr(23, "Invalid maxRecLen in tag TABLE records longer than 999999 bytes not supported!!", 1);
                    return;
                }
                if (attrName.equalsIgnoreCase("minRecLen")) {
                    tab.minRecLen = Integer.parseInt(attr.getNodeValue());
                    continue;
                }
                if (attrName.equalsIgnoreCase("temporary")) {
                    tab.temporary = attr.getNodeValue();
                    continue;
                }
                if (attrName.equalsIgnoreCase("keyCount")) {
                    tab.keyCount = Integer.parseInt(attr.getNodeValue());
                    continue;
                }
                this.edbi.printErr(23, "Invalid sytntax in tag TABLE[" + attrName + "] unknown attribute!", 1);
                return;
            }
        }
    }

    public void carIndexes(Table tab) {
        Element root = this.doc.getDocumentElement();
        NodeList childs = root.getChildNodes();
        IndexList indexes = tab.indexes;
        Index idx = null;
        for (int i = 0; i < childs.getLength(); ++i) {
            String attrName;
            Attr attr;
            Node node = childs.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("key")) continue;
            NamedNodeMap attributes = node.getAttributes();
            idx = new Index(this.edbi, false);
            indexes.addItem(idx);
            if (attributes.getLength() > 0) {
                for (int j = 0; j < attributes.getLength(); ++j) {
                    attr = (Attr)attributes.item(j);
                    attrName = attr.getNodeName();
                    if (attrName.equalsIgnoreCase("segCount")) {
                        idx.segNum = Integer.parseInt(attr.getNodeValue());
                        if (idx.segNum <= 1) continue;
                        idx.isSplit = true;
                        continue;
                    }
                    if (attrName.equalsIgnoreCase("duplicate")) {
                        if (attr.getNodeValue().equalsIgnoreCase("true")) {
                            idx.idxdups = true;
                            tab.haveDups = true;
                            continue;
                        }
                        idx.idxdups = false;
                        continue;
                    }
                    this.edbi.printErr(23, "Invalid sytntax in tag KEY[" + attrName + "] unknown attribute!", 1);
                    return;
                }
            }
            NodeList childsKey = node.getChildNodes();
            for (int j = 0; childsKey != null && j < childsKey.getLength(); ++j) {
                node = childsKey.item(j);
                if (node != null && node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("segment")) {
                    attributes = node.getAttributes();
                    Segment seg = new Segment();
                    idx.segments.addItem(seg);
                    if (attributes.getLength() <= 0) continue;
                    for (int p = 0; p < attributes.getLength(); ++p) {
                        attr = (Attr)attributes.item(p);
                        attrName = attr.getNodeName();
                        if (attrName.equalsIgnoreCase("offset")) {
                            seg.offset = Integer.parseInt(attr.getNodeValue());
                            continue;
                        }
                        if (attrName.equalsIgnoreCase("size")) {
                            seg.size = Integer.parseInt(attr.getNodeValue());
                            continue;
                        }
                        this.edbi.printErr(23, "Invalid sytntax in tag SEGMENT[" + attrName + "] unknown attribute!", 1);
                        return;
                    }
                    continue;
                }
                if (node == null || node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("part") || (attributes = node.getAttributes()).getLength() <= 0) continue;
                for (int n = 0; n < attributes.getLength(); ++n) {
                    attr = (Attr)attributes.item(n);
                    attrName = attr.getNodeName();
                    if (!attrName.equalsIgnoreCase("name")) {
                        this.edbi.printErr(23, "Invalid sytntax in tag PART[" + attrName + "] unknown attribute!", 1);
                        return;
                    }
                    idx.namePart.addItem(new String(attr.getNodeValue()));
                }
            }
        }
    }

    public void carConditions(Table tab) {
        Element root = this.doc.getDocumentElement();
        NodeList childs = root.getChildNodes();
        String strCond = "";
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("conditions")) continue;
            NodeList childsKey = node.getChildNodes();
            String table = "";
            int numCond = -1;
            String field = "";
            String op = "";
            String value = "";
            for (int j = 0; j < childsKey.getLength(); ++j) {
                node = childsKey.item(j);
                StringList fieldCond = new StringList();
                if (node == null || node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("condition")) continue;
                strCond = "";
                field = "";
                op = "";
                value = "";
                String sp = "";
                NamedNodeMap attributes = node.getAttributes();
                if (attributes.getLength() > 0) {
                    for (int p = 0; p < attributes.getLength(); ++p) {
                        Attr attr = (Attr)attributes.item(p);
                        String attrName = attr.getNodeName();
                        if (attrName.equalsIgnoreCase("number")) {
                            numCond = Integer.parseInt(attr.getNodeValue());
                        } else if (attrName.equalsIgnoreCase("table")) {
                            table = attr.getNodeValue().toUpperCase();
                        } else if (attrName.equalsIgnoreCase("name")) {
                            strCond = strCond + sp + attr.getNodeValue();
                            fieldCond.addIfNotExist(attr.getNodeValue());
                            field = attr.getNodeValue();
                        } else if (attrName.equalsIgnoreCase("op")) {
                            strCond = strCond + sp + this.getOp(attr.getNodeValue());
                            op = attr.getNodeValue();
                        } else {
                            this.edbi.printErr(23, "Invalid sytntax in tag CONDITION[" + attrName + "] unknown attribute!", 1);
                            return;
                        }
                        sp = " ";
                    }
                }
                NodeList childsCond = node.getChildNodes();
                SimpleConditionList simplConds = new SimpleConditionList();
                for (int p = 0; p < childsCond.getLength(); ++p) {
                    node = childsCond.item(p);
                    if (node == null || node.getNodeType() != 1) continue;
                    strCond = strCond + this.carComplexCondition(node, tab, fieldCond, simplConds);
                }
                node = childsCond.item(0);
                if (node != null && node.getNodeType() == 3) {
                    strCond = strCond + " " + node.getNodeValue();
                    value = node.getNodeValue();
                }
                Condition cond = new Condition(table, numCond, strCond, simplConds);
                cond.fieldCond = fieldCond;
                if (field.length() == 0 && simplConds.getItemNum() > 0) {
                    field = simplConds.getFirst().field;
                }
                if (op.length() == 0 && simplConds.getItemNum() > 0) {
                    if (simplConds.getFirst().and) {
                        op = "and";
                    } else if (simplConds.getFirst().or) {
                        op = "or";
                    }
                }
                cond.field = field;
                cond.op = op;
                cond.value = value.trim();
                if (this.edbi.hasDebug()) {
                    System.err.println("num " + numCond + " name[" + table + "] [" + strCond + "]" + Macro.eol + "field[" + field + "] op[" + op + "] value[" + value + "]");
                }
                if (table.equalsIgnoreCase(tab.getCobName())) {
                    cond.isRedefines = true;
                }
                tab.conditions.addItemOrChild(cond);
                tab.numConditions = tab.numConditions + 1 + simplConds.getItemNum();
                tab.numSimplConditions += simplConds.getItemNum();
                if (!cond.condition.equalsIgnoreCase("EDBIDEFAULT")) continue;
                tab.setDefaultCond(true);
            }
        }
        int condCount = tab.numConditions - tab.numSimplConditions;
        SimpleCondition simplCond = null;
        Condition conCh = null;
        Condition con = tab.getCondition().getFirst();
        while (con != null) {
            simplCond = con.simpleCond.getFirst();
            if (simplCond != null) {
                simplCond.number = ++condCount;
            }
            while (simplCond != null) {
                simplCond = con.simpleCond.getNext();
                if (simplCond == null) continue;
                simplCond.number = ++condCount;
            }
            conCh = con.childsCond.getFirst();
            while (conCh != null) {
                simplCond = conCh.simpleCond.getFirst();
                if (simplCond != null) {
                    simplCond.number = ++condCount;
                }
                while (simplCond != null) {
                    simplCond = conCh.simpleCond.getNext();
                    if (simplCond == null) continue;
                    simplCond.number = ++condCount;
                }
                conCh = con.childsCond.getNext();
            }
            con = tab.getCondition().getNext();
        }
    }

    String getOp(String val) {
        String op = "";
        if (val.equalsIgnoreCase("EQ")) {
            op = "=";
        } else if (val.equalsIgnoreCase("GT")) {
            op = ">";
        } else if (val.equalsIgnoreCase("LT")) {
            op = "<";
        } else if (val.equalsIgnoreCase("GE")) {
            op = "not <";
        } else if (val.equalsIgnoreCase("LE")) {
            op = "not >";
        } else if (val.equalsIgnoreCase("NE")) {
            op = "not =";
        } else if (val.equalsIgnoreCase("DEFAULT")) {
            op = "EDBIDEFAULT";
        } else {
            this.edbi.printErr(23, "Invalid value in attribute op [" + val + "]!", 1);
            return "";
        }
        return op;
    }

    String carComplexCondition(Node node, Table tab, StringList fieldCond, SimpleConditionList simpCondList) {
        String attrName = "";
        String strCond = "";
        if (node != null && node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("paren")) {
            strCond = strCond + " (";
            NodeList childsCond = node.getChildNodes();
            for (int p = 0; p < childsCond.getLength(); ++p) {
                node = childsCond.item(p);
                strCond = strCond + this.carComplexCondition(node, tab, fieldCond, simpCondList);
            }
            strCond = strCond + " )";
        } else if (node != null && node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("and")) {
            strCond = strCond + Macro.eol + "                  and";
            if (simpCondList.getLast() != null) {
                simpCondList.getLast().and = true;
            }
        } else if (node != null && node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("or")) {
            strCond = strCond + Macro.eol + "                  or";
            if (simpCondList.getLast() != null) {
                simpCondList.getLast().or = true;
            }
        } else if (node != null && node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("simple_condition")) {
            NodeList values;
            String simpName = "";
            String simpOp = "";
            String simpVal = "";
            NamedNodeMap attributes = node.getAttributes();
            if (attributes.getLength() > 0) {
                for (int t = 0; t < attributes.getLength(); ++t) {
                    Attr attr = (Attr)attributes.item(t);
                    attrName = attr.getNodeName();
                    if (attrName.equalsIgnoreCase("name")) {
                        simpName = attr.getNodeValue();
                        strCond = strCond + " " + simpName;
                        fieldCond.addIfNotExist(simpName);
                        continue;
                    }
                    if (attrName.equalsIgnoreCase("op")) {
                        simpOp = attr.getNodeValue();
                        strCond = strCond + " " + this.getOp(simpOp);
                        continue;
                    }
                    this.edbi.printErr(23, "Invalid sytntax in tag SIMPLE_CONDITION[" + attrName + "] unknown attribute!", 1);
                    return "";
                }
            }
            if ((node = (values = node.getChildNodes()).item(0)) != null && node.getNodeType() == 3) {
                strCond = strCond + " " + node.getNodeValue();
            }
            simpVal = node.getNodeValue();
            simpCondList.addItem(new SimpleCondition(simpName, simpOp, simpVal));
        }
        return strCond;
    }

    public void carFields(Table tab) {
        Element root = this.doc.getDocumentElement();
        NodeList childs = root.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if (node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("field")) {
                this.carField(tab, node, -1, "", "", 0);
                continue;
            }
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("occurs")) continue;
            this.carOccurs(tab, node, -1, "", "", 0);
        }
    }

    void carField(Table tab, Node node, int xmlcondition, String suffix, String efdParseOccs, int offsOccurs) {
        String xmlname = "";
        String xmltype = "";
        String xmldbtype = "";
        int xmloffset = -1;
        int xmlsize = -1;
        int origcondition = -1;
        int xmlformat = -1;
        int xmltime = -1;
        int xmlscale = 0;
        int xmldigits = 0;
        boolean hidden = false;
        boolean trailing = false;
        boolean separate = false;
        boolean leading = false;
        boolean timeFirst = false;
        int format = 0;
        int fldtype = -1;
        int flddbtype = 8;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attr = (Attr)attributes.item(i);
                String attrName = attr.getNodeName();
                if (attrName.equalsIgnoreCase("name")) {
                    xmlname = attr.getNodeValue() + suffix;
                    continue;
                }
                if (attrName.equalsIgnoreCase("offset")) {
                    xmloffset = Integer.parseInt(attr.getNodeValue()) + offsOccurs;
                    continue;
                }
                if (attrName.equalsIgnoreCase("size")) {
                    xmlsize = Integer.parseInt(attr.getNodeValue());
                    continue;
                }
                if (attrName.equalsIgnoreCase("condition")) {
                    origcondition = xmlcondition = Integer.parseInt(attr.getNodeValue());
                    continue;
                }
                if (attrName.equalsIgnoreCase("digits")) {
                    xmldigits = Integer.parseInt(attr.getNodeValue());
                    continue;
                }
                if (attrName.equalsIgnoreCase("scale")) {
                    xmlscale = Integer.parseInt(attr.getNodeValue());
                    continue;
                }
                if (attrName.equalsIgnoreCase("hidden")) {
                    if (attr.getNodeValue().equalsIgnoreCase("true")) {
                        hidden = true;
                        continue;
                    }
                    hidden = false;
                    continue;
                }
                if (attrName.equalsIgnoreCase("format")) {
                    int p;
                    String frmt = attr.getNodeValue();
                    Integer t = hdescfrmt.get(frmt);
                    if (t != null) {
                        xmlformat = t;
                        continue;
                    }
                    for (p = EdbiIs.timefrmt.length - 1; p >= 0 && !frmt.startsWith(EdbiIs.timefrmt[p]) && !frmt.endsWith(EdbiIs.timefrmt[p]); --p) {
                    }
                    if (p <= 0) {
                        this.edbi.printErr(23, "Invalid sytntax in tag FIELD unknown attribute type value[" + attr.getNodeValue() + "]!", 1);
                        return;
                    }
                    if (frmt.startsWith(EdbiIs.timefrmt[p])) {
                        xmlformat = hdescfrmt.get(frmt.substring(EdbiIs.timefrmt[p].length()));
                        timeFirst = true;
                    } else {
                        xmlformat = hdescfrmt.get(frmt.substring(0, frmt.indexOf(EdbiIs.timefrmt[p])));
                    }
                    xmltime = hdescfrmt.get(EdbiIs.timefrmt[p]);
                    continue;
                }
                if (attrName.equalsIgnoreCase("dbtype")) {
                    xmldbtype = attr.getNodeValue();
                    if (xmldbtype.equalsIgnoreCase("DATE")) {
                        flddbtype = 4;
                        continue;
                    }
                    if (xmldbtype.equalsIgnoreCase("BINARY")) {
                        flddbtype = 7;
                        continue;
                    }
                    if (xmldbtype.equalsIgnoreCase("LONGCHAR")) {
                        flddbtype = 1;
                        continue;
                    }
                    if (xmldbtype.equalsIgnoreCase("CHAR")) {
                        flddbtype = 0;
                        continue;
                    }
                    if (xmldbtype.equalsIgnoreCase("LONGBINARY") || xmldbtype.equalsIgnoreCase("SERIAL")) continue;
                    this.edbi.printErr(23, "Invalid sytntax in tag FIELD unknown attribute dbtype value[" + attr.getNodeValue() + "]!", 1);
                    return;
                }
                if (attrName.equalsIgnoreCase("type")) {
                    xmltype = attr.getNodeValue();
                    if (xmltype.equalsIgnoreCase("NUMSIGNED")) {
                        fldtype = 3;
                        format = 0;
                        continue;
                    }
                    if (xmltype.equalsIgnoreCase("NUMUNSIGNED")) {
                        fldtype = 2;
                        format = 0;
                        continue;
                    }
                    if (xmltype.equalsIgnoreCase("NUMSIGNSEP")) {
                        fldtype = 3;
                        format = 0;
                        trailing = true;
                        separate = true;
                        continue;
                    }
                    if (xmltype.equalsIgnoreCase("NUMSEPLEAD")) {
                        fldtype = 3;
                        format = 0;
                        separate = true;
                        leading = true;
                        continue;
                    }
                    if (xmltype.equalsIgnoreCase("NUMLEADING")) {
                        fldtype = 3;
                        format = 0;
                        leading = true;
                        continue;
                    }
                    if (xmltype.equalsIgnoreCase("COMPSIGNED")) {
                        format = 3;
                        fldtype = 3;
                        continue;
                    }
                    if (xmltype.equalsIgnoreCase("COMPUNSIGNED")) {
                        format = 3;
                        fldtype = 3;
                        continue;
                    }
                    if (xmltype.equalsIgnoreCase("PACKEDPOSITIVE")) {
                        format = 4;
                        fldtype = 2;
                        continue;
                    }
                    if (xmltype.equalsIgnoreCase("PACKEDSIGNED")) {
                        format = 4;
                        fldtype = 3;
                        continue;
                    }
                    if (xmltype.equalsIgnoreCase("PACKEDUNSIGNED")) {
                        format = 5;
                        fldtype = 2;
                        continue;
                    }
                    if (xmltype.equalsIgnoreCase("BINARYSIGNED")) {
                        format = 1;
                        fldtype = 3;
                        continue;
                    }
                    if (xmltype.equalsIgnoreCase("BINARYUNSIGNED")) {
                        format = 1;
                        fldtype = 2;
                        continue;
                    }
                    if (xmltype.equalsIgnoreCase("NATIVESIGNED")) {
                        format = 2;
                        fldtype = 3;
                        continue;
                    }
                    if (xmltype.equalsIgnoreCase("NATIVEUNSIGNED")) {
                        format = 2;
                        fldtype = 2;
                        continue;
                    }
                    if (xmltype.equalsIgnoreCase("FLOAT")) {
                        format = 0;
                        fldtype = 3;
                        continue;
                    }
                    if (xmltype.equalsIgnoreCase("ALPHANUM") || xmltype.equalsIgnoreCase("NATIONAL")) {
                        format = 0;
                        fldtype = 0;
                        continue;
                    }
                    this.edbi.printErr(23, "Invalid sytntax in tag FIELD unknown attribute type value[" + attr.getNodeValue() + "]!", 1);
                    return;
                }
                this.edbi.printErr(23, "Invalid sytntax in tag FIELD[" + attrName + "] unknown attribute!", 1);
                return;
            }
        }
        NodeList childs = node.getChildNodes();
        if (!hidden || this.isInCond(tab, xmlname) || this.isEfdParser && hidden && childs.getLength() == 0 || this.efdParserFlagInclude999) {
            if (xmldbtype.equalsIgnoreCase("DATE")) {
                fldtype = 4;
            }
            if (xmldbtype.equalsIgnoreCase("BINARY") && EdbiIs.dbt == 0) {
                fldtype = 0;
                xmltype = "ALPHANUM";
            }
            Field fld = new Field(this.edbi, xmlname, xmltype, xmlformat, xmltime, xmloffset, xmlsize, xmldigits, xmlscale, xmlcondition, origcondition, hidden, fldtype, leading, trailing, separate, flddbtype, format, timeFirst);
            fld.xmldbtypeS = xmldbtype;
            if (hidden && this.isInCond(tab, xmlname)) {
                tab.fieldsRedefines.addItem(fld);
            } else {
                tab.fields.addItem(fld);
            }
            if (this.isEfdParser && suffix.length() > 0) {
                fld.suffix = suffix.substring(1);
                fld.efdParseOccs = efdParseOccs.substring(1);
            }
            if (!fld.getIntType().equalsIgnoreCase(fld.getCobType()) || fldtype == 4) {
                tab.haveSameBuffs = false;
            }
            if (fld.getTimeType().length() > 0) {
                tab.hasTime = true;
            }
            if (!xmlname.equalsIgnoreCase("FILLER")) {
                tab.sqlfields.addItem(fld);
            }
            if (this.edbi.hasDebug()) {
                System.out.println("Created field [" + xmlname + "," + xmltype + "," + xmloffset + "," + xmlsize + "," + xmldigits + "," + xmlscale + "," + xmlcondition + "," + origcondition + "," + hidden + "," + fldtype + "," + leading + "," + trailing + "," + separate + "," + flddbtype + "," + format + "]" + suffix);
            }
        }
        for (int i = 0; i < childs.getLength(); ++i) {
            node = childs.item(i);
            if (node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("field")) {
                if (this.edbi.hasDebug()) {
                    System.out.println("   ADD a child at[" + xmlname + "]");
                }
                this.carField(tab, node, xmlcondition, suffix, efdParseOccs, offsOccurs);
                continue;
            }
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("occurs")) continue;
            if (this.edbi.hasDebug()) {
                System.out.println("   Found OCCURS[" + xmlname + "]");
            }
            this.carOccurs(tab, node, xmlcondition, suffix, efdParseOccs, offsOccurs);
        }
    }

    void carOccurs(Table tab, Node node, int xmlcondition, String suffix, String efdParseOccs, int offsOccurs) {
        NamedNodeMap attributes = node.getAttributes();
        int occurs = 1;
        int size = 1;
        if (attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attr = (Attr)attributes.item(i);
                String attrName = attr.getNodeName();
                if (attrName.equalsIgnoreCase("number")) {
                    occurs = Integer.parseInt(attr.getNodeValue());
                    continue;
                }
                if (!attrName.equalsIgnoreCase("size")) continue;
                size = Integer.parseInt(attr.getNodeValue());
            }
        }
        String tmp = "" + occurs;
        int suffLen = tmp.length();
        NodeList childs = node.getChildNodes();
        boolean optNO = false;
        if (this.edbi.getOption("-no") != null) {
            optNO = true;
        }
        for (int i = 0; i < childs.getLength(); ++i) {
            node = childs.item(i);
            for (int j = 1; j <= occurs; ++j) {
                String intEfdParseOccs;
                String intSuff;
                if (optNO) {
                    tmp = "00000000000000000" + j;
                    intSuff = suffix + "_" + tmp.substring(tmp.length() - suffLen);
                    intEfdParseOccs = efdParseOccs + "_" + occurs;
                } else {
                    intSuff = suffix + "_" + j;
                    intEfdParseOccs = efdParseOccs + "_" + occurs;
                }
                int intOffsOccurs = offsOccurs + size * (j - 1);
                if (node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("field")) {
                    this.carField(tab, node, xmlcondition, intSuff, intEfdParseOccs, intOffsOccurs);
                    continue;
                }
                if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("occurs")) continue;
                this.carOccurs(tab, node, xmlcondition, intSuff, intEfdParseOccs, intOffsOccurs);
            }
        }
    }

    boolean isInCond(Table tab, String xmlname) {
        Condition cond = tab.conditions.getFirst();
        while (cond != null) {
            if (xmlname.equalsIgnoreCase(cond.field)) {
                return true;
            }
            Condition condC = cond.childsCond.getFirst();
            while (condC != null) {
                if (xmlname.equalsIgnoreCase(condC.field)) {
                    return true;
                }
                condC = cond.childsCond.getNext();
            }
            cond = tab.conditions.getNext();
        }
        return false;
    }

    static {
        hdescfrmt.put("NOFRMT", new Integer(0));
        hdescfrmt.put("BINARYFRMT", new Integer(1));
        hdescfrmt.put("NATIVEFRMT", new Integer(2));
        hdescfrmt.put("COMPFRMT", new Integer(3));
        hdescfrmt.put("PACKEDFRMT", new Integer(4));
        hdescfrmt.put("PACKEDUFRMT", new Integer(5));
        hdescfrmt.put("DDMMYY", new Integer(6));
        hdescfrmt.put("YYMMDD", new Integer(7));
        hdescfrmt.put("DDMMYYYY", new Integer(8));
        hdescfrmt.put("YYYYMMDD", new Integer(9));
        hdescfrmt.put("MMDDYY", new Integer(10));
        hdescfrmt.put("MMDDYYYY", new Integer(11));
        hdescfrmt.put("YY", new Integer(12));
        hdescfrmt.put("YYY", new Integer(13));
        hdescfrmt.put("MMYY", new Integer(14));
        hdescfrmt.put("YYMM", new Integer(15));
        hdescfrmt.put("HH", new Integer(16));
        hdescfrmt.put("HHNN", new Integer(17));
        hdescfrmt.put("HHNNSS", new Integer(18));
        hdescfrmt.put("HHNNSSTT", new Integer(19));
        hdescfrmt.put("JJJ", new Integer(20));
        hdescfrmt.put("JJJJ", new Integer(21));
        hdescfrmt.put("JJJJJ", new Integer(22));
        hdescfrmt.put("JJJJJJ", new Integer(23));
        hdescfrmt.put("JJJJJJJ", new Integer(24));
        hdescfrmt.put("JJJJJJJJ", new Integer(25));
        hdescfrmt.put("YYYYEEE", new Integer(27));
        hdescfrmt.put("EEEYYYY", new Integer(28));
        hdescfrmt.put("YYEEE", new Integer(29));
        hdescfrmt.put("EEEYY", new Integer(30));
    }
}

