/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.easydb;

import com.iscobol.compiler.MyStringTokenizer;
import com.iscobol.compiler.Token;
import com.iscobol.easydb.EdbiIs;
import com.iscobol.easydb.EdbiIsCommon;
import com.iscobol.rts.Config;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;

public class OptionList
implements Cloneable,
EdbiIsCommon {
    public static String eol = System.getProperty("line.separator", "\n");
    public static String newLineFill = eol + "             ";
    public static final String CONLY = "-conly=";
    public static final String C = "-c=";
    public static final String CSQQ = "-csqq";
    public static final String D2 = "-d2";
    public static final String D4 = "-d4";
    public static final String DI = "-di";
    public static final String DM = "-dm";
    public static final String DMLD = "-dmld";
    public static final String DMLU = "-dmlu";
    public static final String DMOID = "-dmoid=";
    public static final String DO = "-do";
    public static final String DP = "-dp";
    public static final String DPLD = "-dpld";
    public static final String DPLU = "-dplu";
    public static final String DPOID = "-dpoid=";
    public static final String DS = "-ds";
    public static final String DSLD = "-dsld";
    public static final String DSLU = "-dslu";
    public static final String DSOID = "-dsoid=";
    public static final String DCD = "-dcd";
    public static final String DZ = "-dz";
    public static final String CA = "-ca";
    public static final String CC = "-cc";
    public static final String CE = "-ce";
    public static final String CP = "-cp";
    public static final String DEFCHAR = "-defchar";
    public static final String ESST = "-esst";
    public static final String H = "-h";
    public static final String I = "-i";
    public static final String JCD = "-jcd=";
    public static final String JDC = "-jdc=";
    public static final String LD = "-ld=";
    public static final String MAXCHARLEN = "-maxcharlen=";
    public static final String MO = "-mo";
    public static final String N = "-n";
    public static final String NN = "-nn";
    public static final String NO = "-no";
    public static final String PDO = "-pdo";
    public static final String OC = "-oc=";
    public static final String OD = "-od=";
    public static final String OS = "-os=";
    public static final String SL = "-sl";
    public static final String T = "-t";
    public static final String UA = "-ua";
    public static final String V = "-v";
    public static final String ID = "-id";
    public static final String OH = "-oh";
    public static final String OHO = "-oho";
    public static final String OII = "-oii=";
    public static final String OIT = "-oit=";
    public static final String ONI = "-oni=";
    public static final String ONT = "-ont=";
    public static final String OPI = "-opi=";
    public static final String OPT = "-opt=";
    public static final String OTI = "-oti=";
    public static final String OTT = "-ott=";
    public static final String OW = "-ow";
    public static final String OWFL = "-owfl";
    public static final String PI = "-pi";
    public static final String SC = "-sc";
    public static final String SCO = "-sco";
    public static final String SDT = "-sdt";
    public static final String HELP = "-help";
    public static final String ENTRYPOINTS = "-entrypoints";
    public static final String NOCHECK = "-nocheck";
    public static final String PREFIX = "-prefix=";
    public static final String MH = "-mh";
    public static final String SQL = "-sql";
    private static Hashtable<String, String> allOpts = new Hashtable();
    private static Hashtable<String, String> allOra = new Hashtable();
    private static Hashtable<String, String> allInf = new Hashtable();
    private static Hashtable<String, String> allPos = new Hashtable();
    private static Hashtable<String, String> allSer = new Hashtable();
    private static Hashtable<String, String> allMys = new Hashtable();
    private Hashtable<String, String> optArgs = new Hashtable();
    private String[] notOptArgs = new String[]{""};
    private int errorNum = 0;
    private String error;
    private HashMap<String, String> savedProps = new HashMap();

    public Object clone() {
        OptionList Return2;
        try {
            Return2 = (OptionList)super.clone();
            Return2.optArgs = (Hashtable)this.optArgs.clone();
            Return2.notOptArgs = (String[])this.notOptArgs.clone();
        }
        catch (CloneNotSupportedException _ex) {
            Return2 = null;
        }
        return Return2;
    }

    public OptionList(String[] argv) {
        String fixedOpt;
        this.addOptions(argv);
        String propName = null;
        propName = this.getOption(CONLY);
        if (propName != null && propName.length() != 0) {
            System.setProperty("iscobol.conf.only", propName);
            Config.setProperty("iscobol.conf", propName);
        }
        if ((propName = this.getOption(C)) != null && propName.length() != 0) {
            System.setProperty("iscobol.conf", propName);
            Config.setProperty("iscobol.conf", propName);
        }
        if ((fixedOpt = Config.getProperty(".jeasydb.options", null)) != null) {
            MyStringTokenizer st = new MyStringTokenizer(fixedOpt);
            String[] fixopt = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                fixopt[i] = st.nextToken();
                ++i;
            }
            this.addOptions(fixopt, true);
        }
    }

    void checkOptions(EdbiIs edbi) {
        Enumeration<String> en = this.optArgs.keys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            if (!key.equalsIgnoreCase(DO) && !key.equalsIgnoreCase(D2) && !key.equalsIgnoreCase(D4) && !key.equalsIgnoreCase(DI) && !key.equalsIgnoreCase(DM) && !key.equalsIgnoreCase(DMLD) && !key.equalsIgnoreCase(DMLU) && !key.equalsIgnoreCase(DP) && !key.equalsIgnoreCase(DPLD) && !key.equalsIgnoreCase(DPLU) && !key.equalsIgnoreCase(DSLD) && !key.equalsIgnoreCase(DSLU) && !key.equalsIgnoreCase(DS)) continue;
            if (EdbiIs.dbt != 1) {
                edbi.printErr(25, key + " it is no possible to use more than one DB type", 0);
                return;
            }
            if (key.equalsIgnoreCase(DO)) {
                EdbiIs.dbt = 0;
                EdbiIs.suffix = ".pco";
                EdbiIs.dbStrType = "ORA";
                continue;
            }
            if (key.equalsIgnoreCase(D2)) {
                EdbiIs.dbt = 4;
                EdbiIs.suffix = ".db2";
                EdbiIs.dbStrType = "DB2";
                continue;
            }
            if (key.equalsIgnoreCase(D4)) {
                EdbiIs.dbt = 5;
                EdbiIs.suffix = ".d24";
                EdbiIs.dbStrType = "DB4";
                continue;
            }
            if (key.equalsIgnoreCase(DI)) {
                EdbiIs.dbt = 7;
                EdbiIs.suffix = ".ifx";
                EdbiIs.dbStrType = "IFX";
                continue;
            }
            if (key.equalsIgnoreCase(DM)) {
                EdbiIs.dbt = 3;
                EdbiIs.suffix = ".mys";
                EdbiIs.dbStrType = "MYS";
                continue;
            }
            if (key.equalsIgnoreCase(DMLD)) {
                EdbiIs.dbt = 3;
                EdbiIs.suffix = ".myl";
                EdbiIs.dbStrType = "MYS";
                continue;
            }
            if (key.equalsIgnoreCase(DMLU)) {
                EdbiIs.dbt = 3;
                EdbiIs.suffix = ".myl";
                EdbiIs.dbStrType = "MYS";
                continue;
            }
            if (key.equalsIgnoreCase(DP)) {
                EdbiIs.dbt = 6;
                EdbiIs.suffix = ".pgs";
                EdbiIs.dbStrType = "PGS";
                continue;
            }
            if (key.equalsIgnoreCase(DPLD)) {
                EdbiIs.dbt = 6;
                EdbiIs.suffix = ".pgl";
                EdbiIs.dbStrType = "PGS";
                continue;
            }
            if (key.equalsIgnoreCase(DPLU)) {
                EdbiIs.dbt = 6;
                EdbiIs.suffix = ".pgl";
                EdbiIs.dbStrType = "PGS";
                continue;
            }
            if (key.equalsIgnoreCase(DS)) {
                EdbiIs.dbt = 2;
                EdbiIs.suffix = ".srv";
                EdbiIs.dbStrType = "SRV";
                continue;
            }
            if (key.equalsIgnoreCase(DSLD)) {
                EdbiIs.dbt = 2;
                EdbiIs.suffix = ".srl";
                EdbiIs.dbStrType = "SRV";
                continue;
            }
            if (!key.equalsIgnoreCase(DSLU)) continue;
            EdbiIs.dbt = 2;
            EdbiIs.suffix = ".srl";
            EdbiIs.dbStrType = "SRV";
        }
        if (EdbiIs.dbt != 6 && this.optArgs.containsKey(PI)) {
            edbi.printErr(0, " -Pi requires -dp or -dpld or -dplu!!", 0);
        }
        if (EdbiIs.dbt != 2 && (this.optArgs.containsKey(SC) || this.optArgs.containsKey(SCO) || this.optArgs.containsKey(SDT))) {
            edbi.printErr(0, "with -Sc or -Sco or -Sdt -ds required!!", 0);
        }
        if (this.optArgs.containsKey(SCO) && this.optArgs.containsKey(SC)) {
            edbi.printErr(0, "-Sc and -Sco can not be used togheter!!", 0);
        }
        if (EdbiIs.dbt != 7 && this.optArgs.containsKey(ID)) {
            edbi.printErr(0, "-Id used -di required!!", 0);
        }
        if (EdbiIs.dbt != 3 && this.optArgs.containsKey(MH)) {
            edbi.printErr(0, "-mh used -dm or -dmld or -dmlu required!!", 0);
        }
        if (EdbiIs.dbt != 0 && (this.optArgs.containsKey(CE) || this.optArgs.containsKey(OH) || this.optArgs.containsKey(OHO) || this.optArgs.containsKey(OW) || this.optArgs.containsKey(OII) || this.optArgs.containsKey(OIT) || this.optArgs.containsKey(ONI) || this.optArgs.containsKey(ONT) || this.optArgs.containsKey(OPI) || this.optArgs.containsKey(OPT) || this.optArgs.containsKey(OTI) || this.optArgs.containsKey(OTT) || this.optArgs.containsKey(OWFL))) {
            edbi.printErr(0, "used an option that requires -do!!", 0);
        }
        if (this.optArgs.containsKey(OH) && this.optArgs.containsKey(OHO)) {
            edbi.printErr(0, "-Oh and -Oho can not be used togheter!!", 0);
        }
        if (this.optArgs.containsKey(OHO) && this.optArgs.containsKey(PDO)) {
            edbi.printErr(0, "-Oho can not be used with -pdo option!!", 0);
        }
        if (this.optArgs.containsKey(OW) && this.optArgs.containsKey(OWFL)) {
            edbi.printErr(0, "-Ow and -Owfl can not be used togheter!!", 0);
        }
        if (this.optArgs.containsKey(CA)) {
            this.optArgs.put(DEFCHAR, "");
        }
        if (this.optArgs.containsKey(DEFCHAR) && this.optArgs.containsKey(MAXCHARLEN)) {
            edbi.printErr(0, "-defCHAR and -macCHARlen can not be used togheter!!", 0);
        }
        if (this.optArgs.containsKey(DMOID) && !this.optArgs.containsKey(DMLD)) {
            edbi.printErr(0, "-dmoid=<name>  must be used with -dmld option!!", 0);
        } else if (this.optArgs.containsKey(DMOID)) {
            EdbiIs.oidName = this.getOption(DMOID);
        }
        if (this.optArgs.containsKey(DPOID) && !this.optArgs.containsKey(DPLD)) {
            edbi.printErr(0, "-dpoid=<name>  must be used with -dpld option!!", 0);
        } else if (this.optArgs.containsKey(DPOID)) {
            EdbiIs.oidName = this.getOption(DPOID);
        }
        if (this.optArgs.containsKey(DSOID) && !this.optArgs.containsKey(DSLD)) {
            edbi.printErr(0, "-dsoid=<name>  must be used with -dsld option!!", 0);
        } else if (this.optArgs.containsKey(DSOID)) {
            EdbiIs.oidName = this.getOption(DSOID);
        }
        if (this.optArgs.containsKey(JCD) && !this.optArgs.containsKey(JDC)) {
            edbi.printErr(0, " -jcd  and -jdc must be used together!!", 0);
        }
        if (this.optArgs.containsKey(CP)) {
            edbi.printErr(0, "WARNING -cp option no more supported!!", 0);
        }
        if (this.optArgs.containsKey(LD)) {
            edbi.printErr(0, "WARNING -ld= option no more supported!!", 0);
        }
        if (this.optArgs.containsKey(OC)) {
            edbi.printErr(0, "WARNING -oc= option no more supported!!", 0);
        }
        if (this.optArgs.containsKey(MAXCHARLEN)) {
            edbi.setMaxCharLen(Integer.parseInt(this.optArgs.get(MAXCHARLEN)));
        }
    }

    public boolean hasErrors() {
        return this.error != null;
    }

    public String getErrors() {
        return this.error;
    }

    public int getErrorNum() {
        return this.errorNum;
    }

    public String addOption(String arg) {
        String Return2;
        int eq = arg.indexOf(61) + 1;
        if (arg.charAt(0) == '#') {
            arg = '-' + arg.substring(1, arg.length());
            if (eq > 1) {
                Return2 = arg.substring(0, eq).toLowerCase(Locale.US);
                this.optArgs.remove(Return2);
            } else {
                Return2 = arg.toLowerCase(Locale.US);
                this.optArgs.remove(Return2);
            }
        } else if (eq > 1 && (allOpts.containsKey(arg.substring(0, eq).toLowerCase(Locale.US)) || allOra.containsKey(arg.substring(0, eq).toLowerCase(Locale.US)) || allInf.containsKey(arg.substring(0, eq).toLowerCase(Locale.US)) || allMys.containsKey(arg.substring(0, eq).toLowerCase(Locale.US)) || allPos.containsKey(arg.substring(0, eq).toLowerCase(Locale.US)) || allSer.containsKey(arg.substring(0, eq).toLowerCase(Locale.US)))) {
            Return2 = arg.substring(0, eq).toLowerCase(Locale.US);
            this.optArgs.put(Return2, arg.substring(eq));
        } else if (allOpts.containsKey(arg.toLowerCase(Locale.US)) || allOra.containsKey(arg.toLowerCase(Locale.US)) || allInf.containsKey(arg.toLowerCase(Locale.US)) || allMys.containsKey(arg.toLowerCase(Locale.US)) || allPos.containsKey(arg.toLowerCase(Locale.US)) || allSer.containsKey(arg.toLowerCase(Locale.US))) {
            Return2 = arg.toLowerCase(Locale.US);
            this.optArgs.put(Return2, "");
        } else {
            Return2 = null;
        }
        return Return2;
    }

    public void addOptions(String[] argv) {
        this.addOptions(argv, false);
    }

    public void addOptions(String[] argv, boolean fixed) {
        Vector<String> noa = new Vector<String>();
        int eq = 0;
        String start = "-D" + Config.getPrefix() + "jeasydb.";
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].startsWith(start)) {
                eq = argv[i].indexOf(61);
                if (eq <= 0) continue;
                Config.setProperty(argv[i].substring(2, eq), argv[i].substring(eq + 1));
                continue;
            }
            if (this.addOption(argv[i]) != null || fixed) continue;
            if (argv[i].startsWith("-")) {
                this.errorNum = 24;
                this.error = argv[i];
                continue;
            }
            noa.addElement(argv[i]);
        }
        if (!fixed) {
            this.notOptArgs = noa.toArray(this.notOptArgs);
        }
    }

    public String getOption(String key) {
        return this.optArgs.get(key.toLowerCase(Locale.US));
    }

    public int getOption(String key, int deflt) {
        int Return2;
        String res = this.optArgs.get(key.toLowerCase(Locale.US));
        try {
            Return2 = Integer.parseInt(res);
        }
        catch (Exception _ex) {
            Return2 = deflt;
        }
        return Return2;
    }

    public String[] getArgs() {
        return this.notOptArgs;
    }

    public String getAll() {
        StringBuffer Return2 = new StringBuffer();
        Enumeration<String> en = this.optArgs.keys();
        boolean first = true;
        String opt = "";
        while (en.hasMoreElements()) {
            opt = en.nextElement();
            if (first) {
                first = false;
            } else {
                Return2.append(" ");
            }
            Return2.append(opt + this.getOption(opt));
        }
        return Return2.toString();
    }

    public Enumeration<String> getAllKeys() {
        return this.optArgs.keys();
    }

    protected void setProperty(Token prop, Token value, int sourceFormat) {
        String propName = prop.getOriginalWord();
        if (prop.getToknum() == 10001) {
            propName = propName.substring(1, propName.length() - 1);
        }
        String propValue = null;
        if (value != null) {
            propValue = value.getOriginalWord();
            if (value.getToknum() == 10001) {
                propValue = propValue.substring(1, propValue.length() - 1);
            }
        }
        if (!this.savedProps.containsKey(propName = "iscobol.jeasydb." + propName.toLowerCase(Locale.US))) {
            this.savedProps.put(propName, Config.getProperty(propName, null));
        }
        if (propValue != null) {
            Config.setProperty(propName, propValue);
        } else {
            Config.unsetProperty(propName);
        }
    }

    protected void restoreProperties() {
        for (String propName : this.savedProps.keySet()) {
            String propValue = this.savedProps.get(propName);
            if (propValue != null) {
                Config.setProperty(propName, propValue);
                continue;
            }
            Config.unsetProperty(propName);
        }
        this.savedProps.clear();
    }

    public void help(boolean x) {
        this.help(x, allOpts);
        System.out.println();
        System.out.println("Only for Informix");
        System.out.println();
        this.help(x, allInf);
        System.out.println();
        System.out.println("Only for MySQL");
        System.out.println();
        this.help(x, allMys);
        System.out.println();
        System.out.println("Only for Oracle");
        System.out.println();
        this.help(x, allOra);
        System.out.println();
        System.out.println("Only for Posgresql");
        System.out.println();
        this.help(x, allPos);
        System.out.println();
        System.out.println("Only for SQL Server");
        System.out.println();
        this.help(x, allSer);
    }

    public void help(boolean x, Hashtable<String, String> allOptsN) {
        TreeSet<String> ordered = new TreeSet<String>();
        Enumeration<String> en = allOptsN.keys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            if (!x && key.startsWith("-x")) continue;
            String value = allOptsN.get(key);
            ordered.add((key + "            ").substring(0, 13) + value);
        }
        Iterator it = ordered.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }

    public static int getAllOptionCount() {
        return allOpts.size();
    }

    public static Enumeration<String> getAllOptionKeys(boolean sort) {
        return allOpts.keys();
    }

    public static String getOptionDesc(String key) {
        return allOpts.get(key).toString();
    }

    public static boolean hasValue(String key) {
        return key.endsWith("=") && allOpts.get(key) != null;
    }

    static {
        allOpts.put(HELP, "Display help");
        allOpts.put(CONLY, "Specifies the only iscobol.properties to be used");
        allOpts.put(C, "Specifies the iscobol.properties to be used");
        allOpts.put(CSQQ, "Add quotes at every sql name and add the -csqq compiler option");
        allOpts.put(D2, "DB2 version");
        allOpts.put(D4, "DB2/AS400 version");
        allOpts.put(DI, "Informix version");
        allOpts.put(DM, "MySQL DB (InnoDB Engine)");
        allOpts.put(DMLD, "MySQL DB (InnoDB Engine) version with LIMIT ");
        allOpts.put(DMLU, "MySQL DB(InnoDB Engine) version with LIMIT used only on UNIQUE" + newLineFill + "index");
        allOpts.put(DO, "ORACLE DB (generic DB default) ");
        allOpts.put(DP, "PostgreSql version ");
        allOpts.put(DPLD, "PostgreSql version with LIMIT ");
        allOpts.put(DPLU, "PostgreSql version with LIMIT used only on UNIQUE index");
        allOpts.put(DS, "SQLServer version ");
        allOpts.put(DSLD, "SQLServer version with LIMIT ");
        allOpts.put(DSLU, "SQLServer version with LIMIT used only on UNIQUE index");
        allOpts.put(DCD, "Use Data General binary numeric format");
        allOpts.put(DZ, "Relax size-checking rules");
        allOpts.put(CA, "Acu4GL Compatibility (supports A4GL-WHERE-CONSTRAINT and implies" + newLineFill + "-defCHAR)");
        allOpts.put(CC, "support for COMMIT_COUNT setting. ");
        allOpts.put(CE, "EXECUTE instead CURSOR EQUAL (only Oracle)");
        allOpts.put(CP, "allows to use the -cp compiler option ");
        allOpts.put(DEFCHAR, "default for PIC X(n) is CHAR (use $EFD VAR-LENGTH for VARCHAR) ");
        allOpts.put(ENTRYPOINTS, "generate the code for BEFORE-<op> AFTER-op paragraphs");
        allOpts.put(ESST, "enable start on specific table");
        allOpts.put(H, "use HIGH-VALUE as max numeric value in numeric key fields ");
        allOpts.put(I, "isam positioning on at end ");
        allOpts.put(JCD, "routine Julian date COBOL DB ");
        allOpts.put(JDC, "routine Julian date DB COBOL ");
        allOpts.put(LD, "Licence file and templates directory (NO MORE SUPPORTED)");
        allOpts.put(MAXCHARLEN, "uses CHAR database type for PIC X(n) where n <= len");
        allOpts.put(MO, "old Multirecord call managment");
        allOpts.put(N, "test not numeric in keys");
        allOpts.put(NN, "generate NOT NULL clause for every column");
        allOpts.put(NO, "name filled with zeroes on index part (OCCURS fields) ");
        allOpts.put(NOCHECK, "disable the check of the table existence on the OPEN ");
        allOpts.put(PREFIX, "routine name prefix (used only if invoked by compiler) ");
        allOpts.put(PDO, "use on duplicate keys the primary key's order (PREVIOUS)");
        allOpts.put(OC, "Output directory for copyfile (NO MORE SUPPORTED)");
        allOpts.put(OD, "Output directory for subroutines ");
        allOpts.put(OS, "Output directory for sql script files");
        allOpts.put(SL, "feature for START WITH LENGTH");
        allOpts.put(SQL, "generate sql CREATE TABLE script");
        allOpts.put(T, "allow trace for not numeric ");
        allOpts.put(UA, "UNLOCK ALL statements");
        allOpts.put(V, "version");
        allInf.put(ID, "use string format for the DATE conversions ");
        allMys.put(MH, "Generate hints that force the query optimizer to use the" + newLineFill + "proper index");
        allMys.put(DMOID, "name of the column used for LIMIT (OID default)");
        allPos.put(DPOID, "name of the column used for LIMIT (OID default)");
        allOra.put(OH, "Generate hints that force the query optimizer to use the" + newLineFill + "proper index unless the HINT Directive has been used to specify" + newLineFill + "custom hints. This option is incompatible with Oho.");
        allOra.put(OHO, "Generate hints that force the query optimizer to use the proper" + newLineFill + "index. Hints are also used to specify the data ordering, avoiding" + newLineFill + "the Order By clause and providing better performance. " + newLineFill + "The HINT Directive shouldn't be used along with this option" + newLineFill + "since it might cause wrong data ordering.  This option is " + newLineFill + "incompatible with the Oh option and with the configuration setting" + newLineFill + "iscobol.jdbc.cursor.type=3.");
        allOra.put(OII, "storage initial value for index ");
        allOra.put(OIT, "storage initial value for table");
        allOra.put(ONI, "storage next value for index ");
        allOra.put(ONT, "storage next value for table");
        allOra.put(OPI, "storage pctincrease value for index ");
        allOra.put(OPT, "storage pctincrease value for table ");
        allOra.put(OTI, "tablespace index name ");
        allOra.put(OTT, "tablespace name ");
        allOra.put(OW, "NOWAIT for update. This option allows the EDBI user's routine" + newLineFill + "to return record lock condition");
        allOra.put(OWFL, "support for WAIT_FOR_LOCKS setting. This option allows the" + newLineFill + "EDBI user's routine to return record lock condition depending on" + newLineFill + "iscobol.easydb.oracle.wait_for_locks setting ");
        allPos.put(PI, "allow to use indicators to manage LOW-VALUE values");
        allSer.put(SC, "collating latin1_general_bin");
        allSer.put(SCO, "collating latin1_general_bin only on ORDER BY");
        allSer.put(SDT, "use always DATETIME for EFD DATE");
        allSer.put(DSOID, "name of the column used for LIMIT (OID default)");
    }
}

