/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class JumpCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 29;
    public static final String SHORT_DESCRIPTION = " : jump to the selected line or paragraph";
    public static final String STRING_ID = "jump";
    public static final String HELP_PAGE = "jump.html";
    public static final String USAGE = "usage:" + eol + "   jump line-number|paragraph-name" + eol + "   jump " + "-outpar" + eol + "   jump " + "-outprog" + eol + "   jump " + "-next" + eol;
    public static final byte TYPE_OUTPAR = 1;
    public static final byte TYPE_OUTPROG = 2;
    public static final byte TYPE_NEXT = 3;
    private int lineNo;
    private int fileIndex;
    private String fileName;
    private String paragraphName;
    private byte type;

    public JumpCommand() {
    }

    public JumpCommand(int line, String fileName, int fileIndex) {
        this.lineNo = line;
        this.fileName = fileName;
        this.fileIndex = fileIndex;
    }

    public static JumpCommand getJumpOutParagraphInstance() {
        JumpCommand Return2 = new JumpCommand();
        Return2.type = 1;
        return Return2;
    }

    public static JumpCommand getJumpOutProgramInstance() {
        JumpCommand Return2 = new JumpCommand();
        Return2.type = (byte)2;
        return Return2;
    }

    public static JumpCommand getJumpNextInstance() {
        JumpCommand Return2 = new JumpCommand();
        Return2.type = (byte)3;
        return Return2;
    }

    public JumpCommand(String paragraph) {
        this.paragraphName = paragraph;
    }

    public boolean isJumpOutParagraph() {
        return this.type == 1;
    }

    public boolean isJumpOutProgram() {
        return this.type == 2;
    }

    public boolean isJumpNext() {
        return this.type == 3;
    }

    public byte getType() {
        return this.type;
    }

    public String getFilename() {
        return this.fileName;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public String getParagraphName() {
        return this.paragraphName;
    }

    @Override
    public int getId() {
        return 29;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeByte(this.type);
        if (this.type == 0) {
            out.writeInt(this.lineNo);
            out.writeInt(this.fileIndex);
            RtsUtil.writeUTFOptmz(this.paragraphName, out);
            RtsUtil.writeUTFOptmz(this.fileName, out);
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.type = in.readByte();
        if (this.type == 0) {
            this.lineNo = in.readInt();
            this.fileIndex = in.readInt();
            this.paragraphName = RtsUtil.readUTFOptmz(in);
            this.fileName = RtsUtil.readUTFOptmz(in);
        }
    }
}

