/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.VarName;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.interfaces.debugger.IVariableCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ClearMonitorCommand
implements DebugCommand,
IVariableCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 14;
    public static final String SHORT_DESCRIPTION = " : clear the monitor on a specified variable";
    public static final String STRING_ID = "unmonitor";
    public static final String HELP_PAGE = "unmonitor.html";
    public static final String USAGE = " usage:" + eol + "   unmonitor [-c class-name[:>method-name]] variable-name" + eol + "or unmonitor [-c class-name[:>method-name]] control-name|control-handle|window-handle " + "prop" + "|" + "property" + " property-name" + eol + "or unmonitor " + "-env" + " env-name" + eol + "or unmonitor " + "-a" + " (to clear all monitors)" + eol;
    private VarName varname;
    private String propertyName;
    private String className;
    private String envName;
    private boolean clearAll;

    public ClearMonitorCommand() {
    }

    public ClearMonitorCommand(VarName vn, String cls, String prop) {
        this.varname = vn;
        this.className = cls;
        this.propertyName = prop;
    }

    public ClearMonitorCommand(String envProp) {
        this.envName = envProp;
    }

    public ClearMonitorCommand(boolean clearAll) {
        this.clearAll = clearAll;
    }

    @Override
    public VarName getVarName() {
        return this.varname;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public String getEnvName() {
        return this.envName;
    }

    public boolean isClearAll() {
        return this.clearAll;
    }

    @Override
    public int getId() {
        return 14;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.clearAll);
        if (!this.clearAll) {
            out.writeBoolean(this.varname != null);
            if (this.varname != null) {
                this.varname.writeExternal(out);
            }
            RtsUtil.writeUTFOptmz(this.className, out);
            RtsUtil.writeUTFOptmz(this.propertyName, out);
            RtsUtil.writeUTFOptmz(this.envName, out);
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.clearAll = in.readBoolean();
        if (!this.clearAll) {
            if (in.readBoolean()) {
                this.varname = new VarName();
                this.varname.readExternal(in);
            } else {
                this.varname = null;
            }
            this.className = RtsUtil.readUTFOptmz(in);
            this.propertyName = RtsUtil.readUTFOptmz(in);
            this.envName = RtsUtil.readUTFOptmz(in);
        }
    }
}

