/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.compiler.CopyBookDesc;
import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.interfaces.compiler.PreProcessorReaderProvider;
import com.iscobol.interfaces.debugger.IFileLoader;
import com.iscobol.interfaces.debugger.IListingInfoExtension;
import com.iscobol.interfaces.debugger.InputStreamProvider;
import com.iscobol.rts.Config;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class ListingInfo
implements IListingInfoExtension {
    private static byte[] unscramble = new byte[]{9, 36, 92, 106, 73, -76, -20, -53, 37, -92, -39, 66, -62, 47, 23, -64, 20, -73, 55, 26, -85, 120, -94, -33, 114, -19, 93, 24, -9, -27, -67, -120, 116, -55, -112, 53, 107, 28, 82, 97, 17, 89, 81, -26, 4, -25, 6, 15, -44, 127, 25, 3, 105, -29, 95, 52, 31, -125, -93, 48, 57, 103, 2, 90, 16, -116, 41, -87, -127, 65, 111, 87, 74, 122, -32, 0, -110, -54, -31, -49, 83, 5, 46, -100, 27, -10, 63, 50, -41, 112, 44, 21, -38, 59, 42, 61, 64, -42, -47, -1, -36, 72, 125, -4, -21, 40, 14, -37, -114, -59, -95, 84, 86, 119, 8, -78, -51, 126, 113, -43, -7, 109, -80, 100, -126, 79, -99, -11, -70, -8, 70, 78, 108, 7, -22, -63, -104, 30, -61, 11, 69, 110, -124, 77, -79, -123, -108, 102, 43, 104, -40, -3, -68, 80, -82, -57, -90, 29, 115, 45, 101, -46, -60, -2, 49, -128, -75, 62, 1, -72, 18, 39, -66, 98, -71, 13, 54, 118, -105, -15, 67, -77, 85, -91, -84, -48, -45, -111, -17, 58, -106, -97, -50, -30, -115, -16, 33, 51, 38, 76, 10, -88, -119, 99, -23, 117, 123, -117, -101, -107, -102, -89, -69, 19, 96, 121, -122, -18, -28, -74, -96, 88, -118, -6, -52, 34, 60, -12, 68, -35, 75, -98, 71, 32, -81, -113, -34, -56, 22, 56, 12, -86, 91, -121, -14, -65, -58, -83, 94, -5, -13, 35, 124, -24, -103, -109};
    private final IFileLoader fileLoader;
    private final PreProcessorReaderProvider readerProvider;
    private final InputStreamProvider inputStreamProvider;
    private String charset;
    private final HashMap<File, List<byte[]>> fileMap = new HashMap();

    public ListingInfo(byte[] listing, int format) throws IOException {
        this(listing, null, format);
    }

    public ListingInfo(byte[] listing, DebugCopyFile[] copyFiles, int format) throws IOException {
        IFileLoader fl = null;
        PreProcessorReaderProvider rp = null;
        InputStreamProvider isp = null;
        DataInputStream dIn = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(listing)));
        while (true) {
            try {
                Hashtable<CopyBookDesc, CopyBookDesc> includeCopyBooks;
                this.charset = dIn.readUTF();
                if (format < 4) {
                    int fileCount = dIn.readInt();
                    for (int fIdx = 0; fIdx < fileCount; ++fIdx) {
                        this.readFile(dIn, dIn.readUTF());
                    }
                    int propCount = dIn.readInt();
                    for (int j = 0; j < propCount; ++j) {
                        String prop = dIn.readUTF();
                        int idx = prop.indexOf(61);
                        if (idx < 0) continue;
                        Config.setProperty(prop.substring(0, idx), prop.substring(idx + 1));
                    }
                } else {
                    String fileName = dIn.readUTF();
                    while (fileName.length() > 0) {
                        this.readFile(dIn, fileName);
                        fileName = dIn.readUTF();
                    }
                }
                if (copyFiles != null) {
                    includeCopyBooks = new Hashtable<CopyBookDesc, CopyBookDesc>();
                    for (int i = 0; i < copyFiles.length; ++i) {
                        String copyfile = copyFiles[i].getCopyFileName();
                        File f = new File(copyfile);
                        CopyBookDesc ref = new CopyBookDesc(f.getName(), new File(copyFiles[i].getParentFileName()).getName(), copyFiles[i].getCopyStatementLineNumber(), i + 1);
                        includeCopyBooks.put(ref, ref);
                    }
                } else {
                    includeCopyBooks = null;
                }
                fl = new IFileLoader(){

                    private Integer[] getIndexes(File f, File[] fs) {
                        ArrayList<Integer> result = new ArrayList<Integer>();
                        for (int i = 0; i < fs.length; ++i) {
                            if (!f.getName().equalsIgnoreCase(fs[i].getName())) continue;
                            result.add(i);
                        }
                        return result.toArray(new Integer[result.size()]);
                    }

                    @Override
                    public String getAbsolutePath(String filename) {
                        File[] fsOrig;
                        File[] fs = fsOrig = ListingInfo.this.fileMap.keySet().toArray(new File[ListingInfo.this.fileMap.size()]);
                        File f = new File(filename);
                        Integer[] idxs;
                        while ((idxs = this.getIndexes(f, fs)).length != 0) {
                            if (idxs.length == 1) {
                                return fsOrig[idxs[0]].getPath();
                            }
                            if ((f = f.getParentFile()) == null) {
                                f = new File(".");
                            }
                            File[] tmp = new File[idxs.length];
                            File[] tmpOrig = new File[idxs.length];
                            for (int i = 0; i < idxs.length; ++i) {
                                tmp[i] = fs[idxs[i]].getParentFile();
                                if (tmp[i] == null) {
                                    tmp[i] = new File(".");
                                }
                                tmpOrig[i] = fsOrig[idxs[i]];
                            }
                            fs = tmp;
                            fsOrig = tmpOrig;
                        }
                        return null;
                    }
                };
                final InputStreamProvider fisp = isp = new InputStreamProvider(){

                    @Override
                    public InputStream getInputStream(String fileName) {
                        File f = new File(fileName);
                        List l = (List)ListingInfo.this.fileMap.get(f);
                        if (l != null) {
                            byte[] b = l.size() > 1 ? (byte[])l.remove(0) : (byte[])l.get(0);
                            return new ByteArrayInputStream(b);
                        }
                        return null;
                    }
                };
                rp = new PreProcessorReaderProvider(){

                    @Override
                    public Reader getReader(String fileName) {
                        InputStream is = fisp.getInputStream(fileName);
                        if (is != null) {
                            try {
                                return new InputStreamReader(is, ListingInfo.this.charset);
                            }
                            catch (UnsupportedEncodingException e) {
                                return new InputStreamReader(is);
                            }
                        }
                        return null;
                    }

                    @Override
                    public Hashtable getIncludeCopyBooks() {
                        return includeCopyBooks;
                    }
                };
            }
            catch (ZipException ex) {
                dIn.close();
                dIn = new DataInputStream(new ByteArrayInputStream(listing));
                continue;
            }
            break;
        }
        this.fileLoader = fl;
        this.readerProvider = rp;
        this.inputStreamProvider = isp;
    }

    private void readFile(DataInputStream dIn, String fileName) throws IOException {
        File f = new File(fileName);
        int count = dIn.readInt();
        byte[] b = new byte[count];
        dIn.readFully(b);
        for (int i = 0; i < b.length; ++i) {
            b[i] = unscramble[b[i] & 0xFF];
        }
        List<byte[]> l = this.fileMap.get(f);
        if (l == null) {
            l = new ArrayList<byte[]>();
            this.fileMap.put(f, l);
        }
        l.add(b);
    }

    @Override
    public IFileLoader getFileLoader() {
        return this.fileLoader;
    }

    public PreProcessorReaderProvider getReaderProvider() {
        return this.readerProvider;
    }

    @Override
    public InputStreamProvider getInputStreamProvider() {
        return this.inputStreamProvider;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }
}

