/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.Debugger;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.EnvVarName;
import com.iscobol.debugger.VarName;
import com.iscobol.interfaces.debugger.IExpression;
import com.iscobol.interfaces.debugger.IExpressionOp;
import com.iscobol.rts.Config;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class Expression
implements IExpression,
DataExternalizable {
    private static final long serialVersionUID = 1000006L;
    public static final int ADD = 0;
    public static final int SUBTRACT = 1;
    public static final int DIVIDE = 2;
    public static final int MULTIPLY = 3;
    public static final int GREATER = 4;
    public static final int GREATER_OR_EQUAL = 5;
    public static final int LESS = 6;
    public static final int LESS_OR_EQUAL = 7;
    public static final int EQUAL = 8;
    public static final int NOT_EQUAL = 9;
    public static final int NOT = 10;
    public static final int AND = 11;
    public static final int OR = 12;
    private static final int OPEN_PAR = 13;
    private static final int ELEM_OP = 1;
    private static final int ELEM_STRING = 2;
    private static final int ELEM_BD_STRING = 3;
    private static final int ELEM_ENV_VN = 4;
    private static final int ELEM_VN = 5;
    private static final int ELEM_EXPR = 6;
    private transient int openPar;
    private transient DebugTM tm;
    private Vector elements;
    private boolean conditional;
    private boolean envProperty;
    private boolean hexadecimal;

    public Expression() {
    }

    public Expression(DebugTM tm) throws DebuggerException {
        this(tm, false, false, false);
    }

    public Expression(DebugTM tm, boolean conditional, boolean envProperty, boolean hex) throws DebuggerException {
        Stack<Object> itemStack = new Stack<Object>();
        Stack<Op> opStack = new Stack<Op>();
        this.tm = tm;
        this.conditional = conditional;
        this.envProperty = envProperty;
        this.hexadecimal = hex;
        boolean allowExpr = true;
        String tk = tm.getToken();
        block7: while (tk != null) {
            Op op;
            Op operation = null;
            try {
                operation = new Op(tk, this);
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
            if (operation != null) {
                switch (operation.type) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: {
                        while (!opStack.isEmpty()) {
                            op = (Op)opStack.peek();
                            if (op.priority < operation.priority) break;
                            itemStack.push(this.op(opStack, itemStack));
                        }
                        opStack.push(operation);
                        allowExpr = true;
                        break;
                    }
                    case 13: {
                        if (allowExpr) {
                            ++this.openPar;
                            opStack.push(operation);
                            break;
                        }
                        tm.ungetToken();
                        break block7;
                    }
                    case 10: {
                        opStack.push(operation);
                        allowExpr = true;
                    }
                }
            } else if (tk.equals(")")) {
                if (this.openPar > 0) {
                    --this.openPar;
                } else {
                    tm.ungetToken();
                    break;
                }
                while (!opStack.isEmpty()) {
                    op = (Op)opStack.peek();
                    if (op.type == 13) {
                        opStack.pop();
                        break;
                    }
                    itemStack.push(this.op(opStack, itemStack));
                }
                allowExpr = false;
            } else if (tk.equals("\"")) {
                String str = tk;
                String tk0 = tm.getAllToken();
                while (tk0 != null && !tk0.equals("\"")) {
                    str = str + tk0;
                    tk0 = tm.getAllToken();
                }
                if ("\"".equals(tk0)) {
                    str = str + tk0;
                }
                itemStack.push(str);
            } else if (allowExpr) {
                Object obj = this.value(tk);
                if (obj != null) {
                    itemStack.push(obj);
                } else if (DebugUtilities.isValidCobolIdentifierName(tk)) {
                    tm.ungetToken();
                    if (envProperty) {
                        itemStack.push(new EnvVarName(tm));
                    } else {
                        itemStack.push(new VarName(tm));
                    }
                } else {
                    tm.ungetToken();
                    break;
                }
                allowExpr = false;
            } else {
                tm.ungetToken();
                break;
            }
            tk = tm.getToken();
        }
        while (!opStack.isEmpty()) {
            itemStack.push(this.op(opStack, itemStack));
        }
        if (itemStack.size() == 1) {
            Object num = itemStack.pop();
            if (num instanceof Expression) {
                this.elements = ((Expression)num).elements;
            } else {
                this.elements = new Vector();
                this.elements.addElement(num);
            }
        } else {
            throw new DebuggerException(5);
        }
    }

    public Expression(Vector elements, boolean conditional, boolean envProperty, boolean hex) {
        this.elements = elements;
        this.conditional = conditional;
        this.envProperty = envProperty;
        this.hexadecimal = hex;
    }

    @Override
    public boolean isEnvProperty() {
        return this.envProperty;
    }

    @Override
    public boolean isCondition() {
        return this.conditional;
    }

    @Override
    public boolean isHex() {
        return this.hexadecimal;
    }

    private Object op(Stack opStack, Stack itemStack) throws DebuggerException {
        Op operation = (Op)opStack.pop();
        if (operation.isUnaryOp()) {
            if (itemStack.isEmpty()) {
                throw new DebuggerException(5);
            }
            Object operator1 = itemStack.pop();
            Expression exp = new Expression();
            exp.elements = new Vector();
            exp.elements.addElement(operation);
            exp.elements.addElement(operator1);
            return exp;
        }
        if (itemStack.size() < 2) {
            throw new DebuggerException(5);
        }
        Object operator2 = itemStack.pop();
        Object operator1 = itemStack.pop();
        Expression exp = new Expression();
        exp.elements = new Vector();
        exp.elements.addElement(operator1);
        exp.elements.addElement(operation);
        exp.elements.addElement(operator2);
        return exp;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        Enumeration en = this.getElements();
        while (en.hasMoreElements()) {
            buff.append(en.nextElement());
            if (!en.hasMoreElements()) continue;
            buff.append(" ");
        }
        return buff.toString();
    }

    public Boolean evaluateBoolean(Object expr, Debugger dbg) throws DebuggerException {
        if (expr instanceof Expression) {
            Object val = ((Expression)expr).evaluate(dbg, false, false);
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
        } else if (expr instanceof Boolean) {
            return (Boolean)expr;
        }
        return null;
    }

    public Comparable evaluateComparable(Object expr, boolean numeric, boolean hex, Debugger dbg) throws DebuggerException {
        if (expr instanceof Expression) {
            Object val = ((Expression)expr).evaluate(dbg, numeric, hex);
            if (val instanceof Comparable) {
                return (Comparable)val;
            }
        } else if (expr instanceof VarName) {
            Debugger.IscobolField field = dbg.findVar((VarName)expr, false);
            if (field != null) {
                if (field.getVar() instanceof Comparable) {
                    return (Comparable)field.getVar();
                }
                if (field.getVar() instanceof ICobolVar) {
                    ICobolVar cvar = (ICobolVar)field.getVar();
                    if (hex) {
                        return DebugUtilities.bytesToHex(cvar.getBytes(), cvar.length());
                    }
                    if (cvar instanceof INumericVar) {
                        return ((INumericVar)cvar).num().bigDecimalValue();
                    }
                    return cvar.toString();
                }
            }
        } else {
            if (expr instanceof EnvVarName) {
                return Config.getProperty(Config.getPrefix() + ((EnvVarName)expr).getName().trim().toLowerCase().replace('-', '_'), null);
            }
            if (expr instanceof String) {
                String s = (String)expr;
                if (s.startsWith("\"") && s.endsWith("\"")) {
                    s = s.substring(1, s.length() - 1);
                }
                return s;
            }
            if (expr instanceof Comparable) {
                return (Comparable)expr;
            }
        }
        return null;
    }

    public BigDecimal evaluateBigDecimal(Object expr, Debugger dbg) throws DebuggerException {
        if (expr instanceof Expression) {
            Object val = ((Expression)expr).evaluate(dbg, true, false);
            if (val instanceof BigDecimal) {
                return (BigDecimal)val;
            }
        } else if (expr instanceof VarName) {
            Debugger.IscobolField field = dbg.findVar((VarName)expr, false);
            if (field != null && field.getVar() instanceof INumericVar) {
                return ((INumericVar)field.getVar()).num().bigDecimalValue();
            }
        } else if (expr instanceof EnvVarName) {
            String prop = Config.getProperty(Config.getPrefix() + ((EnvVarName)expr).getName().trim().toLowerCase().replace('-', '_'), null);
            try {
                return new BigDecimal(prop.replace(',', '.'));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (expr instanceof BigDecimal) {
            return (BigDecimal)expr;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object evaluate(Debugger dbg, boolean numeric, boolean hex) throws DebuggerException {
        void var4_13;
        void var4_5;
        Object var4_4 = null;
        Enumeration e = this.getElements();
        Op op = null;
        Object elem = null;
        while (e.hasMoreElements()) {
            elem = e.nextElement();
            if (elem instanceof Op) {
                op = elem;
                continue;
            }
            if (op != null) {
                if (op.type == 10) {
                    Boolean b = this.evaluateBoolean(elem, dbg);
                    if (b == null) throw new DebuggerException(35);
                    Boolean bl = b == false;
                    continue;
                }
                if (op.isLogicalOp()) {
                    Boolean b1 = this.evaluateBoolean(var4_5, dbg);
                    Boolean b2 = this.evaluateBoolean(elem, dbg);
                    if (b1 == null || b2 == null) throw new DebuggerException(35);
                    Boolean bl = this.compute(op, b1, b2);
                    continue;
                }
                if (op.isRelationalOp()) {
                    Comparable c1 = this.evaluateComparable(var4_5, numeric, hex, dbg);
                    Comparable c2 = this.evaluateComparable(elem, numeric, hex, dbg);
                    if (c1 == null || c2 == null || c1.getClass() != c2.getClass()) throw new DebuggerException(35);
                    Boolean bl = this.computeRelation(op, c1, c2);
                    continue;
                }
                BigDecimal bd1 = this.evaluateBigDecimal(var4_5, dbg);
                BigDecimal bd2 = this.evaluateBigDecimal(elem, dbg);
                if (bd1 == null || bd2 == null) throw new DebuggerException(35);
                BigDecimal bigDecimal = this.compute(op, bd1, bd2);
                continue;
            }
            Object var4_10 = elem;
        }
        if (numeric) {
            BigDecimal bd = this.evaluateBigDecimal(var4_5, dbg);
            if (bd == null) throw new DebuggerException(35);
            BigDecimal bigDecimal = bd;
            return var4_13;
        } else {
            Comparable c = this.evaluateComparable(var4_5, numeric, hex, dbg);
            if (c == null) throw new DebuggerException(35);
            Comparable comparable = c;
        }
        return var4_13;
    }

    private Object value(String tk) {
        if (this.hexadecimal) {
            if (DebugUtilities.hexToBytes(tk) != null) {
                return tk.toUpperCase();
            }
            return null;
        }
        try {
            return new BigDecimal(tk.replace(',', '.'));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private BigDecimal compute(Op operation, BigDecimal operator1, BigDecimal operator2) {
        BigDecimal Return2;
        if (operator1 == null) {
            operator1 = new BigDecimal("0");
        }
        switch (operation.type) {
            case 0: {
                Return2 = operator1.add(operator2);
                break;
            }
            case 1: {
                Return2 = operator1.subtract(operator2);
                break;
            }
            case 3: {
                Return2 = operator1.multiply(operator2);
                break;
            }
            case 2: {
                Return2 = operator1.divide(operator2, 1);
                break;
            }
            default: {
                Return2 = null;
            }
        }
        return Return2;
    }

    private Boolean compute(Op operation, Boolean operator1, Boolean operator2) {
        Boolean Return2;
        if (operator1 == null) {
            operator1 = false;
        }
        switch (operation.type) {
            case 11: {
                Return2 = operator1 != false && operator2 != false;
                break;
            }
            case 12: {
                Return2 = operator1 != false || operator2 != false;
                break;
            }
            case 10: {
                Return2 = operator1 == false;
                break;
            }
            default: {
                Return2 = null;
            }
        }
        return Return2;
    }

    private Boolean computeRelation(Op operation, Comparable operator1, Comparable operator2) {
        Boolean Return2;
        if (operator1 == null) {
            operator1 = new BigDecimal("0");
        }
        if (operator1 instanceof String && operator2 instanceof String) {
            operator1 = ((String)operator1).replaceAll("\\s+$", "");
            operator2 = ((String)operator2).replaceAll("\\s+$", "");
        }
        switch (operation.type) {
            case 4: {
                Return2 = operator1.compareTo(operator2) > 0;
                break;
            }
            case 5: {
                Return2 = operator1.compareTo(operator2) >= 0;
                break;
            }
            case 6: {
                Return2 = operator1.compareTo(operator2) < 0;
                break;
            }
            case 7: {
                Return2 = operator1.compareTo(operator2) <= 0;
                break;
            }
            case 8: {
                Return2 = operator1.compareTo(operator2) == 0;
                break;
            }
            case 9: {
                Return2 = operator1.compareTo(operator2) != 0;
                break;
            }
            default: {
                Return2 = null;
            }
        }
        return Return2;
    }

    @Override
    public Enumeration getElements() {
        return this.elements != null ? this.elements.elements() : DebugUtilities.EMPTY_ENUMERATION;
    }

    @Override
    public int getElementCount() {
        return this.elements != null ? this.elements.size() : 0;
    }

    @Override
    public boolean containsVariables() {
        Enumeration en = this.getElements();
        while (en.hasMoreElements()) {
            Object obj = en.nextElement();
            if (!(obj instanceof VarName) && !(obj instanceof EnvVarName) && (!(obj instanceof Expression) || !((Expression)obj).containsVariables())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.conditional);
        out.writeBoolean(this.envProperty);
        out.writeBoolean(this.hexadecimal);
        if (this.elements != null) {
            int n = this.elements.size();
            out.writeInt(n);
            for (int i = 0; i < n; ++i) {
                Object o = this.elements.elementAt(i);
                if (o instanceof Op) {
                    out.writeInt(1);
                    ((Op)o).writeExternal(out);
                    continue;
                }
                if (o instanceof BigDecimal) {
                    out.writeInt(3);
                    RtsUtil.writeUTFOptmz(o.toString(), out);
                    continue;
                }
                if (o instanceof String) {
                    out.writeInt(2);
                    RtsUtil.writeUTFOptmz((String)o, out);
                    continue;
                }
                if (o instanceof EnvVarName) {
                    out.writeInt(4);
                    ((EnvVarName)o).writeExternal(out);
                    continue;
                }
                if (o instanceof VarName) {
                    out.writeInt(5);
                    ((VarName)o).writeExternal(out);
                    continue;
                }
                if (o instanceof Expression) {
                    out.writeInt(6);
                    ((Expression)o).writeExternal(out);
                    continue;
                }
                throw new IOException("Expression.writeExternal: Unknown element type");
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.conditional = in.readBoolean();
        this.envProperty = in.readBoolean();
        this.hexadecimal = in.readBoolean();
        int n = in.readInt();
        if (n > 0) {
            this.elements = new Vector();
            block8: for (int i = 0; i < n; ++i) {
                switch (in.readInt()) {
                    case 1: {
                        Op op = new Op();
                        op.readExternal(in);
                        this.elements.addElement(op);
                        continue block8;
                    }
                    case 3: {
                        this.elements.addElement(new BigDecimal(RtsUtil.readUTFOptmz(in)));
                        continue block8;
                    }
                    case 2: {
                        this.elements.addElement(RtsUtil.readUTFOptmz(in));
                        continue block8;
                    }
                    case 4: {
                        EnvVarName evn = new EnvVarName();
                        evn.readExternal(in);
                        this.elements.addElement(evn);
                        continue block8;
                    }
                    case 5: {
                        VarName vn = new VarName();
                        vn.readExternal(in);
                        this.elements.addElement(vn);
                        continue block8;
                    }
                    case 6: {
                        Expression expr = new Expression();
                        expr.readExternal(in);
                        this.elements.addElement(expr);
                        continue block8;
                    }
                    default: {
                        throw new IOException("Expression.readExternal: Unknown element type");
                    }
                }
            }
        } else {
            this.elements = null;
        }
    }

    public static class Op
    implements IExpressionOp,
    DataExternalizable {
        int type;
        transient int priority;
        private static final long serialVersionUID = 1000006L;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Op(String tk, Expression expr) throws DebuggerException {
            if (tk.equals("+")) {
                this.type = 0;
                this.setPriority();
                return;
            } else if (tk.equals("-")) {
                this.type = 1;
                this.setPriority();
                return;
            } else if (tk.equals("/")) {
                this.type = 2;
                this.setPriority();
                return;
            } else if (tk.equals("*")) {
                this.type = 3;
                this.setPriority();
                return;
            } else if (tk.equals("(")) {
                this.type = 13;
                return;
            } else {
                if (!expr.conditional) throw new DebuggerException(5);
                if (tk.equals(">")) {
                    tk = expr.tm.getAllToken();
                    if (tk.equals("=")) {
                        this.type = 5;
                    } else {
                        expr.tm.ungetAllToken();
                        this.type = 4;
                    }
                    this.setPriority();
                    return;
                } else if (tk.equals("<")) {
                    tk = expr.tm.getAllToken();
                    if (tk.equals("=")) {
                        this.type = 7;
                    } else {
                        expr.tm.ungetAllToken();
                        this.type = 6;
                    }
                    this.setPriority();
                    return;
                } else if (tk.equals("=")) {
                    this.type = 8;
                    this.priority = 3;
                    return;
                } else if (tk.equals("||")) {
                    this.type = 12;
                    this.setPriority();
                    return;
                } else if (tk.equals("&&")) {
                    this.type = 11;
                    this.setPriority();
                    return;
                } else {
                    if (!tk.equals("!")) throw new DebuggerException(5);
                    tk = expr.tm.getAllToken();
                    if (tk.equals("=")) {
                        this.type = 9;
                        this.setPriority();
                        return;
                    } else {
                        expr.tm.ungetAllToken();
                        this.type = 10;
                        this.setPriority();
                    }
                }
            }
        }

        public Op() {
        }

        public Op(int type) {
            this.type = type;
            this.setPriority();
        }

        private void setPriority() {
            switch (this.type) {
                case 0: 
                case 1: {
                    this.priority = 5;
                    break;
                }
                case 2: 
                case 3: {
                    this.priority = 6;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.priority = 4;
                    break;
                }
                case 8: 
                case 9: {
                    this.priority = 3;
                    break;
                }
                case 12: {
                    this.priority = 1;
                    break;
                }
                case 11: {
                    this.priority = 2;
                    break;
                }
                case 10: {
                    this.priority = 7;
                    break;
                }
                default: {
                    this.priority = 0;
                }
            }
        }

        @Override
        public boolean isUnaryOp() {
            switch (this.type) {
                case 10: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isLogicalOp() {
            switch (this.type) {
                case 10: 
                case 11: 
                case 12: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isRelationalOp() {
            switch (this.type) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isMathematicalOp() {
            switch (this.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        public boolean isSameCategory(Op op) {
            return this.isLogicalOp() && op.isLogicalOp() || this.isRelationalOp() && op.isRelationalOp() || this.isMathematicalOp() && op.isMathematicalOp();
        }

        @Override
        public int getType() {
            return this.type;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return "+";
                }
                case 1: {
                    return "-";
                }
                case 3: {
                    return "*";
                }
                case 2: {
                    return "/";
                }
                case 5: {
                    return ">=";
                }
                case 4: {
                    return ">";
                }
                case 7: {
                    return "<";
                }
                case 6: {
                    return "<";
                }
                case 8: {
                    return "=";
                }
                case 9: {
                    return "!=";
                }
                case 10: {
                    return "!";
                }
                case 11: {
                    return "&&";
                }
                case 12: {
                    return "||";
                }
                case 13: {
                    return "(";
                }
            }
            return "?";
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            out.writeInt(this.type);
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.type = in.readInt();
            this.setPriority();
        }
    }
}

