/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Condition;
import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.debugger.DebugOutputStream;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.Debugger;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.Expression;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.IscobolDebugger;
import com.iscobol.debugger.Listing;
import com.iscobol.debugger.ListingException;
import com.iscobol.debugger.ListingInfo;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.commands.ClearBreakpointCommand;
import com.iscobol.debugger.commands.ClearMonitorCommand;
import com.iscobol.debugger.commands.CompositeCommand;
import com.iscobol.debugger.commands.ContinueCommand;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.DirectoryCommand;
import com.iscobol.debugger.commands.DisplayCommand;
import com.iscobol.debugger.commands.EnvCommand;
import com.iscobol.debugger.commands.ExitCommand;
import com.iscobol.debugger.commands.GCCommand;
import com.iscobol.debugger.commands.GetFileCommand;
import com.iscobol.debugger.commands.GetInfoCommand;
import com.iscobol.debugger.commands.GetVariablesCommand;
import com.iscobol.debugger.commands.JumpCommand;
import com.iscobol.debugger.commands.LengthCommand;
import com.iscobol.debugger.commands.LetCommand;
import com.iscobol.debugger.commands.LoadCommand;
import com.iscobol.debugger.commands.MemoryCommand;
import com.iscobol.debugger.commands.MethodBreakpointCommand;
import com.iscobol.debugger.commands.OffsetCommand;
import com.iscobol.debugger.commands.ProgramBreakpointCommand;
import com.iscobol.debugger.commands.QuitCommand;
import com.iscobol.debugger.commands.RawTextCommand;
import com.iscobol.debugger.commands.RunCommand;
import com.iscobol.debugger.commands.SaveCommand;
import com.iscobol.debugger.commands.SetBreakpointCommand;
import com.iscobol.debugger.commands.SetMonitorCommand;
import com.iscobol.debugger.commands.SetRedirectStreamsCommand;
import com.iscobol.debugger.commands.StepIntoCommand;
import com.iscobol.debugger.commands.StepOutParagraphCommand;
import com.iscobol.debugger.commands.StepOutProgramCommand;
import com.iscobol.debugger.commands.StepOverCommand;
import com.iscobol.debugger.commands.StepToCommand;
import com.iscobol.debugger.commands.StepToNextProgramCommand;
import com.iscobol.debugger.commands.SuspendCommand;
import com.iscobol.debugger.commands.ThreadCommand;
import com.iscobol.debugger.commands.TraceOffCommand;
import com.iscobol.debugger.commands.TraceOnCommand;
import com.iscobol.interfaces.debugger.Appender;
import com.iscobol.interfaces.debugger.ICondition;
import com.iscobol.interfaces.debugger.IDebugCommand;
import com.iscobol.interfaces.debugger.IDebugCopyFile;
import com.iscobol.interfaces.debugger.IDebugTM;
import com.iscobol.interfaces.debugger.IDebuggerExtension7;
import com.iscobol.interfaces.debugger.IDebuggerInvoker;
import com.iscobol.interfaces.debugger.IExpression;
import com.iscobol.interfaces.debugger.IFileLoader;
import com.iscobol.interfaces.debugger.IFilename;
import com.iscobol.interfaces.debugger.IListing;
import com.iscobol.interfaces.debugger.IListingInfo;
import com.iscobol.interfaces.debugger.IVarName;
import com.iscobol.interfaces.debugger.IVarValue;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class DebuggerImpl
implements IDebuggerExtension7 {
    @Override
    public IDebuggerInvoker newDebuggerInvoker() {
        return new DebuggerInvoker();
    }

    @Override
    public IDebugTM newDebugTM(String cmd, int type) {
        DebugCommand[] dcmd;
        switch (type) {
            case 1: {
                dcmd = DebuggerInvoker.standardCommands;
                break;
            }
            default: {
                dcmd = new DebugCommand[]{};
            }
        }
        return new DebugTM(cmd, " ,;(:=)+*\"<>", dcmd);
    }

    @Override
    public IDebugCommand newGetInfoCommand(int c, String clazz) {
        return new GetInfoCommand(c, clazz);
    }

    @Override
    public IListing newListing(IFileLoader fileLoader, IDebugCopyFile[] copyFiles, IFilename file, int format, String formatOpt, boolean reload) throws ListingException {
        HashSet<String> opts = new HashSet<String>();
        if (format != 0 && formatOpt == null) {
            switch (format) {
                case 2: {
                    formatOpt = "-st";
                    break;
                }
                case 1: {
                    formatOpt = "-sa";
                    break;
                }
                case 3: {
                    formatOpt = "-sf";
                    break;
                }
                case 4: {
                    formatOpt = "-sv";
                    break;
                }
                case 5: {
                    formatOpt = "-sl";
                }
            }
            if (formatOpt != null) {
                opts.add(formatOpt);
            }
        }
        return this.newListing(fileLoader, copyFiles, file, null, opts, reload);
    }

    @Override
    public IListing newListing(IFileLoader fileLoader, IDebugCopyFile[] copyFiles, IFilename file, Set<String> opts, boolean reload) throws ListingException {
        return this.newListing(fileLoader, copyFiles, file, null, opts, reload);
    }

    @Override
    public IListing newListing(IFileLoader fileLoader, IDebugCopyFile[] copyFiles, IFilename file, String encoding, Set<String> opts, boolean reload) throws ListingException {
        DebugCopyFile[] dcf = this.checkNewListingArgs(file, copyFiles);
        return new Listing(fileLoader, dcf, (Filename)file, encoding, opts);
    }

    private DebugCopyFile[] checkNewListingArgs(IFilename file, IDebugCopyFile[] copyFiles) {
        DebugCopyFile[] dcf;
        if (file != null && !(file instanceof Filename)) {
            throw new IllegalArgumentException(file.toString());
        }
        if (copyFiles != null) {
            dcf = new DebugCopyFile[copyFiles.length];
            for (int i = 0; i < copyFiles.length; ++i) {
                if (!(copyFiles[i] instanceof DebugCopyFile)) {
                    throw new IllegalArgumentException("" + copyFiles[i]);
                }
                dcf[i] = (DebugCopyFile)copyFiles[i];
            }
        } else {
            dcf = new DebugCopyFile[]{};
        }
        return dcf;
    }

    @Override
    public IListing newListing(byte[] lInfo, int infoFormat, IDebugCopyFile[] copyFiles, IFilename file, String encoding, Set<String> opts) throws IOException {
        DebugCopyFile[] dcf = this.checkNewListingArgs(file, copyFiles);
        return new Listing(lInfo, infoFormat, dcf, (Filename)file, encoding, opts);
    }

    @Override
    public IFilename newFilename(String file) {
        return new Filename(file);
    }

    @Override
    public IDebugCommand newGetVariablesCommand(IVarName[] variablesNames, String[] classNames, int maxHexDumpLength, int startHexDumpOffset, int maxArrayLength, int startArrayOffset, int maxTextLength) {
        GetVariablesCommand cmd = (GetVariablesCommand)this.newGetVariablesCommand(variablesNames, maxHexDumpLength, startHexDumpOffset, maxArrayLength, startArrayOffset, maxTextLength);
        cmd.setClassNames(classNames);
        return cmd;
    }

    @Override
    public IDebugCommand newGetVariablesCommand(IVarName[] variablesNames, int maxHexDumpLength, int startHexDumpOffset, int maxArrayLength, int startArrayOffset, int maxTextLength) {
        VarName[] vn;
        if (variablesNames != null) {
            vn = new VarName[variablesNames.length];
            for (int i = 0; i < variablesNames.length; ++i) {
                if (!(variablesNames[i] instanceof VarName)) {
                    throw new IllegalArgumentException("" + variablesNames[i]);
                }
                vn[i] = (VarName)variablesNames[i];
            }
        } else {
            vn = new VarName[]{};
        }
        return new GetVariablesCommand(vn, maxHexDumpLength, startHexDumpOffset, maxArrayLength, startArrayOffset, maxTextLength);
    }

    @Override
    public IDebugCommand newGetVariablesCommand(IVarName varName, String[] classNames, int maxHexDumpLength, int startHexDumpOffset, int maxArrayLength, int startArrayOffset, int maxTextLength) {
        GetVariablesCommand cmd = (GetVariablesCommand)this.newGetVariablesCommand(varName, maxHexDumpLength, startHexDumpOffset, maxArrayLength, startArrayOffset, maxTextLength);
        cmd.setClassNames(classNames);
        return cmd;
    }

    @Override
    public IDebugCommand newGetVariablesCommand(IVarName varName, int maxHexDumpLength, int startHexDumpOffset, int maxArrayLength, int startArrayOffset, int maxTextLength) {
        if (!(varName instanceof VarName)) {
            throw new IllegalArgumentException("" + varName);
        }
        return new GetVariablesCommand((VarName)varName, maxHexDumpLength, startHexDumpOffset, maxArrayLength, startArrayOffset, maxTextLength);
    }

    @Override
    public IVarName newVarName(IDebugTM tm) throws Exception {
        if (!(tm instanceof DebugTM)) {
            throw new IllegalArgumentException("" + tm);
        }
        return new VarName((DebugTM)tm);
    }

    @Override
    public IVarValue parseVarValue(String value) {
        return DebugUtilities.parseVarValue(value);
    }

    @Override
    public IDebugCommand newTraceOnCommand(int level, String file) {
        return new TraceOnCommand(level, file);
    }

    @Override
    public IDebugCommand newTraceOffCommand() {
        return new TraceOffCommand();
    }

    @Override
    public PrintStream newDebugOutputStream(Appender appender) {
        return new DebugOutputStream(appender);
    }

    @Override
    public void unexpectedException(Throwable t) {
        Debugger.unexpectedException(t);
    }

    @Override
    public boolean hasIscobolDebugInfos(Object obj) {
        return obj != null && IscobolDebugger.class.isAssignableFrom(obj.getClass());
    }

    @Override
    public void startListener(int rd, int port, boolean redStreams, boolean standaloneMode, int blockMode) {
        Debugger.startListener(rd, port, redStreams, standaloneMode, blockMode);
    }

    @Override
    public void stopListener(boolean closeCurrentConnection) {
        Debugger.stopListener(closeCurrentConnection);
    }

    @Override
    public boolean suspending() {
        return Debugger.suspending();
    }

    @Override
    public IListingInfo getListingInfo(byte[] b) {
        try {
            return b != null ? new ListingInfo(b, 4) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public IDebugCommand newSetRedirectStreamsCommand(boolean v) {
        return new SetRedirectStreamsCommand(v);
    }

    @Override
    public IDebugCommand newClearBreakpointCommand(int line, String file, int fileIndex, String prog, String path) {
        return new ClearBreakpointCommand(line, file, fileIndex, prog, path);
    }

    @Override
    public IDebugCommand newClearBreakpointCommand(String par, String file, int fileIndex, String prog, String path) {
        return new ClearBreakpointCommand(par, file, fileIndex, prog, path);
    }

    @Override
    public IDebugCommand newClearBreakpointCommand(boolean clearAll) {
        return new ClearBreakpointCommand(clearAll);
    }

    @Override
    public IDebugCommand newClearMonitorCommand(IVarName vn, String cls, String prop) {
        return new ClearMonitorCommand((VarName)vn, cls, prop);
    }

    @Override
    public IDebugCommand newClearMonitorCommand(boolean clearAll) {
        return new ClearMonitorCommand(clearAll);
    }

    @Override
    public IDebugCommand newClearMonitorCommand(String envProp) {
        return new ClearMonitorCommand(envProp);
    }

    public IDebugCommand newCompositeCommand(Vector list) {
        return new CompositeCommand(list);
    }

    @Override
    public IDebugCommand newContinueCommand() {
        return new ContinueCommand();
    }

    @Override
    public IDebugCommand newDirectoryCommand(String dirname) {
        return new DirectoryCommand(dirname);
    }

    @Override
    public IDebugCommand newDisplayCommand(boolean displayClassVersion) {
        return new DisplayCommand(displayClassVersion);
    }

    @Override
    public IDebugCommand newDisplayCommand(IVarName vn, boolean hex, boolean tr) {
        return new DisplayCommand((VarName)vn, null, hex, tr);
    }

    @Override
    public IDebugCommand newDisplayCommand(IVarName vn, String propName) {
        return new DisplayCommand((VarName)vn, null, propName);
    }

    @Override
    public IDebugCommand newDisplayCommand(IVarName vn, boolean hex) {
        return new DisplayCommand((VarName)vn, null, hex);
    }

    @Override
    public IDebugCommand newDisplayCommand(IVarName vn, boolean hex, boolean tr, String className) {
        return new DisplayCommand((VarName)vn, className, hex, tr);
    }

    @Override
    public IDebugCommand newDisplayCommand(IVarName vn, String propName, String className) {
        return new DisplayCommand((VarName)vn, className, propName);
    }

    @Override
    public IDebugCommand newDisplayCommand(IVarName vn, boolean hex, String className) {
        return new DisplayCommand((VarName)vn, className, hex);
    }

    @Override
    public IDebugCommand newDisplayCommand(String envProp) {
        return new DisplayCommand(envProp);
    }

    @Override
    public IDebugCommand newEnvCommand(String name) {
        return new EnvCommand(name);
    }

    @Override
    public IDebugCommand newExitCommand(boolean tsre) {
        return new ExitCommand(tsre);
    }

    @Override
    public IDebugCommand newGCCommand() {
        return new GCCommand();
    }

    @Override
    public IDebugCommand newGetFileCommand(String path) {
        return new GetFileCommand(path);
    }

    @Override
    public IDebugCommand newJumpCommand(int line, String fileName, int fileIndex) {
        return this.newJumpCommand(line, fileName, fileIndex);
    }

    @Override
    public IDebugCommand newJumpCommand(String paragraph) {
        return new JumpCommand(paragraph);
    }

    @Override
    public IDebugCommand newJumpOutParagraphCommand() {
        return JumpCommand.getJumpOutParagraphInstance();
    }

    @Override
    public IDebugCommand newJumpOutProgramCommand() {
        return JumpCommand.getJumpOutProgramInstance();
    }

    @Override
    public IDebugCommand newLengthCommand(IVarName vn) {
        return new LengthCommand((VarName)vn, null);
    }

    @Override
    public IDebugCommand newLengthCommand(IVarName vn, String className) {
        return new LengthCommand((VarName)vn, className);
    }

    @Override
    public IDebugCommand newLetCommand(IVarName vn, boolean hex, String val) {
        return new LetCommand((VarName)vn, null, hex, val);
    }

    @Override
    public IDebugCommand newLetCommand(IVarName vn, String propName, String val) {
        return new LetCommand((VarName)vn, null, propName, val);
    }

    @Override
    public IDebugCommand newLetCommand(IVarName vn, boolean hex, String val, String className) {
        return new LetCommand((VarName)vn, className, hex, val);
    }

    @Override
    public IDebugCommand newLetCommand(IVarName vn, String propName, String val, String className) {
        return new LetCommand((VarName)vn, className, propName, val);
    }

    @Override
    public IDebugCommand newLetCommand(String envName, String val) {
        return new LetCommand(envName, val);
    }

    @Override
    public IDebugCommand newLoadSessionCommand(String fn) {
        return new LoadCommand(fn);
    }

    @Override
    public IDebugCommand newMemoryCommand() {
        return new MemoryCommand();
    }

    @Override
    public IDebugCommand newSetMethodBreakpointCommand(String methodName, boolean en, IExpression cond) {
        return new MethodBreakpointCommand(methodName, en, (Expression)cond);
    }

    @Override
    public IDebugCommand newOffsetCommand(IVarName vn) {
        return new OffsetCommand((VarName)vn, null);
    }

    @Override
    public IDebugCommand newOffsetCommand(IVarName vn, String className) {
        return new OffsetCommand((VarName)vn, className);
    }

    @Override
    public IDebugCommand newSetProgramBreakpointCommand(String name, boolean en, IExpression cond) {
        return new ProgramBreakpointCommand(name, en, (Expression)cond);
    }

    @Override
    public IDebugCommand newQuitCommand() {
        return new QuitCommand();
    }

    @Override
    public IDebugCommand newRawTextCommand(String rawText) {
        return new RawTextCommand(rawText);
    }

    @Override
    public IDebugCommand newRunCommand(String[] args) {
        return new RunCommand(args);
    }

    @Override
    public IDebugCommand newSaveSessionCommand(String filename) {
        return new SaveCommand(filename);
    }

    @Override
    public IDebugCommand newSetBreakpointCommand(int line, String file, int fileIndex, String prog, boolean en, String path) {
        return new SetBreakpointCommand(line, file, fileIndex, prog, en, path);
    }

    @Override
    public IDebugCommand newSetBreakpointCommand(int line, String file, int fileIndex, String prog, boolean en, String path, IExpression condition) {
        return new SetBreakpointCommand(line, file, fileIndex, prog, en, path, (Expression)condition);
    }

    @Override
    public IDebugCommand newSetBreakpointCommand(String par, String file, int fileIndex, String prog, boolean en, String path, IExpression condition) {
        return new SetBreakpointCommand(par, file, fileIndex, prog, en, path, (Expression)condition);
    }

    @Override
    public IDebugCommand newSetBreakpointCommand(String par, String file, int fileIndex, String prog, boolean en, String path) {
        return new SetBreakpointCommand(par, file, fileIndex, prog, en, path);
    }

    @Override
    public IDebugCommand newSetBreakpointCommand(boolean listing) {
        return new SetBreakpointCommand(listing);
    }

    @Override
    public IDebugCommand newSetMonitorCommand(IVarName vn, String cls, boolean hex, ICondition cond, boolean en) {
        return new SetMonitorCommand((VarName)vn, cls, hex, (Condition)cond, en);
    }

    @Override
    public IDebugCommand newSetMonitorCommand(IVarName vn, String cls, String prop, ICondition cond, boolean en) {
        return new SetMonitorCommand((VarName)vn, cls, prop, (Condition)cond, en);
    }

    @Override
    public IDebugCommand newSetMonitorCommand(String envProp, ICondition cond, boolean en) {
        return new SetMonitorCommand(envProp, (Condition)cond, en);
    }

    @Override
    public IDebugCommand newSetMonitorCommand(boolean listing) {
        return new SetMonitorCommand(listing);
    }

    @Override
    public IDebugCommand newStepIntoCommand(int stepNumber) {
        return new StepIntoCommand(stepNumber);
    }

    @Override
    public IDebugCommand newStepOutParagraphCommand() {
        return new StepOutParagraphCommand();
    }

    @Override
    public IDebugCommand newStepOutProgramCommand() {
        return new StepOutProgramCommand();
    }

    @Override
    public IDebugCommand newStepOverCommand() {
        return new StepOverCommand();
    }

    @Override
    public IDebugCommand newStepToCommand(int l, String file, int fileIndex) {
        return new StepToCommand(l, file, fileIndex);
    }

    @Override
    public IDebugCommand newStepToNextProgramCommand() {
        return new StepToNextProgramCommand();
    }

    @Override
    public IDebugCommand newSuspendCommand() {
        return new SuspendCommand();
    }

    @Override
    public IDebugCommand newThreadCommand(String th) {
        return new ThreadCommand(th);
    }

    @Override
    public IDebugCommand newThreadCommand(boolean listing) {
        return new ThreadCommand(listing);
    }
}

