/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.interfaces.debugger.IDebugTM;
import com.iscobol.interfaces.debugger.IDebugTMMarker;
import java.util.StringTokenizer;

public class DebugTM
implements IDebugTM {
    private String[] tokenBuffer;
    private int tokenIdx;
    private DebugCommand[] commands;

    public DebugTM(String s) {
        this(s, " ,;(:=)+*\"<>", DebuggerInvoker.standardCommands);
    }

    public DebugTM(String s, String delim, DebugCommand[] commands) {
        this.commands = commands;
        StringTokenizer stk = new StringTokenizer(s, delim, true);
        int count = stk.countTokens();
        this.tokenBuffer = new String[count];
        int i = 0;
        while (stk.hasMoreTokens()) {
            this.tokenBuffer[i] = stk.nextToken();
            ++i;
        }
    }

    protected String getCommandAlias(String commandStringId) {
        return null;
    }

    @Override
    public int getCommand() throws DebuggerException {
        return this.getCommand(this.getToken());
    }

    @Override
    public int getCommand(String str) throws DebuggerException {
        int Return2 = -2;
        String error = null;
        if (str == null) {
            return -1;
        }
        if (str.equals("?")) {
            return 20;
        }
        for (int j = 0; j < this.commands.length; ++j) {
            String cmdStringId = this.commands[j].getStringId();
            String cmdAlias = this.getCommandAlias(cmdStringId);
            if (cmdAlias != null) {
                cmdStringId = cmdAlias;
            }
            String cmd = cmdStringId;
            if (this.commands[j].isWholeWord() && cmd.equalsIgnoreCase(str)) {
                Return2 = this.commands[j].getId();
                break;
            }
            if (this.commands[j].isWholeWord() || cmd.length() < str.length() || !cmd.substring(0, str.length()).equalsIgnoreCase(str)) continue;
            if (error == null) {
                error = str + ": " + cmdStringId;
                Return2 = this.commands[j].getId();
                continue;
            }
            error = error + ", " + cmdStringId;
            Return2 = -2;
        }
        if (Return2 == -2) {
            if (error == null) {
                throw new DebuggerException(33, "'" + str + "'");
            }
            throw new DebuggerException(34, error);
        }
        return Return2;
    }

    @Override
    public Marker setMarker() {
        return new Marker(Math.min(this.tokenIdx, this.tokenBuffer.length - 1));
    }

    @Override
    public void rewindToMarker(IDebugTMMarker mk) {
        if (!(mk instanceof Marker)) {
            throw new IllegalArgumentException("" + mk);
        }
        this.rewindToMarker((Marker)mk);
    }

    public void rewindToMarker(Marker mk) {
        this.tokenIdx = mk.idx;
    }

    @Override
    public String getAllToken() {
        if (this.tokenIdx < this.tokenBuffer.length) {
            return this.tokenBuffer[this.tokenIdx++];
        }
        return null;
    }

    @Override
    public void ungetAllToken() {
        if (this.tokenIdx > 0) {
            --this.tokenIdx;
        }
    }

    @Override
    public void ungetToken() {
        while (this.tokenIdx > 0) {
            this.ungetAllToken();
            if (DebugTM.isSeparator(this.tokenBuffer[this.tokenIdx])) continue;
            break;
        }
    }

    @Override
    public String getTokenAndComma() {
        while (this.tokenIdx < this.tokenBuffer.length) {
            String tk = this.getAllToken();
            if (!tk.equals(",") && DebugTM.isSeparator(tk)) continue;
            return tk;
        }
        return null;
    }

    @Override
    public String getToken() {
        while (this.tokenIdx < this.tokenBuffer.length) {
            String tk = this.getAllToken();
            if (DebugTM.isSeparator(tk)) continue;
            return tk;
        }
        return null;
    }

    @Override
    public int countAllTokens() {
        return this.tokenBuffer.length - this.tokenIdx;
    }

    @Override
    public int countTokens() {
        int Return2 = 0;
        int n = this.countAllTokens();
        for (int i = 0; i < n; ++i) {
            if (DebugTM.isSeparator(this.tokenBuffer[this.tokenIdx + i])) continue;
            ++Return2;
        }
        return Return2;
    }

    public static boolean isSeparator(String tk) {
        return tk.equals(" ") || tk.equals(",");
    }

    public String toString(Marker beginMk, Marker endMk) {
        return this.toString(beginMk.idx, endMk.idx);
    }

    public String toString() {
        return this.toString(0, this.tokenBuffer.length - 1);
    }

    private String toString(int beginIdx, int endIdx) {
        StringBuffer Return2 = new StringBuffer();
        for (int i = beginIdx; i <= endIdx; ++i) {
            if (DebugTM.isSeparator(this.tokenBuffer[i])) continue;
            Return2.append(this.tokenBuffer[i] + " ");
        }
        if (Return2.length() > 0) {
            Return2.deleteCharAt(Return2.length() - 1);
        }
        return Return2.toString();
    }

    public class Marker
    implements IDebugTMMarker {
        private int idx;

        private Marker(int i) {
            this.idx = i;
        }
    }
}

