/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Breakpoint;
import com.iscobol.debugger.Condition;
import com.iscobol.debugger.Debugger;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Expression;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.Watch;
import com.iscobol.rts.INumericVar;
import java.io.File;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public class BreakpointManager {
    protected static final String EXTERNAL_KEY = "external";
    private static Map<String, Vector<Breakpoint>> breakpoints = new LinkedHashMap<String, Vector<Breakpoint>>();
    private static Map<String, Watch> monitors = new LinkedHashMap<String, Watch>();
    private static Map<String, Map<String, Watch>> monitorToAdd = new LinkedHashMap<String, Map<String, Watch>>();
    private static Breakpoint temporary = null;
    private static Breakpoint jump = null;

    private static String getKey(String file, String lineOrParagraph) {
        return new File(file.toLowerCase()).getName() + "$" + lineOrParagraph;
    }

    public static void addTempBreakpoint(int lineNo, String file, int fileIndex) {
        temporary = new Breakpoint(lineNo, file, fileIndex, null, true);
    }

    public static void addJumppoint(int lineNo, String file, int fileIndex) {
        jump = new Breakpoint(lineNo, file, fileIndex, null, true);
    }

    public static void addJumppoint(String paragraph, String file) {
        jump = new Breakpoint(paragraph, file, null, true);
    }

    public static boolean checkTempBreakpoint(int lineNo, String file, int fileIndex) {
        if (temporary != null && temporary.equals(new Breakpoint(lineNo, file, fileIndex, null, true))) {
            temporary = null;
            return true;
        }
        return false;
    }

    public static boolean checkJumppoint(int lineNo, String file, int fileIndex) {
        if (jump != null && jump.equals(new Breakpoint(lineNo, file, fileIndex, null, true))) {
            jump = null;
            return true;
        }
        return false;
    }

    public static boolean checkJumppoint(String paragraph, String file) {
        if (jump != null && jump.equals(new Breakpoint(paragraph, file, null, true))) {
            jump = null;
            return true;
        }
        return false;
    }

    public static Breakpoint addBreakpoint(int lineNo, String file, int fileIndex, String progName, boolean enabled) {
        return BreakpointManager.addBreakpoint(lineNo, file, fileIndex, progName, null, enabled);
    }

    public static Breakpoint addBreakpoint(int lineNo, String file, int fileIndex, String progName, Expression condition, boolean enabled) {
        String key = BreakpointManager.getKey(file, "" + lineNo);
        Vector<Breakpoint> bpList = breakpoints.get(key);
        if (bpList == null) {
            bpList = new Vector();
        }
        Breakpoint Return2 = new Breakpoint(lineNo, file, fileIndex, progName, condition, enabled);
        for (Breakpoint tmp : bpList) {
            if (!tmp.equals(Return2)) continue;
            bpList.removeElement(tmp);
            break;
        }
        bpList.addElement(Return2);
        breakpoints.put(key, bpList);
        return Return2;
    }

    public static Breakpoint addBreakpoint(String paragraph, int lineNo, String file, int fileIndex, String progName, Expression condition, boolean enabled) {
        String key = BreakpointManager.getKey(file, paragraph.toLowerCase());
        Vector<Breakpoint> bpList = breakpoints.get(key);
        if (bpList == null) {
            bpList = new Vector();
        }
        Breakpoint Return2 = new Breakpoint(paragraph, lineNo, file, fileIndex, progName, condition, enabled);
        for (Breakpoint tmp : bpList) {
            if (!tmp.equals(Return2)) continue;
            bpList.removeElement(tmp);
            break;
        }
        bpList.addElement(Return2);
        breakpoints.put(key, bpList);
        return Return2;
    }

    public static Breakpoint removeBreakpoint(int lineNo, String file, int fileIndex, String progName) {
        return BreakpointManager.intRemoveBreakpoint(BreakpointManager.getKey(file, "" + lineNo), new Breakpoint(lineNo, file, fileIndex, progName, true));
    }

    public static Breakpoint removeBreakpoint(String paragraph, String file, String progName) {
        return BreakpointManager.intRemoveBreakpoint(BreakpointManager.getKey(file, paragraph.toLowerCase()), new Breakpoint(paragraph, file, progName, true));
    }

    private static Breakpoint intRemoveBreakpoint(String key, Breakpoint target) {
        Vector<Breakpoint> bpList = breakpoints.get(key);
        if (bpList == null) {
            return null;
        }
        Enumeration<Breakpoint> en = bpList.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            Breakpoint bp = en.nextElement();
            if (bp.equals(target)) {
                bpList.removeElementAt(i);
                if (bpList.isEmpty()) {
                    breakpoints.remove(key);
                }
                return bp;
            }
            ++i;
        }
        return null;
    }

    public static boolean checkBreakpoint(int lineNo, String file, int fileIndex, String progName, Debugger dbg) {
        return BreakpointManager.intCheckBreakpoint(BreakpointManager.getKey(file, "" + lineNo), new Breakpoint(lineNo, file, fileIndex, progName, true), dbg);
    }

    public static boolean checkBreakpoint(String paragraph, String file, String progName, Debugger dbg) {
        return BreakpointManager.intCheckBreakpoint(BreakpointManager.getKey(file, paragraph.toLowerCase()), new Breakpoint(paragraph, file, progName, true), dbg);
    }

    private static boolean intCheckBreakpoint(String key, Breakpoint target, Debugger dbg) {
        Vector<Breakpoint> bpList = breakpoints.get(key);
        if (bpList == null) {
            return false;
        }
        for (Breakpoint bp : bpList) {
            if (!bp.isEnabled() || !bp.equals(target)) continue;
            Expression condition = bp.getCondition();
            if (condition != null) {
                try {
                    Object val = condition.evaluate(dbg, false, condition.isHex());
                    return val instanceof Boolean && (Boolean)val != false;
                }
                catch (DebuggerException e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static void removeAllBreakpoints() {
        breakpoints.clear();
    }

    public static void setMonitorToAdd(String cls, VarName vn, Condition cond, String propName, boolean hex, boolean enabled) {
        BreakpointManager.removeMonitor(cls, vn.getFullName(), propName);
        Map<String, Watch> m = monitorToAdd.get(cls);
        if (m == null) {
            m = new LinkedHashMap<String, Watch>();
            monitorToAdd.put(cls, m);
        }
        m.put(BreakpointManager.buildMonitorKey(vn.getFullName(), cls, propName), new Watch(vn, null, cond, cls, propName, hex, enabled));
    }

    public static Watch[] getMonitorToAdd(String cls) {
        Map<String, Watch> m = monitorToAdd.get(cls);
        if (m == null) {
            return new Watch[0];
        }
        return m.values().toArray(new Watch[m.size()]);
    }

    public static void addEnvMonitor(String envProp, String currValue, Condition cond, boolean enabled) {
        String key = "ENV$$" + envProp.toUpperCase();
        monitors.put(key, new Watch(envProp, currValue, cond, enabled));
    }

    public static boolean removeEnvMonitor(String envProp) {
        String key = "ENV$$" + envProp.toUpperCase();
        return monitors.remove(key) != null;
    }

    public static void addMonitor(VarName varname, Debugger.IscobolField field, Object var, String fullName, Condition cond, String cls, boolean hex, boolean enabled) {
        monitors.put(BreakpointManager.buildMonitorKey(fullName, cls, null), new Watch(varname, field, var, fullName, cond, cls, hex, enabled));
    }

    public static void addMonitor(INumericVar handle, String fullName, Condition cond, String cls, String propName, String currValue, boolean hex, boolean enabled) {
        monitors.put(BreakpointManager.buildMonitorKey(fullName, cls, propName), new Watch(handle, fullName, cond, cls, propName, currValue, hex, enabled));
    }

    private static boolean intRemoveMonitor(String fullName, String cls, String propName) {
        return monitors.remove(BreakpointManager.buildMonitorKey(fullName, cls, propName)) != null;
    }

    private static String buildMonitorKey(String fullName, String cls, String propName) {
        String key = fullName.toUpperCase() + "@" + cls;
        if (propName != null) {
            key = key + "::" + propName.toUpperCase();
        }
        return key;
    }

    public static void removeMonitorToAdd(String cls) {
        monitorToAdd.remove(cls);
    }

    public static boolean removeMonitor(String cls, String fullName, String propName) {
        if (BreakpointManager.intRemoveMonitor(fullName, cls, propName)) {
            return true;
        }
        Map<String, Watch> m = monitorToAdd.get(cls);
        if (m != null) {
            m.remove(BreakpointManager.buildMonitorKey(fullName, cls, propName));
        }
        return false;
    }

    public static Watch[] getMonitors(Debugger dbg) {
        return BreakpointManager.getMonitors(null, dbg);
    }

    public static Watch[] getMonitors(String classname, Debugger dbg) {
        Watch[] Return2 = BreakpointManager.checkMonitors(classname, true, dbg);
        if (Return2 != null) {
            for (int i = 0; i < Return2.length; ++i) {
                Debugger.IscobolField field = Return2[i].getField();
                if (field != null) {
                    Return2[i].refresh(dbg, field, false);
                    continue;
                }
                VarName varname = Return2[i].getVarName();
                if (varname != null) {
                    try {
                        field = dbg.findVar(varname, false);
                    }
                    catch (DebuggerException debuggerException) {
                        // empty catch block
                    }
                }
                Return2[i].refresh(dbg, field, true);
            }
        }
        return Return2;
    }

    public static Watch[] checkBreakMonitors(String classname, Debugger dbg) {
        return BreakpointManager.checkMonitors(classname, false, dbg);
    }

    private static Watch[] checkMonitors(String classname, boolean getAll, Debugger dbg) {
        Vector<Watch> v = new Vector<Watch>();
        for (Watch watch : monitors.values()) {
            if (watch.getEnvProperty() == null && classname != null) {
                watch.setActive(watch.getClassname().equals(classname) || watch.getClassname().equals(EXTERNAL_KEY));
            }
            if (!getAll && !watch.shouldNotifyChange(dbg)) continue;
            v.addElement(watch);
        }
        if (getAll) {
            for (Map map : monitorToAdd.values()) {
                v.addAll(map.values());
            }
        }
        if (v.size() == 0) {
            return null;
        }
        Watch[] Return2 = new Watch[v.size()];
        v.toArray(Return2);
        return Return2;
    }

    public static void removeAllMonitors() {
        monitors.clear();
        monitorToAdd.clear();
    }

    public static Breakpoint[] getBreakpoints() {
        Vector<Breakpoint> allBps = new Vector<Breakpoint>();
        for (Vector<Breakpoint> v : breakpoints.values()) {
            allBps.addAll(v);
        }
        return allBps.toArray(new Breakpoint[allBps.size()]);
    }
}

