/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote.server;

import com.iscobol.as.IDEHandler;
import com.iscobol.compiler.remote.server.RemoteCompiler;
import com.iscobol.interfaces.runtime.IIDESettings;
import com.iscobol.rts.RtsUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RemoteCompilerClassLoader
extends URLClassLoader {
    private final List<File> paths;

    private RemoteCompilerClassLoader(String[] paths, ClassLoader parent) {
        super(new URL[0], parent);
        ArrayList<File> f = new ArrayList<File>();
        for (String p : paths) {
            try {
                File file = new File(p);
                this.addURL(file.toURI().toURL());
                f.add(file);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.paths = Collections.unmodifiableList(f);
    }

    public static RemoteCompilerClassLoader getInstance() {
        String[] pathList;
        String cp;
        Map<String, String> m;
        IIDESettings conf = IDEHandler.getConfigurationFile();
        if (conf != null && (m = conf.getModes().get("Default")) != null && (cp = m.get("iscobol.classpath")) != null && cp.length() > 0 && (pathList = RtsUtil.getPathList(cp = cp.replace("\t", ";"))).length > 0) {
            return new RemoteCompilerClassLoader(pathList, RemoteCompiler.class.getClassLoader());
        }
        return null;
    }

    public List<File> getPaths() {
        return this.paths;
    }
}

