/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote;

import com.iscobol.compiler.Errors;
import com.iscobol.compiler.remote.RemoteBridgeFile;
import com.iscobol.compiler.remote.RemoteErrors;
import com.iscobol.compiler.remote.RemoteFile;
import com.iscobol.interfaces.compiler.remote.IRemoteUnitOutput;
import com.iscobol.rts.RtsUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;

public class PPFileOutput
implements IRemoteUnitOutput,
Externalizable {
    private static final long serialVersionUID = 1L;
    private RemoteFile translatedFile;
    private RemoteFile errorFile;
    private RemoteFile listingFile;
    private RemoteFile[] classFiles;
    private Vector bridgeFiles = new Vector();
    private Vector javaFiles = new Vector();
    private RemoteFile iscobolListingFile;
    private RemoteFile iscobolErrorFile;
    private Vector copyFileNames;
    private RemoteErrors errors;
    private String fullClassName;
    private String sourceFileName;

    public PPFileOutput() {
    }

    public PPFileOutput(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    @Override
    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    @Override
    public RemoteFile getTranslatedFile() {
        return this.translatedFile;
    }

    public void setTranslatedFile(RemoteFile translatedFile) {
        this.translatedFile = translatedFile;
    }

    @Override
    public RemoteFile getErrorFile() {
        return this.errorFile;
    }

    public void setErrorFile(RemoteFile errorFile) {
        this.errorFile = errorFile;
    }

    @Override
    public RemoteFile getListingFile() {
        return this.listingFile;
    }

    public void setListingFile(RemoteFile listingFile) {
        this.listingFile = listingFile;
    }

    public RemoteFile[] getClassFiles() {
        return this.classFiles;
    }

    public void setClassFiles(RemoteFile[] classFiles) {
        this.classFiles = classFiles;
    }

    @Override
    public RemoteFile getJavaFile() {
        return this.javaFiles.size() > 0 ? (RemoteFile)this.javaFiles.elementAt(0) : null;
    }

    public void addJavaFile(RemoteFile javaFile) {
        this.javaFiles.addElement(javaFile);
    }

    @Override
    public RemoteFile getIscobolListingFile() {
        return this.iscobolListingFile;
    }

    public void setIscobolListingFile(RemoteFile iscobolListingFile) {
        this.iscobolListingFile = iscobolListingFile;
    }

    @Override
    public RemoteFile getIscobolErrorFile() {
        return this.iscobolErrorFile;
    }

    public void setIscobolErrorFile(RemoteFile iscobolErrorFile) {
        this.iscobolErrorFile = iscobolErrorFile;
    }

    @Override
    public Vector getCopyFileNames() {
        return this.copyFileNames;
    }

    public void setCopyFileNames(Vector copyFileNames) {
        this.copyFileNames = copyFileNames;
    }

    @Override
    public Errors getErrors() {
        return this.errors;
    }

    public void setErrors(RemoteErrors errors) {
        this.errors = errors;
    }

    @Override
    public String getFullClassName() {
        return this.fullClassName;
    }

    public void setFullClassName(String fullClassName) {
        this.fullClassName = fullClassName;
    }

    public RemoteBridgeFile[] getBridgeFiles() {
        RemoteBridgeFile[] Return2 = new RemoteBridgeFile[this.bridgeFiles.size()];
        this.bridgeFiles.toArray(Return2);
        return Return2;
    }

    public void addBridgeFile(RemoteBridgeFile bridgeFile) {
        this.bridgeFiles.addElement(bridgeFile);
    }

    public RemoteFile[] getJavaFiles() {
        RemoteFile[] Return2 = new RemoteFile[this.javaFiles.size()];
        this.javaFiles.toArray(Return2);
        return Return2;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.bridgeFiles.size());
        for (Object o : this.bridgeFiles) {
            ((RemoteBridgeFile)o).writeExternal(out);
        }
        if (this.classFiles != null) {
            out.writeInt(this.classFiles.length);
            for (int i = 0; i < this.classFiles.length; ++i) {
                this.classFiles[i].writeExternal(out);
            }
        } else {
            out.writeInt(0);
        }
        if (this.copyFileNames != null) {
            out.writeInt(this.copyFileNames.size());
            for (Object o : this.copyFileNames) {
                RtsUtil.writeUTF(((String[])o)[0], out);
                RtsUtil.writeUTF(((String[])o)[1], out);
                RtsUtil.writeUTF(((String[])o)[2], out);
            }
        } else {
            out.writeInt(0);
        }
        out.writeBoolean(this.errorFile != null);
        if (this.errorFile != null) {
            this.errorFile.writeExternal(out);
        }
        out.writeBoolean(this.errors != null);
        if (this.errors != null) {
            this.errors.writeExternal(out);
        }
        RtsUtil.writeUTF(this.fullClassName, out);
        out.writeBoolean(this.iscobolErrorFile != null);
        if (this.iscobolErrorFile != null) {
            this.iscobolErrorFile.writeExternal(out);
        }
        out.writeBoolean(this.iscobolListingFile != null);
        if (this.iscobolListingFile != null) {
            this.iscobolListingFile.writeExternal(out);
        }
        out.writeInt(this.javaFiles.size());
        for (Object o : this.javaFiles) {
            ((RemoteFile)o).writeExternal(out);
        }
        out.writeBoolean(this.listingFile != null);
        if (this.listingFile != null) {
            this.listingFile.writeExternal(out);
        }
        RtsUtil.writeUTF(this.sourceFileName, out);
        out.writeBoolean(this.translatedFile != null);
        if (this.translatedFile != null) {
            this.translatedFile.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean b;
        int i;
        this.bridgeFiles.clear();
        int n = in.readInt();
        for (i = 0; i < n; ++i) {
            RemoteBridgeFile rf = new RemoteBridgeFile();
            rf.readExternal(in);
            this.bridgeFiles.addElement(rf);
        }
        n = in.readInt();
        if (n > 0) {
            this.classFiles = new RemoteFile[n];
            for (i = 0; i < n; ++i) {
                this.classFiles[i] = new RemoteFile();
                this.classFiles[i].readExternal(in);
            }
        }
        if ((n = in.readInt()) > 0) {
            this.copyFileNames = new Vector();
            for (i = 0; i < n; ++i) {
                this.copyFileNames.addElement(new String[]{RtsUtil.readUTF(in), RtsUtil.readUTF(in), RtsUtil.readUTF(in)});
            }
        }
        if (b = in.readBoolean()) {
            this.errorFile = new RemoteFile();
            this.errorFile.readExternal(in);
        }
        if (b = in.readBoolean()) {
            this.errors = new RemoteErrors();
            this.errors.readExternal(in);
        }
        this.fullClassName = RtsUtil.readUTF(in);
        b = in.readBoolean();
        if (b) {
            this.iscobolErrorFile = new RemoteFile();
            this.iscobolErrorFile.readExternal(in);
        }
        if (b = in.readBoolean()) {
            this.iscobolListingFile = new RemoteFile();
            this.iscobolListingFile.readExternal(in);
        }
        this.javaFiles.clear();
        n = in.readInt();
        for (int i2 = 0; i2 < n; ++i2) {
            RemoteFile rf = new RemoteFile();
            rf.readExternal(in);
            this.javaFiles.addElement(rf);
        }
        b = in.readBoolean();
        if (b) {
            this.listingFile = new RemoteFile();
            this.listingFile.readExternal(in);
        }
        this.sourceFileName = RtsUtil.readUTF(in);
        b = in.readBoolean();
        if (b) {
            this.translatedFile = new RemoteFile();
            this.translatedFile.readExternal(in);
        }
    }
}

