/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.html;

import com.iscobol.compiler.OptionList;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;

public class HtmlPreProcessor
extends Reader {
    protected static String eolSt = System.getProperty("line.separator", "\n");
    protected static char[] eolCh = eolSt.toCharArray();
    private final LineNumberReader inpFile;
    private LineNumberReader cpyFile;
    private char[] currLine = eolCh;
    private int currOffs = eolCh.length;
    private final OptionList opList;
    private final int col0;
    private final LinkedList linesStack;
    private ArrayList lines;

    public HtmlPreProcessor(Reader in, OptionList ol, LinkedList stk) {
        this.inpFile = new LineNumberReader(in);
        this.opList = ol;
        this.col0 = ol.getOption("-sa") != null ? 7 : (ol.getOption("-st") != null ? 0 : 0);
        this.linesStack = stk;
    }

    protected boolean nextLine() throws IOException {
        String line = this.inpFile.readLine();
        if (line == null) {
            this.currLine = eolCh;
            this.currOffs = eolCh.length;
            return false;
        }
        this.currLine = this.process(line);
        this.currOffs = 0;
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.currOffs >= this.currLine.length) {
            this.currOffs = 0;
            if (this.currLine == eolCh) {
                if (this.nextLine()) {
                    return this.read();
                }
                return -1;
            }
            this.currLine = eolCh;
            return this.currLine[this.currOffs++];
        }
        return this.currLine[this.currOffs++];
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int i = 0;
        int j = off;
        while (i < len) {
            int c = this.read();
            if (c < 0) {
                if (i != 0) break;
                return -1;
            }
            cbuf[j] = (char)c;
            ++i;
            ++j;
        }
        return i;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("skip() not supported");
    }

    @Override
    public boolean ready() throws IOException {
        throw new IOException("ready() not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark() not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    @Override
    public void close() throws IOException {
        this.inpFile.close();
        if (this.cpyFile != null) {
            this.cpyFile.close();
        }
    }

    private char[] process(String line) {
        if (this.lines != null) {
            if (line.matches("^[ \t]*(?i)end-exec[. \t]*$")) {
                this.lines = null;
                return line.toCharArray();
            }
            if (this.col0 == 0) {
                this.lines.add(line);
                return ("*>" + line).toCharArray();
            }
            String ll = line.substring(this.col0);
            this.lines.add(ll);
            return (line.substring(0, this.col0) + "*>" + ll).toCharArray();
        }
        if (line.matches("^[ \t]*(?i)exec[ \t][ \t]*html[ \t]*$")) {
            if (this.col0 > 0) {
                line = line.substring(0, this.col0) + line.substring(this.col0).trim();
            }
            line = line + " ";
            line = line + this.linesStack.size();
            this.lines = new ArrayList();
            this.linesStack.add(this.lines);
        }
        return line.toCharArray();
    }
}

