/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.Function;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GenericObject;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.InlineInvoke;
import com.iscobol.compiler.InlineSetGetProperty;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.MalformedDataNameException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.OffsetHelper;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SubValueList;
import com.iscobol.compiler.Subscript;
import com.iscobol.compiler.SubscriptList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UndefinedException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationScreen;
import com.iscobol.interfaces.compiler.IVariableName;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;

public class VariableName
implements CobolToken,
ErrorsNumbers,
GenericObject,
IVariableName {
    Token name;
    boolean rounded;
    VariableDeclaration varDecl;
    private VariableName of;
    private SubscriptList indexes;
    private SubValueList subValue;
    private Errors error;
    private Token function;
    private VariableDeclaration functionVar;
    private boolean isSpecial;
    boolean isSelf;
    boolean isSuper;
    private boolean isAll;
    private boolean hasAllSubscript;
    private final Pcc pc;
    private boolean lambdaExpr;
    private String sqlCallMode;
    public int sqlTypeFunc = -1;
    public boolean sqlTypeCast = false;
    private String sqljName = null;
    private String sqljNameParam = null;
    private static final int RECORD_POSITION = 1;
    private static final int FUNCTION = 2;
    private static final int LENGTH_OF = 3;
    private static final int EXCEPTION_OBJECT = 4;
    private static final int LINAGE_COUNTER = 5;
    private static final int CURRENT_DATE = 6;
    private static final int TIME_OF_DAY = 7;
    private static final int WHEN_COMPILED = 8;
    private static final int ADDRESS_OF = 9;
    private static final int PROG_ID = 10;
    private static final Hashtable specialNames = new Hashtable();

    static int isSpecialName(String n, TokenManager t) {
        Integer f = (Integer)specialNames.get(n);
        if (f != null) {
            if (t.isNotReservedWord(n)) {
                switch (f) {
                    case 8: 
                    case 10: {
                        if (t.getOptionList().getOption("-cr") != null) {
                            return f;
                        }
                        return 0;
                    }
                }
                return 0;
            }
            return f;
        }
        return 0;
    }

    public static VariableName get(TokenManager tm, Errors err) throws EndOfProgramException, GeneralErrorException {
        return VariableName.get(tm, err, null);
    }

    private void checkIndexes(Pcc pc) throws GeneralErrorException {
        if (this.indexes != null) {
            Subscript s = this.indexes.getFirst();
            while (s != null) {
                s.check(this.name, this.error, pc);
                s = this.indexes.getNext();
            }
        }
    }

    public void checkAny(Pcc pc, GetVarOpts opts) throws GeneralErrorException {
        this.associateToVarDeclAny(pc, true, true, opts);
        this.checkIndexes(pc);
    }

    public void checkObject(Pcc pc) throws GeneralErrorException {
        this.associateToVarDeclObj(pc);
        this.checkIndexes(pc);
    }

    public void check(Pcc pc) throws GeneralErrorException {
        this.check(pc, true, true, GetVarOpts.NO_OPTS);
    }

    public void check(Pcc pc, boolean ckDim, boolean setUsed, GetVarOpts opts) throws GeneralErrorException {
        this.associateToVarDeclVar(pc, ckDim, setUsed, opts);
        this.checkIndexes(pc);
    }

    public static VariableName getAny(TokenManager tm, Errors err, Pcc pc) throws EndOfProgramException, GeneralErrorException {
        return VariableName.getAny(tm, err, null, pc, GetVarOpts.NO_OPTS);
    }

    public static VariableName getAny(TokenManager tm, Errors err, Block blk, Pcc pc) throws EndOfProgramException, GeneralErrorException {
        return VariableName.getAny(tm, err, blk, pc, GetVarOpts.NO_OPTS);
    }

    public static VariableName getAny(TokenManager tm, Errors err, Block blk, Pcc pc, GetVarOpts opts) throws EndOfProgramException, GeneralErrorException {
        VariableName Return2 = VariableName.internalGet(tm, err, blk, pc);
        if (Return2 != null) {
            if (pc != null) {
                Return2.checkAny(pc, opts);
            }
            VariableName.checkDynGroup(Return2, opts.dynGroupAllowed, err);
        }
        return Return2;
    }

    public static VariableName getAnyUsing(TokenManager tm, Errors err, Block blk, Pcc pc) throws EndOfProgramException, GeneralErrorException {
        VariableName Return2 = VariableName.internalGet(tm, err, blk, pc);
        if (Return2 != null) {
            if (pc != null) {
                Return2.associateToVarDeclAny(pc, false, true, GetVarOpts.DYN_GRP_ALLOW);
                Return2.checkIndexes(pc);
            }
            VariableName.checkDynGroup(Return2, true, err);
        }
        return Return2;
    }

    static void checkDynGroup(VariableName Return2, boolean dynGroupAllowed, Errors err) {
        if (Return2.getVarDecl() != null && Return2.getVarDecl().isVariableLengthGroup() && (Return2.hasSubValue() && dynGroupAllowed || !Return2.hasSubValue() && !dynGroupAllowed)) {
            err.print(257, 2, Return2.getNameToken(), Return2.getName());
        }
    }

    public static VariableName getObject(TokenManager tm, Errors err, Block blk, Pcc pc) throws EndOfProgramException, GeneralErrorException {
        VariableName Return2 = VariableName.internalGet(tm, err, blk, pc);
        if (Return2 != null && pc != null) {
            if ("SELF".equals(Return2.name.getWord())) {
                Return2.setVarDecl(pc.getSelfVarDecl());
            } else {
                Return2.checkObject(pc);
            }
        }
        return Return2;
    }

    public static VariableName get(TokenManager tm, Errors err, Pcc pc, GetVarOpts opts) throws EndOfProgramException, GeneralErrorException {
        return VariableName.get(tm, err, null, pc, true, true, true, true, opts);
    }

    public static VariableName get(TokenManager tm, Errors err, Pcc pc) throws EndOfProgramException, GeneralErrorException {
        return VariableName.get(tm, err, pc, true);
    }

    public static VariableName get(TokenManager tm, Errors err, Pcc pc, boolean ckDim) throws EndOfProgramException, GeneralErrorException {
        return VariableName.get(tm, err, pc, ckDim, true);
    }

    public static VariableName get(TokenManager tm, Errors err, Pcc pc, boolean ckDim, boolean doCheck) throws EndOfProgramException, GeneralErrorException {
        return VariableName.get(tm, err, null, pc, ckDim, doCheck);
    }

    public static VariableName get(TokenManager tm, Errors err, Block blk, Pcc pc, boolean ckDim, boolean doCheck) throws EndOfProgramException, GeneralErrorException {
        return VariableName.get(tm, err, blk, pc, ckDim, doCheck, true, true, GetVarOpts.NO_OPTS);
    }

    public static VariableName get(TokenManager tm, Errors err, Block blk, Pcc pc, boolean ckDim, boolean doCheck, boolean checkscreenname, boolean setUsed) throws EndOfProgramException, GeneralErrorException {
        return VariableName.get(tm, err, blk, pc, ckDim, doCheck, checkscreenname, setUsed, GetVarOpts.NO_OPTS);
    }

    public static VariableName get(TokenManager tm, Errors err, Block blk, Pcc pc, boolean ckDim, boolean doCheck, boolean checkscreenname, boolean setUsed, GetVarOpts opts) throws EndOfProgramException, GeneralErrorException {
        return VariableName.get(tm, err, blk, pc, ckDim, doCheck, checkscreenname, setUsed, opts, false);
    }

    public static VariableName get(TokenManager tm, Errors err, Block blk, Pcc pc, boolean ckDim, boolean doCheck, boolean checkscreenname, boolean setUsed, GetVarOpts opts, boolean nameCall) throws EndOfProgramException, GeneralErrorException {
        VariableName Return2 = VariableName.internalGet(tm, err, blk, pc, nameCall);
        if (Return2 != null) {
            if (pc != null && doCheck) {
                Return2.check(pc, ckDim, setUsed, opts);
                if (checkscreenname) {
                    VariableDeclarationScreen.checkScreenName(Return2.getVarDecl(), Return2.getNameToken(), err);
                }
            }
            VariableName.checkDynGroup(Return2, opts.dynGroupAllowed, err);
        }
        return Return2;
    }

    private static VariableName internalGet(TokenManager tm, Errors err, Block blk, Pcc pc) throws EndOfProgramException, GeneralErrorException {
        return VariableName.internalGet(tm, err, blk, pc, true);
    }

    private static VariableName internalGet(TokenManager tm, Errors err, Block blk, Pcc pc, boolean nameCall) throws EndOfProgramException, GeneralErrorException {
        VariableName Return2 = null;
        TokenManager.Marker mk = tm.getMarker();
        tm.setMarker(mk);
        Token tk = tm.getToken();
        boolean isAll = tk.isAll();
        if (tk.getToknum() == 10018) {
            tk = new Token(10009, "SELF", tk.getFLN(), tk.getOffset(), tk.getFileName());
            tm.ungetToken();
        }
        if (tk.getToknum() == 10009 || tk.getToknum() == 259) {
            Function vd;
            Token func;
            Token first = tk;
            boolean lambdaExpr = false;
            Token tk0 = tm.getToken();
            if (first.getWord().startsWith("->")) {
                if (tk0.getToknum() != 10018) {
                    throw new GeneralErrorException(274, 4, first, tk0.getWord(), err);
                }
                first.setWord(first.getWord().substring(2).toUpperCase(Locale.US).replace(Pcc.hyphenRepl, '-'));
                lambdaExpr = true;
            }
            if (tk0.getToknum() == 10018 && pc != null) {
                VariableName vn = new VariableName(tk, tm, err, pc);
                vn.lambdaExpr = lambdaExpr;
                if ("SELF".equals(vn.getName())) {
                    vn.isSelf = true;
                } else if ("SUPER".equals(vn.getName())) {
                    vn.isSuper = true;
                } else {
                    vn.checkObject(pc);
                }
                if (vn.isObjectReference()) {
                    Token methName = new Token(vn.getNameToken());
                    methName.setWord(methName.getWord() + "::");
                    Return2 = new VariableName(methName);
                    Return2.lambdaExpr = lambdaExpr;
                    Return2.error = err;
                    Return2.varDecl = new InlineInvoke(vn, blk, pc, tk, tm, err);
                    Return2.isAll = isAll;
                    return Return2;
                }
            }
            tm.ungetToken();
            if (VariableName.isSpecialName(tk.getWord(), tm) == 1) {
                func = tk;
                vd = new Function(pc, tk, tm, true);
                tk = tm.getToken();
                if (tk.getToknum() == 609) {
                    tk = tm.getToken();
                }
            } else {
                func = null;
                vd = null;
            }
            try {
                Return2 = new VariableName(tk, tm, err, pc);
                if (!Return2.isSpecial) {
                    Return2.function = func;
                    Return2.functionVar = vd;
                }
            }
            catch (MalformedDataNameException e) {
                tm.rewindToMarker(mk);
                throw new MalformedDataNameException(first, err);
            }
            tk = tm.getToken();
            if (tk.getToknum() == 40) {
                TokenManager.Marker mk1 = tm.getMarker();
                tm.setMarker(mk1);
                Subscript s = VariableName.getSubscript(tm, err, pc);
                if (s == null && !nameCall) {
                    throw new MalformedDataNameException(first, err);
                }
                if (s != null) {
                    tk = tm.getToken();
                    if (tk.getToknum() == 58) {
                        Return2.getSubValue(s, tm, err, pc);
                        tk = tm.getToken();
                        if (tk.getToknum() != 41) {
                            throw new MalformedDataNameException(first, err);
                        }
                    } else {
                        if (VariableName.isSpecialName(Return2.name.getWord(), tm) == 2) {
                            throw new GeneralErrorException(80, 4, Return2.name, "", err);
                        }
                        Return2.indexes = new SubscriptList();
                        Return2.indexes.addItem(s);
                        tm.ungetToken();
                        while ((tk = tm.getToken()).getToknum() != 41) {
                            tm.ungetToken();
                            s = VariableName.getSubscript(tm, err, pc);
                            if (s == null) {
                                throw new MalformedDataNameException(first, err);
                            }
                            Return2.indexes.addItem(s);
                        }
                        TokenManager.Marker mkopenpar = tm.getMarker();
                        tm.setMarker(mkopenpar);
                        tk = tm.getToken();
                        if (tk.getToknum() == 40) {
                            s = VariableName.getSubscript(tm, err, pc);
                            if (s == null) {
                                throw new MalformedDataNameException(first, err);
                            }
                            tk = tm.getToken();
                            if (tk.getToknum() == 58) {
                                Return2.getSubValue(s, tm, err, pc);
                                tk = tm.getToken();
                                if (tk.getToknum() != 41) {
                                    throw new MalformedDataNameException(first, err);
                                }
                            } else {
                                tm.rewindToMarker(mkopenpar);
                            }
                        } else {
                            tm.ungetToken();
                        }
                        if (tm.getToken().getToknum() == 10018 && pc != null) {
                            Return2.checkObject(pc);
                            VariableName vn = Return2;
                            Token methName = new Token(vn.getNameToken());
                            methName.setWord(methName.getWord() + "::");
                            Return2 = new VariableName(methName);
                            Return2.error = err;
                            Return2.varDecl = new InlineInvoke(vn, blk, pc, tk, tm, err);
                            Return2.isAll = isAll;
                            return Return2;
                        }
                        tm.ungetToken();
                    }
                } else {
                    tm.rewindToMarker(mk1);
                    tm.ungetToken();
                }
            } else {
                tm.ungetToken();
            }
        } else {
            tm.rewindToMarker(mk);
        }
        if (Return2 != null) {
            Return2.isAll = isAll;
        }
        return Return2;
    }

    public static VariableName getTableItemWithAll(TokenManager tm, Errors err, Pcc pc) throws EndOfProgramException, GeneralErrorException {
        VariableName Return2 = null;
        TokenManager.Marker mk = tm.getMarker();
        tm.setMarker(mk);
        Token tk = tm.getToken();
        if (tk.getToknum() == 10009 && VariableName.isSpecialName(tk.getWord(), tm) == 0) {
            try {
                Return2 = new VariableName(tk, tm, err, pc);
                tk = tm.getToken();
                if (tk.getToknum() == 40) {
                    Subscript s = Subscript.getWithAll(tm, err, pc);
                    if (s == null) {
                        Return2 = null;
                    } else {
                        Return2.indexes = new SubscriptList();
                        Return2.hasAllSubscript |= s.isAll();
                        Return2.indexes.addItem(s);
                        while ((tk = tm.getToken(false)).getToknum() != 41) {
                            tm.ungetToken();
                            s = Subscript.getWithAll(tm, err, pc);
                            if (s == null) {
                                throw new MalformedDataNameException(null, err);
                            }
                            Return2.hasAllSubscript |= s.isAll();
                            Return2.indexes.addItem(s);
                        }
                    }
                } else {
                    Return2 = null;
                }
            }
            catch (MalformedDataNameException e) {
                Return2 = null;
            }
        }
        if (Return2 == null || !Return2.hasAllSubscript) {
            Return2 = null;
            tm.rewindToMarker(mk);
        } else {
            Return2.checkAny(pc, GetVarOpts.NO_OPTS);
        }
        return Return2;
    }

    public VariableName(Token tk) {
        this.name = tk;
        this.pc = null;
    }

    public VariableName(String n) {
        this(new Token(10009, n, 0, 0, "dummy"));
    }

    public VariableName(VariableDeclaration vd) {
        this(new Token(10009, vd.getName(), 0, 0, vd.getNameToken() != null ? vd.getNameToken().getFileName() : "dummy"));
        this.varDecl = vd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VariableName(Token n, final TokenManager t, final Errors err, final Pcc p) throws EndOfProgramException, MalformedDataNameException, GeneralErrorException {
        this.name = n;
        this.error = err;
        this.pc = p;
        switch (VariableName.isSpecialName(n.getWord(), t)) {
            case 2: {
                this.function = n;
                this.varDecl = this.functionVar = new Function(p, n, t, err);
                this.isSpecial = true;
                return;
            }
            case 9: {
                if (p == null) {
                    throw new GeneralErrorException(15, 4, n, n.getWord(), err);
                }
            }
            case 3: {
                this.function = n;
                t.ungetToken();
                this.varDecl = this.functionVar = new Function(p, n, t, err);
                this.isSpecial = true;
                return;
            }
            case 4: {
                Block b;
                if (p == null || (b = p.getCurrentBlock()) == null || !b.isExceptionBlock()) return;
                final String extname = b.getParentExceptName();
                this.varDecl = new VariableDeclaration(t){
                    {
                        super(t2);
                        this.pc = p;
                        this.tm = t;
                        this.error = err;
                        this.setClassName("java.lang.Throwable");
                    }

                    @Override
                    public String getUnivoqueName() {
                        return extname;
                    }
                };
                this.isSpecial = true;
                return;
            }
            case 5: {
                Select sel;
                this.function = n;
                Token tk = t.getToken();
                if (tk.getToknum() == 609) {
                    tk = t.getToken();
                    if (tk.getToknum() != 10009) throw new GeneralErrorException(24, 4, tk, tk.getWord(), err);
                    sel = p.getSelect(tk.getWord());
                } else {
                    t.ungetToken();
                    sel = p.getLinageSelect(n, err);
                }
                if (sel == null) {
                    throw new GeneralErrorException(53, 4, n, n.getWord(), err);
                }
                if (!sel.hasLinage()) {
                    throw new GeneralErrorException(117, 4, n, n.getWord(), err);
                }
                this.varDecl = this.functionVar = new Function(p, new Token(10009, "Factory.getNumLiteral (" + sel.getName() + ".linageCounter(),10,0,false)", n.getFLN(), n.getOffset(), n.getFileName()), t, true);
                this.isSpecial = true;
                return;
            }
            case 6: {
                this.varDecl = this.functionVar = new Function(p, new Token(10009, "Functions.vsCurrentDate()", n.getFLN(), n.getOffset(), n.getFileName()), t, true);
                return;
            }
            case 7: {
                this.varDecl = this.functionVar = new Function(p, new Token(10009, "Functions.vsTimeOfDay()", n.getFLN(), n.getOffset(), n.getFileName()), t, true);
                return;
            }
            case 8: {
                GregorianCalendar now = new GregorianCalendar();
                StringBuffer result = new StringBuffer();
                if (this.pc.getOption("-cr") != null) {
                    int x = now.get(11);
                    if (x < 10) {
                        result.append("0");
                    }
                    result.append(x);
                    result.append(".");
                    x = now.get(12);
                    if (x < 10) {
                        result.append("0");
                    }
                    result.append(x);
                    result.append(".");
                    x = now.get(13);
                    if (x < 10) {
                        result.append("0");
                    }
                    result.append(x);
                    result.append(now.getDisplayName(2, 1, Locale.getDefault()));
                    result.append(" ");
                    x = now.get(5);
                    if (x < 10) {
                        result.append("0");
                    }
                    result.append(x);
                    result.append(", ");
                    x = now.get(1);
                    result.append(x);
                } else {
                    int x = now.get(2) + 1;
                    if (x < 10) {
                        result.append("0");
                    }
                    result.append(x);
                    result.append("/");
                    x = now.get(5);
                    if (x < 10) {
                        result.append("0");
                    }
                    result.append(x);
                    result.append("/");
                    x = now.get(1) % 100;
                    if (x < 10) {
                        result.append("0");
                    }
                    result.append(x);
                    x = now.get(11);
                    if (x < 10) {
                        result.append("0");
                    }
                    result.append(x);
                    result.append(".");
                    x = now.get(12);
                    if (x < 10) {
                        result.append("0");
                    }
                    result.append(x);
                    result.append(".");
                    x = now.get(13);
                    if (x < 10) {
                        result.append("0");
                    }
                    result.append(x);
                }
                this.varDecl = this.functionVar = new Function(p, new Token(10009, "Factory.getStrLiteral(\"" + result + "\")", n.getFLN(), n.getOffset(), n.getFileName()), t, true);
                return;
            }
            case 10: {
                String progName = "";
                if (this.pc instanceof CobolProgram) {
                    progName = ((CobolProgram)this.pc).getCobolProgramName();
                }
                this.varDecl = this.functionVar = new Function(p, new Token(10009, "Factory.getStrLiteral(\"" + progName + "\")", n.getFLN(), n.getOffset(), n.getFileName()), t, true);
                return;
            }
            default: {
                if (p != null && p.isExecMacro(n)) {
                    String trnsltn = p.getExecMacro(n, t);
                    this.varDecl = this.functionVar = new Function(p, new Token(10009, trnsltn, n.getFLN(), n.getOffset(), n.getFileName()), t, true);
                    return;
                }
                Token tk = t.getToken();
                if (tk.getToknum() == 609 || tk.getToknum() == 526) {
                    tk = t.getToken();
                    if (tk.getToknum() == 10009) {
                        this.of = new VariableName(tk, t, err, p);
                        return;
                    }
                    t.ungetToken();
                    t.ungetToken();
                    return;
                }
                t.ungetToken();
            }
        }
    }

    @Override
    public boolean hasSubValue() {
        return this.subValue != null;
    }

    private void getSubValue(Subscript s, TokenManager tm, Errors err, Pcc pc) throws EndOfProgramException, GeneralErrorException {
        this.subValue = new SubValueList();
        this.subValue.addItem(s);
        this.subValue.addItem(VariableName.getSubscript(tm, err, pc));
    }

    private static Subscript getSubscript(TokenManager tm, Errors err, Pcc pc) throws EndOfProgramException, GeneralErrorException {
        Subscript Return2 = null;
        Return2 = Subscript.get(tm, err, pc);
        return Return2;
    }

    @Override
    public String getName() {
        return this.name.getWord();
    }

    @Override
    public Token getNameToken() {
        return this.name;
    }

    void setNameToken(Token tk) {
        this.name = tk;
    }

    public void setOf(VariableName o) {
        this.of = o;
    }

    @Override
    public VariableName getOf() {
        return this.of;
    }

    void associateToVarDeclAny(Pcc pc) throws GeneralErrorException {
        this.associateToVarDeclAny(pc, true, true, GetVarOpts.NO_OPTS);
    }

    void associateToVarDeclAny(Pcc pc, boolean checkDim) throws GeneralErrorException {
        this.associateToVarDeclAny(pc, checkDim, true, GetVarOpts.NO_OPTS);
    }

    public boolean isDeclared(Pcc pc) {
        if (this.varDecl == null) {
            try {
                this.varDecl = pc.getAny(this, false, true);
            }
            catch (GeneralErrorException _ex) {
                return false;
            }
        }
        return this.varDecl != null;
    }

    void associateToVarDeclAny(Pcc pc, boolean ckDim, boolean setUsed, GetVarOpts opts) throws GeneralErrorException {
        if (this.varDecl == null) {
            this.varDecl = pc.getAny(this, ckDim, false, null, false, opts);
        }
        if (this.varDecl == null) {
            throw new UndefinedException(this.getNameToken(), this.error, this.getName());
        }
        this.checkALL();
        if (setUsed) {
            this.varDecl.setUsed();
        }
        if (this.subValue != null) {
            this.varDecl.setAccessedByAddress();
        }
    }

    void associateToVarDeclObj(Pcc pc) throws GeneralErrorException {
        this.associateToVarDeclAny(pc);
    }

    void associateToVarDeclVar(Pcc pc) throws GeneralErrorException {
        this.associateToVarDeclVar(pc, true, true, GetVarOpts.NO_OPTS);
    }

    void associateToVarDeclVar(Pcc pc, boolean ckDim, boolean setUsed, GetVarOpts opts) throws GeneralErrorException {
        this.associateToVarDeclAny(pc, ckDim, setUsed, opts);
        if (this.varDecl != null && !this.varDecl.isCobolVar() && !this.varDecl.isLobLocator()) {
            throw new GeneralErrorException(75, 4, this.name, this.name.getWord(), this.error);
        }
    }

    @Override
    public int getDimension() {
        if (this.indexes != null) {
            return this.indexes.getItemNum();
        }
        return 0;
    }

    @Override
    public VariableDeclaration getVarDecl() {
        if (this.functionVar != null) {
            return this.functionVar;
        }
        return this.varDecl;
    }

    public void setVarDecl(VariableDeclaration vd) {
        this.varDecl = vd;
    }

    @Override
    public boolean hasIndexes() {
        return this.indexes != null;
    }

    @Override
    public SubscriptList getIndexes() {
        return this.indexes;
    }

    public void setIndexes(SubscriptList sl) {
        this.indexes = sl;
    }

    @Override
    public SubValueList getSubValueList() {
        return this.subValue;
    }

    public boolean hasVariableIndex() {
        Subscript s;
        if (this.indexes != null) {
            s = this.indexes.getFirst();
            while (s != null) {
                if (!s.isLiteral()) {
                    return true;
                }
                s = this.indexes.getNext();
            }
        }
        if (this.subValue != null) {
            s = this.subValue.getFirst();
            while (s != null) {
                if (!s.isLiteral()) {
                    return true;
                }
                s = this.subValue.getNext();
            }
        }
        return false;
    }

    public boolean isDeclaredInLinkage() {
        if (this.varDecl != null) {
            return this.varDecl.isInLinkage();
        }
        throw new InternalErrorException("Declaration not found:" + this.getName());
    }

    public String getSubscriptCode() {
        return this.getSubscriptCode(false);
    }

    public String getSubscriptCode(boolean arrayNoClone) {
        if (this.indexes != null) {
            return this.indexes.getCode(this.varDecl.isObjectReference(), this.varDecl.getOccurs() > 0, this.isEdited() && this.isNumeric(), arrayNoClone && !this.varDecl.pc.isFactory() && !this.varDecl.isPic1());
        }
        return "";
    }

    @Override
    public String getCode() {
        VariableDeclaration vd;
        if (this.pc != null && this.pc.registerScreenAttrs && !((vd = this.getVarDecl()) instanceof VariableDeclarationScreen)) {
            String code = this.getCode(false);
            String name = this.pc.screenVars.get(code);
            if (name == null) {
                name = vd != null && vd.getClass() == VariableDeclaration.class ? vd.getDeclUnivoqueName() : "CV";
                name = this.pc.newScreenName(name);
                this.pc.screenVars.put(this.getCode(false), name);
            }
            return "params.getValue(\"" + name + "\")";
        }
        return this.getCode(false);
    }

    public String getCode88() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.varDecl.getCobolClassPrefix());
        Return2.append(this.varDecl.parent.getUnivoqueName());
        Return2.append(this.getSubscriptCode());
        return Return2.toString();
    }

    private void getCodeIndex(StringBuffer code, boolean atNoClone) {
        if (this.hasAllSubscript) {
            code.append(this.indexes.getCodeWithAll());
        } else {
            code.append(this.indexes.getCode(this.varDecl.isObjectReference(), this.varDecl.getOccurs() > 0, this.isEdited() && this.isNumeric(), atNoClone && !this.varDecl.isInDynamic() && !this.varDecl.pc.isFactory() && !this.varDecl.isPic1()));
        }
    }

    public String getCode(boolean atNoClone) {
        return this.getCode(true, atNoClone);
    }

    public String getCode(boolean withIndex, boolean atNoClone) {
        return this.getCode(withIndex, atNoClone, true);
    }

    public String getCode(boolean withIndex, boolean atNoClone, boolean wSubVal) {
        StringBuffer Return2 = new StringBuffer();
        if (this.isSelf || this.isSuper) {
            Pcc rootPcc;
            Pcc pcc = rootPcc = this.varDecl != null ? this.varDecl.pc.getRoot() : null;
            if (this.isSelf) {
                if (rootPcc != null && rootPcc != this.varDecl.pc) {
                    if (this.varDecl.pc.isDefault()) {
                        return "$This$";
                    }
                    return rootPcc.getFullClassName() + ".this";
                }
                return "this";
            }
            if (rootPcc != null && rootPcc != this.varDecl.pc) {
                return rootPcc.getFullClassName() + ".super";
            }
            return "super";
        }
        if (this.varDecl.level == 88) {
            Return2.append(this.varDecl.getCobolClassPrefix());
            Return2.append(this.varDecl.parent.getUnivoqueName());
        } else if (this.isAll) {
            Token tk = new Token(this.varDecl.value);
            tk.setAll(true);
            Return2.append(this.varDecl.tm.getCodeLiteral(tk));
        } else if (this.varDecl.isFactory && !this.varDecl.isLobLocator()) {
            Return2.append("\"" + this.varDecl.getTypeName() + "\"");
        } else {
            Return2.append(this.varDecl.getCobolClassPrefix());
            Return2.append(this.varDecl.getUnivoqueName());
        }
        if (this.varDecl.hasVariableOffset()) {
            Return2.append(this.getByOffset());
        } else if (withIndex && this.indexes != null) {
            this.getCodeIndex(Return2, atNoClone);
        }
        if (this.subValue != null && wSubVal) {
            Return2.append(this.subValue.getCode(this.varDecl.isNational, this.varDecl.isPic1()));
        }
        if (this.function != null && "RECORD-POSITION".equals(this.function.getWord())) {
            Return2.append(".getRecordPosition()");
        }
        return Return2.toString();
    }

    public String toString() {
        if (this.hasSubValue()) {
            return this.getName() + "(:)";
        }
        return this.getName();
    }

    private String getByOffset() {
        StringBuffer Return2 = new StringBuffer(".offs(");
        Return2.append(new OffsetHelper(this.varDecl, this.indexes));
        Return2.append(")");
        return Return2.toString();
    }

    public void checkALL() throws GeneralErrorException {
        Subscript ss;
        if (this.isAll && !this.varDecl.isConstant()) {
            this.isAll = false;
        }
        if (this.subValue != null) {
            int start;
            Token tk;
            boolean rlxdCheck;
            int vLen = this.varDecl.isUsageBit() ? this.varDecl.getLogicLen() : this.varDecl.globalLen(this.varDecl.getOffset());
            ss = this.subValue.getFirst();
            Expression expr = ss.getExpression();
            boolean wrefCheck = this.pc != null && this.pc.getOption("-wref") != null;
            boolean bl = rlxdCheck = this.pc != null && (this.pc.getOption("-cv") != null || this.pc.getOption("-cm") != null);
            if (expr != null) {
                if (!expr.isNumeric()) {
                    throw new GeneralErrorException(49, 4, this.name, expr.toString(), this.error);
                }
                tk = expr.getAsToken();
                if (tk != null && tk.getToknum() == 10002) {
                    start = tk.longValue();
                    if (start < 1) {
                        this.error.print(173, 3, tk, "" + start);
                    }
                    if (wrefCheck) {
                        if (vLen > 0 && start > vLen) {
                            this.error.print(173, 2, tk, tk.getWord());
                        }
                    } else if (!rlxdCheck && vLen > 0 && start > vLen) {
                        this.error.print(173, 3, tk, tk.getWord());
                    }
                } else {
                    start = 1;
                }
            } else {
                start = 1;
            }
            if ((ss = this.subValue.getNext()) != null && (expr = ss.getExpression()) != null) {
                if (!expr.isNumeric()) {
                    throw new GeneralErrorException(49, 4, this.name, expr.toString(), this.error);
                }
                tk = expr.getAsToken();
                if (tk != null && tk.getToknum() == 10002) {
                    int end = tk.longValue();
                    if (end < 1) {
                        this.error.print(173, 3, tk, tk.getWord());
                    }
                    if (wrefCheck) {
                        if (vLen > 0 && start + end > vLen + 1) {
                            this.error.print(173, 2, tk, tk.getWord());
                        }
                    } else if (!rlxdCheck && vLen > 0 && start + end > vLen + 1) {
                        this.error.print(173, 3, tk, tk.getWord());
                    }
                }
            }
        }
        if (this.indexes != null && this.varDecl.dimension > 0) {
            int[] aiMax = new int[this.varDecl.dimension];
            int[] aiMin = new int[this.varDecl.dimension];
            int i = this.varDecl.dimension - 1;
            VariableDeclaration v = this.varDecl;
            while (v != null && i >= 0) {
                if (v.occursMin > 0) {
                    aiMax[i] = v.occursMax;
                    aiMin[i] = v.occursMin;
                    --i;
                }
                v = v.parent;
            }
            ss = this.indexes.getFirst();
            for (i = 0; ss != null && i < this.varDecl.dimension; ++i) {
                if (ss.isLiteral() && ss.getExpression() != null) {
                    Token tk = ss.getExpression().getAsToken();
                    if (tk.getToknum() != 10002) {
                        throw new GeneralErrorException(22, 4, tk, ss.getExpression().toString(), this.error);
                    }
                    int idx = Integer.parseInt(tk.getWord());
                    if (idx < 1) {
                        this.error.print(264, 3, ss.getExpression().getAsToken(), ss.getExpression().toString());
                    } else if (aiMax[i] > 0) {
                        if (idx > aiMax[i]) {
                            this.error.print(264, 3, ss.getExpression().getAsToken(), ss.getExpression().toString());
                        }
                    } else if (aiMin[i] > 0 && idx > aiMin[i]) {
                        this.error.print(264, 3, ss.getExpression().getAsToken(), ss.getExpression().toString());
                    }
                }
                ss = this.indexes.getNext();
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.varDecl != null) {
            this.varDecl.check();
            this.checkALL();
        } else if (this.functionVar != null && this.isAll) {
            this.isAll = false;
        }
    }

    @Override
    public MyClass getCType() throws GeneralErrorException {
        return this.getType();
    }

    public MyClass getType() {
        MyClass Return2;
        try {
            int dme = this.getDimension();
            Return2 = dme > 0 ? MyClass.removeDimension(this.getVarDecl().getType(), dme) : (this.hasSubValue() ? this.pc.existsClass(Pcc.TYPES_PACKAGE + ".PicX") : this.getVarDecl().getType());
        }
        catch (ClassNotFoundException e) {
            try {
                Return2 = MyClass.getInstance(Pcc.TYPES_PACKAGE + ".CobolVar");
            }
            catch (ClassNotFoundException _ex) {
                throw new InternalErrorException("" + _ex);
            }
        }
        return Return2;
    }

    @Override
    public boolean isPrimitive() {
        if (!this.isSelf && !this.isSuper) {
            VariableDeclaration vd = this.getVarDecl();
            if (!vd.isFactory) {
                try {
                    int dme = this.getDimension();
                    MyClass me = dme > 0 ? MyClass.removeDimension(vd.getType(), dme) : vd.getType();
                    return me.isPrimitive();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public boolean isString() {
        if (!this.isSelf && !this.isSuper) {
            VariableDeclaration vd = this.getVarDecl();
            if (!vd.isFactory) {
                try {
                    int dme = this.getDimension();
                    MyClass me = dme > 0 ? MyClass.removeDimension(vd.getType(), dme) : vd.getType();
                    return me.isString();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public boolean isSetGetProperty() {
        return this.varDecl instanceof InlineSetGetProperty;
    }

    @Override
    public boolean isBoolean() {
        if (!this.isSelf && !this.isSuper) {
            VariableDeclaration vd = this.getVarDecl();
            if (!vd.isFactory) {
                try {
                    int dme = this.getDimension();
                    MyClass me = dme > 0 ? MyClass.removeDimension(vd.getType(), dme) : vd.getType();
                    return me.isBoolean();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public boolean isObjectReference() {
        return this.isSelf || this.isSuper || this.getVarDecl().isObjectReference();
    }

    public boolean isStrictPrimitive() {
        MyClass mc = this.getType();
        return mc != null && mc.isStrictPrimitive();
    }

    public boolean isPrimitiveWrapper() {
        MyClass mc = this.getType();
        return mc != null && mc.isPrimitiveWrapper();
    }

    @Override
    public boolean isCobolVar() {
        return this.getVarDecl().isCobolVar();
    }

    @Override
    public boolean isNumericVar() {
        if (this.hasSubValue()) {
            return false;
        }
        return this.getVarDecl().isNumericVar();
    }

    @Override
    public boolean isFactory() {
        if (this.isSelf || this.isSuper) {
            return false;
        }
        return this.getVarDecl().isFactory;
    }

    @Override
    public int getVariableLength() {
        return this.getVariableLength(false);
    }

    int getVariableLength(boolean getRealLen) {
        if (this.varDecl == null) {
            return -1;
        }
        if (this.varDecl.level == 78 && this.varDecl.value != null) {
            return this.varDecl.value.getRealLength();
        }
        int Return2 = this.varDecl.phisicLen;
        if (this.varDecl.isNational || this.varDecl.isPicG()) {
            Return2 /= 2;
        }
        if (this.subValue != null) {
            Subscript left = this.subValue.getFirst();
            Expression expr = left.getExpression();
            if (expr == null || expr.hasOperator || expr.firstToken == null || expr.firstToken.getToknum() != 10002) {
                return -1;
            }
            int l = Integer.parseInt(expr.firstToken.getWord());
            int r = Return2 - l + 1;
            Subscript right = this.subValue.getNext();
            if (right != null && (expr = right.getExpression()) != null) {
                if (!expr.hasOperator && expr.firstToken != null && expr.firstToken.getToknum() == 10002) {
                    r = Integer.parseInt(expr.firstToken.getWord());
                } else {
                    return -1;
                }
            }
            Return2 = getRealLen ? r : Math.min(Return2 - l + 1, r);
        }
        return Return2;
    }

    @Override
    public int getLevel() {
        if (this.isSelf || this.isSuper) {
            return 77;
        }
        VariableDeclaration vd = this.getVarDecl();
        return vd != null ? vd.level : 0;
    }

    @Override
    public boolean isNumeric() {
        if (this.isSelf || this.isSuper) {
            return false;
        }
        if (this.function != null && "RECORD-POSITION".equals(this.function.getWord())) {
            return true;
        }
        if (this.subValue != null) {
            return false;
        }
        return this.getVarDecl().isNumeric();
    }

    @Override
    public boolean isInteger() {
        if (this.isSelf || this.isSuper) {
            return false;
        }
        return this.subValue == null && this.getVarDecl().isInteger();
    }

    @Override
    public boolean isEdited() {
        if (this.isSelf || this.isSuper) {
            return false;
        }
        return this.getVarDecl().isEdited();
    }

    @Override
    public boolean isSelf() {
        return this.isSelf;
    }

    @Override
    public boolean isSuper() {
        return this.isSuper;
    }

    @Override
    public boolean isFunction() {
        return this.varDecl instanceof Function;
    }

    @Override
    public boolean isMethod() {
        return this.varDecl instanceof InlineInvoke;
    }

    @Override
    public boolean isUsageDisplay() {
        return this.getVarDecl().isUsageDisplay() || this.hasSubValue();
    }

    @Override
    public boolean isUniversal() {
        return this.getVarDecl().isUniversal();
    }

    public boolean isRecordPosition() {
        return this.function != null && "RECORD-POSITION".equals(this.function.getWord());
    }

    public boolean isAssignableTo(VariableName vn) {
        try {
            int dme = this.getDimension();
            int dhe = vn.getDimension();
            VariableDeclaration vdme = this.getVarDecl();
            if (vdme.isObjectReference() && vdme.getOccurs() > 0) {
                --dme;
            }
            VariableDeclaration vdhe = vn.getVarDecl();
            MyClass me = dme > 0 ? MyClass.removeDimension(vdme.getType(), dme) : vdme.getType();
            if (vdhe.isObjectReference() && vdhe.getOccurs() > 0) {
                --dhe;
            }
            MyClass he = dhe > 0 ? MyClass.removeDimension(vdhe.getType(), dhe) : vdhe.getType();
            return me.isAssignableTo(he);
        }
        catch (ClassNotFoundException _ex) {
            return false;
        }
    }

    @Override
    public VariableName getVariableName() {
        return this;
    }

    @Override
    public Token getFunction() {
        return this.function;
    }

    @Override
    public boolean isRounded() {
        return this.rounded;
    }

    public void setAll(boolean b) {
        this.isAll = b;
    }

    @Override
    public boolean isAll() {
        return this.isAll;
    }

    final boolean isNotXOptimizable(boolean onlyX) {
        return this.getVarDecl().isNotXOptimizable(onlyX);
    }

    public void getCodeOffset(StringBuffer code, int adj) {
        this.getCodeOffset(code, adj, false);
    }

    public void getCodeOffset(StringBuffer code, int adj, boolean for88) {
        VariableDeclaration vd = this.getVarDecl();
        if (for88) {
            vd = vd.getParent();
        }
        if (vd.isInLinkage() || vd.hasVariableOffset() || this.indexes != null) {
            if (this.indexes != null) {
                code.append(this.getCode(false, false, this.subValue == null));
                code.append(".getOffset");
                this.indexes.getCodeNum(code);
            } else {
                code.append(this.getCode(false, false, this.subValue == null));
                code.append(".getOffset()");
            }
            if (adj != 0) {
                code.append("+");
                code.append(adj);
            }
        } else {
            code.append(vd.getOffset() + adj);
        }
        if (this.subValue != null) {
            code.append("+");
            code.append(this.subValue.getOffset());
            code.append("-1");
        }
    }

    public boolean getSubstringLen(StringBuffer code, int adj) {
        String len = this.subValue.getLen();
        if (len.length() == 0) {
            return false;
        }
        code.append(this.subValue.getLen());
        return true;
    }

    public void getSubstringOffs(StringBuffer code, int adj) {
        code.append(this.subValue.getOffset());
    }

    public void setSqlCallMode(String s) {
        this.sqlCallMode = s;
    }

    public String getSqlCallMode() {
        return this.sqlCallMode;
    }

    protected void setPropTypeSet() throws GeneralErrorException {
        if (this.varDecl instanceof InlineSetGetProperty) {
            InlineSetGetProperty prop = (InlineSetGetProperty)this.varDecl;
            if (prop.getPropType() == 0) {
                throw new GeneralErrorException(59, 4, this.getNameToken(), this.getName(), this.error);
            }
            prop.setPropType(1);
        }
    }

    protected void setPropTypeGet() throws GeneralErrorException {
        if (this.varDecl instanceof InlineSetGetProperty) {
            InlineSetGetProperty prop = (InlineSetGetProperty)this.varDecl;
            if (prop.getPropType() == 1) {
                throw new GeneralErrorException(241, 4, this.getNameToken(), this.getName(), this.error);
            }
            prop.setPropType(0);
        }
    }

    protected void checkPropTypeSetGet() throws GeneralErrorException {
        InlineSetGetProperty prop;
        if (this.varDecl instanceof InlineSetGetProperty && (prop = (InlineSetGetProperty)this.varDecl).getPropType() != 2) {
            throw new GeneralErrorException(241, 4, this.getNameToken(), this.getName(), this.error);
        }
    }

    @Override
    public String getNameIde() {
        if (this.indexes != null) {
            return this.getName() + this.indexes.getCodeIde();
        }
        return this.getName();
    }

    public boolean isVariableLengthGroup() {
        return !this.hasSubValue() && this.getVarDecl().isVariableLengthGroup();
    }

    public boolean isLambdaExpression() {
        return this.lambdaExpr;
    }

    public void setSqlj(String s) {
        this.sqljName = s;
    }

    public void setSqljParam(String s) {
        this.sqljNameParam = s;
    }

    public String getSqljName() {
        return this.sqljName;
    }

    public String getSqljNameParam() {
        return this.sqljNameParam;
    }

    static {
        specialNames.put("RECORD-POSITION", 1);
        specialNames.put("FUNCTION", 2);
        specialNames.put("LENGTH OF", 3);
        specialNames.put("EXCEPTION-OBJECT", 4);
        specialNames.put("LINAGE-COUNTER", 5);
        specialNames.put("CURRENT-DATE", 6);
        specialNames.put("TIME-OF-DAY", 7);
        specialNames.put("WHEN-COMPILED", 8);
        specialNames.put("ADDRESS OF", 9);
        specialNames.put("PROGRAM-ID", 10);
        specialNames.put("ADDRESS", 9);
    }
}

