/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.EndTry;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import java.util.Vector;

public class Try
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Block tryBlock;
    private Vector catchClass = new Vector();
    private Vector catchBlocks = new Vector();
    private Block finallyBlock;
    private Block lastExBlock;
    private BlockException defException;

    public Try(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk;
        this.tryBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
        while ((tk = this.tm.getToken()).getToknum() == 315) {
            this.doCatch();
        }
        if (this.lastExBlock == null) {
            throw new ExpectedFoundException(tk, this.error, "'CATCH'");
        }
        this.tm.ungetToken();
        tk = this.tm.getToken();
        if (tk.getToknum() == 488) {
            this.finallyBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
        } else {
            this.tm.ungetToken();
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 451) {
            throw new ExpectedFoundException(tk, this.error, "'END-TRY'");
        }
        this.lastExBlock.verbs.addItem(new EndTry(tk, this.lastExBlock, this.pc, this.tm, this.error, this.catchBlocks));
    }

    void doCatch() throws GeneralErrorException, EndOfProgramException {
        if (this.tm.getToken().getToknum() == 472) {
            if (this.defException != null) {
                throw new GeneralErrorException(131, 4, this.keyWord, "EXCEPTION", this.error);
            }
            this.defException = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, MyClass.getInstance(Exception.class));
            this.lastExBlock = this.defException;
            this.tryBlock.setCatchBlock(this.defException);
        } else {
            this.tm.ungetToken();
            if (this.defException != null) {
                throw new GeneralErrorException(133, 4, this.keyWord, "", this.error);
            }
            VariableName nameObj = VariableName.getObject(this.tm, this.error, this.parent, this.pc);
            if (nameObj != null) {
                this.catchClass.addElement(nameObj);
                BlockException be = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, nameObj.getType());
                this.lastExBlock = be;
                this.tryBlock.setCatchBlock(be);
                this.catchBlocks.addElement(be);
            } else {
                throw new UnexpectedTokenException(this.tm.getToken(), this.error);
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        int nCatch = this.catchClass.size();
        MyClass lastException = null;
        for (int i = 0; i < nCatch; ++i) {
            VariableName nameObj = (VariableName)this.catchClass.elementAt(i);
            if (lastException != null && lastException.isAssignableFrom(nameObj.getType())) {
                throw new GeneralErrorException(131, 4, this.keyWord, nameObj.getType().getName(), this.error);
            }
            lastException = nameObj.getType();
            for (int j = i + 1; j < nCatch; ++j) {
                if (!nameObj.getType().equals(((VariableName)this.catchClass.elementAt(j)).getType())) continue;
                throw new GeneralErrorException(131, 4, this.keyWord, nameObj.getType().getName(), this.error);
            }
            if (nameObj.getType().isAssignableTo(Throwable.class) && nameObj.getVarDecl().isFactory) continue;
            throw new GeneralErrorException(75, 4, this.keyWord, nameObj.getType().getName(), this.error);
        }
        if (this.defException != null) {
            MyClass excpt = MyClass.getInstance(Exception.class);
            for (int i = 0; i < nCatch; ++i) {
                if (!excpt.equals(((VariableName)this.catchClass.elementAt(i)).getType())) continue;
                throw new GeneralErrorException(131, 4, this.keyWord, excpt.getName(), this.error);
            }
        }
    }

    @Override
    public String getCode() {
        String indent = this.parent.getIndent();
        StringBuffer Return2 = new StringBuffer();
        Return2.append(indent);
        Return2.append("try ");
        Return2.append(eol);
        Return2.append(this.tryBlock.getCode());
        for (int i = 0; i < this.catchBlocks.size(); ++i) {
            VariableName nameObj = (VariableName)this.catchClass.elementAt(i);
            Return2.append(" catch (");
            Return2.append(nameObj.getType().getName());
            Return2.append(" ");
            Return2.append(this.parent.getExceptName());
            Return2.append(")");
            Return2.append(eol);
            Return2.append(((Block)this.catchBlocks.elementAt(i)).getCode());
        }
        if (this.defException != null) {
            Return2.append(" catch (java.lang.Exception ");
            Return2.append(this.parent.getExceptName());
            Return2.append(")");
            Return2.append(eol);
            Return2.append(this.defException.getCode());
        }
        if (this.finallyBlock != null) {
            Return2.append(" finally ");
            Return2.append(this.finallyBlock.getCode());
            Return2.append(eol);
        }
        Return2.append(eol);
        return Return2.toString();
    }

    public Vector getCatchClasses() {
        return this.catchClass;
    }

    public Vector getCatchBlocks() {
        return this.catchBlocks;
    }

    public Block getFinallyBlock() {
        return this.finallyBlock;
    }

    public Block getTryBlock() {
        return this.tryBlock;
    }

    public boolean hasDefaultException() {
        return this.defException != null;
    }
}

