/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Exec;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VerbList;
import com.iscobol.interfaces.compiler.IDataSection;

public abstract class StorageSection
implements CobolToken,
ErrorsNumbers,
IDataSection {
    TokenManager tm;
    Errors error;
    Pcc pc;
    VariableDeclarationList vars = new VariableDeclarationList();
    int memoryOffset = 0;
    final boolean memIn1block;
    final boolean optionXMS;
    final boolean optionXMSN;
    final byte defaultByte;
    final int align;
    Token firstToken;
    Token lastToken;
    private VerbList execList = new VerbList();

    public StorageSection(Pcc p, TokenManager t, Errors err, Token tk) throws GeneralErrorException, EndOfProgramException {
        int algn;
        this.firstToken = tk;
        this.pc = p;
        this.error = err;
        this.tm = t;
        this.memIn1block = this.pc.getOption("-m1") != null && p.getRoot() instanceof CobolProgram;
        this.optionXMS = this.pc.getOption("-xms") != null;
        this.optionXMSN = this.pc.getOption("-xmsn") != null;
        try {
            algn = Integer.parseInt(this.pc.getOption("-align="));
            if (algn < 1) {
                algn = 1;
            }
        }
        catch (NumberFormatException _ex) {
            algn = 1;
        }
        this.align = algn;
        this.defaultByte = VariableDeclaration.getDefaultByte(this.pc.getOptions(), false, true);
    }

    void getCodeHeader(StringBuffer Return2) {
    }

    public String getCode(StringBuffer dynPart) {
        StringBuffer Return2 = new StringBuffer();
        this.getCodeHeader(Return2);
        if (this.memIn1block) {
            if (this.optionXMS) {
                if (this.optionXMSN) {
                    Return2.append("   public Memory wsMem=Factory.getNotOptmzdMem(");
                } else {
                    Return2.append("   public Memory wsMem = Factory.getMem (");
                }
            } else {
                Return2.append("   public byte wsMem[] = Factory.getMem (");
            }
            Return2.append(this.memoryOffset);
            if (this.defaultByte != 32) {
                Return2.append(", (byte)");
                Return2.append(this.defaultByte);
            }
            Return2.append(");" + eol);
            Return2.append(eol);
        }
        VariableDeclaration v = this.vars.getFirst();
        while (v != null) {
            Return2.append(v.getCode(dynPart));
            v = this.vars.getNext();
        }
        Exec e = (Exec)this.execList.getFirst();
        while (e != null) {
            e.getCode(dynPart);
            e = (Exec)this.execList.getNext();
        }
        return Return2.toString();
    }

    @Override
    public final VariableDeclarationList getVariableDeclarationList() {
        return this.vars;
    }

    @Override
    public final Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public final Token getLastToken() {
        return this.lastToken;
    }

    protected void exec(Token tk) throws GeneralErrorException, EndOfProgramException {
        try {
            this.execList.addItem(new Exec(tk, null, this.pc, this.tm, this.error));
        }
        catch (GeneralErrorException generalErrorException) {
            // empty catch block
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 10006) {
            this.tm.ungetToken();
        }
    }

    public VerbList getExecList() {
        return this.execList;
    }

    static int calcAlign(int pnt, int size) {
        return size - pnt % size & size - 1;
    }
}

