/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;

public class SqlDeclareVar
extends SqlStatement {
    static final int SQL_TYPE_NOBIN = 0;
    static final int SQL_TYPE_BINARY = 1;
    VariableName var;
    int sqlType = 0;
    String ccsid = "";
    VariableName ccsidVar = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlDeclareVar(ExecSql es, Token kw, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(es, kw, null, p, t, err, false);
        Token tk = this.tm.getToken();
        if (tk == null || tk.getToknum() != 10009) return;
        this.ungetSqlToken();
        this.var = VariableName.get(this.tm, this.error, this.pc);
        tk = this.getSqlToken();
        if (tk == null || !tk.getWord().equalsIgnoreCase("VARIABLE")) throw new GeneralErrorException(31, 4, tk, "VARIABLE/" + tk.getWord(), this.error);
        tk = this.getSqlToken();
        if (tk != null && tk.getWord().equalsIgnoreCase("FOR")) {
            tk = this.getSqlToken();
            if (tk == null || !tk.getWord().equalsIgnoreCase("BIT")) throw new GeneralErrorException(31, 4, tk, "BIT/" + tk.getWord(), this.error);
            tk = this.getSqlToken();
            if (tk == null || !tk.getWord().equalsIgnoreCase("DATA")) throw new GeneralErrorException(31, 4, tk, "DATA/" + tk.getWord(), this.error);
            this.sqlType = 1;
            return;
        } else {
            if (!tk.getWord().equalsIgnoreCase("CCSID")) throw new GeneralErrorException(31, 4, tk, "FOR or CCSID/" + tk.getWord(), this.error);
            tk = this.getSqlToken();
            if (tk.getToknum() == 58) {
                this.ccsidVar = this.getHostVariable(false, true);
                return;
            } else {
                this.ccsid = tk.getWord();
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        if (this.sqlType == 1) {
            Return2.append(this.var.getName().replace('-', Pcc.hyphenRepl) + ".setSqlBinary();" + eol);
        }
        return Return2.toString();
    }
}

