/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolClass;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.DuplicateParagraph;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GeneralErrorInfo;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import java.util.Vector;

public class LabelName
implements CobolToken,
ErrorsNumbers {
    private final TokenManager tm;
    private final Pcc pc;
    private final Errors error;
    private boolean isInDeclaratives;
    private Token name;
    private Token of;
    private TokenManager.Marker mk;
    private int parIdNumber;
    private Paragraph pargrf;
    private Paragraph foundIn;
    private CobolMethod method;

    public static LabelName get(Block par, TokenManager t, Errors err, Pcc p) throws EndOfProgramException, GeneralErrorException {
        LabelName Return2 = new LabelName(par, t, err, p);
        if (!Return2.isValid()) {
            Return2 = null;
        }
        return Return2;
    }

    private LabelName(Block par, TokenManager t, Errors err, Pcc p) throws EndOfProgramException, GeneralErrorException {
        if (par != null) {
            this.foundIn = par.parent;
        }
        this.tm = t;
        this.pc = p;
        this.isInDeclaratives = this.pc.inDeclaratives;
        this.error = err;
        this.mk = this.tm.getMarker();
        this.tm.setMarker(this.mk);
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 10009 || tk.getToknum() == 10002) {
            this.name = tk;
            tk = this.tm.getToken();
            if (tk.getToknum() == 609 || tk.getToknum() == 526) {
                tk = this.tm.getToken();
                switch (tk.getToknum()) {
                    case 10001: {
                        if (!(this.pc instanceof CobolClass) || "\"new\"".equals(tk.getWord())) {
                            this.name = null;
                            this.rewind();
                            break;
                        }
                    }
                    case 10002: 
                    case 10009: {
                        this.of = tk;
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 609 || tk.getToknum() == 526) {
                            this.name = null;
                            this.rewind();
                            break;
                        }
                        this.tm.ungetToken();
                        break;
                    }
                    default: {
                        this.name = null;
                        this.rewind();
                        break;
                    }
                }
            } else {
                this.tm.ungetToken();
            }
        } else {
            this.rewind();
        }
    }

    boolean isValid() {
        return this.name != null;
    }

    void rewind() {
        if (this.mk != null) {
            this.tm.rewindToMarker(this.mk);
            this.mk = null;
        }
    }

    public Token getName() {
        return this.name;
    }

    public void removeTokens() {
        if (this.mk != null) {
            this.tm.removeToMarker(this.mk);
            this.mk = null;
        }
    }

    public void setFoundIn(Paragraph p) {
        this.foundIn = p;
    }

    public void check() throws GeneralErrorException {
        GeneralErrorInfo gi = this.check(this.isInDeclaratives);
        if (gi != null) {
            throw new GeneralErrorException(gi);
        }
    }

    GeneralErrorInfo check(boolean inDecl) {
        if (this.of != null) {
            if (this.of.getToknum() == 10001) {
                CobolMethod m;
                CobolMethod[] mts = this.pc.parent.getMethods();
                Vector<CobolMethod> found = new Vector<CobolMethod>();
                String methodName = this.of.getWord().substring(1, this.of.getWord().length() - 1);
                for (CobolMethod m2 : mts) {
                    if (!m2.getMethodName().equals(methodName)) continue;
                    found.addElement(m2);
                }
                switch (found.size()) {
                    case 0: {
                        return new GeneralErrorInfo(77, 4, this.of, this.of.getWord(), this.error);
                    }
                    case 1: {
                        MyClass[] pts = ((CobolMethod)found.elementAt(0)).getParameterTypes();
                        if (pts == null || pts.length <= 0) break;
                        return new GeneralErrorInfo(83, 4, this.of, this.of.getWord() + " must be without parameters", this.error);
                    }
                    default: {
                        MyClass[] pts;
                        int i = 0;
                        while (i < found.size()) {
                            pts = ((CobolMethod)found.elementAt(i)).getParameterTypes();
                            if (pts != null && pts.length > 0) {
                                found.remove(i);
                                continue;
                            }
                            ++i;
                        }
                        if (found.size() > 1) {
                            return new GeneralErrorInfo(145, 4, this.of, this.of.getWord(), this.error);
                        }
                        if (found.size() != 0) break;
                        return new GeneralErrorInfo(83, 4, this.of, this.of.getWord() + " must be without parameters", this.error);
                    }
                }
                if (!(m = (CobolMethod)found.elementAt(0)).isFactory() && this.pc.isFactory()) {
                    return new GeneralErrorInfo(84, 4, this.of, this.of.getWord(), this.error);
                }
                this.pargrf = m.getParagraph(this.name.getWord(), null);
                if (this.pargrf == null) {
                    return new GeneralErrorInfo(105, 4, this.name, this.toString(), this.error);
                }
                if (this.pargrf instanceof DuplicateParagraph) {
                    return new GeneralErrorInfo(67, 4, this.name, this.name.getWord(), this.error);
                }
                this.method = m;
            } else {
                this.pargrf = this.pc.getParagraph(this.name.getWord(), this.of.getWord(), inDecl);
            }
        } else {
            this.pargrf = this.pc.getParagraph(this.name.getWord(), this.foundIn, inDecl);
        }
        if (this.pargrf == null) {
            return new GeneralErrorInfo(105, 4, this.name, this.toString(), this.error);
        }
        if (this.pargrf instanceof DuplicateParagraph) {
            return new GeneralErrorInfo(67, 4, this.name, this.name.getWord(), this.error);
        }
        this.isInDeclaratives = inDecl;
        this.parIdNumber = this.pargrf.getIdNumber();
        return null;
    }

    public Paragraph getParagraph() {
        return this.pargrf;
    }

    public int getParIdNumber() {
        return this.parIdNumber;
    }

    public String toString() {
        if (this.of != null) {
            return this.name.getWord() + " OF " + this.of.getWord();
        }
        return this.name.getWord();
    }

    public boolean isInDeclaratives() {
        return this.isInDeclaratives;
    }

    public CobolMethod getMethod() {
        return this.method;
    }
}

